/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.gui.SplashWindow;

class AnimationThread
extends Thread {
    private SplashWindow splash;
    private int cycle;
    private int progress;
    private final String initializing = "Initializing";
    private final String constructing = "Constructing GUI";
    private final String fetching = "Downloading Data";
    private final String connecting = "Connecting to Server";

    public AnimationThread(SplashWindow s) {
        this.splash = s;
        this.progress = 0;
        this.cycle = 0;
    }

    private void setLabelText(String s) {
        this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "</b></CENTER></HTML>");
        this.splash.getProgressBar().setValue(this.progress);
    }

    public synchronized void run() {
        while (this.splash.shouldAnimate()) {
            try {
                int currStatus;
                this.wait(150L);
                ++this.cycle;
                if (this.cycle == 4) {
                    this.cycle = 0;
                }
                if ((currStatus = this.splash.getStatus()) == this.splash.STATUS_DATAERROR || currStatus == this.splash.STATUS_INPUTWAIT || currStatus == this.splash.STATUS_CONNECTFAILED) {
                    --this.cycle;
                } else if (this.cycle == 0) {
                    ++this.progress;
                    if (this.progress == 10) {
                        this.progress = 0;
                    }
                }
                if (currStatus == this.splash.STATUS_INITIALIZING) {
                    this.setLabelText("Initializing");
                } else if (currStatus == this.splash.STATUS_FETCHINGDATA) {
                    this.setLabelText("Downloading Data");
                } else if (currStatus == this.splash.STATUS_CONSTRUCTINGGUI) {
                    this.setLabelText("Constructing GUI");
                } else if (currStatus == this.splash.STATUS_CONNECTING) {
                    this.setLabelText("Connecting to Server");
                } else if (currStatus == this.splash.STATUS_INPUTWAIT) {
                    this.splash.getImageLabel().setText("<HTML><CENTER><b>Connecting to Server<br>[Waiting for Input]</b></CENTER></HTML>");
                } else if (currStatus == this.splash.STATUS_DATAERROR) {
                    this.splash.getImageLabel().setText("<HTML><CENTER><b>Downloading Data<br>[Data Access Error]</b></CENTER></HTML>");
                } else if (currStatus == this.splash.STATUS_CONNECTFAILED) {
                    this.splash.getImageLabel().setText("<HTML><CENTER><b>Connecting to Server<br>[Connection Failed]</b></CENTER></HTML>");
                }
                if (this.splash.shouldAnimate()) continue;
                return;
            }
            catch (Exception e) {
                this.splash.getImageLabel().setText("Error in animation thread!");
                return;
            }
        }
    }
}

