/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CArmy;
import client.gui.AttackMenu;
import client.gui.CMainFrame;
import client.gui.CMapPanel;
import client.gui.dialog.PlanetSearchDialog;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import common.CampaignData;
import common.House;
import common.Influences;
import common.Planet;
import common.util.MMNetXStream;
import common.util.Position;
import common.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerStellarMap
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener {
    private static final long serialVersionUID = 8655078955521790260L;
    InnerStellarMapConfig conf = new InnerStellarMapConfig();
    private CMapPanel mp;
    private MWClient mwclient;
    private IconProvider iconCache = new IconProvider();
    private Planet selectedPlanet = null;
    ArrayList<ArrayList<Position>> overlayLines = new ArrayList();
    private static final String[] displayStr = new String[]{"Planet Names", "Planet Control", "Factories", "Warehouses", "Attack Ranges", "Recent Changes", "Overlay", "Tooltips"};
    private static final int DISPLAY_NAMES = 0;
    private static final int DISPLAY_INFLUENCE = 1;
    private static final int DISPLAY_UNITS = 2;
    private static final int DISPLAY_WAREHOUSES = 3;
    private static final int DISPLAY_RANGES = 4;
    private static final int DISPLAY_LAST_CHANGED = 5;
    private static final int DISPLAY_OVERLAY = 6;
    private static final int DISPLAY_TOOLTIPS = 7;
    private JCheckBoxMenuItem[] display = new JCheckBoxMenuItem[displayStr.length];
    private static final String[] filterStr = new String[]{"All", "", "Factories", "Facilities", "Faction", "Disputed", "Contested"};
    boolean[] filterSettings = new boolean[]{true, false, true, true, true, true, true};
    private static final int FILTER_ALL = 0;
    private static final int FILTER_SEP = 1;
    private static final int FILTER_FACTORIES = 2;
    private static final int FILTER_FACILITIES = 3;
    private static final int FILTER_FACTION = 4;
    private static final int FILTER_DISPUTED = 5;
    private static final int FILTER_CONTESTED = 6;
    private JCheckBoxMenuItem[] filter = new JCheckBoxMenuItem[filterStr.length];
    private Map<Integer, Influences> changesSinceLastRefresh;
    private boolean blinkPhase = false;
    Point lastMousePos = null;
    int mouseMod = 0;

    public CMapPanel getMapPanel() {
        return this.mp;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            final Planet p = this.nearestNeighbour(this.scr2mapX(e.getX()), this.scr2mapY(e.getY()));
            if (p != null) {
                this.activate(p);
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem info = new JMenuItem("Information");
            info.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (Boolean.parseBoolean(InnerStellarMap.this.mwclient.getserverConfigs("UseStaticMaps"))) {
                        House h = InnerStellarMap.this.mwclient.getData().getHouseByName(InnerStellarMap.this.mp.getPPanel().getPlanet().getOriginalOwner());
                        String color = InnerStellarMap.this.mwclient.getserverConfigs("DisputedPlanetColor");
                        String name = "None";
                        if (h != null) {
                            color = h.getHouseColor();
                            name = h.getName();
                        }
                        JEditorPane label = new JEditorPane("text/html", "<html>" + InnerStellarMap.this.mp.getPPanel().getPlanet().getAdvanceDescription(InnerStellarMap.this.mwclient.getUser(InnerStellarMap.this.mwclient.getUsername()).getUserlevel()) + "<b>Original Owner:</b><br><font color=" + color + ">" + name + "</font>" + "</html>");
                        label.setEditable(false);
                        label.setCaretPosition(0);
                        label.setPreferredSize(new Dimension(500, 400));
                        JOptionPane.showMessageDialog(InnerStellarMap.this, new JScrollPane(label), "Information for " + InnerStellarMap.this.mp.getPPanel().getPlanet().getName(), 1);
                    } else {
                        House h = InnerStellarMap.this.mwclient.getData().getHouseByName(InnerStellarMap.this.mp.getPPanel().getPlanet().getOriginalOwner());
                        String color = InnerStellarMap.this.mwclient.getserverConfigs("DisputedPlanetColor");
                        String name = "None";
                        if (h != null) {
                            color = h.getHouseColor();
                            name = h.getName();
                        }
                        JEditorPane label = new JEditorPane("text/html", "<html>" + InnerStellarMap.this.mp.getPPanel().getPlanet().getLongDescription(true) + "<b>Original Owner:</b><br><font color=" + color + ">" + name + "</font>" + "</html>");
                        label.setEditable(false);
                        label.setCaretPosition(0);
                        label.setPreferredSize(new Dimension(500, 400));
                        JOptionPane.showMessageDialog(InnerStellarMap.this, new JScrollPane(label), "Information for " + InnerStellarMap.this.mp.getPPanel().getPlanet().getName(), 1);
                    }
                }
            });
            popup.add(info);
            if (p != null) {
                AttackMenu aMenu = new AttackMenu(this.mwclient, -1, p.getName());
                aMenu.updateMenuItems(false);
                popup.add(aMenu);
            }
            popup.addSeparator();
            JMenuItem search = new JMenuItem("Find Planet");
            search.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    InnerStellarMap.this.createPlanetSearchDialog();
                }
            });
            popup.add(search);
            JMenu centerM = new JMenu("Center Map");
            JMenuItem item = new JMenuItem("On Selected Planet");
            if (p != null) {
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        InnerStellarMap.this.conf.offset.setLocation(-p.getPosition().x * InnerStellarMap.this.conf.scale, p.getPosition().y * InnerStellarMap.this.conf.scale);
                        InnerStellarMap.this.mp.repaint();
                    }
                });
                centerM.add(item);
            }
            item = new JMenuItem("On Natural Center");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    InnerStellarMap.this.conf.offset = new Point();
                    InnerStellarMap.this.conf.scale = 1.0;
                    InnerStellarMap.this.mp.getSlider().setValue((int)Math.round(50.0 / InnerStellarMap.this.conf.scale));
                    InnerStellarMap.this.mp.repaint();
                }
            });
            centerM.add(item);
            popup.add(centerM);
            JMenu displayMenu = new JMenu("Display");
            popup.add(displayMenu);
            for (int i = 0; i < displayStr.length; ++i) {
                displayMenu.add(this.display[i]);
            }
            JMenu filterMenu = new JMenu("Filter");
            popup.add(filterMenu);
            for (int i = 0; i < filterStr.length; ++i) {
                if (i == 1) {
                    filterMenu.addSeparator();
                    continue;
                }
                filterMenu.add(this.filter[i]);
            }
            if (this.mwclient.isLeader() && this.mwclient.getUserLevel() >= this.mwclient.getData().getAccessLevel("PurchaseFactory")) {
                item = new JMenuItem("Purchase Factory");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        InnerStellarMap.this.mwclient.getMainFrame().jMenuLeaderPurchaseFactory_actionPerformed(p == null ? null : p.getName());
                    }
                });
                popup.add(item);
            }
            popup.addSeparator();
            item = new JMenuItem("Refresh");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    InnerStellarMap.this.changesSinceLastRefresh.clear();
                    InnerStellarMap.this.mwclient.refreshData();
                    InnerStellarMap.this.mp.repaint();
                }
            });
            popup.add(item);
            if (this.mwclient.isMod()) {
                try {
                    File loadJar = new File("./MekWarsAdmin.jar");
                    if (!loadJar.exists()) {
                        CampaignData.mwlog.errLog("AdminMapPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                    } else {
                        URLClassLoader loader = new URLClassLoader(new URL[]{loadJar.toURI().toURL()});
                        Class<?> c = loader.loadClass("admin.AdminMapPopupMenu");
                        Object o = c.newInstance();
                        c.getDeclaredMethod("createMenu", MWClient.class, InnerStellarMap.class, Integer.class, Integer.class, Planet.class).invoke(o, this.mwclient, this, new Integer((int)this.scr2mapX(e.getX())), new Integer((int)this.scr2mapY(e.getY())), this.mp.getPPanel().getPlanet());
                        popup.add((JMenu)o);
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("AdminMapPopupMenu creation FAILED!");
                    CampaignData.mwlog.errLog(ex);
                }
            }
            popup.show(this, e.getX() + 10, e.getY() + 10);
        } else if (e.getButton() == 1 && e.getClickCount() >= 2) {
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseStaticMaps"))) {
                House h = this.mwclient.getData().getHouseByName(this.mp.getPPanel().getPlanet().getOriginalOwner());
                String color = this.mwclient.getserverConfigs("DisputedPlanetColor");
                String name = "None";
                if (h != null) {
                    color = h.getHouseColor();
                    name = h.getName();
                }
                JEditorPane label = new JEditorPane("text/html", "<html>" + this.mp.getPPanel().getPlanet().getAdvanceDescription(this.mwclient.getUser(this.mwclient.getUsername()).getUserlevel()) + "<b>Original Owner:</b><br><font color=" + color + ">" + name + "</font>" + "</html>");
                label.setEditable(false);
                label.setCaretPosition(0);
                label.setPreferredSize(new Dimension(500, 400));
                JOptionPane.showMessageDialog(this, new JScrollPane(label), "Information for " + this.mp.getPPanel().getPlanet().getName(), 1);
            } else {
                House h = this.mwclient.getData().getHouseByName(this.mp.getPPanel().getPlanet().getOriginalOwner());
                String color = this.mwclient.getserverConfigs("DisputedPlanetColor");
                String name = "None";
                if (h != null) {
                    color = h.getHouseColor();
                    name = h.getName();
                }
                JEditorPane label = new JEditorPane("text/html", "<html>" + this.mp.getPPanel().getPlanet().getLongDescription(true) + "<b>Original Owner:</b><br><font color=" + color + ">" + name + "</font>" + "</html>");
                label.setEditable(false);
                label.setCaretPosition(0);
                label.setPreferredSize(new Dimension(500, 400));
                JOptionPane.showMessageDialog(this, new JScrollPane(label), "Information for " + this.mp.getPPanel().getPlanet().getName(), 1);
            }
        }
    }

    InnerStellarMap(CMapPanel panel, MWClient client, CMainFrame mainFrame) {
        Planet currPlan;
        double storedValue;
        this.mwclient = client;
        this.setBackground(Color.BLACK);
        this.mp = panel;
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        try {
            File dir = new File(client.getCacheDir());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.conf = (InnerStellarMapConfig)xml.fromXML(new FileReader(client.getCacheDir() + "/mapconf.xml"));
            if (this.conf.display.length != displayStr.length) {
                throw new RuntimeException("not my file");
            }
        }
        catch (Throwable e) {
            if (!(e instanceof FileNotFoundException)) {
                CampaignData.mwlog.errLog((Exception)e);
            }
            CampaignData.mwlog.infoLog("could not read map config file. Will use defaults");
            this.conf = new InnerStellarMapConfig();
        }
        try {
            this.parseOverlayFile();
        }
        catch (Throwable e) {
            if (!(e instanceof FileNotFoundException)) {
                CampaignData.mwlog.errLog((Exception)e);
            }
            CampaignData.mwlog.infoLog("could not read map overlay file.");
        }
        for (int i = 0; i < displayStr.length; ++i) {
            this.display[i] = new JCheckBoxMenuItem(displayStr[i], this.conf.display[i]);
            this.display[i].addActionListener(this);
        }
        StringTokenizer tokenizer = new StringTokenizer(this.mwclient.getConfigParam("MAPFILTER1"), "$");
        int currFilter = 0;
        while (tokenizer.hasMoreElements() || currFilter < filterStr.length) {
            String nextToken = tokenizer.nextToken();
            if (currFilter == 1) {
                ++currFilter;
                continue;
            }
            if (nextToken != null) {
                boolean filterState;
                this.filterSettings[currFilter] = filterState = Boolean.parseBoolean(nextToken);
                this.filter[currFilter] = new JCheckBoxMenuItem(filterStr[currFilter], filterState);
                this.filter[currFilter].addActionListener(this);
            } else {
                this.filterSettings[currFilter] = true;
                this.filter[currFilter] = new JCheckBoxMenuItem(filterStr[currFilter], true);
                this.filter[currFilter].addActionListener(this);
            }
            ++currFilter;
        }
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InnerStellarMap.this.processTick();
            }
        });
        this.changesSinceLastRefresh = client.getChangesSinceLastRefresh();
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    InnerStellarMap.this.blinkPhase = !InnerStellarMap.this.blinkPhase;
                    if (InnerStellarMap.this.changesSinceLastRefresh.size() <= 0) continue;
                    InnerStellarMap.this.mp.repaint();
                }
            }
        }.start();
        Double storedZoom = Double.parseDouble(client.getConfigParam("MAPZOOMLEVEL"));
        if (storedZoom != null && (storedValue = storedZoom.doubleValue()) != 0.0) {
            this.conf.scale = storedValue;
        }
        int storedXOffset = Integer.parseInt(client.getConfigParam("MAPXOFFSET"));
        int storedYOffset = Integer.parseInt(client.getConfigParam("MAPYOFFSET"));
        this.conf.offset = new Point(storedXOffset, storedYOffset);
        String storedPlanetName = client.getConfigParam("SELECTEDPLANET");
        if (storedPlanetName != null && !storedPlanetName.trim().equals("") && (currPlan = client.getData().getPlanetByName(storedPlanetName)) != null) {
            this.activate(currPlan, false);
        }
    }

    private void parseOverlayFile() throws Exception {
        File file = new File("data/mapoverlay.txt");
        BufferedReader r = new BufferedReader(new FileReader(file));
        StreamTokenizer st = new StreamTokenizer(r);
        st.eolIsSignificant(true);
        st.commentChar(35);
        ArrayList<Position> line = new ArrayList<Position>();
        while (st.nextToken() != -1) {
            if (st.ttype == -3 && st.sval.equals("LINE") && line.size() > 0) {
                this.overlayLines.add(line);
                line = new ArrayList();
                continue;
            }
            if (st.ttype != -2) continue;
            double x = st.nval;
            if (st.nextToken() == -2) {
                line.add(new Position(x, st.nval));
            }
            while (st.ttype != -1 && st.ttype != 10) {
                st.nextToken();
            }
        }
        if (line.size() > 0) {
            this.overlayLines.add(line);
        }
    }

    private Planet nearestNeighbour(double x, double y) {
        Iterator<Planet> it = this.mp.getData().getAllPlanets().iterator();
        double minDiff = Double.MAX_VALUE;
        double diff = 0.0;
        Planet minPlanet = null;
        while (it.hasNext()) {
            Planet p = it.next();
            diff = p.getPosition().distanceSq(x, y);
            if (!(diff < minDiff) || !this.planetIsVisible(p)) continue;
            minDiff = diff;
            minPlanet = p;
        }
        return minPlanet;
    }

    private double scr2mapX(int x) {
        return Math.round((double)(x - this.getWidth() / 2 - this.conf.offset.x) / this.conf.scale);
    }

    private int map2scrX(double x) {
        return (int)Math.round((double)(this.getWidth() / 2) + x * this.conf.scale) + this.conf.offset.x;
    }

    private double scr2mapY(int y) {
        return Math.round((double)(this.getHeight() / 2 - (y - this.conf.offset.y)) / this.conf.scale);
    }

    private int map2scrY(double y) {
        return (int)Math.round((double)(this.getHeight() / 2) - y * this.conf.scale) + this.conf.offset.y;
    }

    @Override
    public void paint(Graphics g) {
        Collection<Planet> planets = this.mp.getData().getAllPlanets();
        g.setColor(StringUtils.html2Color(this.conf.backgroundColor));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int size = (int)Math.round(Math.max(5.0, Math.log(this.conf.scale) * 15.0 + 5.0));
        size = Math.max(Math.min(size, this.conf.maxdotSize), this.conf.minDotSize);
        if (this.conf.display[6] && this.overlayLines != null) {
            for (ArrayList arrayList : this.overlayLines) {
                g.setColor(StringUtils.html2Color(this.mwclient.getConfigParam("MAPOVERLAYCOLOR")));
                Position last = null;
                for (Position p : arrayList) {
                    if (last != null) {
                        g.drawLine(this.map2scrX(last.x), this.map2scrY(last.y), this.map2scrX(p.x), this.map2scrY(p.y));
                    }
                    last = p;
                }
            }
        } else {
            try {
                int x = this.mwclient.getConfig().getIntParam("MAPIMAGEX");
                int n = this.mwclient.getConfig().getIntParam("MAPIMAGEY");
                int height = (int)((double)this.mwclient.getConfig().getIntParam("MAPIMAGEHEIGHT") * this.conf.scale);
                int width = (int)((double)this.mwclient.getConfig().getIntParam("MAPIMAGEWIDTH") * this.conf.scale);
                ImageIcon ic = null;
                boolean useJPGImage = new File("data/images/mekwarsmap.jpg").exists();
                ic = useJPGImage ? new ImageIcon("data/images/mekwarsmap.jpg") : new ImageIcon("data/images/mekwarsmap.gif");
                g.drawImage(ic.getImage(), this.map2scrX(x), this.map2scrY(n), width, height, ic.getImageObserver());
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        for (Planet planet : planets) {
            int pos;
            if (!this.planetIsVisible(planet)) continue;
            Integer houseID = planet.getInfluence().getOwner();
            String houseColor = "";
            houseColor = houseID == null || houseID == -1 || planet.getInfluence().getInfluence(houseID) < this.mwclient.getMinPlanetOwnerShip(planet) ? this.mwclient.getserverConfigs("DisputedPlanetColor") : this.mwclient.getData().getHouse(houseID).getHouseColor();
            Color c = Color.WHITE;
            if (Boolean.parseBoolean(this.mwclient.getConfigParam("DARKERMAP"))) {
                try {
                    c = StringUtils.html2Color(houseColor);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Bad House for planet: " + planet.getName());
                }
            } else {
                try {
                    c = this.adjustColor(StringUtils.html2Color(houseColor));
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Bad House for planet: " + planet.getName());
                }
            }
            if (c.getRed() == 0 && c.getBlue() == 0) {
                c = Color.white;
            }
            int x = this.map2scrX(planet.getPosition().x) - size / 2;
            int y = this.map2scrY(planet.getPosition().y) - size / 2;
            if (this.mp.getPPanel() != null && this.mp.getPPanel().getPlanet() != null && this.mp.getPPanel().getPlanet().equals(planet)) {
                g.setColor(Color.WHITE);
                g.fillArc(x - 2, y - 2, size + 4, size + 4, 0, 360);
            }
            int dotSize = size;
            boolean blink = false;
            if (this.conf.display[5] && this.blinkPhase && this.changesSinceLastRefresh.containsKey(planet.getId())) {
                g.setColor(Color.WHITE);
                ++dotSize;
                blink = true;
            } else {
                g.setColor(c);
            }
            if (size < 3) {
                g.fillRect(x, y, dotSize, dotSize);
            } else {
                g.fillArc(x, y, dotSize, dotSize, 0, 360);
            }
            if (!blink) {
                g.setColor(c);
            }
            if (this.conf.display[0] && (this.conf.showPlanetNamesThreshold == 0.0 || this.conf.scale > this.conf.showPlanetNamesThreshold)) {
                g.drawString(planet.getName(), x + size, y);
            }
            if (this.conf.display[1] && (this.conf.showInfluenceThreshold == 0.0 || this.conf.scale > this.conf.showInfluenceThreshold)) {
                pos = 0;
                for (House h : planet.getInfluence().getHouses()) {
                    int flu;
                    String color = this.mwclient.getserverConfigs("DisputedPlanetColor");
                    int id = -1;
                    if (h != null) {
                        color = h.getHouseColor();
                        id = h.getId();
                    }
                    if ((flu = planet.getInfluence().getInfluence(id) / 10) == 10) continue;
                    Color factionColor = StringUtils.html2Color(color);
                    g.setColor(factionColor);
                    g.fillRect(x - 10, y + size + pos, 10, flu);
                    pos += flu;
                }
            }
            if (this.conf.display[2] && (this.conf.showUnitFactoriesThreshold == 0.0 || this.conf.scale > this.conf.showUnitFactoriesThreshold)) {
                pos = 0;
                if (planet.getFactoryCount() > 0) {
                    ImageIcon staricon = this.iconCache.get("data/images/star.gif");
                    staricon.paintIcon(this, g, x + size + pos, y + size / 2);
                }
            }
            if (this.conf.display[3] && planet.getBaysProvided() > 0) {
                g.setColor(Color.WHITE);
                g.drawString(Integer.toString(planet.getBaysProvided()), x - 8, y);
            }
            if (!planet.isHomeWorld()) continue;
            ImageIcon homeicon = this.iconCache.get("data/images/homeworld.gif");
            homeicon.paintIcon(this, g, x, y);
        }
        try {
            if (this.conf.display[4]) {
                TreeSet<String> legalOps = new TreeSet<String>();
                for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                    legalOps.addAll(currA.getLegalOperations());
                }
                for (String typeName : legalOps) {
                    Planet p;
                    String[] vals = this.mwclient.getAllOps().get(typeName);
                    double range = Double.parseDouble(vals[0]);
                    if (!(range < 2000.0) || !this.planetIsVisible(p = this.mp.getPPanel().getPlanet())) continue;
                    int x = this.map2scrX(p.getPosition().x);
                    int y = this.map2scrY(p.getPosition().y);
                    Color c = StringUtils.html2Color(vals[1]);
                    g.setColor(c);
                    int rSize = (int)Math.round(2.0 * range * this.conf.scale);
                    g.drawArc(x - rSize / 2, y - rSize / 2, rSize, rSize, 0, 360);
                }
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    private int adj(int r) {
        if (this.conf.colorAdjustment == 0.0) {
            return r;
        }
        if (this.conf.colorAdjustment == 1.0) {
            return 255;
        }
        int i = (int)(1.0 / this.conf.colorAdjustment);
        if (r > 0 && r < i) {
            r = i;
        }
        return Math.min((int)((double)r / (1.0 - this.conf.colorAdjustment)), 255);
    }

    public Color adjustColor(Color c) {
        return new Color(this.adj(c.getRed()), this.adj(c.getGreen()), this.adj(c.getBlue()));
    }

    public void activate(Planet p) {
        if (p == null) {
            return;
        }
        if (this.mp.getPPanel() != null && this.mp.getPPanel().getPlanet() != p) {
            this.mp.getPPanel().update(p);
            this.conf.planetID = p.getId();
            this.mp.repaint();
            this.saveMapSelection(p);
        }
    }

    public void activate(Planet p, boolean center) {
        if (p == null) {
            return;
        }
        this.activate(p);
        if (center) {
            this.conf.offset.setLocation(-p.getPosition().x * this.conf.scale, p.getPosition().y * this.conf.scale);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lastMousePos = new Point(e.getX(), e.getY());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lastMousePos = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMod = e.getButton();
        if (e.getButton() != 1) {
            return;
        }
        this.selectedPlanet = this.nearestNeighbour(this.scr2mapX(e.getX()), this.scr2mapY(e.getY()));
        this.activate(this.selectedPlanet);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseMod = 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseMod != 3) {
            return;
        }
        if (this.lastMousePos != null) {
            this.conf.offset.x -= this.lastMousePos.x - e.getX();
            this.conf.offset.y -= this.lastMousePos.y - e.getY();
        }
        this.mouseMoved(e);
        this.mp.repaint();
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 37) {
            this.conf.offset.y = (int)((double)this.conf.offset.y - this.conf.scale);
        } else if (keyCode == 38) {
            this.conf.offset.x = (int)((double)this.conf.offset.x - this.conf.scale);
        } else if (keyCode == 39) {
            this.conf.offset.y = (int)((double)this.conf.offset.y + this.conf.scale);
        } else if (keyCode == 40) {
            this.conf.offset.x = (int)((double)this.conf.offset.x + this.conf.scale);
        } else {
            return;
        }
        this.mp.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.lastMousePos == null) {
            this.lastMousePos = new Point(e.getX(), e.getY());
        } else {
            this.lastMousePos.x = e.getX();
            this.lastMousePos.y = e.getY();
        }
        if (this.conf.display[7]) {
            Planet planet = this.nearestNeighbour(this.scr2mapX(e.getX()), this.scr2mapY(e.getY()));
            StringBuilder result = new StringBuilder("<html><center><b><u>" + planet.getName() + "</b></u></center>");
            result.append("<TABLE CELLPADDING=1 CELLSPACING=1>");
            for (House h : planet.getInfluence().getHouses()) {
                String color = this.mwclient.getserverConfigs("DisputedPlanetColor");
                String name = "None";
                int id = -1;
                if (h != null) {
                    color = h.getHouseColor();
                    name = h.getName();
                    id = h.getId();
                }
                result.append("<TR><TD><font color=" + color + ">" + name + "</font></TD><TD>" + planet.getInfluence().getInfluence(id) + "%</TD></TR>");
            }
            result.append("</TABLE></html>");
            this.setToolTipText(result.toString());
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mp.getSlider().setValue(this.mp.getSlider().getValue() + e.getWheelRotation() * 3);
        if (this.selectedPlanet != null) {
            this.conf.offset.setLocation(-this.selectedPlanet.getPosition().x * this.conf.scale, this.selectedPlanet.getPosition().y * this.conf.scale);
            this.mp.repaint();
        }
    }

    public void setScale(double scale) {
        this.conf.scale = scale;
        if (this.selectedPlanet != null) {
            this.conf.offset.setLocation(-this.selectedPlanet.getPosition().x * this.conf.scale, this.selectedPlanet.getPosition().y * this.conf.scale);
        }
    }

    public void setXOff(int off) {
        this.conf.offset.x = off;
    }

    public void setYOff(int off) {
        this.conf.offset.y = off;
    }

    public void setSelectedPlanet(Planet p) {
        this.selectedPlanet = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mp.repaint();
        for (int i = 0; i < displayStr.length; ++i) {
            this.conf.display[i] = this.display[i].isSelected();
        }
        String filterString = "";
        for (int i = 0; i < this.filterSettings.length; ++i) {
            if (i == 1) {
                filterString = filterString + "false$";
                continue;
            }
            this.filterSettings[i] = this.filter[i].isSelected();
            filterString = filterString + this.filterSettings[i] + "$";
        }
        this.mwclient.getConfig().setParam("MAPFILTER", filterString);
        this.mwclient.getConfig().saveConfig();
    }

    public void processTick() {
        try {
            new MMNetXStream().toXML(this.conf, new FileWriter(this.mwclient.getCacheDir() + "/mapconf.xml"));
        }
        catch (IOException e1) {
            CampaignData.mwlog.errLog(e1);
        }
    }

    public void dataFetched(Map<Integer, Influences> changes) {
        for (int id : changes.keySet()) {
            try {
                Influences addinf = changes.get(id);
                Influences oldinf = this.changesSinceLastRefresh.get(id);
                if (oldinf != null) {
                    addinf.add(oldinf);
                }
                this.changesSinceLastRefresh.put(id, addinf);
                if (this.mp == null) continue;
                this.mp.repaint();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error with Planet: " + this.mwclient.getData().getPlanet(id).getName());
            }
        }
    }

    public Map<Integer, Influences> getChangesSinceLastRefresh() {
        return this.changesSinceLastRefresh;
    }

    public void createPlanetSearchDialog() {
        PlanetSearchDialog searchDialog = new PlanetSearchDialog(this, this.mwclient);
        searchDialog.setVisible(true);
    }

    public void saveMapSelection(Planet p) {
        this.mwclient.getConfig().setParam("SELECTEDPLANET", p.getName());
        this.mwclient.getConfig().setParam("MAPZOOMLEVEL", "" + this.conf.scale);
        this.mwclient.getConfig().setParam("MAPYOFFSET", "" + (int)this.conf.offset.getY());
        this.mwclient.getConfig().setParam("MAPXOFFSET", "" + (int)this.conf.offset.getX());
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
    }

    private boolean planetIsVisible(Planet p) {
        if (this.filterSettings[0]) {
            return true;
        }
        if (this.filterSettings[2] && p.getFactoryCount() > 0) {
            return true;
        }
        if (this.filterSettings[3] && p.getBaysProvided() > 0) {
            return true;
        }
        if (this.filterSettings[5]) {
            Integer houseID = p.getInfluence().getOwner();
            if (houseID == null) {
                return true;
            }
            if (p.getInfluence().getInfluence(houseID) < this.mwclient.getMinPlanetOwnerShip(p)) {
                return true;
            }
        }
        if (this.filterSettings[6] && p.getInfluence().getHouses().size() > 1) {
            return true;
        }
        return this.filterSettings[4] && p.getInfluence().getInfluence(this.mwclient.getPlayer().getMyHouse().getId()) > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IconProvider
    extends TreeMap<String, ImageIcon> {
        private static final long serialVersionUID = 4594828039895948331L;

        private IconProvider() {
        }

        public ImageIcon get(String key) {
            if (!this.containsKey(key)) {
                this.put(key, new ImageIcon(key));
            }
            return (ImageIcon)super.get(key);
        }
    }

    public static final class InnerStellarMapConfig {
        int minDotSize = 2;
        int maxdotSize = 25;
        int reverseScaleMax = 100;
        int reverseScaleMin = 2;
        double showInfluenceThreshold = 0.0;
        double showUnitFactoriesThreshold = 0.0;
        double showPlanetNamesThreshold = 0.0;
        double colorAdjustment = 0.5;
        String backgroundColor = "#000000";
        boolean[] display = new boolean[]{true, false, true, true, true, true, true, true};
        double scale = 1.0;
        Point offset = new Point();
        int planetID;
    }
}

