/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import common.CampaignData;
import common.House;
import common.campaign.pilot.Pilot;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import megamek.client.Client;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

public class CustomUnitDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4035217132830883530L;
    private JLabel labAutoEject = new JLabel("Disable Autoeject", 11);
    private JCheckBox chAutoEject = new JCheckBox();
    private JLabel labOffBoard = new JLabel("Deploy Offboard", 11);
    private JCheckBox chOffBoard = new JCheckBox();
    private JLabel labOffBoardDistance = new JLabel("Offboard Distance (Hexes):", 11);
    private JTextField fldOffBoardDistance = new JTextField(4);
    private JPanel boxPanel;
    private JScrollPane scrollPane;
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton("Okay");
    private JButton butCancel = new JButton("Cancel");
    private Vector<MunitionChoicePanel> m_vMunitions = new Vector(1, 1);
    private JPanel panMunitions = new JPanel();
    private Vector<MachineGunChoicePanel> m_vMachineGuns = new Vector(1, 1);
    private JPanel panMachineGuns = new JPanel();
    private JLabel labTargSys = new JLabel("Targeting System", 11);
    private Choice choTargSys = new Choice();
    private JPanel panEdgeSkills = new JPanel();
    private JCheckBox tacCB = new JCheckBox("TAC Rolls");
    private JCheckBox koCB = new JCheckBox("KO Rolls");
    private JCheckBox headHitsCB = new JCheckBox("Head Hit Rolls");
    private JCheckBox explosionsCB = new JCheckBox("Explosion Rolls");
    private Entity entity;
    private boolean okay = false;
    private MWClient mwclient;
    private boolean canDump = false;
    private Client mmClient = new Client("temp", "None", 0);
    private Pilot pilot = null;
    private boolean usingCrits = false;

    public CustomUnitDialog(MWClient mwclient, Entity entity, Pilot pilot) {
        super(mwclient.getMainFrame());
        this.entity = entity;
        this.mwclient = mwclient;
        this.pilot = pilot;
        this.usingCrits = Boolean.parseBoolean(mwclient.getserverConfigs("UsePartsRepair"));
        this.mmClient.game.getOptions().loadOptions();
        this.setTitle("Customize Unit");
        this.loadAmmo();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 1));
        this.scrollPane = new JScrollPane(scrollPanel);
        this.getContentPane().add(this.scrollPane);
        this.getContentPane().add(this.panButtons);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butOkay);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        int boxRows = 0;
        this.boxPanel = new JPanel(new SpringLayout());
        if (entity instanceof Mech) {
            Mech mech = (Mech)entity;
            this.chAutoEject.setSelected(!mech.isAutoEject());
            this.boxPanel.add(this.labAutoEject);
            this.boxPanel.add(this.chAutoEject);
            ++boxRows;
        }
        if (pilot.getSkills().has(20)) {
            this.setupEdgeSkills();
            this.boxPanel.add(new JLabel("Edge Selections", 11));
            this.boxPanel.add(this.panEdgeSkills);
            ++boxRows;
        }
        if (!UnitUtils.hasTargettingComputer(entity) && this.mmClient.game.getOptions().booleanOption("allow_level_3_targsys") && (entity instanceof Mech || entity instanceof Tank) && !entity.hasC3() && !entity.hasC3i()) {
            this.boxPanel.add(this.labTargSys);
            for (int pos = 0; pos < MiscType.targSysNames.length; ++pos) {
                if (pos == 1 || mwclient.getData().getBannedTargetingSystems().containsKey(pos)) continue;
                this.choTargSys.add(MiscType.getTargetSysName(pos));
            }
            this.boxPanel.add(this.choTargSys);
            this.choTargSys.select(MiscType.getTargetSysName(entity.getTargSysType()));
            ++boxRows;
        }
        boolean eligibleForOffBoard = false;
        for (Mounted mounted : entity.getWeaponList()) {
            WeaponType wtype = (WeaponType)mounted.getType();
            if (!wtype.hasFlag(32768L)) continue;
            eligibleForOffBoard = true;
        }
        if (eligibleForOffBoard) {
            this.boxPanel.add(this.labOffBoard);
            this.boxPanel.add(this.chOffBoard);
            this.chOffBoard.setSelected(entity.isOffBoard());
            this.boxPanel.add(this.labOffBoardDistance);
            this.fldOffBoardDistance.setText(Integer.toString(entity.getOffBoardDistance()));
            this.boxPanel.add(this.fldOffBoardDistance);
            boxRows += 2;
        }
        SpringLayoutHelper.setupSpringGrid(this.boxPanel, 2);
        scrollPanel.add(this.boxPanel);
        if (!(entity instanceof Infantry)) {
            this.setupMunitions();
            JPanel centeringPanel = new JPanel();
            centeringPanel.setLayout(new BoxLayout(centeringPanel, 1));
            centeringPanel.add(this.panMunitions);
            scrollPanel.add(centeringPanel);
            if (this.panMunitions.getComponentCount() == 0) {
                this.setTitle("Customize Unit");
            }
        }
        if (this.mmClient.game.getOptions().booleanOption("tacops_burst") && !(entity instanceof Infantry)) {
            this.setupMachineGuns();
            scrollPanel.add(this.panMachineGuns);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CustomUnitDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void setupMunitions() {
        int munitionsRows = 0;
        this.panMunitions.setLayout(new SpringLayout());
        MunitionChoicePanel mcp = null;
        int location = -1;
        for (Mounted m : this.entity.getAmmo()) {
            int loc;
            AmmoType at = (AmmoType)m.getType();
            Vector<AmmoType> vTypes = new Vector<AmmoType>(1, 1);
            Vector<AmmoType> vAllTypes = AmmoType.getMunitionsFor(at.getAmmoType());
            ++location;
            this.canDump = this.mmClient.game.getOptions().booleanOption("lobby_ammo_dump");
            if (vAllTypes == null) continue;
            int n = vAllTypes.size();
            for (int x = 0; x < n; ++x) {
                AmmoType atCheck = vAllTypes.elementAt(x);
                if (atCheck.getRackSize() != at.getRackSize() || atCheck.getTonnage(this.entity) != at.getTonnage(this.entity)) continue;
                boolean bTechMatch = TechConstants.isLegal(this.entity.getTechLevel(), atCheck.getTechLevel(), true);
                String munition = Long.toString(atCheck.getMunitionType());
                House faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse());
                if (this.mwclient.getData().getServerBannedAmmo().containsKey(munition) || faction.getBannedAmmo().containsKey(munition) || this.mwclient.getAmmoCost(atCheck.getInternalName()) < 0.0 && !this.usingCrits || this.usingCrits && this.mwclient.getPlayer().getPartsCache().getPartsCritCount(atCheck.getInternalName()) < 1 && !this.ammoAlreadyLoaded(atCheck) && this.mwclient.getBlackMarketEquipmentList().get(atCheck.getInternalName()) == null) continue;
                if (!(bTechMatch || this.entity.getTechLevel() != 5 && this.entity.getTechLevel() != 7 || atCheck.getTechLevel() > 1)) {
                    bTechMatch = true;
                }
                if (!this.mmClient.game.getOptions().booleanOption("is_eq_limits") && !this.entity.isClan() && atCheck.getTechLevel() == 1) {
                    bTechMatch = true;
                }
                if (this.mmClient.game.getOptions().booleanOption("allow_level_3_ammo") && !this.mmClient.game.getOptions().booleanOption("is_eq_limits")) {
                    if (this.entity.isClan() && (atCheck.getTechLevel() == 8 || atCheck.getTechLevel() == 6)) {
                        bTechMatch = true;
                    }
                    if (!(this.entity.isClan() || atCheck.getTechLevel() != 7 && atCheck.getTechLevel() != 5)) {
                        bTechMatch = true;
                    }
                } else if ((atCheck.getTechLevel() == 7 || atCheck.getTechLevel() == 5) && this.entity.getTechLevel() != 7 && this.entity.getTechLevel() != 5 || (atCheck.getTechLevel() == 8 || atCheck.getTechLevel() == 6) && this.entity.getTechLevel() != 8 && this.entity.getTechLevel() != 6) {
                    bTechMatch = false;
                }
                if (this.entity.isMixedTech()) {
                    bTechMatch = true;
                }
                long muniType = atCheck.getMunitionType();
                if (!this.mmClient.game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((muniType &= 0xFFFFFFFFFFFDFFFFL) == 524288L || muniType == 0x800000L || muniType == 0x1000000L || muniType == 0x2000000L || muniType == 0x4000000L || muniType == 0x8000000000L || muniType == 0x10000000000L)) {
                    bTechMatch = false;
                }
                if (!this.mmClient.game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(atCheck) || atCheck.hasFlag(4L) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && atCheck.hasFlag(1L) && !atCheck.hasFlag(4L) || !bTechMatch || atCheck.hasFlag(2L)) continue;
                vTypes.addElement(atCheck);
            }
            mcp = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(m, vTypes, location) : new MunitionChoicePanel(m, vTypes, location);
            if (m.getLocation() == -1) {
                Mounted linkedBy = m.getLinkedBy();
                loc = linkedBy.getLocation();
            } else {
                loc = m.getLocation();
            }
            this.panMunitions.add(new JLabel(this.entity.getLocationAbbr(loc) + ":", 11));
            this.panMunitions.add(mcp);
            this.m_vMunitions.addElement(mcp);
            ++munitionsRows;
        }
        if (munitionsRows > 10) {
            SpringLayoutHelper.setupSpringGrid(this.panMunitions, 4);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.panMunitions, 2);
        }
    }

    private void setupEdgeSkills() {
        this.panEdgeSkills.setLayout(new SpringLayout());
        this.tacCB.setSelected(this.pilot.getTac());
        this.koCB.setSelected(this.pilot.getKO());
        this.explosionsCB.setSelected(this.pilot.getExplosion());
        this.headHitsCB.setSelected(this.pilot.getHeadHit());
        this.panEdgeSkills.add(this.tacCB);
        this.panEdgeSkills.add(this.koCB);
        this.panEdgeSkills.add(this.explosionsCB);
        this.panEdgeSkills.add(this.headHitsCB);
        SpringLayoutHelper.setupSpringGrid(this.panEdgeSkills, 4);
    }

    private void setupMachineGuns() {
        int mgRows = 0;
        this.panMachineGuns.setLayout(new SpringLayout());
        for (int location = 0; location <= 7; ++location) {
            for (int slot = 0; slot < this.entity.getNumberOfCriticals(location); ++slot) {
                WeaponType wt;
                Mounted m;
                CriticalSlot crit = this.entity.getCritical(location, slot);
                if (crit == null || crit.getType() != 1 || (m = this.entity.getEquipment(crit.getIndex())) == null || !(m.getType() instanceof WeaponType) || !(wt = (WeaponType)m.getType()).hasFlag(512L)) continue;
                MachineGunChoicePanel mgcp = new MachineGunChoicePanel(m, location, slot);
                this.panMachineGuns.add(mgcp);
                this.m_vMachineGuns.addElement(mgcp);
                ++mgRows;
            }
        }
        if (mgRows >= 6) {
            SpringLayoutHelper.setupSpringGrid(this.panMachineGuns, 2);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.panMachineGuns, 1);
        }
    }

    public boolean isOkay() {
        return this.okay;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.butCancel) {
            boolean autoEject = this.chAutoEject.isSelected();
            if (this.chOffBoard.isSelected()) {
                int offBoardDistance;
                try {
                    offBoardDistance = Integer.parseInt(this.fldOffBoardDistance.getText());
                }
                catch (NumberFormatException e) {
                    this.mwclient.showInfoWindow("Please enter valid numbers for off board distance.");
                    return;
                }
                if (offBoardDistance < 17) {
                    this.mwclient.showInfoWindow("Offboard units need to be at least one mapsheet (17 hexes) away.");
                    return;
                }
                this.entity.setOffBoard(offBoardDistance, 0);
            } else {
                this.entity.setOffBoard(0, -1);
            }
            if (this.entity instanceof Mech) {
                Mech mech = (Mech)this.entity;
                if (mech.isAutoEject() == autoEject) {
                    mech.setAutoEject(!autoEject);
                    this.mwclient.sendChat("/c setautoeject#" + mech.getExternalId() + "#" + !autoEject);
                }
                if (this.pilot.getSkills().has(20)) {
                    this.mwclient.sendChat("/c setedgeSkills#" + mech.getExternalId() + "#" + this.tacCB.isSelected() + "#" + this.koCB.isSelected() + "#" + this.headHitsCB.isSelected() + "#" + this.explosionsCB.isSelected());
                }
            }
            if ((this.entity instanceof Mech || this.entity instanceof Tank) && !UnitUtils.hasTargettingComputer(this.entity) && this.mmClient.game.getOptions().booleanOption("allow_level_3_targsys")) {
                int targSysIndex = 0;
                if (this.choTargSys.getSelectedItem() != null) {
                    targSysIndex = MiscType.getTargetSysType(this.choTargSys.getSelectedItem());
                }
                if (this.entity.getTargSysType() != targSysIndex) {
                    if (targSysIndex >= 0) {
                        this.entity.setTargSysType(targSysIndex);
                    } else {
                        System.err.println("Illegal targetting system index: " + targSysIndex);
                        this.entity.setTargSysType(0);
                    }
                    this.mwclient.sendChat("/c settargetsystemtype#" + this.entity.getExternalId() + "#" + this.entity.getTargSysType());
                }
            }
            this.okay = true;
            Enumeration<JPanel> e = this.m_vMunitions.elements();
            while (e.hasMoreElements()) {
                e.nextElement().applyChoice();
            }
            e = this.m_vMachineGuns.elements();
            while (e.hasMoreElements()) {
                ((MachineGunChoicePanel)e.nextElement()).applyChoice();
            }
        }
        this.setVisible(false);
    }

    private void loadAmmo() {
        this.mwclient.loadBannedAmmo();
        this.mwclient.loadBanTargeting();
    }

    private boolean ammoAlreadyLoaded(AmmoType ammo) {
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType currAmmo = (AmmoType)mounted.getType();
            if (!currAmmo.equals(ammo)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private static final long serialVersionUID = 3984045407240841489L;
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        public ProtomechMunitionChoicePanel(Mounted m, Vector<AmmoType> vTypes, int row) {
            super(m, vTypes, row);
            this.m_origAmmo = (AmmoType)m.getType();
            this.m_origShotsLeft = m.getShotsLeft();
        }

        @Override
        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.isSelected()) {
                this.setShotsLeft(0);
            }
        }
    }

    class HotLoadChoicePanel
    extends JPanel {
        private static final long serialVersionUID = -4801226845131401403L;
        private Mounted m_mounted;
        private int location = 0;
        protected JCheckBox chHotLoad = new JCheckBox();

        public HotLoadChoicePanel(Mounted m, int location) {
            this.m_mounted = m;
            this.location = location;
            int loc = m.getLocation();
            this.chHotLoad.setSelected(this.m_mounted.isHotLoaded());
            this.chHotLoad.setText("Hot-Load " + this.m_mounted.getName() + " (" + CustomUnitDialog.this.entity.getLocationAbbr(loc) + ")");
            this.add(this.chHotLoad);
        }

        public void applyChoice() {
            if (this.m_mounted.isHotLoaded() != this.chHotLoad.isSelected()) {
                CustomUnitDialog.this.mwclient.sendChat("/c setunithotload#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + this.chHotLoad.isSelected());
            }
        }

        public void setEnabled(boolean enabled) {
            this.chHotLoad.setEnabled(enabled);
        }
    }

    class MachineGunChoicePanel
    extends JPanel {
        private static final long serialVersionUID = -2207765894385312209L;
        private Mounted m_mounted;
        private int location = 0;
        private int slot = 0;
        protected JCheckBox chBurst = new JCheckBox();

        public MachineGunChoicePanel(Mounted m, int location, int slot) {
            this.m_mounted = m;
            this.location = location;
            this.slot = slot;
            this.chBurst.setSelected(this.m_mounted.isRapidfire());
            this.chBurst.setText("Rapid Fire MG (" + CustomUnitDialog.this.entity.getLocationAbbr(location) + ")");
            this.add(this.chBurst);
        }

        public void applyChoice() {
            if (this.m_mounted.isRapidfire() != this.chBurst.isSelected()) {
                CustomUnitDialog.this.mwclient.sendChat("/c setunitburst#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + this.slot + "#" + this.chBurst.isSelected());
            }
        }

        public void setEnabled(boolean enabled) {
            this.chBurst.setEnabled(enabled);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MunitionChoicePanel
    extends JPanel {
        private static final long serialVersionUID = -5861067242226106955L;
        private Vector<AmmoType> m_vTypes;
        private JComboBox m_choice;
        private Mounted m_mounted;
        private int location = 0;
        protected JCheckBox chDump = new JCheckBox();
        protected JCheckBox chHotLoad = new JCheckBox();

        public MunitionChoicePanel(Mounted m, Vector<AmmoType> vTypes, int location) {
            this.m_vTypes = vTypes;
            this.m_mounted = m;
            this.location = location;
            AmmoType curType = (AmmoType)m.getType();
            this.m_choice = new JComboBox();
            Enumeration<AmmoType> e = this.m_vTypes.elements();
            int x = 0;
            while (e.hasMoreElements()) {
                AmmoType at = e.nextElement();
                this.m_choice.setMaximumSize(new Dimension(5, 5));
                int cost = Integer.MAX_VALUE;
                int shotsLeft = m.getShotsLeft();
                if (!curType.getInternalName().equalsIgnoreCase(at.getInternalName())) {
                    shotsLeft = 0;
                }
                double ammoCost = 0.0;
                try {
                    ammoCost = CustomUnitDialog.this.mwclient.getAmmoCost(at.getInternalName());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("error finding cost for: " + at.getName());
                    CampaignData.mwlog.errLog(ex);
                }
                if (m.getLocation() == -1) {
                    if (CustomUnitDialog.this.usingCrits) {
                        this.m_choice.addItem(at.getName() + " (" + shotsLeft + "/1/" + CustomUnitDialog.this.mwclient.getPlayer().getPartsCache().getPartsCritCount(at.getInternalName()) + ")");
                    } else {
                        this.m_choice.addItem(at.getName() + " (" + shotsLeft + "/1) " + CustomUnitDialog.this.mwclient.moneyOrFluMessage(true, true, (int)ammoCost));
                    }
                } else {
                    int refillShots = at.getShots();
                    if (!curType.getInternalName().equalsIgnoreCase(at.getInternalName())) {
                        shotsLeft = 0;
                    }
                    cost = shotsLeft == refillShots ? 0 : (int)Math.ceil(ammoCost * (double)(refillShots -= shotsLeft));
                    if (CustomUnitDialog.this.usingCrits) {
                        this.m_choice.addItem(at.getName() + " (" + shotsLeft + "/" + refillShots + "/" + CustomUnitDialog.this.mwclient.getPlayer().getPartsCache().getPartsCritCount(at.getInternalName()) + ")");
                    } else {
                        this.m_choice.addItem(at.getName() + " (" + shotsLeft + "/" + refillShots + ") " + CustomUnitDialog.this.mwclient.moneyOrFluMessage(true, true, cost));
                    }
                }
                if (at.getInternalName().equalsIgnoreCase(curType.getInternalName())) {
                    this.m_choice.setSelectedIndex(x);
                }
                ++x;
            }
            this.add(this.m_choice);
            if (CustomUnitDialog.this.canDump) {
                if (m.getShotsLeft() == 0) {
                    this.chDump.setSelected(true);
                }
                this.chDump.setText("Dump");
                this.add(this.chDump);
            }
            if (((CustomUnitDialog)CustomUnitDialog.this).mmClient.game.getOptions().booleanOption("tacops_hotload") && (CustomUnitDialog.this.entity instanceof Mech || CustomUnitDialog.this.entity instanceof Tank) && ((AmmoType)m.getType()).hasFlag(8L)) {
                this.chHotLoad.setSelected(m.isHotLoaded());
                this.chHotLoad.setText("Hot-Load");
                this.add(this.chHotLoad);
            } else {
                this.chHotLoad.setEnabled(false);
                this.chHotLoad.setText("Hot-Load");
                this.add(this.chHotLoad);
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            if (n < 0) {
                return;
            }
            AmmoType at = this.m_vTypes.elementAt(n);
            int totalShots = at.getShots();
            boolean hotloaded = false;
            if (this.chHotLoad != null) {
                hotloaded = this.chHotLoad.isSelected();
            }
            if (this.chDump.isSelected()) {
                this.m_mounted.setShotsLeft(0);
                totalShots = 0;
            } else if (this.m_mounted.getLocation() == -1) {
                totalShots = 1;
            }
            CustomUnitDialog.this.mwclient.sendChat("/c setunitammo#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + at.getAmmoType() + "#" + at.getInternalName() + "#" + totalShots + "#" + hotloaded);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.m_choice.setEnabled(enabled);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int shots) {
            this.m_mounted.setShotsLeft(shots);
        }
    }
}

