/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.gui.MechInfo;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Tank;

class GeneralPanel
extends JPanel {
    private static final long serialVersionUID = 4029105940787569233L;
    public JPanel statusP;
    public JPanel terrainP;
    public JPanel moveP;
    public JLabel mechTypeL;
    public JLabel weightL;
    public JLabel weightR;
    public JLabel pilotL;
    public JLabel pilotR;
    public JLabel skillsL;
    public JLabel skillsR;
    public JLabel mpL;
    public JLabel mpR;
    public JLabel heatL;
    public JLabel heatR;
    public JLabel bvR;
    public JLabel bvL;
    public JLabel cargoL;
    public JLabel cargoR;
    public JCheckBox autoEjectCB;
    public Entity ent = null;
    public MechInfo unitPicture = null;

    public GeneralPanel() {
        try {
            this.ent = UnitUtils.createOMG();
        }
        catch (Exception e) {
            System.out.println("ERROR UNIT MISSING!");
        }
        this.mechTypeL = new JLabel("<HTML><body>Me fail english!?<br>Thats unpossible!</body></HTML>", 0);
        this.mechTypeL.setAlignmentX(0.5f);
        this.weightL = new JLabel("Weight:", 4);
        this.pilotL = new JLabel("Pilot:", 4);
        this.skillsL = new JLabel("Gun/Pilot:", 4);
        this.weightR = new JLabel("?", 2);
        this.pilotR = new JLabel("?", 2);
        this.skillsR = new JLabel("?/?", 2);
        this.mpL = new JLabel("Movement:", 4);
        this.heatL = new JLabel("Heat:", 4);
        this.mpR = new JLabel("8/12/0", 2);
        this.heatR = new JLabel("2 (10 capacity)", 2);
        this.autoEjectCB = new JCheckBox();
        this.autoEjectCB.setToolTipText("Check to enable autoeject");
        this.statusP = new JPanel();
        JPanel statusSpringP = new JPanel(new SpringLayout());
        this.cargoL = new JLabel("Cargo:", 4);
        this.cargoR = new JLabel("9999", 2);
        this.bvL = new JLabel("BV:", 4);
        this.bvR = new JLabel("9999", 2);
        statusSpringP.add(this.weightL);
        statusSpringP.add(this.weightR);
        statusSpringP.add(this.skillsL);
        statusSpringP.add(this.skillsR);
        statusSpringP.add(this.mpL);
        statusSpringP.add(this.mpR);
        statusSpringP.add(this.heatL);
        statusSpringP.add(this.heatR);
        statusSpringP.add(this.bvL);
        statusSpringP.add(this.bvR);
        statusSpringP.add(this.cargoL);
        statusSpringP.add(this.cargoR);
        SpringLayoutHelper.setupSpringGrid(statusSpringP, 6, 2);
        this.statusP.setLayout(new BoxLayout(this.statusP, 1));
        this.statusP.add(statusSpringP);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.mechTypeL);
        this.add(this.statusP);
    }

    public void displayMech(Entity en, int bv, ImageIcon currentCamo) {
        this.ent = en;
        this.unitPicture = new MechInfo(currentCamo);
        this.unitPicture.setUnit(en);
        String uName = en.getShortNameRaw();
        this.mechTypeL.setText("<HTML><br><b>" + uName + "</b><br></HTML>");
        this.weightR.setText(Integer.toString((int)en.getWeight()));
        this.pilotR.setText(en.crew.getDesc());
        if (en instanceof Mech || en instanceof Tank || en instanceof Infantry && ((Infantry)en).isAntiMek()) {
            this.skillsR.setText(en.crew.getGunnery() + "/" + en.crew.getPiloting());
        } else {
            this.skillsL.setText("Gunnery:");
            this.skillsR.setText(Integer.toString(en.crew.getGunnery()));
        }
        StringBuilder mp = new StringBuilder();
        try {
            mp.append(en.getWalkMP());
            mp.append('/');
            mp.append(en.getRunMP());
            mp.append('/');
            mp.append(en.getJumpMPWithTerrain());
        }
        catch (Exception ex) {
            mp.append("0/0/0");
        }
        this.mpR.setText(mp.toString());
        int heatCap = en.getHeatCapacity() - en.getCoolantFailureAmount();
        int heatCapWater = en.getHeatCapacityWithWater() - en.getCoolantFailureAmount();
        String heatCapacityStr = Integer.toString(heatCap);
        if (heatCap < heatCapWater) {
            heatCapacityStr = heatCap + " [" + heatCapWater + "]";
        }
        this.heatR.setText(Integer.toString(en.heat) + " (" + heatCapacityStr + " capacity)");
        String capacity = en.getUnusedString();
        if (capacity != null && capacity.startsWith("Troops")) {
            capacity = capacity.substring(9);
            this.cargoR.setText(capacity);
        } else {
            this.cargoL.setText("");
            this.cargoR.setText("");
            this.cargoL.setVisible(false);
            this.cargoR.setVisible(false);
        }
        if (bv == 0) {
            this.bvR.setText("N/A");
        } else {
            this.bvR.setText(Integer.toString(bv));
        }
        this.add(this.unitPicture);
        this.validate();
    }
}

