/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.CUser;
import client.MWClient;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class PlayerNameDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2185532842152633162L;
    private JList matchingPlayersList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    public static final int ANY_PLAYER = 0;
    public static final int FACTION_ONLY = 1;
    public static final int MERCS_ONLY = 2;
    private String toReturn = null;
    private ArrayList<String> possiblePlayers = null;

    public PlayerNameDialog(MWClient client, String boxText, int playerType) {
        super(client.getMainFrame(), boxText, true);
        CUser user;
        Vector<String> factionPlayers = new Vector<String>(1, 1);
        Iterator<CUser> i = client.getUsers().iterator();
        if (playerType == 1) {
            while (i.hasNext()) {
                user = i.next();
                if (user.isInvis() && user.getUserlevel() > client.getUser(client.getPlayer().getName()).getUserlevel() || !user.getHouse().equalsIgnoreCase(client.getPlayer().getHouse()) || user.getName().equals(client.getPlayer().getName())) continue;
                factionPlayers.add(user.getName());
            }
        } else if (playerType == 2) {
            while (i.hasNext()) {
                user = i.next();
                if (user.isInvis() && user.getUserlevel() > client.getUser(client.getPlayer().getName()).getUserlevel() || !user.isMerc()) continue;
                factionPlayers.add(user.getName());
            }
        } else {
            while (i.hasNext()) {
                user = i.next();
                if (user.isInvis() && user.getUserlevel() > client.getUser(client.getPlayer().getName()).getUserlevel()) continue;
                factionPlayers.add(user.getName());
            }
        }
        Collections.sort(factionPlayers);
        final Object[] playerNames = factionPlayers.toArray();
        this.matchingPlayersList = new JList<Object>(playerNames);
        this.matchingPlayersList.setVisibleRowCount(10);
        this.matchingPlayersList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = PlayerNameDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            PlayerNameDialog.this.matchingPlayersList.setListData(playerNames);
                            return;
                        }
                        PlayerNameDialog.this.possiblePlayers = new ArrayList();
                        text = text.toLowerCase();
                        int until = playerNames.length;
                        for (int i = 0; i < until; ++i) {
                            String currPlayer = (String)playerNames[i];
                            if (currPlayer.toLowerCase().indexOf(text) == -1) continue;
                            PlayerNameDialog.this.possiblePlayers.add(currPlayer);
                        }
                        PlayerNameDialog.this.matchingPlayersList.setListData(PlayerNameDialog.this.possiblePlayers.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = PlayerNameDialog.this.possiblePlayers.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                PlayerNameDialog.this.matchingPlayersList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            PlayerNameDialog.this.matchingPlayersList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingPlayersList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedPlayer = (String)this.matchingPlayersList.getSelectedValue();
            if (selectedPlayer == null) {
                selectedPlayer = this.nameField.getText();
            }
            if (this.matchingPlayersList.getModel().getSize() == 1) {
                selectedPlayer = (String)this.matchingPlayersList.getModel().getElementAt(0);
            }
            if (selectedPlayer == null || selectedPlayer.equals("")) {
                return;
            }
            this.setPlayerName(selectedPlayer);
            this.setVisible(false);
            return;
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setPlayerName(String name) {
        this.toReturn = name;
    }

    public String getPlayerName() {
        return this.toReturn;
    }
}

