/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class SignonDialog
implements ActionListener {
    private final String usernameCommand = "user";
    private final String passwordCommand = "password";
    private final String okayCommand = "okay";
    private final String cancelCommand = "cancel";
    private final String windowName = "MekWars Login";
    private final String ipaddressCommand = "ip address";
    private final String chatPortCommand = "chatport";
    private final String dataPortCommand = "dataport";
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private final JTextField ipaddressField = new JTextField();
    private final JTextField chatPortField = new JTextField();
    private final JTextField dataPortField = new JTextField();
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private JDialog dialog;
    private JOptionPane pane;

    public SignonDialog(MWClient mwclient) {
        JLabel usernameLabel = new JLabel("Username: ", 2);
        JLabel passwordLabel = new JLabel("Password (none if unregistered): ", 2);
        JLabel ipaddressLabel = new JLabel("IP Address: ", 2);
        JLabel chatPortLabel = new JLabel("Chat Port: ", 2);
        JLabel dataPortLabel = new JLabel("Data Port: ", 2);
        this.usernameField.setActionCommand("user");
        this.passwordField.setActionCommand("password");
        this.chatPortField.setActionCommand("chatport");
        this.dataPortField.setActionCommand("dataport");
        this.ipaddressField.setActionCommand("ip address");
        this.okayButton.setActionCommand("okay");
        this.cancelButton.setActionCommand("cancel");
        this.usernameField.addActionListener(this);
        this.passwordField.addActionListener(this);
        this.ipaddressField.addActionListener(this);
        this.chatPortField.addActionListener(this);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        usernameLabel.setToolTipText("Username for remote systems");
        passwordLabel.setToolTipText("Password for remote systems");
        ipaddressLabel.setToolTipText("IP address for remote systems");
        chatPortLabel.setToolTipText("Port which server uses to host chat");
        dataPortLabel.setToolTipText("Port which server uses to host data");
        this.okayButton.setToolTipText("Use this username and password");
        this.cancelButton.setToolTipText("Quit MekWars");
        this.ipaddressField.setToolTipText("IP address for remote systems");
        JPanel textPanel = new JPanel(new GridLayout(5, 4), false);
        textPanel.add(usernameLabel);
        textPanel.add(this.usernameField);
        textPanel.add(passwordLabel);
        textPanel.add(this.passwordField);
        textPanel.add(ipaddressLabel);
        textPanel.add(this.ipaddressField);
        textPanel.add(chatPortLabel);
        textPanel.add(this.chatPortField);
        textPanel.add(dataPortLabel);
        textPanel.add(this.dataPortField);
        JPanel mainPanel = new JPanel(false);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(textPanel, -1, -1, null, options, this.usernameField);
        this.dialog = this.pane.createDialog(mainPanel, "MekWars Login");
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.usernameField.setText(mwclient.getConfig().getParam("NAME"));
        this.passwordField.setText(mwclient.getConfig().getParam("NAMEPASSWORD"));
        this.ipaddressField.setText(mwclient.getConfig().getParam("SERVERIP"));
        this.chatPortField.setText(mwclient.getConfig().getParam("SERVERPORT"));
        this.dataPortField.setText(mwclient.getConfig().getParam("DATAPORT"));
        this.dialog.setVisible(true);
        this.dialog.requestFocus();
        this.usernameField.requestFocus();
        this.dialog.setLocationRelativeTo(mwclient.getMainFrame());
        if (this.pane.getValue() == this.okayButton) {
            mwclient.getConfig().setParam("NAME", this.usernameField.getText());
            mwclient.setUsername(this.usernameField.getText());
            mwclient.setPassword(new String(this.passwordField.getPassword()));
            mwclient.getConfig().setParam("SERVERPORT", this.chatPortField.getText());
            mwclient.getConfig().setParam("DATAPORT", this.dataPortField.getText());
            mwclient.getConfig().setParam("SERVERIP", this.ipaddressField.getText());
        } else {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("user")) {
            this.passwordField.requestFocus();
        } else if (command.equals("password")) {
            this.ipaddressField.requestFocus();
        } else if (command.equals("ip address")) {
            this.chatPortField.requestFocus();
        } else if (command.equals("chatport")) {
            this.dataPortField.requestFocus();
        } else if (command.equals("dataport")) {
            this.okayButton.doClick(200);
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals("okay")) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals("cancel")) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        }
    }
}

