/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.TableSorter;
import client.gui.dialog.MechDetailDisplay;
import client.util.CUnitComparator;
import common.CampaignData;
import common.House;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import megamek.common.Entity;
import megamek.common.EntityListFile;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewerDialog
extends JFrame
implements ItemListener {
    private static final long serialVersionUID = -5449211786198003020L;
    JComboBox weightClassCombo;
    JComboBox factionCombo;
    JComboBox unitTypeCombo;
    JLabel factionLabel = new JLabel("Faction: ", 4);
    JLabel typeLabel = new JLabel("Type: ", 4);
    JLabel weightLabel = new JLabel("Class: ", 4);
    JLabel percentageLabel = new JLabel("Total Percentage: ", 0);
    Object[] factionArray;
    String[] unitTypeArray = new String[]{"Mek", "Vehicle", "BattleArmor", "Infantry", "ProtoMek", "Aero"};
    String[] weightClassArray = new String[]{"Light", "Medium", "Heavy", "Assault"};
    int factionSort = 0;
    int unitSort = 0;
    int weightSort = 0;
    JTable generalTable = new JTable();
    JScrollPane generalScrollPane = new JScrollPane();
    JButton closeButton = new JButton("Close");
    JButton refreshButton = new JButton("Reload Data");
    TableViewerModel tvModel;
    TreeMap<Object, TableUnit> currentUnits;
    TableUnit[] sortedUnits = new TableUnit[0];
    MWClient mwclient;

    public TableViewerDialog(MWClient client) {
        super("Table Browser");
        String previousItem;
        this.mwclient = client;
        this.currentUnits = new TreeMap();
        this.generalScrollPane = new JScrollPane();
        TreeSet<String> factionNames = new TreeSet<String>();
        for (House house : this.mwclient.getData().getAllHouses()) {
            if (house.getId() <= -1) continue;
            factionNames.add(house.getName());
        }
        factionNames.add("Common");
        this.factionArray = factionNames.toArray();
        this.weightClassCombo = new JComboBox<String>(this.weightClassArray);
        this.factionCombo = new JComboBox<Object>(this.factionArray);
        this.unitTypeCombo = new JComboBox();
        for (int type = 0; type < 6; ++type) {
            this.unitTypeCombo.addItem(Unit.getTypeClassDesc(type));
        }
        Dimension comboDim = new Dimension();
        comboDim.setSize(this.factionCombo.getMinimumSize().getWidth() * 1.5, this.factionLabel.getMinimumSize().getHeight() + 2.0);
        this.factionCombo.setAlignmentX(0.5f);
        this.factionCombo.setMaximumSize(comboDim);
        this.weightClassCombo.setAlignmentX(0.5f);
        this.weightClassCombo.setMaximumSize(comboDim);
        this.unitTypeCombo.setAlignmentX(0.5f);
        this.unitTypeCombo.setMaximumSize(comboDim);
        JPanel comboPanel = new JPanel(new SpringLayout());
        comboPanel.add(this.factionLabel);
        comboPanel.add(this.factionCombo);
        comboPanel.add(this.typeLabel);
        comboPanel.add(this.unitTypeCombo);
        comboPanel.add(this.weightLabel);
        comboPanel.add(this.weightClassCombo);
        SpringLayoutHelper.setupSpringGrid(comboPanel, 3, 2);
        try {
            previousItem = this.mwclient.getConfigParam("TABLEVIEWERFACTION");
            this.factionCombo.setSelectedItem(previousItem);
            this.factionSort = this.factionCombo.getSelectedIndex();
        }
        catch (Exception e) {
            this.factionCombo.setSelectedItem(this.mwclient.getPlayer().getHouse());
        }
        try {
            previousItem = this.mwclient.getConfigParam("TABLEVIEWERTYPE");
            this.unitTypeCombo.setSelectedItem(previousItem);
            this.unitSort = this.unitTypeCombo.getSelectedIndex();
        }
        catch (Exception e) {
            this.unitTypeCombo.setSelectedIndex(-1);
        }
        try {
            previousItem = this.mwclient.getConfigParam("TALEVIEWERWEIGHT");
            this.weightClassCombo.setSelectedItem(previousItem);
            this.weightSort = this.weightClassCombo.getSelectedIndex();
        }
        catch (Exception e) {
            this.weightClassCombo.setSelectedIndex(-1);
        }
        this.factionCombo.addItemListener(this);
        this.unitTypeCombo.addItemListener(this);
        this.weightClassCombo.addItemListener(this);
        this.closeButton.setAlignmentX(0.5f);
        this.closeButton.setAlignmentY(0.5f);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableViewerDialog.this.dispose();
            }
        });
        this.refreshButton.setAlignmentX(0.5f);
        this.refreshButton.setAlignmentY(0.5f);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableViewerDialog.this.refreshButton_ActionPerformed();
            }
        });
        this.tvModel = new TableViewerModel(this.mwclient, this.currentUnits, this.sortedUnits);
        TableSorter sorter = new TableSorter(this.tvModel, client, 1);
        this.generalTable.setModel(sorter);
        this.generalTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableUnit u = TableViewerDialog.this.getUnitAtRow(TableViewerDialog.this.generalTable.getSelectedRow());
                    if (u == null) {
                        return;
                    }
                    Entity theEntity = u.getEntity();
                    theEntity.loadAllWeapons();
                    JFrame InfoWindow = new JFrame();
                    MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
                    InfoWindow.getContentPane().add(MechDetailInfo);
                    InfoWindow.setSize(220, 400);
                    InfoWindow.setResizable(false);
                    MechDetailInfo.displayEntity(theEntity, theEntity.calculateBattleValue(), TableViewerDialog.this.mwclient.getConfig().getImage("CAMO"));
                    InfoWindow.setTitle(u.getModelName());
                    InfoWindow.setLocationRelativeTo(TableViewerDialog.this.mwclient.getMainFrame());
                    InfoWindow.setVisible(true);
                }
            }
        });
        for (int j = 0; j < this.tvModel.getColumnCount(); ++j) {
            this.generalTable.getColumnModel().getColumn(j).setCellRenderer(this.tvModel.getRenderer());
        }
        sorter.addMouseListenerToHeaderInTable(this.generalTable);
        this.generalTable.setSelectionMode(0);
        this.generalTable.setDoubleBuffered(true);
        this.generalScrollPane.setToolTipText("Click on column header to sort.");
        this.generalScrollPane.setViewportView(this.generalTable);
        this.generalScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), BorderFactory.createLineBorder(Color.BLACK, 1)));
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        JPanel buttonPanel = new JPanel(new SpringLayout());
        this.percentageLabel.setAlignmentX(0.5f);
        this.percentageLabel.setAlignmentY(0.5f);
        this.percentageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        boxPanel.add(comboPanel);
        boxPanel.add(this.generalScrollPane);
        boxPanel.add(this.percentageLabel);
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(this.closeButton);
        SpringLayoutHelper.setupSpringGrid(buttonPanel, 2);
        boxPanel.add(buttonPanel);
        boxPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.getContentPane().add(boxPanel);
        this.loadTables();
        this.refresh();
        this.setLocationRelativeTo(this.mwclient.getMainFrame());
        this.setVisible(true);
    }

    public void refresh() {
        this.tvModel.refreshModel();
        this.generalTable.setPreferredSize(new Dimension(this.generalTable.getWidth(), this.generalTable.getRowHeight() * this.generalTable.getRowCount()));
        this.generalTable.revalidate();
    }

    @Override
    public void setVisible(boolean show) {
        this.pack();
        this.setLocationRelativeTo(this.mwclient.getMainFrame());
        this.setSize(720, 575);
        this.setResizable(false);
        super.setVisible(show);
    }

    public TableUnit getUnitAtRow(int row) {
        String filename = (String)this.generalTable.getModel().getValueAt(row, 4);
        if (filename != null) {
            return this.currentUnits.get(filename);
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent i) {
        JComboBox source = (JComboBox)i.getSource();
        if (source == this.unitTypeCombo && this.unitSort == this.unitTypeCombo.getSelectedIndex()) {
            return;
        }
        if (source == this.weightClassCombo && this.weightSort == this.weightClassCombo.getSelectedIndex()) {
            return;
        }
        if (source == this.factionCombo && this.factionSort == this.factionCombo.getSelectedIndex()) {
            return;
        }
        this.loadTables();
        this.unitSort = this.unitTypeCombo.getSelectedIndex();
        this.weightSort = this.weightClassCombo.getSelectedIndex();
        this.factionSort = this.factionCombo.getSelectedIndex();
        this.mwclient.getConfig().setParam("TABLEVIEWERFACTION", (String)this.factionCombo.getSelectedItem());
        this.mwclient.getConfig().setParam("TABLEVIEWERTYPE", (String)this.unitTypeCombo.getSelectedItem());
        this.mwclient.getConfig().setParam("TALEVIEWERWEIGHT", (String)this.weightClassCombo.getSelectedItem());
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
        this.refresh();
    }

    public boolean hasValidExtension(String l) {
        String lc = l.toLowerCase();
        return lc.endsWith(".blk") || lc.endsWith(".mtf") || lc.endsWith(".hmp") || lc.endsWith(".xml") || lc.endsWith(".hmv") || lc.endsWith(".mep") || lc.endsWith(".mul");
    }

    public InputStream getEntryInputStream(File bf) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(bf);
            return is;
        }
        catch (IOException io) {
            return null;
        }
    }

    public int getTotalWeightForTable(File bf) {
        int totalweight = 0;
        try {
            FileInputStream fis = new FileInputStream(bf);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String l = dis.readLine();
                if (l == null || l.trim().length() == 0) continue;
                l = l.trim();
                if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                    l = l.substring(1, l.length());
                }
                StringTokenizer ST = new StringTokenizer(l);
                totalweight += Integer.parseInt((String)ST.nextElement());
            }
            fis.close();
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalweight;
    }

    /*
     * Unable to fully structure code
     */
    public void doTableLayer(TreeMap<String, Double> curr, TreeMap<String, Double> next, String add, File buildTablePath, boolean commonOverride) {
        for (String currTableName : curr.keySet()) {
            tableEntry = null;
            tableEntry = commonOverride != false ? new File(buildTablePath.getPath() + File.separatorChar + "Common" + add) : new File(buildTablePath.getPath() + File.separatorChar + currTableName + add);
            if (!tableEntry.exists()) {
                tableEntry = commonOverride != false ? new File((buildTablePath.getPath() + File.separatorChar + "Common" + add).toLowerCase()) : new File((buildTablePath.getPath() + File.separatorChar + currTableName + add).toLowerCase());
            }
            if (!tableEntry.exists()) continue;
            totaltableweight = this.getTotalWeightForTable(tableEntry);
            is = this.getEntryInputStream(tableEntry);
            dis = new BufferedReader(new InputStreamReader(is));
            tablemultiplier = curr.get(currTableName);
lbl11:
            // 2 sources

            try {
                while (dis.ready()) {
                    block18: {
                        block19: {
                            l = dis.readLine();
                            if (l == null || l.trim().length() == 0) continue;
                            l = l.trim();
                            if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                                l = l.substring(1, l.length());
                            }
                            ST = new StringTokenizer(l);
                            weight = Double.parseDouble((String)ST.nextElement());
                            if (!this.hasValidExtension(l) || weight == 0.0) break block18;
                            Filename = "";
                            while (ST.hasMoreElements()) {
                                Filename = Filename + ST.nextToken();
                                if (!ST.hasMoreElements()) continue;
                                Filename = Filename + " ";
                            }
                            frequency = weight / (double)totaltableweight * tablemultiplier;
                            if (!Filename.toLowerCase().endsWith(".mul")) break block19;
                            loadedUnits = null;
                            entityFile = new File("data/armies/" + Filename);
                            try {
                                loadedUnits = EntityListFile.loadFrom(entityFile);
                                loadedUnits.trimToSize();
                                frequency /= (double)loadedUnits.size();
                            }
                            catch (Exception ex) {
                                CampaignData.mwlog.errLog("Unable to load file " + entityFile.getName());
                                CampaignData.mwlog.errLog(ex);
                                continue;
                            }
                            for (Entity en : loadedUnits) {
                                tu = new TableUnit(en, frequency);
                                if (tu == null) continue;
                                eu = this.currentUnits.get(tu.getRealFilename());
                                if (eu != null) {
                                    eu.addFrequencyFrom(tu);
                                } else {
                                    this.currentUnits.put(tu.getRealFilename(), tu);
                                }
                                eu = this.currentUnits.get(tu.getRealFilename());
                                if (eu.getTables().get(currTableName) == null) {
                                    eu.getTables().put(currTableName, new Double(frequency));
                                    continue;
                                }
                                currFreq = eu.getTables().get(currTableName);
                                newFreq = new Double(currFreq + frequency);
                                eu.getTables().remove(currTableName);
                                eu.getTables().put(currTableName, newFreq);
                            }
                            ** GOTO lbl11
                        }
                        tu = new TableUnit(Filename, frequency);
                        if (tu == null) continue;
                        eu = this.currentUnits.get(Filename);
                        if (eu != null) {
                            eu.addFrequencyFrom(tu);
                        } else {
                            this.currentUnits.put(Filename, tu);
                        }
                        eu = this.currentUnits.get(Filename);
                        if (eu.getTables().get(currTableName) == null) {
                            eu.getTables().put(currTableName, new Double(frequency));
                            continue;
                        }
                        currFreq = eu.getTables().get(currTableName);
                        newFreq = new Double(currFreq + frequency);
                        eu.getTables().remove(currTableName);
                        eu.getTables().put(currTableName, newFreq);
                        continue;
                    }
                    if (weight == 0.0) continue;
                    crossTableName = "";
                    while (ST.hasMoreElements()) {
                        crossTableName = crossTableName + ST.nextToken();
                        if (!ST.hasMoreElements()) continue;
                        crossTableName = crossTableName + " ";
                    }
                    if (next == null) continue;
                    if (next.containsKey("crossTableName")) {
                        d = next.get(crossTableName);
                        newTableWeight = d + weight / (double)totaltableweight * tablemultiplier;
                        next.remove(crossTableName);
                        next.put(crossTableName, new Double(newTableWeight));
                        continue;
                    }
                    next.put(crossTableName, new Double(weight / (double)totaltableweight * tablemultiplier));
                }
                is.close();
                dis.close();
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public void loadTables() {
        String factionString = "";
        String addOnString = "";
        factionString = factionString + (String)this.factionCombo.getSelectedItem();
        addOnString = addOnString + "_" + (String)this.weightClassCombo.getSelectedItem();
        String type = (String)this.unitTypeCombo.getSelectedItem();
        if (!type.equals("Mek")) {
            addOnString = addOnString + type;
        }
        addOnString = addOnString + ".txt";
        File buildTablePath = null;
        buildTablePath = new File("./data/buildtables/standard");
        if (!buildTablePath.exists()) {
            CampaignData.mwlog.errLog("Could not find build tables.");
            return;
        }
        this.currentUnits.clear();
        boolean overrideWithCommon = false;
        File tableEntry = new File(buildTablePath.getPath() + File.separatorChar + factionString + addOnString);
        if (tableEntry == null) {
            tableEntry = new File((buildTablePath.getPath() + File.separatorChar + factionString + addOnString).toLowerCase());
        }
        if (tableEntry == null) {
            overrideWithCommon = true;
            tableEntry = new File(buildTablePath.getPath() + File.separatorChar + "Common" + addOnString);
        }
        if (tableEntry == null) {
            tableEntry = new File((buildTablePath.getPath() + File.separatorChar + "Common" + addOnString).toLowerCase());
        }
        if (tableEntry == null) {
            return;
        }
        TreeMap<String, Double> crossMap1 = new TreeMap<String, Double>();
        TreeMap<String, Double> crossMap2 = new TreeMap<String, Double>();
        TreeMap<String, Double> temp = new TreeMap<String, Double>();
        temp.put(factionString, new Double(100.0));
        this.doTableLayer(temp, crossMap1, addOnString, buildTablePath, overrideWithCommon);
        while (true) {
            this.doTableLayer(crossMap1, crossMap2, addOnString, buildTablePath, false);
            if (crossMap2.size() < 1) break;
            crossMap1 = crossMap2;
            crossMap2 = new TreeMap();
        }
        double totalPercent = 0.0;
        for (TableUnit currUnit : this.currentUnits.values()) {
            totalPercent += currUnit.getFrequency();
        }
        DecimalFormat myFormatter = new DecimalFormat("###.#####");
        this.percentageLabel.setText("Total Percentage: " + myFormatter.format(totalPercent) + "%");
    }

    public void refreshButton_ActionPerformed() {
        int userLevel = this.mwclient.getUserLevel();
        this.refreshButton.setEnabled(false);
        if (userLevel >= this.mwclient.getData().getAccessLevel("AdminRequestBuildTable")) {
            this.mwclient.sendChat("/c AdminRequestBuildTable#list#true");
        } else if (userLevel >= this.mwclient.getData().getAccessLevel("RequestBuildTable")) {
            this.mwclient.sendChat("/c RequestBuildTable#list#true");
        }
        this.mwclient.setWaiting(true);
        while (this.mwclient.isWaiting()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.loadTables();
        this.refresh();
        this.refreshButton.setEnabled(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TableUnit
    extends CUnit {
        double frequency;
        String realFilename;
        TreeMap<String, Double> tables;

        public TableUnit(String fn, double f) {
            this.setUnitFilename(fn.trim());
            this.setPilot(new Pilot("Autopilot", 4, 5));
            try {
                String modfn = fn.trim();
                modfn = modfn.substring(0, modfn.length() - 4);
                MechSummary ms = MechSummaryCache.getInstance().getMech(modfn);
                this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            }
            catch (Exception e) {
                this.createEntityFromFileNameWithCache(fn.trim());
            }
            this.realFilename = fn;
            this.frequency = f;
            this.tables = new TreeMap();
        }

        public TableUnit(Entity en, double f) {
            this.realFilename = UnitUtils.getEntityFileName(en);
            this.setUnitFilename(this.realFilename);
            this.setPilot(new Pilot("Autopilot", 4, 5));
            this.UnitEntity = en;
            this.frequency = f;
            this.tables = new TreeMap();
        }

        public double getFrequency() {
            return this.frequency;
        }

        public void addFrequencyFrom(TableUnit u) {
            this.frequency += u.getFrequency();
        }

        public String getRealFilename() {
            return this.realFilename;
        }

        public TreeMap<String, Double> getTables() {
            return this.tables;
        }

        private void createEntityFromFileNameWithCache(String fn) {
            this.UnitEntity = UnitUtils.createEntity(fn);
            if (this.UnitEntity == null) {
                this.createEntityFromFilename(fn);
            }
        }

        private void createEntityFromFilename(String fn) {
            this.UnitEntity = null;
            try {
                this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), fn).getEntity();
            }
            catch (Exception e) {
                try {
                    this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Vehicles.zip"), fn).getEntity();
                }
                catch (Exception ex) {
                    try {
                        this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Infantry.zip"), fn).getEntity();
                    }
                    catch (Exception exc) {
                        try {
                            CampaignData.mwlog.errLog("Error loading unit: " + fn + ". Try replacing with OMG.");
                            this.UnitEntity = UnitUtils.createOMG();
                        }
                        catch (Exception exepe) {
                            CampaignData.mwlog.errLog("Error unit failed to load. Exiting.");
                            System.exit(1);
                        }
                    }
                }
            }
            this.setType(TableUnit.getEntityType(this.UnitEntity));
            this.getC3Type(this.UnitEntity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TableViewerModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4544580878221428391L;
        public static final int UNIT = 0;
        public static final int WEIGHT = 1;
        public static final int BATTLEVALUE = 2;
        public static final int FREQUENCY = 3;
        public static final int FILENAME = 4;
        TreeMap<Object, TableUnit> currentUnits;
        TableUnit[] sortedUnits;
        int currentSortMode = 3;
        String[] columnNames = new String[]{"Unit", "Weight", "BV", "Frequency"};
        MWClient mwclient;

        public TableViewerModel(MWClient c, TreeMap<Object, TableUnit> current, TableUnit[] sorted) {
            this.mwclient = c;
            this.currentUnits = current;
            this.sortedUnits = sorted;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.sortedUnits.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setSortMode(int sortMode) {
            this.currentSortMode = sortMode;
        }

        public TableViewerRenderer getRenderer() {
            return new TableViewerRenderer();
        }

        public void refreshModel() {
            this.sortedUnits = new TableUnit[0];
            this.sortedUnits = this.sortUnits(this.currentSortMode);
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.sortedUnits.length) {
                return "";
            }
            TableUnit currU = this.sortedUnits[row];
            if (currU == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    try {
                        if (currU.getType() == 0 && currU.getEntity() != null && !currU.getEntity().isOmni()) {
                            return "<html><body>" + currU.getEntity().getChassis() + ", " + currU.getModelName();
                        }
                        return "<html><body>" + currU.getModelName();
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                        return "";
                    }
                }
                case 1: {
                    return new Integer((int)currU.getEntity().getWeight());
                }
                case 2: {
                    return new Integer(currU.getEntity().calculateBattleValue());
                }
                case 3: {
                    DecimalFormat myFormatter = new DecimalFormat("##0.00");
                    return myFormatter.format(currU.getFrequency()) + "%";
                }
                case 4: {
                    return currU.getRealFilename();
                }
            }
            return "";
        }

        public TableUnit[] sortUnits(int sortMode) {
            CUnitComparator comparator = null;
            switch (sortMode) {
                case 0: {
                    this.sortedUnits = this.currentUnits.values().toArray(this.sortedUnits);
                    comparator = new CUnitComparator(0);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 1: {
                    this.sortedUnits = this.currentUnits.values().toArray(this.sortedUnits);
                    comparator = new CUnitComparator(9);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 2: {
                    this.sortedUnits = this.currentUnits.values().toArray(this.sortedUnits);
                    comparator = new CUnitComparator(1);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 3: {
                    this.sortedUnits = this.currentUnits.values().toArray(this.sortedUnits);
                    Arrays.sort(this.sortedUnits, new Comparator<TableUnit>(){

                        @Override
                        public int compare(TableUnit o1, TableUnit o2) {
                            try {
                                TableUnit t1 = o1;
                                TableUnit t2 = o2;
                                Double d1 = 0.0;
                                Double d2 = 0.0;
                                if (t1 != null) {
                                    d1 = new Double(t1.getFrequency());
                                }
                                if (t2 != null) {
                                    d2 = new Double(t2.getFrequency());
                                }
                                return d1.compareTo(d2);
                            }
                            catch (Exception ex) {
                                CampaignData.mwlog.errLog(ex);
                                return 0;
                            }
                        }
                    });
                    return this.sortedUnits;
                }
            }
            return new TableUnit[0];
        }

        private class TableViewerRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -8249928200262506117L;

            private TableViewerRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component d = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel c = new JLabel();
                c.setOpaque(true);
                if (row >= TableViewerModel.this.currentUnits.size() || row < 0) {
                    return c;
                }
                if (table.getModel().getValueAt(row, column) != null) {
                    c.setText(table.getModel().getValueAt(row, column).toString());
                }
                c.setToolTipText("");
                Object unit = table.getModel().getValueAt(row, 4);
                TableUnit currU = TableViewerModel.this.currentUnits.get(unit);
                if (currU == null) {
                    return null;
                }
                StringBuilder description = new StringBuilder();
                if (currU.getType() == 0 && !currU.getEntity().isOmni()) {
                    description.append("<html><body><u>" + currU.getEntity().getChassis() + ", " + currU.getModelName() + "</u><br>");
                } else {
                    description.append("<html><body><u>" + currU.getModelName() + "</u><br>");
                }
                description.append("Sources:");
                Iterator<String> i = currU.getTables().keySet().iterator();
                DecimalFormat formatter = new DecimalFormat("##0.0##");
                while (i.hasNext()) {
                    String tableName = i.next();
                    Double freq = currU.getTables().get(tableName);
                    description.append("<br>- " + tableName + ": " + formatter.format(freq) + "%");
                }
                c.setToolTipText(description.toString());
                if (isSelected) {
                    c.setForeground(d.getForeground());
                    c.setBackground(d.getBackground());
                    return c;
                }
                c.setBackground(Color.white);
                return c;
            }
        }
    }
}

