/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.MWClient;
import common.CampaignData;
import common.Equipment;
import common.House;
import common.Influences;
import common.Planet;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFetchClient {
    private String hostAddr;
    private String cacheDir;
    private CampaignData data;
    private Map<Integer, Influences> changesSinceLastRefresh;
    private Date lastTimestamp = null;
    private int dataPort = 4867;
    private Socket dataSocket = null;
    private int socketDelayTime = 2000;

    public DataFetchClient(int dataport, int socketDelayTime) {
        this.dataPort = dataport;
        this.changesSinceLastRefresh = new HashMap<Integer, Influences>();
        this.socketDelayTime = socketDelayTime > 0 ? socketDelayTime : 2000;
    }

    public void getServerConfigData(MWClient mwclient) throws IOException {
        block17: {
            boolean timestampMatch = false;
            boolean localConfigExists = false;
            File localConfig = new File(this.cacheDir + "/campaignconfig.txt");
            if (localConfig.exists()) {
                localConfigExists = true;
                String localConfigTimestamp = "";
                try {
                    FileInputStream in = new FileInputStream(this.cacheDir + "/campaignconfig.txt");
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    String tempTime = br.readLine();
                    br.close();
                    in.close();
                    localConfigTimestamp = tempTime.substring(11);
                }
                catch (Exception e) {
                    CampaignData.mwlog.errLog("Problems reading timestamp from local configuration.");
                }
                String serverConfigTimestamp = "error";
                try {
                    BinReader in = this.openConnection("ConfigTimestamp");
                    serverConfigTimestamp = in.readLine("ConfigTimestamp");
                }
                catch (Exception e) {
                    CampaignData.mwlog.errLog("Problems connecting to server to get config timestamp.");
                }
                CampaignData.mwlog.errLog("Local Config: " + localConfigTimestamp + " Server Config: " + serverConfigTimestamp);
                if (localConfigTimestamp.equals(serverConfigTimestamp)) {
                    timestampMatch = true;
                    try {
                        FileInputStream configFile = new FileInputStream(this.cacheDir + "/campaignconfig.txt");
                        mwclient.serverConfigs.load(configFile);
                        configFile.close();
                    }
                    catch (Exception ex) {
                        timestampMatch = false;
                    }
                }
            }
            if (!timestampMatch || !localConfigExists) {
                if (localConfigExists) {
                    File f = new File(this.cacheDir + "/campaignconfig.txt");
                    f.delete();
                }
                try {
                    BinReader in = this.openConnection("ServerConfig");
                    FileOutputStream fops = new FileOutputStream(this.cacheDir + "/campaignconfig.txt");
                    PrintStream out = new PrintStream(fops);
                    try {
                        while (true) {
                            out.println(in.readLine("ConfigLine"));
                        }
                    }
                    catch (Exception e) {
                        out.close();
                        fops.close();
                        try {
                            FileInputStream configFile = new FileInputStream(this.cacheDir + "/campaignconfig.txt");
                            mwclient.serverConfigs.load(configFile);
                            configFile.close();
                        }
                        catch (Exception ex) {
                            CampaignData.mwlog.errLog(ex);
                        }
                    }
                }
                catch (Exception exe) {
                    Object[] options;
                    int selectedValue;
                    if (mwclient.getConfig().isParam("DEDICATED") || (selectedValue = JOptionPane.showOptionDialog(null, "No campaignconfig.txt. This usually means that you were unable to\n\rconnect to the server to fetch a copy. Do you wish to exit?", "Startup\n\rerror!", -1, 0, null, options = new Object[]{"Exit", "Continue"}, options[0])) != 0) break block17;
                    System.exit(0);
                }
            }
        }
    }

    public void getBlackMarketSettings(MWClient mwclient) throws IOException {
        try {
            BinReader in = this.openConnection("BMSetting");
            try {
                for (int count = in.readInt("BMSetting"); count > 0; --count) {
                    Equipment bme = new Equipment();
                    bme.setEquipmentInternalName(in.readLine("BMSetting"));
                    bme.setMinCost(in.readDouble("BMSetting"));
                    bme.setMaxCost(in.readDouble("BMSetting"));
                    bme.setMinProduction(in.readInt("BMSetting"));
                    bme.setMaxProduction(in.readInt("BMSetting"));
                    bme.setUpdated(false);
                    mwclient.getBlackMarketEquipmentList().put(bme.getEquipmentInternalName(), bme);
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
        catch (Exception exe) {
            CampaignData.mwlog.errLog(exe);
        }
    }

    public void getBannedAmmoData(MWClient mwclient) throws IOException {
        boolean timestampMatch = false;
        File localban = new File(this.cacheDir + "/banammo.dat");
        if (localban.exists()) {
            String localListTimestamp = "";
            try {
                FileInputStream in = new FileInputStream(localban);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                localListTimestamp = br.readLine();
                br.close();
                in.close();
                BinReader binreader = this.openConnection("BannedAmmoTimeStamp");
                String serverTimeStamp = binreader.readLine("BannedAmmoTimeStamp");
                CampaignData.mwlog.errLog("Local Ban: " + localListTimestamp + " Server Ban: " + serverTimeStamp);
                if (localListTimestamp.equals(serverTimeStamp)) {
                    timestampMatch = true;
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Problems reading timestamp from local banammo.dat.");
            }
        }
        mwclient.clearBanAmmo();
        if (!timestampMatch) {
            BinReader in = this.openConnection("BannedAmmo");
            String timestamp = "-1";
            try {
                timestamp = in.readLine("BannedAmmo");
                while (true) {
                    mwclient.loadBanAmmo(in.readLine("BannedAmmo"));
                }
            }
            catch (Exception ex) {
                mwclient.saveBannedAmmo(timestamp);
            }
        } else {
            try {
                FileInputStream fis = new FileInputStream(mwclient.getCacheDir() + "/banammo.dat");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String line = dis.readLine();
                    mwclient.loadBanAmmo(line);
                }
                dis.close();
                fis.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void getBanTargetingData(MWClient mwclient) throws IOException {
        boolean timestampMatch = false;
        File localban = new File(this.cacheDir + "/bantargeting.dat");
        if (localban.exists()) {
            String localListTimestamp = "";
            try {
                FileInputStream in = new FileInputStream(localban);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                localListTimestamp = br.readLine();
                br.close();
                in.close();
                BinReader binreader = this.openConnection("BanTargetingTimeStamp");
                String serverTimeStamp = binreader.readLine("BanTargetingTimeStamp");
                CampaignData.mwlog.errLog("Local BanT: " + localListTimestamp + " Server BanT: " + serverTimeStamp);
                if (localListTimestamp.equals(serverTimeStamp)) {
                    timestampMatch = true;
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Problems reading timestamp from local bantargeting.dat.");
            }
        }
        mwclient.clearBanTargeting();
        if (!timestampMatch) {
            BinReader in = this.openConnection("BanTargeting");
            String timestamp = "-1";
            try {
                timestamp = in.readLine("BanTargeting");
                mwclient.loadBanTargeting(in.readLine("BanTargeting"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            mwclient.saveBannedTargetingSystems(timestamp);
        } else {
            try {
                FileInputStream fis = new FileInputStream(mwclient.getCacheDir() + "/bantargeting.dat");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                dis.readLine();
                mwclient.loadBanTargeting(dis.readLine());
                dis.close();
                fis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void checkServerVersion(MWClient mwclient) throws IOException {
        boolean mustUpdate = false;
        String clientVersion = "0.2.40.0";
        clientVersion = clientVersion.substring(0, clientVersion.lastIndexOf("."));
        BinReader binreader = this.openConnection("ServerVersion");
        String serverVersion = binreader.readLine("ServerVersion");
        serverVersion = serverVersion.substring(0, serverVersion.lastIndexOf("."));
        CampaignData.mwlog.errLog("Client Version: " + clientVersion + " Server Version: " + serverVersion);
        boolean bl = mustUpdate = !serverVersion.equalsIgnoreCase(clientVersion);
        if (!mustUpdate) {
            binreader = this.openConnection("ForceUpdateKey");
            String forceUpdateKey = binreader.readLine("ForceUpdateKey");
            String clientUpdateKey = mwclient.getConfigParam("UPDATEKEY");
            CampaignData.mwlog.errLog("Server Key: " + forceUpdateKey);
            if (forceUpdateKey.trim().length() > 1) {
                boolean bl2 = mustUpdate = !forceUpdateKey.equals(clientUpdateKey);
            }
        }
        if (mustUpdate) {
            Runtime runtime;
            int update = 1;
            if (!mwclient.isDedicated()) {
                update = JOptionPane.showConfirmDialog(null, "You have an invalid version\n\rof the MekWars Client\n\rWould you like to update now?", "Invalid Client update now!", 0);
                if (update == 0) {
                    try {
                        mwclient.goodbye();
                        runtime = Runtime.getRuntime();
                        String[] call = new String[]{"java", "-jar", "./MekWarsAutoUpdate.jar", "PLAYER"};
                        runtime.exec(call);
                        CampaignData.mwlog.errLog("Starting Update!");
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                }
            } else {
                try {
                    mwclient.stopHost();
                    mwclient.goodbye();
                    runtime = Runtime.getRuntime();
                    String[] call = new String[]{"java", "-jar", "MekWarsAutoUpdate.jar", "DEDICATED"};
                    runtime.exec(call);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
            System.exit(0);
        }
    }

    public void checkForMostRecentOpList() throws IOException {
        Object in;
        boolean timestampMatch = false;
        File localList = new File(this.cacheDir + "/OpList.txt");
        if (localList.exists()) {
            String localListTimestamp = "";
            try {
                in = new FileInputStream(this.cacheDir + "/OpList.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in));
                String tempTime = br.readLine();
                br.close();
                ((FileInputStream)in).close();
                localListTimestamp = tempTime.substring(11);
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Problems reading timestamp from local OpList.");
            }
            in = this.openConnection("OpListTimestamp");
            String serverListTimestamp = ((BinReader)in).readLine("OpListTimestamp");
            CampaignData.mwlog.errLog("Local OpList: " + localListTimestamp + " Server OpList: " + serverListTimestamp);
            if (localListTimestamp.equals(serverListTimestamp)) {
                timestampMatch = true;
            }
        }
        if (!timestampMatch) {
            File f = new File(this.cacheDir + "/OpList.txt");
            if (f.exists()) {
                f.delete();
            }
            try {
                in = this.openConnection("OpList");
                FileOutputStream fops = new FileOutputStream(this.cacheDir + "/OpList.txt");
                PrintStream out = new PrintStream(fops);
                try {
                    while (true) {
                        out.println(((BinReader)in).readLine("ListLine"));
                    }
                }
                catch (Exception e) {
                    out.close();
                    fops.close();
                }
            }
            catch (Exception exe) {
                CampaignData.mwlog.errLog(exe);
            }
        }
    }

    public void getServerTraitFiles() throws IOException {
        try {
            BinReader in = this.openConnection("ServerTrait");
            try {
                while (true) {
                    String faction = in.readLine("TraitLine");
                    FileOutputStream fops = new FileOutputStream(this.cacheDir + "/" + faction.toLowerCase() + "traitnames.txt");
                    PrintStream out = new PrintStream(fops);
                    for (int count = in.readInt("TraitLine"); count > 0; --count) {
                        out.println(in.readLine("TraitLine"));
                    }
                    out.flush();
                    out.close();
                    fops.flush();
                    fops.close();
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public CampaignData getAllData() throws IOException {
        CampaignData data;
        BinReader in = this.openConnection("All");
        this.data = data = new CampaignData(in);
        this.store();
        return data;
    }

    public CampaignData getCacheData(String cachePath) throws IOException {
        BinReader in = new BinReader(new FileReader(cachePath + "/data.dat"));
        CampaignData data = new CampaignData(in);
        in.close();
        this.data = data;
        this.store();
        return data;
    }

    public boolean getPlanetsUpdate(CampaignData Data) {
        try {
            BinReader in = this.openConnection("PDiff", 60000);
            this.data = Data;
            if (this.data == null) {
                CampaignData.mwlog.errLog("data is null getPlanetsUpdate");
                return false;
            }
            try {
                this.data.clearHouses();
                int size = in.readInt("houses.size");
                for (int count = 0; count < size; ++count) {
                    House house = new House(in);
                    this.data.addHouse(house);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                this.lastTimestamp = sdf.parse(in.readLine("lasttimestamp"));
                boolean fullUpdate = in.readBoolean("FullUpdate");
                if (fullUpdate) {
                    this.data.clearPlanets();
                }
                size = in.readInt("planets.size");
                for (int count = 0; count < size; ++count) {
                    Planet planet = new Planet();
                    planet.binIn(in, this.data);
                    this.data.addPlanet(planet);
                    this.changesSinceLastRefresh.put(planet.getId(), planet.getInfluence());
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog(e);
            return false;
        }
        catch (RuntimeException e) {
            CampaignData.mwlog.errLog(e);
            return false;
        }
        this.store();
        return true;
    }

    public boolean getAccessLevels(CampaignData Data) {
        try {
            BinReader in = this.openConnection("CommandAccessLevels");
            Data.importAccessLevels(in);
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog(e);
            return false;
        }
        catch (RuntimeException e) {
            CampaignData.mwlog.errLog(e);
            return false;
        }
        return true;
    }

    private BinReader openConnection(String cmd) throws IOException {
        return this.openConnection(cmd, this.socketDelayTime);
    }

    private BinReader openConnection(String cmd, int timeout) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        CampaignData.mwlog.infoLog("Command: " + cmd);
        if (this.dataSocket == null || this.dataSocket.isClosed() || this.dataSocket.isInputShutdown() || this.dataSocket.isOutputShutdown()) {
            this.closeDataConnection();
            CampaignData.mwlog.infoLog("Trying to connect to " + this.hostAddr + " at port " + this.dataPort);
            this.dataSocket = new Socket(this.hostAddr, this.dataPort);
            this.dataSocket.setKeepAlive(true);
        } else {
            this.dataSocket.getOutputStream().flush();
        }
        this.dataSocket.setSoTimeout(timeout);
        BinWriter out = new BinWriter(new PrintWriter(this.dataSocket.getOutputStream()));
        out.println(cmd, "cmd");
        if (this.lastTimestamp == null) {
            out.println("", "lasttimestamp");
        } else {
            CampaignData.mwlog.infoLog("writing timestamp " + sdf.format(this.lastTimestamp));
            out.println(sdf.format(this.lastTimestamp), "lasttimestamp");
        }
        out.flush();
        BinReader in = null;
        try {
            in = new BinReader(new InputStreamReader(this.dataSocket.getInputStream()));
            sdf.parse(in.readLine("lasttimestamp"));
        }
        catch (ParseException e) {
            CampaignData.mwlog.errLog(e);
            CampaignData.mwlog.infoLog("Timestamp could not be parsed.. left unchanged.");
        }
        catch (SocketException se) {
            CampaignData.mwlog.errLog("Socket Exception Error: DataFetchClient");
            CampaignData.mwlog.errLog(se);
            this.closeDataConnection();
            return this.openConnection(cmd, timeout);
        }
        catch (NullPointerException NPE) {
            this.closeDataConnection();
            return this.openConnection(cmd, timeout);
        }
        return in;
    }

    public void setData(String hostAddr, String cacheDir) {
        this.hostAddr = hostAddr;
        this.cacheDir = cacheDir;
    }

    public void store() {
        if (this.lastTimestamp != null) {
            try {
                FileWriter fw = new FileWriter(this.cacheDir + "/dataLastUpdated.dat");
                fw.write(Long.toString(this.lastTimestamp.getTime()));
                fw.close();
            }
            catch (IOException e) {
                CampaignData.mwlog.errLog(e);
            }
        }
        try {
            BinWriter binOut = new BinWriter(new PrintWriter(new FileWriter(this.cacheDir + "/data.dat")));
            this.data.binOut(binOut);
            binOut.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Error saving data.");
        }
    }

    public Map<Integer, Influences> getChangesSinceLastRefresh() {
        return this.changesSinceLastRefresh;
    }

    public void setLastTimestamp(Date lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public void closeDataConnection() {
        try {
            if (this.dataSocket == null) {
                return;
            }
            CampaignData.mwlog.infoLog("Closing Socket.");
            this.dataSocket.shutdownInput();
            this.dataSocket.shutdownOutput();
            this.dataSocket.close();
            this.dataSocket = null;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            this.dataSocket = null;
        }
    }
}

