/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Unit;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Army {
    public static final int NO_LIMIT = -1;
    private Vector<Unit> units = new Vector(1, 1);
    private String name = " ";
    private int upperLimiter = -1;
    private int lowerLimiter = -1;
    private int bv = 0;
    private int id;
    private boolean locked = false;
    private boolean armyPlayerLocked = false;
    private boolean armyDisabled = false;
    private float opForceSize = -1.0f;
    private Hashtable<Integer, Integer> c3Network = new Hashtable();
    private Vector<Integer> commanders = new Vector(1, 1);

    public int getAmountOfUnits() {
        return this.units.size();
    }

    public boolean isDisabled() {
        return this.armyDisabled;
    }

    public void disableArmy() {
        this.armyDisabled = true;
    }

    public void enableArmy() {
        this.armyDisabled = false;
    }

    public void toggleArmyDisabled() {
        this.armyDisabled = !this.armyDisabled;
    }

    public boolean isPlayerLocked() {
        return this.armyPlayerLocked;
    }

    public void playerLockArmy() {
        this.armyPlayerLocked = true;
    }

    public void playerUnlockArmy() {
        this.armyPlayerLocked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    public int getBV() {
        if (this.bv < 0) {
            return 0;
        }
        return this.bv;
    }

    public void setBV(int i) {
        this.bv = i;
    }

    public int getLowerLimiter() {
        return this.lowerLimiter;
    }

    public void setLowerLimiter(int lowerLimit) {
        this.lowerLimiter = lowerLimit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s.trim();
    }

    public void addUnit(Unit unit, int Position2) {
        this.units.add(Position2, unit);
    }

    public void addUnit(Unit unit) {
        this.units.add(unit);
    }

    public Vector<Unit> getUnits() {
        return this.units;
    }

    public int getNumberOfUnitTypes(int type) {
        int count = 0;
        for (Unit unit : this.getUnits()) {
            if (unit.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public int getUpperLimiter() {
        return this.upperLimiter;
    }

    public void setUpperLimiter(int upperLimit) {
        this.upperLimiter = upperLimit;
    }

    public int getID() {
        return this.id;
    }

    public Unit getUnit(int unitId) {
        for (Unit currU : this.getUnits()) {
            if (currU.getId() != unitId) continue;
            return currU;
        }
        return null;
    }

    public void setID(int id) {
        this.id = id;
    }

    public String toString(boolean toClient, String delimiter) {
        StringBuilder result = new StringBuilder();
        result.append(this.getID());
        result.append(delimiter);
        if (toClient) {
            result.append(this.getBV());
            result.append(delimiter);
            result.append(this.isLocked());
            result.append(delimiter);
        }
        if (this.getName().length() > 0) {
            result.append(this.getName());
        } else {
            result.append(" ");
        }
        result.append(delimiter);
        result.append(this.getLowerLimiter());
        result.append(delimiter);
        result.append(this.getUpperLimiter());
        result.append(delimiter);
        result.append(this.getUnits().size());
        result.append(delimiter);
        for (Unit unit : this.getUnits()) {
            result.append(unit.getId());
            result.append(delimiter);
        }
        result.append(delimiter);
        result.append(this.getC3Network().size());
        result.append(delimiter);
        for (Integer currI : this.getC3Network().keySet()) {
            result.append(currI);
            result.append(delimiter);
            result.append(this.getC3Network().get(currI));
            result.append(delimiter);
        }
        result.append(this.opForceSize);
        result.append(delimiter);
        result.append(this.commanders.size());
        result.append(delimiter);
        for (Integer unitId : this.commanders) {
            result.append(unitId);
            result.append(delimiter);
        }
        result.append(Boolean.toString(this.armyPlayerLocked));
        result.append(delimiter);
        result.append(Boolean.toString(this.armyDisabled));
        result.append(delimiter);
        return result.toString();
    }

    public Hashtable<Integer, Integer> getC3Network() {
        return this.c3Network;
    }

    public void setC3Network(Hashtable<Integer, Integer> network) {
        this.c3Network = network;
    }

    public void removeUnitFromC3Network(int unitID) {
        if (this.getC3Network().get(new Integer(unitID)) != null) {
            this.getC3Network().remove(new Integer(unitID));
            return;
        }
        Iterator<Integer> i = this.getC3Network().keySet().iterator();
        while (i.hasNext()) {
            Integer slave = i.next();
            Integer master = this.getC3Network().get(slave);
            if (master != unitID) continue;
            i.remove();
        }
    }

    public int getNumberOfNetworks() {
        int count = 0;
        for (int uid : this.c3Network.values()) {
            try {
                Unit master = this.getUnit(uid);
                if (this.c3Network.containsKey(uid) || !master.hasBeenC3LinkedTo(this)) continue;
                ++count;
            }
            catch (Exception ex) {}
        }
        return Math.max(1, count);
    }

    public float getOpForceSize() {
        return this.opForceSize;
    }

    public void setOpForceSize(float force) {
        this.opForceSize = force;
    }

    public Vector<Integer> getCommanders() {
        return this.commanders;
    }

    public boolean isCommander(int id) {
        return this.commanders.contains(id);
    }

    public void removeCommander(int id) {
        this.commanders.removeElement(id);
        this.commanders.trimToSize();
    }

    public void addCommander(int id) {
        if (this.isCommander(id)) {
            return;
        }
        this.commanders.add(id);
        this.commanders.trimToSize();
    }
}

