/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.Unit;
import java.util.Properties;
import java.util.StringTokenizer;

public class SubFaction {
    private static Properties defaultSettings = new Properties();
    private Properties factionSettings = new Properties(SubFaction.getDefault());
    public int DBId = 0;

    public SubFaction() {
    }

    public SubFaction(String name) {
        this.factionSettings.setProperty("Name", name);
    }

    public SubFaction(String name, String accessLevel) {
        this.factionSettings.setProperty("Name", name);
        this.factionSettings.setProperty("AccessLevel", accessLevel);
    }

    public static Properties getDefault() {
        defaultSettings.setProperty("Name", "");
        defaultSettings.setProperty("AccessLevel", "0");
        for (int type = 0; type < 6; ++type) {
            for (int weight = 0; weight <= 3; ++weight) {
                String setting = "CanBuyNew" + Unit.getWeightClassDesc(weight) + Unit.getTypeClassDesc(type);
                defaultSettings.setProperty(setting, "true");
                setting = "CanBuyUsed" + Unit.getWeightClassDesc(weight) + Unit.getTypeClassDesc(type);
                defaultSettings.setProperty(setting, "true");
            }
        }
        defaultSettings.setProperty("MinELO", "0");
        defaultSettings.setProperty("MinExp", "0");
        return defaultSettings;
    }

    public String getConfig(String key) {
        if (!this.factionSettings.containsKey(key)) {
            if (SubFaction.getDefault().containsKey(key)) {
                return SubFaction.getDefault().getProperty(key);
            }
            CampaignData.mwlog.errLog("Unable to find subfaction config: " + key);
            return "-1";
        }
        return this.factionSettings.getProperty(key);
    }

    public void setConfig(String key, String value) {
        this.factionSettings.setProperty(key, value);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.factionSettings.size() < 1) {
            return "# #";
        }
        for (Object key : this.factionSettings.keySet()) {
            result.append(key.toString());
            result.append("#");
            result.append(this.factionSettings.getProperty(key.toString()));
            result.append("#");
        }
        return result.toString();
    }

    public void fromString(String settings) {
        StringTokenizer propertyList = new StringTokenizer(settings, "#");
        while (propertyList.hasMoreElements()) {
            String key = propertyList.nextToken();
            if (!propertyList.hasMoreElements()) {
                return;
            }
            String value = propertyList.nextToken();
            this.setConfig(key, value);
        }
    }
}

