/*
 * Decompiled with CFR 0.152.
 */
package common.comm;

import client.MWClient;
import common.comm.ClientCommand;
import common.comm.ICommand;
import common.comm.ServerCommand;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MWServ;

public abstract class Command
extends Thread
implements ClientCommand,
ServerCommand {
    public static final String DELIM = "|";
    public static final int TIMEOUT = 0;
    public static final int UNKNOWN = 1;
    public static final int MALFORMED = 2;
    public static final int LASTERROR = 2;
    public Vector<String> ErrorMessages = new Vector(1, 1);
    protected MWClient mwclient = null;
    protected MWServ myServer = null;
    protected String username;
    protected int error_code = -1;
    protected String myPrefix;

    public Command(String prefix) {
        this.myPrefix = prefix;
        this.ErrorMessages.add("This operation has timed out");
        this.ErrorMessages.add("The packet recieved was unknown");
        this.ErrorMessages.add("The packet recieved was malformed");
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public void timeout() {
        this.error_code = 0;
    }

    public void reset() {
        this.error_code = -1;
        this.username = "";
    }

    public boolean hasError() {
        return this.error_code != -1;
    }

    public String getErrorMessage() {
        if (this.hasError() && this.error_code >= 0 && this.error_code < this.ErrorMessages.size()) {
            return this.toString() + " " + this.ErrorMessages.elementAt(this.error_code);
        }
        return "";
    }

    public void send(boolean blocking) {
    }

    public void setClient(MWClient client) {
        this.mwclient = client;
    }

    public void setServer(MWServ server) {
        this.myServer = server;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public void parseReply(String s) {
        StringTokenizer st = new StringTokenizer(s, DELIM);
        if (!st.hasMoreTokens()) {
            this.error_code = 2;
            return;
        }
        if (!st.nextToken().equalsIgnoreCase(this.getPrefix())) {
            this.error_code = 2;
            return;
        }
        if (st.hasMoreTokens() && st.nextToken().equalsIgnoreCase("E") && st.hasMoreTokens()) {
            this.error_code = Integer.parseInt(st.nextToken());
        }
        this.parseReplyArgs(s.substring(s.indexOf(DELIM) + 1));
    }

    public abstract void parseReplyArgs(String var1);

    public void clientSend(String txt) {
        this.myServer.clientSend(txt, this.username);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends Hashtable<String, ICommand> {
        private static final long serialVersionUID = -4187092531938444178L;

        public void put(ICommand c) {
            super.put(c.getPrefix(), c);
        }
    }
}

