/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import java.io.File;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import server.campaign.CampaignMain;

public final class MWLogger {
    private static final int rotations = 5;
    private static final int normFileSize = 1000000;
    private static final int bigFileSize = 5000000;
    private static final int hugeFileSize = 10000000;
    private static boolean logging = false;
    private static boolean addSeconds = true;
    private static boolean isServer = false;
    private File logDir;
    private Logger mainLog;
    private Logger factionLog;
    private Logger gameLog;
    private Logger resultsLog;
    private Logger cmdLog;
    private Logger pmLog;
    private Logger bmLog;
    private Logger infoLog;
    private Logger warnLog;
    private Logger errLog;
    private Logger modLog;
    private Logger tickLog;
    private Logger ipLog;
    private Logger dbLog;
    private Logger debugLog;
    private MMNetFormatter mmnetFormatter;
    private FileHandler mainHandler;
    private FileHandler factionHandler;
    private FileHandler gameHandler;
    private FileHandler resultsHandler;
    private FileHandler cmdHandler;
    private FileHandler pmHandler;
    private FileHandler bmHandler;
    private FileHandler infoHandler;
    private FileHandler warnHandler;
    private FileHandler errHandler;
    private FileHandler modHandler;
    private FileHandler tickHandler;
    private FileHandler ipHandler;
    private FileHandler dbHandler;
    private FileHandler debugHandler;

    public MWLogger() {
        if (logging) {
            return;
        }
        this.logDir = new File("logs");
        if (!this.logDir.exists()) {
            try {
                if (!this.logDir.mkdirs()) {
                    System.err.println("WARNING: logging directory cannot be created!");
                    System.err.println("WARNING: disabling log subsystem");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!this.logDir.isDirectory()) {
            System.err.println("WARNING: logging directory is not a directory!");
            System.err.println("WARNING: disabling log subsystem");
            return;
        }
        if (!this.logDir.canWrite()) {
            System.err.println("WARNING: cannot write in logging directory!");
            System.err.println("WARNING: disabling log subsystem");
            return;
        }
        this.mmnetFormatter = new MMNetFormatter();
    }

    public void createClientLoggers() {
        try {
            this.infoHandler = new FileHandler(this.logDir.getPath() + "/infolog", 1000000, 5, true);
            this.infoHandler.setLevel(Level.INFO);
            this.infoHandler.setFilter(null);
            this.infoHandler.setFormatter(this.mmnetFormatter);
            this.infoHandler.setEncoding("UTF8");
            this.infoLog = Logger.getLogger("infoLogger");
            this.infoLog.setUseParentHandlers(false);
            this.infoLog.addHandler(this.infoHandler);
            this.errHandler = new FileHandler(this.logDir.getPath() + "/errlog", 1000000, 5, true);
            this.errHandler.setLevel(Level.INFO);
            this.errHandler.setFilter(null);
            this.errHandler.setEncoding("UTF8");
            this.errHandler.setFormatter(this.mmnetFormatter);
            this.errLog = Logger.getLogger("errLogger");
            this.errLog.setUseParentHandlers(false);
            this.errLog.addHandler(this.errHandler);
            logging = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createServerLoggers() {
        try {
            this.mainHandler = new FileHandler(this.logDir.getPath() + "/mainlog", 5000000, 5, true);
            this.mainHandler.setLevel(Level.INFO);
            this.mainHandler.setFilter(null);
            this.mainHandler.setFormatter(this.mmnetFormatter);
            this.mainHandler.setEncoding("UTF8");
            this.mainLog = Logger.getLogger("mainLogger");
            this.mainLog.setUseParentHandlers(false);
            this.mainLog.addHandler(this.mainHandler);
            this.gameHandler = new FileHandler(this.logDir.getPath() + "/gamelog", 5000000, 5, true);
            this.gameHandler.setLevel(Level.INFO);
            this.gameHandler.setFilter(null);
            this.gameHandler.setFormatter(this.mmnetFormatter);
            this.gameHandler.setEncoding("UTF8");
            this.gameLog = Logger.getLogger("gameLogger");
            this.gameLog.setUseParentHandlers(false);
            this.gameLog.addHandler(this.gameHandler);
            this.resultsHandler = new FileHandler(this.logDir.getPath() + "/resultslog", 5000000, 5, true);
            this.resultsHandler.setLevel(Level.INFO);
            this.resultsHandler.setFilter(null);
            this.resultsHandler.setFormatter(this.mmnetFormatter);
            this.resultsHandler.setEncoding("UTF8");
            this.resultsLog = Logger.getLogger("resultsLogger");
            this.resultsLog.setUseParentHandlers(false);
            this.resultsLog.addHandler(this.resultsHandler);
            this.cmdHandler = new FileHandler(this.logDir.getPath() + "/cmdlog", 10000000, 5, true);
            this.cmdHandler.setLevel(Level.INFO);
            this.cmdHandler.setFilter(null);
            this.cmdHandler.setFormatter(this.mmnetFormatter);
            this.cmdHandler.setEncoding("UTF8");
            this.cmdLog = Logger.getLogger("cmdLogger");
            this.cmdLog.setUseParentHandlers(false);
            this.cmdLog.addHandler(this.cmdHandler);
            this.pmHandler = new FileHandler(this.logDir.getPath() + "/pmlog", 5000000, 5, true);
            this.pmHandler.setLevel(Level.INFO);
            this.pmHandler.setFilter(null);
            this.pmHandler.setFormatter(this.mmnetFormatter);
            this.pmHandler.setEncoding("UTF8");
            this.pmLog = Logger.getLogger("pmLogger");
            this.pmLog.setUseParentHandlers(false);
            this.pmLog.addHandler(this.pmHandler);
            this.bmHandler = new FileHandler(this.logDir.getPath() + "/bmlog", 1000000, 5, true);
            this.bmHandler.setLevel(Level.INFO);
            this.bmHandler.setFilter(null);
            this.bmHandler.setEncoding("UTF8");
            this.bmHandler.setFormatter(this.mmnetFormatter);
            this.bmLog = Logger.getLogger("bmLogger");
            this.bmLog.setUseParentHandlers(false);
            this.bmLog.addHandler(this.bmHandler);
            this.infoHandler = new FileHandler(this.logDir.getPath() + "/infolog", 1000000, 5, true);
            this.infoHandler.setLevel(Level.INFO);
            this.infoHandler.setFilter(null);
            this.infoHandler.setFormatter(this.mmnetFormatter);
            this.infoHandler.setEncoding("UTF8");
            this.infoLog = Logger.getLogger("infoLogger");
            this.infoLog.setUseParentHandlers(false);
            this.infoLog.addHandler(this.infoHandler);
            this.warnHandler = new FileHandler(this.logDir.getPath() + "/warnlog", 1000000, 5, true);
            this.warnHandler.setLevel(Level.INFO);
            this.warnHandler.setFilter(null);
            this.warnHandler.setFormatter(this.mmnetFormatter);
            this.warnHandler.setEncoding("UTF8");
            this.warnLog = Logger.getLogger("warnLogger");
            this.warnLog.setUseParentHandlers(false);
            this.warnLog.addHandler(this.warnHandler);
            this.errHandler = new FileHandler(this.logDir.getPath() + "/errlog", 1000000, 5, true);
            this.errHandler.setLevel(Level.INFO);
            this.errHandler.setFilter(null);
            this.errHandler.setEncoding("UTF8");
            this.errHandler.setFormatter(this.mmnetFormatter);
            this.errLog = Logger.getLogger("errLogger");
            this.errLog.setUseParentHandlers(false);
            this.errLog.addHandler(this.errHandler);
            this.modHandler = new FileHandler(this.logDir.getPath() + "/modlog", 5000000, 5, true);
            this.modHandler.setLevel(Level.INFO);
            this.modHandler.setFilter(null);
            this.modHandler.setFormatter(this.mmnetFormatter);
            this.modHandler.setEncoding("UTF8");
            this.modLog = Logger.getLogger("modLogger");
            this.modLog.setUseParentHandlers(false);
            this.modLog.addHandler(this.modHandler);
            this.tickHandler = new FileHandler(this.logDir.getPath() + "/ticklog", 1000000, 5, true);
            this.tickHandler.setLevel(Level.INFO);
            this.tickHandler.setFilter(null);
            this.tickHandler.setFormatter(this.mmnetFormatter);
            this.tickHandler.setEncoding("UTF8");
            this.tickLog = Logger.getLogger("tickLogger");
            this.tickLog.setUseParentHandlers(false);
            this.tickLog.addHandler(this.tickHandler);
            this.ipHandler = new FileHandler(this.logDir.getPath() + "/iplog", 0x6400000, 5, true);
            this.ipHandler.setLevel(Level.INFO);
            this.ipHandler.setFilter(null);
            this.ipHandler.setEncoding("UTF8");
            this.ipHandler.setFormatter(this.mmnetFormatter);
            this.ipLog = Logger.getLogger("ipLogger");
            this.ipLog.setUseParentHandlers(false);
            this.ipLog.addHandler(this.ipHandler);
            this.dbHandler = new FileHandler(this.logDir.getPath() + "/dblog", 0x6400000, 5, true);
            this.dbHandler.setLevel(Level.INFO);
            this.dbHandler.setFilter(null);
            this.dbHandler.setFormatter(this.mmnetFormatter);
            this.dbHandler.setEncoding("UTF8");
            this.dbLog = Logger.getLogger("dbLogger");
            this.dbLog.setUseParentHandlers(false);
            this.dbLog.addHandler(this.dbHandler);
            this.debugHandler = new FileHandler(this.logDir.getPath() + "/debuglog", 10000000, 5, true);
            this.debugHandler.setLevel(Level.INFO);
            this.debugHandler.setFilter(null);
            this.debugHandler.setFormatter(this.mmnetFormatter);
            this.debugHandler.setEncoding("UTF8");
            this.debugLog = Logger.getLogger("debugLogger");
            this.debugLog.setUseParentHandlers(false);
            this.debugLog.addHandler(this.debugHandler);
            logging = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mainLog(String s) {
        if (logging) {
            this.mainLog.info(s);
            this.mainHandler.flush();
        }
    }

    public void factionLog(String s, String LogName) {
        this.factionLog = Logger.getLogger(LogName);
        this.factionLog.info(s);
        this.factionLog.getHandlers()[0].flush();
    }

    public void gameLog(String s) {
        if (logging) {
            this.gameLog.info(s);
            this.gameHandler.flush();
        }
    }

    public void resultsLog(String s) {
        if (logging) {
            this.resultsLog.info(s);
            this.resultsHandler.flush();
        }
    }

    public void cmdLog(String s) {
        String lower;
        if (logging && (lower = s.toLowerCase()).indexOf("hm#") == -1 && lower.indexOf("factionmail#") == -1) {
            this.cmdLog.info(s);
            this.cmdHandler.flush();
        }
    }

    public void pmLog(String s) {
        if (logging) {
            this.pmLog.info(s);
            this.pmHandler.flush();
        }
    }

    public void bmLog(String s) {
        if (logging) {
            this.bmLog.info(s);
            this.bmHandler.flush();
        }
    }

    public void infoLog(String s) {
        if (logging) {
            this.infoLog.info(s);
            this.infoHandler.flush();
        }
    }

    public void log(String s) {
        if (logging) {
            this.infoLog.info(s);
            this.infoHandler.flush();
        }
    }

    public void warnLog(String s) {
        if (logging) {
            this.warnLog.info(s);
            this.warnHandler.flush();
        }
    }

    public void errLog(String s) {
        if (logging) {
            this.errLog.info(s);
            this.errHandler.flush();
            if (isServer && CampaignMain.cm != null) {
                CampaignMain.cm.doSendErrLog(s);
            }
        }
    }

    public void errLog(Exception e) {
        if (logging) {
            this.errLog.warning("[" + e.toString() + "]");
            this.errHandler.flush();
            if (isServer && CampaignMain.cm != null) {
                CampaignMain.cm.doSendErrLog("[" + e.toString() + "]");
            }
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                this.errLog.warning("   " + t[i].toString());
                this.errHandler.flush();
                if (!isServer || CampaignMain.cm == null) continue;
                CampaignMain.cm.doSendErrLog("   " + t[i].toString());
            }
        }
    }

    public void debugLog(String s) {
        if (logging) {
            this.debugLog.info(s);
            this.debugHandler.flush();
        }
    }

    public void debugLog(Exception e) {
        if (logging) {
            this.debugLog.warning("[" + e.toString() + "]");
            this.debugHandler.flush();
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                this.debugLog.warning("   " + t[i].toString());
                this.debugHandler.flush();
                if (!isServer || CampaignMain.cm == null) continue;
                CampaignMain.cm.doSendErrLog("   " + t[i].toString());
            }
        }
    }

    public void modLog(String s) {
        if (logging) {
            this.modLog.info(s);
            this.modHandler.flush();
        }
    }

    public void tickLog(String s) {
        if (logging) {
            this.tickLog.info(s);
            this.tickHandler.flush();
        }
    }

    public void ipLog(String s) {
        if (logging) {
            this.ipLog.info(s);
            this.ipHandler.flush();
        }
    }

    public void dbLog(String s) {
        if (logging) {
            this.dbLog.info(s);
            this.dbHandler.flush();
        }
    }

    public void dbLog(Exception e) {
        if (logging) {
            this.dbLog.warning("[" + e.toString() + "]");
            this.dbHandler.flush();
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                this.dbLog.warning("   " + t[i].toString());
                this.dbHandler.flush();
                if (!isServer || CampaignMain.cm == null) continue;
                CampaignMain.cm.doSendErrLog("   " + t[i].toString());
            }
        }
    }

    public void enableSeconds(boolean b) {
        addSeconds = b;
    }

    public void enableLogging(boolean b) {
        logging = b;
    }

    public void setServer(boolean b) {
        isServer = b;
    }

    public void createFactionLogger(String logName) {
        try {
            this.factionHandler = new FileHandler(this.logDir.getPath() + "/" + logName, 5000000, 5, true);
            this.factionHandler.setLevel(Level.INFO);
            this.factionHandler.setFilter(null);
            this.factionHandler.setFormatter(this.mmnetFormatter);
            this.factionLog = Logger.getLogger(logName);
            this.factionLog.setUseParentHandlers(false);
            this.factionLog.addHandler(this.factionHandler);
            this.factionLog.info(logName + " log touched");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class MMNetFormatter
    extends SimpleFormatter {
        public String format(LogRecord record) {
            GregorianCalendar now = new GregorianCalendar();
            now.setTimeInMillis(record.getMillis());
            StringBuilder sb = new StringBuilder();
            DecimalFormat mills = new DecimalFormat("000");
            DecimalFormat secs = new DecimalFormat("00");
            sb.append(now.get(1));
            sb.append(secs.format(now.get(2) + 1));
            sb.append(secs.format(now.get(5)));
            sb.append(" ");
            sb.append(now.get(11));
            sb.append(":");
            sb.append(secs.format(now.get(12)));
            if (addSeconds) {
                sb.append(":");
                sb.append(secs.format(now.get(13)));
                sb.append(".");
                sb.append(mills.format(now.get(14)));
                sb.append(" ");
                sb.append(this.formatMessage(record));
                sb.append("\n");
            } else {
                sb.append(" ");
                sb.append(this.formatMessage(record) + "\n");
            }
            return sb.toString();
        }
    }
}

