/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.CampaignData;
import common.util.UnitUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitComponents {
    Hashtable<String, Integer> components = new Hashtable();

    public String tableizeComponents() {
        return this.tableizeComponents(this.components);
    }

    public static Comparator<? super Object> stringComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = ((String)o1).toLowerCase();
                String s2 = ((String)o2).toLowerCase();
                return s1.compareTo(s2);
            }
        };
    }

    public String tableizeComponents(Hashtable<String, Integer> parts) {
        StringBuffer result = new StringBuffer();
        Comparator<? super Object> stringCompare = UnitComponents.stringComparator();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        for (String key : parts.keySet()) {
            keys.put(UnitComponents.getName(key), key);
        }
        Vector equipment = new Vector(keys.keySet());
        Collections.sort(equipment, stringCompare);
        result.append("<table><tr><th>Component</th><th># of Crits</th><th>Tech</th><th>Component</th><th># of Crits</th><th>Tech</th></tr>");
        result.append("<tr><td>");
        for (int pos = 0; pos < equipment.size(); ++pos) {
            String key = (String)equipment.get(pos);
            result.append(key);
            result.append("</td><td>");
            result.append(parts.get(keys.get(key)));
            result.append("</td><td>");
            result.append(UnitComponents.getTech((String)keys.get(key)));
            if (pos % 2 == 1) {
                result.append("</td></tr>");
                result.append("<tr><td>");
                continue;
            }
            result.append("</td><td>");
        }
        result.append("</table>");
        return result.toString();
    }

    public String toString(String token) {
        StringBuffer result = new StringBuffer();
        if (this.components.size() < 1) {
            return token + " " + token;
        }
        for (String key : this.components.keySet()) {
            if (this.components.get(key) < 1) continue;
            result.append(key);
            result.append(token);
            result.append(this.components.get(key));
            result.append(token);
        }
        return result.toString();
    }

    public void fromString(String data, String token) {
        StringTokenizer st = new StringTokenizer(data, token);
        try {
            this.components.clear();
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (!st.hasMoreElements()) {
                    return;
                }
                int value = Integer.parseInt(st.nextToken());
                this.components.put(key, value);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void fromString(StringTokenizer st) {
        try {
            this.components.clear();
            while (st.hasMoreTokens()) {
                this.components.put(st.nextToken(), Integer.parseInt(st.nextToken()));
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void add(String part, int amount) {
        if (amount < 1) {
            return;
        }
        if (this.components.containsKey(part)) {
            this.components.put(part, Math.max(0, this.components.get(part) + amount));
        } else {
            this.components.put(part, amount);
        }
    }

    public void add(Hashtable<String, Integer> parts) {
        for (String part : parts.keySet()) {
            if (this.components.containsKey(part)) {
                this.components.put(part, this.components.get(part) + parts.get(part));
                continue;
            }
            this.components.put(part, parts.get(part));
        }
    }

    public String canRepodUnit(Entity mainUnit, Entity repodUnit) {
        String ammoName;
        Mounted mount;
        CriticalSlot crit;
        int slot;
        int location;
        Hashtable<String, Integer> mainUnitParts = new Hashtable<String, Integer>();
        Hashtable<String, Integer> repodUnitParts = new Hashtable<String, Integer>();
        int IS = 0;
        int armor = 0;
        int rear = 0;
        String part = "";
        for (location = 0; location < mainUnit.locations(); ++location) {
            IS += Math.max(0, mainUnit.getInternal(location));
            armor += Math.max(0, mainUnit.getArmor(location));
            rear += Math.max(0, mainUnit.getArmor(location, true));
            for (slot = 0; slot < mainUnit.getNumberOfCriticals(location); ++slot) {
                crit = mainUnit.getCritical(location, slot);
                if (crit == null || crit.isDamaged()) continue;
                part = UnitUtils.getCritName(mainUnit, slot, location, false);
                if (part.equalsIgnoreCase("Ammo Bin")) {
                    mount = mainUnit.getEquipment(crit.getIndex());
                    ammoName = mount.getType().getInternalName();
                    if (mainUnitParts.containsKey(ammoName)) {
                        mainUnitParts.put(ammoName, (Integer)mainUnitParts.get(ammoName) + mount.getShotsLeft());
                    } else {
                        mainUnitParts.put(ammoName, mount.getShotsLeft());
                    }
                    if (mainUnitParts.containsKey(part)) {
                        mainUnitParts.put(part, (Integer)mainUnitParts.get(part) + 1);
                        continue;
                    }
                    mainUnitParts.put(part, 1);
                    continue;
                }
                if (mainUnitParts.containsKey(part)) {
                    mainUnitParts.put(part, (Integer)mainUnitParts.get(part) + 1);
                    continue;
                }
                mainUnitParts.put(part, 1);
            }
        }
        part = UnitUtils.getCritName(mainUnit, 13, 0, true);
        mainUnitParts.put(part, armor + rear);
        part = UnitUtils.getCritName(mainUnit, 15, 0, true);
        mainUnitParts.put(part, IS);
        IS = 0;
        armor = 0;
        rear = 0;
        for (location = 0; location < mainUnit.locations(); ++location) {
            IS += Math.max(0, repodUnit.getInternal(location));
            armor += Math.max(0, repodUnit.getArmor(location));
            rear += Math.max(0, repodUnit.getArmor(location, true));
            for (slot = 0; slot < repodUnit.getNumberOfCriticals(location); ++slot) {
                crit = repodUnit.getCritical(location, slot);
                if (crit == null) continue;
                part = UnitUtils.getCritName(repodUnit, slot, location, false);
                if (part.equalsIgnoreCase("Ammo Bin")) {
                    mount = repodUnit.getEquipment(crit.getIndex());
                    ammoName = mount.getType().getInternalName();
                    if (repodUnitParts.containsKey(ammoName)) {
                        repodUnitParts.put(ammoName, (Integer)repodUnitParts.get(ammoName) + mount.getShotsLeft());
                    } else {
                        repodUnitParts.put(ammoName, mount.getShotsLeft());
                    }
                    if (repodUnitParts.containsKey(part)) {
                        repodUnitParts.put(part, (Integer)repodUnitParts.get(part) + 1);
                        continue;
                    }
                    repodUnitParts.put(part, 1);
                    continue;
                }
                if (repodUnitParts.containsKey(part)) {
                    repodUnitParts.put(part, (Integer)repodUnitParts.get(part) + 1);
                    continue;
                }
                repodUnitParts.put(part, 1);
            }
        }
        part = UnitUtils.getCritName(repodUnit, 13, 0, true);
        repodUnitParts.put(part, armor + rear);
        part = UnitUtils.getCritName(repodUnit, 15, 0, true);
        repodUnitParts.put(part, IS);
        StringBuilder result = new StringBuilder("<table><tr>");
        int count = 0;
        boolean missingCrits = false;
        for (String key : repodUnitParts.keySet()) {
            if (!this.components.containsKey(key) && !mainUnitParts.containsKey(key)) {
                missingCrits = true;
                result.append("<td>");
                result.append(repodUnitParts.get(key) + " of " + UnitComponents.getName(key));
                result.append("</td>");
                if (count++ % 4 != 3) continue;
                result.append("</tr><tr>");
                continue;
            }
            int partAmount = 0;
            if (this.components.containsKey(key)) {
                partAmount += this.components.get(key).intValue();
            }
            if (mainUnitParts.containsKey(key)) {
                partAmount += ((Integer)mainUnitParts.get(key)).intValue();
            }
            if (partAmount >= (Integer)repodUnitParts.get(key)) continue;
            missingCrits = true;
            result.append("<td>");
            result.append(Integer.toString((Integer)repodUnitParts.get(key) - partAmount) + " of " + UnitComponents.getName(key));
            result.append("</td>");
            if (count++ % 4 != 3) continue;
            result.append("</tr><tr>");
        }
        result.append("</table>");
        if (!missingCrits) {
            return "";
        }
        return result.toString();
    }

    public boolean repodUnit(Entity mainUnit, Entity repodUnit) {
        Mounted mount;
        CriticalSlot crit;
        int slot;
        int location;
        Hashtable<String, Integer> repodUnitParts = new Hashtable<String, Integer>();
        int IS = 0;
        int armor = 0;
        int rear = 0;
        String part = "";
        for (location = 0; location < mainUnit.locations(); ++location) {
            IS += Math.max(0, mainUnit.getInternal(location));
            armor += Math.max(0, mainUnit.getArmor(location));
            rear += Math.max(0, mainUnit.getArmor(location, true));
            for (slot = 0; slot < mainUnit.getNumberOfCriticals(location); ++slot) {
                crit = mainUnit.getCritical(location, slot);
                if (crit == null || crit.isDamaged()) continue;
                part = UnitUtils.getCritName(mainUnit, slot, location, false);
                if (part.indexOf("Ammo") > -1) {
                    mount = mainUnit.getEquipment(crit.getIndex());
                    this.add(part, mount.getShotsLeft());
                    this.add("Ammo Bin", 1);
                    continue;
                }
                this.add(part, 1);
            }
        }
        part = UnitUtils.getCritName(mainUnit, 13, 0, true);
        this.add(part, armor + rear);
        part = UnitUtils.getCritName(mainUnit, 15, 0, true);
        this.add(part, IS);
        IS = 0;
        armor = 0;
        rear = 0;
        for (location = 0; location < mainUnit.locations(); ++location) {
            IS += Math.max(0, repodUnit.getInternal(location));
            armor += Math.max(0, repodUnit.getArmor(location));
            rear += Math.max(0, repodUnit.getArmor(location, true));
            for (slot = 0; slot < repodUnit.getNumberOfCriticals(location); ++slot) {
                crit = repodUnit.getCritical(location, slot);
                if (crit == null) continue;
                part = UnitUtils.getCritName(repodUnit, slot, location, false);
                if (part.indexOf("Ammo") > -1) {
                    mount = repodUnit.getEquipment(crit.getIndex());
                    if (repodUnitParts.containsKey(part)) {
                        repodUnitParts.put(part, (Integer)repodUnitParts.get(part) + mount.getShotsLeft());
                    } else {
                        repodUnitParts.put(part, mount.getShotsLeft());
                    }
                    if (repodUnitParts.containsKey("Ammo Bin")) {
                        repodUnitParts.put("Ammo Bin", (Integer)repodUnitParts.get("Ammo Bin") + 1);
                        continue;
                    }
                    repodUnitParts.put("Ammo Bin", 1);
                    continue;
                }
                if (repodUnitParts.containsKey(part)) {
                    repodUnitParts.put(part, (Integer)repodUnitParts.get(part) + 1);
                    continue;
                }
                repodUnitParts.put(part, 1);
            }
        }
        part = UnitUtils.getCritName(repodUnit, 13, 0, true);
        repodUnitParts.put(part, armor + rear);
        part = UnitUtils.getCritName(repodUnit, 15, 0, true);
        repodUnitParts.put(part, IS);
        for (String key : repodUnitParts.keySet()) {
            this.remove(key, (Integer)repodUnitParts.get(key));
        }
        return true;
    }

    public int getPartsCritCount(String key) {
        if (this.components.get(key) == null) {
            return 0;
        }
        return this.components.get(key);
    }

    public boolean hasEnoughCrits(String crit, int amount) {
        if (this.components.get(crit) == null) {
            return false;
        }
        return this.components.get(crit) >= amount;
    }

    public void remove(String key, int amount) {
        if (this.components.get(key) == null) {
            return;
        }
        int parts = this.components.get(key);
        if ((parts -= Math.abs(amount)) <= 0) {
            this.components.remove(key);
        } else {
            this.components.put(key, parts);
        }
    }

    public static String getTech(String crit) {
        EquipmentType eq = EquipmentType.get(crit);
        if (eq == null) {
            return "All";
        }
        if (UnitUtils.isClanEQ(eq)) {
            return "Clan";
        }
        if (eq.getTechLevel() == 11 || eq.getTechLevel() <= 4) {
            return "All";
        }
        return "IS";
    }

    public static String getName(String crit) {
        EquipmentType eq = EquipmentType.get(crit);
        if (eq == null) {
            return crit;
        }
        return eq.getName();
    }

    public void clear() {
        this.components.clear();
    }
}

