/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.CampaignData;
import common.MegaMekPilotOption;
import common.Unit;
import java.util.Iterator;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.Tank;

public class UnitUtils {
    public static final int STANDARD_ENGINE = 0;
    public static final int IS_LIGHT_ENGINE = 1;
    public static final int IS_XL_ENGINE = 2;
    public static final int IS_XXL_ENGINE = 3;
    public static final int CLAN_XL_ENGINE = 4;
    public static final int CLAN_XXL_ENGINE = 5;
    public static final String[] ENGINE_SHORT_STRING = new String[]{"Standard Engine", "Light Engine", "XL Engine", "XXL Engine", "XL Engine", "XXL Engine"};
    public static final String[] ENGINE_TECH_STRING = new String[]{"Standard Engine", "IS Light Engine", "IS XL Engine", "IS XXL Engine", "Clan XL Engine", "Clan XXL Engine"};
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    public static final int LOC_CTR = 8;
    public static final int LOC_RTR = 9;
    public static final int LOC_LTR = 10;
    public static final int LOC_FRONT_ARMOR = 13;
    public static final int LOC_REAR_ARMOR = 14;
    public static final int LOC_INTERNAL_ARMOR = 15;
    public static final int TECH_GREEN = 0;
    public static final int TECH_REG = 1;
    public static final int TECH_VET = 2;
    public static final int TECH_ELITE = 3;
    public static final int TECH_PILOT = 4;
    public static final int TECH_REWARD_POINTS = 5;
    public static final int ARMOR = 1;
    public static final int INTERNAL = 2;
    public static final int WEAPONS = 3;
    public static final int EQUIPMENT = 4;
    public static final int SYSTEMS = 5;
    public static final int ENGINES = 6;

    public static String unitBattleDamage(Entity unit) {
        return UnitUtils.unitBattleDamage(unit, true);
    }

    public static String unitBattleDamage(Entity unit, boolean sendAmmo) {
        if (unit instanceof Mech) {
            return UnitUtils.mekBattleDamage(unit, sendAmmo);
        }
        if (unit instanceof Tank) {
            return UnitUtils.tankBattleDamage(unit, sendAmmo);
        }
        return "%%-%%-%%";
    }

    public static String tankBattleDamage(Entity unit, boolean sendAmmo) {
        StringBuilder result = new StringBuilder();
        String delimiter = "-";
        String delimiter2 = "%";
        boolean hasData = false;
        try {
            int loc;
            for (loc = 0; loc <= 5; ++loc) {
                if (unit.getArmor(loc) == unit.getOArmor(loc)) continue;
                hasData = true;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getArmor(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(loc));
                }
                result.append(delimiter2);
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (loc = 0; loc <= 5; ++loc) {
                if (unit.getInternal(loc) == unit.getOInternal(loc)) continue;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getInternal(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getInternal(loc));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (int x = 0; x < unit.locations(); ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null || UnitUtils.isNonRepairableCrit(unit, cs)) continue;
                    if (cs.isRepairing()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("!");
                        result.append(delimiter2);
                        hasData = true;
                    }
                    if (cs.isDamaged() && UnitUtils.isDestroyedOrDamaged(unit, cs)) {
                        cs.setMissing(true);
                    }
                    if (cs.isMissing()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("@");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (cs.isDamaged()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("^");
                        result.append(delimiter2);
                        hasData = true;
                    }
                    if (!cs.isBreached()) continue;
                    result.append(x);
                    result.append(delimiter2);
                    result.append(y);
                    result.append(delimiter2);
                    result.append("X");
                    result.append(delimiter2);
                    hasData = true;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            if (sendAmmo) {
                int location = 0;
                for (Mounted weap : unit.getAmmo()) {
                    if (weap.isDestroyed()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(0);
                        result.append(delimiter2);
                    } else if (weap.getShotsLeft() != ((AmmoType)weap.getType()).getShots()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(Math.max(0, weap.getShotsLeft()));
                        result.append(delimiter2);
                    }
                    ++location;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Entity: " + unit.getShortNameRaw());
            CampaignData.mwlog.errLog(ex);
            return "%%-%%-%%";
        }
        return result.toString();
    }

    public static String mekBattleDamage(Entity unit, boolean sendAmmo) {
        StringBuilder result = new StringBuilder();
        String delimiter = "-";
        String delimiter2 = "%";
        boolean hasData = false;
        try {
            int loc;
            for (loc = 0; loc <= 7; ++loc) {
                if (unit.getArmor(loc) == unit.getOArmor(loc)) continue;
                hasData = true;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getArmor(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(loc));
                }
                result.append(delimiter2);
            }
            if (unit.getArmor(1, true) != unit.getOArmor(1, true)) {
                result.append(8);
                result.append(delimiter2);
                if (unit.getArmor(1, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(1, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (unit.getArmor(3, true) != unit.getOArmor(3, true)) {
                result.append(10);
                result.append(delimiter2);
                if (unit.getArmor(3, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(3, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (unit.getArmor(2, true) != unit.getOArmor(2, true)) {
                result.append(9);
                result.append(delimiter2);
                if (unit.getArmor(2, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(2, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (loc = 0; loc <= 7; ++loc) {
                if (unit.getInternal(loc) == unit.getOInternal(loc)) continue;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getInternal(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getInternal(loc));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (int x = 0; x < unit.locations(); ++x) {
                int shieldHitsLeft = -1;
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null || UnitUtils.isNonRepairableCrit(unit, cs)) continue;
                    Mounted m = unit.getEquipment(cs.getIndex());
                    if (m != null && m.getType() instanceof MiscType && ((MiscType)m.getType()).isShield() && m.getBaseDamageCapacity() != m.getCurrentDamageCapacity(unit, x) && shieldHitsLeft == -1 && (x == 5 || x == 4)) {
                        float shieldcrits = Math.max(1, UnitUtils.getNumberOfCrits(unit, cs));
                        float basePoints = m.getBaseDamageCapacity();
                        float currentPoints = m.getCurrentDamageCapacity(unit, x);
                        float tempHits = 0.0f;
                        tempHits = shieldcrits / basePoints;
                        tempHits *= currentPoints;
                        tempHits = Math.abs(tempHits - shieldcrits);
                        shieldHitsLeft = Math.max(1, Math.round(tempHits));
                    }
                    if (cs.isRepairing()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("!");
                        result.append(delimiter2);
                        hasData = true;
                    }
                    if (cs.isDamaged() && UnitUtils.isDestroyedOrDamaged(unit, cs)) {
                        cs.setMissing(true);
                    }
                    if (cs.isMissing()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("@");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (cs.isDamaged()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("^");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (cs.isBreached()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("X");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (m == null || !(m.getType() instanceof MiscType) || !((MiscType)m.getType()).isShield() || x != 5 && x != 4 || shieldHitsLeft <= 0) continue;
                    result.append(x);
                    result.append(delimiter2);
                    result.append(y);
                    result.append(delimiter2);
                    result.append("^");
                    result.append(delimiter2);
                    hasData = true;
                    --shieldHitsLeft;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            if (sendAmmo) {
                int location = 0;
                for (Mounted weap : unit.getAmmo()) {
                    if (weap.isDestroyed()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(0);
                        result.append(delimiter2);
                    } else if (weap.getShotsLeft() != ((AmmoType)weap.getType()).getShots()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(Math.max(0, weap.getShotsLeft()));
                        result.append(delimiter2);
                    }
                    ++location;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Entity: " + unit.getShortNameRaw());
            CampaignData.mwlog.errLog(ex);
            return "%%-%%-%%";
        }
        return result.toString();
    }

    public static void applyBattleDamage(Entity unit, String report) {
        UnitUtils.applyBattleDamage(unit, report, true);
    }

    public static void applyTankBattleDamage(Entity unit, String report, boolean isRepairing) {
        int armor;
        int location;
        StringTokenizer entry = new StringTokenizer(report, "-");
        StringTokenizer externalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer internalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer crits = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer ammo = null;
        if (entry.hasMoreTokens()) {
            ammo = new StringTokenizer(entry.nextToken(), "%");
        }
        while (externalArmor.hasMoreTokens()) {
            location = Integer.parseInt(externalArmor.nextToken());
            armor = Integer.parseInt(externalArmor.nextToken());
            unit.setArmor(armor, location);
            if (isRepairing) continue;
            UnitUtils.removeArmorRepair(unit, 13, location);
        }
        while (internalArmor.hasMoreTokens()) {
            location = Integer.parseInt(internalArmor.nextToken());
            armor = Integer.parseInt(internalArmor.nextToken());
            if (armor <= 0) {
                armor = -3;
            }
            unit.setInternal(armor, location);
            if (isRepairing) continue;
            UnitUtils.removeArmorRepair(unit, 15, location);
        }
        while (crits.hasMoreTokens()) {
            Mounted mounted;
            location = Integer.parseInt(crits.nextToken());
            int slot = Integer.parseInt(crits.nextToken());
            String damageType = crits.nextToken();
            CriticalSlot critSlot = unit.getCritical(location, slot);
            if (damageType.equals("@")) {
                critSlot.setMissing(true);
                if (critSlot.getType() == 1 && (mounted = unit.getEquipment(critSlot.getIndex())).getShotsLeft() > 0) {
                    mounted.setShotsLeft(0);
                }
            }
            if (damageType.equals("^")) {
                critSlot.setDestroyed(true);
                if (critSlot.getType() == 1 && (mounted = unit.getEquipment(critSlot.getIndex())).getShotsLeft() > 0) {
                    mounted.setShotsLeft(0);
                }
            }
            if (damageType.equals("!") && isRepairing) {
                critSlot.setRepairing(true);
                if (!critSlot.isBreached() && !critSlot.isDamaged()) {
                    critSlot.setDestroyed(true);
                    if (critSlot.getType() == 1 && (mounted = unit.getEquipment(critSlot.getIndex())).getShotsLeft() > 0) {
                        mounted.setShotsLeft(0);
                    }
                }
            }
            if (damageType.equals("X")) {
                critSlot.setBreached(true);
            }
            unit.setCritical(location, slot, critSlot);
        }
        if (ammo != null && ammo.hasMoreTokens()) {
            int locationCount = 0;
            Iterator<Mounted> munitions = unit.getAmmo().iterator();
            if (munitions.hasNext()) {
                Mounted weapon = munitions.next();
                try {
                    while (ammo.hasMoreTokens()) {
                        int location2 = Integer.parseInt(ammo.nextToken());
                        int ammoLeft = Integer.parseInt(ammo.nextToken());
                        while (location2 != locationCount) {
                            weapon = munitions.next();
                            ++locationCount;
                        }
                        weapon.setShotsLeft(ammoLeft);
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Error while parsing ammo Moving along");
                }
            }
        }
    }

    public static void applyBattleDamage(Entity unit, String report, boolean isRepairing) {
        int armor;
        int location;
        if (unit instanceof Tank) {
            UnitUtils.applyTankBattleDamage(unit, report, isRepairing);
            return;
        }
        if (unit instanceof Protomech || unit instanceof Infantry) {
            return;
        }
        StringTokenizer entry = new StringTokenizer(report, "-");
        StringTokenizer externalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer internalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer crits = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer ammo = null;
        if (entry.hasMoreTokens()) {
            ammo = new StringTokenizer(entry.nextToken(), "%");
        }
        while (externalArmor.hasMoreTokens()) {
            location = Integer.parseInt(externalArmor.nextToken());
            armor = Integer.parseInt(externalArmor.nextToken());
            if (location >= 8) {
                unit.setArmor(armor, location - 7, true);
                if (isRepairing) continue;
                UnitUtils.removeArmorRepair(unit, 14, location - 7);
                continue;
            }
            unit.setArmor(armor, location);
            if (isRepairing) continue;
            UnitUtils.removeArmorRepair(unit, 13, location);
        }
        while (internalArmor.hasMoreTokens()) {
            location = Integer.parseInt(internalArmor.nextToken());
            armor = Integer.parseInt(internalArmor.nextToken());
            if (armor <= 0) {
                armor = -3;
            }
            unit.setInternal(armor, location);
            if (isRepairing) continue;
            UnitUtils.removeArmorRepair(unit, 15, location);
        }
        while (crits.hasMoreTokens()) {
            try {
                Mounted mounted;
                int location2 = Integer.parseInt(crits.nextToken());
                int slot = Integer.parseInt(crits.nextToken());
                String damageType = crits.nextToken();
                CriticalSlot critSlot = unit.getCritical(location2, slot);
                if (damageType.equals("@")) {
                    critSlot.setMissing(true);
                    if (critSlot.getType() == 1) {
                        mounted = unit.getEquipment(critSlot.getIndex());
                        mounted.setMissing(true);
                        if (mounted.getShotsLeft() > 0) {
                            mounted.setShotsLeft(0);
                        }
                    }
                }
                if (damageType.equals("^")) {
                    critSlot.setDestroyed(true);
                    if (critSlot.getType() == 1) {
                        mounted = unit.getEquipment(critSlot.getIndex());
                        mounted.setDestroyed(true);
                        if (mounted.getShotsLeft() > 0) {
                            mounted.setShotsLeft(0);
                        }
                    }
                }
                if (damageType.equals("!") && isRepairing) {
                    critSlot.setRepairing(true);
                    if (!critSlot.isBreached() && !critSlot.isDamaged()) {
                        critSlot.setDestroyed(true);
                        if (critSlot.getType() == 1) {
                            mounted = unit.getEquipment(critSlot.getIndex());
                            mounted.setDestroyed(true);
                            if (mounted.getShotsLeft() > 0) {
                                mounted.setShotsLeft(0);
                            }
                        }
                    }
                }
                if (damageType.equals("X")) {
                    critSlot.setBreached(true);
                    if (critSlot.getType() == 1) {
                        mounted = unit.getEquipment(critSlot.getIndex());
                        mounted.setBreached(true);
                    }
                }
                unit.setCritical(location2, slot, critSlot);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        if (ammo != null && ammo.hasMoreTokens()) {
            int locationCount = 0;
            Iterator<Mounted> munitions = unit.getAmmo().iterator();
            if (munitions.hasNext()) {
                Mounted weapon = munitions.next();
                try {
                    while (ammo.hasMoreTokens()) {
                        int location3 = Integer.parseInt(ammo.nextToken());
                        int ammoLeft = Integer.parseInt(ammo.nextToken());
                        while (location3 != locationCount) {
                            weapon = munitions.next();
                            ++locationCount;
                        }
                        weapon.setShotsLeft(ammoLeft);
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Error while parsing ammo Moving along");
                }
            }
        }
    }

    public static boolean canStartUp(Entity unit) {
        int engineHits = 0;
        if (!(unit instanceof Mech)) {
            return true;
        }
        if (unit.getInternal(0) <= 0) {
            return false;
        }
        if (unit.getBadCriticals(0, 2, 0) > 0) {
            return false;
        }
        engineHits = UnitUtils.getNumberOfDamagedEngineCrits(unit);
        return engineHits < 3;
    }

    public static boolean hasArmorDamage(Entity unit) {
        return unit.getTotalArmor() != unit.getTotalOArmor() || unit.getTotalInternal() != unit.getTotalOInternal();
    }

    public static boolean hasISDamage(Entity unit) {
        return unit.getTotalInternal() != unit.getTotalOInternal();
    }

    public static boolean hasCriticalDamage(Entity unit) {
        if (unit instanceof Mech || unit instanceof Tank) {
            for (int x = 0; x < unit.locations(); ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null || !cs.isDamaged() && !cs.isBreached()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasUndamagedCriticals(Entity unit, int location) {
        if (unit instanceof Mech || unit instanceof Tank) {
            for (int y = 0; y < unit.getNumberOfCriticals(location); ++y) {
                CriticalSlot cs = unit.getCritical(location, y);
                if (cs == null || cs.isDamaged() || UnitUtils.isNonRepairableCrit(unit, cs)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCriticalsUnderRepair(Entity unit, int location) {
        if (unit instanceof Mech || unit instanceof Tank) {
            for (int y = 0; y < unit.getNumberOfCriticals(location); ++y) {
                CriticalSlot cs = unit.getCritical(location, y);
                if (cs == null || !cs.isRepairing()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRepairing(Entity unit) {
        if (unit instanceof Mech || unit instanceof Tank) {
            for (int x = 0; x < unit.locations(); ++x) {
                if (unit.getArmor(x) > unit.getOArmor(x)) {
                    return true;
                }
                if (unit.hasRearArmor(x) && unit.getArmor(x, true) > unit.getOArmor(x, true)) {
                    return true;
                }
                if (unit.getInternal(x) > unit.getOInternal(x)) {
                    return true;
                }
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null || !cs.isRepairing()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getNumberOfEngineCrits(Entity unit) {
        int engines = 0;
        if (unit instanceof Mech) {
            for (int x = 1; x <= 3; ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (!UnitUtils.isEngineCrit(cs)) continue;
                    ++engines;
                }
            }
        } else {
            engines = 6;
        }
        return engines;
    }

    public static void destroyAllEngineCrits(Entity unit) {
        if (unit instanceof Mech) {
            for (int x = 1; x <= 3; ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (!UnitUtils.isEngineCrit(cs)) continue;
                    UnitUtils.salvageCriticalSlot(cs, unit);
                }
            }
        }
    }

    public static int getEngineType(Entity unit) {
        int engineNumber = UnitUtils.getNumberOfEngineCrits(unit);
        if (unit instanceof Mech) {
            if (unit.isClan()) {
                if (engineNumber == 12) {
                    return 5;
                }
                if (engineNumber == 10) {
                    return 4;
                }
            } else {
                if (engineNumber == 18) {
                    return 3;
                }
                if (engineNumber == 12) {
                    return 2;
                }
                if (engineNumber == 10) {
                    return 1;
                }
            }
        }
        return 0;
    }

    public static int getNumberOfDamagedEngineCrits(Entity unit) {
        int engineHits = 0;
        for (int x = 1; x <= 3; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs) || !cs.isBreached() && !cs.isDamaged()) continue;
                ++engineHits;
            }
        }
        return engineHits;
    }

    public static void repairEquipment(Mounted eq, Entity unit, int location) {
        if (eq.isSplit()) {
            UnitUtils.repairSplitEquipment(eq, unit);
            return;
        }
        for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
            Mounted mounted;
            CriticalSlot crit = unit.getCritical(location, slot);
            if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex()))) continue;
            UnitUtils.fixCriticalSlot(crit, unit, crit.isBreached());
            unit.setCritical(location, slot, crit);
        }
    }

    public static void salvageCriticalSlot(CriticalSlot cs, Entity unit) {
        if (cs.getType() == 1) {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            mounted.setDestroyed(true);
            mounted.setMissing(true);
            mounted.setHit(true);
            mounted.setBreached(false);
        }
        cs.setDestroyed(true);
        cs.setHit(true);
        cs.setMissing(true);
        cs.setRepairing(false);
        cs.setBreached(false);
    }

    public static void salvageEquipment(Mounted eq, Entity unit, int location) {
        if (eq.isSplit()) {
            UnitUtils.salvageSplitEquipment(eq, unit);
            return;
        }
        for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
            Mounted mounted;
            CriticalSlot crit = unit.getCritical(location, slot);
            if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex()))) continue;
            UnitUtils.salvageCriticalSlot(crit, unit);
            unit.setCritical(location, slot, crit);
        }
    }

    public static void salvageSplitEquipment(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null || cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex()))) continue;
                UnitUtils.salvageCriticalSlot(cs, unit);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void salvageSystemCrit(int location, CriticalSlot cs, Entity unit) {
        if (cs.getIndex() >= 0 && cs.getIndex() <= 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                CriticalSlot crit = unit.getCritical(location, slot);
                if (crit == null || crit.getIndex() != cs.getIndex()) continue;
                UnitUtils.salvageCriticalSlot(crit, unit);
            }
        } else {
            UnitUtils.salvageCriticalSlot(cs, unit);
        }
    }

    public static void repairDamagedEngine(Entity unit) {
        for (int x = 0; x < unit.locations(); ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs)) continue;
                UnitUtils.fixCriticalSlot(cs, unit, cs.isBreached());
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void repairSplitEquipment(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null || cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex()))) continue;
                UnitUtils.fixCriticalSlot(cs, unit, cs.isBreached());
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void repairSystemCrit(int location, CriticalSlot cs, Entity unit) {
        if (cs.getIndex() >= 0 && cs.getIndex() <= 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                CriticalSlot crit = unit.getCritical(location, slot);
                if (crit == null || crit.getIndex() != cs.getIndex()) continue;
                UnitUtils.fixCriticalSlot(crit, unit, crit.isBreached());
            }
        } else {
            UnitUtils.fixCriticalSlot(cs, unit, cs.isBreached());
        }
    }

    public static void fixCriticalSlot(CriticalSlot cs, Entity unit, boolean breach) {
        if (cs.getType() == 1) {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            if (breach) {
                mounted.setBreached(false);
            } else {
                mounted.setDestroyed(false);
                mounted.setMissing(false);
                mounted.setHit(false);
            }
        }
        if (breach) {
            cs.setBreached(false);
            cs.setRepairing(false);
        } else {
            cs.setDestroyed(false);
            cs.setHit(false);
            cs.setRepairing(false);
            cs.setMissing(false);
        }
    }

    public static boolean isEngineCrit(CriticalSlot cs) {
        return cs != null && cs.getType() == 0 && cs.getIndex() == 3;
    }

    public static int getNumberOfCrits(Entity unit, int slot, int location) {
        if (slot == 13) {
            return unit.getArmor(location, false);
        }
        if (slot == 14) {
            return unit.getArmor(location, true);
        }
        if (slot == 15) {
            return unit.getInternal(location);
        }
        CriticalSlot cs = unit.getCritical(location, slot);
        return UnitUtils.getNumberOfCrits(unit, cs);
    }

    public static int getNumberOfCrits(Entity unit, CriticalSlot cs) {
        if (cs == null) {
            return 0;
        }
        int numberOfCrits = 1;
        if (UnitUtils.isEngineCrit(cs)) {
            numberOfCrits = UnitUtils.getNumberOfEngineCrits(unit);
        } else if (cs.getType() == 1) {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            numberOfCrits = mounted.getType().getCriticals(unit);
        } else {
            numberOfCrits = UnitUtils.getNumberOfSystemCriticals(unit, cs);
        }
        return Math.max(1, numberOfCrits);
    }

    public static void setRepairingSystems(Entity unit, CriticalSlot cs) {
        if (cs.getIndex() == 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(1); ++slot) {
                CriticalSlot crit = unit.getCritical(1, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                crit.setRepairing(true);
            }
        } else if (((Mech)unit).getCockpitType() == 1) {
            for (int location = 1; location <= 3; ++location) {
                for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot crit = unit.getCritical(location, slot);
                    if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                    crit.setRepairing(true);
                }
            }
        } else {
            for (int slot = 0; slot < unit.getNumberOfCriticals(0); ++slot) {
                CriticalSlot crit = unit.getCritical(0, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                crit.setRepairing(true);
            }
        }
    }

    public static int getNumberOfSystemCriticals(Entity unit, CriticalSlot cs) {
        int count = 0;
        if (cs.getIndex() > 4) {
            return 1;
        }
        if (cs.getIndex() == 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(1); ++slot) {
                CriticalSlot crit = unit.getCritical(1, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                ++count;
            }
        } else if (((Mech)unit).getCockpitType() == 1) {
            for (int location = 1; location <= 3; ++location) {
                for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot crit = unit.getCritical(location, slot);
                    if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                    ++count;
                }
            }
        } else {
            for (int slot = 0; slot < unit.getNumberOfCriticals(0); ++slot) {
                CriticalSlot crit = unit.getCritical(0, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                ++count;
            }
        }
        return count;
    }

    public static int getNumberOfDamagedSystemCriticals(Entity unit, CriticalSlot cs) {
        int count = 0;
        if (cs.getIndex() > 4) {
            if (cs.isDamaged()) {
                return 1;
            }
            return 0;
        }
        if (cs.getIndex() == 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(1); ++slot) {
                CriticalSlot crit = unit.getCritical(1, slot);
                if (crit == null || crit.getType() != 0 || !crit.isDamaged() || crit.getIndex() != cs.getIndex()) continue;
                ++count;
            }
        } else if (((Mech)unit).getCockpitType() == 1) {
            for (int location = 1; location <= 3; ++location) {
                for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot crit = unit.getCritical(location, slot);
                    if (crit == null || crit.getType() != 0 || !crit.isDamaged() || crit.getIndex() != cs.getIndex()) continue;
                    ++count;
                }
            }
        } else {
            for (int slot = 0; slot < unit.getNumberOfCriticals(0); ++slot) {
                CriticalSlot crit = unit.getCritical(0, slot);
                if (crit == null || crit.getType() != 0 || !crit.isDamaged() || crit.getIndex() != cs.getIndex()) continue;
                ++count;
            }
        }
        return count;
    }

    public static void setRepairing(Entity unit, CriticalSlot cs) {
        if (UnitUtils.isEngineCrit(cs)) {
            UnitUtils.setRepairingEngines(unit);
        } else if (cs.getType() == 0) {
            if (cs.getIndex() <= 4) {
                UnitUtils.setRepairingSystems(unit, cs);
            } else {
                cs.setRepairing(true);
            }
        } else {
            Mounted eq = unit.getEquipment(cs.getIndex());
            int location = eq.getLocation();
            if (eq.isSplit()) {
                UnitUtils.setRepairingSplit(eq, unit);
                return;
            }
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                Mounted mounted;
                CriticalSlot crit = unit.getCritical(location, slot);
                if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex()))) continue;
                crit.setRepairing(true);
            }
        }
    }

    public static void setRepairingSplit(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null || cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex()))) continue;
                cs.setRepairing(true);
            }
        }
    }

    public static boolean isNonRepairableCrit(Entity unit, CriticalSlot cs) {
        if (cs.getType() != 1) {
            return false;
        }
        try {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(1)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(9)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(4)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(6)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(5)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(7)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(2)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(3)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(8)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(1)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(4)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(2)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(3)) != -1) {
                return true;
            }
            if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(3)) != -1) {
                return true;
            }
            if (mounted.getType() instanceof MiscType && mounted.getType().hasFlag(32L)) {
                return true;
            }
            if (mounted.getType() instanceof MiscType && mounted.getType().hasFlag(8L) && unit.isClan()) {
                return true;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error in UnitUtils.isNonRepairableCrit");
            CampaignData.mwlog.errLog(ex);
            return false;
        }
        return false;
    }

    public static void setRepairingEngines(Entity unit) {
        for (int x = 0; x < unit.locations(); ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs)) continue;
                cs.setRepairing(true);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static String techDescription(int tech) {
        String result = "";
        switch (tech) {
            case 0: {
                result = "Green";
                break;
            }
            case 1: {
                result = "Reg";
                break;
            }
            case 2: {
                result = "Vet";
                break;
            }
            case 3: {
                result = "Elite";
                break;
            }
            case 4: {
                result = "Pilot";
                break;
            }
            case 5: {
                result = "Reward Points";
            }
        }
        return result;
    }

    public static int techType(String tech) {
        int techType = 0;
        if (tech.equalsIgnoreCase("regular") || tech.equalsIgnoreCase("reg")) {
            techType = 1;
        } else if (tech.equalsIgnoreCase("vet") || tech.equalsIgnoreCase("Veteran")) {
            techType = 2;
        } else if (tech.equalsIgnoreCase("Elite")) {
            techType = 3;
        } else if (tech.equalsIgnoreCase("Pilot")) {
            techType = 4;
        } else if (tech.equalsIgnoreCase("Reward Points")) {
            techType = 5;
        }
        return techType;
    }

    public static int techBaseRoll(int techType) {
        int roll = 9;
        roll = techType == 0 ? 9 : 8 - techType;
        return roll;
    }

    public static int getTechRoll(Entity unit, int location, int slot, int techType, boolean armor, int techLevel) {
        return UnitUtils.getTechRoll(unit, location, slot, techType, armor, techLevel, false);
    }

    public static int getTechRoll(Entity unit, int location, int slot, int techType, boolean armor, int techLevel, boolean salvage) {
        int roll = UnitUtils.techBaseRoll(techType);
        if (techType == 5) {
            return 1;
        }
        if (location < 0 || slot < 0) {
            return roll;
        }
        if (armor) {
            if (slot != 15) {
                --roll;
            } else {
                int armorToRepair = 0;
                if (unit.getInternal(location) > unit.getOInternal(location)) {
                    UnitUtils.removeArmorRepair(unit, 15, location);
                    armorToRepair = unit.getOInternal(location) - unit.getInternal(location);
                    UnitUtils.setArmorRepair(unit, 15, location);
                } else {
                    armorToRepair = unit.getOInternal(location) - unit.getInternal(location);
                }
                roll = unit.getInternal(location) <= 0 ? (location == 5 || location == 4 || location == 6 || location == 7 ? (roll += 2) : (location == 0 ? (roll += 3) : (roll += 4))) : (armorToRepair <= unit.getOInternal(location) / 4 ? UnitUtils.techBaseRoll(techType) : (armorToRepair <= unit.getOInternal(location) / 2 ? ++roll : (armorToRepair <= unit.getOInternal(location) * 3 / 4 ? (roll += 2) : (roll += 3))));
            }
        } else {
            CriticalSlot cs = unit.getCritical(location, slot);
            if (cs == null) {
                return roll;
            }
            if (cs.isBreached() && !salvage) {
                return 2;
            }
            if (cs.getType() == 1) {
                Mounted m = unit.getEquipment(cs.getIndex());
                if (m != null) {
                    if (!m.isDestroyed() && !m.isBreached()) {
                        return roll;
                    }
                    if (m.getDesc().indexOf("Heat Sink") > -1) {
                        --roll;
                    } else if (m.getDesc().indexOf("Jump Jet") > -1) {
                        ++roll;
                    }
                } else if (!cs.isMissing()) {
                    int crits = UnitUtils.getNumberOfCrits(unit, cs);
                    switch (crits) {
                        case 0: {
                            ++roll;
                            break;
                        }
                        case 1: {
                            roll -= 2;
                            break;
                        }
                        case 2: {
                            --roll;
                            break;
                        }
                        case 3: {
                            ++roll;
                            break;
                        }
                        default: {
                            roll += 3;
                            break;
                        }
                    }
                } else {
                    ++roll;
                }
                if (unit.isOmni() && UnitUtils.isCompatibleTech(unit, techLevel)) {
                    roll -= 4;
                }
            } else if (UnitUtils.isEngineCrit(cs)) {
                int crits = UnitUtils.getNumberOfDamagedEngineCrits(unit);
                switch (crits) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ++roll;
                        break;
                    }
                    default: {
                        roll += 3;
                        break;
                    }
                }
            } else if (cs.getIndex() == 1) {
                int crits = unit.getBadCriticals(0, 1, 0);
                if (crits >= 2 && !cs.isMissing()) {
                    roll += 4;
                } else if (crits > 0) {
                    ++roll;
                }
            } else if (cs.getIndex() == 4) {
                int crits;
                roll = cs.isMissing() ? ++roll : ((crits = unit.getBadCriticals(0, 4, 1)) == 0 ? ++roll : (crits == 1 ? (roll += 2) : (roll += 5)));
            } else if (cs.getIndex() == 0) {
                int crits;
                if (!cs.isMissing() && (crits = unit.getBadCriticals(0, 0, 0)) == 2) {
                    roll += 2;
                }
            } else if (UnitUtils.isActuator(cs)) {
                roll = cs.isMissing() ? (roll -= 2) : --roll;
            }
            if (!UnitUtils.isCompatibleTech(unit, techLevel)) {
                roll += 4;
            }
        }
        return Math.max(roll, 3);
    }

    public static boolean isActuator(CriticalSlot cs) {
        if (cs.getType() != 0) {
            return false;
        }
        return cs.getIndex() == 14 || cs.getIndex() == 10 || cs.getIndex() == 11 || cs.getIndex() == 9 || cs.getIndex() == 13 || cs.getIndex() == 7 || cs.getIndex() == 8 || cs.getIndex() == 12;
    }

    public static void removeRepairEquipment(Mounted eq, Entity unit, int location) {
        if (eq.isSplit()) {
            UnitUtils.removeRepairSplitEquipment(eq, unit);
            return;
        }
        for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
            Mounted mounted;
            CriticalSlot crit = unit.getCritical(location, slot);
            if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex())) || !crit.isRepairing()) continue;
            crit.setRepairing(false);
            unit.setCritical(location, slot, crit);
        }
    }

    public static void removeRepairing(Entity unit, CriticalSlot cs) {
        if (UnitUtils.isEngineCrit(cs)) {
            UnitUtils.removeRepairDamagedEngine(unit);
        } else if (cs.getType() == 0) {
            if (cs.getIndex() <= 4) {
                UnitUtils.removeRepairingSystems(unit, cs);
            } else {
                cs.setRepairing(false);
            }
        } else {
            Mounted eq = unit.getEquipment(cs.getIndex());
            int location = eq.getLocation();
            UnitUtils.removeRepairEquipment(eq, unit, location);
        }
    }

    public static void removeRepairingSystems(Entity unit, CriticalSlot cs) {
        if (cs.getIndex() == 4) {
            for (int slot = 0; slot < unit.getNumberOfCriticals(1); ++slot) {
                CriticalSlot crit = unit.getCritical(1, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                crit.setRepairing(false);
            }
        } else if (((Mech)unit).getCockpitType() == 1) {
            for (int location = 1; location <= 3; ++location) {
                for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot crit = unit.getCritical(location, slot);
                    if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                    crit.setRepairing(false);
                }
            }
        } else {
            for (int slot = 0; slot < unit.getNumberOfCriticals(0); ++slot) {
                CriticalSlot crit = unit.getCritical(0, slot);
                if (crit == null || crit.getType() != 0 || crit.getIndex() != cs.getIndex()) continue;
                crit.setRepairing(false);
            }
        }
    }

    public static void removeArmorRepair(Entity unit, int slot, int location) {
        if (slot < 15) {
            if (location >= 8) {
                location -= 7;
            }
            while (unit.getArmor(location, slot == 14) > unit.getOArmor(location, slot == 14)) {
                int currArmor = unit.getArmor(location, slot == 14);
                unit.setArmor(currArmor -= 99, location, slot == 14);
            }
        } else {
            while (unit.getInternal(location) > unit.getOInternal(location)) {
                int currArmor = unit.getInternal(location);
                unit.setInternal(currArmor -= 99, location);
            }
        }
    }

    public static void setArmorRepair(Entity unit, int slot, int location) {
        if (slot < 15) {
            if (location >= 8) {
                location -= 7;
            }
            while (unit.getArmor(location, slot == 14) < unit.getOArmor(location, slot == 14)) {
                int currArmor = unit.getArmor(location, slot == 14);
                unit.setArmor(currArmor += 99, location, slot == 14);
            }
        } else {
            while (unit.getInternal(location) < unit.getOInternal(location)) {
                int currArmor = unit.getInternal(location);
                unit.setInternal(currArmor += 99, location);
            }
        }
    }

    public static void removeRepairDamagedEngine(Entity unit) {
        for (int x = 0; x < unit.locations(); ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs) || !cs.isRepairing()) continue;
                cs.setRepairing(false);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void removeRepairSplitEquipment(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null || cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex())) || !cs.isRepairing()) continue;
                cs.setRepairing(false);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static int getPartCost(Entity unit, int location, int slot, boolean armor) {
        double cost = 0.0;
        if (!(unit instanceof Mech)) {
            return 0;
        }
        Mech mek = (Mech)unit;
        if (armor) {
            if (slot < 15) {
                double points = 16.0 * EquipmentType.getArmorPointMultiplier(unit.getArmorType(), unit.getArmorTechLevel());
                double costPerTon = EquipmentType.getArmorCost(unit.getArmorType());
                if (points == 0.0) {
                    points = 16.0;
                }
                cost = costPerTon / points;
                boolean rear = slot == 14;
                cost = (double)(mek.getOArmor(location, rear) - mek.getArmor(location, rear)) * cost;
            } else {
                double structureCost = EquipmentType.getStructureCost(mek.getStructureType());
                cost = structureCost / 8.0;
                cost = (double)(mek.getOInternal(location) - mek.getInternal(location)) * cost;
            }
        } else {
            CriticalSlot cs = unit.getCritical(location, slot);
            if (cs == null) {
                return 0;
            }
            if (cs.isBreached()) {
                return 0;
            }
            if (!cs.isDamaged()) {
                return 0;
            }
            if (cs.getType() == 1) {
                Mounted m = unit.getEquipment(cs.getIndex());
                if (m.getDesc().indexOf("Heat Sink") > -1) {
                    cost = m.getType().hasFlag(1L) ? (m.getType().getTechLevel() == 5 || m.getType().getTechLevel() == 7 ? 3000.0 : 2000.0) : 6000.0;
                } else {
                    int itemCost = (int)m.getType().getCost();
                    if (itemCost == Integer.MIN_VALUE) {
                        itemCost = m.getType().resolveVariableCost(mek);
                    }
                    cost = itemCost;
                }
            } else if (UnitUtils.isEngineCrit(cs)) {
                Engine engine = mek.getEngine();
                cost = (double)((float)(engine.getBaseCost() * engine.getRating()) * mek.getWeight()) / 75.0;
                double totalEngineCrits = UnitUtils.getNumberOfEngineCrits(unit);
                double damagedEngineCrits = UnitUtils.getNumberOfDamagedEngineCrits(unit);
                cost *= damagedEngineCrits / totalEngineCrits;
            } else if (cs.getIndex() == 1) {
                cost = mek.getWeight() * 2000.0f;
            } else if (cs.getIndex() == 4) {
                cost = mek.getGyroType() == 1 ? (double)(750000 * (int)Math.ceil((float)mek.getOriginalWalkMP() * mek.getWeight() / 100.0f)) * 0.5 : (mek.getGyroType() == 2 ? (double)(400000 * (int)Math.ceil((float)mek.getOriginalWalkMP() * mek.getWeight() / 100.0f)) * 1.5 : (mek.getGyroType() == 3 ? (double)(500000 * (int)Math.ceil((float)mek.getOriginalWalkMP() * mek.getWeight() / 100.0f) * 2) : (double)(300000 * (int)Math.ceil((float)mek.getOriginalWalkMP() * mek.getWeight() / 100.0f))));
            } else if (cs.getIndex() == 0) {
                cost = 50000.0;
            } else if (cs.getIndex() == 2) {
                cost = mek.getCockpitType() == 1 ? 750000.0 : (mek.getCockpitType() == 2 ? 175000.0 : 200000.0);
            } else if (UnitUtils.isActuator(cs)) {
                if (cs.getIndex() == 10) {
                    cost = mek.getWeight() * 80.0f;
                } else if (cs.getIndex() == 9) {
                    cost = mek.getWeight() * 50.0f;
                } else if (cs.getIndex() == 8 || cs.getIndex() == 7) {
                    cost = mek.getWeight() * 100.0f;
                } else if (cs.getIndex() == 14) {
                    cost = mek.getWeight() * 120.0f;
                } else if (cs.getIndex() == 13) {
                    cost = mek.getWeight() * 80.0f;
                } else if (cs.getIndex() == 12 || cs.getIndex() == 11) {
                    cost = mek.getWeight() * 150.0f;
                }
            }
        }
        return (int)Math.ceil(cost);
    }

    public static int getTotalDamagedPartCost(Entity unit) {
        double totalCost = 0.0;
        for (int location = 0; location < unit.locations(); ++location) {
            if (location == 1 || location == 2 || location == 3) {
                totalCost += (double)UnitUtils.getPartCost(unit, location, 13, true);
                totalCost += (double)UnitUtils.getPartCost(unit, location, 14, true);
                totalCost += (double)UnitUtils.getPartCost(unit, location, 15, true);
            } else {
                totalCost += (double)UnitUtils.getPartCost(unit, location, 13, true);
                totalCost += (double)UnitUtils.getPartCost(unit, location, 15, true);
            }
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                totalCost += (double)UnitUtils.getPartCost(unit, location, slot, false);
            }
        }
        return (int)Math.ceil(totalCost);
    }

    public static String getRepairMessage(Entity unit, int location, int slot, boolean armor) {
        String repairMessage = "";
        if (unit instanceof Mech && unit.getInternal(1) < 1) {
            repairMessage = "This unit has been cored and cannot be repaired. Either Scrap it or try to salvage it for parts!";
            return repairMessage;
        }
        if (unit instanceof Tank) {
            for (int loc = 1; loc < 5; ++loc) {
                if (unit.getInternal(loc) >= 1) continue;
                repairMessage = "This unit has been cored and cannot be repaired. Either Scrap it or try to salvage it for parts!";
                return repairMessage;
            }
        }
        if (location == 4 && unit.getInternal(2) != unit.getOInternal(2) || location == 5 && unit.getInternal(3) != unit.getOInternal(3)) {
            repairMessage = "You may not repair your " + unit.getShortNameRaw() + "'s " + unit.getLocationName(location) + " until the adjacent torso's internal structure is fully repaired.";
            return repairMessage;
        }
        if (location >= 8) {
            location -= 7;
        }
        if (armor) {
            boolean rear;
            int armorRepaired = 0;
            boolean bl = rear = slot == 14;
            if (slot < 15) {
                armorRepaired = unit.getOArmor(location, rear) - unit.getArmor(location, rear);
                if (armorRepaired == 0) {
                    repairMessage = rear ? "All external armor(" + unit.getLocationAbbr(location) + "r) has already been repaired." : "All external armor(" + unit.getLocationAbbr(location) + ") has already been repaired.";
                }
            } else {
                armorRepaired = unit.getOInternal(location) - unit.getInternal(location);
                if (armorRepaired == 0) {
                    repairMessage = "All internal structure(" + unit.getLocationAbbr(location) + ") has already been repaired.";
                }
            }
        } else {
            CriticalSlot cs;
            if (unit.getInternal(location) != unit.getOInternal(location)) {
                repairMessage = "You may not make any repairs to the until the internal structure(" + unit.getLocationAbbr(location) + ") is fully repaired!";
            }
            if ((cs = unit.getCritical(location, slot)) == null) {
                repairMessage = "There is no critical in that location please select another critical slot to repair!";
            }
            Mounted mount = null;
            if (!UnitUtils.isActuator(cs)) {
                mount = unit.getEquipment(cs.getIndex());
            }
            if (mount != null) {
                if (!(mount.isDestroyed() || mount.isBreached() || mount.isMissing() || cs.isDamaged() || cs.isBreached())) {
                    repairMessage = "That critical is not damaged!?!?";
                }
            } else if (!cs.isDamaged() && !cs.isBreached()) {
                repairMessage = "That critical is not damaged?!?!";
            }
        }
        return repairMessage;
    }

    public static String getSalvageMessage(Entity unit, int location, int slot, boolean armor) {
        String salvageMessage = "";
        if (armor && slot == 15) {
            if (location == 2 && unit.getInternal(4) > 0 || location == 3 && unit.getInternal(5) > 0) {
                salvageMessage = "You may not salvage your " + unit.getShortNameRaw() + "'s " + unit.getLocationName(location) + " until the adjacent arm's internal structure is fully removed.";
                return salvageMessage;
            }
            if (location == 1 && unit.getInternal(5) > 0 && unit.getInternal(4) > 0) {
                salvageMessage = "You may not salvage your " + unit.getShortNameRaw() + "'s " + unit.getLocationName(location) + " until the adjacent toro's internal structure is fully removed.";
                return salvageMessage;
            }
            if (UnitUtils.hasUndamagedCriticals(unit, location) || UnitUtils.hasCriticalsUnderRepair(unit, location)) {
                salvageMessage = "You may not salvage your " + unit.getShortNameRaw() + "'s " + unit.getLocationName(location) + " internal structure until the parts have been fully removed.";
                return salvageMessage;
            }
        }
        if (location >= 8) {
            location -= 7;
        }
        if (armor) {
            boolean rear;
            int armorLeft = 0;
            boolean bl = rear = slot == 14;
            if (slot < 15) {
                armorLeft = unit.getArmor(location, rear);
                if (armorLeft == 0) {
                    salvageMessage = rear ? "All external armor(" + unit.getLocationAbbr(location) + "r) has already been removed." : "All external armor(" + unit.getLocationAbbr(location) + ") has already been removed.";
                }
            } else {
                armorLeft = unit.getInternal(location);
                if (armorLeft == 0) {
                    salvageMessage = "All internal structure(" + unit.getLocationAbbr(location) + ") has already been removed.";
                }
            }
        } else {
            CriticalSlot cs = unit.getCritical(location, slot);
            if (cs == null) {
                salvageMessage = "There is no critical in that location please select another critical slot to salvage!";
            }
            if (UnitUtils.isNonRepairableCrit(unit, cs) || cs.isDamaged()) {
                salvageMessage = "That critical is not salvagable!";
            }
        }
        return salvageMessage;
    }

    public static boolean checkRepairViability(Entity unit, int location, int slot, boolean armor) {
        if (location == 4 && unit.getInternal(2) != unit.getOInternal(2) || location == 5 && unit.getInternal(3) != unit.getOInternal(3)) {
            return false;
        }
        if (armor) {
            return true;
        }
        return unit.getInternal(location) == unit.getOInternal(location);
    }

    public static boolean hasTargettingComputer(Entity unit) {
        for (Mounted m : unit.getMisc()) {
            if (!(m.getType() instanceof MiscType) || !m.getType().hasFlag(1024L)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllAmmo(Entity unit) {
        for (Mounted ammo : unit.getAmmo()) {
            if (!(ammo.getLocation() == -1 ? ammo.getShotsLeft() != 1 : ammo.getShotsLeft() != ((AmmoType)ammo.getType()).getShots())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAmmoless(Entity unit) {
        return unit.getAmmo().size() == 0;
    }

    public static boolean hasLowAmmo(Entity unit) {
        for (Mounted ammo : unit.getAmmo()) {
            if (ammo == null) continue;
            try {
                if (!(ammo.getLocation() == -1 ? ammo.getShotsLeft() == 0 : ammo.getShotsLeft() < ((AmmoType)ammo.getType()).getShots() && ammo.getShotsLeft() > 0)) continue;
                return true;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        return false;
    }

    public static boolean hasEmptyAmmo(Entity unit) {
        for (Mounted ammo : unit.getAmmo()) {
            if (ammo.getShotsLeft() != 0) continue;
            return true;
        }
        return false;
    }

    public static String getArmorShortName(Entity unit) {
        String armorName = "Standard";
        switch (unit.getArmorType()) {
            case 0: {
                armorName = "Standard";
                break;
            }
            case 1: {
                armorName = "FF";
                break;
            }
            case 2: {
                armorName = "Reactive";
                break;
            }
            case 3: {
                armorName = "Reflective";
                break;
            }
            case 4: {
                armorName = "Hardened";
                break;
            }
            case 5: {
                armorName = "LFF";
                break;
            }
            case 6: {
                armorName = "HFF";
                break;
            }
            case 7: {
                armorName = "Patchwork";
                break;
            }
            case 8: {
                armorName = "Stealth";
                break;
            }
            case 9: {
                armorName = "FFProto";
            }
        }
        return armorName;
    }

    public static String getInternalShortName(Entity unit) {
        String internalName = "Standard";
        switch (unit.getStructureType()) {
            case 0: {
                internalName = "Standard";
                break;
            }
            case 1: {
                internalName = "Endo";
                break;
            }
            case 2: {
                internalName = "EndoProto";
                break;
            }
            case 3: {
                internalName = "Reinforced";
                break;
            }
            case 4: {
                internalName = "Composite";
            }
        }
        return internalName;
    }

    public static boolean isDestroyedOrDamaged(Entity unit, CriticalSlot cs) {
        if (cs.isMissing()) {
            return cs.isMissing();
        }
        Mounted mount = unit.getEquipment(cs.getIndex());
        if (mount == null) {
            return true;
        }
        int totalCrits = 0;
        int damagedCrits = 0;
        if (mount.isSplit()) {
            CriticalSlot crit;
            int slot;
            int location = mount.getLocation();
            int numberOfSlots = unit.getNumberOfCriticals(location);
            for (slot = 0; slot < numberOfSlots; ++slot) {
                crit = unit.getCritical(location, slot);
                try {
                    if (crit == null || !unit.getEquipment(crit.getIndex()).equals(unit.getEquipment(cs.getIndex()))) continue;
                    ++totalCrits;
                    if (!crit.isDamaged()) continue;
                    ++damagedCrits;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            location = mount.getSecondLocation();
            numberOfSlots = unit.getNumberOfCriticals(location);
            for (slot = 0; slot < numberOfSlots; ++slot) {
                crit = unit.getCritical(location, slot);
                try {
                    if (crit == null || !unit.getEquipment(crit.getIndex()).equals(unit.getEquipment(cs.getIndex()))) continue;
                    ++totalCrits;
                    if (!crit.isDamaged()) continue;
                    ++damagedCrits;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (damagedCrits > totalCrits / 2) {
                return true;
            }
        } else {
            int numberOfSlots = unit.getNumberOfCriticals(mount.getLocation());
            for (int slot = 0; slot < numberOfSlots; ++slot) {
                CriticalSlot crit = unit.getCritical(mount.getLocation(), slot);
                try {
                    if (crit == null || !unit.getEquipment(crit.getIndex()).equals(unit.getEquipment(cs.getIndex()))) continue;
                    ++totalCrits;
                    if (!crit.isDamaged()) continue;
                    ++damagedCrits;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (damagedCrits > totalCrits / 2) {
                return true;
            }
        }
        return false;
    }

    public static int getNumberOfDamagedCrits(Entity unit, int slot, int loc, boolean armor) {
        if (armor) {
            if (slot == 15) {
                return unit.getOInternal(loc) - unit.getInternal(loc);
            }
            if (loc >= 8) {
                return unit.getOArmor(loc - 7, true) - unit.getArmor(loc - 7, true);
            }
            return unit.getOArmor(loc) - unit.getArmor(loc);
        }
        CriticalSlot cs = unit.getCritical(loc, slot);
        if (UnitUtils.isEngineCrit(cs)) {
            return UnitUtils.getNumberOfDamagedEngineCrits(unit);
        }
        if (cs.getType() == 1) {
            Mounted mount = unit.getEquipment(cs.getIndex());
            int damagedCrits = 0;
            if (mount != null && mount.isSplit()) {
                CriticalSlot crit;
                int pos;
                int location = mount.getLocation();
                int numberOfSlots = unit.getNumberOfCriticals(location);
                for (pos = 0; pos < numberOfSlots; ++pos) {
                    crit = unit.getCritical(location, pos);
                    try {
                        if (crit == null || !unit.getEquipment(crit.getIndex()).equals(mount) || !crit.isDamaged()) continue;
                        ++damagedCrits;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                location = mount.getSecondLocation();
                numberOfSlots = unit.getNumberOfCriticals(location);
                for (pos = 0; pos < numberOfSlots; ++pos) {
                    crit = unit.getCritical(location, pos);
                    try {
                        if (crit == null || !unit.getEquipment(crit.getIndex()).equals(mount) || !crit.isDamaged()) continue;
                        ++damagedCrits;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            } else {
                int numberOfSlots = unit.getNumberOfCriticals(mount.getLocation());
                for (int pos = 0; pos < numberOfSlots; ++pos) {
                    CriticalSlot crit = unit.getCritical(mount.getLocation(), pos);
                    try {
                        if (crit == null || !unit.getEquipment(crit.getIndex()).equals(mount) || !crit.isDamaged()) continue;
                        ++damagedCrits;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            return damagedCrits;
        }
        return UnitUtils.getNumberOfDamagedSystemCriticals(unit, cs);
    }

    public static String getCritName(Entity unit, int slot, int location, boolean armor) {
        Mounted mounted;
        if (armor) {
            if (slot == 15) {
                if (MiscType.getArmorTypeName(unit.getStructureType()).equalsIgnoreCase("Standard")) {
                    return "IS (STD)";
                }
                return MiscType.getStructureTypeName(unit.getStructureType());
            }
            if (MiscType.getArmorTypeName(unit.getArmorType()).equalsIgnoreCase("Standard")) {
                return "Armor (STD)";
            }
            return MiscType.getArmorTypeName(unit.getArmorType());
        }
        CriticalSlot crit = unit.getCritical(location, slot);
        if (crit == null) {
            return "";
        }
        if (UnitUtils.isActuator(crit)) {
            return "Actuator";
        }
        if (crit.getType() == 1 && (mounted = unit.getEquipment(crit.getIndex())).getType() instanceof AmmoType) {
            return "Ammo Bin";
        }
        if (unit instanceof Mech && crit.getType() == 0) {
            if (crit.getIndex() == 3) {
                return ENGINE_TECH_STRING[UnitUtils.getEngineType(unit)];
            }
            if (crit.getIndex() == 4) {
                return Mech.getGyroTypeString(unit.getGyroType());
            }
            if (crit.getIndex() == 2) {
                return Mech.getCockpitTypeString(((Mech)unit).getCockpitType());
            }
            return ((Mech)unit).getSystemName(crit.getIndex());
        }
        return unit.getEquipment(crit.getIndex()).getType().getInternalName();
    }

    public static String getCritExternalName(Entity unit, int slot, int location, boolean armor) {
        if (armor) {
            if (slot == 15) {
                if (MiscType.getArmorTypeName(unit.getStructureType()).equalsIgnoreCase("Standard")) {
                    return "IS (STD)";
                }
                return MiscType.getStructureTypeName(unit.getStructureType());
            }
            if (MiscType.getArmorTypeName(unit.getArmorType()).equalsIgnoreCase("Standard")) {
                return "Armor (STD)";
            }
            return MiscType.getArmorTypeName(unit.getArmorType());
        }
        CriticalSlot crit = unit.getCritical(location, slot);
        if (crit == null) {
            return "";
        }
        if (UnitUtils.isActuator(crit)) {
            return "Actuator";
        }
        if (crit.getType() == 1) {
            Mounted mounted = unit.getEquipment(crit.getIndex());
            if (mounted.getType() instanceof AmmoType) {
                return "Ammo Bin";
            }
            return mounted.getName();
        }
        if (unit instanceof Mech && crit.getType() == 0) {
            if (crit.getIndex() == 3) {
                return ENGINE_TECH_STRING[UnitUtils.getEngineType(unit)];
            }
            if (crit.getIndex() == 4) {
                return Mech.getGyroTypeString(unit.getGyroType());
            }
            if (crit.getIndex() == 2) {
                return Mech.getCockpitTypeString(((Mech)unit).getCockpitType());
            }
            return ((Mech)unit).getSystemName(crit.getIndex());
        }
        return unit.getEquipment(crit.getIndex()).getType().getInternalName();
    }

    public static boolean isCompatibleTech(Entity unit, int techLevel) {
        if (techLevel != 11 && techLevel != -2 && techLevel != -1 && unit.getTechLevel() != techLevel) {
            switch (unit.getTechLevel()) {
                case 10: {
                    if (techLevel == 10) break;
                    return false;
                }
                case 8: {
                    if (techLevel == 8 || techLevel == 10) break;
                    return false;
                }
                case 6: {
                    if (techLevel == 6 || techLevel == 8 || techLevel == 10) break;
                    return false;
                }
                case 2: {
                    if (techLevel == 2 || techLevel == 6 || techLevel == 8 || techLevel == 10) break;
                    return false;
                }
                case 9: {
                    if (techLevel == 9) break;
                    return false;
                }
                case 7: {
                    if (techLevel == 9 || techLevel == 7) break;
                    return false;
                }
                case 5: {
                    if (techLevel != 5 && techLevel != 9 && techLevel != 7) {
                        return false;
                    }
                }
                case 3: {
                    if (techLevel != 3 && techLevel != 5 && techLevel != 9 && techLevel != 7) {
                        return false;
                    }
                }
                case 1: {
                    if (techLevel != 1 && techLevel != 3 && techLevel != 5 && techLevel != 9 && techLevel != 7) {
                        return false;
                    }
                }
                case 0: {
                    if (techLevel == 0 || techLevel == 1 || techLevel == 3 || techLevel == 5 || techLevel == 9 || techLevel == 7) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSameTech(int tech, int techLevel) {
        if (tech >= 11 || tech < 0) {
            return true;
        }
        return techLevel >= tech;
    }

    public static Entity createOMG() {
        BipedMech entity = new BipedMech(0, 0);
        entity.setYear(2075);
        entity.setTechLevel(0);
        entity.setWeight(25.0f);
        entity.setEngine(new Engine(325, 1, 0));
        entity.setArmorType(0);
        entity.setStructureType(0);
        entity.addGyro();
        entity.addEngineCrits();
        entity.addCockpit();
        entity.addEngineSinks(entity.getEngine().integralHeatSinkCapacity(), false);
        entity.autoSetInternal();
        for (int loc = 0; loc <= 7; ++loc) {
            entity.initializeArmor(1, loc);
            if (!entity.hasRearArmor(loc)) continue;
            entity.initializeRearArmor(1, loc);
        }
        entity.setFluff("This is an Error Unit! If you've recieved this unit in error please let someone know.");
        entity.setModel("OMG-UR-FD");
        entity.setChassis("Error");
        return entity;
    }

    public static Entity createEntity(String fileName) {
        Entity UnitEntity = null;
        try {
            MechSummary ms = MechSummaryCache.getInstance().getMech(fileName);
            if (ms == null && (ms = MechSummaryCache.getInstance().getMech(fileName.trim())) == null) {
                MechSummary[] units;
                for (MechSummary unit : units = MechSummaryCache.getInstance().getAllMechs()) {
                    if (!unit.getEntryName().equalsIgnoreCase(fileName) && !unit.getModel().trim().equalsIgnoreCase(fileName.trim()) && !unit.getChassis().trim().equalsIgnoreCase(fileName.trim())) continue;
                    ms = unit;
                    break;
                }
            }
            UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
        }
        catch (Exception exep) {
            try {
                UnitEntity = UnitUtils.createOMG();
            }
            catch (Exception exepe) {
                CampaignData.mwlog.errLog("Error unit failed to load. Exiting.");
                return null;
            }
        }
        return UnitEntity;
    }

    public static String getEntityFileName(Entity en) {
        String unitFile = "";
        MechSummary ms = MechSummaryCache.getInstance().getMech(en.getShortNameRaw());
        if (ms == null) {
            MechSummary[] units;
            for (MechSummary unit : units = MechSummaryCache.getInstance().getAllMechs()) {
                if (!unit.getModel().trim().equalsIgnoreCase(en.getModel().trim()) || !unit.getChassis().trim().equalsIgnoreCase(en.getChassis().trim())) continue;
                return unit.getEntryName();
            }
        } else {
            unitFile = ms.getEntryName();
            if (unitFile == null || unitFile.equals("null")) {
                unitFile = ms.getSourceFile().getName();
            }
            if (unitFile.indexOf("/") > -1) {
                unitFile = unitFile.substring(unitFile.lastIndexOf("/") + 1);
            } else if (unitFile.indexOf("\\") > -1) {
                unitFile = unitFile.substring(unitFile.lastIndexOf("\\") + 1);
            }
        }
        return unitFile;
    }

    public static boolean isCored(Entity unit) {
        if (unit instanceof Tank) {
            for (int loc = 1; loc < 5; ++loc) {
                if (unit.getInternal(loc) >= 0) continue;
                return true;
            }
        } else if (unit instanceof Mech) {
            return !UnitUtils.canStartUp(unit);
        }
        return false;
    }

    public static void destroyCockPit(Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        Mech mek = (Mech)unit;
        int location = 0;
        if (mek.getCockpitType() == 1) {
            location = 1;
        }
        for (int y = 0; y < unit.getNumberOfCriticals(location); ++y) {
            CriticalSlot cs = unit.getCritical(location, y);
            if (cs == null || cs.getIndex() != 2) continue;
            UnitUtils.salvageCriticalSlot(cs, unit);
        }
    }

    public static Pilot createEntityPilot(Unit mek) {
        Pilot pilot = null;
        pilot = new Pilot(mek.getPilot().getName(), mek.getPilot().getGunnery(), mek.getPilot().getPiloting());
        pilot.setHits(mek.getPilot().getHits());
        for (MegaMekPilotOption po : mek.getPilot().getMegamekOptions()) {
            if (po.getMmname().equals("weapon_specialist")) {
                pilot.getOptions().getOption(po.getMmname()).setValue(mek.getPilot().getWeapon());
                continue;
            }
            if (po.getMmname().equals("edge")) {
                pilot.getOptions().getOption(po.getMmname()).setValue(mek.getPilot().getSkills().getPilotSkill(20).getLevel());
                pilot.getOptions().getOption("edge_when_headhit").setValue(mek.getPilot().getHeadHit());
                pilot.getOptions().getOption("edge_when_tac").setValue(mek.getPilot().getTac());
                pilot.getOptions().getOption("edge_when_ko").setValue(mek.getPilot().getKO());
                pilot.getOptions().getOption("edge_when_explosion").setValue(mek.getPilot().getExplosion());
                continue;
            }
            pilot.getOptions().getOption(po.getMmname()).setValue(po.isValue());
        }
        return pilot;
    }

    public static boolean isClanEQ(EquipmentType eq) {
        return eq.getTechLevel() == 6 || eq.getTechLevel() == 8 || eq.getTechLevel() == 2 || eq.getTechLevel() == 10;
    }
}

