/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.common.Coords;

public class DeployCommand
extends ClientCommand {
    public DeployCommand(Client client) {
        super(client, "deploy", "This command deploys a given unit to the specified hex. Usage: '#deploy unit x y facing' where unit is the unit id number and x and y are the coordinates of the hex, and facing is the direction it's looking in. #deploy without any options will provide legal deployment zones.");
    }

    public String run(String[] stringArray) {
        if (stringArray.length == 1) {
            this.client.getBoard();
            return "The legal deployment zone is: " + this.legalDeploymentZone();
        }
        if (stringArray.length == 5) {
            int n = Integer.parseInt(stringArray[1]);
            Coords coords = new Coords(Integer.parseInt(stringArray[2]) - 1, Integer.parseInt(stringArray[3]) - 1);
            int n2 = DeployCommand.getDirection(stringArray[4]);
            this.client.deploy(n, coords, n2);
            return "Unit " + n + " deployed to " + coords.toFriendlyString() + ". (this is assuming it worked. No error checking done.)";
        }
        return "Wrong number of arguments supplied. No deployment done.";
    }

    public String legalDeploymentZone() {
        int n = this.client.getBoard().getWidth();
        int n2 = this.client.getBoard().getHeight();
        int n3 = this.client.getLocalPlayer().getStartingPos();
        int n4 = 0;
        int n5 = n;
        int n6 = 0;
        int n7 = n2;
        String string = "";
        if (n3 > 10) {
            n3 -= 10;
            string = "Deep ";
            n4 = n / 5;
            n5 -= n / 5;
            n6 = n2 / 5;
            n7 -= n2 / 5;
        }
        switch (n3) {
            case 0: {
                return string + "Deploy nearly anywhere. MinX: " + (n4 + 1) + " MinY: " + (n6 + 1) + " MaxX: " + (n5 + 1) + " MaxY: " + (n7 + 1);
            }
            case 1: {
                return string + "Deploy NW.";
            }
            case 2: {
                return string + "Deploy N.";
            }
            case 3: {
                return string + "Deploy NE.";
            }
            case 4: {
                return string + "Deploy E.";
            }
            case 5: {
                return string + "Deploy SE.";
            }
            case 6: {
                return string + "Deploy S.";
            }
            case 7: {
                return string + "Deploy SW.";
            }
            case 8: {
                return string + "Deploy W.";
            }
            case 9: {
                return string + "Deploy at any edge.";
            }
            case 10: {
                return string + "Deploy in the center. MinX: " + (Math.max(n4, n / 3) + 1) + " MinY: " + (Math.max(n6, n2 / 3) + 1) + " MaxX: " + (Math.min(n5, 2 * n / 3) + 1) + " MaxY: " + (Math.min(n6, 2 * n2 / 3) + 1);
            }
        }
        return "Something went wrong, unknown deployment schema.";
    }
}

