/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import keypoint.PngEncoder;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListenerAdapter;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.BoardNewDialog;
import megamek.client.ui.AWT.BoardView1;
import megamek.client.ui.AWT.CommonAboutDialog;
import megamek.client.ui.AWT.CommonHelpDialog;
import megamek.client.ui.AWT.CommonMenuBar;
import megamek.client.ui.AWT.CommonSettingsDialog;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.ExitsDialog;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.IMapSettingsObserver;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.MiniMap;
import megamek.client.ui.AWT.RandomMapDialog;
import megamek.client.ui.AWT.TilesetManager;
import megamek.client.ui.IBoardView;
import megamek.common.Coords;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.MapSettings;
import megamek.common.Terrains;
import megamek.common.util.BoardUtilities;

public class BoardEditor
extends Container
implements ItemListener,
ActionListener,
TextListener,
IMapSettingsObserver {
    private static final long serialVersionUID = -8281854232284355981L;
    private final Frame frame = new Frame();
    private final Game game = new Game();
    private IBoard board = this.game.getBoard();
    private BoardView1 bv;
    private final CommonMenuBar menuBar = new CommonMenuBar();
    private CommonAboutDialog about = null;
    private CommonHelpDialog help = null;
    private CommonSettingsDialog setdlg = null;
    private IHex curHex = new Hex();
    private String curpath;
    private String curfile;
    private String curfileImage;
    private HexCanvas canHex;
    private Label labElev;
    private TextField texElev;
    private Button butElevUp;
    private Button butElevDown;
    private Label labTerrain;
    private List lisTerrain;
    private Button butDelTerrain;
    private Panel panTerrainType;
    private Choice choTerrainType;
    private TextField texTerrainLevel;
    private Panel panTerrExits;
    private Checkbox cheTerrExitSpecified;
    private TextField texTerrExits;
    private Button butTerrExits;
    private Panel panRoads;
    private Checkbox cheRoadsAutoExit;
    private Label labTheme;
    private TextField texTheme;
    private Button butAddTerrain;
    private Label blankL;
    private Label labBoard;
    private Panel panButtons;
    private Button butBoardNew;
    private Button butBoardLoad;
    private Button butBoardSave;
    private Button butBoardSaveAs;
    private Button butBoardSaveAsImage;
    private Button butMiniMap;
    private Dialog minimapW;
    private MiniMap minimap;
    private Coords lastClicked;
    private MapSettings mapSettings = new MapSettings();

    public BoardEditor() {
        try {
            this.bv = new BoardView1(this.game);
        }
        catch (IOException iOException) {
            new AlertDialog(this.frame, Messages.getString("BoardEditor.FatalError"), Messages.getString("BoardEditor.CouldntInitialize") + iOException);
            this.frame.dispose();
        }
        this.bv.addBoardViewListener(new BoardViewListenerAdapter(){

            public void hexMoused(BoardViewEvent boardViewEvent) {
                Coords coords = boardViewEvent.getCoords();
                if (coords.equals(BoardEditor.this.lastClicked)) {
                    return;
                }
                BoardEditor.this.lastClicked = coords;
                BoardEditor.this.bv.cursor(coords);
                if ((boardViewEvent.getModifiers() & 8) != 0) {
                    BoardEditor.this.setCurrentHex(BoardEditor.this.board.getHex(boardViewEvent.getCoords()));
                } else if ((boardViewEvent.getModifiers() & 2) != 0) {
                    if (!BoardEditor.this.board.getHex(boardViewEvent.getCoords()).equals(BoardEditor.this.curHex)) {
                        BoardEditor.this.paintHex(boardViewEvent.getCoords());
                    }
                } else if ((boardViewEvent.getModifiers() & 1) != 0) {
                    BoardEditor.this.addToHex(boardViewEvent.getCoords());
                } else if ((boardViewEvent.getModifiers() & 0x10) != 0) {
                    BoardEditor.this.resurfaceHex(boardViewEvent.getCoords());
                }
            }
        });
        this.bv.setUseLOSTool(false);
        this.setupEditorPanel();
        this.setupFrame();
        this.frame.setVisible(true);
        if (GUIPreferences.getInstance().getNagForMapEdReadme()) {
            String string = Messages.getString("BoardEditor.readme.title");
            String string2 = Messages.getString("BoardEditor.readme.message");
            ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2, true);
            confirmDialog.setVisible(true);
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForMapEdReadme(false);
            }
            if (confirmDialog.getAnswer()) {
                this.showHelp();
            }
        }
    }

    private void setupFrame() {
        this.frame.setTitle(Messages.getString("BoardEditor.title"));
        this.frame.setLayout(new BorderLayout());
        this.frame.add(this.bv.getComponent(), "Center");
        this.frame.add((Component)this, "East");
        this.menuBar.addActionListener(this);
        this.frame.setMenuBar(this.menuBar);
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        if (GUIPreferences.getInstance().getWindowSizeHeight() != 0) {
            this.frame.setLocation(GUIPreferences.getInstance().getWindowPosX(), GUIPreferences.getInstance().getWindowPosY());
            this.frame.setSize(GUIPreferences.getInstance().getWindowSizeWidth(), GUIPreferences.getInstance().getWindowSizeHeight());
        } else {
            this.frame.setSize(800, 600);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardEditor.this.frame.setVisible(false);
                BoardEditor.this.setMapVisible(false);
            }
        });
    }

    private void setupEditorPanel() {
        this.canHex = new HexCanvas();
        this.labElev = new Label(Messages.getString("BoardEditor.labElev"), 2);
        this.texElev = new TextField("0", 1);
        this.texElev.addActionListener(this);
        this.texElev.addTextListener(this);
        this.butElevUp = new Button(Messages.getString("BoardEditor.butElevUp"));
        this.butElevUp.addActionListener(this);
        this.butElevDown = new Button(Messages.getString("BoardEditor.butElevDown"));
        this.butElevDown.addActionListener(this);
        this.labTerrain = new Label(Messages.getString("BoardEditor.labTerrain"), 0);
        this.lisTerrain = new List(6);
        this.lisTerrain.addItemListener(this);
        this.refreshTerrainList();
        this.butDelTerrain = new Button(Messages.getString("BoardEditor.butDelTerrain"));
        this.butDelTerrain.addActionListener(this);
        this.choTerrainType = new Choice();
        for (int i = 1; i < Terrains.SIZE; ++i) {
            this.choTerrainType.add(Terrains.getName(i));
        }
        this.texTerrainLevel = new TextField("1", 1);
        this.butAddTerrain = new Button(Messages.getString("BoardEditor.butAddTerrain"));
        this.butAddTerrain.addActionListener(this);
        this.butMiniMap = new Button(Messages.getString("BoardEditor.butMiniMap"));
        this.butMiniMap.setActionCommand("viewMiniMap");
        this.butMiniMap.addActionListener(this);
        this.panTerrainType = new Panel(new BorderLayout());
        this.panTerrainType.add((Component)this.choTerrainType, "West");
        this.panTerrainType.add((Component)this.texTerrainLevel, "Center");
        this.cheTerrExitSpecified = new Checkbox(Messages.getString("BoardEditor.cheTerrExitSpecified"));
        this.butTerrExits = new Button(Messages.getString("BoardEditor.butTerrExits"));
        this.texTerrExits = new TextField("0", 1);
        this.butTerrExits.addActionListener(this);
        this.panTerrExits = new Panel(new FlowLayout());
        this.panTerrExits.add(this.cheTerrExitSpecified);
        this.panTerrExits.add(this.butTerrExits);
        this.panTerrExits.add(this.texTerrExits);
        this.panRoads = new Panel(new FlowLayout());
        this.cheRoadsAutoExit = new Checkbox(Messages.getString("BoardEditor.cheRoadsAutoExit"));
        this.cheRoadsAutoExit.addItemListener(this);
        this.panRoads.add(this.cheRoadsAutoExit);
        this.labTheme = new Label(Messages.getString("BoardEditor.labTheme"), 0);
        this.texTheme = new TextField("", 15);
        this.texTheme.addTextListener(this);
        this.labBoard = new Label(Messages.getString("BoardEditor.labBoard"), 0);
        this.butBoardNew = new Button(Messages.getString("BoardEditor.butBoardNew"));
        this.butBoardNew.setActionCommand("fileBoardNew");
        this.butBoardNew.addActionListener(this);
        this.butBoardLoad = new Button(Messages.getString("BoardEditor.butBoardLoad"));
        this.butBoardLoad.setActionCommand("fileBoardOpen");
        this.butBoardLoad.addActionListener(this);
        this.butBoardSave = new Button(Messages.getString("BoardEditor.butBoardSave"));
        this.butBoardSave.setActionCommand("fileBoardSave");
        this.butBoardSave.addActionListener(this);
        this.butBoardSaveAs = new Button(Messages.getString("BoardEditor.butBoardSaveAs"));
        this.butBoardSaveAs.setActionCommand("fileBoardSaveAs");
        this.butBoardSaveAs.addActionListener(this);
        this.butBoardSaveAsImage = new Button(Messages.getString("BoardEditor.butBoardSaveAsImage"));
        this.butBoardSaveAsImage.setActionCommand("fileBoardSaveAsImage");
        this.butBoardSaveAsImage.addActionListener(this);
        this.panButtons = new Panel(new GridLayout(3, 2, 2, 2));
        this.panButtons.add(this.labBoard);
        this.panButtons.add(this.butBoardNew);
        this.panButtons.add(this.butBoardLoad);
        this.panButtons.add(this.butBoardSave);
        this.panButtons.add(this.butBoardSaveAs);
        this.panButtons.add(this.butBoardSaveAsImage);
        this.blankL = new Label("", 1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.canHex, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.addBag(this.labElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevUp, gridBagLayout, gridBagConstraints);
        this.addBag(this.butElevDown, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.texElev, gridBagLayout, gridBagConstraints);
        this.addBag(this.labTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.lisTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.butDelTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrainType, gridBagLayout, gridBagConstraints);
        this.addBag(this.panTerrExits, gridBagLayout, gridBagConstraints);
        this.addBag(this.panRoads, gridBagLayout, gridBagConstraints);
        this.addBag(this.labTheme, gridBagLayout, gridBagConstraints);
        this.addBag(this.texTheme, gridBagLayout, gridBagConstraints);
        this.addBag(this.butAddTerrain, gridBagLayout, gridBagConstraints);
        this.addBag(this.butMiniMap, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.blankL, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.minimapW = new Dialog(this.frame, Messages.getString("BoardEditor.minimapW"), false);
        this.minimapW.setLocation(GUIPreferences.getInstance().getMinimapPosX(), GUIPreferences.getInstance().getMinimapPosY());
        try {
            this.minimap = new MiniMap(this.minimapW, this.game, (IBoardView)this.bv);
        }
        catch (IOException iOException) {
            new AlertDialog(this.frame, Messages.getString("BoardEditor.FatalError"), Messages.getString("BoardEditor.CouldNotInitialiseMinimap") + iOException);
            this.frame.dispose();
        }
        this.minimapW.add(this.minimap);
        this.setMapVisible(true);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void paintHex(Coords coords) {
        this.board.setHex(coords, this.curHex.duplicate());
    }

    public void resurfaceHex(Coords coords) {
        if (this.board.contains(coords)) {
            IHex iHex = this.curHex.duplicate();
            iHex.setElevation(this.board.getHex(coords).getElevation());
            this.board.setHex(coords, iHex);
        }
    }

    public void addToHex(Coords coords) {
        if (this.board.contains(coords)) {
            IHex iHex = this.curHex.duplicate();
            IHex iHex2 = this.board.getHex(coords);
            iHex.setElevation(iHex2.getElevation());
            for (int i = 0; i < Terrains.SIZE; ++i) {
                if (iHex.containsTerrain(i) || !iHex2.containsTerrain(i)) continue;
                iHex.addTerrain(iHex2.getTerrain(i));
            }
            this.board.setHex(coords, iHex);
        }
    }

    public void setCurrentHex(IHex iHex) {
        this.curHex = iHex.duplicate();
        this.texElev.setText(Integer.toString(this.curHex.getElevation()));
        this.refreshTerrainList();
        if (this.lisTerrain.getItemCount() > 0) {
            this.lisTerrain.select(0);
            this.refreshTerrainFromList();
        }
        this.texTheme.setText(this.curHex.getTheme());
        this.repaint();
        this.repaintWorkingHex();
    }

    private void repaintWorkingHex() {
        if (this.curHex != null) {
            TilesetManager tilesetManager = this.bv.getTilesetManager();
            tilesetManager.clearHex(this.curHex);
        }
        this.canHex.repaint();
        this.lastClicked = null;
    }

    public void refreshTerrainList() {
        this.lisTerrain.removeAll();
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = this.curHex.getTerrain(i);
            if (iTerrain == null) continue;
            this.lisTerrain.add(iTerrain.toString());
        }
    }

    private ITerrain enteredTerrain() {
        int n = Terrains.getType(this.choTerrainType.getSelectedItem());
        int n2 = Integer.parseInt(this.texTerrainLevel.getText());
        boolean bl = this.cheTerrExitSpecified.getState();
        int n3 = Integer.parseInt(this.texTerrExits.getText());
        return Terrains.getTerrainFactory().createTerrain(n, n2, bl, n3);
    }

    private void addSetTerrain() {
        ITerrain iTerrain = this.enteredTerrain();
        this.curHex.addTerrain(iTerrain);
        this.refreshTerrainList();
        this.repaintWorkingHex();
    }

    private void refreshTerrainFromList() {
        ITerrain iTerrain = Terrains.getTerrainFactory().createTerrain(this.lisTerrain.getSelectedItem());
        iTerrain = this.curHex.getTerrain(iTerrain.getType());
        this.choTerrainType.select(Terrains.getName(iTerrain.getType()));
        this.texTerrainLevel.setText(Integer.toString(iTerrain.getLevel()));
        this.cheTerrExitSpecified.setState(iTerrain.hasExitsSpecified());
        this.texTerrExits.setText(Integer.toString(iTerrain.getExits()));
    }

    public void boardNewXX() {
        BoardNewDialog boardNewDialog = new BoardNewDialog(this.frame, this.lisTerrain.getItems(), this.lisTerrain.getSelectedIndex());
        boardNewDialog.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        boardNewDialog.setVisible(true);
        if (boardNewDialog.getX() > 0 || boardNewDialog.getY() > 0) {
            IHex[] iHexArray = new IHex[boardNewDialog.getX() * boardNewDialog.getY()];
            for (int i = 0; i < iHexArray.length; ++i) {
                iHexArray[i] = new Hex();
            }
            this.board.newData(boardNewDialog.getX(), boardNewDialog.getY(), iHexArray);
            this.curpath = null;
            this.curfile = null;
            this.frame.setTitle(Messages.getString("BoardEditor.title"));
            this.menuBar.setBoard(true);
        }
    }

    public void boardNew() {
        RandomMapDialog randomMapDialog = new RandomMapDialog(this.frame, this, this.mapSettings);
        randomMapDialog.setVisible(true);
        this.board = BoardUtilities.generateRandom(this.mapSettings);
        this.game.setBoard(this.board);
        this.curpath = null;
        this.curfile = null;
        this.frame.setTitle(Messages.getString("BoardEditor.title"));
        this.menuBar.setBoard(true);
    }

    public void updateMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
    }

    public void boardLoad() {
        FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("BoardEditor.loadBoard"), 0);
        fileDialog.setDirectory("data" + File.separator + "boards");
        fileDialog.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curpath = fileDialog.getDirectory();
        this.curfile = fileDialog.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.curpath, this.curfile));
            this.board.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            this.menuBar.setBoard(true);
        }
        catch (IOException iOException) {
            System.err.println("error opening file to load!");
            System.err.println(iOException);
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfile);
        this.cheRoadsAutoExit.setState(this.board.getRoadsAutoExit());
        this.refreshTerrainList();
    }

    public void boardSave() {
        if (this.curfile == null) {
            this.boardSaveAs();
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.curpath, this.curfile));
            this.board.save(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to save!");
            System.err.println(iOException);
        }
    }

    public void boardSaveImage() {
        if (this.curfileImage == null) {
            this.boardSaveAsImage();
            return;
        }
        Dialog dialog = new Dialog(this.frame, Messages.getString("BoardEditor.waitDialog.title"));
        dialog.add(new Label(Messages.getString("BoardEditor.waitDialog.message")));
        dialog.setSize(250, 130);
        dialog.setLocation(this.frame.getSize().width / 2 - dialog.getSize().width / 2, this.frame.getSize().height / 2 - dialog.getSize().height / 2);
        dialog.setVisible(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        PngEncoder pngEncoder = new PngEncoder(this.bv.getEntireBoardImage(), false, 0, 9);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.curfileImage);
            byte[] byArray = pngEncoder.pngEncode();
            if (byArray == null) {
                System.out.println("Failed to save board as image:Null image");
            } else {
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        dialog.setVisible(false);
        this.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void boardSaveAs() {
        FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("BoardEditor.saveBoardAs"), 1);
        fileDialog.setDirectory("data" + File.separator + "boards");
        fileDialog.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curpath = fileDialog.getDirectory();
        this.curfile = fileDialog.getFile();
        if (!this.curfile.toLowerCase().endsWith(".board")) {
            this.curfile = this.curfile + ".board";
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfile);
        this.boardSave();
    }

    public void boardSaveAsImage() {
        FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("BoardEditor.saveAsImage"), 1);
        fileDialog.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return null != string && string.endsWith(".png");
            }
        });
        fileDialog.setDirectory(".");
        String string = null;
        if (null != this.curfile && this.curfile.length() > 0) {
            string = this.curfile.toUpperCase();
            if (string.endsWith(".BOARD")) {
                int n = string.length();
                string = string.substring(0, n - 6);
            }
            string = string.toLowerCase() + ".png";
            fileDialog.setFile(string);
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curpath = fileDialog.getDirectory();
        this.curfileImage = fileDialog.getFile();
        if (!this.curfileImage.toLowerCase().endsWith(".png")) {
            this.curfileImage = this.curfileImage + ".png";
        }
        this.frame.setTitle(Messages.getString("BoardEditor.title0") + this.curfileImage);
        this.boardSaveImage();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lisTerrain) {
            this.refreshTerrainFromList();
        } else if (itemEvent.getSource() == this.cheRoadsAutoExit) {
            this.board.setRoadsAutoExit(this.cheRoadsAutoExit.getState());
            this.bv.updateBoard();
            this.repaintWorkingHex();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.texElev) {
            int n;
            try {
                n = Integer.parseInt(this.texElev.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n != this.curHex.getElevation()) {
                this.curHex.setElevation(n);
                this.repaintWorkingHex();
            }
        } else if (textEvent.getSource() == this.texTheme) {
            this.curHex.setTheme(this.texTheme.getText());
            this.repaintWorkingHex();
        }
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    private void showHelp() {
        if (this.help == null) {
            File file = new File("docs", "editor-readme.txt");
            this.help = new CommonHelpDialog(this.frame, file);
        }
        this.help.setVisible(true);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardNew")) {
            this.boardNew();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardOpen")) {
            this.boardLoad();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardSave")) {
            this.boardSave();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardSaveAs")) {
            this.boardSaveAs();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("fileBoardSaveAsImage")) {
            this.boardSaveAsImage();
        } else if (actionEvent.getSource() == this.butDelTerrain && this.lisTerrain.getSelectedItem() != null) {
            ITerrain iTerrain = Terrains.getTerrainFactory().createTerrain(this.lisTerrain.getSelectedItem());
            this.curHex.removeTerrain(iTerrain.getType());
            this.refreshTerrainList();
            this.repaintWorkingHex();
        } else if (actionEvent.getSource() == this.butAddTerrain) {
            this.addSetTerrain();
        } else if (actionEvent.getSource() == this.butElevUp && this.curHex.getElevation() < 9) {
            this.curHex.setElevation(this.curHex.getElevation() + 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.repaintWorkingHex();
        } else if (actionEvent.getSource() == this.butElevDown && this.curHex.getElevation() > -5) {
            this.curHex.setElevation(this.curHex.getElevation() - 1);
            this.texElev.setText(Integer.toString(this.curHex.getElevation()));
            this.repaintWorkingHex();
        } else if (actionEvent.getSource() == this.butTerrExits) {
            ExitsDialog exitsDialog = new ExitsDialog(this.frame);
            this.cheTerrExitSpecified.setState(true);
            exitsDialog.setExits(Integer.parseInt(this.texTerrExits.getText()));
            exitsDialog.setVisible(true);
            this.texTerrExits.setText(Integer.toString(exitsDialog.getExits()));
            this.addSetTerrain();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("viewMiniMap")) {
            this.toggleMap();
        } else if (actionEvent.getActionCommand().equals("viewZoomIn")) {
            this.bv.zoomIn();
        } else if (actionEvent.getActionCommand().equals("viewZoomOut")) {
            this.bv.zoomOut();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("helpAbout")) {
            this.showAbout();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("helpContents")) {
            this.showHelp();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("viewClientSettings")) {
            this.showSettings();
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void toggleMap() {
        this.setMapVisible(!this.minimapW.isVisible());
    }

    public void setMapVisible(boolean bl) {
        this.minimapW.setVisible(bl);
    }

    private class HexCanvas
    extends Canvas {
        private static final long serialVersionUID = 537547390238897105L;

        public HexCanvas() {
            this.setSize(72, 72);
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (BoardEditor.this.curHex != null) {
                TilesetManager tilesetManager = BoardEditor.this.bv.getTilesetManager();
                graphics.drawImage(tilesetManager.baseFor(BoardEditor.this.curHex), 0, 0, this);
                if (tilesetManager.supersFor(BoardEditor.this.curHex) != null) {
                    Iterator<Image> iterator = tilesetManager.supersFor(BoardEditor.this.curHex).iterator();
                    while (iterator.hasNext()) {
                        graphics.drawImage(iterator.next(), 0, 0, this);
                        graphics.drawString(Messages.getString("BoardEditor.SUPER"), 0, 10);
                    }
                }
                graphics.setFont(new Font("SansSerif", 0, 9));
                graphics.drawString(Messages.getString("BoardEditor.LEVEL") + BoardEditor.this.curHex.getElevation(), 24, 70);
            } else {
                graphics.clearRect(0, 0, 72, 72);
            }
        }
    }
}

