/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.AdvancedLabel;

public class CommonHelpDialog
extends Dialog {
    private static final long serialVersionUID = 6500342607269603829L;
    private AdvancedLabel lblHelp;

    public CommonHelpDialog(Frame frame, File file) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CommonHelpDialog.this.quit();
            }
        });
        this.setLayout(new BorderLayout());
        this.lblHelp = new AdvancedLabel(Messages.getString("CommonHelpDialog.noHelp.Message"));
        ScrollPane scrollPane = new ScrollPane(1);
        scrollPane.add(this.lblHelp);
        this.add((Component)scrollPane, "Center");
        Button button = new Button(Messages.getString("CommonHelpDialog.Close"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonHelpDialog.this.quit();
            }
        });
        this.add((Component)button, "South");
        Dimension dimension = frame.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width / 2, dimension.height / 2);
        this.pack();
        this.setSize(dimension2);
        this.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        this.setFile(file);
    }

    public void setFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        if (file == null) {
            this.setTitle(Messages.getString("CommonHelpDialog.noHelp.title"));
            stringBuffer.append(Messages.getString("CommonHelpDialog.noHelp.Message"));
        } else {
            this.setTitle(Messages.getString("CommonHelpDialog.helpFile") + file.getName());
            boolean bl = true;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" \n");
                    }
                    stringBuffer.append(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                if (!bl) {
                    stringBuffer.append("\n \n");
                }
                stringBuffer.append(Messages.getString("CommonHelpDialog.errorReading")).append(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        this.lblHelp.setText(stringBuffer.toString());
    }

    void quit() {
        this.setVisible(false);
    }
}

