/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.BombPayloadDialog;
import megamek.client.ui.AWT.ChoiceDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.ManeuverChoiceDialog;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.MineLayingDialog;
import megamek.client.ui.AWT.SingleChoiceDialog;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.client.ui.AWT.VibrabombSettingDialog;
import megamek.client.ui.SharedUtility;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Bay;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.GameTurn;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LandAirMech;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Protomech;
import megamek.common.Report;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.TeleMissile;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.RamAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovementDisplay
extends StatusBarPhaseDisplay
implements ActionListener,
DoneButtoned,
KeyListener,
GameListener,
BoardViewListener {
    private static final long serialVersionUID = 9136822404087057673L;
    private static final int NUM_BUTTON_LAYOUTS = 4;
    public static final String MOVE_WALK = "moveWalk";
    public static final String MOVE_NEXT = "moveNext";
    public static final String MOVE_JUMP = "moveJump";
    public static final String MOVE_BACK_UP = "moveBackUp";
    public static final String MOVE_TURN = "moveTurn";
    public static final String MOVE_GET_UP = "moveGetUp";
    public static final String MOVE_CHARGE = "moveCharge";
    public static final String MOVE_DFA = "moveDFA";
    public static final String MOVE_GO_PRONE = "moveGoProne";
    public static final String MOVE_FLEE = "moveFlee";
    public static final String MOVE_EJECT = "moveEject";
    public static final String MOVE_LOAD = "moveLoad";
    public static final String MOVE_UNLOAD = "moveUnload";
    public static final String MOVE_UNJAM = "moveUnjam";
    public static final String MOVE_CLEAR = "moveClear";
    public static final String MOVE_CANCEL = "moveCancel";
    public static final String MOVE_RAISE_ELEVATION = "moveRaiseElevation";
    public static final String MOVE_LOWER_ELEVATION = "moveLowerElevation";
    public static final String MOVE_SEARCHLIGHT = "moveSearchlight";
    public static final String MOVE_LAY_MINE = "moveLayMine";
    public static final String MOVE_HULL_DOWN = "moveHullDown";
    public static final String MOVE_CLIMB_MODE = "moveClimbMode";
    public static final String MOVE_SWIM = "moveSwim";
    public static final String MOVE_DIG_IN = "moveDigIn";
    public static final String MOVE_FORTIFY = "moveFortify";
    public static final String MOVE_SHAKE_OFF = "moveShakeOff";
    public static final String MOVE_MODE_MECH = "moveModeMech";
    public static final String MOVE_MODE_AIRMECH = "moveModeAirmech";
    public static final String MOVE_MODE_AIRCRAFT = "moveModeAircraft";
    public static final String MOVE_RECKLESS = "moveReckless";
    public static final String MOVE_CAREFUL_STAND = "moveCarefulStand";
    public static final String MOVE_EVADE = "MoveEvade";
    public static final String MOVE_ACC = "MoveAccelerate";
    public static final String MOVE_DEC = "MoveDecelerate";
    public static final String MOVE_EVADE_AERO = "MoveEvadeAero";
    public static final String MOVE_ACCN = "MoveAccNext";
    public static final String MOVE_DECN = "MoveDecNext";
    public static final String MOVE_ROLL = "MoveRoll";
    public static final String MOVE_LAUNCH = "MoveLaunch";
    public static final String MOVE_RECOVER = "MoveRecover";
    public static final String MOVE_DUMP = "MoveDump";
    public static final String MOVE_RAM = "MoveRam";
    public static final String MOVE_HOVER = "MoveHover";
    public static final String MOVE_MANEUVER = "MoveManeuver";
    public static final String MOVE_TURN_LEFT = "MoveTurnLeft";
    public static final String MOVE_TURN_RIGHT = "MoveTurnRight";
    public static final String MOVE_THRUST = "MoveThrust";
    public static final String MOVE_YAW = "MoveYaw";
    public static final String MOVE_END_OVER = "MoveEndOver";
    public Client client;
    private ClientGUI clientgui;
    private Panel panButtons;
    private Button butWalk;
    private Button butJump;
    private Button butBackup;
    private Button butTurn;
    private Button butSwim;
    private Button butUp;
    private Button butDown;
    private Button butCharge;
    private Button butDfa;
    private Button butRAC;
    private Button butFlee;
    private Button butEject;
    private Button butLoad;
    private Button butUnload;
    private Button butSpace;
    private Button butClear;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private Button butRaise;
    private Button butLower;
    private Button butSearchlight;
    private Button butLayMine;
    private Button butHullDown;
    private Button butClimbMode;
    private Button butDigIn;
    private Button butFortify;
    private Button butShakeOff;
    private Button butReckless;
    private Button butEvade;
    private Button butAcc;
    private Button butDec;
    private Button butEvadeAero;
    private Button butAccN;
    private Button butDecN;
    private Button butRoll;
    private Button butLaunch;
    private Button butRecover;
    private Button butDump;
    private Button butRam;
    private Button butHover;
    private Button butManeuver;
    private Button butTurnLeft;
    private Button butTurnRight;
    private Button butThrust;
    private Button butYaw;
    private Button butEndOver;
    private int buttonLayout;
    private ArrayList<Button> buttonsMech;
    private ArrayList<Button> buttonsTank;
    private ArrayList<Button> buttonsVtol;
    private ArrayList<Button> buttonsInf;
    private ArrayList<Button> buttonsAero;
    private int cen = -1;
    private MovePath cmd;
    private int gear;
    private boolean shiftheld;
    private Vector<Entity> loadedUnits = null;
    public static final int GEAR_LAND = 0;
    public static final int GEAR_BACKUP = 1;
    public static final int GEAR_JUMP = 2;
    public static final int GEAR_CHARGE = 3;
    public static final int GEAR_DFA = 4;
    public static final int GEAR_TURN = 5;
    public static final int GEAR_SWIM = 6;
    public static final int GEAR_RAM = 7;
    public static final int GEAR_IMMEL = 8;
    public static final int GEAR_SPLIT_S = 9;

    public MovementDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        this.gear = 0;
        this.shiftheld = false;
        clientGUI.getBoardView().addBoardViewListener(this);
        this.setupStatusBar(Messages.getString("MovementDisplay.waitingForMovementPhase"));
        this.butClear = new Button(Messages.getString("MovementDisplay.butClear"));
        this.butClear.addActionListener(this);
        this.butClear.setEnabled(false);
        this.butClear.setActionCommand(MOVE_CLEAR);
        this.butClear.addKeyListener(this);
        this.butWalk = new Button(Messages.getString("MovementDisplay.butWalk"));
        this.butWalk.addActionListener(this);
        this.butWalk.setEnabled(false);
        this.butWalk.setActionCommand(MOVE_WALK);
        this.butWalk.addKeyListener(this);
        this.butJump = new Button(Messages.getString("MovementDisplay.butJump"));
        this.butJump.addActionListener(this);
        this.butJump.setEnabled(false);
        this.butJump.setActionCommand(MOVE_JUMP);
        this.butJump.addKeyListener(this);
        this.butSwim = new Button(Messages.getString("MovementDisplay.butSwim"));
        this.butSwim.addActionListener(this);
        this.butSwim.setEnabled(false);
        this.butSwim.setActionCommand(MOVE_SWIM);
        this.butSwim.addKeyListener(this);
        this.butBackup = new Button(Messages.getString("MovementDisplay.butBackup"));
        this.butBackup.addActionListener(this);
        this.butBackup.setEnabled(false);
        this.butBackup.setActionCommand(MOVE_BACK_UP);
        this.butBackup.addKeyListener(this);
        this.butTurn = new Button(Messages.getString("MovementDisplay.butTurn"));
        this.butTurn.addActionListener(this);
        this.butTurn.setEnabled(false);
        this.butTurn.setActionCommand(MOVE_TURN);
        this.butTurn.addKeyListener(this);
        this.butUp = new Button(Messages.getString("MovementDisplay.butUp"));
        this.butUp.addActionListener(this);
        this.butUp.setEnabled(false);
        this.butUp.setActionCommand(MOVE_GET_UP);
        this.butUp.addKeyListener(this);
        this.butDown = new Button(Messages.getString("MovementDisplay.butDown"));
        this.butDown.addActionListener(this);
        this.butDown.setEnabled(false);
        this.butDown.setActionCommand(MOVE_GO_PRONE);
        this.butDown.addKeyListener(this);
        this.butCharge = new Button(Messages.getString("MovementDisplay.butCharge"));
        this.butCharge.addActionListener(this);
        this.butCharge.setEnabled(false);
        this.butCharge.setActionCommand(MOVE_CHARGE);
        this.butCharge.addKeyListener(this);
        this.butDfa = new Button(Messages.getString("MovementDisplay.butDfa"));
        this.butDfa.addActionListener(this);
        this.butDfa.setEnabled(false);
        this.butDfa.setActionCommand(MOVE_DFA);
        this.butDfa.addKeyListener(this);
        this.butFlee = new Button(Messages.getString("MovementDisplay.butFlee"));
        this.butFlee.addActionListener(this);
        this.butFlee.setEnabled(false);
        this.butFlee.setActionCommand(MOVE_FLEE);
        this.butFlee.addKeyListener(this);
        this.butEject = new Button(Messages.getString("MovementDisplay.butEject"));
        this.butEject.addActionListener(this);
        this.butEject.setEnabled(false);
        this.butEject.setActionCommand(MOVE_EJECT);
        this.butEject.addKeyListener(this);
        this.butRAC = new Button(Messages.getString("MovementDisplay.butRAC"));
        this.butRAC.addActionListener(this);
        this.butRAC.setEnabled(false);
        this.butRAC.setActionCommand(MOVE_UNJAM);
        this.butRAC.addKeyListener(this);
        this.butSearchlight = new Button(Messages.getString("MovementDisplay.butSearchlightOn"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.setEnabled(false);
        this.butSearchlight.setActionCommand(MOVE_SEARCHLIGHT);
        this.butSearchlight.addKeyListener(this);
        this.butMore = new Button(Messages.getString("MovementDisplay.butMore"));
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.butMore.addKeyListener(this);
        this.butNext = new Button(Messages.getString("MovementDisplay.butNext"));
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butNext.setActionCommand(MOVE_NEXT);
        this.butNext.addKeyListener(this);
        this.butDone = new Button(Messages.getString("MovementDisplay.butDone"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butDone.addKeyListener(this);
        this.butLoad = new Button(Messages.getString("MovementDisplay.butLoad"));
        this.butLoad.addActionListener(this);
        this.butLoad.setEnabled(false);
        this.butLoad.setActionCommand(MOVE_LOAD);
        this.butLoad.addKeyListener(this);
        this.butUnload = new Button(Messages.getString("MovementDisplay.butUnload"));
        this.butUnload.addActionListener(this);
        this.butUnload.setEnabled(false);
        this.butUnload.setActionCommand(MOVE_UNLOAD);
        this.butUnload.addKeyListener(this);
        this.butRaise = new Button(Messages.getString("MovementDisplay.butRaise"));
        this.butRaise.addActionListener(this);
        this.butRaise.setEnabled(false);
        this.butRaise.setActionCommand(MOVE_RAISE_ELEVATION);
        this.butRaise.addKeyListener(this);
        this.butLower = new Button(Messages.getString("MovementDisplay.butLower"));
        this.butLower.addActionListener(this);
        this.butLower.setEnabled(false);
        this.butLower.setActionCommand(MOVE_LOWER_ELEVATION);
        this.butLower.addKeyListener(this);
        this.butLayMine = new Button(Messages.getString("MovementDisplay.butLayMine"));
        this.butLayMine.addActionListener(this);
        this.butLayMine.setEnabled(false);
        this.butLayMine.setActionCommand(MOVE_LAY_MINE);
        this.butLayMine.addKeyListener(this);
        this.butHullDown = new Button(Messages.getString("MovementDisplay.butHullDown"));
        this.butHullDown.addActionListener(this);
        this.butHullDown.setEnabled(false);
        this.butHullDown.setActionCommand(MOVE_HULL_DOWN);
        this.butHullDown.addKeyListener(this);
        this.butClimbMode = new Button(Messages.getString("MovementDisplay.butClimbMode"));
        this.butClimbMode.addActionListener(this);
        this.butClimbMode.setEnabled(false);
        this.butClimbMode.setActionCommand(MOVE_CLIMB_MODE);
        this.butClimbMode.addKeyListener(this);
        this.butDigIn = new Button(Messages.getString("MovementDisplay.butDigIn"));
        this.butDigIn.addActionListener(this);
        this.butDigIn.setEnabled(false);
        this.butDigIn.setActionCommand(MOVE_DIG_IN);
        this.butDigIn.addKeyListener(this);
        this.butFortify = new Button(Messages.getString("MovementDisplay.butFortify"));
        this.butFortify.addActionListener(this);
        this.butFortify.setEnabled(false);
        this.butFortify.setActionCommand(MOVE_FORTIFY);
        this.butFortify.addKeyListener(this);
        this.butShakeOff = new Button(Messages.getString("MovementDisplay.butShakeOff"));
        this.butShakeOff.addActionListener(this);
        this.butShakeOff.setEnabled(false);
        this.butShakeOff.setActionCommand(MOVE_SHAKE_OFF);
        this.butShakeOff.addKeyListener(this);
        this.butReckless = new Button(Messages.getString("MovementDisplay.butReckless"));
        this.butReckless.addActionListener(this);
        this.butReckless.setEnabled(false);
        this.butReckless.setActionCommand(MOVE_RECKLESS);
        this.butReckless.addKeyListener(this);
        this.butEvade = new Button(Messages.getString("MovementDisplay.butEvade"));
        this.butEvade.addActionListener(this);
        this.butEvade.setEnabled(false);
        this.butEvade.setActionCommand(MOVE_EVADE);
        this.butEvade.addKeyListener(this);
        this.butAcc = new Button(Messages.getString("MovementDisplay.butAcc"));
        this.butAcc.addActionListener(this);
        this.butAcc.setEnabled(false);
        this.butAcc.setActionCommand(MOVE_ACC);
        this.butAcc.addKeyListener(this);
        this.butDec = new Button(Messages.getString("MovementDisplay.butDec"));
        this.butDec.addActionListener(this);
        this.butDec.setEnabled(false);
        this.butDec.setActionCommand(MOVE_DEC);
        this.butDec.addKeyListener(this);
        this.butAccN = new Button(Messages.getString("MovementDisplay.butAccN"));
        this.butAccN.addActionListener(this);
        this.butAccN.setEnabled(false);
        this.butAccN.setActionCommand(MOVE_ACCN);
        this.butAccN.addKeyListener(this);
        this.butDecN = new Button(Messages.getString("MovementDisplay.butDecN"));
        this.butDecN.addActionListener(this);
        this.butDecN.setEnabled(false);
        this.butDecN.setActionCommand(MOVE_DECN);
        this.butDecN.addKeyListener(this);
        this.butEvadeAero = new Button(Messages.getString("MovementDisplay.butEvadeAero"));
        this.butEvadeAero.addActionListener(this);
        this.butEvadeAero.setEnabled(false);
        this.butEvadeAero.setActionCommand(MOVE_EVADE_AERO);
        this.butEvadeAero.addKeyListener(this);
        this.butRoll = new Button(Messages.getString("MovementDisplay.butRoll"));
        this.butRoll.addActionListener(this);
        this.butRoll.setEnabled(false);
        this.butRoll.setActionCommand(MOVE_ROLL);
        this.butRoll.addKeyListener(this);
        this.butLaunch = new Button(Messages.getString("MovementDisplay.butLaunch"));
        this.butLaunch.addActionListener(this);
        this.butLaunch.setEnabled(false);
        this.butLaunch.setActionCommand(MOVE_LAUNCH);
        this.butLaunch.addKeyListener(this);
        this.butRecover = new Button(Messages.getString("MovementDisplay.butRecover"));
        this.butRecover.addActionListener(this);
        this.butRecover.setEnabled(false);
        this.butRecover.setActionCommand(MOVE_RECOVER);
        this.butRecover.addKeyListener(this);
        this.butDump = new Button(Messages.getString("MovementDisplay.butDump"));
        this.butDump.addActionListener(this);
        this.butDump.setEnabled(false);
        this.butDump.setActionCommand(MOVE_DUMP);
        this.butDump.addKeyListener(this);
        this.butRam = new Button(Messages.getString("MovementDisplay.butRam"));
        this.butRam.addActionListener(this);
        this.butRam.setEnabled(false);
        this.butRam.setActionCommand(MOVE_RAM);
        this.butRam.addKeyListener(this);
        this.butHover = new Button(Messages.getString("MovementDisplay.butHover"));
        this.butHover.addActionListener(this);
        this.butHover.setEnabled(false);
        this.butHover.setActionCommand(MOVE_HOVER);
        this.butHover.addKeyListener(this);
        this.butManeuver = new Button(Messages.getString("MovementDisplay.butManeuver"));
        this.butManeuver.addActionListener(this);
        this.butManeuver.setEnabled(false);
        this.butManeuver.setActionCommand(MOVE_MANEUVER);
        this.butManeuver.addKeyListener(this);
        this.butTurnLeft = new Button(Messages.getString("MovementDisplay.butTurnLeft"));
        this.butTurnLeft.addActionListener(this);
        this.butTurnLeft.setEnabled(false);
        this.butTurnLeft.setActionCommand(MOVE_TURN_LEFT);
        this.butTurnLeft.addKeyListener(this);
        this.butTurnRight = new Button(Messages.getString("MovementDisplay.butTurnRight"));
        this.butTurnRight.addActionListener(this);
        this.butTurnRight.setEnabled(false);
        this.butTurnRight.setActionCommand(MOVE_TURN_RIGHT);
        this.butTurnRight.addKeyListener(this);
        this.butThrust = new Button(Messages.getString("MovementDisplay.butThrust"));
        this.butThrust.addActionListener(this);
        this.butThrust.setEnabled(false);
        this.butThrust.setActionCommand(MOVE_THRUST);
        this.butThrust.addKeyListener(this);
        this.butYaw = new Button(Messages.getString("MovementDisplay.butYaw"));
        this.butYaw.addActionListener(this);
        this.butYaw.setEnabled(false);
        this.butYaw.setActionCommand(MOVE_YAW);
        this.butYaw.addKeyListener(this);
        this.butEndOver = new Button(Messages.getString("MovementDisplay.butEndOver"));
        this.butEndOver.addActionListener(this);
        this.butEndOver.setEnabled(false);
        this.butEndOver.setActionCommand(MOVE_END_OVER);
        this.butEndOver.addKeyListener(this);
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butSpace.addKeyListener(this);
        this.buttonsMech = new ArrayList(22);
        this.buttonsMech.add(this.butWalk);
        this.buttonsMech.add(this.butJump);
        this.buttonsMech.add(this.butBackup);
        this.buttonsMech.add(this.butTurn);
        this.buttonsMech.add(this.butUp);
        this.buttonsMech.add(this.butDown);
        this.buttonsMech.add(this.butCharge);
        this.buttonsMech.add(this.butDfa);
        this.buttonsMech.add(this.butLoad);
        this.buttonsMech.add(this.butUnload);
        this.buttonsMech.add(this.butClimbMode);
        this.buttonsMech.add(this.butSearchlight);
        this.buttonsMech.add(this.butHullDown);
        this.buttonsMech.add(this.butSwim);
        this.buttonsMech.add(this.butEvade);
        this.buttonsMech.add(this.butReckless);
        this.buttonsMech.add(this.butEject);
        this.buttonsMech.add(this.butFlee);
        this.buttonsMech.add(this.butRAC);
        this.buttonsMech.add(this.butFortify);
        this.buttonsMech.add(this.butLayMine);
        this.buttonsMech.add(this.butLower);
        this.buttonsMech.add(this.butRaise);
        this.buttonsTank = new ArrayList(22);
        this.buttonsTank.add(this.butWalk);
        this.buttonsTank.add(this.butBackup);
        this.buttonsTank.add(this.butTurn);
        this.buttonsTank.add(this.butLoad);
        this.buttonsTank.add(this.butUnload);
        this.buttonsTank.add(this.butCharge);
        this.buttonsTank.add(this.butClimbMode);
        this.buttonsTank.add(this.butSearchlight);
        this.buttonsTank.add(this.butHullDown);
        this.buttonsTank.add(this.butSwim);
        this.buttonsTank.add(this.butReckless);
        this.buttonsTank.add(this.butEject);
        this.buttonsTank.add(this.butFlee);
        this.buttonsTank.add(this.butRAC);
        this.buttonsTank.add(this.butLayMine);
        this.buttonsTank.add(this.butShakeOff);
        this.buttonsTank.add(this.butDfa);
        this.buttonsTank.add(this.butUp);
        this.buttonsTank.add(this.butDown);
        this.buttonsTank.add(this.butJump);
        this.buttonsTank.add(this.butDigIn);
        this.buttonsTank.add(this.butLower);
        this.buttonsTank.add(this.butRaise);
        this.buttonsVtol = new ArrayList(22);
        this.buttonsVtol.add(this.butWalk);
        this.buttonsVtol.add(this.butBackup);
        this.buttonsVtol.add(this.butLower);
        this.buttonsVtol.add(this.butRaise);
        this.buttonsVtol.add(this.butTurn);
        this.buttonsVtol.add(this.butLoad);
        this.buttonsVtol.add(this.butUnload);
        this.buttonsVtol.add(this.butSearchlight);
        this.buttonsVtol.add(this.butReckless);
        this.buttonsVtol.add(this.butEject);
        this.buttonsVtol.add(this.butFlee);
        this.buttonsVtol.add(this.butRAC);
        this.buttonsVtol.add(this.butShakeOff);
        this.buttonsVtol.add(this.butHullDown);
        this.buttonsVtol.add(this.butLayMine);
        this.buttonsVtol.add(this.butSwim);
        this.buttonsVtol.add(this.butClimbMode);
        this.buttonsVtol.add(this.butCharge);
        this.buttonsVtol.add(this.butDfa);
        this.buttonsVtol.add(this.butUp);
        this.buttonsVtol.add(this.butDown);
        this.buttonsVtol.add(this.butJump);
        this.buttonsVtol.add(this.butDigIn);
        this.buttonsInf = new ArrayList(22);
        this.buttonsInf.add(this.butWalk);
        this.buttonsInf.add(this.butJump);
        this.buttonsInf.add(this.butLower);
        this.buttonsInf.add(this.butRaise);
        this.buttonsInf.add(this.butTurn);
        this.buttonsInf.add(this.butClimbMode);
        this.buttonsInf.add(this.butSearchlight);
        this.buttonsInf.add(this.butEject);
        this.buttonsInf.add(this.butFlee);
        this.buttonsInf.add(this.butRAC);
        this.buttonsInf.add(this.butLayMine);
        this.buttonsInf.add(this.butSwim);
        this.buttonsInf.add(this.butDigIn);
        this.buttonsInf.add(this.butFortify);
        this.buttonsInf.add(this.butClear);
        this.buttonsInf.add(this.butLoad);
        this.buttonsInf.add(this.butUnload);
        this.buttonsInf.add(this.butBackup);
        this.buttonsInf.add(this.butHullDown);
        this.buttonsInf.add(this.butCharge);
        this.buttonsInf.add(this.butDfa);
        this.buttonsInf.add(this.butUp);
        this.buttonsInf.add(this.butDown);
        this.buttonsAero = new ArrayList(22);
        if (!this.client.game.useVectorMove()) {
            this.buttonsAero.add(this.butWalk);
            this.buttonsAero.add(this.butAcc);
            this.buttonsAero.add(this.butDec);
            this.buttonsAero.add(this.butTurn);
            this.buttonsAero.add(this.butAccN);
            this.buttonsAero.add(this.butDecN);
            this.buttonsAero.add(this.butRoll);
            this.buttonsAero.add(this.butEvadeAero);
            this.buttonsAero.add(this.butRam);
            this.buttonsAero.add(this.butLower);
            this.buttonsAero.add(this.butRaise);
            this.buttonsAero.add(this.butManeuver);
            this.buttonsAero.add(this.butEject);
            this.buttonsAero.add(this.butFlee);
            this.buttonsAero.add(this.butLaunch);
            this.buttonsAero.add(this.butRecover);
            this.buttonsAero.add(this.butHover);
            this.buttonsAero.add(this.butRAC);
            this.buttonsAero.add(this.butDump);
            this.buttonsAero.add(this.butFortify);
            this.buttonsAero.add(this.butHullDown);
            this.buttonsAero.add(this.butShakeOff);
        } else {
            this.buttonsAero.add(this.butThrust);
            this.buttonsAero.add(this.butTurnLeft);
            this.buttonsAero.add(this.butTurnRight);
            this.buttonsAero.add(this.butEvadeAero);
            this.buttonsAero.add(this.butRoll);
            this.buttonsAero.add(this.butYaw);
            this.buttonsAero.add(this.butEndOver);
            this.buttonsAero.add(this.butRam);
            this.buttonsAero.add(this.butEject);
            this.buttonsAero.add(this.butFlee);
            this.buttonsAero.add(this.butLaunch);
            this.buttonsAero.add(this.butRecover);
            this.buttonsAero.add(this.butRAC);
            this.buttonsAero.add(this.butDump);
            this.buttonsAero.add(this.butDfa);
            this.buttonsAero.add(this.butUp);
            this.buttonsAero.add(this.butDown);
            this.buttonsAero.add(this.butJump);
            this.buttonsAero.add(this.butDigIn);
            this.buttonsAero.add(this.butFortify);
            this.buttonsAero.add(this.butHullDown);
            this.buttonsAero.add(this.butShakeOff);
        }
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        int n;
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 8));
        ArrayList<Button> arrayList = this.buttonsMech;
        Entity entity = this.ce();
        if (entity != null) {
            if (entity instanceof Infantry) {
                arrayList = this.buttonsInf;
            } else if (entity instanceof VTOL) {
                arrayList = this.buttonsVtol;
            } else if (entity instanceof Tank) {
                arrayList = this.buttonsTank;
            } else if (entity instanceof Aero) {
                arrayList = this.buttonsAero;
            }
        }
        boolean bl = false;
        while (!bl && this.buttonLayout != 0) {
            for (n = this.buttonLayout * 6; n < (this.buttonLayout + 1) * 6 && n < arrayList.size(); ++n) {
                if (!arrayList.get(n).isEnabled()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ++this.buttonLayout;
            if (this.buttonLayout * 6 < arrayList.size()) continue;
            this.buttonLayout = 0;
        }
        this.panButtons.add(this.butNext);
        for (n = this.buttonLayout * 6; n < (this.buttonLayout + 1) * 6 && n < arrayList.size(); ++n) {
            this.panButtons.add(arrayList.get(n));
        }
        this.panButtons.add(this.butMore);
        this.validate();
    }

    public synchronized void selectEntity(int n) {
        Entity entity = this.client.game.getEntity(n);
        if (entity == null) {
            System.err.println("MovementDisplay: tried to select non-existant entity: " + n);
            return;
        }
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        this.clearAllMoves();
        this.updateButtons();
        this.clientgui.getMenuBar().setEntity(entity);
        this.clientgui.getBoardView().highlight(entity.getPosition());
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.mechD.displayEntity(entity);
        this.clientgui.mechD.showPanel("movement");
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.bv.centerOnHex(entity.getPosition());
        }
    }

    private void updateButtons() {
        Entity entity = this.ce();
        boolean bl = entity instanceof Mech;
        boolean bl2 = entity instanceof Infantry;
        boolean bl3 = entity instanceof Aero;
        this.setWalkEnabled(!entity.isImmobile() && (entity.getWalkMP() > 0 || entity.getRunMP() > 0) && !entity.isStuck());
        this.setJumpEnabled(!bl3 && !entity.isImmobile() && entity.getJumpMP() > 0 && (!entity.isStuck() || entity.canUnstickByJumping()));
        this.setSwimEnabled(!bl3 && !entity.isImmobile() && entity.hasUMU() && this.client.game.getBoard().getHex(entity.getPosition()).containsTerrain(2));
        this.setBackUpEnabled(this.butWalk.isEnabled() && !bl3);
        this.setChargeEnabled(entity.canCharge());
        this.setDFAEnabled(entity.canDFA());
        this.setRamEnabled(entity.canRam());
        if (bl2) {
            if (this.client.game.containsMinefield(entity.getPosition())) {
                this.setClearEnabled(true);
            } else {
                this.setClearEnabled(false);
            }
        } else {
            this.setClearEnabled(false);
        }
        if (entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9 || entity.getMovementMode() == 18 || entity.getMovementMode() == 6 || entity.getMovementMode() == 19 || entity.getMovementMode() == 20 || entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
            this.butClimbMode.setEnabled(false);
        } else {
            this.butClimbMode.setEnabled(true);
        }
        if (bl2) {
            this.butDigIn.setEnabled(true);
            this.butFortify.setEnabled(true);
        } else {
            this.butDigIn.setEnabled(false);
            this.butFortify.setEnabled(false);
        }
        this.setTurnEnabled(!entity.isImmobile() && !entity.isStuck() && (entity.getWalkMP() > 0 || entity.getJumpMP() > 0));
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateLoadButtons();
        this.updateElevationButtons();
        this.setEvadeEnabled(bl && this.client.game.getOptions().booleanOption("tacops_evade"));
        this.updateRecoveryButton();
        this.updateDumpButton();
        if (entity instanceof Aero) {
            this.butThrust.setEnabled(true);
            this.butYaw.setEnabled(true);
            this.butEndOver.setEnabled(true);
            this.butTurnLeft.setEnabled(true);
            this.butTurnRight.setEnabled(true);
            this.setEvadeAeroEnabled(true);
            this.setEjectEnabled(true);
            if ((((Aero)entity).isSpheroid() || this.client.game.getPlanetaryConditions().isVacuum()) && this.client.game.getBoard().inAtmosphere()) {
                this.setTurnEnabled(false);
            }
        }
        this.updateSpeedButtons();
        this.updateThrustButton();
        this.updateRollButton();
        this.checkFuel();
        this.checkOOC();
        this.checkAtmosphere();
        this.updateFleeButton();
        this.updateLaunchButton();
        this.updateRecklessButton();
        this.updateHoverButton();
        this.updateManeuverButton();
        if (bl2 && entity.hasWorkingMisc(262144L, 1L)) {
            this.butFortify.setEnabled(true);
        } else {
            this.butFortify.setEnabled(false);
        }
        if (bl2 && this.client.game.getOptions().booleanOption("tacops_dig_in")) {
            this.butDigIn.setEnabled(true);
        } else {
            this.butDigIn.setEnabled(false);
        }
        this.butShakeOff.setEnabled(entity instanceof Tank && entity.getSwarmAttackerId() != -1);
        this.setLayMineEnabled(entity.canLayMine());
        this.setFleeEnabled(entity.canFlee());
        if (this.client.game.getOptions().booleanOption("vehicles_can_eject")) {
            this.setEjectEnabled(!bl2 && (!bl || ((Mech)entity).getCockpitType() != 1) && entity.isActive());
        } else {
            this.setEjectEnabled(bl && ((Mech)entity).getCockpitType() != 1 && entity.isActive());
        }
        this.setupButtonPanel();
        this.updateTransformationButtons(entity);
    }

    private void updateTransformationButtons(Entity entity) {
        if (entity instanceof LandAirMech) {
            LandAirMech landAirMech = (LandAirMech)entity;
            this.setLAMmechModeEnabled(landAirMech.canConvertToMech());
            this.setLAMairmechModeEnabled(landAirMech.canConvertToAirmech());
            this.setLAMaircraftModeEnabled(landAirMech.canConvertToAircraft());
        } else {
            this.setLAMmechModeEnabled(false);
            this.setLAMairmechModeEnabled(false);
            this.setLAMaircraftModeEnabled(false);
        }
    }

    private void beginMyTurn() {
        this.setStatusBarText(Messages.getString("MovementDisplay.its_your_turn"));
        this.selectEntity(this.client.getFirstEntityNum());
        this.butDone.setLabel(Messages.getString("MovementDisplay.Done"));
        this.butDone.setEnabled(true);
        this.setNextEnabled(true);
        this.butMore.setEnabled(true);
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.setDisplayVisible(true);
        }
    }

    private synchronized void endMyTurn() {
        Entity entity = this.ce();
        this.disableButtons();
        Entity entity2 = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (IGame.Phase.PHASE_MOVEMENT == this.client.game.getPhase() && null != entity2 && null != entity && entity2.getOwnerId() != entity.getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
    }

    private void disableButtons() {
        this.setWalkEnabled(false);
        this.setJumpEnabled(false);
        this.setBackUpEnabled(false);
        this.setTurnEnabled(false);
        this.setFleeEnabled(false);
        this.setEjectEnabled(false);
        this.setUnjamEnabled(false);
        this.setSearchlightEnabled(false, false);
        this.setGetUpEnabled(false);
        this.setGoProneEnabled(false);
        this.setChargeEnabled(false);
        this.setDFAEnabled(false);
        this.setNextEnabled(false);
        this.butMore.setEnabled(false);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(false);
        this.setUnloadEnabled(false);
        this.setClearEnabled(false);
        this.setHullDownEnabled(false);
        this.setSwimEnabled(false);
        this.setEvadeEnabled(false);
        this.setAccEnabled(false);
        this.setDecEnabled(false);
        this.setEvadeAeroEnabled(false);
        this.setAccNEnabled(false);
        this.setDecNEnabled(false);
        this.setRollEnabled(false);
        this.setLaunchEnabled(false);
        this.setThrustEnabled(false);
        this.setYawEnabled(false);
        this.setEndOverEnabled(false);
        this.setTurnLeftEnabled(false);
        this.setTurnRightEnabled(false);
        this.setDumpEnabled(false);
        this.setRamEnabled(false);
        this.setHoverEnabled(false);
        this.setManeuverEnabled(false);
        this.setRecklessEnabled(false);
    }

    private void clearAllMoves() {
        Entity entity = this.ce();
        if (entity.getMovementMode() == 13) {
            entity.setMovementMode(1);
        } else if (entity.getMovementMode() == 14) {
            entity.setMovementMode(2);
        }
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.cmd = new MovePath(this.client.game, entity);
        this.gear = 0;
        this.clientgui.bv.clearMovementData();
        this.butDone.setLabel(Messages.getString("MovementDisplay.Done"));
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateElevationButtons();
        this.updateFleeButton();
        this.updateLaunchButton();
        this.updateRecklessButton();
        this.updateHoverButton();
        this.updateManeuverButton();
        this.loadedUnits = entity.getLoadedUnits();
        this.updateLoadButtons();
        this.updateElevationButtons();
        this.updateRecoveryButton();
        this.updateSpeedButtons();
        this.updateThrustButton();
        this.updateRollButton();
        this.checkFuel();
        this.checkOOC();
        this.checkAtmosphere();
    }

    private void removeLastStep() {
        this.cmd.removeLastStep();
        if (this.cmd.length() == 0) {
            this.clearAllMoves();
        } else {
            this.clientgui.bv.drawMovementData(this.ce(), this.cmd);
            MovePath movePath = this.cmd.clone();
            movePath.clipToPossible();
            if (movePath.length() == 0) {
                this.butDone.setLabel(Messages.getString("MovementDisplay.Done"));
            }
        }
    }

    private synchronized void moveTo(MovePath movePath) {
        Object object;
        Object object2;
        Entity entity = this.ce();
        boolean bl = false;
        if (entity instanceof Aero) {
            object2 = (Aero)entity;
            if (this.client.game.getBoard().inAtmosphere() && !((Aero)object2).isVSTOL() && !((Aero)object2).isSpheroid() && !this.client.game.getPlanetaryConditions().isVacuum() && (movePath == null && ((Aero)object2).getCurrentVelocity() == 0 || movePath != null && movePath.getFinalVelocity() == 0)) {
                movePath.addStep(44);
            }
            if (movePath != null) {
                boolean bl2 = false;
                if (movePath.getLastStep() != null && movePath.getLastStep().getType() == 46) {
                    bl2 = true;
                }
                if (this.client.game.useVectorMove() && !bl2) {
                    movePath.clipToPossible();
                    movePath = this.addSteps(movePath, entity);
                }
                if (!this.client.game.useVectorMove() && (((Aero)object2).isOutControlTotal() || ((Entity)object2).isShutDown() || ((Entity)object2).getCrew().isUnconscious())) {
                    Serializable serializable;
                    object = movePath;
                    bl = true;
                    movePath = new MovePath(this.client.game, entity);
                    int n = ((Aero)object2).getCurrentVelocity();
                    if (n == 0 && !((Aero)object2).isSpheroid() && !this.client.game.getPlanetaryConditions().isVacuum() && this.client.game.getBoard().inAtmosphere() && !((Aero)object2).isVSTOL()) {
                        movePath.addStep(44);
                    }
                    while (n > 0) {
                        boolean bl3;
                        serializable = ((Entity)object2).getPosition();
                        int n2 = ((Entity)object2).getFacing();
                        MoveStep moveStep = movePath.getLastStep();
                        if (moveStep != null) {
                            serializable = moveStep.getPosition();
                            n2 = moveStep.getFacing();
                        }
                        boolean bl4 = bl3 = ((Coords)serializable).x % 2 == 0;
                        if (((Coords)serializable).x == 0 && (n2 == 5 || n2 == 4) || ((Coords)serializable).x == this.client.game.getBoard().getWidth() - 1 && (n2 == 1 || n2 == 2) || ((Coords)serializable).y == 0 && (n2 == 1 || n2 == 5 || n2 == 0) && bl3 || ((Coords)serializable).y == 0 && n2 == 0 || ((Coords)serializable).y == this.client.game.getBoard().getHeight() - 1 && (n2 == 2 || n2 == 3 || n2 == 4) && !bl3 || ((Coords)serializable).y == this.client.game.getBoard().getHeight() - 1 && n2 == 3) {
                            movePath.addStep(39);
                            n = 0;
                            continue;
                        }
                        if (((Aero)object2).isRandomMove()) {
                            int n3 = Compute.d6(1);
                            switch (n3) {
                                case 1: {
                                    movePath.addStep(1);
                                    movePath.addStep(3);
                                    movePath.addStep(3);
                                }
                                case 2: {
                                    movePath.addStep(1);
                                    movePath.addStep(3);
                                }
                                case 3: 
                                case 4: {
                                    movePath.addStep(1);
                                }
                                case 5: {
                                    movePath.addStep(1);
                                    movePath.addStep(4);
                                }
                                case 6: {
                                    movePath.addStep(1);
                                    movePath.addStep(4);
                                    movePath.addStep(4);
                                }
                            }
                        } else {
                            movePath.addStep(1);
                        }
                        --n;
                    }
                    if (((MovePath)object).contains(40) && !movePath.contains(39) && ((MoveStep)(serializable = ((MovePath)object).getLastStep())).getType() == 40) {
                        movePath.addStep(((MoveStep)serializable).getType(), ((MoveStep)serializable).getLaunched());
                    }
                } else {
                    movePath.clipToPossible();
                    object = movePath.getLastStep();
                    if (object != null) {
                        if (((MoveStep)object).getVelocityLeft() > 0 && !this.client.game.useVectorMove() && ((MoveStep)object).getType() != 10) {
                            String string = Messages.getString("MovementDisplay.VelocityLeft.title");
                            String string2 = Messages.getString("MovementDisplay.VelocityLeft.message");
                            this.clientgui.doAlertDialog(string, string2);
                            return;
                        }
                    } else if (((Aero)object2).getCurrentVelocity() > 0 && !this.client.game.useVectorMove()) {
                        String string = Messages.getString("MovementDisplay.VelocityLeft.title");
                        String string3 = Messages.getString("MovementDisplay.VelocityLeft.message");
                        this.clientgui.doAlertDialog(string, string3);
                        return;
                    }
                }
                object = SharedUtility.doThrustCheck(movePath);
                if (!this.client.game.useVectorMove() && ((String)object).length() > 0 && GUIPreferences.getInstance().getNagForPSR()) {
                    ConfirmDialog confirmDialog = new ConfirmDialog(this.clientgui.frame, Messages.getString("MovementDisplay.areYouSure"), Messages.getString("MovementDisplay.ConfirmPilotingRoll") + (String)object, true);
                    confirmDialog.setVisible(true);
                    if (confirmDialog.getAnswer()) {
                        if (!confirmDialog.getShowAgain()) {
                            GUIPreferences.getInstance().setNagForPSR(false);
                        }
                    } else {
                        return;
                    }
                }
            }
        }
        movePath.clipToPossible();
        if (movePath.length() == 0 && GUIPreferences.getInstance().getNagForNoAction()) {
            String string;
            object2 = Messages.getString("MovementDisplay.ConfirmNoMoveDlg.title");
            object = this.clientgui.doYesNoBotherDialog((String)object2, string = Messages.getString("MovementDisplay.ConfirmNoMoveDlg.message"));
            if (!((ConfirmDialog)object).getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!((ConfirmDialog)object).getAnswer()) {
                return;
            }
        }
        if (movePath.hasActiveMASC() && GUIPreferences.getInstance().getNagForMASC()) {
            object2 = (Mech)this.ce();
            ConfirmDialog confirmDialog = new ConfirmDialog(this.clientgui.frame, Messages.getString("MovementDisplay.areYouSure"), Messages.getString("MovementDisplay.ConfirmMoveRoll", new Object[]{new Integer(((Mech)object2).getMASCTarget())}), true);
            confirmDialog.setVisible(true);
            if (confirmDialog.getAnswer()) {
                if (!confirmDialog.getShowAgain()) {
                    GUIPreferences.getInstance().setNagForMASC(false);
                }
            } else {
                return;
            }
        }
        if (((String)(object2 = SharedUtility.doPSRCheck(movePath, this.client))).length() > 0 && GUIPreferences.getInstance().getNagForPSR() && !bl) {
            ConfirmDialog confirmDialog = new ConfirmDialog(this.clientgui.frame, Messages.getString("MovementDisplay.areYouSure"), Messages.getString("MovementDisplay.ConfirmPilotingRoll") + (String)object2, true);
            confirmDialog.setVisible(true);
            if (confirmDialog.getAnswer()) {
                if (!confirmDialog.getShowAgain()) {
                    GUIPreferences.getInstance().setNagForPSR(false);
                }
            } else {
                return;
            }
        }
        this.disableButtons();
        this.clientgui.bv.clearMovementData();
        if (this.ce().hasUMU() || this.ce() instanceof LandAirMech) {
            this.client.sendUpdateEntity(this.ce());
        }
        this.client.moveEntity(this.cen, movePath);
    }

    private synchronized Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private void currentMove(Coords coords) {
        if (this.shiftheld || this.gear == 5) {
            this.cmd.rotatePathfinder(this.cmd.getFinalCoords().direction(coords), false);
        } else if (this.gear == 0 || this.gear == 2) {
            this.cmd.findPathTo(coords, 1);
        } else if (this.gear == 1) {
            this.cmd.findPathTo(coords, 2);
        } else if (this.gear == 3) {
            this.cmd.findPathTo(coords, 8);
        } else if (this.gear == 4) {
            this.cmd.findPathTo(coords, 9);
        } else if (this.gear == 6) {
            this.cmd.findPathTo(coords, 27);
        } else if (this.gear == 7) {
            this.cmd.findPathTo(coords, 1);
        } else if (this.gear == 8) {
            this.cmd.addStep(20, true, true);
            this.cmd.addStep(20, true, true);
            this.cmd.addStep(34, true, true);
            this.cmd.addStep(34, true, true);
            this.cmd.rotatePathfinder(this.cmd.getFinalCoords().direction(coords), true);
            this.gear = 0;
        } else if (this.gear == 9) {
            this.cmd.addStep(21, true, true);
            this.cmd.addStep(21, true, true);
            this.cmd.addStep(33, true, true);
            this.cmd.rotatePathfinder(this.cmd.getFinalCoords().direction(coords), true);
            this.gear = 0;
        }
    }

    @Override
    public synchronized void hexMoused(BoardViewEvent boardViewEvent) {
        boolean bl;
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        boolean bl2 = bl = entity instanceof Aero && this.client.game.useVectorMove();
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        if (this.shiftheld != ((boardViewEvent.getModifiers() & 1) != 0)) {
            boolean bl3 = this.shiftheld = (boardViewEvent.getModifiers() & 1) != 0;
        }
        if (boardViewEvent.getType() == 2 && !bl) {
            if (!boardViewEvent.getCoords().equals(this.clientgui.getBoardView().getLastCursor()) || this.shiftheld || this.gear == 5) {
                this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
                if (entity != null) {
                    this.currentMove(boardViewEvent.getCoords());
                    this.clientgui.bv.drawMovementData(entity, this.cmd);
                }
            }
        } else if (boardViewEvent.getType() == 0) {
            Coords coords = boardViewEvent.getCoords();
            this.clientgui.bv.drawMovementData(entity, this.cmd);
            this.clientgui.getBoardView().select(boardViewEvent.getCoords());
            if (this.shiftheld || this.gear == 5) {
                this.butDone.setLabel(Messages.getString("MovementDisplay.Move"));
                MovePath movePath = this.cmd.clone();
                movePath.clipToPossible();
                if (movePath.length() == 0) {
                    this.butDone.setLabel(Messages.getString("MovementDisplay.Done"));
                }
                return;
            }
            if (this.gear == 7) {
                Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
                if (targetable == null || targetable.equals(entity) || !(targetable instanceof Aero)) {
                    this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantRam"), Messages.getString("MovementDisplay.NoTarget"));
                    this.clearAllMoves();
                    return;
                }
                if (entity instanceof Aero && this.client.game.useVectorMove()) {
                    this.cmd.clipToPossible();
                    this.cmd = this.addSteps(this.cmd, entity);
                }
                this.cmd.addStep(46);
                ToHitData toHitData = new RamAttackAction(this.cen, targetable.getTargetType(), targetable.getTargetId(), targetable.getPosition()).toHit(this.client.game, this.cmd);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    Aero aero = (Aero)targetable;
                    Aero aero2 = (Aero)entity;
                    int n = RamAttackAction.getDamageTakenBy(aero2, aero, this.cmd.getSecondFinalPosition(aero2.getPosition()), this.cmd.getHexesMoved(), aero.getCurrentVelocity());
                    int n2 = RamAttackAction.getDamageFor(aero2, aero, this.cmd.getSecondFinalPosition(aero2.getPosition()), this.cmd.getHexesMoved(), aero.getCurrentVelocity());
                    if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.RamDialog.title", new Object[]{targetable.getDisplayName()}), Messages.getString("MovementDisplay.RamDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(n2), toHitData.getTableDesc(), new Integer(n)}))) {
                        this.cmd.getLastStep().setTarget(targetable);
                        this.moveTo(this.cmd);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantRam"), toHitData.getDesc());
                this.clearAllMoves();
                return;
            }
            if (this.gear == 3) {
                Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
                if (targetable == null || targetable.equals(entity)) {
                    this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantCharge"), Messages.getString("MovementDisplay.NoTarget"));
                    this.clearAllMoves();
                    return;
                }
                ToHitData toHitData = new ChargeAttackAction(this.cen, targetable.getTargetType(), targetable.getTargetId(), targetable.getPosition()).toHit(this.client.game, this.cmd);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    int n = 0;
                    if (targetable.getTargetType() == 0) {
                        Entity entity2 = (Entity)targetable;
                        n = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.client.game.getOptions().booleanOption("tacops_charge_damage"), this.cmd.getHexesMoved());
                    } else if (targetable.getTargetType() == 15 || targetable.getTargetType() == 3) {
                        Building building = this.client.game.getBoard().getBuildingAt(coords);
                        n = ChargeAttackAction.getDamageTakenBy(entity, building, coords);
                    }
                    if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.ChargeDialog.title", new Object[]{targetable.getDisplayName()}), Messages.getString("MovementDisplay.ChargeDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(ChargeAttackAction.getDamageFor(entity, this.client.game.getOptions().booleanOption("tacops_charge_damage"), this.cmd.getHexesMoved())), toHitData.getTableDesc(), new Integer(n)}))) {
                        this.cmd.getLastStep().setTarget(targetable);
                        this.moveTo(this.cmd);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantCharge"), toHitData.getDesc());
                this.clearAllMoves();
                return;
            }
            if (this.gear == 4) {
                Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
                if (targetable == null || targetable.equals(entity)) {
                    this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantDFA"), Messages.getString("MovementDisplay.NoTarget"));
                    this.clearAllMoves();
                    return;
                }
                ToHitData toHitData = DfaAttackAction.toHit(this.client.game, this.cen, targetable, this.cmd);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.DFADialog.title", new Object[]{targetable.getDisplayName()}), Messages.getString("MovementDisplay.DFADialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(DfaAttackAction.getDamageFor(entity, targetable instanceof Infantry && !(targetable instanceof BattleArmor))), toHitData.getTableDesc(), new Integer(DfaAttackAction.getDamageTakenBy(entity))}))) {
                        this.cmd.getLastStep().setTarget(targetable);
                        this.moveTo(this.cmd);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantDFA"), toHitData.getDesc());
                this.clearAllMoves();
                return;
            }
            this.butDone.setLabel(Messages.getString("MovementDisplay.Move"));
            this.updateProneButtons();
            this.updateRACButton();
            this.updateSearchlightButton();
            this.updateLoadButtons();
            this.updateElevationButtons();
            this.updateFleeButton();
            this.updateLaunchButton();
            this.updateRecklessButton();
            this.updateHoverButton();
            this.updateManeuverButton();
            this.updateSpeedButtons();
            this.updateThrustButton();
            this.updateRollButton();
            this.checkFuel();
            this.checkOOC();
            this.checkAtmosphere();
        }
    }

    private synchronized void updateProneButtons() {
        Entity entity = this.ce();
        if (entity != null) {
            boolean bl = entity instanceof Mech;
            if (this.cmd.getFinalProne()) {
                this.setGetUpEnabled(!entity.isImmobile() && !entity.isStuck());
                this.setGoProneEnabled(false);
                this.setHullDownEnabled(true);
            } else if (this.cmd.getFinalHullDown()) {
                if (bl) {
                    this.setGetUpEnabled(!entity.isImmobile() && !entity.isStuck() && !((Mech)entity).cannotStandUpFromHullDown());
                } else {
                    this.setGetUpEnabled(!entity.isImmobile() && !entity.isStuck());
                }
                this.setGoProneEnabled(!entity.isImmobile() && bl && !entity.isStuck());
                this.setHullDownEnabled(false);
            } else {
                this.setGetUpEnabled(false);
                this.setGoProneEnabled(!entity.isImmobile() && bl && !entity.isStuck() && !this.butUp.isEnabled());
                this.setHullDownEnabled(entity.canGoHullDown());
            }
        } else {
            this.setGetUpEnabled(false);
            this.setGoProneEnabled(false);
            this.setHullDownEnabled(false);
        }
    }

    private void updateRACButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setUnjamEnabled(entity.canUnjamRAC() && (this.gear == 0 || this.gear == 5 || this.gear == 1) && this.cmd.getMpUsed() <= entity.getWalkMP());
    }

    private void updateSearchlightButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setSearchlightEnabled(entity.hasSpotlight() && !this.cmd.contains(22), this.ce().isUsingSpotlight());
    }

    private synchronized void updateElevationButtons() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (entity instanceof Aero && ((Aero)entity).isOutControlTotal()) {
            this.setRaiseEnabled(false);
            this.setLowerEnabled(false);
            return;
        }
        this.setRaiseEnabled(entity.canGoUp(this.cmd.getFinalElevation(), this.cmd.getFinalCoords()));
        this.setLowerEnabled(entity.canGoDown(this.cmd.getFinalElevation(), this.cmd.getFinalCoords()));
    }

    private void updateRollButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        this.setRollEnabled(true);
        if (this.client.game.getBoard().inAtmosphere()) {
            this.setRollEnabled(false);
        }
        if (this.cmd.contains(38)) {
            this.setRollEnabled(false);
        }
    }

    private void updateHoverButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        if (!aero.isSpheroid() && !this.client.game.getPlanetaryConditions().isVacuum()) {
            return;
        }
        if (!this.client.game.getBoard().inAtmosphere()) {
            return;
        }
        if (!this.cmd.contains(47)) {
            this.setHoverEnabled(true);
        } else {
            this.setHoverEnabled(false);
        }
    }

    private void updateThrustButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        int n = 0;
        MoveStep moveStep = this.cmd.getLastStep();
        if (null != moveStep) {
            n = moveStep.getMpUsed();
        }
        if (n >= aero.getRunMP()) {
            this.setThrustEnabled(false);
        } else {
            this.setThrustEnabled(true);
        }
    }

    private synchronized void updateSpeedButtons() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        this.setAccEnabled(false);
        this.setDecEnabled(false);
        MoveStep moveStep = this.cmd.getLastStep();
        int n = aero.getCurrentVelocity();
        int n2 = aero.getNextVelocity();
        if (null != moveStep) {
            n = moveStep.getVelocity();
            n2 = moveStep.getVelocityN();
        }
        if (null == moveStep) {
            this.setAccEnabled(true);
            if (n > 0) {
                this.setDecEnabled(true);
            }
        } else if (moveStep.getType() == 33) {
            this.setAccEnabled(true);
        } else if (moveStep.getType() == 34 && n > 0) {
            this.setDecEnabled(true);
        }
        if (aero.didFailManeuver()) {
            this.setAccEnabled(false);
            this.setDecEnabled(false);
        }
        if (aero.didAccLast()) {
            this.setAccEnabled(false);
            this.setDecEnabled(false);
        }
        this.setAccNEnabled(false);
        this.setDecNEnabled(false);
        if (!(this.cmd.contains(33) || this.cmd.contains(34) || this.cmd.contains(37))) {
            this.setAccNEnabled(true);
        }
        if (!(this.cmd.contains(33) || this.cmd.contains(34) || this.cmd.contains(36) || n2 <= 0)) {
            this.setDecNEnabled(true);
        }
        if (aero.didFailManeuver() && aero.didAccDecNow()) {
            this.setDecNEnabled(false);
            this.setAccNEnabled(false);
        }
        if (!this.client.game.getBoard().inSpace() && n == 2 * aero.getWalkMP()) {
            this.setAccEnabled(false);
        }
        if (!this.client.game.getBoard().inSpace() && n2 == 4 * aero.getWalkMP()) {
            this.setAccNEnabled(false);
        }
        if (aero instanceof TeleMissile) {
            this.setDecEnabled(false);
            this.setDecNEnabled(false);
        }
    }

    private void updateDumpButton() {
        if (this.ce() instanceof Aero) {
            Aero aero = (Aero)this.ce();
            this.setDumpEnabled(aero.hasBombs() && this.cmd.length() == 0);
        } else {
            this.setDumpEnabled(false);
        }
    }

    private void updateFleeButton() {
        Entity entity = this.ce();
        if (entity instanceof Aero) {
            boolean bl;
            MoveStep moveStep = this.cmd.getLastStep();
            Coords coords = entity.getPosition();
            int n = entity.getFacing();
            Aero aero = (Aero)entity;
            int n2 = aero.getCurrentVelocity();
            if (moveStep != null) {
                coords = moveStep.getPosition();
                n = moveStep.getFacing();
                n2 = moveStep.getVelocityLeft();
            }
            boolean bl2 = bl = coords.x % 2 == 0;
            if (n2 > 0 && (coords.x == 0 && (n == 5 || n == 4) || coords.x == this.client.game.getBoard().getWidth() - 1 && (n == 1 || n == 2) || coords.y == 0 && (n == 1 || n == 5 || n == 0) && bl || coords.y == 0 && n == 0 || coords.y == this.client.game.getBoard().getHeight() - 1 && (n == 2 || n == 3 || n == 4) && !bl || coords.y == this.client.game.getBoard().getHeight() - 1 && n == 3)) {
                this.setFleeEnabled(true);
            } else {
                this.setFleeEnabled(false);
            }
        }
    }

    private void updateLaunchButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setLaunchEnabled(entity.getLaunchableFighters().size() > 0 || entity.getLaunchableSmallCraft().size() > 0);
    }

    private void updateRecklessButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (entity instanceof Protomech) {
            this.setRecklessEnabled(false);
        } else {
            this.setRecklessEnabled(null == this.cmd || this.cmd.length() == 0);
        }
    }

    private void updateManeuverButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        if (aero.isSpheroid() || this.client.game.getPlanetaryConditions().isVacuum()) {
            return;
        }
        if (!(aero.didFailManeuver() || null != this.cmd && this.cmd.contains(48))) {
            this.setManeuverEnabled(true);
        }
    }

    private synchronized void updateLoadButtons() {
        Object object;
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        boolean bl = this.gear == 0 || this.gear == 5 || this.gear == 1;
        int n = this.cmd.getFinalElevation();
        IHex iHex = entity.getGame().getBoard().getHex(this.cmd.getFinalCoords());
        boolean bl2 = false;
        Object object2 = this.loadedUnits.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (!((Entity)object).isElevationValid(n, iHex) && ((Entity)object).getJumpMP() <= 0) continue;
            bl2 = true;
            break;
        }
        if (!bl || this.loadedUnits.size() == 0 || this.cen == -1 || !bl2) {
            this.setUnloadEnabled(false);
        } else {
            this.setUnloadEnabled(true);
        }
        if (this.cmd.length() > 0 || this.cen == -1) {
            this.setLoadEnabled(false);
        } else {
            object2 = null;
            object = this.client.game.getEntities(entity.getPosition());
            boolean bl3 = false;
            while (object.hasMoreElements()) {
                object2 = (Entity)object.nextElement();
                if (!entity.getOwner().isEnemyOf(((Entity)object2).getOwner()) && !entity.equals(object2)) {
                    if (entity.getWalkMP() <= 0 || !entity.canLoad((Entity)object2) || !((Entity)object2).isLoadableThisTurn()) break;
                    this.setLoadEnabled(true);
                    bl3 = true;
                    break;
                }
                object2 = null;
            }
            if (!bl3) {
                this.setLoadEnabled(false);
            }
        }
    }

    private Entity getUnloadedUnit() {
        Entity entity = this.ce();
        Entity entity2 = null;
        if (this.loadedUnits.size() == 0) {
            System.err.println("MovementDisplay#getUnloadedUnit() called without loaded units.");
        } else if (this.loadedUnits.size() > 1) {
            String[] stringArray = new String[this.loadedUnits.size()];
            String string = Messages.getString("MovementDisplay.UnloadUnitDialog.message", new Object[]{entity.getShortName(), entity.getUnusedString()});
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.loadedUnits.elementAt(i).getShortName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.UnloadUnitDialog.title"), string, stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                entity2 = this.loadedUnits.elementAt(singleChoiceDialog.getChoice());
            }
        } else {
            entity2 = this.loadedUnits.elementAt(0);
            this.loadedUnits.removeElementAt(0);
        }
        return entity2;
    }

    private synchronized void updateRecoveryButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (entity instanceof Aero) {
            Coords coords = this.cmd.getFinalCoords();
            if (this.client.game.useVectorMove()) {
                coords = Compute.getFinalPosition(entity.getPosition(), this.cmd.getFinalVectors());
            }
            Entity entity2 = null;
            Enumeration<Entity> enumeration = this.client.game.getEntities(coords);
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                entity2 = enumeration.nextElement();
                if (!entity.getOwner().isEnemyOf(entity2.getOwner()) && !entity.equals(entity2) && entity2 instanceof Aero && entity2.isDone() && entity2.canLoad(entity) && this.cmd.getFinalFacing() == entity2.getFacing()) {
                    Aero aero = (Aero)entity2;
                    if (this.client.game.useVectorMove()) {
                        if (Compute.sameVectors(this.cmd.getFinalVectors(), aero.getVectors())) {
                            this.setRecoverEnabled(true);
                            bl = true;
                        }
                    } else if (this.cmd.getFinalVelocity() == aero.getCurrentVelocity()) {
                        this.setRecoverEnabled(true);
                        bl = true;
                    }
                }
                entity2 = null;
            }
            if (!bl) {
                this.setRecoverEnabled(false);
            }
        }
    }

    private Vector<Integer[]> getLaunchedUnits() {
        Entity entity = this.ce();
        Vector<Integer[]> vector = new Vector<Integer[]>();
        Vector<Entity> vector2 = entity.getLaunchableFighters();
        Vector<Entity> vector3 = entity.getLaunchableSmallCraft();
        if (vector2.size() <= 0 && vector3.size() <= 0) {
            System.err.println("MovementDisplay#getUnloadedUnit() called without loaded units.");
        } else {
            int n = 1;
            Vector<Object> vector4 = new Vector();
            int n2 = 0;
            Vector<Bay> vector5 = entity.getFighterBays();
            for (int i = 0; i < vector5.size(); ++i) {
                Bay bay = vector5.elementAt(i);
                vector4 = bay.getLaunchableUnits();
                n2 = bay.getDoors();
                for (int j = 0; j < n2; ++j) {
                    int n3;
                    if (vector4.size() <= 0) continue;
                    String[] stringArray = new String[vector4.size()];
                    String string = Messages.getString("MovementDisplay.LaunchFighterDialog.message", new Object[]{entity.getShortName(), n, j + 1});
                    for (int k = 0; k < stringArray.length; ++k) {
                        stringArray[k] = ((Entity)vector4.elementAt(k)).getShortName();
                    }
                    ChoiceDialog choiceDialog = new ChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.LaunchFighterDialog.title", new Object[]{bay.getType(), n, j + 1}), string, stringArray);
                    choiceDialog.setVisible(true);
                    if (!choiceDialog.getAnswer()) continue;
                    int[] nArray = choiceDialog.getChoices();
                    int n4 = nArray.length - 2;
                    int n5 = 0;
                    boolean bl = false;
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        int n6;
                        n5 = 0;
                        if ((((Aero)entity).isOutControlTotal() || n3 > 1) && !bl && (n6 = Compute.d6(2)) == 2) {
                            n5 = 1;
                            bl = true;
                        }
                        vector.add(new Integer[]{((Entity)vector4.elementAt(nArray[n3])).getId(), n4, n5});
                    }
                    for (n3 = nArray.length; n3 > 0; --n3) {
                        vector4.remove(nArray[n3 - 1]);
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    private int getRecoveryUnit() {
        Object object;
        Entity entity = this.ce();
        Vector<Integer> vector = new Vector<Integer>();
        Coords coords = this.cmd.getFinalCoords();
        if (this.client.game.useVectorMove()) {
            coords = Compute.getFinalPosition(entity.getPosition(), this.cmd.getFinalVectors());
        }
        Entity entity2 = null;
        Enumeration<Entity> enumeration = this.client.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            entity2 = enumeration.nextElement();
            if (!entity.getOwner().isEnemyOf(entity2.getOwner()) && !entity.equals(entity2) && entity2 instanceof Aero && !((Aero)entity2).isOutControlTotal() && entity2.isDone() && entity2.canLoad(entity) && entity.isLoadableThisTurn() && this.cmd.getFinalFacing() == entity2.getFacing()) {
                object = (Aero)entity2;
                if (this.client.game.useVectorMove()) {
                    if (Compute.sameVectors(this.cmd.getFinalVectors(), ((Entity)object).getVectors())) {
                        vector.add(entity2.getId());
                    }
                } else if (this.cmd.getFinalVelocity() == ((Aero)object).getCurrentVelocity()) {
                    vector.add(entity2.getId());
                }
            }
            entity2 = null;
        }
        if (vector.size() < 1) {
            return -1;
        }
        if (vector.size() == 1) {
            if (this.client.game.getEntity((int)((Integer)vector.elementAt((int)0)).intValue()).mpUsed > 0) {
                if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.RecoverSureDialog.title"), Messages.getString("MovementDisplay.RecoverSureDialog.message"))) {
                    return (Integer)vector.elementAt(0);
                }
            } else {
                return (Integer)vector.elementAt(0);
            }
            return -1;
        }
        object = new String[vector.size()];
        for (int i = 0; i < ((String[])object).length; ++i) {
            object[i] = this.client.game.getEntity((Integer)vector.elementAt(i)).getShortName();
        }
        String string = Messages.getString("MovementDisplay.RecoverFighterDialog.message");
        SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.RecoverFighterDialog.title"), string, (String[])object);
        singleChoiceDialog.setVisible(true);
        if (singleChoiceDialog.getAnswer()) {
            if (this.client.game.getEntity((int)((Integer)vector.elementAt((int)singleChoiceDialog.getChoice())).intValue()).mpUsed > 0) {
                if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.RecoverSureDialog.title"), Messages.getString("MovementDisplay.RecoverSureDialog.message"))) {
                    return (Integer)vector.elementAt(singleChoiceDialog.getChoice());
                }
            } else {
                return (Integer)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return -1;
    }

    private void checkOOC() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        if (aero.isOutControlTotal()) {
            this.disableButtons();
            this.butDone.setEnabled(true);
            this.butNext.setEnabled(true);
            this.butLaunch.setEnabled(true);
        }
    }

    private void checkFuel() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        if (aero.getFuel() < 1) {
            this.disableButtons();
            this.butDone.setEnabled(true);
            this.butNext.setEnabled(true);
            this.butLaunch.setEnabled(true);
            this.updateRACButton();
            this.updateRecoveryButton();
            this.updateDumpButton();
        }
    }

    private void checkAtmosphere() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        if (!(entity instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)entity;
        if (this.client.game.getBoard().inAtmosphere() && (aero.isSpheroid() || this.client.game.getPlanetaryConditions().isVacuum())) {
            this.butAcc.setEnabled(false);
            this.butDec.setEnabled(false);
            this.butAccN.setEnabled(false);
            this.butDecN.setEnabled(false);
        }
    }

    private Targetable chooseTarget(Coords coords) {
        Entity entity = this.ce();
        Targetable targetable = null;
        Enumeration<Entity> enumeration = this.client.game.getEntities(coords);
        Vector<Targetable> vector = new Vector<Targetable>();
        while (enumeration.hasMoreElements()) {
            targetable = enumeration.nextElement();
            if (entity.equals(targetable)) continue;
            vector.addElement(targetable);
        }
        Building building = this.client.game.getBoard().getBuildingAt(coords);
        if (building != null) {
            vector.addElement(new BuildingTarget(coords, this.client.game.getBoard(), false));
        }
        if (vector.size() == 1) {
            targetable = (Targetable)vector.elementAt(0);
        } else if (vector.size() > 1) {
            String[] stringArray = new String[vector.size()];
            String string = Messages.getString("MovementDisplay.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()});
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Targetable)vector.elementAt(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.ChooseTargetDialog.title"), string.toString(), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                targetable = (Targetable)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return targetable;
    }

    private int chooseMineToLay() {
        MineLayingDialog mineLayingDialog = new MineLayingDialog(this.clientgui.frame, this.ce());
        mineLayingDialog.setVisible(true);
        if (mineLayingDialog.getAnswer()) {
            return mineLayingDialog.getMine();
        }
        return -1;
    }

    private void dumpBombs() {
        if (!(this.ce() instanceof Aero)) {
            return;
        }
        Aero aero = (Aero)this.ce();
        int n = 0;
        if (null != this.cmd) {
            n = this.cmd.getLastStepMovementType();
        }
        BombPayloadDialog bombPayloadDialog = new BombPayloadDialog(this.clientgui.frame, Messages.getString("MovementDisplay.BombDumpDialog.title"), aero.getBombChoices(), false, true);
        bombPayloadDialog.setVisible(true);
        if (bombPayloadDialog.getAnswer()) {
            String string;
            String string2;
            int[] nArray = bombPayloadDialog.getChoices();
            PilotingRollData pilotingRollData = this.ce().getBasePilotingRoll(n);
            int n2 = Compute.d6(2);
            Report report = new Report(9500);
            report.subject = this.ce().getId();
            report.add(this.ce().getDisplayName());
            report.add(pilotingRollData.getValue());
            report.add(n2);
            report.newlines = 0;
            report.indent(1);
            if (n2 < pilotingRollData.getValue()) {
                report.choose(false);
                string2 = Messages.getString("MovementDisplay.DumpingBombs.title");
                string = Messages.getString("MovementDisplay.DumpFailure.message");
                this.clientgui.doAlertDialog(string2, string);
                nArray = aero.getBombChoices();
            } else {
                report.choose(true);
                string2 = Messages.getString("MovementDisplay.DumpingBombs.title");
                string = Messages.getString("MovementDisplay.DumpSuccessful.message");
                this.clientgui.doAlertDialog(string2, string);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                aero.removeBombs(nArray[i], i);
                report.subject = this.ce().getId();
                report.addDesc(this.ce());
                report.add("" + nArray[i] + " " + Aero.bombNames[i] + "(s)");
            }
            aero.updateBombLoad();
            this.client.sendUpdateEntity(this.ce());
        }
    }

    private boolean addManeuver(int n) {
        this.cmd.addManeuver(n);
        switch (n) {
            case 4: {
                this.cmd.addStep(42, true, true);
                return true;
            }
            case 5: {
                this.cmd.addStep(38, true, true);
                return true;
            }
            case 6: {
                this.cmd.addStep(34, true, true);
                return true;
            }
            case 2: {
                this.gear = 8;
                return false;
            }
            case 3: {
                this.gear = 9;
                return false;
            }
            case 9: {
                if (!(this.ce() instanceof Aero)) {
                    return false;
                }
                Aero aero = (Aero)this.ce();
                MoveStep moveStep = this.cmd.getLastStep();
                int n2 = aero.getCurrentVelocity();
                if (null != moveStep) {
                    n2 = moveStep.getVelocityLeft();
                }
                while (n2 > 0) {
                    this.cmd.addStep(34, true, true);
                    --n2;
                }
                this.cmd.addStep(20);
                return true;
            }
            case 7: {
                this.cmd.addStep(11, true, true);
                return true;
            }
            case 8: {
                this.cmd.addStep(12, true, true);
                return true;
            }
            case 1: {
                this.cmd.addStep(49, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            if (this.client.canUnloadStranded()) {
                this.unloadStranded();
            } else {
                this.beginMyTurn();
            }
        } else if (gameTurnChangeEvent.getPlayer() == null && this.client.game.getTurn() instanceof GameTurn.UnloadStrandedTurn) {
            this.setStatusBarText(Messages.getString("MovementDisplay.waitForAnother"));
        } else {
            this.setStatusBarText(Messages.getString("MovementDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    @Override
    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_MOVEMENT) {
            this.setStatusBarText(Messages.getString("MovementDisplay.waitingForMovementPhase"));
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.moveTo(this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(MOVE_CANCEL)) {
            this.clearAllMoves();
        } else if (actionEvent.getSource() == this.butMore) {
            ++this.buttonLayout;
            this.buttonLayout %= 4;
            this.setupButtonPanel();
        } else if (actionEvent.getActionCommand().equals(MOVE_UNJAM)) {
            if (this.gear == 2 || this.gear == 3 || this.gear == 4 || this.cmd.getMpUsed() > entity.getWalkMP() || this.gear == 6 || this.gear == 7) {
                this.setUnjamEnabled(false);
            } else {
                this.cmd.addStep(15);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_SEARCHLIGHT)) {
            this.cmd.addStep(22);
        } else if (actionEvent.getActionCommand().equals(MOVE_WALK)) {
            if (this.gear == 2 || this.gear == 6) {
                this.clearAllMoves();
            }
            this.gear = 0;
        } else if (actionEvent.getActionCommand().equals(MOVE_JUMP)) {
            if (entity instanceof LandAirMech && ((LandAirMech)entity).isInMode(2)) {
                if (this.cmd.isFlying()) {
                    this.cmd.addStep(32);
                    this.gear = 2;
                } else {
                    this.cmd.addStep(31);
                    this.gear = 2;
                }
            } else {
                if (this.gear != 2) {
                    this.clearAllMoves();
                }
                if (!this.cmd.isJumping()) {
                    this.cmd.addStep(7);
                }
                this.gear = 2;
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_SWIM)) {
            if (this.gear != 6) {
                this.clearAllMoves();
            }
            this.gear = 6;
            entity.setMovementMode(entity instanceof BipedMech ? 13 : 14);
        } else if (actionEvent.getActionCommand().equals(MOVE_TURN)) {
            this.gear = 5;
        } else if (actionEvent.getActionCommand().equals(MOVE_BACK_UP)) {
            if (this.gear == 2) {
                this.clearAllMoves();
            }
            this.gear = 1;
        } else if (actionEvent.getActionCommand().equals(MOVE_CLEAR)) {
            this.clearAllMoves();
            if (!this.client.game.containsMinefield(entity.getPosition())) {
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantClearMinefield"), Messages.getString("MovementDisplay.NoMinefield"));
                return;
            }
            int n = 10;
            int n2 = 5;
            Vector<Minefield> vector = this.client.game.getMinefields(entity.getPosition());
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Minefield.getDisplayableName(vector.elementAt(i).getType());
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.ChooseMinefieldDialog.title"), Messages.getString("MovementDisplay.ChooseMinefieldDialog.message"), stringArray);
            singleChoiceDialog.setVisible(true);
            Minefield minefield = null;
            if (singleChoiceDialog.getAnswer()) {
                minefield = vector.elementAt(singleChoiceDialog.getChoice());
            }
            if (null != minefield && this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.ClearMinefieldDialog.title"), Messages.getString("MovementDisplay.ClearMinefieldDialog.message", new Object[]{new Integer(n), new Integer(n2)}))) {
                this.cmd.addStep(19, minefield);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_CHARGE)) {
            if (this.gear != 0) {
                this.clearAllMoves();
            }
            this.gear = 3;
        } else if (actionEvent.getActionCommand().equals(MOVE_DFA)) {
            if (this.gear != 2) {
                this.clearAllMoves();
            }
            this.gear = 4;
            if (!this.cmd.isJumping()) {
                this.cmd.addStep(7);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_RAM)) {
            if (this.gear != 0) {
                this.clearAllMoves();
            }
            this.gear = 7;
        } else if (actionEvent.getActionCommand().equals(MOVE_GET_UP)) {
            if (!this.cmd.contains(24)) {
                this.clearAllMoves();
            }
            if (this.cmd.getFinalProne() || this.cmd.getFinalHullDown()) {
                this.cmd.addStep(5);
            }
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_CAREFUL_STAND)) {
            this.clearAllMoves();
            entity.setCarefulStand(true);
            if (this.cmd.getFinalProne() || this.cmd.getFinalHullDown()) {
                this.cmd.addStep(50);
            }
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_GO_PRONE)) {
            this.gear = 0;
            if (!this.cmd.getFinalProne()) {
                this.cmd.addStep(6);
            }
            this.clientgui.bv.drawMovementData(entity, this.cmd);
            this.butDone.setLabel(Messages.getString("MovementDisplay.Move"));
        } else if (actionEvent.getActionCommand().equals(MOVE_HULL_DOWN)) {
            this.gear = 0;
            if (!this.cmd.getFinalHullDown()) {
                this.cmd.addStep(24);
            }
            this.clientgui.bv.drawMovementData(entity, this.cmd);
            this.butDone.setLabel(Messages.getString("MovementDisplay.Move"));
        } else if (actionEvent.getActionCommand().equals(MOVE_FLEE) && this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.EscapeDialog.title"), Messages.getString("MovementDisplay.EscapeDialog.message"))) {
            this.clearAllMoves();
            this.cmd.addStep(10);
            this.moveTo(this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_EJECT)) {
            if (entity instanceof Tank) {
                if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.AbandonDialog.title"), Messages.getString("MovementDisplay.AbandonDialog.message"))) {
                    this.clearAllMoves();
                    this.cmd.addStep(18);
                    this.moveTo(this.cmd);
                }
            } else if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.AbandonDialog1.title"), Messages.getString("MovementDisplay.AbandonDialog1.message"))) {
                this.clearAllMoves();
                this.cmd.addStep(18);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_LOAD)) {
            Entity entity2 = null;
            Enumeration<Entity> enumeration = this.client.game.getEntities(entity.getPosition());
            while (enumeration.hasMoreElements()) {
                entity2 = enumeration.nextElement();
                if (!entity.getOwner().isEnemyOf(entity2.getOwner()) && !entity.equals(entity2)) {
                    this.loadedUnits.addElement(entity2);
                    break;
                }
                entity2 = null;
            }
            if (entity2 != null) {
                this.cmd.addStep(16);
                this.clientgui.bv.drawMovementData(entity, this.cmd);
                this.gear = 0;
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_UNLOAD)) {
            Entity entity3 = this.getUnloadedUnit();
            if (entity3 != null) {
                this.cmd.addStep(17, entity3);
                this.clientgui.bv.drawMovementData(entity, this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_RAISE_ELEVATION)) {
            this.cmd.addStep(20);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_LOWER_ELEVATION)) {
            if (entity instanceof Aero && null != this.cmd.getLastStep() && this.cmd.getLastStep().getNDown() == 1 && this.cmd.getLastStep().getVelocity() < 12 && !((Aero)entity).isSpheroid() && !this.client.game.getPlanetaryConditions().isVacuum()) {
                this.cmd.addStep(33, true);
            }
            this.cmd.addStep(21);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_CLIMB_MODE)) {
            MoveStep moveStep = this.cmd.getLastStep();
            if (moveStep != null && (moveStep.getType() == 25 || moveStep.getType() == 26)) {
                this.cmd.removeLastStep();
            } else if (this.cmd.getFinalClimbMode()) {
                this.cmd.addStep(26);
            } else {
                this.cmd.addStep(25);
            }
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_LAY_MINE)) {
            this.clearAllMoves();
            int n = this.chooseMineToLay();
            if (n != -1) {
                Mounted mounted = this.ce().getEquipment(n);
                if (mounted.getMineType() == 1) {
                    VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                    vibrabombSettingDialog.setVisible(true);
                    mounted.setVibraSetting(vibrabombSettingDialog.getSetting());
                }
                this.cmd.addStep(23, n);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_DIG_IN)) {
            this.cmd.addStep(28);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_FORTIFY)) {
            this.cmd.addStep(29);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_SHAKE_OFF)) {
            this.cmd.addStep(30);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_MODE_MECH)) {
            this.clearAllMoves();
            if (entity instanceof LandAirMech) {
                LandAirMech landAirMech = (LandAirMech)this.client.getEntity(entity.getId());
                landAirMech.convertToMode(1);
                this.updateTransformationButtons(landAirMech);
                this.clientgui.mechD.displayEntity(landAirMech);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_MODE_AIRMECH)) {
            this.clearAllMoves();
            if (entity instanceof LandAirMech) {
                LandAirMech landAirMech = (LandAirMech)this.client.getEntity(entity.getId());
                landAirMech.convertToMode(2);
                this.updateTransformationButtons(landAirMech);
                this.clientgui.mechD.displayEntity(landAirMech);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_MODE_AIRCRAFT)) {
            this.clearAllMoves();
            if (entity instanceof LandAirMech) {
                LandAirMech landAirMech = (LandAirMech)this.client.getEntity(entity.getId());
                landAirMech.convertToMode(4);
                this.updateTransformationButtons(landAirMech);
                this.clientgui.mechD.displayEntity(landAirMech);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_RECKLESS)) {
            this.cmd.setCareful(false);
        } else if (actionEvent.getActionCommand().equals(MOVE_ACCN)) {
            this.cmd.addStep(36);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_DECN)) {
            this.cmd.addStep(37);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_ACC)) {
            this.cmd.addStep(33);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_DEC)) {
            this.cmd.addStep(34);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_EVADE)) {
            this.cmd.addStep(35);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_EVADE_AERO)) {
            this.cmd.addStep(35);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_ROLL)) {
            this.cmd.addStep(38);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_HOVER)) {
            this.cmd.addStep(47);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_MANEUVER)) {
            ManeuverChoiceDialog maneuverChoiceDialog = new ManeuverChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.ManeuverDialog.title"), "huh?");
            Aero aero = (Aero)entity;
            MoveStep moveStep = this.cmd.getLastStep();
            int n = aero.getCurrentVelocity();
            int n3 = aero.getElevation();
            Coords coords = aero.getPosition();
            int n4 = 0;
            if (null != moveStep) {
                n = moveStep.getVelocityLeft();
                n3 = moveStep.getElevation();
                coords = moveStep.getPosition();
                n4 = moveStep.getDistance();
            }
            int n5 = this.client.game.getBoard().getHex(coords).ceiling();
            maneuverChoiceDialog.checkPerformability(n, n3, n5, aero.isVSTOL(), n4);
            maneuverChoiceDialog.setVisible(true);
            int n6 = maneuverChoiceDialog.getChoice();
            if (n6 > 0 && this.addManeuver(n6)) {
                this.clientgui.bv.drawMovementData(entity, this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_LAUNCH)) {
            Vector<Integer[]> vector = this.getLaunchedUnits();
            this.cmd.addStep(40, vector);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_RECOVER)) {
            int n = this.getRecoveryUnit();
            if (n != -1) {
                this.cmd.addStep(45, n, -1);
                this.clientgui.bv.drawMovementData(entity, this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_TURN_LEFT)) {
            this.cmd.addStep(3);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_TURN_RIGHT)) {
            this.cmd.addStep(4);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_THRUST)) {
            this.cmd.addStep(41);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_YAW)) {
            this.cmd.addStep(42);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_END_OVER)) {
            this.cmd.addStep(42);
            this.cmd.addStep(38);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_DUMP)) {
            this.dumpBombs();
        }
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateLoadButtons();
        this.updateElevationButtons();
        this.updateFleeButton();
        this.updateLaunchButton();
        this.updateRecklessButton();
        this.updateHoverButton();
        this.updateManeuverButton();
        this.updateDumpButton();
        this.updateSpeedButtons();
        this.updateThrustButton();
        this.updateRollButton();
        this.checkFuel();
        this.checkOOC();
        this.checkAtmosphere();
    }

    private void unloadStranded() {
        Object object;
        Vector<Entity> vector = new Vector<Entity>();
        String[] stringArray = null;
        Entity entity = null;
        Entity entity2 = null;
        this.setStatusBarText(Messages.getString("MovementDisplay.AllPlayersUnload"));
        Enumeration<Entity> enumeration = this.client.getSelectedEntities(new EntitySelector(){
            private final IGame game;
            private final GameTurn turn;
            private final int ownerId;
            {
                this.game = MovementDisplay.this.client.game;
                this.turn = MovementDisplay.this.client.game.getTurn();
                this.ownerId = MovementDisplay.this.client.getLocalPlayer().getId();
            }

            public boolean accept(Entity entity) {
                return this.turn.isValid(this.ownerId, entity, this.game);
            }
        });
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            entity = (Entity)vector.elementAt(i);
            entity2 = this.client.getEntity(entity.getTransportId());
            object = null == entity2 ? entity.getDisplayName() : Messages.getString("MovementDisplay.EntityAt", new Object[]{entity.getDisplayName(), entity2.getPosition().getBoardNum()});
            stringArray[i] = ((String)object).toString();
        }
        int[] nArray = this.clientgui.doChoiceDialog(Messages.getString("MovementDisplay.UnloadStrandedUnitsDialog.title"), Messages.getString("MovementDisplay.UnloadStrandedUnitsDialog.message"), stringArray);
        object = null;
        if (null != nArray) {
            object = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                entity = (Entity)vector.elementAt(i);
                object[i] = entity.getId();
            }
        }
        this.client.sendUnloadStranded((int[])object);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearAllMoves();
        }
        if (keyEvent.getKeyCode() == 8 && this.client.isMyTurn()) {
            this.removeLastStep();
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && this.client.isMyTurn()) {
            this.moveTo(this.cmd);
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null && !this.clientgui.getBoardView().getLastCursor().equals(this.clientgui.getBoardView().getSelected())) {
                this.currentMove(this.clientgui.getBoardView().getLastCursor());
                this.clientgui.bv.drawMovementData(entity, this.cmd);
            }
        }
        if (this.shiftheld && this.client.isMyTurn() && (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39)) {
            int n;
            int n2 = n = this.cmd.getFinalFacing();
            n2 = keyEvent.getKeyCode() == 37 ? (n2 + 5) % 6 : (n2 + 7) % 6;
            Coords coords = this.cmd.getFinalCoords();
            Coords coords2 = coords.translated(n2);
            this.currentMove(coords2);
            this.clientgui.bv.drawMovementData(entity, this.cmd);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null && !this.clientgui.getBoardView().getLastCursor().equals(this.clientgui.getBoardView().getSelected())) {
                this.clientgui.bv.clearMovementData();
                this.currentMove(this.clientgui.getBoardView().getLastCursor());
                this.clientgui.bv.drawMovementData(this.ce(), this.cmd);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && entity != null) {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.bv.centerOnHex(entity.getPosition());
        }
    }

    @Override
    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (null == entity) {
            return;
        }
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    private void setWalkEnabled(boolean bl) {
        this.butWalk.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveWalkEnabled(bl);
    }

    private void setTurnEnabled(boolean bl) {
        this.butTurn.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveTurnEnabled(bl);
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveNextEnabled(bl);
    }

    private void setLayMineEnabled(boolean bl) {
        this.butLayMine.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLayMineEnabled(bl);
    }

    private void setLoadEnabled(boolean bl) {
        this.butLoad.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLoadEnabled(bl);
    }

    private void setUnloadEnabled(boolean bl) {
        this.butUnload.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveUnloadEnabled(bl);
    }

    private void setJumpEnabled(boolean bl) {
        this.butJump.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveJumpEnabled(bl);
    }

    private void setSwimEnabled(boolean bl) {
        this.butSwim.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveSwimEnabled(bl);
    }

    private void setBackUpEnabled(boolean bl) {
        this.butBackup.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveBackUpEnabled(bl);
    }

    private void setChargeEnabled(boolean bl) {
        this.butCharge.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveChargeEnabled(bl);
    }

    private void setDFAEnabled(boolean bl) {
        this.butDfa.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveDFAEnabled(bl);
    }

    private void setGoProneEnabled(boolean bl) {
        this.butDown.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveGoProneEnabled(bl);
    }

    private void setFleeEnabled(boolean bl) {
        this.butFlee.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveFleeEnabled(bl);
    }

    private void setEjectEnabled(boolean bl) {
        this.butEject.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveEjectEnabled(bl);
    }

    private void setUnjamEnabled(boolean bl) {
        this.butRAC.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveUnjamEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl, boolean bl2) {
        if (bl2) {
            this.butSearchlight.setLabel(Messages.getString("MovementDisplay.butSearchlightOff"));
        } else {
            this.butSearchlight.setLabel(Messages.getString("MovementDisplay.butSearchlightOn"));
        }
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveSearchlightEnabled(bl);
    }

    private void setHullDownEnabled(boolean bl) {
        this.butHullDown.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveHullDownEnabled(bl);
    }

    private void setClearEnabled(boolean bl) {
        this.butClear.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveClearEnabled(bl);
    }

    private void setGetUpEnabled(boolean bl) {
        this.butUp.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveGetUpEnabled(bl);
    }

    private void setRaiseEnabled(boolean bl) {
        this.butRaise.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRaiseEnabled(bl);
    }

    private void setLowerEnabled(boolean bl) {
        this.butLower.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLowerEnabled(bl);
    }

    private void setRecklessEnabled(boolean bl) {
        this.butReckless.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRecklessEnabled(bl);
    }

    private void setLAMmechModeEnabled(boolean bl) {
        this.clientgui.getMenuBar().setMoveLAMmechModeEnabled(bl);
    }

    private void setLAMairmechModeEnabled(boolean bl) {
        this.clientgui.getMenuBar().setMoveLAMairmechModeEnabled(bl);
    }

    private void setLAMaircraftModeEnabled(boolean bl) {
        this.clientgui.getMenuBar().setMoveLAMaircraftModeEnabled(bl);
    }

    private void setAccEnabled(boolean bl) {
        this.butAcc.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveAccEnabled(bl);
    }

    private void setDecEnabled(boolean bl) {
        this.butDec.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveDecEnabled(bl);
    }

    private void setAccNEnabled(boolean bl) {
        this.butAccN.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveAccNEnabled(bl);
    }

    private void setDecNEnabled(boolean bl) {
        this.butDecN.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveDecNEnabled(bl);
    }

    private void setEvadeEnabled(boolean bl) {
        this.butEvade.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveEvadeEnabled(bl);
    }

    private void setEvadeAeroEnabled(boolean bl) {
        this.butEvadeAero.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveEvadeAeroEnabled(bl);
    }

    private void setRollEnabled(boolean bl) {
        this.butRoll.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRollEnabled(bl);
    }

    private void setLaunchEnabled(boolean bl) {
        this.butLaunch.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLaunchEnabled(bl);
    }

    private void setRecoverEnabled(boolean bl) {
        this.butRecover.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRecoverEnabled(bl);
    }

    private void setDumpEnabled(boolean bl) {
        this.butDump.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveDumpEnabled(bl);
    }

    private void setRamEnabled(boolean bl) {
        this.butRam.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRamEnabled(bl);
    }

    private void setHoverEnabled(boolean bl) {
        this.butHover.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveHoverEnabled(bl);
    }

    private void setManeuverEnabled(boolean bl) {
        this.butManeuver.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveManeuverEnabled(bl);
    }

    private void setTurnLeftEnabled(boolean bl) {
        this.butTurnLeft.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveTurnLeftEnabled(bl);
    }

    private void setTurnRightEnabled(boolean bl) {
        this.butTurnRight.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveTurnRightEnabled(bl);
    }

    private void setThrustEnabled(boolean bl) {
        this.butThrust.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveThrustEnabled(bl);
    }

    private void setYawEnabled(boolean bl) {
        this.butYaw.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveYawEnabled(bl);
    }

    private void setEndOverEnabled(boolean bl) {
        this.butEndOver.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveEndOverEnabled(bl);
    }

    @Override
    public Button getDoneButton() {
        return this.butDone;
    }

    @Override
    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }

    private MovePath addSteps(MovePath movePath, Entity entity) {
        MoveStep moveStep = movePath.getLastStep();
        if (moveStep != null && (moveStep.getType() == 40 || moveStep.getType() == 45)) {
            movePath.removeLastStep();
        }
        Coords coords = entity.getPosition();
        Coords coords2 = Compute.getFinalPosition(coords, movePath.getFinalVectors());
        ArrayList<Coords> arrayList = Coords.intervening(coords, coords2);
        boolean bl = false;
        double d = coords.degree(coords2);
        if (d % 60.0 == 30.0) {
            bl = true;
            arrayList = Coords.intervening(coords, coords2, true);
        }
        Coords coords3 = coords;
        int n = movePath.getFinalFacing();
        for (int i = 1; i < arrayList.size(); ++i) {
            Coords coords4;
            if (i % 3 == 1 && bl) {
                coords4 = arrayList.get(i);
                Coords coords5 = arrayList.get(i + 1);
                Enumeration<Entity> enumeration = this.client.game.getEntities(coords4);
                double d2 = 0.0;
                while (enumeration.hasMoreElements()) {
                    d2 += (double)enumeration.nextElement().getWeight();
                }
                Enumeration<Entity> enumeration2 = this.client.game.getEntities(coords5);
                double d3 = 0.0;
                while (enumeration2.hasMoreElements()) {
                    d3 += (double)enumeration2.nextElement().getWeight();
                }
                entity.addPassedThrough(coords5);
                entity.addPassedThrough(coords4);
                this.client.sendUpdateEntity(entity);
                if (!(d2 < d3)) continue;
                ++i;
            }
            coords4 = arrayList.get(i);
            if (!this.client.game.getBoard().contains(coords4)) {
                movePath.addStep(39);
                break;
            }
            int n2 = coords3.direction(coords4);
            int n3 = n2 - n;
            if (n3 == 0) {
                movePath.addStep(1);
            } else if (n3 == 1 || n3 == -5) {
                movePath.addStep(12);
            } else if (n3 == -2 || n3 == 4) {
                movePath.addStep(14);
            } else if (n3 == -1 || n3 == 5) {
                movePath.addStep(11);
            } else if (n3 == 2 || n3 == -4) {
                movePath.addStep(13);
            } else if (n3 == 3 || n3 == -3) {
                movePath.addStep(2);
            }
            coords3 = coords4;
        }
        if (moveStep != null && moveStep.getType() == 40) {
            movePath.addStep(40, moveStep.getLaunched());
        }
        if (moveStep != null && moveStep.getType() == 45) {
            movePath.addStep(45, moveStep.getRecoveryUnit());
        }
        return movePath;
    }
}

