/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import megamek.client.Client;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.Messages;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.Tank;
import megamek.common.VTOL;

public class RandomSkillDialog
extends Dialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -2459992981678758743L;
    private Client client;
    private ClientGUI clientgui;
    private Panel panButtons = new Panel();
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Label labelMethod = new Label(Messages.getString("RandomSkillDialog.labelMethod"), 2);
    private Choice chMethod = new Choice();
    private Label labelType = new Label(Messages.getString("RandomSkillDialog.labelType"), 2);
    private Choice chType = new Choice();
    private Label labelLevel = new Label(Messages.getString("RandomSkillDialog.labelLevel"), 2);
    private Choice chLevel = new Choice();
    private Label labelPlayer = new Label(Messages.getString("MechSelectorDialog.m_labelPlayer"), 2);
    private Choice chPlayer = new Choice();
    private TextArea texDesc = new TextArea(Messages.getString("CustomMechDialog.texDesc"), 3, 35, 1);
    private Checkbox cForceClose = new Checkbox(Messages.getString("RandomSkillDialog.cForceClose"));

    public RandomSkillDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("RandomSkillDialog.title"), true);
        this.client = clientGUI.getClient();
        this.clientgui = clientGUI;
        this.updatePlayerChoice();
        this.cForceClose.setState(false);
        this.texDesc.setEnabled(true);
        this.chMethod.add(Messages.getString("RandomSkillDialog.MethodTW"));
        this.chMethod.add(Messages.getString("RandomSkillDialog.MethodTaharqa"));
        this.chMethod.add(Messages.getString("RandomSkillDialog.MethodConstant"));
        this.chMethod.select(0);
        this.chMethod.addItemListener(this);
        this.texDesc.setText(Messages.getString("RandomSkillDialog.descTW"));
        this.chType.add(Messages.getString("RandomSkillDialog.InnerSphere"));
        this.chType.add(Messages.getString("RandomSkillDialog.Clan"));
        this.chType.add(Messages.getString("RandomSkillDialog.ManeiDomini"));
        this.chType.select(0);
        this.chLevel.add(Messages.getString("RandomSkillDialog.Green"));
        this.chLevel.add(Messages.getString("RandomSkillDialog.Regular"));
        this.chLevel.add(Messages.getString("RandomSkillDialog.Veteran"));
        this.chLevel.add(Messages.getString("RandomSkillDialog.Elite"));
        this.chLevel.select(1);
        this.setupButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelMethod, gridBagConstraints);
        this.add(this.labelMethod);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.chMethod, gridBagConstraints);
        this.add(this.chMethod);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelType, gridBagConstraints);
        this.add(this.labelType);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.chType, gridBagConstraints);
        this.add(this.chType);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelLevel, gridBagConstraints);
        this.add(this.labelLevel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.chLevel, gridBagConstraints);
        this.add(this.chLevel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.cForceClose, gridBagConstraints);
        this.add(this.cForceClose);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
        this.add(this.texDesc);
        gridBagConstraints.fill = 3;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RandomSkillDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(clientGUI.frame.getLocation().x + clientGUI.frame.getSize().width / 2 - this.getSize().width / 2, clientGUI.frame.getLocation().y + clientGUI.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labelPlayer, gridBagConstraints);
        this.panButtons.add(this.labelPlayer);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.chPlayer, gridBagConstraints);
        this.panButtons.add(this.chPlayer);
    }

    public void update() {
    }

    private void updatePlayerChoice() {
        String string = this.chPlayer.getSelectedItem();
        this.chPlayer.removeAll();
        this.chPlayer.setEnabled(true);
        this.chPlayer.addItem(this.clientgui.getClient().getName());
        Iterator<Client> iterator = this.clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.chPlayer.addItem(iterator.next().getName());
        }
        if (this.chPlayer.getItemCount() == 1) {
            this.chPlayer.setEnabled(false);
        } else {
            this.chPlayer.select(string);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updatePlayerChoice();
        }
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            Object object;
            Client client = null;
            if (this.chPlayer.getSelectedIndex() > 0) {
                object = this.chPlayer.getSelectedItem();
                client = this.clientgui.getBots().get(object);
            }
            if (client == null) {
                client = this.client;
            }
            object = client.game.getEntities();
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                if (entity.getOwnerId() != client.getLocalPlayer().getId()) continue;
                int[] nArray = Compute.getRandomSkills(this.chMethod.getSelectedIndex(), this.chType.getSelectedIndex(), this.chLevel.getSelectedIndex(), entity instanceof Tank || entity instanceof VTOL);
                if (this.cForceClose.getState()) {
                    nArray[1] = nArray[0] + 1;
                }
                entity.getCrew().setGunnery(nArray[0]);
                entity.getCrew().setGunneryL(nArray[0]);
                entity.getCrew().setGunneryM(nArray[0]);
                entity.getCrew().setGunneryB(nArray[0]);
                entity.getCrew().setPiloting(nArray[1]);
                client.sendUpdateEntity(entity);
            }
            this.clientgui.chatlounge.refreshEntities();
            this.setVisible(false);
        }
        if (actionEvent.getSource() == this.butCancel) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chMethod) {
            if (this.chMethod.getSelectedIndex() == 0) {
                this.texDesc.setText(Messages.getString("RandomSkillDialog.descTW"));
            }
            if (this.chMethod.getSelectedIndex() == 1) {
                this.texDesc.setText(Messages.getString("RandomSkillDialog.descTaharqa"));
            }
            if (this.chMethod.getSelectedIndex() == 2) {
                this.texDesc.setText(Messages.getString("RandomSkillDialog.descConstant"));
            }
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

