/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.AimedShotDialog;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.ConfirmDialog;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.SingleChoiceDialog;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.client.ui.swing.TriggerAPPodDialog;
import megamek.client.ui.swing.TriggerBPodDialog;
import megamek.client.ui.swing.VibrabombSettingDialog;
import megamek.client.ui.swing.widget.IndexedCheckbox;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameTurn;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.LargeSupportTank;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.RepairWeaponMalfunctionAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.SpotAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.TriggerAPPodAction;
import megamek.common.actions.TriggerBPodAction;
import megamek.common.actions.UnjamTurretAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

public class FiringDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
GameListener,
ActionListener,
DoneButtoned,
KeyListener,
ItemListener,
ListSelectionListener {
    private static final long serialVersionUID = -5586388490027013723L;
    private static final int NUM_BUTTON_LAYOUTS = 2;
    public static final String FIRE_FIND_CLUB = "fireFindClub";
    public static final String FIRE_FIRE = "fireFire";
    public static final String FIRE_MODE = "fireMode";
    public static final String FIRE_FLIP_ARMS = "fireFlipArms";
    private static final String FIRE_MORE = "fireMore";
    public static final String FIRE_NEXT = "fireNext";
    public static final String FIRE_NEXT_TARG = "fireNextTarg";
    public static final String FIRE_SKIP = "fireSkip";
    public static final String FIRE_SPOT = "fireSpot";
    public static final String FIRE_TWIST = "fireTwist";
    public static final String FIRE_CANCEL = "fireCancel";
    public static final String FIRE_SEARCHLIGHT = "fireSearchlight";
    public static final String FIRE_CLEAR_TURRET = "fireClearTurret";
    public static final String FIRE_CLEAR_WEAPON = "fireClearWeaponJam";
    private Client client;
    ClientGUI clientgui;
    private JComponent panButtons;
    private JButton butFire;
    private JButton butTwist;
    private JButton butSkip;
    private JButton butFindClub;
    private JButton butNextTarg;
    private JButton butFlipArms;
    private JButton butSpot;
    private JButton butSearchlight;
    private JButton butSpace;
    private JButton butFireMode;
    private JButton butFireClearTurret;
    private JButton butFireClearWeaponJam;
    private JButton butNext;
    private JButton butDone;
    private JButton butMore;
    private int buttonLayout;
    private int cen = -1;
    Targetable target;
    private boolean showTargetChoice = true;
    private Vector<AbstractEntityAction> attacks;
    private boolean shiftheld;
    private boolean twisting;
    private Entity[] visibleTargets = null;
    private int lastTargetID = -1;
    private AimedShotHandler ash;

    public FiringDisplay(ClientGUI clientGUI) {
        this.client = clientGUI.getClient();
        this.clientgui = clientGUI;
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.shiftheld = false;
        this.attacks = new Vector();
        this.setupStatusBar(Messages.getString("FiringDisplay.waitingForFiringPhase"));
        this.butFire = new JButton(Messages.getString("FiringDisplay.Fire"));
        this.butFire.addActionListener(this);
        this.butFire.addKeyListener(this);
        this.butFire.setActionCommand(FIRE_FIRE);
        this.butFire.setEnabled(false);
        this.butSkip = new JButton(Messages.getString("FiringDisplay.Skip"));
        this.butSkip.addActionListener(this);
        this.butSkip.addKeyListener(this);
        this.butSkip.setActionCommand(FIRE_SKIP);
        this.butSkip.setEnabled(false);
        this.butTwist = new JButton(Messages.getString("FiringDisplay.Twist"));
        this.butTwist.addActionListener(this);
        this.butTwist.addKeyListener(this);
        this.butTwist.setActionCommand(FIRE_TWIST);
        this.butTwist.setEnabled(false);
        this.butFindClub = new JButton(Messages.getString("FiringDisplay.FindClub"));
        this.butFindClub.addActionListener(this);
        this.butFindClub.addKeyListener(this);
        this.butFindClub.setActionCommand(FIRE_FIND_CLUB);
        this.butFindClub.setEnabled(false);
        this.butNextTarg = new JButton(Messages.getString("FiringDisplay.NextTarget"));
        this.butNextTarg.addActionListener(this);
        this.butNextTarg.addKeyListener(this);
        this.butNextTarg.setActionCommand(FIRE_NEXT_TARG);
        this.butNextTarg.setEnabled(false);
        this.butFlipArms = new JButton(Messages.getString("FiringDisplay.FlipArms"));
        this.butFlipArms.addActionListener(this);
        this.butFlipArms.addKeyListener(this);
        this.butFlipArms.setActionCommand(FIRE_FLIP_ARMS);
        this.butFlipArms.setEnabled(false);
        this.butSpot = new JButton(Messages.getString("FiringDisplay.Spot"));
        this.butSpot.addActionListener(this);
        this.butSpot.addKeyListener(this);
        this.butSpot.setActionCommand(FIRE_SPOT);
        this.butSpot.setEnabled(false);
        this.butSearchlight = new JButton(Messages.getString("FiringDisplay.Searchlight"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.addKeyListener(this);
        this.butSearchlight.setActionCommand(FIRE_SEARCHLIGHT);
        this.butSearchlight.setEnabled(false);
        this.butSpace = new JButton(".");
        this.butSpace.setEnabled(false);
        this.butFireMode = new JButton(Messages.getString("FiringDisplay.Mode"));
        this.butFireMode.addActionListener(this);
        this.butFireMode.addKeyListener(this);
        this.butFireMode.setActionCommand(FIRE_MODE);
        this.butFireMode.setEnabled(false);
        this.butFireClearTurret = new JButton(Messages.getString("FiringDisplay.ClearTurret"));
        this.butFireClearTurret.addActionListener(this);
        this.butFireClearTurret.addKeyListener(this);
        this.butFireClearTurret.setActionCommand(FIRE_CLEAR_TURRET);
        this.butFireClearTurret.setEnabled(false);
        this.butFireClearWeaponJam = new JButton(Messages.getString("FiringDisplay.ClearWeaponJam"));
        this.butFireClearWeaponJam.addActionListener(this);
        this.butFireClearWeaponJam.addKeyListener(this);
        this.butFireClearWeaponJam.setActionCommand(FIRE_CLEAR_WEAPON);
        this.butFireClearWeaponJam.setEnabled(false);
        this.butDone = new JButton(Messages.getString("FiringDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.addKeyListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new JButton(Messages.getString("FiringDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.addKeyListener(this);
        this.butNext.setActionCommand(FIRE_NEXT);
        this.butNext.setEnabled(false);
        this.butMore = new JButton(Messages.getString("FiringDisplay.More"));
        this.butMore.addActionListener(this);
        this.butMore.addKeyListener(this);
        this.butMore.setActionCommand(FIRE_MORE);
        this.butMore.setEnabled(false);
        this.panButtons = new JPanel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
        clientGUI.mechD.wPan.weaponList.addListSelectionListener(this);
        clientGUI.mechD.wPan.weaponList.addKeyListener(this);
        this.ash = new AimedShotHandler();
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 8));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butFire);
                this.panButtons.add(this.butSkip);
                this.panButtons.add(this.butNextTarg);
                this.panButtons.add(this.butTwist);
                this.panButtons.add(this.butFireMode);
                this.panButtons.add(this.butFireClearWeaponJam);
                this.panButtons.add(this.butMore);
                break;
            }
            case 1: {
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butFire);
                this.panButtons.add(this.butFlipArms);
                this.panButtons.add(this.butFindClub);
                this.panButtons.add(this.butSpot);
                this.panButtons.add(this.butSearchlight);
                this.panButtons.add(this.butFireClearTurret);
                this.panButtons.add(this.butMore);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        if (n != this.cen) {
            this.clearAttacks();
            this.refreshAll();
        }
        if (this.client.game.getEntity(n) != null) {
            int n2;
            int n3;
            this.cen = n;
            this.clientgui.setSelectedEntityNum(n);
            if (this.ce().getPosition() == null) {
                n3 = this.client.getNextEntityNum(n);
                while (n3 != n) {
                    if (this.client.game.getEntity(n3).getPosition() != null) {
                        this.cen = n3;
                        break;
                    }
                    n3 = this.client.getNextEntityNum(n3);
                }
                if (this.ce().getPosition() == null) {
                    System.err.println("FiringDisplay: could not find an on-board entity: " + n);
                    return;
                }
            }
            n3 = this.ce().getLastTarget();
            if (this.ce() instanceof Mech && (n2 = ((Mech)this.ce()).getGrappled()) != -1) {
                n3 = n2;
            }
            Entity entity = this.client.game.getEntity(n3);
            this.target(entity);
            if (!this.ce().isOffBoard()) {
                this.clientgui.getBoardView().highlight(this.ce().getPosition());
            }
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
            this.cacheVisibleTargets();
            if (!this.clientgui.bv.isMovingUnits() && !this.ce().isOffBoard()) {
                this.clientgui.bv.centerOnHex(this.ce().getPosition());
            }
            this.clientgui.getMenuBar().setEntity(this.ce());
            this.setTwistEnabled(this.ce().canChangeSecondaryFacing() && this.ce().getCrew().isActive());
            this.setFindClubEnabled(FindClubAction.canMechFindClub(this.client.game, n));
            this.setFlipArmsEnabled(this.ce().canFlipArms());
            this.updateSearchlight();
            this.updateClearTurret();
            this.updateClearWeaponJam();
        } else {
            System.err.println("FiringDisplay: tried to select non-existant entity: " + n);
        }
    }

    private void beginMyTurn() {
        GameTurn gameTurn;
        this.target = null;
        this.selectEntity(this.client.getFirstEntityNum());
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.setDisplayVisible(true);
        }
        if ((gameTurn = this.client.getMyTurn()) instanceof GameTurn.TriggerAPPodTurn && this.ce() != null) {
            this.disableButtons();
            TriggerAPPodDialog triggerAPPodDialog = new TriggerAPPodDialog(this.clientgui.getFrame(), this.ce());
            triggerAPPodDialog.setVisible(true);
            this.attacks.removeAllElements();
            Enumeration<TriggerAPPodAction> enumeration = triggerAPPodDialog.getActions();
            while (enumeration.hasMoreElements()) {
                this.attacks.addElement(enumeration.nextElement());
            }
            this.ready();
        } else if (gameTurn instanceof GameTurn.TriggerBPodTurn && null != this.ce()) {
            this.disableButtons();
            TriggerBPodDialog triggerBPodDialog = new TriggerBPodDialog(this.clientgui, this.ce(), ((GameTurn.TriggerBPodTurn)gameTurn).getAttackType());
            triggerBPodDialog.setVisible(true);
            this.attacks.removeAllElements();
            Enumeration<TriggerBPodAction> enumeration = triggerBPodDialog.getActions();
            while (enumeration.hasMoreElements()) {
                this.attacks.addElement(enumeration.nextElement());
            }
            this.ready();
        } else {
            this.setNextEnabled(true);
            this.butDone.setEnabled(true);
            this.butMore.setEnabled(true);
            this.setFireModeEnabled(true);
            this.clientgui.getBoardView().select(null);
        }
    }

    private void endMyTurn() {
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (this.client.game.getPhase() == IGame.Phase.PHASE_FIRING && entity != null && this.ce() != null && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.target(null);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
        this.disableButtons();
        this.clearVisibleTargets();
    }

    private void disableButtons() {
        this.setFireEnabled(false);
        this.setSkipEnabled(false);
        this.setTwistEnabled(false);
        this.setSpotEnabled(false);
        this.setFindClubEnabled(false);
        this.butMore.setEnabled(false);
        this.setNextEnabled(false);
        this.butDone.setEnabled(false);
        this.setNextTargetEnabled(false);
        this.setFlipArmsEnabled(false);
        this.setFireModeEnabled(false);
        this.setFireClearTurretEnabled(false);
        this.setFireClearWeaponJamEnabled(false);
    }

    private void changeMode() {
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        if (this.ce() == null) {
            return;
        }
        Mounted mounted = this.ce().getEquipment(n);
        if (mounted == null || !mounted.getType().hasModes()) {
            return;
        }
        if (this.ce() instanceof Aero) {
            return;
        }
        int n2 = mounted.switchMode();
        this.client.sendModeChange(this.cen, n, n2);
        if (mounted.getType().hasInstantModeSwitch()) {
            this.clientgui.systemMessage(Messages.getString("FiringDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
        } else {
            this.clientgui.systemMessage(Messages.getString("FiringDisplay.willSwitch", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
        }
        this.updateTarget();
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n);
    }

    private void cacheVisibleTargets() {
        this.clearVisibleTargets();
        Vector<Entity> vector = this.client.game.getValidTargets(this.ce());
        Comparator<Entity> comparator = new Comparator<Entity>(){

            @Override
            public int compare(Entity entity, Entity entity2) {
                int n;
                int n2 = FiringDisplay.this.ce().getPosition().distance(entity.getPosition());
                if (n2 == (n = FiringDisplay.this.ce().getPosition().distance(entity2.getPosition()))) {
                    return entity.getId() < entity2.getId() ? -1 : 1;
                }
                return n2 < n ? -1 : 1;
            }
        };
        TreeSet<Entity> treeSet = new TreeSet<Entity>(comparator);
        this.visibleTargets = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            treeSet.add(vector.elementAt(i));
        }
        Iterator<Entity> iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.visibleTargets[n++] = iterator.next();
        }
        this.setNextTargetEnabled(this.visibleTargets.length > 0);
    }

    private void clearVisibleTargets() {
        this.visibleTargets = null;
        this.lastTargetID = -1;
        this.setNextTargetEnabled(false);
    }

    private Entity getNextTarget() {
        if (this.visibleTargets == null) {
            return null;
        }
        ++this.lastTargetID;
        if (this.lastTargetID >= this.visibleTargets.length) {
            this.lastTargetID = 0;
        }
        return this.visibleTargets[this.lastTargetID];
    }

    private void jumpToNextTarget() {
        Entity entity = this.getNextTarget();
        if (entity == null) {
            return;
        }
        this.showTargetChoice = false;
        this.clientgui.bv.centerOnHex(entity.getPosition());
        this.clientgui.getBoardView().select(entity.getPosition());
        this.showTargetChoice = true;
        this.target(entity);
    }

    private void ready() {
        WeaponAttackAction weaponAttackAction;
        boolean bl;
        Targetable targetable;
        Entity entity;
        WeaponAttackAction weaponAttackAction2;
        Object object;
        if (this.attacks.isEmpty() && GUIPreferences.getInstance().getNagForNoAction()) {
            Iterator<AbstractEntityAction> iterator;
            object = Messages.getString("FiringDisplay.DontFireDialog.title");
            ConfirmDialog serializable = this.clientgui.doYesNoBotherDialog((String)object, (String)((Object)(iterator = Messages.getString("FiringDisplay.DontFireDialog.message"))));
            if (!serializable.getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!serializable.getAnswer()) {
                return;
            }
        }
        this.disableButtons();
        this.removeTempAttacks();
        object = new Vector();
        for (AbstractEntityAction abstractEntityAction : this.attacks) {
            if (abstractEntityAction instanceof ArtilleryAttackAction) {
                ((Vector)object).addElement(abstractEntityAction);
                continue;
            }
            if (abstractEntityAction instanceof WeaponAttackAction) {
                weaponAttackAction2 = (WeaponAttackAction)abstractEntityAction;
                entity = weaponAttackAction2.getEntity(this.client.game);
                targetable = weaponAttackAction2.getTarget(this.client.game);
                bl = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
                if (!bl) continue;
                weaponAttackAction = new WeaponAttackAction(weaponAttackAction2.getEntityId(), weaponAttackAction2.getTargetType(), weaponAttackAction2.getTargetId(), weaponAttackAction2.getWeaponId());
                weaponAttackAction.setAimedLocation(weaponAttackAction2.getAimedLocation());
                weaponAttackAction.setAimingMode(weaponAttackAction2.getAimingMode());
                weaponAttackAction.setOtherAttackInfo(weaponAttackAction2.getOtherAttackInfo());
                weaponAttackAction.setAmmoId(weaponAttackAction2.getAmmoId());
                ((Vector)object).addElement(weaponAttackAction);
                continue;
            }
            ((Vector)object).addElement(abstractEntityAction);
        }
        for (AbstractEntityAction abstractEntityAction : this.attacks) {
            if (abstractEntityAction instanceof ArtilleryAttackAction || !(abstractEntityAction instanceof WeaponAttackAction)) continue;
            weaponAttackAction2 = (WeaponAttackAction)abstractEntityAction;
            entity = weaponAttackAction2.getEntity(this.client.game);
            targetable = weaponAttackAction2.getTarget(this.client.game);
            bl = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
            if (bl) continue;
            weaponAttackAction = new WeaponAttackAction(weaponAttackAction2.getEntityId(), weaponAttackAction2.getTargetType(), weaponAttackAction2.getTargetId(), weaponAttackAction2.getWeaponId());
            weaponAttackAction.setAimedLocation(weaponAttackAction2.getAimedLocation());
            weaponAttackAction.setAimingMode(weaponAttackAction2.getAimingMode());
            weaponAttackAction.setOtherAttackInfo(weaponAttackAction2.getOtherAttackInfo());
            weaponAttackAction.setAmmoId(weaponAttackAction2.getAmmoId());
            ((Vector)object).addElement(weaponAttackAction);
        }
        this.client.sendAttackData(this.cen, (Vector<EntityAction>)object);
        this.attacks.removeAllElements();
        this.clientgui.getMenuBar().setEntity(null);
        this.ash.closeDialog();
        this.endMyTurn();
    }

    private void doClearTurret() {
        String string;
        String string2 = Messages.getString("FiringDisplay.ClearTurret.title");
        if (!this.clientgui.doYesNoDialog(string2, string = Messages.getString("FiringDisplay.ClearTurret.message"))) {
            return;
        }
        if (this.attacks.size() == 0 && this.ce() instanceof Tank && ((Tank)this.ce()).isTurretJammed()) {
            UnjamTurretAction unjamTurretAction = new UnjamTurretAction(this.ce().getId());
            this.attacks.add(unjamTurretAction);
            this.ready();
        }
    }

    private void doClearWeaponJam() {
        ArrayList<Mounted> arrayList = ((Tank)this.ce()).getJammedWeapons();
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = arrayList.get(i).getDesc();
        }
        SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("FiringDisplay.ClearWeaponJam.title"), Messages.getString("FiringDisplay.ClearWeaponJam.question"), stringArray);
        singleChoiceDialog.setVisible(true);
        if (singleChoiceDialog.getAnswer()) {
            RepairWeaponMalfunctionAction repairWeaponMalfunctionAction = new RepairWeaponMalfunctionAction(this.ce().getId(), this.ce().getEquipmentNum(arrayList.get(singleChoiceDialog.getChoice())));
            this.attacks.add(repairWeaponMalfunctionAction);
            this.ready();
        }
    }

    private void doSearchlight() {
        if (this.ce() == null || this.target == null) {
            throw new IllegalArgumentException("current searchlight parameters are invalid");
        }
        if (!SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null)) {
            return;
        }
        SearchlightAttackAction searchlightAttackAction = new SearchlightAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        this.attacks.addElement(searchlightAttackAction);
        this.client.game.addAction(searchlightAttackAction);
        this.clientgui.bv.addAttack(searchlightAttackAction);
        this.clientgui.minimap.drawMap();
        this.updateTarget();
    }

    void fire() {
        Serializable serializable;
        Object object;
        EntityAction entityAction;
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        Mounted mounted = this.ce().getEquipment(n);
        if (this.ce() == null || this.target == null || mounted == null || !(mounted.getType() instanceof WeaponType)) {
            throw new IllegalArgumentException("current fire parameters are invalid");
        }
        if (this.ce() instanceof Mech || this.ce() instanceof Tank || this.ce() instanceof Protomech) {
            entityAction = null;
            try {
                entityAction = this.attacks.lastElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (entityAction != null && entityAction instanceof WeaponAttackAction && !(object = ((AbstractAttackAction)(serializable = (WeaponAttackAction)entityAction)).getTarget(this.client.game)).equals(this.target)) {
                String string;
                String string2;
                boolean bl = Compute.isInArc(this.ce().getPosition(), this.ce().getSecondaryFacing(), object.getPosition(), 1);
                boolean bl2 = Compute.isInArc(this.ce().getPosition(), this.ce().getSecondaryFacing(), this.target.getPosition(), 1);
                if (!bl && bl2 && !this.clientgui.doYesNoDialog(string2 = Messages.getString("FiringDisplay.SecondaryTargetToHitChange.title"), string = Messages.getString("FiringDisplay.SecondaryTargetToHitChange.message"))) {
                    return;
                }
            }
        }
        if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
            this.doSearchlight();
        }
        entityAction = !mounted.getType().hasFlag(32768L) ? new WeaponAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n) : new ArtilleryAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n, this.client.game);
        if (mounted.getLinked() != null && ((WeaponType)mounted.getType()).getAmmoType() != -1) {
            serializable = mounted.getLinked();
            object = (AmmoType)((Mounted)serializable).getType();
            ((WeaponAttackAction)entityAction).setAmmoId(this.ce().getEquipmentNum((Mounted)serializable));
            if (((AmmoType)object).getMunitionType() == 0x2000000L && (((AmmoType)object).getAmmoType() == 7 || ((AmmoType)object).getAmmoType() == 45) || ((AmmoType)object).getMunitionType() == 0x10000000000L) {
                VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                vibrabombSettingDialog.setVisible(true);
                ((WeaponAttackAction)entityAction).setOtherAttackInfo(vibrabombSettingDialog.getSetting());
            }
        }
        if (this.ash.allowAimedShotWith(mounted) && this.ash.inAimingMode() && this.ash.isAimingAtLocation()) {
            ((WeaponAttackAction)entityAction).setAimedLocation(this.ash.getAimingAt());
            ((WeaponAttackAction)entityAction).setAimingMode(this.ash.getAimingMode());
        } else {
            ((WeaponAttackAction)entityAction).setAimedLocation(-1);
            ((WeaponAttackAction)entityAction).setAimingMode(0);
        }
        this.attacks.addElement((AbstractEntityAction)entityAction);
        this.client.game.addAction(entityAction);
        this.clientgui.minimap.drawMap();
        mounted.setUsedThisRound(true);
        int n2 = this.ce().getNextWeapon(n);
        this.updateClearTurret();
        this.updateClearWeaponJam();
        if (n2 == -1 && GUIPreferences.getInstance().getAutoEndFiring()) {
            this.ready();
            return;
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n2);
        this.updateTarget();
    }

    void nextWeapon() {
        int n = this.ce().getNextWeapon(this.clientgui.mechD.wPan.getSelectedWeaponNum());
        if (n == -1) {
            return;
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.clientgui.mechD.wPan.selectWeapon(n);
        this.updateTarget();
    }

    private void findClub() {
        String string;
        if (this.ce() == null) {
            return;
        }
        String string2 = Messages.getString("FiringDisplay.FindClubDialog.title");
        if (!this.clientgui.doYesNoDialog(string2, string = Messages.getString("FiringDisplay.FindClubDialog.message"))) {
            return;
        }
        this.attacks.removeAllElements();
        this.attacks.addElement(new FindClubAction(this.cen));
        this.ready();
    }

    private void doSpot() {
        String string;
        if (this.ce() == null || this.target == null) {
            return;
        }
        if (this.ce().isINarcedWith(4L)) {
            String string2 = Messages.getString("FiringDisplay.CantSpotDialog.title");
            String string3 = Messages.getString("FiringDisplay.CantSpotDialog.message");
            this.clientgui.doAlertDialog(string2, string3);
            return;
        }
        String string4 = Messages.getString("FiringDisplay.SpotForInderectDialog.title");
        if (!this.clientgui.doYesNoDialog(string4, string = Messages.getString("FiringDisplay.SpotForInderectDialog.message"))) {
            return;
        }
        this.attacks.addElement(new SpotAction(this.cen, this.target.getTargetId()));
    }

    private void clearAttacks() {
        if (this.ce() == null) {
            return;
        }
        Enumeration<AbstractEntityAction> enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction = enumeration.nextElement();
            if (!(abstractEntityAction instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)abstractEntityAction;
            this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
        }
        this.attacks.removeAllElements();
        this.removeTempAttacks();
        this.ce().setSecondaryFacing(this.ce().getFacing());
        this.ce().setArmsFlipped(false);
    }

    private void removeTempAttacks() {
        this.client.game.removeActionsFor(this.cen);
        this.clientgui.bv.removeAttacksFor(this.ce());
    }

    private void removeLastFiring() {
        AbstractEntityAction abstractEntityAction = this.attacks.lastElement();
        if (abstractEntityAction instanceof WeaponAttackAction) {
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)abstractEntityAction;
            this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
            this.attacks.removeElement(abstractEntityAction);
            this.clientgui.mechD.wPan.displayMech(this.ce());
            this.client.game.removeAction(abstractEntityAction);
            this.clientgui.bv.refreshAttacks();
            this.clientgui.minimap.drawMap();
        }
    }

    private void refreshAll() {
        if (this.ce() == null) {
            return;
        }
        this.clientgui.bv.redrawEntity(this.ce());
        this.clientgui.mechD.displayEntity(this.ce());
        this.clientgui.mechD.showPanel("weapons");
        this.clientgui.mechD.wPan.selectWeapon(this.ce().getFirstWeapon());
        this.updateTarget();
    }

    void target(Targetable targetable) {
        this.target = targetable;
        this.ash.setAimingMode();
        this.updateTarget();
        this.ash.showDialog();
    }

    protected void updateTarget() {
        this.setFireEnabled(false);
        if (this.ce() != null && !this.ce().equals(this.clientgui.mechD.getCurrentEntity())) {
            this.clientgui.mechD.displayEntity(this.ce());
        }
        if (this.ce() != null && this.ce().canSpot() && this.target != null && this.client.game.getOptions().booleanOption("indirect_fire")) {
            this.setSpotEnabled(true);
        }
        int n = this.clientgui.mechD.wPan.getSelectedWeaponNum();
        if (this.target != null && this.target.getPosition() != null && n != -1 && this.ce() != null) {
            ToHitData toHitData;
            Mounted mounted;
            if (this.ash.inAimingMode()) {
                mounted = this.ce().getEquipment(n);
                boolean bl = this.ash.isAimingAtLocation() && this.ash.allowAimedShotWith(mounted);
                this.ash.setEnableAll(bl);
                if (bl) {
                    toHitData = WeaponAttackAction.toHit(this.client.game, this.cen, this.target, n, this.ash.getAimingAt(), this.ash.getAimingMode());
                    this.clientgui.mechD.wPan.wTargetR.setText(this.target.getDisplayName() + " (" + this.ash.getAimingLocation() + ")");
                } else {
                    toHitData = WeaponAttackAction.toHit(this.client.game, this.cen, this.target, n, -1, 0);
                    this.clientgui.mechD.wPan.wTargetR.setText(this.target.getDisplayName());
                }
                this.ash.setPartialCover(toHitData.getCover());
            } else {
                toHitData = WeaponAttackAction.toHit(this.client.game, this.cen, this.target, n, -1, 0);
                this.clientgui.mechD.wPan.wTargetR.setText(this.target.getDisplayName());
            }
            this.clientgui.mechD.wPan.wRangeR.setText("" + this.ce().getPosition().distance(this.target.getPosition()));
            if (this.ce() instanceof Aero && this.target instanceof Aero && this.client.game.getBoard().inAtmosphere()) {
                int n2 = Math.abs(this.ce().getElevation() - this.target.getElevation());
                this.clientgui.mechD.wPan.wRangeR.setText("" + this.ce().getPosition().distance(this.target.getPosition()) + " + " + n2 + " altitude");
            }
            if ((mounted = this.ce().getEquipment(n)).isUsedThisRound()) {
                this.clientgui.mechD.wPan.wToHitR.setText(Messages.getString("FiringDisplay.alreadyFired"));
                this.setFireEnabled(false);
            } else if (mounted.getType().hasFlag(16L)) {
                this.clientgui.mechD.wPan.wToHitR.setText(Messages.getString("FiringDisplay.autoFiringWeapon"));
                this.setFireEnabled(false);
            } else if (toHitData.getValue() == Integer.MAX_VALUE) {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.setFireEnabled(false);
            } else if (toHitData.getValue() == 0x7FFFFFFE) {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.setFireEnabled(true);
            } else {
                this.clientgui.mechD.wPan.wToHitR.setText(toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)");
                this.setFireEnabled(true);
            }
            this.clientgui.mechD.wPan.toHitText.setText(toHitData.getDesc());
            this.setSkipEnabled(true);
        } else {
            this.clientgui.mechD.wPan.wTargetR.setText("---");
            this.clientgui.mechD.wPan.wRangeR.setText("---");
            this.clientgui.mechD.wPan.wToHitR.setText("---");
            this.clientgui.mechD.wPan.toHitText.setText("");
        }
        this.updateSearchlight();
    }

    void torsoTwist(Coords coords) {
        int n = this.ce().getFacing();
        if (coords != null) {
            n = this.ce().clipSecondaryFacing(this.ce().getPosition().direction(coords));
        }
        if (n != this.ce().getSecondaryFacing()) {
            this.clearAttacks();
            this.attacks.addElement(new TorsoTwistAction(this.cen, n));
            this.ce().setSecondaryFacing(n);
            this.refreshAll();
        }
    }

    void torsoTwist(int n) {
        int n2 = this.ce().getSecondaryFacing();
        if (n == 0) {
            this.clearAttacks();
            n2 = this.ce().clipSecondaryFacing((n2 + 5) % 6);
            this.attacks.addElement(new TorsoTwistAction(this.cen, n2));
            this.ce().setSecondaryFacing(n2);
            this.refreshAll();
        } else if (n == 1) {
            this.clearAttacks();
            n2 = this.ce().clipSecondaryFacing((n2 + 7) % 6);
            this.attacks.addElement(new TorsoTwistAction(this.cen, n2));
            this.ce().setSecondaryFacing(n2);
            this.refreshAll();
        }
    }

    Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        if (this.shiftheld != ((boardViewEvent.getModifiers() & 1) != 0)) {
            boolean bl = this.shiftheld = (boardViewEvent.getModifiers() & 1) != 0;
        }
        if (boardViewEvent.getType() == 2) {
            if (this.shiftheld || this.twisting) {
                this.updateFlipArms(false);
                this.torsoTwist(boardViewEvent.getCoords());
            }
            this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
        } else if (boardViewEvent.getType() == 0) {
            this.twisting = false;
            this.clientgui.getBoardView().select(boardViewEvent.getCoords());
        }
    }

    public void hexSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && boardViewEvent.getCoords() != null && this.ce() != null && !boardViewEvent.getCoords().equals(this.ce().getPosition())) {
            Targetable targetable = null;
            if (this.showTargetChoice) {
                targetable = this.chooseTarget(boardViewEvent.getCoords());
            }
            if (this.shiftheld) {
                this.updateFlipArms(false);
                this.torsoTwist(boardViewEvent.getCoords());
            } else if (targetable != null) {
                this.target(targetable);
            }
        }
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_FIRING) {
            if (this.client.isMyTurn()) {
                if (this.cen == -1) {
                    this.beginMyTurn();
                }
                this.setStatusBarText(Messages.getString("FiringDisplay.its_your_turn"));
            } else {
                this.endMyTurn();
                this.setStatusBarText(Messages.getString("FiringDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
            }
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != IGame.Phase.PHASE_FIRING) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_FIRING) {
            this.setStatusBarText(Messages.getString("FiringDisplay.waitingForFiringPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.ready();
        } else if ("viewGameOptions".equalsIgnoreCase(actionEvent.getActionCommand())) {
            if (this.clientgui.getGameOptionsDialog().isEditable()) {
                this.clientgui.getGameOptionsDialog().setEditable(false);
            }
            this.clientgui.getGameOptionsDialog().update(this.client.game.getOptions());
            this.clientgui.getGameOptionsDialog().setVisible(true);
        } else if (actionEvent.getActionCommand().equals(FIRE_FIRE)) {
            this.fire();
        } else if (actionEvent.getActionCommand().equals(FIRE_SKIP)) {
            this.nextWeapon();
        } else if (actionEvent.getActionCommand().equals(FIRE_TWIST)) {
            this.twisting = true;
        } else if (actionEvent.getActionCommand().equals(FIRE_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(FIRE_MORE)) {
            ++this.buttonLayout;
            this.buttonLayout %= 2;
            this.setupButtonPanel();
        } else if (actionEvent.getActionCommand().equals(FIRE_FIND_CLUB)) {
            this.findClub();
        } else if (actionEvent.getActionCommand().equals(FIRE_SPOT)) {
            this.doSpot();
        } else if (actionEvent.getActionCommand().equals(FIRE_NEXT_TARG)) {
            this.jumpToNextTarget();
        } else if (actionEvent.getActionCommand().equals(FIRE_FLIP_ARMS)) {
            this.updateFlipArms(!this.ce().getArmsFlipped());
        } else if (actionEvent.getActionCommand().equals(FIRE_MODE)) {
            this.changeMode();
        } else if ("changeSinks".equalsIgnoreCase(actionEvent.getActionCommand()) || actionEvent.getActionCommand().equals(FIRE_CANCEL)) {
            this.clearAttacks();
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
        } else if (actionEvent.getActionCommand().equals(FIRE_SEARCHLIGHT)) {
            this.doSearchlight();
        } else if (actionEvent.getActionCommand().equals(FIRE_CLEAR_TURRET)) {
            this.doClearTurret();
        } else if (actionEvent.getActionCommand().equals(FIRE_CLEAR_WEAPON)) {
            this.doClearWeaponJam();
        }
    }

    void updateFlipArms(boolean bl) {
        if (bl == this.ce().getArmsFlipped()) {
            return;
        }
        this.twisting = false;
        this.torsoTwist(null);
        this.clearAttacks();
        this.ce().setArmsFlipped(bl);
        this.attacks.addElement(new FlipArmsAction(this.cen, bl));
        this.updateTarget();
        this.refreshAll();
    }

    private void updateSearchlight() {
        this.setSearchlightEnabled(this.ce() != null && this.target != null && this.ce().isUsingSpotlight() && this.ce().getCrew().isActive() && SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null) && ((Tank)this.ce()).getStunnedTurns() <= 0);
    }

    private void updateClearTurret() {
        this.setFireClearTurretEnabled(this.ce() instanceof Tank && ((Tank)this.ce()).isTurretJammed() && this.attacks.size() == 0 && ((Tank)this.ce()).getStunnedTurns() <= 0);
    }

    private void updateClearWeaponJam() {
        this.setFireClearWeaponJamEnabled(this.ce() instanceof Tank && ((Tank)this.ce()).getJammedWeapons().size() != 0 && this.attacks.size() == 0 && ((Tank)this.ce()).getStunnedTurns() <= 0);
    }

    private void setFireEnabled(boolean bl) {
        this.butFire.setEnabled(bl);
        this.clientgui.getMenuBar().setFireFireEnabled(bl);
    }

    private void setTwistEnabled(boolean bl) {
        this.butTwist.setEnabled(bl);
        this.clientgui.getMenuBar().setFireTwistEnabled(bl);
    }

    private void setSkipEnabled(boolean bl) {
        this.butSkip.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSkipEnabled(bl);
    }

    private void setFindClubEnabled(boolean bl) {
        this.butFindClub.setEnabled(bl);
        this.clientgui.getMenuBar().setFireFindClubEnabled(bl);
    }

    private void setNextTargetEnabled(boolean bl) {
        this.butNextTarg.setEnabled(bl);
        this.clientgui.getMenuBar().setFireNextTargetEnabled(bl);
    }

    private void setFlipArmsEnabled(boolean bl) {
        this.butFlipArms.setEnabled(bl);
        this.clientgui.getMenuBar().setFireFlipArmsEnabled(bl);
    }

    private void setSpotEnabled(boolean bl) {
        this.butSpot.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSpotEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl) {
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSearchlightEnabled(bl);
    }

    private void setFireModeEnabled(boolean bl) {
        this.butFireMode.setEnabled(bl);
        this.clientgui.getMenuBar().setFireModeEnabled(bl);
    }

    private void setFireClearTurretEnabled(boolean bl) {
        this.butFireClearTurret.setEnabled(bl);
        this.clientgui.getMenuBar().setFireClearTurretEnabled(bl);
    }

    private void setFireClearWeaponJamEnabled(boolean bl) {
        this.butFireClearWeaponJam.setEnabled(bl);
        this.clientgui.getMenuBar().setFireClearWeaponJamEnabled(bl);
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setFireNextEnabled(bl);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearAttacks();
            this.clientgui.getBoardView().select(null);
            this.clientgui.getBoardView().cursor(null);
            this.refreshAll();
        }
        if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 8 && this.client.isMyTurn()) {
            this.removeLastFiring();
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null) {
                this.updateFlipArms(false);
                this.torsoTwist(this.clientgui.getBoardView().getLastCursor());
            }
        }
        if (keyEvent.getKeyCode() == 37 && this.shiftheld) {
            this.updateFlipArms(false);
            this.torsoTwist(0);
        }
        if (keyEvent.getKeyCode() == 39 && this.shiftheld) {
            this.updateFlipArms(false);
            this.torsoTwist(1);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.ce() != null) {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.bv.centerOnHex(this.ce().getPosition());
        }
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (this.client.isMyTurn()) {
            if (this.client.getMyTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.clientgui.mechD.wPan.weaponList)) {
            this.updateTarget();
        }
    }

    public JButton getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
        this.clientgui.mechD.wPan.weaponList.removeListSelectionListener(this);
    }

    private Targetable chooseTarget(Coords coords) {
        boolean bl = this.client.game.getOptions().booleanOption("friendly_fire");
        Targetable targetable = null;
        Enumeration<Entity> enumeration = bl ? this.client.game.getEntities(coords) : this.client.game.getEnemyEntities(coords, this.ce());
        Vector<Targetable> vector = new Vector<Targetable>();
        while (enumeration.hasMoreElements()) {
            targetable = enumeration.nextElement();
            if (this.ce().equals(targetable)) continue;
            vector.addElement(targetable);
        }
        Building building = this.client.game.getBoard().getBuildingAt(coords);
        if (building != null) {
            vector.addElement(new BuildingTarget(coords, this.client.game.getBoard(), false));
        }
        if (vector.size() == 1) {
            targetable = (Targetable)vector.elementAt(0);
        } else if (vector.size() > 1) {
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Targetable)vector.elementAt(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("FiringDisplay.ChooseTargetDialog.title"), Messages.getString("FiringDisplay.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()}), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                targetable = (Targetable)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return targetable;
    }

    private class AimedShotHandler
    implements ActionListener,
    ItemListener {
        private int aimingAt = -1;
        private int aimingMode = 0;
        private int partialCover = 0;
        private AimedShotDialog asd;

        public void showDialog() {
            if (this.asd != null) {
                int n = this.aimingMode;
                this.closeDialog();
                this.aimingMode = n;
            }
            if (this.inAimingMode()) {
                boolean[] blArray;
                String[] stringArray;
                if (FiringDisplay.this.target instanceof Mech) {
                    if (FiringDisplay.this.target instanceof BipedMech) {
                        stringArray = BipedMech.LOCATION_NAMES;
                        blArray = this.createEnabledMask(stringArray.length);
                    } else {
                        stringArray = QuadMech.LOCATION_NAMES;
                        blArray = this.createEnabledMask(stringArray.length);
                    }
                    if (this.aimingMode == 1) {
                        this.aimingAt = 0;
                    } else if (this.aimingMode == 2) {
                        this.aimingAt = 1;
                    }
                } else if (FiringDisplay.this.target instanceof Tank) {
                    if (FiringDisplay.this.target instanceof LargeSupportTank) {
                        stringArray = LargeSupportTank.LOCATION_NAMES;
                        this.aimingAt = 1;
                    } else {
                        stringArray = Tank.LOCATION_NAMES;
                        this.aimingAt = 1;
                    }
                    blArray = this.createEnabledMask(stringArray.length);
                } else if (FiringDisplay.this.target instanceof GunEmplacement) {
                    stringArray = GunEmplacement.HIT_LOCATION_NAMES;
                    blArray = new boolean[]{true, ((GunEmplacement)FiringDisplay.this.target).hasTurret()};
                    this.aimingAt = 0;
                } else if (FiringDisplay.this.target instanceof Protomech) {
                    stringArray = Protomech.LOCATION_NAMES;
                    blArray = this.createEnabledMask(stringArray.length);
                    this.aimingAt = 1;
                } else if (FiringDisplay.this.target instanceof BattleArmor) {
                    stringArray = BattleArmor.IS_LOCATION_NAMES;
                    blArray = this.createEnabledMask(stringArray.length);
                    this.aimingAt = 1;
                } else {
                    return;
                }
                this.asd = new AimedShotDialog(FiringDisplay.this.clientgui.frame, Messages.getString("FiringDisplay.AimedShotDialog.title"), Messages.getString("FiringDisplay.AimedShotDialog.message"), stringArray, blArray, this.aimingAt, this, this);
                this.asd.setVisible(true);
                FiringDisplay.this.updateTarget();
            }
        }

        private boolean[] createEnabledMask(int n) {
            int n2;
            boolean[] blArray = new boolean[n];
            for (n2 = 0; n2 < n; ++n2) {
                blArray[n2] = true;
            }
            n2 = Compute.targetSideTable(FiringDisplay.this.ce(), FiringDisplay.this.target);
            if (FiringDisplay.this.target instanceof Tank) {
                blArray[0] = false;
                Tank tank = (Tank)FiringDisplay.this.target;
                if (tank.hasNoTurret()) {
                    blArray[5] = false;
                }
                if (FiringDisplay.this.target instanceof LargeSupportTank) {
                    if (n2 == 5) {
                        blArray[2] = false;
                        blArray[4] = false;
                        blArray[6] = false;
                    }
                    if (n2 == 6) {
                        blArray[3] = false;
                        blArray[5] = false;
                        blArray[6] = false;
                    }
                    if (n2 == 8) {
                        blArray[3] = false;
                        blArray[5] = false;
                        blArray[1] = false;
                    }
                    if (n2 == 7) {
                        blArray[4] = false;
                        blArray[2] = false;
                        blArray[1] = false;
                    }
                } else {
                    if (n2 == 2) {
                        blArray[2] = false;
                    }
                    if (n2 == 3) {
                        blArray[3] = false;
                    }
                    if (n2 == 1) {
                        blArray[1] = false;
                    }
                    if (n2 == 0) {
                        blArray[4] = false;
                    }
                }
            }
            if (FiringDisplay.this.target instanceof Protomech && !((Protomech)FiringDisplay.this.target).hasMainGun()) {
                blArray[5] = false;
            }
            if (FiringDisplay.this.target instanceof BattleArmor) {
                blArray[0] = false;
            }
            if ((this.partialCover & 3) != 0) {
                blArray[7] = false;
                blArray[6] = false;
            }
            if (n2 == 0) {
                if ((this.partialCover & 1) != 0) {
                    blArray[6] = false;
                }
                if ((this.partialCover & 2) != 0) {
                    blArray[7] = false;
                }
                if ((this.partialCover & 4) != 0) {
                    blArray[4] = false;
                    blArray[2] = false;
                }
                if ((this.partialCover & 8) != 0) {
                    blArray[5] = false;
                    blArray[3] = false;
                }
            } else {
                if ((this.partialCover & 1) != 0) {
                    blArray[7] = false;
                }
                if ((this.partialCover & 2) != 0) {
                    blArray[6] = false;
                }
                if ((this.partialCover & 4) != 0) {
                    blArray[5] = false;
                    blArray[3] = false;
                }
                if ((this.partialCover & 8) != 0) {
                    blArray[4] = false;
                    blArray[2] = false;
                }
            }
            if (this.aimingMode == 2) {
                blArray[0] = false;
            }
            return blArray;
        }

        public void closeDialog() {
            if (this.asd != null) {
                this.aimingAt = -1;
                this.aimingMode = 0;
                this.asd.setVisible(false);
                this.asd = null;
                FiringDisplay.this.updateTarget();
            }
        }

        public void setEnableAll(boolean bl) {
            if (this.asd != null) {
                this.asd.setEnableAll(bl);
            }
        }

        public void setPartialCover(int n) {
            this.partialCover = n;
        }

        public int getAimingAt() {
            return this.aimingAt;
        }

        public int getAimingMode() {
            return this.aimingMode;
        }

        public String getAimingLocation() {
            if (FiringDisplay.this.target != null && this.aimingAt != -1 && this.aimingMode != 0) {
                if (FiringDisplay.this.target instanceof BipedMech) {
                    return BipedMech.LOCATION_NAMES[this.aimingAt];
                }
                if (FiringDisplay.this.target instanceof BipedMech) {
                    return QuadMech.LOCATION_NAMES[this.aimingAt];
                }
                if (FiringDisplay.this.target instanceof GunEmplacement) {
                    return GunEmplacement.HIT_LOCATION_NAMES[this.aimingAt];
                }
            }
            return null;
        }

        public void setAimingMode() {
            boolean bl;
            boolean bl2 = bl = FiringDisplay.this.target != null && FiringDisplay.this.ce().hasAimModeTargComp() && FiringDisplay.this.target instanceof Mech;
            if (bl) {
                this.aimingMode = 2;
                return;
            }
            boolean bl3 = bl = FiringDisplay.this.target != null && (FiringDisplay.this.target.isImmobile() && (FiringDisplay.this.target instanceof Mech || FiringDisplay.this.target instanceof Tank) || FiringDisplay.this.target instanceof GunEmplacement);
            if (bl) {
                this.aimingMode = 1;
                return;
            }
            this.aimingMode = 0;
        }

        public boolean inAimingMode() {
            return this.aimingMode != 0;
        }

        public boolean isAimingAtLocation() {
            return this.aimingAt != -1;
        }

        public boolean allowAimedShotWith(Mounted mounted) {
            AmmoType ammoType;
            WeaponType weaponType = (WeaponType)mounted.getType();
            boolean bl = weaponType.hasFlag(2048L);
            boolean bl2 = weaponType.getAmmoType() != -1 && !bl;
            Mounted mounted2 = bl2 ? mounted.getLinked() : null;
            AmmoType ammoType2 = ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
            if (weaponType.getInternalName().equals("LegAttack") || weaponType.getInternalName().equals("SwarmMek")) {
                return false;
            }
            switch (this.aimingMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    if (ammoType == null) break;
                    switch (ammoType.getAmmoType()) {
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 24: 
                        case 26: 
                        case 28: 
                        case 31: 
                        case 37: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 45: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: {
                            return false;
                        }
                    }
                    if (ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L) break;
                    return false;
                }
                case 2: {
                    if (!weaponType.hasFlag(1L) || weaponType.hasFlag(0x40000000L)) {
                        return false;
                    }
                    if (mounted.getCurrentShots() > 1) {
                        return false;
                    }
                    if (ammoType == null || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L) break;
                    return false;
                }
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.closeDialog();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            IndexedCheckbox indexedCheckbox = (IndexedCheckbox)itemEvent.getSource();
            this.aimingAt = indexedCheckbox.getIndex();
            FiringDisplay.this.updateTarget();
        }
    }
}

