/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import megamek.client.ui.swing.IMapSettingsObserver;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.widget.SimpleLine;
import megamek.common.MapSettings;

public class RandomMapDialog
extends JDialog
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -1932447917045308611L;
    private static final String NONE = Messages.getString("RandomMapDialog.elevNONE");
    private static final String LOW = Messages.getString("RandomMapDialog.elevLow");
    private static final String MEDIUM = Messages.getString("RandomMapDialog.elevMedium");
    private static final String HIGH = Messages.getString("RandomMapDialog.elevHigh");
    private static final String INVALID_SETTING = Messages.getString("RandomMapDialog.InvalidSetting");
    private static final int NORMAL_LINE_WIDTH = 195;
    private static final int ADVANCED_LINE_WIDTH = 295;
    private JScrollPane scrAll;
    private JButton butOK;
    private JButton butAdvanced;
    private JButton butSave;
    private JButton butLoad;
    private JPanel panButtons;
    private JPanel panOptions;
    private JLabel labBoardSize;
    private JTextField texBoardWidth;
    private JTextField texBoardHeight;
    private JComboBox choElevation;
    private JComboBox choCliffs;
    private JComboBox choWoods;
    private JComboBox choLakes;
    private JComboBox choPavement;
    private JComboBox choRubble;
    private JComboBox choFortified;
    private JComboBox choIce;
    private JComboBox choRough;
    private JComboBox choRoads;
    private JComboBox choRivers;
    private JComboBox choSwamp;
    private JComboBox choCraters;
    private JComboBox choCity;
    private JComboBox choMountain;
    private JLabel labElevation;
    private JLabel labCliffs;
    private JLabel labWoods;
    private JLabel labLakes;
    private JLabel labPavement;
    private JLabel labRubble;
    private JLabel labFortified;
    private JLabel labIce;
    private JLabel labRough;
    private JLabel labRoads;
    private JLabel labRivers;
    private JLabel labSwamp;
    private JLabel labTheme;
    private JLabel labCraters;
    private JLabel labCity;
    private JLabel labMountain = null;
    private SimpleLine slElevation;
    private SimpleLine slCliffs;
    private SimpleLine slWoods;
    private SimpleLine slLakes;
    private SimpleLine slPavement;
    private SimpleLine slRubble;
    private SimpleLine slFortified;
    private SimpleLine slIce;
    private SimpleLine slRough;
    private SimpleLine slRoads;
    private SimpleLine slRivers;
    private SimpleLine slSwamp;
    private SimpleLine slBoardSize;
    private SimpleLine slCraters;
    private SimpleLine slCity;
    private SimpleLine slMountain;
    private SimpleLine slElevationAd;
    private SimpleLine slWoodsAd;
    private SimpleLine slLakesAd;
    private SimpleLine slPavementAd;
    private SimpleLine slRubbleAd;
    private SimpleLine slFortifiedAd;
    private SimpleLine slIceAd;
    private SimpleLine slRoughAd;
    private SimpleLine slRoadsAd;
    private SimpleLine slRiversAd;
    private SimpleLine slSwampAd;
    private SimpleLine slBoardSizeAd;
    private SimpleLine slCratersAd;
    private SimpleLine slCityAd;
    private SimpleLine slInvertNegativeAd;
    private JTextField texTheme;
    private JLabel labHilliness;
    private JTextField texHilliness;
    private JLabel labInvertNegative;
    private JTextField texInvertNegative;
    private JLabel labRange;
    private JTextField texRange;
    private JLabel labProbInvert;
    private JTextField texProbInvert;
    private JLabel labCliffsAd;
    private JTextField texCliffs;
    private JLabel labWaterSpots;
    private JTextField texMinWaterSpots;
    private JTextField texMaxWaterSpots;
    private JLabel labWaterSize;
    private JTextField texMinWaterSize;
    private JTextField texMaxWaterSize;
    private JLabel labProbDeep;
    private JTextField texProbDeep;
    private JLabel labForestSpots;
    private JTextField texMinForestSpots;
    private JTextField texMaxForestSpots;
    private JLabel labForestSize;
    private JTextField texMinForestSize;
    private JTextField texMaxForestSize;
    private JLabel labProbHeavy;
    private JTextField texProbHeavy;
    private JLabel labRoughSpots;
    private JTextField texMinRoughSpots;
    private JTextField texMaxRoughSpots;
    private JLabel labRoughSize;
    private JTextField texMinRoughSize;
    private JTextField texMaxRoughSize;
    private JLabel labSwampSpots;
    private JTextField texMinSwampSpots;
    private JTextField texMaxSwampSpots;
    private JLabel labSwampSize;
    private JTextField texMinSwampSize;
    private JTextField texMaxSwampSize;
    private JLabel labPavementSpots;
    private JTextField texMinPavementSpots;
    private JTextField texMaxPavementSpots;
    private JLabel labPavementSize;
    private JTextField texMinPavementSize;
    private JTextField texMaxPavementSize;
    private JLabel labIceSpots;
    private JTextField texMinIceSpots;
    private JTextField texMaxIceSpots;
    private JLabel labIceSize;
    private JTextField texMinIceSize;
    private JTextField texMaxIceSize;
    private JLabel labRubbleSpots;
    private JTextField texMinRubbleSpots;
    private JTextField texMaxRubbleSpots;
    private JLabel labRubbleSize;
    private JTextField texMinRubbleSize;
    private JTextField texMaxRubbleSize;
    private JLabel labFortifiedSpots;
    private JTextField texMinFortifiedSpots;
    private JTextField texMaxFortifiedSpots;
    private JLabel labFortifiedSize;
    private JTextField texMinFortifiedSize;
    private JTextField texMaxFortifiedSize;
    private JLabel labProbRoad;
    private JTextField texProbRoad;
    private JLabel labProbRiver;
    private JTextField texProbRiver;
    private JLabel labProbCrater;
    private JTextField texProbCrater;
    private JLabel labRadius;
    private JTextField texMinRadius;
    private JTextField texMaxRadius;
    private JLabel labMaxCraters;
    private JTextField texMaxCraters;
    private JTextField texMinCraters;
    private JLabel labProbDrought;
    private JTextField texProbDrought;
    private JLabel labProbFire;
    private JTextField texProbFire;
    private JLabel labProbFlood;
    private JTextField texProbFlood;
    private JLabel labProbFreeze;
    private JTextField texProbFreeze;
    private JLabel labFxMod;
    private JTextField texFxMod;
    private JLabel labCityBlocks;
    private JLabel labCityCF;
    private JLabel labCityFloors;
    private JLabel labCityDensity;
    private JLabel labTownSize;
    private JTextField texCityBlocks;
    private JTextField texCityMinCF;
    private JTextField texCityMaxCF;
    private JTextField texCityMinFloors;
    private JTextField texCityMaxFloors;
    private JTextField texCityDensity;
    private JTextField texTownSize;
    private JLabel labMountainPeaks;
    private JLabel labMountainHeight;
    private JLabel labMountainWidth;
    private JLabel labMountainStyle;
    private JTextField texMountainPeaks;
    private JTextField texMountainStyle;
    private JTextField texMountainHeightMin;
    private JTextField texMountainHeightMax;
    private JTextField texMountainWidthMin;
    private JTextField texMountainWidthMax;
    private JLabel labAlgorithmToUse;
    private JTextField texAlgorithmToUse;
    GridBagLayout gridbag;
    private MapSettings mapSettings;
    private JFrame frame;
    private IMapSettingsObserver bsd;
    private boolean advanced;
    private boolean initiated;

    public RandomMapDialog(JFrame jFrame, IMapSettingsObserver iMapSettingsObserver, MapSettings mapSettings) {
        super(jFrame, Messages.getString("RandomMapDialog.title"), true);
        this.mapSettings = mapSettings;
        this.frame = jFrame;
        this.bsd = iMapSettingsObserver;
        this.setResizable(true);
        this.createComponents();
        this.loadValues();
        this.getContentPane().setLayout(new BorderLayout());
        this.setupOptions();
        this.getContentPane().add((Component)this.scrAll, "Center");
        this.setupButtons();
        this.getContentPane().add((Component)this.panButtons, "South");
        this.validate();
        this.pack();
        this.setProperSize();
        this.butOK.requestFocus();
        this.setProperSize();
        this.setProperLocation();
        this.initiated = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butOK)) {
            if (this.applyValues()) {
                this.setVisible(false);
            }
        } else if (actionEvent.getSource().equals(this.butSave)) {
            JFileChooser jFileChooser = new JFileChooser("data" + File.separator + "boards");
            jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
            jFileChooser.setDialogTitle(Messages.getString("RandomMapDialog.FileSaveDialog"));
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return null != file.getName() && file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return ".xml";
                }
            });
            int n = jFileChooser.showSaveDialog(this.frame);
            if (n != 0 || jFileChooser.getSelectedFile() == null) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".xml")) {
                try {
                    file = new File(file.getCanonicalPath() + ".xml");
                }
                catch (IOException iOException) {
                    return;
                }
            }
            try {
                this.mapSettings.save(new FileOutputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource().equals(this.butLoad)) {
            JFileChooser jFileChooser = new JFileChooser("data" + File.separator + "boards");
            jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
            jFileChooser.setDialogTitle(Messages.getString("RandomMapDialog.FileLoadDialog"));
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return null != file.getName() && file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return ".xml";
                }
            });
            int n = jFileChooser.showOpenDialog(this.frame);
            if (n != 0 || jFileChooser.getSelectedFile() == null) {
                return;
            }
            try {
                this.mapSettings.load(new FileInputStream(jFileChooser.getSelectedFile()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.loadValues();
            if (!this.advanced) {
                this.advanced = true;
                this.butAdvanced.setText(Messages.getString("RandomMapDialog.Normal"));
                this.setupOptions();
                this.setProperSize();
            }
        } else {
            boolean bl = this.advanced = !this.advanced;
            if (this.advanced) {
                this.butAdvanced.setText(Messages.getString("RandomMapDialog.Normal"));
            } else {
                this.butAdvanced.setText(Messages.getString("RandomMapDialog.Advanced"));
            }
            this.setupOptions();
            this.setProperSize();
        }
    }

    private void setupOptions() {
        this.panOptions.removeAll();
        this.addLabelTextField(this.labBoardSize, this.texBoardWidth, this.texBoardHeight, "x");
        this.texBoardWidth.requestFocus();
        if (!this.advanced) {
            this.addSeparator(this.slBoardSize);
            this.addLabelTextField(this.labTheme, this.texTheme);
            this.addOption(this.labElevation, this.choElevation, this.slElevation);
            this.addOption(this.labCliffs, this.choCliffs, this.slCliffs);
            this.addOption(this.labWoods, this.choWoods, this.slWoods);
            this.addOption(this.labRough, this.choRough, this.slRough);
            this.addOption(this.labSwamp, this.choSwamp, this.slSwamp);
            this.addOption(this.labRoads, this.choRoads, this.slRoads);
            this.addOption(this.labLakes, this.choLakes, this.slLakes);
            this.addOption(this.labRivers, this.choRivers, this.slRivers);
            this.addOption(this.labCraters, this.choCraters, this.slCraters);
            this.addOption(this.labPavement, this.choPavement, this.slPavement);
            this.addOption(this.labIce, this.choIce, this.slIce);
            this.addOption(this.labRubble, this.choRubble, this.slRubble);
            this.addOption(this.labFortified, this.choFortified, this.slFortified);
            this.addOption(this.labCity, this.choCity, this.slCity);
            this.addOption(this.labMountain, this.choMountain, this.slMountain);
        } else {
            this.addSeparator(this.slBoardSizeAd);
            this.addLabelTextField(this.labTheme, this.texTheme);
            this.addLabelTextField(this.labHilliness, this.texHilliness);
            this.addLabelTextField(this.labRange, this.texRange);
            this.addLabelTextField(this.labProbInvert, this.texProbInvert);
            this.addLabelTextField(this.labAlgorithmToUse, this.texAlgorithmToUse);
            this.addLabelTextField(this.labCliffsAd, this.texCliffs);
            this.addLabelTextField(this.labMountainPeaks, this.texMountainPeaks);
            this.addLabelTextField(this.labMountainStyle, this.texMountainStyle);
            this.addLabelTextField(this.labMountainHeight, this.texMountainHeightMin, this.texMountainHeightMax, "-");
            this.addLabelTextField(this.labMountainWidth, this.texMountainWidthMin, this.texMountainWidthMax, "-");
            this.addSeparator(this.slElevationAd);
            this.addLabelTextField(this.labForestSpots, this.texMinForestSpots, this.texMaxForestSpots, "-");
            this.addLabelTextField(this.labForestSize, this.texMinForestSize, this.texMaxForestSize, "-");
            this.addLabelTextField(this.labProbHeavy, this.texProbHeavy);
            this.addSeparator(this.slWoodsAd);
            this.addLabelTextField(this.labRoughSpots, this.texMinRoughSpots, this.texMaxRoughSpots, "-");
            this.addLabelTextField(this.labRoughSize, this.texMinRoughSize, this.texMaxRoughSize, "-");
            this.addSeparator(this.slRoughAd);
            this.addLabelTextField(this.labSwampSpots, this.texMinSwampSpots, this.texMaxSwampSpots, "-");
            this.addLabelTextField(this.labSwampSize, this.texMinSwampSize, this.texMaxSwampSize, "-");
            this.addSeparator(this.slSwampAd);
            this.addLabelTextField(this.labProbRoad, this.texProbRoad);
            this.addSeparator(this.slRoadsAd);
            this.addLabelTextField(this.labWaterSpots, this.texMinWaterSpots, this.texMaxWaterSpots, "-");
            this.addLabelTextField(this.labWaterSize, this.texMinWaterSize, this.texMaxWaterSize, "-");
            this.addLabelTextField(this.labProbDeep, this.texProbDeep);
            this.addSeparator(this.slLakesAd);
            this.addLabelTextField(this.labProbRiver, this.texProbRiver);
            this.addSeparator(this.slRiversAd);
            this.addLabelTextField(this.labProbCrater, this.texProbCrater);
            this.addLabelTextField(this.labMaxCraters, this.texMinCraters, this.texMaxCraters, "-");
            this.addLabelTextField(this.labRadius, this.texMinRadius, this.texMaxRadius, "-");
            this.addSeparator(this.slCratersAd);
            this.addLabelTextField(this.labPavementSpots, this.texMinPavementSpots, this.texMaxPavementSpots, "-");
            this.addLabelTextField(this.labPavementSize, this.texMinPavementSize, this.texMaxPavementSize, "-");
            this.addSeparator(this.slPavementAd);
            this.addLabelTextField(this.labRubbleSpots, this.texMinRubbleSpots, this.texMaxRubbleSpots, "-");
            this.addLabelTextField(this.labRubbleSize, this.texMinRubbleSize, this.texMaxRubbleSize, "-");
            this.addSeparator(this.slRubbleAd);
            this.addLabelTextField(this.labFortifiedSpots, this.texMinFortifiedSpots, this.texMaxFortifiedSpots, "-");
            this.addLabelTextField(this.labFortifiedSize, this.texMinFortifiedSize, this.texMaxFortifiedSize, "-");
            this.addSeparator(this.slFortifiedAd);
            this.addLabelTextField(this.labIceSpots, this.texMinIceSpots, this.texMaxIceSpots, "-");
            this.addLabelTextField(this.labIceSize, this.texMinIceSize, this.texMaxIceSize, "-");
            this.addSeparator(this.slIceAd);
            this.addLabelTextField(this.labProbDrought, this.texProbDrought);
            this.addLabelTextField(this.labProbFire, this.texProbFire);
            this.addLabelTextField(this.labProbFreeze, this.texProbFreeze);
            this.addLabelTextField(this.labProbFlood, this.texProbFlood);
            this.addLabelTextField(this.labFxMod, this.texFxMod);
            this.addSeparator(this.slCityAd);
            this.addOption(this.labCity, this.choCity, this.slCity);
            this.addLabelTextField(this.labCityBlocks, this.texCityBlocks);
            this.addLabelTextField(this.labCityCF, this.texCityMinCF, this.texCityMaxCF, "-");
            this.addLabelTextField(this.labCityFloors, this.texCityMinFloors, this.texCityMaxFloors, "-");
            this.addLabelTextField(this.labCityDensity, this.texCityDensity);
            this.addLabelTextField(this.labTownSize, this.texTownSize);
            this.addSeparator(this.slInvertNegativeAd);
            this.addLabelTextField(this.labInvertNegative, this.texInvertNegative);
        }
        this.scrAll = new JScrollPane(this.panOptions);
        if (this.initiated) {
            this.pack();
            this.setProperSize();
            this.setProperLocation();
        }
    }

    private void setupButtons() {
        this.panButtons.add(this.butOK);
        this.panButtons.add(this.butAdvanced);
        this.panButtons.add(this.butSave);
        this.panButtons.add(this.butLoad);
    }

    private void createComponents() {
        this.butOK = new JButton(Messages.getString("Okay"));
        this.butOK.addActionListener(this);
        this.butAdvanced = new JButton(Messages.getString("RandomMapDialog.Advanced"));
        this.butAdvanced.addActionListener(this);
        this.butSave = new JButton(Messages.getString("RandomMapDialog.Save"));
        this.butSave.addActionListener(this);
        this.butLoad = new JButton(Messages.getString("RandomMapDialog.Load"));
        this.butLoad.addActionListener(this);
        this.panButtons = new JPanel();
        this.panButtons.setLayout(new FlowLayout());
        this.panOptions = new JPanel();
        this.gridbag = new GridBagLayout();
        this.panOptions.setLayout(this.gridbag);
        this.labBoardSize = new JLabel(Messages.getString("RandomMapDialog.BoardSize"), 2);
        this.texBoardWidth = new JTextField(2);
        this.texBoardWidth.addFocusListener(this);
        this.texBoardHeight = new JTextField(2);
        this.texBoardHeight.addFocusListener(this);
        this.slBoardSize = new SimpleLine(195);
        this.labElevation = new JLabel(Messages.getString("RandomMapDialog.labElevation"), 2);
        this.choElevation = new JComboBox();
        this.fillChoice(this.choElevation);
        this.slElevation = new SimpleLine(195);
        this.labCliffs = new JLabel(Messages.getString("RandomMapDialog.labCliffs"), 2);
        this.choCliffs = new JComboBox();
        this.fillChoice(this.choCliffs);
        this.slCliffs = new SimpleLine(195);
        this.labWoods = new JLabel(Messages.getString("RandomMapDialog.labWoods"), 2);
        this.choWoods = new JComboBox();
        this.fillChoice(this.choWoods);
        this.slWoods = new SimpleLine(195);
        this.labLakes = new JLabel(Messages.getString("RandomMapDialog.labLakes"), 2);
        this.choLakes = new JComboBox();
        this.fillChoice(this.choLakes);
        this.slLakes = new SimpleLine(195);
        this.labRough = new JLabel(Messages.getString("RandomMapDialog.labRough"), 2);
        this.choRough = new JComboBox();
        this.fillChoice(this.choRough);
        this.slRough = new SimpleLine(195);
        this.labSwamp = new JLabel(Messages.getString("RandomMapDialog.labSwamp"), 2);
        this.choSwamp = new JComboBox();
        this.fillChoice(this.choSwamp);
        this.slSwamp = new SimpleLine(195);
        this.labPavement = new JLabel(Messages.getString("RandomMapDialog.labPavement"), 2);
        this.choPavement = new JComboBox();
        this.fillChoice(this.choPavement);
        this.slPavement = new SimpleLine(195);
        this.labRubble = new JLabel(Messages.getString("RandomMapDialog.labRubble"), 2);
        this.choRubble = new JComboBox();
        this.fillChoice(this.choRubble);
        this.slRubble = new SimpleLine(195);
        this.labFortified = new JLabel(Messages.getString("RandomMapDialog.labFortified"), 2);
        this.choFortified = new JComboBox();
        this.fillChoice(this.choFortified);
        this.slFortified = new SimpleLine(195);
        this.labIce = new JLabel(Messages.getString("RandomMapDialog.labIce"), 2);
        this.choIce = new JComboBox();
        this.fillChoice(this.choIce);
        this.slIce = new SimpleLine(195);
        this.labCraters = new JLabel(Messages.getString("RandomMapDialog.labCraters"), 2);
        this.choCraters = new JComboBox();
        this.fillChoice(this.choCraters);
        this.slCraters = new SimpleLine(195);
        this.labRivers = new JLabel(Messages.getString("RandomMapDialog.labRivers"), 2);
        this.choRivers = new JComboBox();
        this.fillChoice(this.choRivers);
        this.slRivers = new SimpleLine(195);
        this.labRoads = new JLabel(Messages.getString("RandomMapDialog.labRoads"), 2);
        this.choRoads = new JComboBox();
        this.fillChoice(this.choRoads);
        this.slRoads = new SimpleLine(195);
        this.labCity = new JLabel(Messages.getString("RandomMapDialog.labCity"), 2);
        this.choCity = new JComboBox();
        this.choCity.addItem(NONE);
        this.choCity.addItem("HUB");
        this.choCity.addItem("GRID");
        this.choCity.addItem("METRO");
        this.choCity.addItem("TOWN");
        this.slCity = new SimpleLine(195);
        this.labMountain = new JLabel(Messages.getString("RandomMapDialog.labMountain"), 2);
        this.choMountain = new JComboBox();
        this.fillChoice(this.choMountain);
        this.slMountain = new SimpleLine(195);
        this.labTheme = new JLabel(Messages.getString("RandomMapDialog.labTheme"), 2);
        this.texTheme = new JTextField(20);
        this.labHilliness = new JLabel(Messages.getString("RandomMapDialog.labHilliness"), 2);
        this.texHilliness = new JTextField(2);
        this.texHilliness.addFocusListener(this);
        this.labRange = new JLabel(Messages.getString("RandomMapDialog.labRange"), 2);
        this.texRange = new JTextField(2);
        this.texRange.addFocusListener(this);
        this.labProbInvert = new JLabel(Messages.getString("RandomMapDialog.labProbInvert"), 2);
        this.texProbInvert = new JTextField(2);
        this.texProbInvert.addFocusListener(this);
        this.labCliffsAd = new JLabel(Messages.getString("RandomMapDialog.labCliffs"), 2);
        this.texCliffs = new JTextField(2);
        this.texCliffs.addFocusListener(this);
        this.labMountainHeight = new JLabel(Messages.getString("RandomMapDialog.labMountainHeight"), 2);
        this.labMountainWidth = new JLabel(Messages.getString("RandomMapDialog.labMountainWidth"), 2);
        this.labMountainPeaks = new JLabel(Messages.getString("RandomMapDialog.labMountainPeaks"), 2);
        this.labMountainStyle = new JLabel(Messages.getString("RandomMapDialog.labMountainStyle"), 2);
        this.texMountainPeaks = new JTextField(2);
        this.texMountainPeaks.addFocusListener(this);
        this.texMountainHeightMin = new JTextField(2);
        this.texMountainHeightMin.addFocusListener(this);
        this.texMountainHeightMax = new JTextField(2);
        this.texMountainHeightMax.addFocusListener(this);
        this.texMountainWidthMin = new JTextField(2);
        this.texMountainWidthMin.addFocusListener(this);
        this.texMountainWidthMax = new JTextField(2);
        this.texMountainWidthMax.addFocusListener(this);
        this.texMountainStyle = new JTextField(2);
        this.texMountainStyle.addFocusListener(this);
        this.labWaterSpots = new JLabel(Messages.getString("RandomMapDialog.labWaterSpots"), 2);
        this.texMinWaterSpots = new JTextField(2);
        this.texMinWaterSpots.addFocusListener(this);
        this.texMaxWaterSpots = new JTextField(2);
        this.texMaxWaterSpots.addFocusListener(this);
        this.labWaterSize = new JLabel(Messages.getString("RandomMapDialog.labWaterSize"), 2);
        this.texMinWaterSize = new JTextField(2);
        this.texMinWaterSize.addFocusListener(this);
        this.texMaxWaterSize = new JTextField(2);
        this.texMaxWaterSize.addFocusListener(this);
        this.labProbDeep = new JLabel(Messages.getString("RandomMapDialog.labProbDeep"), 2);
        this.texProbDeep = new JTextField(2);
        this.texProbDeep.addFocusListener(this);
        this.labForestSpots = new JLabel(Messages.getString("RandomMapDialog.labForestSpots"), 2);
        this.texMinForestSpots = new JTextField(2);
        this.texMinForestSpots.addFocusListener(this);
        this.texMaxForestSpots = new JTextField(2);
        this.texMaxForestSpots.addFocusListener(this);
        this.labForestSize = new JLabel(Messages.getString("RandomMapDialog.labForestSize"), 2);
        this.texMinForestSize = new JTextField(2);
        this.texMinForestSize.addFocusListener(this);
        this.texMaxForestSize = new JTextField(2);
        this.texMaxForestSize.addFocusListener(this);
        this.labProbHeavy = new JLabel(Messages.getString("RandomMapDialog.labProbHeavy"), 2);
        this.texProbHeavy = new JTextField(2);
        this.texProbHeavy.addFocusListener(this);
        this.labRoughSpots = new JLabel(Messages.getString("RandomMapDialog.labRoughSpots"), 2);
        this.texMinRoughSpots = new JTextField(2);
        this.texMinRoughSpots.addFocusListener(this);
        this.texMaxRoughSpots = new JTextField(2);
        this.texMaxRoughSpots.addFocusListener(this);
        this.labRoughSize = new JLabel(Messages.getString("RandomMapDialog.labRoughSize"), 2);
        this.texMinRoughSize = new JTextField(2);
        this.texMinRoughSize.addFocusListener(this);
        this.texMaxRoughSize = new JTextField(2);
        this.texMaxRoughSize.addFocusListener(this);
        this.labSwampSpots = new JLabel(Messages.getString("RandomMapDialog.labSwampSpots"), 2);
        this.texMinSwampSpots = new JTextField(2);
        this.texMinSwampSpots.addFocusListener(this);
        this.texMaxSwampSpots = new JTextField(2);
        this.texMaxSwampSpots.addFocusListener(this);
        this.labSwampSize = new JLabel(Messages.getString("RandomMapDialog.labSwampSize"), 2);
        this.texMinSwampSize = new JTextField(2);
        this.texMinSwampSize.addFocusListener(this);
        this.texMaxSwampSize = new JTextField(2);
        this.texMaxSwampSize.addFocusListener(this);
        this.labPavementSpots = new JLabel(Messages.getString("RandomMapDialog.labPavementSpots"), 2);
        this.texMinPavementSpots = new JTextField(2);
        this.texMinPavementSpots.addFocusListener(this);
        this.texMaxPavementSpots = new JTextField(2);
        this.texMaxPavementSpots.addFocusListener(this);
        this.labPavementSize = new JLabel(Messages.getString("RandomMapDialog.labPavementSize"), 2);
        this.texMinPavementSize = new JTextField(2);
        this.texMinPavementSize.addFocusListener(this);
        this.texMaxPavementSize = new JTextField(2);
        this.texMaxPavementSize.addFocusListener(this);
        this.labRubbleSpots = new JLabel(Messages.getString("RandomMapDialog.labRubbleSpots"), 2);
        this.texMinRubbleSpots = new JTextField(2);
        this.texMinRubbleSpots.addFocusListener(this);
        this.texMaxRubbleSpots = new JTextField(2);
        this.texMaxRubbleSpots.addFocusListener(this);
        this.labRubbleSize = new JLabel(Messages.getString("RandomMapDialog.labRubbleSize"), 2);
        this.texMinRubbleSize = new JTextField(2);
        this.texMinRubbleSize.addFocusListener(this);
        this.texMaxRubbleSize = new JTextField(2);
        this.texMaxRubbleSize.addFocusListener(this);
        this.labFortifiedSpots = new JLabel(Messages.getString("RandomMapDialog.labFortifiedSpots"), 2);
        this.texMinFortifiedSpots = new JTextField(2);
        this.texMinFortifiedSpots.addFocusListener(this);
        this.texMaxFortifiedSpots = new JTextField(2);
        this.texMaxFortifiedSpots.addFocusListener(this);
        this.labFortifiedSize = new JLabel(Messages.getString("RandomMapDialog.labFortifiedSize"), 2);
        this.texMinFortifiedSize = new JTextField(2);
        this.texMinFortifiedSize.addFocusListener(this);
        this.texMaxFortifiedSize = new JTextField(2);
        this.texMaxFortifiedSize.addFocusListener(this);
        this.labIceSpots = new JLabel(Messages.getString("RandomMapDialog.labIceSpots"), 2);
        this.texMinIceSpots = new JTextField(2);
        this.texMinIceSpots.addFocusListener(this);
        this.texMaxIceSpots = new JTextField(2);
        this.texMaxIceSpots.addFocusListener(this);
        this.labIceSize = new JLabel(Messages.getString("RandomMapDialog.labIceSize"), 2);
        this.texMinIceSize = new JTextField(2);
        this.texMinIceSize.addFocusListener(this);
        this.texMaxIceSize = new JTextField(2);
        this.texMaxIceSize.addFocusListener(this);
        this.labProbRoad = new JLabel(Messages.getString("RandomMapDialog.labProbRoad"), 2);
        this.texProbRoad = new JTextField(2);
        this.texProbRoad.addFocusListener(this);
        this.labProbRiver = new JLabel(Messages.getString("RandomMapDialog.labProbRiver"), 2);
        this.texProbRiver = new JTextField(2);
        this.texProbRiver.addFocusListener(this);
        this.labProbCrater = new JLabel(Messages.getString("RandomMapDialog.labProbCrater"), 2);
        this.texProbCrater = new JTextField(2);
        this.texProbCrater.addFocusListener(this);
        this.labRadius = new JLabel(Messages.getString("RandomMapDialog.labRadius"), 2);
        this.texMinRadius = new JTextField(2);
        this.texMinRadius.addFocusListener(this);
        this.texMaxRadius = new JTextField(2);
        this.texMaxRadius.addFocusListener(this);
        this.labMaxCraters = new JLabel(Messages.getString("RandomMapDialog.labMaxCraters"), 2);
        this.texMaxCraters = new JTextField(2);
        this.texMaxCraters.addFocusListener(this);
        this.texMinCraters = new JTextField(2);
        this.texMinCraters.addFocusListener(this);
        this.labProbDrought = new JLabel(Messages.getString("RandomMapDialog.labProbDrought"), 2);
        this.labProbFire = new JLabel(Messages.getString("RandomMapDialog.labProbFire"), 2);
        this.labProbFreeze = new JLabel(Messages.getString("RandomMapDialog.labProbFreeze"), 2);
        this.labProbFlood = new JLabel(Messages.getString("RandomMapDialog.labProbFlood"), 2);
        this.labFxMod = new JLabel(Messages.getString("RandomMapDialog.labFxMod"), 2);
        this.texProbDrought = new JTextField(2);
        this.texProbFire = new JTextField(2);
        this.texProbFreeze = new JTextField(2);
        this.texProbFlood = new JTextField(2);
        this.texFxMod = new JTextField(2);
        this.labCityBlocks = new JLabel(Messages.getString("RandomMapDialog.labCityBlocks"), 2);
        this.labCityCF = new JLabel(Messages.getString("RandomMapDialog.labCityCF"), 2);
        this.labCityFloors = new JLabel(Messages.getString("RandomMapDialog.labCityFloors"), 2);
        this.labCityDensity = new JLabel(Messages.getString("RandomMapDialog.labCityDensity"), 2);
        this.labTownSize = new JLabel(Messages.getString("RandomMapDialog.labTownSize"), 2);
        this.texCityBlocks = new JTextField(2);
        this.texCityMinCF = new JTextField(2);
        this.texCityMaxCF = new JTextField(2);
        this.texCityMinFloors = new JTextField(2);
        this.texCityMaxFloors = new JTextField(2);
        this.texCityDensity = new JTextField(2);
        this.texTownSize = new JTextField(2);
        this.labInvertNegative = new JLabel(Messages.getString("RandomMapDialog.labInvertNegative"), 2);
        this.texInvertNegative = new JTextField(1);
        this.labAlgorithmToUse = new JLabel(Messages.getString("RandomMapDialog.labAlgorithmToUse"), 2);
        this.texAlgorithmToUse = new JTextField(2);
        this.slElevationAd = new SimpleLine(295);
        this.slWoodsAd = new SimpleLine(295);
        this.slLakesAd = new SimpleLine(295);
        this.slPavementAd = new SimpleLine(295);
        this.slRubbleAd = new SimpleLine(295);
        this.slFortifiedAd = new SimpleLine(295);
        this.slIceAd = new SimpleLine(295);
        this.slRoughAd = new SimpleLine(295);
        this.slRoadsAd = new SimpleLine(295);
        this.slRiversAd = new SimpleLine(295);
        this.slSwampAd = new SimpleLine(295);
        this.slBoardSizeAd = new SimpleLine(295);
        this.slCratersAd = new SimpleLine(295);
        this.slCityAd = new SimpleLine(295);
        this.slInvertNegativeAd = new SimpleLine(295);
    }

    private void addOption(JLabel jLabel, JComboBox jComboBox, SimpleLine simpleLine) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(jComboBox, gridBagConstraints);
        this.panOptions.add(jComboBox);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.gridbag.setConstraints(simpleLine, gridBagConstraints);
        this.panOptions.add(simpleLine);
    }

    private void fillChoice(JComboBox jComboBox) {
        jComboBox.addItem(NONE);
        jComboBox.addItem(LOW);
        jComboBox.addItem(MEDIUM);
        jComboBox.addItem(HIGH);
    }

    private void addLabelTextField(JLabel jLabel, JTextField jTextField) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(jTextField, gridBagConstraints);
        this.panOptions.add(jTextField);
    }

    private void addLabelTextField(JLabel jLabel, JTextField jTextField, JTextField jTextField2, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(jTextField, gridBagConstraints);
        this.panOptions.add(jTextField);
        JLabel jLabel2 = new JLabel(string, 0);
        this.gridbag.setConstraints(jLabel2, gridBagConstraints);
        this.panOptions.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        this.gridbag.setConstraints(jTextField2, gridBagConstraints);
        this.panOptions.add(jTextField2);
    }

    private void addSeparator(SimpleLine simpleLine) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.gridbag.setConstraints(simpleLine, gridBagConstraints);
        this.panOptions.add(simpleLine);
    }

    private void loadValues() {
        this.texBoardWidth.setText(Integer.toString(this.mapSettings.getBoardWidth()));
        this.texBoardHeight.setText(Integer.toString(this.mapSettings.getBoardHeight()));
        this.texTheme.setText(this.mapSettings.getTheme());
        this.texHilliness.setText(Integer.toString(this.mapSettings.getHilliness()));
        this.texRange.setText(Integer.toString(this.mapSettings.getRange()));
        this.texProbInvert.setText(Integer.toString(this.mapSettings.getProbInvert()));
        this.texCliffs.setText(Integer.toString(this.mapSettings.getCliffs()));
        this.texMinWaterSpots.setText(Integer.toString(this.mapSettings.getMinWaterSpots()));
        this.texMaxWaterSpots.setText(Integer.toString(this.mapSettings.getMaxWaterSpots()));
        this.texMinWaterSize.setText(Integer.toString(this.mapSettings.getMinWaterSize()));
        this.texMaxWaterSize.setText(Integer.toString(this.mapSettings.getMaxWaterSize()));
        this.texMinForestSpots.setText(Integer.toString(this.mapSettings.getMinForestSpots()));
        this.texMaxForestSpots.setText(Integer.toString(this.mapSettings.getMaxForestSpots()));
        this.texMinForestSize.setText(Integer.toString(this.mapSettings.getMinForestSize()));
        this.texMaxForestSize.setText(Integer.toString(this.mapSettings.getMaxForestSize()));
        this.texMinRoughSpots.setText(Integer.toString(this.mapSettings.getMinRoughSpots()));
        this.texMaxRoughSpots.setText(Integer.toString(this.mapSettings.getMaxRoughSpots()));
        this.texMinRoughSize.setText(Integer.toString(this.mapSettings.getMinRoughSize()));
        this.texMaxRoughSize.setText(Integer.toString(this.mapSettings.getMaxRoughSize()));
        this.texMinSwampSpots.setText(Integer.toString(this.mapSettings.getMinSwampSpots()));
        this.texMaxSwampSpots.setText(Integer.toString(this.mapSettings.getMaxSwampSpots()));
        this.texMinSwampSize.setText(Integer.toString(this.mapSettings.getMinSwampSize()));
        this.texMaxSwampSize.setText(Integer.toString(this.mapSettings.getMaxSwampSize()));
        this.texMinPavementSpots.setText(Integer.toString(this.mapSettings.getMinPavementSpots()));
        this.texMaxPavementSpots.setText(Integer.toString(this.mapSettings.getMaxPavementSpots()));
        this.texMinPavementSize.setText(Integer.toString(this.mapSettings.getMinPavementSize()));
        this.texMaxPavementSize.setText(Integer.toString(this.mapSettings.getMaxPavementSize()));
        this.texMinRubbleSpots.setText(Integer.toString(this.mapSettings.getMinRubbleSpots()));
        this.texMaxRubbleSpots.setText(Integer.toString(this.mapSettings.getMaxRubbleSpots()));
        this.texMinRubbleSize.setText(Integer.toString(this.mapSettings.getMinRubbleSize()));
        this.texMaxRubbleSize.setText(Integer.toString(this.mapSettings.getMaxRubbleSize()));
        this.texMinFortifiedSpots.setText(Integer.toString(this.mapSettings.getMinFortifiedSpots()));
        this.texMaxFortifiedSpots.setText(Integer.toString(this.mapSettings.getMaxFortifiedSpots()));
        this.texMinFortifiedSize.setText(Integer.toString(this.mapSettings.getMinFortifiedSize()));
        this.texMaxFortifiedSize.setText(Integer.toString(this.mapSettings.getMaxFortifiedSize()));
        this.texMinIceSpots.setText(Integer.toString(this.mapSettings.getMinIceSpots()));
        this.texMaxIceSpots.setText(Integer.toString(this.mapSettings.getMaxIceSpots()));
        this.texMinIceSize.setText(Integer.toString(this.mapSettings.getMinIceSize()));
        this.texMaxIceSize.setText(Integer.toString(this.mapSettings.getMaxIceSize()));
        this.texProbDeep.setText(Integer.toString(this.mapSettings.getProbDeep()));
        this.texProbHeavy.setText(Integer.toString(this.mapSettings.getProbHeavy()));
        this.texProbRiver.setText(Integer.toString(this.mapSettings.getProbRiver()));
        this.texProbRoad.setText(Integer.toString(this.mapSettings.getProbRoad()));
        this.texProbCrater.setText(Integer.toString(this.mapSettings.getProbCrater()));
        this.texMinRadius.setText(Integer.toString(this.mapSettings.getMinRadius()));
        this.texMaxRadius.setText(Integer.toString(this.mapSettings.getMaxRadius()));
        this.texMaxCraters.setText(Integer.toString(this.mapSettings.getMaxCraters()));
        this.texMinCraters.setText(Integer.toString(this.mapSettings.getMinCraters()));
        this.texProbDrought.setText(Integer.toString(this.mapSettings.getProbDrought()));
        this.texProbFire.setText(Integer.toString(this.mapSettings.getProbForestFire()));
        this.texProbFreeze.setText(Integer.toString(this.mapSettings.getProbFreeze()));
        this.texProbFlood.setText(Integer.toString(this.mapSettings.getProbFlood()));
        this.texFxMod.setText(Integer.toString(this.mapSettings.getFxMod()));
        this.choCity.setSelectedItem(this.mapSettings.getCityType());
        this.texInvertNegative.setText(Integer.toString(this.mapSettings.getInvertNegativeTerrain()));
        this.texCityBlocks.setText(Integer.toString(this.mapSettings.getCityBlocks()));
        this.texCityMinCF.setText(Integer.toString(this.mapSettings.getCityMinCF()));
        this.texCityMaxCF.setText(Integer.toString(this.mapSettings.getCityMaxCF()));
        this.texCityMinFloors.setText(Integer.toString(this.mapSettings.getCityMinFloors()));
        this.texCityMaxFloors.setText(Integer.toString(this.mapSettings.getCityMaxFloors()));
        this.texCityDensity.setText(Integer.toString(this.mapSettings.getCityDensity()));
        this.texTownSize.setText(Integer.toString(this.mapSettings.getTownSize()));
        this.texMountainPeaks.setText(Integer.toString(this.mapSettings.getMountainPeaks()));
        this.texMountainStyle.setText(Integer.toString(this.mapSettings.getMountainStyle()));
        this.texMountainHeightMin.setText(Integer.toString(this.mapSettings.getMountainHeightMin()));
        this.texMountainHeightMax.setText(Integer.toString(this.mapSettings.getMountainHeightMax()));
        this.texMountainWidthMin.setText(Integer.toString(this.mapSettings.getMountainHeightMin()));
        this.texMountainWidthMax.setText(Integer.toString(this.mapSettings.getMountainHeightMax()));
        this.texAlgorithmToUse.setText(Integer.toString(this.mapSettings.getAlgorithmToUse()));
    }

    private boolean applyValues() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        int n33;
        int n34;
        int n35;
        int n36;
        int n37;
        int n38;
        int n39;
        int n40;
        int n41;
        int n42;
        int n43;
        int n44;
        int n45;
        int n46;
        int n47;
        int n48;
        int n49;
        int n50;
        int n51;
        int n52;
        int n53;
        int n54;
        int n55;
        int n56;
        int n57;
        int n58;
        int n59;
        String string = "";
        int n60 = 4;
        int n61 = 10;
        int n62 = 100;
        int n63 = 1;
        int n64 = 6;
        int n65 = 75;
        int n66 = 60;
        int n67 = 0;
        try {
            n59 = Integer.parseInt(this.texBoardWidth.getText());
            n58 = Integer.parseInt(this.texBoardHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.OnlyIntegersWarn"), INVALID_SETTING, 0);
            return false;
        }
        if (n58 <= 0 || n58 <= 0) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.BoardSizeWarn"), INVALID_SETTING, 0);
            return false;
        }
        string = this.texTheme.getText();
        if (this.advanced) {
            try {
                n57 = Integer.parseInt(this.texHilliness.getText());
                n56 = Integer.parseInt(this.texRange.getText());
                n55 = Integer.parseInt(this.texCliffs.getText());
                n54 = Integer.parseInt(this.texProbInvert.getText());
                n53 = Integer.parseInt(this.texMinWaterSpots.getText());
                n52 = Integer.parseInt(this.texMaxWaterSpots.getText());
                n51 = Integer.parseInt(this.texMinWaterSize.getText());
                n50 = Integer.parseInt(this.texMaxWaterSize.getText());
                n49 = Integer.parseInt(this.texMinForestSpots.getText());
                n48 = Integer.parseInt(this.texMaxForestSpots.getText());
                n47 = Integer.parseInt(this.texMinForestSize.getText());
                n46 = Integer.parseInt(this.texMaxForestSize.getText());
                n45 = Integer.parseInt(this.texMinRoughSpots.getText());
                n44 = Integer.parseInt(this.texMaxRoughSpots.getText());
                n43 = Integer.parseInt(this.texMinRoughSize.getText());
                n42 = Integer.parseInt(this.texMaxRoughSize.getText());
                n41 = Integer.parseInt(this.texMinSwampSpots.getText());
                n40 = Integer.parseInt(this.texMaxSwampSpots.getText());
                n39 = Integer.parseInt(this.texMinSwampSize.getText());
                n38 = Integer.parseInt(this.texMaxSwampSize.getText());
                n37 = Integer.parseInt(this.texMinPavementSpots.getText());
                n36 = Integer.parseInt(this.texMaxPavementSpots.getText());
                n35 = Integer.parseInt(this.texMinPavementSize.getText());
                n34 = Integer.parseInt(this.texMaxPavementSize.getText());
                n33 = Integer.parseInt(this.texMinRubbleSpots.getText());
                n32 = Integer.parseInt(this.texMaxRubbleSpots.getText());
                n31 = Integer.parseInt(this.texMinRubbleSize.getText());
                n30 = Integer.parseInt(this.texMaxRubbleSize.getText());
                n29 = Integer.parseInt(this.texMinFortifiedSpots.getText());
                n28 = Integer.parseInt(this.texMaxFortifiedSpots.getText());
                n27 = Integer.parseInt(this.texMinFortifiedSize.getText());
                n26 = Integer.parseInt(this.texMaxFortifiedSize.getText());
                n25 = Integer.parseInt(this.texMinIceSpots.getText());
                n24 = Integer.parseInt(this.texMaxIceSpots.getText());
                n23 = Integer.parseInt(this.texMinIceSize.getText());
                n22 = Integer.parseInt(this.texMaxIceSize.getText());
                n21 = Integer.parseInt(this.texProbRoad.getText());
                n20 = Integer.parseInt(this.texProbRiver.getText());
                n19 = Integer.parseInt(this.texProbHeavy.getText());
                n18 = Integer.parseInt(this.texProbDeep.getText());
                n17 = Integer.parseInt(this.texProbCrater.getText());
                n16 = Integer.parseInt(this.texMinRadius.getText());
                n15 = Integer.parseInt(this.texMaxRadius.getText());
                n14 = Integer.parseInt(this.texMaxCraters.getText());
                n13 = Integer.parseInt(this.texMinCraters.getText());
                n12 = Integer.parseInt(this.texAlgorithmToUse.getText());
                n11 = Integer.parseInt(this.texProbDrought.getText());
                n10 = Integer.parseInt(this.texProbFire.getText());
                n9 = Integer.parseInt(this.texProbFreeze.getText());
                n8 = Integer.parseInt(this.texProbFlood.getText());
                n7 = Integer.parseInt(this.texFxMod.getText());
                n60 = Integer.parseInt(this.texCityBlocks.getText());
                n61 = Integer.parseInt(this.texCityMinCF.getText());
                n62 = Integer.parseInt(this.texCityMaxCF.getText());
                n63 = Integer.parseInt(this.texCityMinFloors.getText());
                n64 = Integer.parseInt(this.texCityMaxFloors.getText());
                n65 = Integer.parseInt(this.texCityDensity.getText());
                n6 = Integer.parseInt(this.texMountainHeightMin.getText());
                n5 = Integer.parseInt(this.texMountainHeightMax.getText());
                n4 = Integer.parseInt(this.texMountainWidthMin.getText());
                n3 = Integer.parseInt(this.texMountainWidthMax.getText());
                n2 = Integer.parseInt(this.texMountainStyle.getText());
                n = Integer.parseInt(this.texMountainPeaks.getText());
                n67 = Integer.parseInt(this.texInvertNegative.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.OnlyIntegersWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n57 < 0 || n57 > 99) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.AmmountOfElevationWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n55 < 0 || n55 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.CliffsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n56 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.elevRangeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n54 < 0 || n54 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.depressionWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n53 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinLakesWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n52 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxLakesWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n52 < n53) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxLakesWarn2"), INVALID_SETTING, 0);
                return false;
            }
            if (n51 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinLakeSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n50 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxLakeSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n50 < n51) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxLakeSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n18 < 0 || n18 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.DeepWaterProbWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n49 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinForestsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n48 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxForestsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n48 < n49) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxForestsWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n47 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinForestSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n46 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxForestSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n46 < n47) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxForestSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n19 < 0 || n19 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.HeavyForestProbWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n45 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinRoughsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n44 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRoughsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n44 < n45) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRoughsWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n43 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinRoughSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n42 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRoughSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n42 < n43) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRoughSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n41 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinSwampsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n40 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxSwampsWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n40 < n41) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxSwampsWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n39 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinSwampSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n38 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxSwampSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n38 < n39) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxSwampSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n37 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinPavementWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n36 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxPavementWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n36 < n37) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxPavementWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n35 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinPavementSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n34 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxPavementSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n34 < n35) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxPavementSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n33 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinRubbleWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n32 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRubbleWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n32 < n33) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRubbleWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n31 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinRubbleSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n30 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRubbleSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n30 < n31) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxRubbleSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n29 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinFortifiedWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n28 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxFortifiedWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n28 < n29) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxFortifiedWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n27 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinFortifiedSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n26 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxFortifiedSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n26 < n27) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxFortifiedSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n25 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinIceWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n24 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxIceWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n24 < n25) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxIceWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n23 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinIceSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n22 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxIceSizeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n22 < n23) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxIceSizeWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n20 < 0 || n20 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.RiverProbWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n21 < 0 || n21 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.RoadProbWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n17 < 0 || n17 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.CratersProbWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n16 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinCraterRadiusWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n15 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxCraterRadiusWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n15 < n16) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxCraterRadiusWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n14 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxCratersWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n13 < 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MinCratersWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n14 < n13) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MaxCratersWarn1"), INVALID_SETTING, 0);
                return false;
            }
            if (n12 < 0 || n12 > 2) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.AlgorithmWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n61 < 1 || n62 > 150) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.CFOutOfRangeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n63 < 1 || n64 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.FloorsOutOfRangeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if (n65 < 1 || n65 > 100) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.DensityOutOfRangeWarn"), INVALID_SETTING, 0);
                return false;
            }
            if ((n4 < 1 || n3 < n4) && n > 0) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("RandomMapDialog.MountainWidthOutOfRange"), INVALID_SETTING, 0);
            }
        } else {
            String string2 = (String)this.choElevation.getSelectedItem();
            if (string2.equals(NONE)) {
                n57 = 0;
                n56 = 0;
            } else if (string2.equals(LOW)) {
                n57 = 25;
                n56 = 3;
            } else if (string2.equals(MEDIUM)) {
                n57 = 50;
                n56 = 5;
            } else {
                n57 = 75;
                n56 = 8;
            }
            string2 = (String)this.choCliffs.getSelectedItem();
            n55 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = (String)this.choWoods.getSelectedItem();
            if (string2.equals(NONE)) {
                n47 = 0;
                n46 = 0;
                n49 = 0;
                n48 = 0;
                n19 = 0;
            } else if (string2.equals(LOW)) {
                n47 = 3;
                n46 = 6;
                n49 = 3;
                n48 = 6;
                n19 = 20;
            } else if (string2.equals(MEDIUM)) {
                n47 = 3;
                n46 = 10;
                n49 = 4;
                n48 = 8;
                n19 = 30;
            } else {
                n47 = 8;
                n46 = 13;
                n49 = 6;
                n48 = 10;
                n19 = 45;
            }
            string2 = (String)this.choLakes.getSelectedItem();
            if (string2.equals(NONE)) {
                n51 = 0;
                n50 = 0;
                n53 = 0;
                n52 = 0;
                n18 = 0;
            } else if (string2.equals(LOW)) {
                n51 = 1;
                n50 = 5;
                n53 = 1;
                n52 = 5;
                n18 = 20;
            } else if (string2.equals(MEDIUM)) {
                n51 = 6;
                n50 = 10;
                n53 = 2;
                n52 = 5;
                n18 = 30;
            } else {
                n51 = 8;
                n50 = 15;
                n53 = 3;
                n52 = 6;
                n18 = 45;
            }
            string2 = (String)this.choRough.getSelectedItem();
            if (string2.equals(NONE)) {
                n43 = 0;
                n42 = 0;
                n45 = 0;
                n44 = 0;
            } else if (string2.equals(LOW)) {
                n43 = 1;
                n42 = 2;
                n45 = 2;
                n44 = 6;
            } else if (string2.equals(MEDIUM)) {
                n43 = 2;
                n42 = 5;
                n45 = 3;
                n44 = 8;
            } else {
                n43 = 3;
                n42 = 7;
                n45 = 5;
                n44 = 10;
            }
            string2 = (String)this.choSwamp.getSelectedItem();
            if (string2.equals(NONE)) {
                n39 = 0;
                n38 = 0;
                n41 = 0;
                n40 = 0;
            } else if (string2.equals(LOW)) {
                n39 = 1;
                n38 = 2;
                n41 = 2;
                n40 = 6;
            } else if (string2.equals(MEDIUM)) {
                n39 = 2;
                n38 = 5;
                n41 = 3;
                n40 = 8;
            } else {
                n39 = 3;
                n38 = 7;
                n41 = 5;
                n40 = 10;
            }
            string2 = (String)this.choPavement.getSelectedItem();
            if (string2.equals(NONE)) {
                n35 = 0;
                n34 = 0;
                n37 = 0;
                n36 = 0;
            } else if (string2.equals(LOW)) {
                n35 = 1;
                n34 = 2;
                n37 = 2;
                n36 = 6;
            } else if (string2.equals(MEDIUM)) {
                n35 = 2;
                n34 = 5;
                n37 = 3;
                n36 = 8;
            } else {
                n35 = 3;
                n34 = 7;
                n37 = 5;
                n36 = 10;
            }
            string2 = (String)this.choRubble.getSelectedItem();
            if (string2.equals(NONE)) {
                n31 = 0;
                n30 = 0;
                n33 = 0;
                n32 = 0;
            } else if (string2.equals(LOW)) {
                n31 = 1;
                n30 = 2;
                n33 = 2;
                n32 = 6;
            } else if (string2.equals(MEDIUM)) {
                n31 = 2;
                n30 = 5;
                n33 = 3;
                n32 = 8;
            } else {
                n31 = 3;
                n30 = 7;
                n33 = 5;
                n32 = 10;
            }
            string2 = (String)this.choFortified.getSelectedItem();
            if (string2.equals(NONE)) {
                n27 = 0;
                n26 = 0;
                n29 = 0;
                n28 = 0;
            } else if (string2.equals(LOW)) {
                n27 = 1;
                n26 = 2;
                n29 = 1;
                n28 = 2;
            } else if (string2.equals(MEDIUM)) {
                n27 = 2;
                n26 = 3;
                n29 = 2;
                n28 = 4;
            } else {
                n27 = 2;
                n26 = 4;
                n29 = 3;
                n28 = 6;
            }
            string2 = (String)this.choIce.getSelectedItem();
            if (string2.equals(NONE)) {
                n23 = 0;
                n22 = 0;
                n25 = 0;
                n24 = 0;
            } else if (string2.equals(LOW)) {
                n23 = 1;
                n22 = 2;
                n25 = 2;
                n24 = 6;
            } else if (string2.equals(MEDIUM)) {
                n23 = 2;
                n22 = 5;
                n25 = 3;
                n24 = 8;
            } else {
                n23 = 3;
                n22 = 7;
                n25 = 5;
                n24 = 10;
            }
            string2 = (String)this.choRoads.getSelectedItem();
            n21 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = (String)this.choRivers.getSelectedItem();
            n20 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = (String)this.choCraters.getSelectedItem();
            if (string2.equals(NONE)) {
                n17 = 0;
                n16 = 0;
                n15 = 0;
                n13 = 0;
                n14 = 0;
            } else if (string2.equals(LOW)) {
                n17 = 25;
                n16 = 1;
                n15 = 3;
                n13 = 1;
                n14 = 3;
            } else if (string2.equals(MEDIUM)) {
                n17 = 50;
                n16 = 1;
                n15 = 5;
                n13 = 3;
                n14 = 8;
            } else {
                n17 = 75;
                n16 = 3;
                n15 = 9;
                n13 = 6;
                n14 = 14;
            }
            string2 = (String)this.choMountain.getSelectedItem();
            if (string2.equals(NONE)) {
                n = 0;
                n6 = 4;
                n5 = 6;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else if (string2.equals(LOW)) {
                n = 1;
                n6 = 4;
                n5 = 6;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else if (string2.equals(MEDIUM)) {
                n = 2;
                n6 = 6;
                n5 = 8;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else {
                n = 3;
                n6 = 8;
                n5 = 10;
                n4 = 9;
                n3 = 14;
                n2 = 4;
            }
            n60 = 16;
            n61 = 10;
            n62 = 100;
            n63 = 1;
            n64 = 6;
            n65 = 75;
            n66 = 60;
            n12 = 0;
            n54 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
            n10 = 0;
            n11 = 0;
        }
        String string3 = (String)this.choCity.getSelectedItem();
        if (!this.advanced && string3.equals("TOWN")) {
            n60 = 3;
            n62 = 50;
            n64 = 3;
        }
        this.mapSettings.setBoardSize(n59, n58);
        this.mapSettings.setElevationParams(n57, n56, n54);
        this.mapSettings.setCliffParam(n55);
        this.mapSettings.setWaterParams(n53, n52, n51, n50, n18);
        this.mapSettings.setForestParams(n49, n48, n47, n46, n19);
        this.mapSettings.setRoughParams(n45, n44, n43, n42);
        this.mapSettings.setSwampParams(n41, n40, n39, n38);
        this.mapSettings.setPavementParams(n37, n36, n35, n34);
        this.mapSettings.setRubbleParams(n33, n32, n31, n30);
        this.mapSettings.setFortifiedParams(n29, n28, n27, n26);
        this.mapSettings.setIceParams(n25, n24, n23, n22);
        this.mapSettings.setRiverParam(n20);
        this.mapSettings.setRoadParam(n21);
        this.mapSettings.setCraterParam(n17, n13, n14, n16, n15);
        this.mapSettings.setSpecialFX(n7, n10, n9, n8, n11);
        this.mapSettings.setAlgorithmToUse(n12);
        this.mapSettings.setCityParams(n60, string3, n61, n62, n63, n64, n65, n66);
        this.mapSettings.setMountainParams(n, n4, n3, n6, n5, n2);
        this.mapSettings.setInvertNegativeTerrain(n67);
        this.mapSettings.setTheme(string);
        if (!this.advanced) {
            this.loadValues();
        }
        this.bsd.updateMapSettings(this.mapSettings);
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.select(0, 0);
        }
    }

    public void setMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
        this.loadValues();
    }

    private void setProperSize() {
        this.validate();
        this.pack();
        Dimension dimension = this.panOptions.getPreferredSize();
        Dimension dimension2 = this.panButtons.getPreferredSize();
        int n = Math.min(dimension.width + dimension2.width + 50, this.getParent().getSize().width);
        int n2 = Math.min(dimension.height + dimension2.height + 50, this.getParent().getSize().height);
        this.setSize(n, n2);
    }

    private void setProperLocation() {
        int n = (this.getParent().getSize().width - this.getSize().width) / 2;
        int n2 = (this.getParent().getSize().height - this.getSize().height) / 2;
        this.setLocation(n, n2);
    }
}

