/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.SingleChoiceDialog;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.actions.TriggerBPodAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerBPodDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5882060083607984056L;
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JTextArea labMessage;
    private ArrayList<TriggerPodTracker> trackers = new ArrayList();
    private int entityId = -1;
    private ClientGUI clientgui;

    public TriggerBPodDialog(ClientGUI clientGUI, Entity entity, String string) {
        super(clientGUI.frame, Messages.getString("TriggerBPodDialog.title"), true);
        Serializable serializable;
        this.entityId = entity.getId();
        this.clientgui = clientGUI;
        this.labMessage = new JTextArea(Messages.getString("TriggerBPodDialog.selectPodsToTrigger", new Object[]{entity.getDisplayName()}));
        this.labMessage.setEditable(false);
        this.labMessage.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        for (Mounted serializable22 : entity.getWeaponList()) {
            if (!serializable22.getType().hasFlag(0x1000000000L)) continue;
            serializable = new StringBuffer();
            serializable.append(entity.getLocationName(serializable22.getLocation())).append(' ').append(serializable22.getName());
            JCheckBox bl = new JCheckBox(serializable.toString());
            jPanel.add(bl);
            if (serializable22.canFire()) {
                if (string.equals("LegAttack") && serializable22.getLocation() != 1 && serializable22.getLocation() != 7 && serializable22.getLocation() != 6) {
                    if (entity instanceof QuadMech) {
                        if (serializable22.getLocation() == 5 && serializable22.getLocation() == 4) continue;
                        bl.setEnabled(false);
                        continue;
                    }
                    bl.setEnabled(false);
                    continue;
                }
                if (string.equals("SwarmMek") && (serializable22.isRearMounted() || serializable22.getLocation() == 1 || serializable22.getLocation() == 7 || serializable22.getLocation() == 6)) {
                    bl.setEnabled(false);
                    continue;
                }
                TriggerPodTracker triggerPodTracker = new TriggerPodTracker(bl, entity.getEquipmentNum(serializable22));
                this.trackers.add(triggerPodTracker);
                continue;
            }
            bl.setEnabled(false);
        }
        this.butOkay.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labMessage, gridBagConstraints);
        this.getContentPane().add(this.labMessage);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.getContentPane().add(this.butOkay);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TriggerBPodDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setResizable(false);
        this.setLocation(clientGUI.frame.getLocation().x + clientGUI.frame.getSize().width / 2 - ((Dimension)serializable).width / 2, clientGUI.frame.getLocation().y + clientGUI.frame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public Enumeration<TriggerBPodAction> getActions() {
        Vector<TriggerBPodAction> vector = new Vector<TriggerBPodAction>();
        for (TriggerPodTracker triggerPodTracker : this.trackers) {
            if (!triggerPodTracker.isTriggered()) continue;
            vector.addElement(new TriggerBPodAction(this.entityId, triggerPodTracker.getNum(), this.chooseTarget(this.clientgui.client.game.getEntity(this.entityId).getPosition())));
        }
        return vector.elements();
    }

    private Entity chooseTarget(Coords coords) {
        Entity entity = null;
        Enumeration<Entity> enumeration = this.clientgui.client.game.getEntities(coords);
        Vector<Entity> vector = new Vector<Entity>();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (this.clientgui.client.game.getEntity(this.entityId).equals(entity) || !(entity instanceof Infantry)) continue;
            vector.addElement(entity);
        }
        if (vector.size() == 1) {
            entity = (Entity)vector.elementAt(0);
        } else if (vector.size() > 1) {
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Entity)vector.elementAt(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("TriggerBPodDialog.ChooseTargetDialog.title"), Messages.getString("TriggerBPodDialog.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()}), stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                entity = (Entity)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return entity;
    }

    private class TriggerPodTracker {
        private int podNum = -1;
        private JCheckBox checkbox;

        public TriggerPodTracker(JCheckBox jCheckBox, int n) {
            this.podNum = n;
            this.checkbox = jCheckBox;
        }

        public boolean isTriggered() {
            return this.checkbox.isSelected();
        }

        public int getNum() {
            return this.podNum;
        }
    }
}

