/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import megamek.client.ui.swing.widget.PMGenericHotArea;

public class PMPicPolygonalArea
extends PMGenericHotArea {
    private Image idleImage;
    private Image activeImage;
    private boolean highlight = true;
    private Polygon areaShape;
    private boolean selected = false;
    private boolean visible = true;

    public PMPicPolygonalArea(Polygon polygon, Image image, Image image2) {
        this.areaShape = polygon;
        this.idleImage = image;
        this.activeImage = image2;
    }

    public PMPicPolygonalArea(Polygon polygon, Image image) {
        this(polygon, image, null);
        this.highlight = false;
    }

    public PMPicPolygonalArea(Polygon polygon, Image image, boolean bl) {
        this(polygon, image, null);
        this.highlight = bl;
    }

    public void setIdleImage(Image image) {
        this.idleImage = image;
    }

    public Image getIdleImage() {
        return this.idleImage;
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image image) {
        this.activeImage = image;
        this.highlight = this.activeImage != null;
    }

    public void translate(int n, int n2) {
        this.areaShape.translate(n, n2);
    }

    public Rectangle getBounds() {
        return this.areaShape.getBounds();
    }

    public void drawInto(Graphics graphics) {
        if (graphics == null || !this.visible) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        if (this.selected) {
            graphics.drawImage(this.activeImage, rectangle.x, rectangle.y, null);
        } else {
            graphics.drawImage(this.idleImage, rectangle.x, rectangle.y, null);
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Shape getAreaShape() {
        return this.areaShape;
    }

    public void onMouseOver(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = true;
        }
        super.onMouseOver(mouseEvent);
    }

    public void onMouseExit(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = false;
        }
        super.onMouseExit(mouseEvent);
    }
}

