/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmmoType
extends EquipmentType {
    public static final int T_NA = -1;
    public static final int T_AC = 1;
    public static final int T_VEHICLE_FLAMER = 2;
    public static final int T_MG = 3;
    public static final int T_MG_HEAVY = 4;
    public static final int T_MG_LIGHT = 5;
    public static final int T_GAUSS = 6;
    public static final int T_LRM = 7;
    public static final int T_LRM_TORPEDO = 8;
    public static final int T_SRM = 9;
    public static final int T_SRM_TORPEDO = 10;
    public static final int T_SRM_STREAK = 11;
    public static final int T_MRM = 12;
    public static final int T_NARC = 13;
    public static final int T_AMS = 14;
    public static final int T_ARROW_IV = 15;
    public static final int T_LONG_TOM = 16;
    public static final int T_SNIPER = 17;
    public static final int T_THUMPER = 18;
    public static final int T_AC_LBX = 19;
    public static final int T_AC_ULTRA = 20;
    public static final int T_GAUSS_LIGHT = 21;
    public static final int T_GAUSS_HEAVY = 22;
    public static final int T_AC_ROTARY = 23;
    public static final int T_SRM_ADVANCED = 24;
    public static final int T_BA_MICRO_BOMB = 25;
    public static final int T_LRM_TORPEDO_COMBO = 26;
    public static final int T_MINE = 27;
    public static final int T_ATM = 28;
    public static final int T_ROCKET_LAUNCHER = 29;
    public static final int T_INARC = 30;
    public static final int T_LRM_STREAK = 31;
    public static final int T_AC_LBX_THB = 32;
    public static final int T_AC_ULTRA_THB = 33;
    public static final int T_LAC = 34;
    public static final int T_HEAVY_FLAMER = 35;
    public static final int T_COOLANT_POD = 36;
    public static final int T_EXLRM = 37;
    public static final int T_APGAUSS = 38;
    public static final int T_MAGSHOT = 39;
    public static final int T_PXLRM = 40;
    public static final int T_HSRM = 41;
    public static final int T_MRM_STREAK = 42;
    public static final int T_MPOD = 43;
    public static final int T_HAG = 44;
    public static final int T_MML = 45;
    public static final int T_PLASMA = 46;
    public static final int T_SBGAUSS = 47;
    public static final int T_RAIL_GUN = 48;
    public static final int T_TBOLT_5 = 49;
    public static final int T_TBOLT_10 = 50;
    public static final int T_TBOLT_15 = 51;
    public static final int T_TBOLT_20 = 52;
    public static final int T_NAC = 53;
    public static final int T_LIGHT_NGAUSS = 54;
    public static final int T_MED_NGAUSS = 55;
    public static final int T_HEAVY_NGAUSS = 56;
    public static final int T_KILLER_WHALE = 57;
    public static final int T_WHITE_SHARK = 58;
    public static final int T_BARRACUDA = 59;
    public static final int T_KRAKEN_T = 60;
    public static final int T_AR10 = 61;
    public static final int T_SCREEN_LAUNCHER = 62;
    public static final int T_ALAMO = 63;
    public static final int T_IGAUSS_HEAVY = 64;
    public static final int T_CHEMICAL_LASER = 65;
    public static final int T_HYPER_VELOCITY = 66;
    public static final int T_MEK_MORTAR = 67;
    public static final int T_CRUISE_MISSILE = 68;
    public static final int T_BPOD = 69;
    public static final int T_SCC = 70;
    public static final int T_MANTA_RAY = 71;
    public static final int T_SWORDFISH = 72;
    public static final int T_STINGRAY = 73;
    public static final int T_PIRANHA = 74;
    public static final int T_TASER = 75;
    public static final int NUM_TYPES = 76;
    public static final long F_MG = 1L;
    public static final long F_BATTLEARMOR = 2L;
    public static final long F_PROTOMECH = 4L;
    public static final long F_HOTLOAD = 8L;
    public static final long F_ENCUMBERING = 16L;
    public static final long F_MML_LRM = 32L;
    public static final long F_AR10_WHITE_SHARK = 64L;
    public static final long F_AR10_KILLER_WHALE = 128L;
    public static final long F_AR10_BARRACUDA = 256L;
    public static final long F_NUCLEAR = 512L;
    public static final long F_TELE_MISSILE = 1024L;
    public static final long M_STANDARD = 0L;
    public static final long M_CLUSTER = 1L;
    public static final long M_ARMOR_PIERCING = 2L;
    public static final long M_FLECHETTE = 4L;
    public static final long M_INCENDIARY_AC = 8L;
    public static final long M_PRECISION = 16L;
    public static final long M_TRACER = 32L;
    public static final long M_FLAK = 64L;
    public static final long M_EXTENDED_RANGE = 128L;
    public static final long M_HIGH_EXPLOSIVE = 256L;
    public static final long M_FRAGMENTATION = 512L;
    public static final long M_LISTEN_KILL = 1024L;
    public static final long M_ANTI_TSM = 2048L;
    public static final long M_NARC_CAPABLE = 4096L;
    public static final long M_ARTEMIS_CAPABLE = 8192L;
    public static final long M_DEAD_FIRE = 16384L;
    public static final long M_HEAT_SEEKING = 32768L;
    public static final long M_TANDEM_CHARGE = 65536L;
    public static final long M_INCENDIARY_LRM = 131072L;
    public static final long M_FLARE = 262144L;
    public static final long M_SEMIGUIDED = 524288L;
    public static final long M_SWARM = 0x100000L;
    public static final long M_SWARM_I = 0x200000L;
    public static final long M_THUNDER = 0x400000L;
    public static final long M_THUNDER_AUGMENTED = 0x800000L;
    public static final long M_THUNDER_INFERNO = 0x1000000L;
    public static final long M_THUNDER_VIBRABOMB = 0x2000000L;
    public static final long M_THUNDER_ACTIVE = 0x4000000L;
    public static final long M_FOLLOW_THE_LEADER = 0x8000000L;
    public static final long M_MULTI_PURPOSE = 0x10000000L;
    public static final long M_INFERNO = 0x20000000L;
    public static final long M_AX_HEAD = 0x40000000L;
    public static final long M_TORPEDO = 0x80000000L;
    public static final long M_NARC_EX = 0x100000000L;
    public static final long M_ECM = 0x200000000L;
    public static final long M_HAYWIRE = 0x400000000L;
    public static final long M_NEMESIS = 0x800000000L;
    public static final long M_EXPLOSIVE = 0x1000000000L;
    public static final long M_HOMING = 0x2000000000L;
    public static final long M_FASCAM = 0x4000000000L;
    public static final long M_INFERNO_IV = 0x8000000000L;
    public static final long M_VIBRABOMB_IV = 0x10000000000L;
    public static final long M_SMOKE = 0x20000000000L;
    public static final long M_DAVY_CROCKETT_M = 0x40000000000L;
    public static final long M_SANTA_ANNA = 0x80000000000L;
    public static final long M_TELE = 0x100000000000L;
    private static Vector<AmmoType>[] m_vaMunitions = new Vector[76];
    protected int damagePerShot;
    protected int rackSize;
    private int ammoType;
    private long munitionType;
    protected int shots;
    private double kgPerShot = -1.0;
    private double ammoRatio;
    private String shortName = "";
    protected int heat;
    protected RangeType range;
    protected int tech;
    protected boolean capital = false;

    public static Vector<AmmoType> getMunitionsFor(int n) {
        return m_vaMunitions[n];
    }

    public AmmoType() {
        this.criticals = 1;
        this.tonnage = 1.0f;
        this.explosive = true;
        this.instantModeSwitch = false;
        this.ammoRatio = 0.0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AmmoType)) {
            return false;
        }
        return this.getAmmoType() == ((AmmoType)object).getAmmoType() && this.getRackSize() == ((AmmoType)object).getRackSize();
    }

    public int getAmmoType() {
        return this.ammoType;
    }

    public long getMunitionType() {
        return this.munitionType;
    }

    public int getDamagePerShot() {
        return this.damagePerShot;
    }

    public int getRackSize() {
        return this.rackSize;
    }

    public int getShots() {
        return this.shots;
    }

    public double getAmmoRatio() {
        return this.ammoRatio;
    }

    public boolean isCapital() {
        return this.capital;
    }

    public static AmmoType getOneshotAmmo(Mounted mounted) {
        WeaponType weaponType = (WeaponType)mounted.getType();
        Vector<AmmoType> vector = AmmoType.getMunitionsFor(weaponType.getAmmoType());
        AmmoType ammoType = null;
        for (int i = 0; i < vector.size(); ++i) {
            ammoType = vector.elementAt(i);
            if (ammoType.getRackSize() != weaponType.getRackSize() || !TechConstants.isLegal(mounted.getType().getTechLevel(), ammoType.getTechLevel())) continue;
            return ammoType;
        }
        return null;
    }

    public static void initializeTypes() {
        ArrayList<AmmoType> arrayList = new ArrayList<AmmoType>(11);
        ArrayList<AmmoType> arrayList2 = new ArrayList<AmmoType>();
        ArrayList<AmmoType> arrayList3 = new ArrayList<AmmoType>();
        ArrayList<AmmoType> arrayList4 = new ArrayList<AmmoType>();
        ArrayList<AmmoType> arrayList5 = new ArrayList<AmmoType>();
        ArrayList<AmmoType> arrayList6 = new ArrayList<AmmoType>(26);
        ArrayList<AmmoType> arrayList7 = new ArrayList<AmmoType>();
        ArrayList<AmmoType> arrayList8 = new ArrayList<AmmoType>(4);
        ArrayList<AmmoType> arrayList9 = new ArrayList<AmmoType>(4);
        ArrayList<AmmoType> arrayList10 = new ArrayList<AmmoType>(4);
        ArrayList<AmmoType> arrayList11 = new ArrayList<AmmoType>(6);
        ArrayList<AmmoType> arrayList12 = new ArrayList<AmmoType>(6);
        ArrayList<AmmoType> arrayList13 = new ArrayList<AmmoType>(6);
        ArrayList<AmmoType> arrayList14 = new ArrayList<AmmoType>(6);
        ArrayList<AmmoType> arrayList15 = new ArrayList<AmmoType>(4);
        ArrayList<AmmoType> arrayList16 = new ArrayList<AmmoType>(4);
        ArrayList<MunitionMutator> arrayList17 = new ArrayList<MunitionMutator>();
        ArrayList<AmmoType> arrayList18 = new ArrayList<AmmoType>();
        AmmoType ammoType = null;
        EquipmentType.addType(AmmoType.createISVehicleFlamerAmmo());
        EquipmentType.addType(AmmoType.createISMGAmmo());
        EquipmentType.addType(AmmoType.createISMGAmmoHalf());
        ammoType = AmmoType.createISAC2Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC5Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC10Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC20Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM5Ammo();
        arrayList6.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM10Ammo();
        arrayList6.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM15Ammo();
        arrayList6.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM20Ammo();
        arrayList6.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM2Ammo();
        arrayList.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM4Ammo();
        arrayList.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM6Ammo();
        arrayList.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLAC2Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLAC5Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLAC10Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLAC20Ammo();
        arrayList8.add(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createISHeavyFlamerAmmo());
        EquipmentType.addType(AmmoType.createISCoolantPod());
        EquipmentType.addType(AmmoType.createCLCoolantPod());
        EquipmentType.addType(AmmoType.createISRailGunAmmo());
        EquipmentType.addType(AmmoType.createISMPodAmmo());
        EquipmentType.addType(AmmoType.createISBPodAmmo());
        EquipmentType.addType(AmmoType.createISLB2XAmmo());
        EquipmentType.addType(AmmoType.createISLB5XAmmo());
        EquipmentType.addType(AmmoType.createISLB10XAmmo());
        EquipmentType.addType(AmmoType.createISLB20XAmmo());
        EquipmentType.addType(AmmoType.createISLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB2XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB5XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB20XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createISUltra2Ammo());
        EquipmentType.addType(AmmoType.createISUltra5Ammo());
        EquipmentType.addType(AmmoType.createISUltra10Ammo());
        EquipmentType.addType(AmmoType.createISUltra20Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra2Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra10Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra20Ammo());
        EquipmentType.addType(AmmoType.createISRotary2Ammo());
        EquipmentType.addType(AmmoType.createISRotary5Ammo());
        EquipmentType.addType(AmmoType.createISRotary10Ammo());
        EquipmentType.addType(AmmoType.createISRotary20Ammo());
        EquipmentType.addType(AmmoType.createISGaussAmmo());
        EquipmentType.addType(AmmoType.createISLTGaussAmmo());
        EquipmentType.addType(AmmoType.createISHVGaussAmmo());
        EquipmentType.addType(AmmoType.createISIHVGaussAmmo());
        EquipmentType.addType(AmmoType.createISStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createISMRM10Ammo());
        EquipmentType.addType(AmmoType.createISMRM20Ammo());
        EquipmentType.addType(AmmoType.createISMRM30Ammo());
        EquipmentType.addType(AmmoType.createISMRM40Ammo());
        EquipmentType.addType(AmmoType.createISRL10Ammo());
        EquipmentType.addType(AmmoType.createISRL15Ammo());
        EquipmentType.addType(AmmoType.createISRL20Ammo());
        EquipmentType.addType(AmmoType.createISAMSAmmo());
        EquipmentType.addType(AmmoType.createISNarcAmmo());
        EquipmentType.addType(AmmoType.createISNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createISiNarcAmmo());
        EquipmentType.addType(AmmoType.createISiNarcECMAmmo());
        EquipmentType.addType(AmmoType.createISiNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createISiNarcHaywireAmmo());
        EquipmentType.addType(AmmoType.createISiNarcNemesisAmmo());
        EquipmentType.addType(AmmoType.createISLRT5Ammo());
        EquipmentType.addType(AmmoType.createISLRT10Ammo());
        EquipmentType.addType(AmmoType.createISLRT15Ammo());
        EquipmentType.addType(AmmoType.createISLRT20Ammo());
        EquipmentType.addType(AmmoType.createISSRT2Ammo());
        EquipmentType.addType(AmmoType.createISSRT4Ammo());
        EquipmentType.addType(AmmoType.createISSRT6Ammo());
        EquipmentType.addType(AmmoType.createISExtendedLRM5Ammo());
        EquipmentType.addType(AmmoType.createISExtendedLRM10Ammo());
        EquipmentType.addType(AmmoType.createISExtendedLRM15Ammo());
        EquipmentType.addType(AmmoType.createISExtendedLRM20Ammo());
        EquipmentType.addType(AmmoType.createISThunderbolt5Ammo());
        EquipmentType.addType(AmmoType.createISThunderbolt10Ammo());
        EquipmentType.addType(AmmoType.createISThunderbolt15Ammo());
        EquipmentType.addType(AmmoType.createISThunderbolt20Ammo());
        EquipmentType.addType(AmmoType.createISMagshotGRAmmo());
        EquipmentType.addType(AmmoType.createISPXLRM5Ammo());
        EquipmentType.addType(AmmoType.createISPXLRM10Ammo());
        EquipmentType.addType(AmmoType.createISPXLRM15Ammo());
        EquipmentType.addType(AmmoType.createISPXLRM20Ammo());
        EquipmentType.addType(AmmoType.createISHawkSRM2Ammo());
        EquipmentType.addType(AmmoType.createISHawkSRM4Ammo());
        EquipmentType.addType(AmmoType.createISHawkSRM6Ammo());
        EquipmentType.addType(AmmoType.createISStreakMRM10Ammo());
        EquipmentType.addType(AmmoType.createISStreakMRM20Ammo());
        EquipmentType.addType(AmmoType.createISStreakMRM30Ammo());
        EquipmentType.addType(AmmoType.createISStreakMRM40Ammo());
        EquipmentType.addType(AmmoType.createISHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createISHeavyMGAmmoHalf());
        EquipmentType.addType(AmmoType.createISLightMGAmmo());
        EquipmentType.addType(AmmoType.createISLightMGAmmoHalf());
        EquipmentType.addType(AmmoType.createISSBGaussRifleAmmo());
        EquipmentType.addType(AmmoType.createISHVAC10Ammo());
        EquipmentType.addType(AmmoType.createISHVAC5Ammo());
        EquipmentType.addType(AmmoType.createISHVAC2Ammo());
        ammoType = AmmoType.createISMML3LRMAmmo();
        arrayList6.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML3SRMAmmo();
        arrayList.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML5LRMAmmo();
        arrayList6.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML5SRMAmmo();
        arrayList.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML7LRMAmmo();
        arrayList6.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML7SRMAmmo();
        arrayList.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML9LRMAmmo();
        arrayList6.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISMML9SRMAmmo();
        arrayList.add(ammoType);
        arrayList18.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLongTomAmmo();
        arrayList13.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSniperAmmo();
        arrayList12.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISThumperAmmo();
        arrayList11.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISArrowIVAmmo();
        arrayList9.add(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createCLLB2XAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XAmmo());
        EquipmentType.addType(AmmoType.createCLLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLUltra2Ammo());
        EquipmentType.addType(AmmoType.createCLUltra5Ammo());
        EquipmentType.addType(AmmoType.createCLUltra10Ammo());
        EquipmentType.addType(AmmoType.createCLUltra20Ammo());
        EquipmentType.addType(AmmoType.createCLRotary2Ammo());
        EquipmentType.addType(AmmoType.createCLRotary5Ammo());
        EquipmentType.addType(AmmoType.createCLRotary10Ammo());
        EquipmentType.addType(AmmoType.createCLRotary20Ammo());
        EquipmentType.addType(AmmoType.createCLGaussAmmo());
        EquipmentType.addType(AmmoType.createCLStreakSRM1Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM3Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM5Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createCLVehicleFlamerAmmo());
        EquipmentType.addType(AmmoType.createCLMGAmmo());
        EquipmentType.addType(AmmoType.createCLMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createCLHeavyMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLLightMGAmmo());
        EquipmentType.addType(AmmoType.createCLLightMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLAMSAmmo());
        EquipmentType.addType(AmmoType.createCLNarcAmmo());
        EquipmentType.addType(AmmoType.createCLNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createCLATM3Ammo());
        EquipmentType.addType(AmmoType.createCLATM3ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM3HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM6Ammo());
        EquipmentType.addType(AmmoType.createCLATM6ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM6HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM9Ammo());
        EquipmentType.addType(AmmoType.createCLATM9ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM9HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM12Ammo());
        EquipmentType.addType(AmmoType.createCLATM12ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM12HEAmmo());
        EquipmentType.addType(AmmoType.createCLStreakLRM5Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM10Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM15Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM20Ammo());
        EquipmentType.addType(AmmoType.createCLSRT1Ammo());
        EquipmentType.addType(AmmoType.createCLSRT2Ammo());
        EquipmentType.addType(AmmoType.createCLSRT3Ammo());
        EquipmentType.addType(AmmoType.createCLSRT4Ammo());
        EquipmentType.addType(AmmoType.createCLSRT5Ammo());
        EquipmentType.addType(AmmoType.createCLSRT6Ammo());
        EquipmentType.addType(AmmoType.createCLLRT1Ammo());
        EquipmentType.addType(AmmoType.createCLLRT2Ammo());
        EquipmentType.addType(AmmoType.createCLLRT3Ammo());
        EquipmentType.addType(AmmoType.createCLLRT4Ammo());
        EquipmentType.addType(AmmoType.createCLLRT5Ammo());
        EquipmentType.addType(AmmoType.createCLLRT6Ammo());
        EquipmentType.addType(AmmoType.createCLLRT7Ammo());
        EquipmentType.addType(AmmoType.createCLLRT8Ammo());
        EquipmentType.addType(AmmoType.createCLLRT9Ammo());
        EquipmentType.addType(AmmoType.createCLLRT10Ammo());
        EquipmentType.addType(AmmoType.createCLLRT11Ammo());
        EquipmentType.addType(AmmoType.createCLLRT12Ammo());
        EquipmentType.addType(AmmoType.createCLLRT13Ammo());
        EquipmentType.addType(AmmoType.createCLLRT14Ammo());
        EquipmentType.addType(AmmoType.createCLLRT15Ammo());
        EquipmentType.addType(AmmoType.createCLLRT16Ammo());
        EquipmentType.addType(AmmoType.createCLLRT17Ammo());
        EquipmentType.addType(AmmoType.createCLLRT18Ammo());
        EquipmentType.addType(AmmoType.createCLLRT19Ammo());
        EquipmentType.addType(AmmoType.createCLLRT20Ammo());
        EquipmentType.addType(AmmoType.createCLMagshotGRAmmo());
        EquipmentType.addType(AmmoType.createCLMPodAmmo());
        EquipmentType.addType(AmmoType.createCLBPodAmmo());
        EquipmentType.addType(AmmoType.createCLHAG20Ammo());
        EquipmentType.addType(AmmoType.createCLHAG30Ammo());
        EquipmentType.addType(AmmoType.createCLHAG40Ammo());
        EquipmentType.addType(AmmoType.createCLPlasmaCannonAmmo());
        EquipmentType.addType(AmmoType.createISPlasmaRifleAmmo());
        EquipmentType.addType(AmmoType.createCLAPGaussRifleAmmo());
        EquipmentType.addType(AmmoType.createCLMediumChemicalLaserAmmo());
        EquipmentType.addType(AmmoType.createCLSmallChemicalLaserAmmo());
        EquipmentType.addType(AmmoType.createCLLargeChemicalLaserAmmo());
        ammoType = AmmoType.createCLLongTomAmmo();
        arrayList14.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSniperAmmo();
        arrayList14.add(ammoType);
        ammoType = AmmoType.createCLThumperAmmo();
        EquipmentType.addType(ammoType);
        arrayList14.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLArrowIVAmmo();
        arrayList10.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM1Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM2Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM3Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM4Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM5Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM6Ammo();
        arrayList2.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM1Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM2Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM3Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM4Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM5Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM6Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM7Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM8Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM9Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM10Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM11Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM12Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM13Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM14Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM15Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM16Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM17Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM18Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM19Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM20Ammo();
        arrayList7.add(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createBAMicroBombAmmo());
        EquipmentType.addType(AmmoType.createCLTorpedoLRM5Ammo());
        EquipmentType.addType(AmmoType.createBACompactNarcAmmo());
        EquipmentType.addType(AmmoType.createBAMineLauncherAmmo());
        EquipmentType.addType(AmmoType.createAdvancedSRM1Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM2Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM3Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM4Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM5Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM6Ammo());
        EquipmentType.addType(AmmoType.createBARL1Ammo());
        EquipmentType.addType(AmmoType.createBARL2Ammo());
        EquipmentType.addType(AmmoType.createBARL3Ammo());
        EquipmentType.addType(AmmoType.createBARL4Ammo());
        EquipmentType.addType(AmmoType.createBARL5Ammo());
        EquipmentType.addType(AmmoType.createISMRM1Ammo());
        EquipmentType.addType(AmmoType.createISMRM2Ammo());
        EquipmentType.addType(AmmoType.createISMRM3Ammo());
        EquipmentType.addType(AmmoType.createISMRM4Ammo());
        EquipmentType.addType(AmmoType.createISMRM5Ammo());
        EquipmentType.addType(AmmoType.createISBATaserAmmo());
        ammoType = AmmoType.createBAISLRM1Ammo();
        arrayList5.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBAISLRM2Ammo();
        arrayList5.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBAISLRM3Ammo();
        arrayList5.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBAISLRM4Ammo();
        arrayList5.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBAISLRM5Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBACLLRM1Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBACLLRM2Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBACLLRM3Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBACLLRM4Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBACLLRM5Ammo();
        arrayList4.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM1Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM2Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM3Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM4Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM5Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createBASRM6Ammo();
        arrayList3.add(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createCLPROHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createCLPROMGAmmo());
        EquipmentType.addType(AmmoType.createCLPROLightMGAmmo());
        EquipmentType.addType(AmmoType.createNAC10Ammo());
        EquipmentType.addType(AmmoType.createNAC20Ammo());
        EquipmentType.addType(AmmoType.createNAC25Ammo());
        EquipmentType.addType(AmmoType.createNAC30Ammo());
        EquipmentType.addType(AmmoType.createNAC35Ammo());
        EquipmentType.addType(AmmoType.createNAC40Ammo());
        EquipmentType.addType(AmmoType.createLightNGaussAmmo());
        EquipmentType.addType(AmmoType.createMediumNGaussAmmo());
        EquipmentType.addType(AmmoType.createHeavyNGaussAmmo());
        EquipmentType.addType(AmmoType.createKrakenAmmo());
        EquipmentType.addType(AmmoType.createKillerWhaleAmmo());
        EquipmentType.addType(AmmoType.createSantaAnnaAmmo());
        EquipmentType.addType(AmmoType.createWhiteSharkAmmo());
        EquipmentType.addType(AmmoType.createBarracudaAmmo());
        EquipmentType.addType(AmmoType.createKillerWhaleTAmmo());
        EquipmentType.addType(AmmoType.createWhiteSharkTAmmo());
        EquipmentType.addType(AmmoType.createBarracudaTAmmo());
        EquipmentType.addType(AmmoType.createAR10KillerWhaleAmmo());
        EquipmentType.addType(AmmoType.createAR10WhiteSharkAmmo());
        EquipmentType.addType(AmmoType.createAR10SantaAnnaAmmo());
        EquipmentType.addType(AmmoType.createAR10BarracudaAmmo());
        EquipmentType.addType(AmmoType.createAR10KillerWhaleTAmmo());
        EquipmentType.addType(AmmoType.createAR10WhiteSharkTAmmo());
        EquipmentType.addType(AmmoType.createAR10BarracudaTAmmo());
        EquipmentType.addType(AmmoType.createScreenLauncherAmmo());
        EquipmentType.addType(AmmoType.createAlamoAmmo());
        EquipmentType.addType(AmmoType.createLightSCCAmmo());
        EquipmentType.addType(AmmoType.createMediumSCCAmmo());
        EquipmentType.addType(AmmoType.createHeavySCCAmmo());
        EquipmentType.addType(AmmoType.createMantaRayAmmo());
        EquipmentType.addType(AmmoType.createSwordfishAmmo());
        EquipmentType.addType(AmmoType.createStingrayAmmo());
        EquipmentType.addType(AmmoType.createPiranhaAmmo());
        ammoType = AmmoType.createISAPMortar1Ammo();
        arrayList15.add(ammoType);
        ammoType = AmmoType.createISAPMortar2Ammo();
        arrayList15.add(ammoType);
        ammoType = AmmoType.createISAPMortar4Ammo();
        arrayList15.add(ammoType);
        ammoType = AmmoType.createISAPMortar8Ammo();
        arrayList15.add(ammoType);
        ammoType = AmmoType.createCLAPMortar1Ammo();
        arrayList16.add(ammoType);
        ammoType = AmmoType.createCLAPMortar2Ammo();
        arrayList16.add(ammoType);
        ammoType = AmmoType.createCLAPMortar4Ammo();
        arrayList16.add(ammoType);
        ammoType = AmmoType.createCLAPMortar8Ammo();
        arrayList16.add(ammoType);
        EquipmentType.addType(AmmoType.createISAPMortar1Ammo());
        EquipmentType.addType(AmmoType.createISAPMortar2Ammo());
        EquipmentType.addType(AmmoType.createISAPMortar4Ammo());
        EquipmentType.addType(AmmoType.createISAPMortar8Ammo());
        EquipmentType.addType(AmmoType.createCLAPMortar1Ammo());
        EquipmentType.addType(AmmoType.createCLAPMortar2Ammo());
        EquipmentType.addType(AmmoType.createCLAPMortar4Ammo());
        EquipmentType.addType(AmmoType.createCLAPMortar8Ammo());
        EquipmentType.addType(AmmoType.createISCruiseMissile50Ammo());
        EquipmentType.addType(AmmoType.createISCruiseMissile70Ammo());
        EquipmentType.addType(AmmoType.createISCruiseMissile90Ammo());
        EquipmentType.addType(AmmoType.createISCruiseMissile120Ammo());
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Inferno", 1, 0x20000000L, 1));
        arrayList17.add(new MunitionMutator("Fragmentation", 1, 512L, 1));
        arrayList17.add(new MunitionMutator("Narc-capable", 1, 4096L, 1));
        arrayList17.add(new MunitionMutator("Artemis-capable", 1, 8192L, 1));
        arrayList17.add(new MunitionMutator("Listen-Kill", 1, 1024L, 7));
        arrayList17.add(new MunitionMutator("Anti-TSM", 1, 2048L, 7));
        arrayList17.add(new MunitionMutator("Acid", 2, 0x40000000L, 7));
        arrayList17.add(new MunitionMutator("Dead-Fire", 2, 16384L, 9));
        arrayList17.add(new MunitionMutator("Heat-Seeking", 2, 32768L, 5));
        arrayList17.add(new MunitionMutator("Tandem-Charge", 2, 65536L, 7));
        AmmoType.createMunitions(arrayList, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("(Clan) Inferno", 1, 0x20000000L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Fragmentation", 1, 512L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Narc-capable", 1, 4096L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Artemis-capable", 1, 8192L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Listen-Kill", 1, 1024L, 8));
        arrayList17.add(new MunitionMutator("(Clan) Anti-TSM", 1, 2048L, 8));
        arrayList17.add(new MunitionMutator("(Clan) Acid", 2, 0x40000000L, 8));
        arrayList17.add(new MunitionMutator("(Clan) Dead-Fire", 2, 16384L, 10));
        arrayList17.add(new MunitionMutator("(Clan) Heat-Seeking", 2, 32768L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Tandem-Charge", 2, 65536L, 8));
        AmmoType.createMunitions(arrayList2, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Inferno", 1, 0x20000000L, -2));
        arrayList17.add(new MunitionMutator("Torpedo", 1, 0x80000000L, -2));
        AmmoType.createMunitions(arrayList3, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Torpedo", 1, 0x80000000L, 1));
        AmmoType.createMunitions(arrayList5, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Multi-Purpose", 1, 0x10000000L, 2));
        arrayList17.add(new MunitionMutator("Torpedo", 1, 0x80000000L, 2));
        AmmoType.createMunitions(arrayList4, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Fragmentation", 1, 512L, 1));
        arrayList17.add(new MunitionMutator("Thunder", 1, 0x400000L, 5));
        arrayList17.add(new MunitionMutator("Thunder-Augmented", 2, 0x800000L, 5));
        arrayList17.add(new MunitionMutator("Thunder-Inferno", 2, 0x1000000L, 5));
        arrayList17.add(new MunitionMutator("Thunder-Active", 2, 0x4000000L, 5));
        arrayList17.add(new MunitionMutator("Thunder-Vibrabomb", 2, 0x2000000L, 5));
        arrayList17.add(new MunitionMutator("Narc-capable", 1, 4096L, 1));
        arrayList17.add(new MunitionMutator("Artemis-capable", 1, 8192L, 1));
        arrayList17.add(new MunitionMutator("Semi-guided", 1, 524288L, 1));
        arrayList17.add(new MunitionMutator("Swarm", 1, 0x100000L, 5));
        arrayList17.add(new MunitionMutator("Swarm-I", 1, 0x200000L, 5));
        arrayList17.add(new MunitionMutator("Listen-Kill", 1, 1024L, 7));
        arrayList17.add(new MunitionMutator("Anti-TSM", 1, 2048L, 7));
        arrayList17.add(new MunitionMutator("Dead-Fire", 2, 16384L, 9));
        arrayList17.add(new MunitionMutator("Heat-Seeking", 2, 32768L, 5));
        arrayList17.add(new MunitionMutator("Follow The Leader", 2, 0x8000000L, 7));
        AmmoType.createMunitions(arrayList6, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("(Clan) Fragmentation", 1, 512L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Thunder", 1, 0x400000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Thunder-Augmented", 2, 0x800000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Thunder-Inferno", 2, 0x1000000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Thunder-Active", 2, 0x4000000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Thunder-Vibrabomb", 2, 0x2000000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Narc-capable", 1, 4096L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Artemis-capable", 1, 8192L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Semi-guided", 1, 524288L, 2));
        arrayList17.add(new MunitionMutator("(Clan) Swarm", 1, 0x100000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Swarm-I", 1, 0x200000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Listen-Kill", 1, 1024L, 8));
        arrayList17.add(new MunitionMutator("(Clan) Anti-TSM", 1, 2048L, 8));
        arrayList17.add(new MunitionMutator("(Clan) Dead-Fire", 2, 16384L, 10));
        arrayList17.add(new MunitionMutator("(Clan) Heat-Seeking", 2, 32768L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Follow The Leader", 2, 0x8000000L, 8));
        AmmoType.createMunitions(arrayList7, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Torpedo", 1, 0x80000000L, 1));
        AmmoType.createMunitions(arrayList18, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Precision", 2, 16L, 1));
        arrayList17.add(new MunitionMutator("Armor-Piercing", 2, 2L, 1));
        arrayList17.add(new MunitionMutator("Flechette", 1, 4L, 1));
        arrayList17.add(new MunitionMutator("Incendiary", 1, 8L, 1));
        arrayList17.add(new MunitionMutator("Tracer", 1, 32L, 1));
        arrayList17.add(new MunitionMutator("Flak", 1, 64L, 1));
        AmmoType.createMunitions(arrayList8, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Homing", 1, 0x2000000000L, 5));
        arrayList17.add(new MunitionMutator("FASCAM", 1, 0x4000000000L, 5));
        arrayList17.add(new MunitionMutator("Inferno-IV", 1, 0x8000000000L, 5));
        arrayList17.add(new MunitionMutator("Vibrabomb-IV", 1, 0x10000000000L, 5));
        arrayList17.add(new MunitionMutator("Cluster", 1, 1L, 5));
        arrayList17.add(new MunitionMutator("Davy Crockett-M", 5, 0x40000000000L, 7));
        arrayList17.add(new MunitionMutator("Smoke", 1, 0x20000000000L, 5));
        AmmoType.createMunitions(arrayList9, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Homing", 1, 0x2000000000L, 6));
        arrayList17.add(new MunitionMutator("FASCAM", 1, 0x4000000000L, 6));
        arrayList17.add(new MunitionMutator("Inferno-IV", 1, 0x8000000000L, 6));
        arrayList17.add(new MunitionMutator("Vibrabomb-IV", 1, 0x10000000000L, 6));
        arrayList17.add(new MunitionMutator("Davy Crockett-M", 5, 0x40000000000L, 8));
        arrayList17.add(new MunitionMutator("Cluster", 1, 1L, 6));
        arrayList17.add(new MunitionMutator("Smoke", 1, 0x20000000000L, 6));
        AmmoType.createMunitions(arrayList10, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("Smoke", 1, 0x20000000000L, 5));
        arrayList17.add(new MunitionMutator("Copperhead", 1, 0x2000000000L, 5));
        arrayList17.add(new MunitionMutator("Cluster", 1, 1L, 5));
        arrayList17.add(new MunitionMutator("Flechette", 1, 4L, 5));
        AmmoType.createMunitions(arrayList12, arrayList17);
        AmmoType.createMunitions(arrayList11, arrayList17);
        arrayList17.add(new MunitionMutator("Davy Crockett-M", 5, 0x40000000000L, 7));
        AmmoType.createMunitions(arrayList13, arrayList17);
        arrayList17.clear();
        arrayList17.add(new MunitionMutator("(Clan) Copperhead", 1, 0x2000000000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Smoke", 1, 0x20000000000L, 6));
        arrayList17.add(new MunitionMutator("(Clan) Flechette", 1, 4L, 6));
        AmmoType.createMunitions(arrayList14, arrayList17);
        Enumeration<EquipmentType> enumeration = EquipmentType.getAllTypes();
        while (enumeration.hasMoreElements()) {
            EquipmentType equipmentType = enumeration.nextElement();
            if (!(equipmentType instanceof AmmoType)) continue;
            AmmoType ammoType2 = (AmmoType)equipmentType;
            int n = ammoType2.getAmmoType();
            if (m_vaMunitions[n] == null) {
                AmmoType.m_vaMunitions[n] = new Vector();
            }
            m_vaMunitions[n].addElement(ammoType2);
        }
    }

    private static void createMunitions(List<AmmoType> list, List<MunitionMutator> list2) {
        for (AmmoType ammoType : list) {
            for (MunitionMutator munitionMutator : list2) {
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
    }

    private static AmmoType createISAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/2 Ammo";
        ammoType.shortName = "AutoCannon";
        ammoType.setInternalName("IS Ammo AC/2");
        ammoType.addLookupName("ISAC2 Ammo");
        ammoType.addLookupName("IS Autocannon/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 1;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/5 Ammo";
        ammoType.shortName = "AutoCannon";
        ammoType.setInternalName("IS Ammo AC/5");
        ammoType.addLookupName("ISAC5 Ammo");
        ammoType.addLookupName("IS Autocannon/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 1;
        ammoType.shots = 20;
        ammoType.bv = 9.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    private static AmmoType createISAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/10 Ammo";
        ammoType.shortName = "AutoCannon";
        ammoType.setInternalName("IS Ammo AC/10");
        ammoType.addLookupName("ISAC10 Ammo");
        ammoType.addLookupName("IS Autocannon/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 1;
        ammoType.shots = 10;
        ammoType.bv = 15.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    private static AmmoType createISAC20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/20 Ammo";
        ammoType.shortName = "AutoCannon";
        ammoType.setInternalName("IS Ammo AC/20");
        ammoType.addLookupName("ISAC20 Ammo");
        ammoType.addLookupName("IS Autocannon/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 1;
        ammoType.shots = 5;
        ammoType.bv = 22.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISVehicleFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Vehicle Flamer Ammo";
        ammoType.shortName = "Flamer";
        ammoType.setInternalName("IS Vehicle Flamer Ammo");
        ammoType.addLookupName("IS Ammo Vehicle Flamer");
        ammoType.addLookupName("ISVehicleFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 2;
        ammoType.shots = 20;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Machine Gun Ammo";
        ammoType.shortName = "Machine Gun";
        ammoType.setInternalName("IS Ammo MG - Full");
        ammoType.addLookupName("ISMG Ammo (200)");
        ammoType.addLookupName("IS Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.shortName = "Machine Gun";
        ammoType.setInternalName("IS Machine Gun Ammo - Half");
        ammoType.addLookupName("IS Ammo MG - Half");
        ammoType.addLookupName("ISMG Ammo (100)");
        ammoType.addLookupName("IS Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.bv = 0.5;
        ammoType.tonnage = 0.5f;
        ammoType.cost = 500.0;
        return ammoType;
    }

    private static AmmoType createISHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.shortName = "Heavy Machine Gun";
        ammoType.setInternalName("IS Heavy Machine Gun Ammo - Full");
        ammoType.addLookupName("ISHeavyMG Ammo (100)");
        ammoType.addLookupName("IS Heavy Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISHeavyMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Half Heavy Machine Gun Ammo";
        ammoType.shortName = "Heavy Machine Gun";
        ammoType.setInternalName("IS Heavy Machine Gun Ammo - Half");
        ammoType.addLookupName("ISHeavyMG Ammo (50)");
        ammoType.addLookupName("IS Heavy Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1L;
        ammoType.shots = 50;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 0.5;
        ammoType.cost = 500.0;
        return ammoType;
    }

    private static AmmoType createISLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.shortName = "Light Machine Gun";
        ammoType.setInternalName("IS Light Machine Gun Ammo - Full");
        ammoType.addLookupName("ISLightMG Ammo (200)");
        ammoType.addLookupName("IS Light Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 500.0;
        return ammoType;
    }

    private static AmmoType createISLightMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Half Light Machine Gun Ammo";
        ammoType.shortName = "Light Machine Gun";
        ammoType.setInternalName("IS Light Machine Gun Ammo - Half");
        ammoType.addLookupName("ISLightMG Ammo (100)");
        ammoType.addLookupName("IS Light Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 0.5;
        ammoType.cost = 250.0;
        return ammoType;
    }

    private static AmmoType createISLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 5 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS Ammo LRM-5");
        ammoType.addLookupName("ISLRM5 Ammo");
        ammoType.addLookupName("IS LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.bv = 6.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 10 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS Ammo LRM-10");
        ammoType.addLookupName("ISLRM10 Ammo");
        ammoType.addLookupName("IS LRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 15 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS Ammo LRM-15");
        ammoType.addLookupName("ISLRM15 Ammo");
        ammoType.addLookupName("IS LRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 17.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 20 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS Ammo LRM-20");
        ammoType.addLookupName("ISLRM20 Ammo");
        ammoType.addLookupName("IS LRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 23.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 2 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("IS Ammo SRM-2");
        ammoType.addLookupName("ISSRM2 Ammo");
        ammoType.addLookupName("IS SRM 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 4 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("IS Ammo SRM-4");
        ammoType.addLookupName("ISSRM4 Ammo");
        ammoType.addLookupName("IS SRM 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 6 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("IS Ammo SRM-6");
        ammoType.addLookupName("ISSRM6 Ammo");
        ammoType.addLookupName("IS SRM 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISLRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LRT 5 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("IS Ammo LRTorpedo-5");
        ammoType.addLookupName("ISLRTorpedo5 Ammo");
        ammoType.addLookupName("IS LRTorpedo 5 Ammo");
        ammoType.addLookupName("ISLRT5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 8;
        ammoType.shots = 24;
        ammoType.bv = 6.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISLRT10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LRT 10 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("IS Ammo LRTorpedo-10");
        ammoType.addLookupName("ISLRTorpedo10 Ammo");
        ammoType.addLookupName("IS LRTorpedo 10 Ammo");
        ammoType.addLookupName("ISLRT10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 8;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISLRT15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LRT 15 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("IS Ammo LRTorpedo-15");
        ammoType.addLookupName("ISLRTorpedo15 Ammo");
        ammoType.addLookupName("IS LRv 15 Ammo");
        ammoType.addLookupName("ISLRT15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 8;
        ammoType.shots = 8;
        ammoType.bv = 17.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISLRT20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LRT 20 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("IS Ammo LRTorpedo-20");
        ammoType.addLookupName("ISLRTorpedo20 Ammo");
        ammoType.addLookupName("IS LRTorpedo 20 Ammo");
        ammoType.addLookupName("ISLRT20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 8;
        ammoType.shots = 6;
        ammoType.bv = 23.0;
        ammoType.cost = 30000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISSRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRT 2 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("IS Ammo SRTorpedo-2");
        ammoType.addLookupName("ISSRTorpedo2 Ammo");
        ammoType.addLookupName("IS SRTorpedo 2 Ammo");
        ammoType.addLookupName("ISSRT2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 10;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISSRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRT 4 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("IS Ammo SRTorpedo-4");
        ammoType.addLookupName("ISSRTorpedo4 Ammo");
        ammoType.addLookupName("IS SRTorpedo 4 Ammo");
        ammoType.addLookupName("ISSRT4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 10;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISSRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRT 6 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("IS Ammo SRTorpedo-6");
        ammoType.addLookupName("ISSRTorpedo6 Ammo");
        ammoType.addLookupName("IS SRTorpedo 6 Ammo");
        ammoType.addLookupName("ISSRT6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 10;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createISLongTomAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Long Tom Ammo";
        ammoType.shortName = "Long Tom";
        ammoType.setInternalName("ISLongTomAmmo");
        ammoType.addLookupName("ISLongTom Ammo");
        ammoType.addLookupName("ISLongTomArtillery Ammo");
        ammoType.addLookupName("IS Ammo Long Tom");
        ammoType.addLookupName("IS Long Tom Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 25;
        ammoType.ammoType = 16;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISSniperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Sniper Ammo";
        ammoType.shortName = "Sniper";
        ammoType.setInternalName("ISSniperAmmo");
        ammoType.addLookupName("ISSniper Ammo");
        ammoType.addLookupName("ISSniperArtillery Ammo");
        ammoType.addLookupName("IS Ammo Sniper");
        ammoType.addLookupName("IS Sniper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 17;
        ammoType.shots = 10;
        ammoType.bv = 5.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    private static AmmoType createISThumperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Thumper Ammo";
        ammoType.shortName = "Thumper";
        ammoType.setInternalName("ISThumperAmmo");
        ammoType.addLookupName("ISThumper Ammo");
        ammoType.addLookupName("ISThumperArtillery Ammo");
        ammoType.addLookupName("IS Ammo Thumper");
        ammoType.addLookupName("IS Thumper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 18;
        ammoType.shots = 20;
        ammoType.bv = 3.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    private static AmmoType createISLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 2-X AC Ammo");
        ammoType.addLookupName("IS Ammo 2-X");
        ammoType.addLookupName("ISLBXAC2 Ammo");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 5-X AC Ammo");
        ammoType.addLookupName("IS Ammo 5-X");
        ammoType.addLookupName("ISLBXAC5 Ammo");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    private static AmmoType createISLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 10-X AC Ammo");
        ammoType.addLookupName("IS Ammo 10-X");
        ammoType.addLookupName("ISLBXAC10 Ammo");
        ammoType.addLookupName("IS LB 10-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    private static AmmoType createISLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 20-X AC Ammo");
        ammoType.addLookupName("IS Ammo 20-X");
        ammoType.addLookupName("ISLBXAC20 Ammo");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 30.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 2-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 2-X (CL)");
        ammoType.addLookupName("ISLBXAC2 CL Ammo");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 3300.0;
        return ammoType;
    }

    private static AmmoType createISLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 5-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 5-X (CL)");
        ammoType.addLookupName("ISLBXAC5 CL Ammo");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    private static AmmoType createISLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 10-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 10-X (CL)");
        ammoType.addLookupName("ISLBXAC10 CL Ammo");
        ammoType.addLookupName("IS LB 10-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 20-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 20-X (CL)");
        ammoType.addLookupName("ISLBXAC20 CL Ammo");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 5;
        ammoType.bv = 30.0;
        ammoType.cost = 34000.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 2-X AC Ammo (THB)";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 2-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 2-X (THB)");
        ammoType.addLookupName("ISLBXAC2 Ammo (THB)");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 32;
        ammoType.shots = 40;
        ammoType.bv = 5.0;
        ammoType.cost = 3000.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 5-X AC Ammo (THB)";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 5-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 5-X (THB)");
        ammoType.addLookupName("ISLBXAC5 Ammo (THB)");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 32;
        ammoType.shots = 16;
        ammoType.bv = 11.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LB 20-X AC Ammo (THB)";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("IS LB 20-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 20-X (THB)");
        ammoType.addLookupName("ISLBXAC20 Ammo (THB)");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 32;
        ammoType.shots = 4;
        ammoType.bv = 26.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LB 2-X Cluster Ammo (THB)";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 2-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 2-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC2 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 32;
        ammoType.munitionType = 1L;
        ammoType.shots = 40;
        ammoType.bv = 5.0;
        ammoType.cost = 4950.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LB 5-X Cluster Ammo (THB)";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 5-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 5-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC5 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 32;
        ammoType.munitionType = 1L;
        ammoType.shots = 16;
        ammoType.bv = 11.0;
        ammoType.cost = 25000.0;
        return ammoType;
    }

    private static AmmoType createISTHBLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LB 20-X Cluster Ammo (THB)";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("IS LB 20-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 20-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC20 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 32;
        ammoType.munitionType = 1L;
        ammoType.shots = 4;
        ammoType.bv = 26.0;
        ammoType.cost = 51000.0;
        return ammoType;
    }

    private static AmmoType createISUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/2 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/2");
        ammoType.addLookupName("ISUltraAC2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 7.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/5 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/5");
        ammoType.addLookupName("ISUltraAC5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    private static AmmoType createISUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/10 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/10");
        ammoType.addLookupName("ISUltraAC10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    private static AmmoType createISUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/20 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/20");
        ammoType.addLookupName("ISUltraAC20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 35.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISTHBUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Ultra AC/2 Ammo (THB)";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/2 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/2 (THB)");
        ammoType.addLookupName("ISUltraAC2 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 33;
        ammoType.shots = 45;
        ammoType.bv = 8.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISTHBUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Ultra AC/10 Ammo (THB)";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/10 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/10 (THB)");
        ammoType.addLookupName("ISUltraAC10 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 33;
        ammoType.shots = 10;
        ammoType.bv = 31.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    private static AmmoType createISTHBUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Ultra AC/20 Ammo (THB)";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("IS Ultra AC/20 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/20 (THB)");
        ammoType.addLookupName("ISUltraAC20 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 33;
        ammoType.shots = 5;
        ammoType.bv = 42.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISRotary2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Rotary AC/2 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("ISRotaryAC2 Ammo");
        ammoType.addLookupName("IS Rotary AC/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 23;
        ammoType.shots = 45;
        ammoType.bv = 15.0;
        ammoType.cost = 3000.0;
        return ammoType;
    }

    private static AmmoType createISRotary5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Rotary AC/5 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("ISRotaryAC5 Ammo");
        ammoType.addLookupName("IS Rotary AC/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 23;
        ammoType.shots = 20;
        ammoType.bv = 31.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    private static AmmoType createISRotary10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Rotary AC/10 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("ISRotaryAC10 Ammo");
        ammoType.addLookupName("IS Rotary AC/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 23;
        ammoType.shots = 10;
        ammoType.bv = 37.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISRotary20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Rotary AC/20 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("ISRotaryAC20 Ammo");
        ammoType.addLookupName("IS Rotary AC/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 23;
        ammoType.shots = 5;
        ammoType.bv = 59.0;
        ammoType.cost = 80000.0;
        return ammoType;
    }

    private static AmmoType createISGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Gauss Ammo";
        ammoType.shortName = "Gauss";
        ammoType.setInternalName("IS Gauss Ammo");
        ammoType.addLookupName("IS Ammo Gauss");
        ammoType.addLookupName("ISGauss Ammo");
        ammoType.addLookupName("IS Gauss Rifle Ammo");
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 40.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISLTGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Light Gauss Ammo";
        ammoType.shortName = "Light Gauss";
        ammoType.setInternalName("IS Light Gauss Ammo");
        ammoType.addLookupName("ISLightGauss Ammo");
        ammoType.addLookupName("IS Light Gauss Rifle Ammo");
        ammoType.damagePerShot = 8;
        ammoType.explosive = false;
        ammoType.ammoType = 21;
        ammoType.shots = 16;
        ammoType.bv = 20.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISHVGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Heavy Gauss Ammo";
        ammoType.shortName = "Heavy Gauss";
        ammoType.setInternalName("ISHeavyGauss Ammo");
        ammoType.addLookupName("IS Heavy Gauss Rifle Ammo");
        ammoType.damagePerShot = 25;
        ammoType.explosive = false;
        ammoType.ammoType = 22;
        ammoType.shots = 4;
        ammoType.bv = 43.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISIHVGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Improved Heavy Gauss Ammo";
        ammoType.shortName = "Heavy Gauss";
        ammoType.setInternalName("ISImprovedHeavyGauss Ammo");
        ammoType.addLookupName("IS Improved Heavy Gauss Rifle Ammo");
        ammoType.damagePerShot = 22;
        ammoType.explosive = false;
        ammoType.ammoType = 64;
        ammoType.shots = 4;
        ammoType.bv = 48.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("IS Streak SRM 2 Ammo");
        ammoType.addLookupName("IS Ammo Streak-2");
        ammoType.addLookupName("ISStreakSRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 4.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    private static AmmoType createISStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("IS Streak SRM 4 Ammo");
        ammoType.addLookupName("IS Ammo Streak-4");
        ammoType.addLookupName("ISStreakSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 7.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    private static AmmoType createISStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("IS Streak SRM 6 Ammo");
        ammoType.addLookupName("IS Ammo Streak-6");
        ammoType.addLookupName("ISStreakSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 11.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    private static AmmoType createISMRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 10 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 10 Ammo");
        ammoType.addLookupName("ISMRM10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 12;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createISMRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 20 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 20 Ammo");
        ammoType.addLookupName("ISMRM20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 12;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createISMRM30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 30 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 30 Ammo");
        ammoType.addLookupName("ISMRM30 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 12;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createISMRM40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 40 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 40 Ammo");
        ammoType.addLookupName("ISMRM40 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 12;
        ammoType.shots = 6;
        ammoType.bv = 28.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createISRL10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 10 Ammo";
        ammoType.setInternalName("IS Ammo RL-10");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 29;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createISRL15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 15 Ammo";
        ammoType.setInternalName("IS Ammo RL-15");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 29;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    private static AmmoType createISRL20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 20 Ammo";
        ammoType.setInternalName("IS Ammo RL-20");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 29;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AMS Ammo";
        ammoType.shortName = "AMS";
        ammoType.setInternalName("ISAMS Ammo");
        ammoType.addLookupName("IS Ammo AMS");
        ammoType.addLookupName("IS AMS Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Narc Pods";
        ammoType.shortName = "Narc";
        ammoType.setInternalName("ISNarc Pods");
        ammoType.addLookupName("IS Ammo Narc");
        ammoType.addLookupName("IS Narc Missile Beacon Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    private static AmmoType createISNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Narc Explosive Pods";
        ammoType.shortName = "Narc";
        ammoType.setInternalName("ISNarc ExplosivePods");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.munitionType = 0x100000000L;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    private static AmmoType createISiNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Pods";
        ammoType.shortName = "iNarc";
        ammoType.setInternalName("ISiNarc Pods");
        ammoType.addLookupName("IS Ammo iNarc");
        ammoType.addLookupName("IS iNarc Missile Beacon Ammo");
        ammoType.addLookupName("iNarc Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 7500.0;
        return ammoType;
    }

    private static AmmoType createISiNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Explosive Pods";
        ammoType.shortName = "iNarc";
        ammoType.setInternalName("ISiNarc Explosive Pods");
        ammoType.addLookupName("iNarc Explosive Ammo");
        ammoType.damagePerShot = 6;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.munitionType = 0x1000000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    private static AmmoType createISiNarcECMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc ECM Pods";
        ammoType.shortName = "iNarc";
        ammoType.setInternalName("ISiNarc ECM Pods");
        ammoType.addLookupName("iNarc ECM Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.munitionType = 0x200000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    private static AmmoType createISiNarcHaywireAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Haywire Pods";
        ammoType.shortName = "iNarc";
        ammoType.setInternalName("ISiNarc Haywire Pods");
        ammoType.addLookupName("iNarc Haywire Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.munitionType = 0x400000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISiNarcNemesisAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Nemesis Pods";
        ammoType.shortName = "iNarc";
        ammoType.setInternalName("ISiNarc Nemesis Pods");
        ammoType.addLookupName("iNarc Nemesis Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.munitionType = 0x800000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Gauss Ammo";
        ammoType.shortName = "Gauss";
        ammoType.setInternalName("Clan Gauss Ammo");
        ammoType.addLookupName("Clan Ammo Gauss");
        ammoType.addLookupName("CLGauss Ammo");
        ammoType.addLookupName("Clan Gauss Rifle Ammo");
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 40.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createCLLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("Clan LB 2-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 2-X");
        ammoType.addLookupName("CLLBXAC2 Ammo");
        ammoType.addLookupName("Clan LB 2-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        ammoType.cost = 2000.0;
        ammoType.kgPerShot = 20.0;
        return ammoType;
    }

    private static AmmoType createCLLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("Clan LB 5-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 5-X");
        ammoType.addLookupName("CLLBXAC5 Ammo");
        ammoType.addLookupName("Clan LB 5-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        ammoType.cost = 9000.0;
        ammoType.kgPerShot = 50.0;
        return ammoType;
    }

    private static AmmoType createCLLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("Clan LB 10-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 10-X");
        ammoType.addLookupName("CLLBXAC10 Ammo");
        ammoType.addLookupName("Clan LB 10-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    private static AmmoType createCLLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.shortName = "LB-X";
        ammoType.setInternalName("Clan LB 20-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 20-X");
        ammoType.addLookupName("CLLBXAC20 Ammo");
        ammoType.addLookupName("Clan LB 20-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 30.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createCLLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("Clan LB 2-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 2-X (CL)");
        ammoType.addLookupName("CLLBXAC2 CL Ammo");
        ammoType.addLookupName("Clan LB 2-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        ammoType.cost = 3300.0;
        return ammoType;
    }

    private static AmmoType createCLLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("Clan LB 5-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 5-X (CL)");
        ammoType.addLookupName("CLLBXAC5 CL Ammo");
        ammoType.addLookupName("Clan LB 5-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    private static AmmoType createCLLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("Clan LB 10-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 10-X (CL)");
        ammoType.addLookupName("CLLBXAC10 CL Ammo");
        ammoType.addLookupName("Clan LB 10-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createCLLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.shortName = "LB-X Cluster";
        ammoType.setInternalName("Clan LB 20-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 20-X (CL)");
        ammoType.addLookupName("CLLBXAC20 CL Ammo");
        ammoType.addLookupName("Clan LB 20-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 5;
        ammoType.bv = 30.0;
        ammoType.cost = 34000.0;
        return ammoType;
    }

    private static AmmoType createCLVehicleFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Vehicle Flamer Ammo";
        ammoType.shortName = "Vehicle Flamer";
        ammoType.setInternalName("Clan Vehicle Flamer Ammo");
        ammoType.addLookupName("Clan Ammo Vehicle Flamer");
        ammoType.addLookupName("CLVehicleFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 2;
        ammoType.shots = 20;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createCLHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.shortName = "Heavy Machine Gun";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Full");
        ammoType.addLookupName("CLHeavyMG Ammo (100)");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLHeavyMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Heavy Machine Gun Ammo";
        ammoType.shortName = "Heavy Machine Gun";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Half");
        ammoType.addLookupName("CLHeavyMG Ammo (50)");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1L;
        ammoType.shots = 50;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 0.5;
        ammoType.cost = 500.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Machine Gun Ammo";
        ammoType.shortName = "Machine Gun";
        ammoType.setInternalName("Clan Machine Gun Ammo - Full");
        ammoType.addLookupName("Clan Ammo MG - Full");
        ammoType.addLookupName("CLMG Ammo (200)");
        ammoType.addLookupName("Clan Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        ammoType.kgPerShot = 5.0;
        return ammoType;
    }

    private static AmmoType createCLMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.shortName = "Machine Gun";
        ammoType.setInternalName("Clan Machine Gun Ammo - Half");
        ammoType.addLookupName("Clan Ammo MG - Half");
        ammoType.addLookupName("CLMG Ammo (100)");
        ammoType.addLookupName("Clan Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 0.5;
        ammoType.cost = 500.0;
        ammoType.kgPerShot = 5.0;
        return ammoType;
    }

    private static AmmoType createCLLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.shortName = "Light Machine Gun";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Full");
        ammoType.addLookupName("CLLightMG Ammo (200)");
        ammoType.addLookupName("Clan Light Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 500.0;
        ammoType.kgPerShot = 5.0;
        return ammoType;
    }

    private static AmmoType createCLLightMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Light Machine Gun Ammo";
        ammoType.shortName = "Light Machine Gun";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Half");
        ammoType.addLookupName("CLLightMG Ammo (100)");
        ammoType.addLookupName("Clan Light Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1L;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 0.5;
        ammoType.cost = 250.0;
        ammoType.kgPerShot = 5.0;
        return ammoType;
    }

    private static AmmoType createCLUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("Clan Ultra AC/2 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/2");
        ammoType.addLookupName("CLUltraAC2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 8.0;
        ammoType.cost = 1000.0;
        ammoType.kgPerShot = 20.0;
        return ammoType;
    }

    private static AmmoType createCLUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("Clan Ultra AC/5 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/5");
        ammoType.addLookupName("CLUltraAC5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 15.0;
        ammoType.cost = 9000.0;
        ammoType.kgPerShot = 50.0;
        return ammoType;
    }

    private static AmmoType createCLUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("Clan Ultra AC/10 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/10");
        ammoType.addLookupName("CLUltraAC10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    private static AmmoType createCLUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.shortName = "Ultra AC";
        ammoType.setInternalName("Clan Ultra AC/20 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/20");
        ammoType.addLookupName("CLUltraAC20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 42.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createCLRotary2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Rotary AC/2 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("CLRotaryAC2 Ammo");
        ammoType.addLookupName("CL Rotary AC/2 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 23;
        ammoType.shots = 45;
        ammoType.bv = 22.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createCLRotary5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Rotary AC/5 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("CLRotaryAC5 Ammo");
        ammoType.addLookupName("CL Rotary AC/5 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 23;
        ammoType.shots = 20;
        ammoType.bv = 43.0;
        ammoType.cost = 13000.0;
        return ammoType;
    }

    private static AmmoType createCLRotary10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 10;
        ammoType.name = "Rotary AC/10 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("CLRotaryAC10 Ammo");
        ammoType.addLookupName("CL Rotary AC/10 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 23;
        ammoType.shots = 10;
        ammoType.bv = 74.0;
        ammoType.cost = 16000.0;
        return ammoType;
    }

    private static AmmoType createCLRotary20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 10;
        ammoType.name = "Rotary AC/20 Ammo";
        ammoType.shortName = "Rotary AC";
        ammoType.setInternalName("CLRotaryAC20 Ammo");
        ammoType.addLookupName("CL Rotary AC/20 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 23;
        ammoType.shots = 5;
        ammoType.bv = 118.0;
        ammoType.cost = 24000.0;
        return ammoType;
    }

    private static AmmoType createCLLRT1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 1 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-1");
        ammoType.addLookupName("Clan Ammo LRTorpedo-1");
        ammoType.addLookupName("CLLRTorpedo1 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 2 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-2");
        ammoType.addLookupName("Clan Ammo LRTorpedo-2");
        ammoType.addLookupName("CLLRTorpedo2 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 3 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-3");
        ammoType.addLookupName("Clan Ammo LRTorpedo-3");
        ammoType.addLookupName("CLLRTorpedo3 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 4 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-4");
        ammoType.addLookupName("Clan Ammo LRTorpedo-4");
        ammoType.addLookupName("CLLRTorpedo4 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 5 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo LRTorpedo-5");
        ammoType.addLookupName("CLLRTorpedo5 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 5 Ammo");
        ammoType.addLookupName("CLLRT5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 6 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-6");
        ammoType.addLookupName("Clan Ammo LRTorpedo-6");
        ammoType.addLookupName("CLLRTorpedo6 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 6 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 9.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT7Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 7 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-7");
        ammoType.addLookupName("Clan Ammo LRTorpedo-7");
        ammoType.addLookupName("CLLRTorpedo7 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 7 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 10.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 8 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-8");
        ammoType.addLookupName("Clan Ammo LRTorpedo-8");
        ammoType.addLookupName("CLLRTorpedo8 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 8 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 8;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 11.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 9 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-9");
        ammoType.addLookupName("Clan Ammo LRTorpedo-9");
        ammoType.addLookupName("CLLRTorpedo9 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 9 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 10 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo LRTorpedo-10");
        ammoType.addLookupName("CLLRTorpedo10 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 10 Ammo");
        ammoType.addLookupName("CLLRT10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 8;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT11Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 11 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-11");
        ammoType.addLookupName("Clan Ammo LRTorpedo-11");
        ammoType.addLookupName("CLLRTorpedo11 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 11 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 11;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 12 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-12");
        ammoType.addLookupName("Clan Ammo LRTorpedo-12");
        ammoType.addLookupName("CLLRTorpedo12 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 12 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT13Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 13 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-13");
        ammoType.addLookupName("Clan Ammo LRTorpedo-13");
        ammoType.addLookupName("CLLRTorpedo13 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 13 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 13;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 20.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT14Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 14 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-14");
        ammoType.addLookupName("Clan Ammo LRTorpedo-14");
        ammoType.addLookupName("CLLRTorpedo14 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 14 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 14;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 21.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 15 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo LRTorpedo-15");
        ammoType.addLookupName("CLLRTorpedo15 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 15 Ammo");
        ammoType.addLookupName("CLLRT15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 8;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT16Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 16 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-16");
        ammoType.addLookupName("Clan Ammo LRTorpedo-16");
        ammoType.addLookupName("CLLRTorpedo16 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 16 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 16;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT17Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 17 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-17");
        ammoType.addLookupName("Clan Ammo LRTorpedo-17");
        ammoType.addLookupName("CLLRTorpedo17 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 17 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 17;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT18Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 18 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-18");
        ammoType.addLookupName("Clan Ammo LRTorpedo-18");
        ammoType.addLookupName("CLLRTorpedo18 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 18 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 18;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT19Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 19 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-19");
        ammoType.addLookupName("Clan Ammo LRTorpedo-19");
        ammoType.addLookupName("CLLRTorpedo19 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 19 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 19;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRT20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 20 Ammo";
        ammoType.shortName = "LRT";
        ammoType.setInternalName("Clan Ammo LRTorpedo-20");
        ammoType.addLookupName("CLLRTorpedo20 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 20 Ammo");
        ammoType.addLookupName("CLLRT20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 8;
        ammoType.shots = 6;
        ammoType.bv = 27.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 1 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-1");
        ammoType.addLookupName("CLSRM1 Ammo");
        ammoType.addLookupName("Clan SRM 1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 2 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-2");
        ammoType.addLookupName("CLSRM2 Ammo");
        ammoType.addLookupName("Clan SRM 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 3 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-3");
        ammoType.addLookupName("CLSRM3 Ammo");
        ammoType.addLookupName("Clan SRM 3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 4.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 4 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-4");
        ammoType.addLookupName("CLSRM4 Ammo");
        ammoType.addLookupName("Clan SRM 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 5 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-5");
        ammoType.addLookupName("CLSRM5 Ammo");
        ammoType.addLookupName("Clan SRM 5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 6 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("Clan Ammo SRM-6");
        ammoType.addLookupName("CLSRM6 Ammo");
        ammoType.addLookupName("Clan SRM 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 1 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-1");
        ammoType.addLookupName("Clan Ammo LRM-1");
        ammoType.addLookupName("CLLRM1 Ammo");
        ammoType.addLookupName("Clan LRM 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 2 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-2");
        ammoType.addLookupName("Clan Ammo LRM-2");
        ammoType.addLookupName("CLLRM2 Ammo");
        ammoType.addLookupName("Clan LRM 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 3 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-3");
        ammoType.addLookupName("Clan Ammo LRM-3");
        ammoType.addLookupName("CLLRM3 Ammo");
        ammoType.addLookupName("Clan LRM 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 4 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-4");
        ammoType.addLookupName("Clan Ammo LRM-4");
        ammoType.addLookupName("CLLRM4 Ammo");
        ammoType.addLookupName("Clan LRM 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 5 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo LRM-5");
        ammoType.addLookupName("CLLRM5 Ammo");
        ammoType.addLookupName("Clan LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 6 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-6");
        ammoType.addLookupName("Clan Ammo LRM-6");
        ammoType.addLookupName("CLLRM6 Ammo");
        ammoType.addLookupName("Clan LRM 6 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 9.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM7Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 7 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-7");
        ammoType.addLookupName("Clan Ammo LRM-7");
        ammoType.addLookupName("CLLRM7 Ammo");
        ammoType.addLookupName("Clan LRM 7 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 10.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 8 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-8");
        ammoType.addLookupName("Clan Ammo LRM-8");
        ammoType.addLookupName("CLLRM8 Ammo");
        ammoType.addLookupName("Clan LRM 8 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 8;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 11.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 9 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-9");
        ammoType.addLookupName("Clan Ammo LRM-9");
        ammoType.addLookupName("CLLRM9 Ammo");
        ammoType.addLookupName("Clan LRM 9 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 10 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo LRM-10");
        ammoType.addLookupName("CLLRM10 Ammo");
        ammoType.addLookupName("Clan LRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM11Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 11 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-11");
        ammoType.addLookupName("Clan Ammo LRM-11");
        ammoType.addLookupName("CLLRM11 Ammo");
        ammoType.addLookupName("Clan LRM 11 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 11;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 12 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-12");
        ammoType.shortName = "LRM";
        ammoType.addLookupName("Clan Ammo LRM-12");
        ammoType.addLookupName("CLLRM12 Ammo");
        ammoType.addLookupName("Clan LRM 12 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM13Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 13 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-13");
        ammoType.addLookupName("Clan Ammo LRM-13");
        ammoType.addLookupName("CLLRM13 Ammo");
        ammoType.addLookupName("Clan LRM 13 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 13;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 20.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM14Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 14 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-14");
        ammoType.addLookupName("Clan Ammo LRM-14");
        ammoType.addLookupName("CLLRM14 Ammo");
        ammoType.addLookupName("Clan LRM 14 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 14;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 21.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.shortName = "LRM";
        ammoType.name = "LRM 15 Ammo";
        ammoType.setInternalName("Clan Ammo LRM-15");
        ammoType.addLookupName("CLLRM15 Ammo");
        ammoType.addLookupName("Clan LRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM16Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 16 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-16");
        ammoType.addLookupName("Clan Ammo LRM-16");
        ammoType.addLookupName("CLLRM16 Ammo");
        ammoType.addLookupName("Clan LRM 16 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 16;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM17Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 17 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-17");
        ammoType.addLookupName("Clan Ammo LRM-17");
        ammoType.addLookupName("CLLRM17 Ammo");
        ammoType.addLookupName("Clan LRM 17 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 17;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM18Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 18 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo Protomech LRM-18");
        ammoType.addLookupName("Clan Ammo LRM-18");
        ammoType.addLookupName("CLLRM18 Ammo");
        ammoType.addLookupName("Clan LRM 18 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 18;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM19Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.shortName = "LRM";
        ammoType.name = "LRM 19 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-19");
        ammoType.addLookupName("Clan Ammo LRM-19");
        ammoType.addLookupName("CLLRM19 Ammo");
        ammoType.addLookupName("Clan LRM 19 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 19;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 20 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("Clan Ammo LRM-20");
        ammoType.addLookupName("CLLRM20 Ammo");
        ammoType.addLookupName("Clan LRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 27.0;
        ammoType.cost = 30000.0;
        ammoType.kgPerShot = 8.33;
        return ammoType;
    }

    private static AmmoType createCLSRT1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 1 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("Clan Ammo SRTorpedo-1");
        ammoType.addLookupName("CLSRTorpedo1 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        return ammoType;
    }

    private static AmmoType createCLSRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 2 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("Clan Ammo SRTorpedo-2");
        ammoType.addLookupName("CLSRTorpedo2 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 2 Ammo");
        ammoType.addLookupName("CLSRT2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 10;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createCLSRT3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 3 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("Clan Ammo SRTorpedo-3");
        ammoType.addLookupName("CLSRTorpedo3 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 4.0;
        return ammoType;
    }

    private static AmmoType createCLSRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 4 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("Clan Ammo SRTorpedo-4");
        ammoType.addLookupName("CLSRTorpedo4 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 4 Ammo");
        ammoType.addLookupName("CLSRT4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 10;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createCLSRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 5 Ammo";
        ammoType.shortName = "SRT";
        ammoType.setInternalName("Clan Ammo SRTorpedo-5");
        ammoType.addLookupName("CLSRTorpedo5 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        return ammoType;
    }

    private static AmmoType createCLSRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.shortName = "SRT";
        ammoType.name = "SRT 6 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-6");
        ammoType.addLookupName("CLSRTorpedo6 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 6 Ammo");
        ammoType.addLookupName("CLSRT6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 10;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 1 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 1 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-1");
        ammoType.addLookupName("CLStreakSRM1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 2 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-2");
        ammoType.addLookupName("CLStreakSRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 5.0;
        ammoType.cost = 54000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 3 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 3 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-3");
        ammoType.addLookupName("CLStreakSRM3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 7.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 4 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-4");
        ammoType.addLookupName("CLStreakSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 10.0;
        ammoType.cost = 54000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 5 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 5 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-5");
        ammoType.addLookupName("CLStreakSRM5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 13.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak SRM 6 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-6");
        ammoType.addLookupName("CLStreakSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 15.0;
        ammoType.cost = 54000.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createCLAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AMS Ammo";
        ammoType.shortName = "AMS";
        ammoType.setInternalName("CLAMS Ammo");
        ammoType.addLookupName("Clan Ammo AMS");
        ammoType.addLookupName("Clan AMS Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 24;
        ammoType.bv = 22.0;
        ammoType.cost = 2000.0;
        ammoType.kgPerShot = 40.0;
        return ammoType;
    }

    private static AmmoType createCLNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Narc Pods";
        ammoType.setInternalName("CLNarc Pods");
        ammoType.addLookupName("Clan Ammo Narc");
        ammoType.addLookupName("Clan Narc Missile Beacon Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 6000.0;
        ammoType.kgPerShot = 150.0;
        return ammoType;
    }

    private static AmmoType createCLNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Narc Explosive Pods";
        ammoType.setInternalName("CLNarc Explosive Pods");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.munitionType = 0x100000000L;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        ammoType.kgPerShot = 150.0;
        return ammoType;
    }

    private static AmmoType createCLSmallChemicalLaserAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Small Chemical Laser Ammo";
        ammoType.shortName = "Chemical Laser";
        ammoType.setInternalName("CLSmallChemLaserAmmo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 65;
        ammoType.shots = 60;
        ammoType.bv = 1.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createCLMediumChemicalLaserAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Medium Chemical Laser Ammo";
        ammoType.shortName = "Chemical Laser";
        ammoType.setInternalName("CLMediumChemLaserAmmo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 65;
        ammoType.shots = 30;
        ammoType.bv = 5.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createCLLargeChemicalLaserAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Large Chemical Laser Ammo";
        ammoType.shortName = "Chemical Laser";
        ammoType.setInternalName("CLLargeChemLaserAmmo");
        ammoType.damagePerShot = 8;
        ammoType.rackSize = 1;
        ammoType.ammoType = 65;
        ammoType.shots = 10;
        ammoType.bv = 12.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createISMML3LRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 3 LRM Ammo";
        ammoType.shortName = "MML/LRM";
        ammoType.setInternalName("IS Ammo MML-3 LRM");
        ammoType.addLookupName("ISMML3 LRM Ammo");
        ammoType.addLookupName("IS MML-3 LRM Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 45;
        ammoType.shots = 40;
        ammoType.bv = 4.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 0x28L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISMML3SRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 3 SRM Ammo";
        ammoType.shortName = "MML/SRM";
        ammoType.setInternalName("IS Ammo MML-3 SRM");
        ammoType.addLookupName("ISMML3 SRM Ammo");
        ammoType.addLookupName("IS MML-3 SRM Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 45;
        ammoType.shots = 33;
        ammoType.bv = 4.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createISMML5LRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 5 LRM Ammo";
        ammoType.shortName = "MML/LRM";
        ammoType.setInternalName("IS Ammo MML-5 LRM");
        ammoType.addLookupName("ISMML5 LRM Ammo");
        ammoType.addLookupName("IS MML-5 LRM Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 45;
        ammoType.shots = 24;
        ammoType.bv = 6.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 0x28L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISMML5SRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 5 SRM Ammo";
        ammoType.shortName = "MML/SRM";
        ammoType.setInternalName("IS Ammo MML-5 SRM");
        ammoType.addLookupName("ISMML5 SRM Ammo");
        ammoType.addLookupName("IS MML-5 SRM Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 45;
        ammoType.shots = 20;
        ammoType.bv = 6.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createISMML7LRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 7 LRM Ammo";
        ammoType.shortName = "MML/LRM";
        ammoType.setInternalName("IS Ammo MML-7 LRM");
        ammoType.addLookupName("ISMML7 LRM Ammo");
        ammoType.addLookupName("IS MML-7 LRM Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 45;
        ammoType.shots = 17;
        ammoType.bv = 8.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 0x28L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISMML7SRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 7 SRM Ammo";
        ammoType.shortName = "MML/SRM";
        ammoType.setInternalName("IS Ammo MML-7 SRM");
        ammoType.addLookupName("ISMML7 SRM Ammo");
        ammoType.addLookupName("IS MML-7 SRM Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 7;
        ammoType.ammoType = 45;
        ammoType.shots = 14;
        ammoType.bv = 8.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createISMML9LRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 9 LRM Ammo";
        ammoType.shortName = "MML/LRM";
        ammoType.setInternalName("IS Ammo MML-9 LRM");
        ammoType.addLookupName("ISMML9 LRM Ammo");
        ammoType.addLookupName("IS MML-9 LRM Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 45;
        ammoType.shots = 13;
        ammoType.bv = 11.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 0x28L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISMML9SRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MML 9 SRM Ammo";
        ammoType.shortName = "MML/SRM";
        ammoType.setInternalName("IS Ammo MML-9 SRM");
        ammoType.addLookupName("ISMML9 SRM Ammo");
        ammoType.addLookupName("IS MML-9 SRM Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 9;
        ammoType.ammoType = 45;
        ammoType.shots = 11;
        ammoType.bv = 11.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createCLATM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 Ammo";
        ammoType.shortName = "ATM";
        ammoType.setInternalName("Clan Ammo ATM-3");
        ammoType.addLookupName("CLATM3 Ammo");
        ammoType.addLookupName("Clan ATM-3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 28;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM3ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 ER Ammo";
        ammoType.shortName = "ATM ER";
        ammoType.setInternalName("Clan Ammo ATM-3 ER");
        ammoType.addLookupName("CLATM3 ER Ammo");
        ammoType.addLookupName("Clan ATM-3 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 28;
        ammoType.munitionType = 128L;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM3HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 HE Ammo";
        ammoType.shortName = "ATM HE";
        ammoType.setInternalName("Clan Ammo ATM-3 HE");
        ammoType.addLookupName("CLATM3 HE Ammo");
        ammoType.addLookupName("Clan ATM-3 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 3;
        ammoType.ammoType = 28;
        ammoType.munitionType = 256L;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createCLATM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 Ammo";
        ammoType.shortName = "ATM";
        ammoType.setInternalName("Clan Ammo ATM-6");
        ammoType.addLookupName("CLATM6 Ammo");
        ammoType.addLookupName("Clan ATM-6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 28;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM6ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 ER Ammo";
        ammoType.shortName = "ATM ER";
        ammoType.setInternalName("Clan Ammo ATM-6 ER");
        ammoType.addLookupName("CLATM6 ER Ammo");
        ammoType.addLookupName("Clan ATM-6 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 28;
        ammoType.munitionType = 128L;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM6HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 HE Ammo";
        ammoType.shortName = "ATM HE";
        ammoType.setInternalName("Clan Ammo ATM-6 HE");
        ammoType.addLookupName("CLATM6 HE Ammo");
        ammoType.addLookupName("Clan ATM-6 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 6;
        ammoType.ammoType = 28;
        ammoType.munitionType = 256L;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createCLATM9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 Ammo";
        ammoType.shortName = "ATM";
        ammoType.setInternalName("Clan Ammo ATM-9");
        ammoType.addLookupName("CLATM9 Ammo");
        ammoType.addLookupName("Clan ATM-9 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 9;
        ammoType.ammoType = 28;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM9ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 ER Ammo";
        ammoType.shortName = "ATM ER";
        ammoType.setInternalName("Clan Ammo ATM-9 ER");
        ammoType.addLookupName("CLATM9 ER Ammo");
        ammoType.addLookupName("Clan ATM-9 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 28;
        ammoType.munitionType = 128L;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM9HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 HE Ammo";
        ammoType.shortName = "ATM HE";
        ammoType.setInternalName("Clan Ammo ATM-9 HE");
        ammoType.addLookupName("CLATM9 HE Ammo");
        ammoType.addLookupName("Clan ATM-9 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 9;
        ammoType.ammoType = 28;
        ammoType.munitionType = 256L;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createCLATM12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 Ammo";
        ammoType.shortName = "ATM";
        ammoType.setInternalName("Clan Ammo ATM-12");
        ammoType.addLookupName("CLATM12 Ammo");
        ammoType.addLookupName("Clan ATM-12 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 12;
        ammoType.ammoType = 28;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM12ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 ER Ammo";
        ammoType.shortName = "ATM ER";
        ammoType.setInternalName("Clan Ammo ATM-12 ER");
        ammoType.addLookupName("CLATM12 ER Ammo");
        ammoType.addLookupName("Clan ATM-12 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 28;
        ammoType.munitionType = 128L;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createCLATM12HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 HE Ammo";
        ammoType.shortName = "ATM HE";
        ammoType.setInternalName("Clan Ammo ATM-12 HE");
        ammoType.addLookupName("CLATM12 HE Ammo");
        ammoType.addLookupName("Clan ATM-12 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 12;
        ammoType.ammoType = 28;
        ammoType.munitionType = 256L;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    private static AmmoType createCLStreakLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Streak LRM 5 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak LRM 5 Ammo");
        ammoType.addLookupName("CLStreakLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 31;
        ammoType.shots = 24;
        ammoType.bv = 11.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    private static AmmoType createCLStreakLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Streak LRM 10 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak LRM 10 Ammo");
        ammoType.addLookupName("CLStreakLRM10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 31;
        ammoType.shots = 12;
        ammoType.bv = 22.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    private static AmmoType createCLStreakLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Streak LRM 15 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak LRM 15 Ammo");
        ammoType.addLookupName("CLStreakLRM15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 31;
        ammoType.shots = 8;
        ammoType.bv = 32.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    private static AmmoType createCLStreakLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Streak LRM 20 Ammo";
        ammoType.shortName = "Streak";
        ammoType.setInternalName("Clan Streak LRM 20 Ammo");
        ammoType.addLookupName("CLStreakLRM20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 31;
        ammoType.shots = 6;
        ammoType.bv = 43.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    private static AmmoType createBASRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 2 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM2 Ammo");
        ammoType.addLookupName("BASRM-2 Ammo");
        ammoType.addLookupName("BASRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 20.0;
        return ammoType;
    }

    private static AmmoType createBAMicroBombAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Micro Bomb Ammo";
        ammoType.shortName = "Micro Bomb";
        ammoType.setInternalName("BA-Micro Bomb Ammo");
        ammoType.addLookupName("BAMicroBomb Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 25;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createCLTorpedoLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Torpedo/LRM 5 Ammo";
        ammoType.shortName = "Torpedo/LRM";
        ammoType.setInternalName("Clan Torpedo/LRM5 Ammo");
        ammoType.addLookupName("CLTorpedoLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 26;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 7.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    private static AmmoType createBACompactNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "Compact Narc Ammo";
        ammoType.shortName = "Compact Narc";
        ammoType.setInternalName("BA-Compact Narc Ammo");
        ammoType.addLookupName("BACompactNarc Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 13;
        ammoType.flags |= 0x12L;
        ammoType.shots = 2;
        ammoType.explosive = false;
        ammoType.bv = 0.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createBAMineLauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Mine Launcher Ammo";
        ammoType.shortName = "Mine";
        ammoType.setInternalName("BA-Mine Launcher Ammo");
        ammoType.addLookupName("BAMineLauncher Ammo");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 27;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createCLPROHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.shortName = "Heavy Machine Gun";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLHeavyMG Ammo");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 5L;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        return ammoType;
    }

    private static AmmoType createCLPROMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Machine Gun Ammo";
        ammoType.shortName = "Machine Gun";
        ammoType.setInternalName("Clan Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLMG Ammo");
        ammoType.addLookupName("Clan Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 5L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    private static AmmoType createCLPROLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.shortName = "Light Machine Gun";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLLightMG Ammo");
        ammoType.addLookupName("Clan Light Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 5L;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    private static AmmoType createISArrowIVAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Arrow IV Ammo";
        ammoType.shortName = "Arrow IV";
        ammoType.setInternalName("ISArrowIVAmmo");
        ammoType.addLookupName("ISArrowIV Ammo");
        ammoType.addLookupName("IS Ammo Arrow");
        ammoType.addLookupName("IS Arrow IV Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 15;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLArrowIVAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Arrow IV Ammo";
        ammoType.shortName = "Arrow IV";
        ammoType.setInternalName("CLArrowIVAmmo");
        ammoType.addLookupName("CLArrowIV Ammo");
        ammoType.addLookupName("Clan Ammo Arrow");
        ammoType.addLookupName("Clan Arrow IV Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 15;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLLongTomAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Long Tom Ammo";
        ammoType.shortName = "Long Tom";
        ammoType.setInternalName("CLLongTomAmmo");
        ammoType.addLookupName("CLLongTom Ammo");
        ammoType.addLookupName("CLLongTomArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Long Tom");
        ammoType.addLookupName("Clan Long Tom Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 25;
        ammoType.ammoType = 16;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLSniperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Sniper Ammo";
        ammoType.shortName = "Sniper";
        ammoType.setInternalName("CLSniperAmmo");
        ammoType.addLookupName("CLSniper Ammo");
        ammoType.addLookupName("CLSniperArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Sniper");
        ammoType.addLookupName("Clan Sniper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 17;
        ammoType.shots = 10;
        ammoType.bv = 5.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    private static AmmoType createCLThumperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Thumper Ammo";
        ammoType.shortName = "Thumper";
        ammoType.setInternalName("CLThumperAmmo");
        ammoType.addLookupName("CLThumper Ammo");
        ammoType.addLookupName("CLThumperArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Thumper");
        ammoType.addLookupName("Clan Thumper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 18;
        ammoType.shots = 20;
        ammoType.bv = 3.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    private static AmmoType createBAISLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA LRM 1 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS BA Ammo LRM-1");
        ammoType.addLookupName("BAISLRM1 Ammo");
        ammoType.addLookupName("BAISLRM1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.kgPerShot = 8.3;
        return ammoType;
    }

    private static AmmoType createBAISLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA LRM 2 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS BA Ammo LRM-2");
        ammoType.addLookupName("BAISLRM2 Ammo");
        ammoType.addLookupName("BAISLRM2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 3.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.kgPerShot = 16.6;
        return ammoType;
    }

    private static AmmoType createBAISLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA LRM 3 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS BA Ammo LRM-3");
        ammoType.addLookupName("BAISLRM3 Ammo");
        ammoType.addLookupName("BAISLRM3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 4.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.kgPerShot = 25.0;
        return ammoType;
    }

    private static AmmoType createBAISLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA LRM 4 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS BA Ammo LRM-4");
        ammoType.addLookupName("BAISLRM4 Ammo");
        ammoType.addLookupName("BAISLRM4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 5.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.kgPerShot = 33.3;
        return ammoType;
    }

    private static AmmoType createBAISLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA LRM 5 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("IS BA Ammo LRM-5");
        ammoType.addLookupName("BAISLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 6.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        ammoType.kgPerShot = 41.5;
        return ammoType;
    }

    private static AmmoType createBACLLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 1 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("BACL Ammo LRM-1");
        ammoType.addLookupName("BACLLRM1 Ammo");
        ammoType.addLookupName("BACL LRM 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 8.3;
        return ammoType;
    }

    private static AmmoType createBACLLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 2 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("BACL Ammo LRM-2");
        ammoType.addLookupName("BACLLRM2 Ammo");
        ammoType.addLookupName("BACL LRM 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 16.6;
        return ammoType;
    }

    private static AmmoType createBACLLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 3 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("BACL Ammo LRM-3");
        ammoType.addLookupName("BACLLRM3 Ammo");
        ammoType.addLookupName("BACL LRM 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 5.0;
        ammoType.kgPerShot = 25.0;
        return ammoType;
    }

    private static AmmoType createBACLLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 4 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("BACL Ammo LRM-4");
        ammoType.addLookupName("BACLLRM4 Ammo");
        ammoType.addLookupName("BACL LRM 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 33.3;
        return ammoType;
    }

    private static AmmoType createBACLLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 5 Ammo";
        ammoType.shortName = "LRM";
        ammoType.setInternalName("BACL Ammo LRM-5");
        ammoType.addLookupName("BACLLRM5 Ammo");
        ammoType.addLookupName("BACL LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 7.0;
        ammoType.kgPerShot = 41.5;
        return ammoType;
    }

    private static AmmoType createBASRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 6 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM6 Ammo");
        ammoType.addLookupName("BASRM-6 Ammo");
        ammoType.addLookupName("BASRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 7.0;
        ammoType.kgPerShot = 60.0;
        return ammoType;
    }

    private static AmmoType createBASRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 5 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM5 Ammo");
        ammoType.addLookupName("BASRM-5 Ammo");
        ammoType.addLookupName("BASRM5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 50.0;
        return ammoType;
    }

    private static AmmoType createBASRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 4 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM4 Ammo");
        ammoType.addLookupName("BASRM-4 Ammo");
        ammoType.addLookupName("BASRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 5.0;
        ammoType.kgPerShot = 40.0;
        return ammoType;
    }

    private static AmmoType createBASRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 3 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM3 Ammo");
        ammoType.addLookupName("BASRM-3 Ammo");
        ammoType.addLookupName("BASRM3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 4.0;
        ammoType.kgPerShot = 30.0;
        return ammoType;
    }

    private static AmmoType createBASRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = -2;
        ammoType.name = "BA SRM 1 Ammo";
        ammoType.shortName = "SRM";
        ammoType.setInternalName("BA-SRM1 Ammo");
        ammoType.addLookupName("BASRM-1 Ammo");
        ammoType.addLookupName("BASRM1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 9;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createISMRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 1 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 1 Ammo");
        ammoType.addLookupName("ISMRM1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 12;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 1.0;
        ammoType.kgPerShot = 5.0;
        return ammoType;
    }

    private static AmmoType createISMRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 2 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 2 Ammo");
        ammoType.addLookupName("ISMRM2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 12;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createISMRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 3 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 3 Ammo");
        ammoType.addLookupName("ISMRM3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 12;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 15.0;
        return ammoType;
    }

    private static AmmoType createISMRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 4 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 4 Ammo");
        ammoType.addLookupName("ISMRM4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 12;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 3.0;
        ammoType.kgPerShot = 20.0;
        return ammoType;
    }

    private static AmmoType createISMRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 5 Ammo";
        ammoType.shortName = "MRM";
        ammoType.setInternalName("IS MRM 5 Ammo");
        ammoType.addLookupName("ISMRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 12;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 4.0;
        ammoType.kgPerShot = 25.0;
        return ammoType;
    }

    private static AmmoType createBARL1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 1 Ammo";
        ammoType.setInternalName("BARL1 Ammo");
        ammoType.addLookupName("LAW Launcher Ammo");
        ammoType.addLookupName("IS Ammo LAW Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 29;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createISBATaserAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "BA Taser Ammo";
        ammoType.setInternalName(ammoType.name);
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 75;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createBARL2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 2 Ammo";
        ammoType.setInternalName("BARL2 Ammo");
        ammoType.addLookupName("LAW 2 Launcher Ammo");
        ammoType.addLookupName("IS Ammo LAW-2 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 29;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createBARL3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 3 Ammo";
        ammoType.setInternalName("BARL3 Ammo");
        ammoType.addLookupName("LAW 3 Launcher Ammo");
        ammoType.addLookupName("IS Ammo LAW-3 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 29;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createBARL4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 4 Ammo";
        ammoType.setInternalName("BARL4 Ammo");
        ammoType.addLookupName("LAW 4 Launcher Ammo");
        ammoType.addLookupName("IS Ammo LAW-4 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 29;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createBARL5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 5 Ammo";
        ammoType.setInternalName("BARL5 Ammo");
        ammoType.addLookupName("LAW 5 Launcher Ammo");
        ammoType.addLookupName("IS Ammo LAW-5 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 29;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 1 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-1 Ammo");
        ammoType.addLookupName("BAAdvanced SRM1 Ammo");
        ammoType.addLookupName("BAAdvancedSRM1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 2.0;
        ammoType.kgPerShot = 10.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 2 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-2 Ammo");
        ammoType.addLookupName("BA-Advanced SRM-2 Ammo OS");
        ammoType.addLookupName("BAAdvancedSRM2 Ammo");
        ammoType.addLookupName("BAAdvanced SRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 4.0;
        ammoType.kgPerShot = 20.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 3 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-3 Ammo");
        ammoType.addLookupName("BAAdvanced SRM3 Ammo");
        ammoType.addLookupName("BAAdvancedSRM3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 6.0;
        ammoType.kgPerShot = 30.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 4 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-4 Ammo");
        ammoType.addLookupName("BAAdvanced SRM4 Ammo");
        ammoType.addLookupName("BAAdvancedSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 8.0;
        ammoType.kgPerShot = 40.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 5 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-5 Ammo");
        ammoType.addLookupName("BAAdvancedSRM5 Ammo");
        ammoType.addLookupName("BAAdvanced SRM5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 10.0;
        ammoType.kgPerShot = 50.0;
        return ammoType;
    }

    private static AmmoType createAdvancedSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 6 Ammo";
        ammoType.shortName = "Advanced SRM";
        ammoType.setInternalName("BA-Advanced SRM-6 Ammo");
        ammoType.addLookupName("BAAdvanced SRM6 Ammo");
        ammoType.addLookupName("BAAdvancedSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 24;
        ammoType.flags |= 2L;
        ammoType.shots = 1;
        ammoType.bv = 12.0;
        ammoType.kgPerShot = 60.0;
        return ammoType;
    }

    private static AmmoType createISLAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAC/2 Ammo";
        ammoType.shortName = "Light AC";
        ammoType.setInternalName("IS Ammo LAC/2");
        ammoType.addLookupName("ISLAC2 Ammo");
        ammoType.addLookupName("IS Light Autocannon/2 Ammo");
        ammoType.addLookupName("Light AC/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 34;
        ammoType.shots = 45;
        ammoType.bv = 4.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISLAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAC/5 Ammo";
        ammoType.shortName = "Light AC";
        ammoType.setInternalName("IS Ammo LAC/5");
        ammoType.addLookupName("ISLAC5 Ammo");
        ammoType.addLookupName("IS Light Autocannon/5 Ammo");
        ammoType.addLookupName("Light AC/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 34;
        ammoType.shots = 20;
        ammoType.bv = 8.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    private static AmmoType createISLAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LAC/10 Ammo";
        ammoType.shortName = "Light AC";
        ammoType.setInternalName("IS Ammo LAC/10");
        ammoType.addLookupName("ISLAC10 Ammo");
        ammoType.addLookupName("IS Light Autocannon/10 Ammo");
        ammoType.addLookupName("Light AC/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 34;
        ammoType.shots = 10;
        ammoType.bv = 9.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISLAC20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "LAC/20 Ammo";
        ammoType.shortName = "Light AC";
        ammoType.setInternalName("IS Ammo LAC/20");
        ammoType.addLookupName("ISLAC20 Ammo");
        ammoType.addLookupName("IS Light Autocannon/20 Ammo");
        ammoType.addLookupName("Light AC/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 34;
        ammoType.shots = 5;
        ammoType.bv = 15.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISHVAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "HVAC/2 Ammo";
        ammoType.shortName = "Hyper Velocity AC";
        ammoType.setInternalName("IS Ammo HVAC/2");
        ammoType.addLookupName("ISHVAC2 Ammo");
        ammoType.addLookupName("IS Hyper Velocity Autocannon/2 Ammo");
        ammoType.addLookupName("Hyper Velocity AC/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 66;
        ammoType.shots = 30;
        ammoType.bv = 7.0;
        ammoType.cost = 3000.0;
        return ammoType;
    }

    private static AmmoType createISHVAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "HVAC/5 Ammo";
        ammoType.shortName = "Hyper Velocity AC";
        ammoType.setInternalName("IS Ammo HVAC/5");
        ammoType.addLookupName("ISHVAC5 Ammo");
        ammoType.addLookupName("IS Hyper Velocity Autocannon/5 Ammo");
        ammoType.addLookupName(" Hyper Velocity AC/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 66;
        ammoType.shots = 15;
        ammoType.bv = 14.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISHVAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "HVAC/10 Ammo";
        ammoType.shortName = "Hyper Velocity AC";
        ammoType.setInternalName("IS Ammo HVAC/10");
        ammoType.addLookupName("ISHVAC10 Ammo");
        ammoType.addLookupName("IS Hyper Velocity Autocannon/10 Ammo");
        ammoType.addLookupName("Hyper Velocity AC/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 66;
        ammoType.shots = 8;
        ammoType.bv = 20.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISHeavyFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Heavy Flamer Ammo";
        ammoType.shortName = "Heavy Flamer";
        ammoType.setInternalName("IS Heavy Flamer Ammo");
        ammoType.addLookupName("IS Ammo Heavy Flamer");
        ammoType.addLookupName("ISHeavyFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 35;
        ammoType.shots = 10;
        ammoType.bv = 3.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    private static AmmoType createISCoolantPod() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "IS Coolant Pod";
        ammoType.shortName = "Coolant Pod";
        ammoType.setInternalName(ammoType.name);
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 36;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 50000.0;
        String[] stringArray = new String[]{"safe", "efficient", "off", "dump"};
        ammoType.setModes(stringArray);
        ammoType.setInstantModeSwitch(true);
        return ammoType;
    }

    private static AmmoType createCLCoolantPod() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 8;
        ammoType.name = "Clan Coolant Pod";
        ammoType.shortName = "Coolant Pod";
        ammoType.setInternalName(ammoType.name);
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 36;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 50000.0;
        String[] stringArray = new String[]{"safe", "efficient", "off", "dump"};
        ammoType.setModes(stringArray);
        ammoType.setInstantModeSwitch(true);
        return ammoType;
    }

    private static AmmoType createISExtendedLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "ExtendedLRM 5 Ammo";
        ammoType.shortName = "Extended LRM";
        ammoType.setInternalName("IS Ammo ExtendedLRM-5");
        ammoType.addLookupName("ISExtendedLRM5 Ammo");
        ammoType.addLookupName("IS ExtendedLRM 5 Ammo");
        ammoType.addLookupName("ELRM-5 Ammo (THB)");
        ammoType.addLookupName("ELRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 37;
        ammoType.shots = 18;
        ammoType.bv = 7.0;
        ammoType.cost = 90000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISExtendedLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "ExtendedLRM 10 Ammo";
        ammoType.shortName = "Extended LRM";
        ammoType.setInternalName("IS Ammo ExtendedLRM-10");
        ammoType.addLookupName("ISExtendedLRM10 Ammo");
        ammoType.addLookupName("IS ExtendedLRM 10 Ammo");
        ammoType.addLookupName("ELRM-10 Ammo (THB)");
        ammoType.addLookupName("ELRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 37;
        ammoType.shots = 9;
        ammoType.bv = 15.0;
        ammoType.cost = 90000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISExtendedLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "ExtendedLRM 15 Ammo";
        ammoType.shortName = "Extended LRM";
        ammoType.setInternalName("IS Ammo ExtendedLRM-15");
        ammoType.addLookupName("ISExtendedLRM15 Ammo");
        ammoType.addLookupName("IS ExtendedLRM 15 Ammo");
        ammoType.addLookupName("ELRM-15 Ammo (THB)");
        ammoType.addLookupName("ELRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 37;
        ammoType.shots = 6;
        ammoType.bv = 22.0;
        ammoType.cost = 90000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISExtendedLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "ExtendedLRM 20 Ammo";
        ammoType.shortName = "Extended LRM";
        ammoType.setInternalName("IS Ammo ExtendedLRM-20");
        ammoType.addLookupName("ISExtendedLRM20 Ammo");
        ammoType.addLookupName("IS ExtendedLRM 20 Ammo");
        ammoType.addLookupName("ELRM-20 Ammo (THB)");
        ammoType.addLookupName("ELRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 37;
        ammoType.shots = 4;
        ammoType.bv = 30.0;
        ammoType.cost = 90000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISThunderbolt5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Thunderbolt 5 Ammo";
        ammoType.shortName = "Thunderbolt";
        ammoType.setInternalName("IS Ammo Thunderbolt-5");
        ammoType.addLookupName("ISThunderbolt5 Ammo");
        ammoType.addLookupName("IS Thunderbolt 5 Ammo");
        ammoType.addLookupName("ISTBolt5 Ammo");
        ammoType.damagePerShot = 5;
        ammoType.rackSize = 1;
        ammoType.ammoType = 49;
        ammoType.shots = 12;
        ammoType.bv = 8.0;
        ammoType.cost = 50000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISThunderbolt10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Thunderbolt 10 Ammo";
        ammoType.shortName = "Thunderbolt";
        ammoType.setInternalName("IS Ammo Thunderbolt-10");
        ammoType.addLookupName("ISThunderbolt10 Ammo");
        ammoType.addLookupName("IS Thunderbolt 10 Ammo");
        ammoType.addLookupName("ISTBolt10 Ammo");
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 50;
        ammoType.shots = 6;
        ammoType.bv = 16.0;
        ammoType.cost = 50000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISThunderbolt15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Thunderbolt 15 Ammo";
        ammoType.shortName = "Thunderbolt";
        ammoType.setInternalName("IS Ammo Thunderbolt-15");
        ammoType.addLookupName("ISThunderbolt15 Ammo");
        ammoType.addLookupName("IS Thunderbolt 15 Ammo");
        ammoType.addLookupName("ISTBolt15 Ammo");
        ammoType.damagePerShot = 15;
        ammoType.rackSize = 1;
        ammoType.ammoType = 51;
        ammoType.shots = 4;
        ammoType.bv = 26.0;
        ammoType.cost = 50000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISThunderbolt20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Thunderbolt 20 Ammo";
        ammoType.shortName = "Thunderbolt";
        ammoType.setInternalName("IS Ammo Thunderbolt-20");
        ammoType.addLookupName("ISThunderbolt20 Ammo");
        ammoType.addLookupName("IS Thunderbolt 20 Ammo");
        ammoType.addLookupName("ISTBolt20 Ammo");
        ammoType.damagePerShot = 20;
        ammoType.rackSize = 1;
        ammoType.ammoType = 52;
        ammoType.shots = 3;
        ammoType.bv = 35.0;
        ammoType.cost = 50000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISRailGunAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Rail Gun Ammo";
        ammoType.shortName = "Rail Gun";
        ammoType.setInternalName("ISRailGun Ammo");
        ammoType.addLookupName("IS Rail Gun Ammo");
        ammoType.damagePerShot = 22;
        ammoType.explosive = false;
        ammoType.ammoType = 48;
        ammoType.shots = 5;
        ammoType.bv = 51.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    private static AmmoType createISMagshotGRAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Magshot GR Ammo";
        ammoType.shortName = "Magshot";
        ammoType.setInternalName("ISMagshotGR Ammo");
        ammoType.addLookupName("IS Magshot GR Ammo");
        ammoType.damagePerShot = 2;
        ammoType.explosive = false;
        ammoType.ammoType = 39;
        ammoType.shots = 50;
        ammoType.bv = 2.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createCLMagshotGRAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Magshot GR Ammo";
        ammoType.shortName = "Magshot";
        ammoType.setInternalName("CLMagshotGR Ammo");
        ammoType.addLookupName("Clan Magshot GR Ammo");
        ammoType.damagePerShot = 2;
        ammoType.explosive = false;
        ammoType.ammoType = 39;
        ammoType.shots = 50;
        ammoType.bv = 2.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    private static AmmoType createCLAPGaussRifleAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AP Gauss Rifle Ammo";
        ammoType.shortName = "AP Gauss";
        ammoType.setInternalName("CLAPGaussRifle Ammo");
        ammoType.addLookupName("Clan AP Gauss Rifle Ammo");
        ammoType.addLookupName("Clan Anti-Personnel Gauss Rifle Ammo");
        ammoType.damagePerShot = 3;
        ammoType.explosive = false;
        ammoType.ammoType = 38;
        ammoType.shots = 40;
        ammoType.bv = 3.0;
        ammoType.cost = 1000.0;
        ammoType.kgPerShot = 40.0;
        return ammoType;
    }

    private static AmmoType createISPXLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Phoenix LRM 5 Ammo";
        ammoType.shortName = "Phoenix LRM";
        ammoType.setInternalName("ISPhoenixLRM5 Ammo");
        ammoType.addLookupName("ISPhoenix LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 40;
        ammoType.shots = 12;
        ammoType.bv = 7.0;
        ammoType.cost = 60000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISPXLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Phoenix LRM 10 Ammo";
        ammoType.shortName = "Phoenix LRM";
        ammoType.setInternalName("ISPhoenixLRM10 Ammo");
        ammoType.addLookupName("ISPhoenix LRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 40;
        ammoType.shots = 6;
        ammoType.bv = 14.0;
        ammoType.cost = 60000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISPXLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Phoenix LRM 15 Ammo";
        ammoType.shortName = "Phoenix LRM";
        ammoType.setInternalName("ISPhoenixLRM15 Ammo");
        ammoType.addLookupName("ISPhoenix LRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 40;
        ammoType.shots = 4;
        ammoType.bv = 21.0;
        ammoType.cost = 60000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISPXLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Phoenix LRM 20 Ammo";
        ammoType.shortName = "Phoenix LRM";
        ammoType.setInternalName("ISPhoenixLRM20 Ammo");
        ammoType.addLookupName("ISPhoenix LRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 40;
        ammoType.shots = 3;
        ammoType.bv = 28.0;
        ammoType.cost = 60000.0;
        ammoType.flags |= 8L;
        ammoType.setModes(new String[]{"", "HotLoad"});
        return ammoType;
    }

    private static AmmoType createISHawkSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Hawk SRM 2 Ammo";
        ammoType.shortName = "Hawk SRM";
        ammoType.setInternalName("ISHawkSRM2 Ammo");
        ammoType.addLookupName("IS Hawk SRM 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 41;
        ammoType.shots = 25;
        ammoType.bv = 4.0;
        ammoType.cost = 52000.0;
        return ammoType;
    }

    private static AmmoType createISHawkSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Hawk SRM 4 Ammo";
        ammoType.shortName = "Hawk SRM";
        ammoType.setInternalName("ISHawkSRM4 Ammo");
        ammoType.addLookupName("IS Hawk SRM 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 41;
        ammoType.shots = 13;
        ammoType.bv = 6.0;
        ammoType.cost = 52000.0;
        return ammoType;
    }

    private static AmmoType createISHawkSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Hawk SRM 6 Ammo";
        ammoType.shortName = "Hawk SRM";
        ammoType.setInternalName("ISHawkSRM6 Ammo");
        ammoType.addLookupName("IS Hawk SRM 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 41;
        ammoType.shots = 8;
        ammoType.bv = 10.0;
        ammoType.cost = 52000.0;
        return ammoType;
    }

    private static AmmoType createISStreakMRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Streak MRM 10 Ammo";
        ammoType.shortName = "Streak MRM";
        ammoType.setInternalName("IS Streak MRM 10 Ammo");
        ammoType.addLookupName("ISStreakMRM10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 42;
        ammoType.shots = 24;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISStreakMRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Streak MRM 20 Ammo";
        ammoType.shortName = "Streak MRM";
        ammoType.setInternalName("IS Streak MRM 20 Ammo");
        ammoType.addLookupName("ISStreakMRM20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 42;
        ammoType.shots = 12;
        ammoType.bv = 22.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISStreakMRM30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Streak MRM 30 Ammo";
        ammoType.shortName = "Streak MRM";
        ammoType.setInternalName("IS Streak MRM 30 Ammo");
        ammoType.addLookupName("ISStreakMRM30 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 42;
        ammoType.shots = 8;
        ammoType.bv = 33.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISStreakMRM40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 9;
        ammoType.name = "Streak MRM 40 Ammo";
        ammoType.shortName = "Streak MRM";
        ammoType.setInternalName("IS Streak MRM 40 Ammo");
        ammoType.addLookupName("ISStreakMRM40 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 42;
        ammoType.shots = 6;
        ammoType.bv = 44.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISMPodAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "MPod Ammo";
        ammoType.setInternalName("IS M-Pod Ammo");
        ammoType.addLookupName("IS MPod Ammo");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 43;
        ammoType.munitionType = 1L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 0.0;
        ammoType.tonnage = 0.0f;
        return ammoType;
    }

    private static AmmoType createCLMPodAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "MPod Ammo";
        ammoType.setInternalName("Clan M-Pod Ammo");
        ammoType.addLookupName("Clan MPod Ammo");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 43;
        ammoType.munitionType = 1L;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 0.0;
        ammoType.tonnage = 0.0f;
        return ammoType;
    }

    private static AmmoType createISSBGaussRifleAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Silver Bullet Gauss Ammo";
        ammoType.shortName = "Silver Bullet";
        ammoType.setInternalName("Silver Bullet Gauss Ammo");
        ammoType.addLookupName("IS SBGauss Rifle Ammo");
        ammoType.addLookupName("ISSBGauss Ammo");
        ammoType.addLookupName("ISSBGaussRifleAmmo");
        ammoType.explosive = false;
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 47;
        ammoType.munitionType = 1L;
        ammoType.shots = 8;
        ammoType.bv = 25.0;
        ammoType.cost = 25000.0;
        ammoType.toHitModifier = -1;
        return ammoType;
    }

    private static AmmoType createCLHAG20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "HAG/20 Ammo";
        ammoType.shortName = "HAG";
        ammoType.setInternalName(ammoType.name);
        ammoType.addLookupName("CLHAG20 Ammo");
        ammoType.addLookupName("Clan HAG 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 44;
        ammoType.shots = 6;
        ammoType.bv = 33.0;
        ammoType.cost = 30000.0;
        ammoType.explosive = false;
        return ammoType;
    }

    private static AmmoType createCLHAG30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "HAG/30 Ammo";
        ammoType.shortName = "HAG";
        ammoType.setInternalName(ammoType.name);
        ammoType.addLookupName("CLHAG30 Ammo");
        ammoType.addLookupName("Clan HAG 30 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 44;
        ammoType.shots = 4;
        ammoType.bv = 50.0;
        ammoType.cost = 30000.0;
        ammoType.explosive = false;
        return ammoType;
    }

    private static AmmoType createCLHAG40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "HAG/40 Ammo";
        ammoType.shortName = "HAG";
        ammoType.setInternalName(ammoType.name);
        ammoType.addLookupName("CLHAG40 Ammo");
        ammoType.addLookupName("Clan HAG 40 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 44;
        ammoType.shots = 3;
        ammoType.bv = 67.0;
        ammoType.cost = 30000.0;
        ammoType.explosive = false;
        return ammoType;
    }

    private static AmmoType createCLPlasmaCannonAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Plasma Cannon Ammo";
        ammoType.shortName = "Plasma Cannon";
        ammoType.setInternalName("CLPlasmaCannonAmmo");
        ammoType.addLookupName("CLPlasmaCannon Ammo");
        ammoType.damagePerShot = 0;
        ammoType.rackSize = 2;
        ammoType.ammoType = 46;
        ammoType.shots = 10;
        ammoType.bv = 21.0;
        ammoType.cost = 30000.0;
        ammoType.explosive = false;
        return ammoType;
    }

    private static AmmoType createISPlasmaRifleAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Plasma Rifle Ammo";
        ammoType.shortName = "Plasma Rifle";
        ammoType.setInternalName("ISPlasmaRifleAmmo");
        ammoType.addLookupName("ISPlasmaRifle Ammo");
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 46;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 30000.0;
        ammoType.explosive = false;
        return ammoType;
    }

    private static AmmoType createNAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/10 Ammo";
        ammoType.setInternalName("Ammo NAC/10");
        ammoType.addLookupName("NAC10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 238.0;
        ammoType.cost = 30000.0;
        ammoType.ammoRatio = 0.2;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createNAC20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/20 Ammo";
        ammoType.setInternalName("Ammo NAC/20");
        ammoType.addLookupName("NAC20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 475.0;
        ammoType.cost = 60000.0;
        ammoType.ammoRatio = 0.4;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createNAC25Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/25 Ammo";
        ammoType.setInternalName("Ammo NAC/25");
        ammoType.addLookupName("NAC25 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 25;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 594.0;
        ammoType.cost = 75000.0;
        ammoType.ammoRatio = 0.6;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createNAC30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/30 Ammo";
        ammoType.setInternalName("Ammo NAC/30");
        ammoType.addLookupName("NAC30 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 713.0;
        ammoType.cost = 90000.0;
        ammoType.ammoRatio = 0.8;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createNAC35Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/35 Ammo";
        ammoType.setInternalName("Ammo NAC/35");
        ammoType.addLookupName("NAC35 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 35;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 620.0;
        ammoType.cost = 105000.0;
        ammoType.ammoRatio = 1.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createNAC40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "NAC/40 Ammo";
        ammoType.setInternalName("Ammo NAC/40");
        ammoType.addLookupName("NAC40 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 53;
        ammoType.shots = 1;
        ammoType.bv = 708.0;
        ammoType.cost = 120000.0;
        ammoType.ammoRatio = 1.2;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createLightNGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Light N-Gauss Ammo";
        ammoType.setInternalName("Ammo Light N-Gauss");
        ammoType.addLookupName("LightNGauss Ammo");
        ammoType.damagePerShot = 15;
        ammoType.ammoType = 54;
        ammoType.shots = 1;
        ammoType.bv = 360.0;
        ammoType.cost = 45000.0;
        ammoType.ammoRatio = 0.2;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createMediumNGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Medium N-Gauss Ammo";
        ammoType.setInternalName("Ammo Medium N-Gauss");
        ammoType.addLookupName("MediumNGauss Ammo");
        ammoType.damagePerShot = 25;
        ammoType.ammoType = 55;
        ammoType.shots = 1;
        ammoType.bv = 601.0;
        ammoType.cost = 75000.0;
        ammoType.ammoRatio = 0.4;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createHeavyNGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Heavy N-Gauss Ammo";
        ammoType.setInternalName("Ammo Heavy N-Gauss");
        ammoType.addLookupName("HeavyNGauss Ammo");
        ammoType.damagePerShot = 40;
        ammoType.ammoType = 56;
        ammoType.shots = 1;
        ammoType.bv = 721.0;
        ammoType.cost = 90000.0;
        ammoType.ammoRatio = 0.5;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createKrakenAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Kraken-T Ammo";
        ammoType.setInternalName("Ammo KrakenT");
        ammoType.addLookupName("KrakenT Ammo");
        ammoType.damagePerShot = 10;
        ammoType.ammoType = 60;
        ammoType.shots = 1;
        ammoType.bv = 288.0;
        ammoType.cost = 55000.0;
        ammoType.capital = true;
        ammoType.flags |= 0x400L;
        return ammoType;
    }

    private static AmmoType createKillerWhaleAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Killer Whale Ammo";
        ammoType.setInternalName("Ammo Killer Whale");
        ammoType.addLookupName("KillerWhale Ammo");
        ammoType.damagePerShot = 4;
        ammoType.ammoType = 57;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createKillerWhaleTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Killer Whale-T Ammo";
        ammoType.setInternalName("Ammo Killer Whale-T");
        ammoType.addLookupName("KillerWhaleT Ammo");
        ammoType.damagePerShot = 4;
        ammoType.ammoType = 57;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        ammoType.flags |= 0x400L;
        return ammoType;
    }

    private static AmmoType createSantaAnnaAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Santa Anna Ammo";
        ammoType.setInternalName("Ammo Santa Anna");
        ammoType.addLookupName("SantaAnna Ammo");
        ammoType.damagePerShot = 100;
        ammoType.ammoType = 57;
        ammoType.munitionType = 0x80000000000L;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.flags |= 0x200L;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createWhiteSharkAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "White Shark Ammo";
        ammoType.setInternalName("Ammo White Shark");
        ammoType.addLookupName("WhiteShark Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 58;
        ammoType.shots = 1;
        ammoType.bv = 72.0;
        ammoType.cost = 14000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createWhiteSharkTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "White Shark-T Ammo";
        ammoType.setInternalName("Ammo White Shark-T");
        ammoType.addLookupName("WhiteSharkT Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 58;
        ammoType.shots = 1;
        ammoType.bv = 72.0;
        ammoType.cost = 14000.0;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        ammoType.flags |= 0x400L;
        return ammoType;
    }

    private static AmmoType createBarracudaAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Barracuda Ammo";
        ammoType.setInternalName("Ammo Barracuda");
        ammoType.addLookupName("Barracuda Ammo");
        ammoType.damagePerShot = 2;
        ammoType.ammoType = 59;
        ammoType.shots = 1;
        ammoType.bv = 65.0;
        ammoType.cost = 8000.0;
        ammoType.toHitModifier = -2;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createBarracudaTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Barracuda-T Ammo";
        ammoType.setInternalName("Ammo Barracuda-T");
        ammoType.addLookupName("BarracudaT Ammo");
        ammoType.damagePerShot = 2;
        ammoType.ammoType = 59;
        ammoType.shots = 1;
        ammoType.bv = 65.0;
        ammoType.cost = 8000.0;
        ammoType.toHitModifier = -2;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        ammoType.flags |= 0x400L;
        return ammoType;
    }

    private static AmmoType createAR10BarracudaAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 Barracuda Ammo";
        ammoType.setInternalName("Ammo AR10 Barracuda");
        ammoType.addLookupName("AR10 Barracuda Ammo");
        ammoType.damagePerShot = 2;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 65.0;
        ammoType.cost = 8000.0;
        ammoType.flags |= 0x100L;
        ammoType.toHitModifier = -2;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createAR10KillerWhaleAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 Killer Whale Ammo";
        ammoType.setInternalName("Ammo AR10 Killer Whale");
        ammoType.addLookupName("AR10 KillerWhale Ammo");
        ammoType.damagePerShot = 4;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.flags |= 0x80L;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createAR10SantaAnnaAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 Santa Anna Ammo";
        ammoType.setInternalName("Ammo AR10 Santa Anna");
        ammoType.addLookupName("AR10 SantaAnna Ammo");
        ammoType.damagePerShot = 100;
        ammoType.ammoType = 61;
        ammoType.munitionType = 0x80000000000L;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.flags |= 0x280L;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createAR10WhiteSharkAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 White Shark Ammo";
        ammoType.setInternalName("Ammo AR10 White Shark");
        ammoType.addLookupName("AR10 WhiteShark Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 72.0;
        ammoType.cost = 14000.0;
        ammoType.flags |= 0x40L;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createAR10BarracudaTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 Barracuda-T Ammo";
        ammoType.setInternalName("Ammo AR10 Barracuda-T");
        ammoType.addLookupName("AR10 BarracudaT Ammo");
        ammoType.damagePerShot = 2;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 65.0;
        ammoType.cost = 8000.0;
        ammoType.flags |= 0x500L;
        ammoType.toHitModifier = -2;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        return ammoType;
    }

    private static AmmoType createAR10KillerWhaleTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 Killer Whale-T Ammo";
        ammoType.setInternalName("Ammo AR10 Killer Whale-T");
        ammoType.addLookupName("AR10 KillerWhaleT Ammo");
        ammoType.damagePerShot = 4;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 96.0;
        ammoType.cost = 20000.0;
        ammoType.flags |= 0x480L;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        return ammoType;
    }

    private static AmmoType createAR10WhiteSharkTAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AR10 White Shark-T Ammo";
        ammoType.setInternalName("Ammo AR10 White Shark-T");
        ammoType.addLookupName("AR10 WhiteSharkT Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 61;
        ammoType.shots = 1;
        ammoType.bv = 72.0;
        ammoType.cost = 14000.0;
        ammoType.flags |= 0x440L;
        ammoType.capital = true;
        ammoType.munitionType = 0x100000000000L;
        return ammoType;
    }

    private static AmmoType createScreenLauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Screen Launcher Ammo";
        ammoType.setInternalName("Ammo Screen");
        ammoType.addLookupName("ScreenLauncher Ammo");
        ammoType.damagePerShot = 0;
        ammoType.ammoType = 62;
        ammoType.shots = 1;
        ammoType.bv = 20.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createAlamoAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Alamo Ammo";
        ammoType.setInternalName("Ammo Alamo");
        ammoType.addLookupName("Alamo Ammo");
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 63;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 0.0;
        ammoType.flags |= 0x200L;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createLightSCCAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LightSCC Ammo";
        ammoType.setInternalName("Ammo LightSCC");
        ammoType.addLookupName("LightSCC Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 70;
        ammoType.shots = 1;
        ammoType.bv = 47.0;
        ammoType.cost = 10000.0;
        ammoType.ammoRatio = 2.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createMediumSCCAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "MediumSCC Ammo";
        ammoType.setInternalName("Ammo MediumSCC");
        ammoType.addLookupName("MediumSCC Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 70;
        ammoType.shots = 1;
        ammoType.bv = 89.0;
        ammoType.cost = 18000.0;
        ammoType.ammoRatio = 1.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createHeavySCCAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "HeavySCC Ammo";
        ammoType.setInternalName("Ammo HeavySCC");
        ammoType.addLookupName("HeavySCC Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 70;
        ammoType.shots = 1;
        ammoType.bv = 124.0;
        ammoType.cost = 25000.0;
        ammoType.ammoRatio = 0.5;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createMantaRayAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Manta Ray Ammo";
        ammoType.setInternalName("Ammo Manta Ray");
        ammoType.addLookupName("MantaRay Ammo");
        ammoType.damagePerShot = 5;
        ammoType.ammoType = 71;
        ammoType.shots = 1;
        ammoType.bv = 50.0;
        ammoType.cost = 30000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createSwordfishAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Swordfish Ammo";
        ammoType.setInternalName("Ammo Swordfish");
        ammoType.addLookupName("Swordfish Ammo");
        ammoType.damagePerShot = 4;
        ammoType.ammoType = 72;
        ammoType.shots = 1;
        ammoType.bv = 40.0;
        ammoType.cost = 25000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createStingrayAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Stringray Ammo";
        ammoType.setInternalName("Ammo Stringray");
        ammoType.addLookupName("Stingray Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 73;
        ammoType.shots = 1;
        ammoType.bv = 62.0;
        ammoType.cost = 19000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createPiranhaAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Piranha Ammo";
        ammoType.setInternalName("Ammo Piranha");
        ammoType.addLookupName("Piranha Ammo");
        ammoType.damagePerShot = 3;
        ammoType.ammoType = 74;
        ammoType.shots = 1;
        ammoType.bv = 84.0;
        ammoType.cost = 15000.0;
        ammoType.capital = true;
        return ammoType;
    }

    private static AmmoType createISAPMortar1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AP Mortar 1 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("IS Ammo AP Mortar-1");
        ammoType.addLookupName("ISArmorPiercingMortarAmmo1");
        ammoType.addLookupName("ISAPMortarAmmo1");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 67;
        ammoType.shots = 24;
        ammoType.bv = 1.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISAPMortar2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AP Mortar 2 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("IS Ammo AP Mortar-2");
        ammoType.addLookupName("ISArmorPiercingMortarAmmo2");
        ammoType.addLookupName("ISAPMortarAmmo2");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 67;
        ammoType.shots = 12;
        ammoType.bv = 2.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISAPMortar4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AP Mortar 4 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("IS Ammo AP Mortar-4");
        ammoType.addLookupName("ISArmorPiercingMortarAmmo4");
        ammoType.addLookupName("ISAPMortarAmmo4");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 67;
        ammoType.shots = 6;
        ammoType.bv = 3.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISAPMortar8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AP Mortar 8 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("IS Ammo AP Mortar-8");
        ammoType.addLookupName("ISArmorPiercingMortarAmmo8");
        ammoType.addLookupName("ISAPMortarAmmo8");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 8;
        ammoType.ammoType = 67;
        ammoType.shots = 4;
        ammoType.bv = 6.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLAPMortar1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AP Mortar 1 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("Clan Ammo AP Mortar-1");
        ammoType.addLookupName("CLArmorPiercingMortarAmmo1");
        ammoType.addLookupName("CLAPMortarAmmo1");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 67;
        ammoType.shots = 24;
        ammoType.bv = 4.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLAPMortar2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AP Mortar 2 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("Clan Ammo AP Mortar-2");
        ammoType.addLookupName("CLArmorPiercingMortarAmmo2");
        ammoType.addLookupName("CLAPMortarAmmo2");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 67;
        ammoType.shots = 12;
        ammoType.bv = 7.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLAPMortar4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AP Mortar 4 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("Clan Ammo AP Mortar-4");
        ammoType.addLookupName("CLArmorPiercingMortarAmmo4");
        ammoType.addLookupName("CLAPMortarAmmo4");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 67;
        ammoType.shots = 6;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createCLAPMortar8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AP Mortar 8 Ammo";
        ammoType.shortName = "Mortar";
        ammoType.setInternalName("Clan Ammo AP Mortar-8");
        ammoType.addLookupName("CLArmorPiercingMortarAmmo8");
        ammoType.addLookupName("CLAPMortarAmmo8");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 8;
        ammoType.ammoType = 67;
        ammoType.shots = 4;
        ammoType.bv = 14.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    private static AmmoType createISCruiseMissile50Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Cruise Missile/50 Ammo";
        ammoType.setInternalName("ISCruiseMissile50Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 50;
        ammoType.ammoType = 68;
        ammoType.shots = 1;
        ammoType.bv = 75.0;
        ammoType.cost = 20000.0;
        ammoType.tonnage = 25.0f;
        return ammoType;
    }

    private static AmmoType createISCruiseMissile70Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Cruise Missile/70 Ammo";
        ammoType.setInternalName("ISCruiseMissile70Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 70;
        ammoType.ammoType = 68;
        ammoType.shots = 1;
        ammoType.bv = 129.0;
        ammoType.cost = 50000.0;
        ammoType.tonnage = 35.0f;
        return ammoType;
    }

    private static AmmoType createISCruiseMissile90Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Cruise Missile/50 Ammo";
        ammoType.setInternalName("ISCruiseMissile90Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 90;
        ammoType.ammoType = 68;
        ammoType.shots = 1;
        ammoType.bv = 191.0;
        ammoType.cost = 90000.0;
        ammoType.tonnage = 45.0f;
        return ammoType;
    }

    private static AmmoType createISCruiseMissile120Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 7;
        ammoType.name = "Cruise Missile/120 Ammo";
        ammoType.setInternalName("ISCruiseMissile120Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 120;
        ammoType.ammoType = 68;
        ammoType.shots = 1;
        ammoType.bv = 285.0;
        ammoType.cost = 140000.0;
        ammoType.tonnage = 60.0f;
        return ammoType;
    }

    private static AmmoType createISBPodAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "B Pod Ammo";
        ammoType.setInternalName("ISBPodAmmo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 69;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 0.0;
        ammoType.tonnage = 0.0f;
        return ammoType;
    }

    private static AmmoType createCLBPodAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "B Pod Ammo";
        ammoType.setInternalName("ClanBPodAmmo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 69;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 0.0;
        ammoType.tonnage = 0.0f;
        return ammoType;
    }

    public String toString() {
        return "Ammo: " + this.name;
    }

    public static boolean canClearMinefield(AmmoType ammoType) {
        if (ammoType != null && ((ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 31 || ammoType.getAmmoType() == 37 || ammoType.getAmmoType() == 40 || ammoType.getAmmoType() == 12 || ammoType.getAmmoType() == 42 || ammoType.getAmmoType() == 29) && ammoType.getRackSize() >= 20 || ammoType.getAmmoType() == 52) && ammoType.getMunitionType() == 0L) {
            return true;
        }
        if (ammoType != null && ammoType.getAmmoType() == 28 && ammoType.getRackSize() >= 12 && ammoType.getMunitionType() != 128L || ammoType.getAmmoType() == 28 && ammoType.getRackSize() >= 9 && ammoType.getMunitionType() == 256L) {
            return true;
        }
        return ammoType != null && (ammoType.getAmmoType() == 15 || ammoType.getAmmoType() == 16 || ammoType.getAmmoType() == 17 || ammoType.getAmmoType() == 18) && ammoType.getMunitionType() == 0L;
    }

    public static boolean canDeliverMinefield(AmmoType ammoType) {
        return !(ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 0x400000L && ammoType.getMunitionType() != 0x1000000L && ammoType.getMunitionType() != 0x800000L && ammoType.getMunitionType() != 0x2000000L && ammoType.getMunitionType() != 0x4000000L);
    }

    private void addToEnd(AmmoType ammoType, String string) {
        Enumeration<String> enumeration = ammoType.getNames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            this.addLookupName(string2 + string);
        }
    }

    private void addBeforeString(AmmoType ammoType, String string, String string2) {
        Enumeration<String> enumeration = ammoType.getNames();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.insert(string3.lastIndexOf(string), string2);
            this.addLookupName(stringBuffer.toString());
        }
    }

    public double getProtoBV() {
        if (this.getAmmoType() == 9 || this.getAmmoType() == 11 || this.getAmmoType() == 7 || this.getAmmoType() == 10 || this.getAmmoType() == 8) {
            return this.kgPerShot * (double)this.rackSize * (double)this.shots / 1000.0 * this.bv;
        }
        return this.kgPerShot * (double)this.shots / 1000.0 * this.bv;
    }

    public double getBABV() {
        return this.kgPerShot * (double)this.shots / 1000.0 * this.bv;
    }

    public String getShortName() {
        if (this.shortName.trim().length() < 1) {
            return this.getName();
        }
        return this.shortName;
    }

    private static class MunitionMutator {
        private String name;
        private int weight;
        private long type;
        private int techLevel = -1;

        public MunitionMutator(String string, int n, long l, int n2) {
            this.name = string;
            this.weight = n;
            this.type = l;
            this.techLevel = n2;
        }

        public MunitionMutator(String string, int n, long l) {
            this.name = string;
            this.weight = n;
            this.type = l;
        }

        public AmmoType createMunitionType(AmmoType ammoType) {
            AmmoType ammoType2 = new AmmoType();
            switch (ammoType.ammoType) {
                case 1: 
                case 34: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(" - ");
                    stringBuffer.append(this.name);
                    ammoType2.addToEnd(ammoType, " - " + this.name);
                    stringBuffer = new StringBuffer(ammoType.internalName);
                    int n = ammoType.internalName.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    stringBuffer.insert(n, this.name);
                    ammoType2.setInternalName(stringBuffer.toString());
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    stringBuffer = null;
                    break;
                }
                case 15: {
                    StringBuffer stringBuffer = new StringBuffer(ammoType.name);
                    int n = ammoType.name.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    if (this.name.endsWith("-IV")) {
                        StringBuffer stringBuffer2 = new StringBuffer(this.name);
                        stringBuffer2.setLength(stringBuffer2.length() - 3);
                        stringBuffer.insert(n, stringBuffer2.toString());
                    } else {
                        stringBuffer.insert(n, this.name);
                    }
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(ammoType.internalName);
                    n = ammoType.internalName.lastIndexOf("Ammo");
                    stringBuffer.insert(n, this.name);
                    ammoType2.setInternalName(stringBuffer.toString());
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    ammoType2.addToEnd(ammoType, " - " + this.name);
                    if (this.name.equals("Homing")) {
                        ammoType2.addToEnd(ammoType, " (HO)");
                    }
                    stringBuffer = null;
                    break;
                }
                case 9: {
                    StringBuffer stringBuffer = new StringBuffer(" ");
                    stringBuffer.append(this.name);
                    ammoType2.setInternalName(ammoType.internalName + stringBuffer.toString());
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer.insert(0, " -");
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer = new StringBuffer(ammoType.name);
                    int n = ammoType.name.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    stringBuffer.insert(n, this.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = null;
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    break;
                }
                case 7: 
                case 12: 
                case 45: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(" ");
                    stringBuffer.append(this.name);
                    ammoType2.setInternalName(ammoType.internalName + stringBuffer.toString());
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer.insert(0, " -");
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    ammoType2.setInternalName(ammoType2.name);
                    ammoType2.addToEnd(ammoType, ammoType2.name);
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know how to create munitions for " + ammoType.ammoType);
                }
            }
            ammoType2.munitionType = this.type;
            ammoType2.techLevel = this.techLevel != -1 ? this.techLevel : ammoType.techLevel;
            ammoType2.shots = ammoType.shots / this.weight;
            ammoType2.ammoType = ammoType.ammoType;
            double d = ammoType.cost;
            double d2 = ammoType.bv;
            if (ammoType2.getAmmoType() == 1 || ammoType2.getAmmoType() == 34) {
                if (ammoType2.getMunitionType() == 2L) {
                    d *= 4.0;
                }
                if (ammoType2.getMunitionType() == 4L || ammoType2.getMunitionType() == 64L) {
                    d *= 1.5;
                }
                if (ammoType2.getMunitionType() == 32L) {
                    d *= 1.5;
                    d2 *= 0.25;
                }
                if (ammoType2.getMunitionType() == 8L) {
                    d *= 2.0;
                }
                if (ammoType2.getMunitionType() == 16L) {
                    d *= 6.0;
                }
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 0x40000000L) {
                d *= 0.5;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 131072L) {
                d *= 1.5;
            }
            if ((ammoType2.getAmmoType() == 9 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x20000000L) {
                d = 13500.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 524288L) {
                d *= 3.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x100000L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x200000L) {
                d *= 3.0;
                d2 *= 0.2;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x400000L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x800000L) {
                d *= 4.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x1000000L) {
                d *= 1.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x2000000L) {
                d *= 2.5;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45) && ammoType2.getMunitionType() == 0x4000000L) {
                d *= 3.0;
            }
            if (ammoType2.getMunitionType() == 0x2000000000L) {
                d = 15000.0;
            }
            if (ammoType2.getMunitionType() == 0x4000000000L) {
                d *= 1.5;
            }
            if (ammoType2.getMunitionType() == 0x8000000000L) {
                d *= 1.0;
            }
            if (ammoType2.getMunitionType() == 0x10000000000L) {
                d *= 2.0;
            }
            if (ammoType2.getMunitionType() == 0x40000000000L) {
                d *= 50.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 4096L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 8192L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 1024L) {
                d *= 1.1;
            }
            if (!(ammoType2.getAmmoType() != 7 && ammoType2.getAmmoType() != 45 && ammoType2.getAmmoType() != 9 || ammoType2.getMunitionType() != 2048L && ammoType2.getMunitionType() != 16384L && ammoType2.getMunitionType() != 512L)) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 65536L) {
                d *= 5.0;
            }
            if (!(ammoType2.getAmmoType() != 7 && ammoType2.getAmmoType() != 45 && ammoType2.getAmmoType() != 9 || ammoType2.getMunitionType() != 32768L && ammoType2.getMunitionType() != 0x8000000L)) {
                d *= 2.0;
                d2 *= 0.5;
            }
            ammoType2.bv = d2;
            ammoType2.cost = d;
            ammoType2.damagePerShot = ammoType.damagePerShot;
            ammoType2.rackSize = ammoType.rackSize;
            ammoType2.ammoType = ammoType.ammoType;
            ammoType2.flags = ammoType.flags;
            ammoType2.hittable = ammoType.hittable;
            ammoType2.explosive = ammoType.explosive;
            ammoType2.toHitModifier = ammoType.toHitModifier;
            return ammoType2;
        }
    }
}

