/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.CriticalSlot;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;

public class BipedMech
extends Mech {
    private static final long serialVersionUID = 4166375446709772785L;
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Right Arm", "Left Arm", "Right Leg", "Left Leg"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "RA", "LA", "RL", "LL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 12, 12, 6, 6};

    public BipedMech(String string, String string2) {
        this(BipedMech.getGyroTypeForString(string), BipedMech.getCockpitTypeForString(string2));
    }

    public BipedMech() {
        this(0, 0);
    }

    public BipedMech(int n, int n2) {
        super(n, n2);
        this.movementMode = 1;
        this.setCritical(4, 0, new CriticalSlot(0, 7));
        this.setCritical(4, 1, new CriticalSlot(0, 8));
        this.setCritical(4, 2, new CriticalSlot(0, 9));
        this.setCritical(4, 3, new CriticalSlot(0, 10));
        this.setCritical(5, 0, new CriticalSlot(0, 7));
        this.setCritical(5, 1, new CriticalSlot(0, 8));
        this.setCritical(5, 2, new CriticalSlot(0, 9));
        this.setCritical(5, 3, new CriticalSlot(0, 10));
    }

    public boolean canFlipArms() {
        boolean bl;
        boolean bl2 = bl = !this.isProne();
        if (this.hasSystem(10, 5)) {
            bl = false;
        } else if (this.hasSystem(9, 5)) {
            bl = false;
        } else if (this.hasSystem(10, 4)) {
            bl = false;
        } else if (this.hasSystem(9, 4)) {
            bl = false;
        }
        return bl;
    }

    public int getWalkMP(boolean bl, boolean bl2) {
        int n;
        int n2 = this.getOriginalWalkMP();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.locations(); ++n) {
            if (!this.locationIsLeg(n)) continue;
            if (!this.isLocationBad(n)) {
                if (this.legHasHipCrit(n)) {
                    ++n4;
                    if (this.game == null || !this.game.getOptions().booleanOption("tacops_leg_damage")) continue;
                }
                n5 += this.countLegActuatorCrits(n);
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            n2 = n3 == 1 ? 1 : 0;
        } else {
            if (n4 > 0) {
                n2 = this.game != null && this.game.getOptions().booleanOption("tacops_leg_damage") ? (n4 >= 1 ? n2 - 2 * n4 : 0) : (n4 == 1 ? (int)Math.ceil((double)n2 / 2.0) : 0);
            }
            n2 -= n5;
        }
        if (this.hasShield()) {
            n2 -= this.getNumberOfShields(4096L);
            n2 -= this.getNumberOfShields(2048L);
        }
        if (this.hasModularArmor()) {
            --n2;
        }
        if (!bl2) {
            n2 = this.game != null && this.game.getOptions().booleanOption("tacops_heat") ? (this.heat < 30 ? (n2 -= this.heat / 5) : (this.heat >= 49 ? (n2 -= 9) : (this.heat >= 43 ? (n2 -= 8) : (this.heat >= 37 ? (n2 -= 7) : (this.heat >= 31 ? (n2 -= 6) : (n2 -= 5)))))) : (n2 -= this.heat / 5);
            if (this.heat >= 9 && this.hasTSM()) {
                n2 += 2;
            }
        }
        n2 = Math.max(n2 - this.getCargoMpReduction(), 0);
        if (null != this.game && (n = this.game.getPlanetaryConditions().getMovementMods(this)) != 0) {
            n2 = Math.max(n2 + n, 0);
        }
        if (bl) {
            n2 = this.applyGravityEffectsOnMP(n2);
        }
        n2 = Math.max(0, n2);
        return n2;
    }

    public int getRunMP(boolean bl, boolean bl2) {
        if (this.countBadLegs() == 0) {
            return super.getRunMP(bl, bl2);
        }
        return this.getWalkMP(bl, bl2);
    }

    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        if (this.countBadLegs() == 0) {
            return super.getRunMPwithoutMASC(bl, bl2);
        }
        return this.getWalkMP(bl, bl2);
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n4, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[]{6, 7};
        if (this.hasFunctionalLegAES()) {
            pilotingRollData.addModifier(-2, "AES bonus");
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.isLocationBad(n)) {
                pilotingRollData.addModifier(5, this.getLocationName(n) + " destroyed");
                continue;
            }
            if (this.getBadCriticals(0, 11, n) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n) + " Hip Actuator destroyed");
                if (!this.game.getOptions().booleanOption("tacops_leg_damage")) continue;
            }
            if (this.getBadCriticals(0, 12, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Upper Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 13, n) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " Lower Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 14, n) <= 0) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n) + " Foot Actuator destroyed");
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    protected double getArmActuatorCost() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.hasSystem(10, 5)) {
            ++n3;
        }
        if (this.hasSystem(9, 5)) {
            ++n2;
        }
        if (this.hasSystem(8, 5)) {
            ++n;
        }
        if (this.hasSystem(10, 4)) {
            ++n3;
        }
        if (this.hasSystem(9, 4)) {
            ++n2;
        }
        if (this.hasSystem(8, 4)) {
            ++n;
        }
        d += (double)((float)n * this.weight * 100.0f);
        d += (double)((float)n2 * this.weight * 50.0f);
        return d += (double)((float)n3 * this.weight * 80.0f);
    }

    protected double getLegActuatorCost() {
        return this.weight * 150.0f * 2.0f + this.weight * 80.0f * 2.0f + this.weight * 120.0f * 2.0f;
    }

    public boolean hasClaw(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !equipmentType.hasFlag(0x4000000L) || !equipmentType.hasSubType(1L)) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public boolean hasVibroblades() {
        int n = 0;
        if (this.hasVibrobladesInLocation(4)) {
            ++n;
        }
        if (this.hasVibrobladesInLocation(5)) {
            ++n;
        }
        return n > 0;
    }

    public boolean hasVibrobladesInLocation(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isVibroblade()) continue;
            return !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached();
        }
        return false;
    }

    public boolean hasRetractedBlade(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x2000000L) || !mounted.getType().hasSubType(0x800000L) || mounted.curMode().equals("extended")) continue;
            return true;
        }
        return false;
    }

    public int getActiveVibrobladeHeat(int n) {
        if (n != 4 && n != 5) {
            return 0;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isVibroblade() || !mounted.curMode().equals("Active") || mounted.isDestroyed() || mounted.isMissing() || mounted.isBreached()) continue;
            MiscType miscType = (MiscType)equipmentType;
            if (miscType.hasSubType(65536L)) {
                return 7;
            }
            if (miscType.hasSubType(32768L)) {
                return 5;
            }
            return 3;
        }
        return 0;
    }

    public boolean hasShield() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !((MiscType)equipmentType).isShield() || this.getInternal(mounted.getLocation()) <= 0) continue;
            ++n;
        }
        return n > 0;
    }

    public int getNumberOfShields(long l) {
        int n = 0;
        int n2 = 0;
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x2000000L) || !equipmentType.hasSubType(l)) continue;
            if (mounted.getLocation() == 4) {
                n = 1;
            }
            if (mounted.getLocation() == 5) {
                n2 = 1;
            }
            if (n <= 0 || n2 <= 0) continue;
            return 2;
        }
        return n + n2;
    }

    public boolean hasActiveShield(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                if (bl) {
                    return false;
                }
                return this.hasActiveShield(5) || this.hasActiveShield(4);
            }
            case 3: 
            case 5: 
            case 7: {
                return this.hasActiveShield(5);
            }
        }
        return this.hasActiveShield(4);
    }

    public boolean hasActiveShield(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        if (this.isShutDown() || this.getCrew().isKoThisRound() || this.getCrew().isUnconscious()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("Active")) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasPassiveShield(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                return false;
            }
            case 3: 
            case 5: {
                if (bl) {
                    return false;
                }
                return this.hasPassiveShield(5);
            }
        }
        if (bl) {
            return false;
        }
        return this.hasPassiveShield(4);
    }

    public boolean hasPassiveShield(int n) {
        if (this.isShutDown() || this.getCrew().isKoThisRound() || this.getCrew().isUnconscious()) {
            return false;
        }
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("Passive")) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasNoDefenseShield(int n) {
        if (n != 4 && n != 5) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !mounted.curMode().equals("None") && !this.isShutDown() && !this.getCrew().isKoThisRound() && !this.getCrew().isUnconscious()) continue;
            return mounted.getCurrentDamageCapacity(this, mounted.getLocation()) > 0;
        }
        return false;
    }

    public boolean hasFunctionalArmAES(int n) {
        boolean bl = false;
        if (n != 4 && n != 5) {
            return false;
        }
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() == n && mounted.getType().hasFlag(0x40000000000L) && !mounted.isDestroyed() && !mounted.isBreached() && !mounted.isMissing()) {
                bl = true;
                continue;
            }
            if (mounted.getLocation() != n || !mounted.getType().hasFlag(0x40000000000L)) continue;
            return false;
        }
        return bl;
    }

    public boolean hasFunctionalLegAES() {
        boolean bl = false;
        boolean bl2 = false;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() != 7 && mounted.getLocation() != 6) continue;
            if (((MiscType)mounted.getType()).hasFlag(0x40000000000L) && !mounted.isDestroyed() && !mounted.isBreached() && !mounted.isMissing()) {
                if (mounted.getLocation() == 7) {
                    bl2 = true;
                    continue;
                }
                bl = true;
                continue;
            }
            if (!((MiscType)mounted.getType()).hasFlag(0x40000000000L)) continue;
            return false;
        }
        return bl && bl2;
    }

    public boolean canGoHullDown() {
        return this.game.getOptions().booleanOption("tacops_hull_down") && !this.isLocationBad(7) && !this.isLocationBad(6) && !this.isLocationDoomed(7) && !this.isLocationDoomed(6);
    }

    public PilotingRollData checkGetUp(MoveStep moveStep) {
        PilotingRollData pilotingRollData = super.checkGetUp(moveStep);
        if (this.game.getOptions().booleanOption("tacops_attempting_stand") && pilotingRollData.getValue() != -2147483647) {
            this.addStandingPenalties(pilotingRollData);
            pilotingRollData.setCumulative(true);
        }
        return pilotingRollData;
    }

    public PilotingRollData addStandingPenalties(PilotingRollData pilotingRollData) {
        int[] nArray = new int[]{4, 5};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.isLocationBad(n)) {
                pilotingRollData.addModifier(2, this.getLocationName(n) + " destroyed");
                continue;
            }
            if (!this.hasWorkingSystem(10, n)) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " hand Actuator missing/destroyed");
                continue;
            }
            if (!this.hasWorkingSystem(9, n)) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " lower Actuator missing/destroyed");
                continue;
            }
            if (!this.hasWorkingSystem(8, n)) {
                pilotingRollData.addModifier(1, this.getLocationName(n) + " upper ctuator missing/destroyed");
                continue;
            }
            if (this.hasWorkingSystem(7, n)) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n) + " shoulder Actuator missing/destroyed");
        }
        return pilotingRollData;
    }

    public boolean cannotStandUpFromHullDown() {
        int n = 0;
        if (this.isLocationBad(7)) {
            ++n;
        }
        if (this.isLocationBad(6)) {
            ++n;
        }
        return n >= 1 || this.getBadCriticals(0, 4, 1) > 1 && this.getGyroType() != 3 || this.getBadCriticals(0, 4, 1) > 2 && this.getGyroType() == 3;
    }
}

