/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import megamek.common.ASFBay;
import megamek.common.AmmoType;
import megamek.common.Bay;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.SmallCraft;
import megamek.common.SmallCraftBay;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class Dropship
extends SmallCraft
implements Serializable {
    private static final long serialVersionUID = 1528728632696989565L;
    int escapePods = 0;
    int lifeBoats = 0;
    private boolean dockCollarDamaged = false;

    public boolean isDockCollarDamaged() {
        return this.dockCollarDamaged;
    }

    public void setDamageDockCollar(boolean bl) {
        this.dockCollarDamaged = bl;
    }

    public void setEscapePods(int n) {
        this.escapePods = n;
    }

    public int getEscapePods() {
        return this.escapePods;
    }

    public void setLifeBoats(int n) {
        this.lifeBoats = n;
    }

    public int getLifeBoats() {
        return this.lifeBoats;
    }

    public int getFuelPerTon() {
        int n = 80;
        if (this.weight >= 40000.0f) {
            n = 10;
            return n;
        }
        if (this.weight >= 20000.0f) {
            n = 20;
            return n;
        }
        if (this.weight >= 3000.0f) {
            n = 30;
            return n;
        }
        if (this.weight >= 1900.0f) {
            n = 40;
            return n;
        }
        if (this.weight >= 1200.0f) {
            n = 50;
            return n;
        }
        if (this.weight >= 800.0f) {
            n = 60;
            return n;
        }
        if (this.weight >= 400.0f) {
            n = 70;
            return n;
        }
        return n;
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        d += 10000.0;
        double d2 = 0.065;
        if (this.isClan()) {
            d2 = 0.061;
        }
        double d3 = (double)((float)this.getOriginalWalkMP() * this.weight) * d2;
        d += d3 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += (double)(200 * this.getFuel() / this.getFuelPerTon());
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 10000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()));
        double d4 = 36.0;
        if (this.isSpheroid()) {
            d4 = 28.0;
        }
        return Math.round(d * d4);
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        double d;
        double d2;
        double string;
        double n10;
        int hashMap;
        Object object;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x200000000000L)) continue;
            n3 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        d5 += (double)(this.getTotalArmor() + n3) * 2.5;
        d5 += (double)this.getSI() * 2.0;
        double d7 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            object = serializable2.getType();
            if (serializable2.isDestroyed() || !(object instanceof WeaponType && ((EquipmentType)object).hasFlag(0x800000L) || object instanceof AmmoType && ((AmmoType)object).getAmmoType() == 14 || object instanceof AmmoType && ((AmmoType)object).getAmmoType() == 62) && (!(object instanceof WeaponType) || ((WeaponType)object).getAtClass() != 21)) continue;
            d7 += ((EquipmentType)object).getBV(this);
        }
        d5 += d7;
        d5 *= this.getBVTypeModifier();
        int n4 = this.getHeatCapacity();
        TreeMap<Object, Double> treeMap = new TreeMap<Object, Double>();
        object = new TreeMap();
        TreeMap<Integer, Double> treeMap2 = new TreeMap<Integer, Double>();
        for (Mounted mounted : this.getTotalWeaponList()) {
            Object d10;
            WeaponType n6 = (WeaponType)mounted.getType();
            double n7 = n6.getHeat();
            int d14 = this.getWeaponArc(this.getEquipmentNum(mounted));
            double d3 = n6.getBV(this);
            if (n6 instanceof BayWeapon || n6.hasFlag(0x800000L) || n6.getAtClass() == 21 || mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (n6.getAmmoType() == 20 || n6.getAmmoType() == 33) {
                n7 *= 2.0;
            }
            if (n6.getAmmoType() == 23) {
                n7 *= 6.0;
            }
            if (!(n6.hasFlag(131072L) && n6.getAmmoType() != 46 || n6.hasFlag(16384L) || n6.hasFlag(2048L) || n6.getAmmoType() == -1)) {
                d10 = n6.getAmmoType() + ":" + n6.getRackSize() + ";" + d14;
                if (!treeMap.containsKey(d10)) {
                    treeMap.put(d10, n6.getBV(this));
                } else {
                    treeMap.put(d10, n6.getBV(this) + (Double)treeMap.get(d10));
                }
            }
            if (n6.hasFlag(0x100000000L)) {
                double d4 = 0.0;
                for (Mounted d17 : this.getTotalWeaponList()) {
                    if (!d17.getType().hasFlag(512L) || d17.getLocation() != mounted.getLocation()) continue;
                    d4 += d17.getType().getBV(this);
                }
                d3 = d4 * 0.67;
            }
            if (n6.hasFlag(1L) && this.hasTargComp()) {
                d3 *= 1.25;
            }
            if (mounted.getLinkedBy() != null) {
                d10 = mounted.getLinkedBy();
                if (((Mounted)d10).getType() instanceof MiscType && ((Mounted)d10).getType().hasFlag(512L)) {
                    d3 *= 1.2;
                }
                if (((Mounted)d10).getType() instanceof MiscType && ((Mounted)d10).getType().hasFlag(0x1000000000000L)) {
                    d3 *= 1.15;
                }
            }
            double object2 = 0.0;
            double d8 = 0.0;
            if (null != ((TreeMap)object).get(d14)) {
                object2 = (Double)((TreeMap)object).get(d14);
            }
            if (null != treeMap2.get(d14)) {
                d8 = (Double)treeMap2.get(d14);
            }
            ((TreeMap)object).put(d14, object2 + d3);
            treeMap2.put(d14, d8 + n7);
        }
        double d9 = 0.0;
        int n2 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        double d10 = 1.0;
        double d11 = 0.5;
        double d12 = 0.0;
        double d13 = 0.0;
        Set set = ((TreeMap)object).keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap = (Integer)iterator.next();
            if (!((Double)((TreeMap)object).get(hashMap) > d12)) continue;
            n2 = hashMap;
            d12 = (Double)((TreeMap)object).get(hashMap);
        }
        if (n2 > Integer.MIN_VALUE) {
            d13 += ((Double)treeMap2.get(n2)).doubleValue();
            hashMap = this.getAdjacentArcCW(n2);
            int arrayList = this.getAdjacentArcCCW(n2);
            double d14 = 0.0;
            n10 = 0.0;
            if (hashMap > Integer.MIN_VALUE && null != ((TreeMap)object).get(hashMap)) {
                d14 = (Double)((TreeMap)object).get(hashMap);
                n10 = (Double)treeMap2.get(hashMap);
            }
            string = 0.0;
            d2 = 0.0;
            if (arrayList > Integer.MIN_VALUE && null != ((TreeMap)object).get(arrayList)) {
                string = (Double)((TreeMap)object).get(arrayList);
                d2 = (Double)treeMap2.get(arrayList);
            }
            if (d14 > string) {
                n5 = hashMap;
                if (d13 + n10 > (double)n4) {
                    d10 = 0.5;
                }
                d13 += n10;
                n6 = arrayList;
                if (d13 + d2 > (double)n4) {
                    d11 = 0.25;
                }
            } else {
                n5 = arrayList;
                if (d13 + d2 > (double)n4) {
                    d10 = 0.5;
                }
                d13 += d2;
                n6 = hashMap;
                if (d13 + n10 > (double)n4) {
                    d11 = 0.25;
                }
            }
        }
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mounted mounted : this.getAmmo()) {
            int n7 = this.getWeaponArc(this.getEquipmentNum(mounted));
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || ammoType.getAmmoType() == 62 || mounted.getLocation() == -1) continue;
            String n11 = ammoType.getAmmoType() + ":" + ammoType.getRackSize() + ";" + n7;
            if (!arrayList.contains(n11)) {
                arrayList.add(n11);
            }
            if (!hashMap2.containsKey(n11)) {
                hashMap2.put(n11, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(n11, ammoType.getBV(this) + (Double)hashMap2.get(n11));
        }
        for (String string2 : arrayList) {
            n10 = 0.0;
            int miscType = Integer.parseInt(string2.split(";")[1]);
            if (treeMap.get(string2) != null) {
                n10 = (Double)hashMap2.get(string2) > (Double)treeMap.get(string2) ? (n10 += ((Double)treeMap.get(string2)).doubleValue()) : (n10 += ((Double)hashMap2.get(string2)).doubleValue());
            }
            d = 0.0;
            if (null != ((TreeMap)object).get(miscType)) {
                d = (Double)((TreeMap)object).get(miscType);
            }
            ((TreeMap)object).put(miscType, d + n10);
        }
        if (n2 > Integer.MIN_VALUE) {
            d9 += ((Double)((TreeMap)object).get(n2)).doubleValue();
            ((TreeMap)object).put(n2, 0.0);
            if (n5 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n5)) {
                d9 += d10 * (Double)((TreeMap)object).get(n5);
                ((TreeMap)object).put(n5, 0.0);
            }
            if (n6 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n6)) {
                d9 += d11 * (Double)((TreeMap)object).get(n6);
                ((TreeMap)object).put(n6, 0.0);
            }
            set = ((TreeMap)object).keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                int d19 = (Integer)iterator.next();
                d9 += 0.25 * (Double)((TreeMap)object).get(d19);
            }
        }
        double d15 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || miscType.hasFlag(0x80000000000L) || miscType.hasFlag(0x100000000000L) || miscType.hasFlag(0x800000L) || miscType.hasFlag(1024L)) continue;
            d = miscType.getBV(this);
            d15 += d;
            if (!miscType.hasFlag(0x20000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d15 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d15 += (double)this.getArmor(mounted.getLocation(), true);
        }
        string = this.getRunMP();
        double d16 = string > 25.0 ? Math.pow(1.0 + ((double)this.getRunMP() - 5.0) / 10.0, 1.2) : Math.pow(1.0 + (string - 5.0) / 10.0, 1.2);
        d16 = (double)Math.round(d16 * 100.0) / 100.0;
        d6 = (d9 += d15) * d16;
        d2 = 0.0;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true, true);
            }
            n = (int)((double)n * 0.05);
            d2 += (double)n;
        }
        n = (int)Math.round(d5 + d6 + d2);
        double d17 = 1.0;
        if (!bl2) {
            d17 = this.crew.getBVSkillMultiplier();
        }
        int n8 = (int)Math.round((double)n * d17);
        if (bl) {
            return n;
        }
        return n8;
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        Mounted mounted3 = this.whichBay(this.getEquipmentNum(mounted));
        if (mounted3 != null && !mounted3.ammoInBay(this.getEquipmentNum(mounted2))) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public int getIniBonus() {
        return 2;
    }

    public int getAdjacentArcCW(int n) {
        switch (n) {
            case 11: {
                if (this.isSpheroid()) {
                    return 17;
                }
                return 13;
            }
            case 12: {
                return 11;
            }
            case 13: {
                return 15;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 22;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 19;
            }
            case 18: {
                return 16;
            }
            case 19: {
                return 22;
            }
            case 22: {
                if (this.isSpheroid()) {
                    return 18;
                }
                return 14;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int getAdjacentArcCCW(int n) {
        switch (n) {
            case 11: {
                if (this.isSpheroid()) {
                    return 16;
                }
                return 12;
            }
            case 12: {
                return 14;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 22;
            }
            case 15: {
                return 13;
            }
            case 16: {
                return 18;
            }
            case 17: {
                return 11;
            }
            case 18: {
                return 22;
            }
            case 19: {
                return 13;
            }
            case 22: {
                if (this.isSpheroid()) {
                    return 19;
                }
                return 15;
            }
        }
        return Integer.MIN_VALUE;
    }
}

