/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import gd.xml.ParseException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.FighterSquadron;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.WeaponType;
import megamek.common.XMLStreamParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListFile {
    private static String formatArmor(int n) {
        if (n == -2 || n == -3) {
            return "Destroyed";
        }
        if (n == -1) {
            return "N/A";
        }
        return String.valueOf(n);
    }

    private static String formatSlot(String string, Mounted mounted, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("         <slot index=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" type=\"");
        if (mounted == null) {
            stringBuffer.append("System");
        } else {
            stringBuffer.append(mounted.getType().getInternalName());
            if (mounted.isRearMounted()) {
                stringBuffer.append("\" isRear=\"true");
            }
            if (mounted.getType() instanceof AmmoType) {
                stringBuffer.append("\" shots=\"");
                stringBuffer.append(String.valueOf(mounted.getShotsLeft()));
            }
            if (mounted.getType() instanceof WeaponType && mounted.getType().hasFlag(16384L)) {
                stringBuffer.append("\" munition=\"");
                stringBuffer.append(mounted.getLinked().getType().getInternalName());
            }
        }
        if (bl) {
            stringBuffer.append("\" isHit=\"");
            stringBuffer.append(String.valueOf(bl));
        }
        stringBuffer.append("\" isDestroyed=\"");
        stringBuffer.append(String.valueOf(bl2));
        stringBuffer.append("\"/>");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static String getLocString(Entity entity) {
        boolean bl = entity instanceof Mech;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < entity.locations(); ++i) {
            if (!(entity instanceof Aero) && entity.getOInternal(i) != -1 && entity.getInternal(i) <= 0) {
                bl3 = true;
            }
            if (!bl3) {
                if (entity.getOArmor(i) != entity.getArmor(i)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getArmor(i)));
                    stringBuffer2.append("\"/>");
                    stringBuffer2.append("\r\n");
                }
                if (entity.getOInternal(i) != entity.getInternal(i)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getInternal(i)));
                    stringBuffer2.append("\" type=\"Internal\"/>");
                    stringBuffer2.append("\r\n");
                }
                if (entity.hasRearArmor(i) && entity.getOArmor(i, true) != entity.getArmor(i, true)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getArmor(i, true)));
                    stringBuffer2.append("\" type=\"Rear\"/>");
                    stringBuffer2.append("\r\n");
                }
            }
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (null == criticalSlot) {
                    if (!bl || entity.entityIsQuad() || i != 4 && i != 5 || j != 2 && j != 3) continue;
                    stringBuffer2.append("         <slot index=\"");
                    stringBuffer2.append(String.valueOf(j + 1));
                    stringBuffer2.append("\" type=\"Empty\"/>");
                    stringBuffer2.append("\r\n");
                    bl2 = true;
                    continue;
                }
                Mounted mounted = null;
                if (1 == criticalSlot.getType()) {
                    mounted = entity.getEquipment(criticalSlot.getIndex());
                }
                if (bl3 && bl && criticalSlot.isMissing() && !criticalSlot.isHit() && !criticalSlot.isDestroyed()) {
                    stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, criticalSlot.isHit(), criticalSlot.isDestroyed()));
                    bl2 = true;
                    bl4 = true;
                    continue;
                }
                if (!bl3 && criticalSlot.isDamaged()) {
                    stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, criticalSlot.isHit(), criticalSlot.isDestroyed()));
                    bl2 = true;
                    continue;
                }
                if (!bl3 && mounted != null && mounted.getType() instanceof AmmoType) {
                    stringBuffer2.append("         <slot index=\"");
                    stringBuffer2.append(String.valueOf(j + 1));
                    stringBuffer2.append("\" type=\"");
                    stringBuffer2.append(mounted.getType().getInternalName());
                    stringBuffer2.append("\" shots=\"");
                    stringBuffer2.append(String.valueOf(mounted.getShotsLeft()));
                    stringBuffer2.append("\"/>");
                    stringBuffer2.append("\r\n");
                    bl2 = true;
                    continue;
                }
                if (bl3 || mounted == null || !(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(16384L)) continue;
                stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, criticalSlot.isHit(), criticalSlot.isDestroyed()));
                bl2 = true;
            }
            if (entity instanceof Tank || entity instanceof Protomech) {
                for (Mounted mounted : entity.getAmmo()) {
                    if (mounted.getLocation() != i) continue;
                    stringBuffer2.append(EntityListFile.formatSlot("N/A", mounted, false, false));
                    bl2 = true;
                }
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("      <location index=\"");
                stringBuffer.append(String.valueOf(i));
                if (bl3) {
                    stringBuffer.append("\" isDestroyed=\"true");
                }
                stringBuffer.append("\"> ");
                stringBuffer.append(entity.getLocationName(i));
                if (bl4) {
                    stringBuffer.append(" has been blown off.");
                }
                stringBuffer.append("\r\n");
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("      </location>");
                stringBuffer.append("\r\n");
                stringBuffer2 = new StringBuffer();
                bl4 = false;
            } else if (bl3) {
                stringBuffer.append("      <location index=\"");
                stringBuffer.append(String.valueOf(i));
                stringBuffer.append("\" isDestroyed=\"true\" /> ");
                stringBuffer.append(entity.getLocationName(i));
                stringBuffer.append("\r\n");
            }
            bl3 = false;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        if (bl2) {
            stringBuffer.insert(0, "\r\n");
            stringBuffer.insert(0, "      The first slot in a location is at index=\"1\".");
            if (entity instanceof Tank) {
                stringBuffer.insert(0, "\r\n");
                stringBuffer.insert(0, "      Tanks have special needs, so don't delete any ammo slots.");
            }
        }
        return stringBuffer.toString();
    }

    public static void saveTo(File file, ArrayList<Entity> arrayList) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("<unit>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("\r\n");
        for (Entity entity : arrayList) {
            String string;
            Serializable serializable;
            bufferedWriter.write("   <entity chassis=\"");
            bufferedWriter.write(entity.getChassis().replaceAll("\"", "&quot;"));
            bufferedWriter.write("\" model=\"");
            bufferedWriter.write(entity.getModel().replaceAll("\"", "&quot;"));
            bufferedWriter.write("\" type=\"");
            if (entity instanceof FighterSquadron) {
                serializable = (FighterSquadron)entity;
                bufferedWriter.write("squadron\" fighters=\"");
                for (int i = 0; i < ((FighterSquadron)serializable).fighters.size(); ++i) {
                    if (i > 0) {
                        bufferedWriter.write(":");
                    }
                    bufferedWriter.write(((FighterSquadron)serializable).fighters.elementAt(i));
                }
            } else {
                bufferedWriter.write(entity.getMovementModeAsString());
            }
            bufferedWriter.write("\">");
            bufferedWriter.write("\r\n");
            serializable = entity.getCrew();
            bufferedWriter.write("      <pilot name=\"");
            bufferedWriter.write(((Pilot)serializable).getName().replaceAll("\"", "&quot;"));
            bufferedWriter.write("\" gunnery=\"");
            bufferedWriter.write(String.valueOf(((Pilot)serializable).getGunnery()));
            if (entity.getGame().getOptions().booleanOption("rpg_gunnery")) {
                bufferedWriter.write("\" gunneryL=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getGunneryL()));
                bufferedWriter.write("\" gunneryM=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getGunneryM()));
                bufferedWriter.write("\" gunneryB=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getGunneryB()));
            }
            bufferedWriter.write("\" piloting=\"");
            bufferedWriter.write(String.valueOf(((Pilot)serializable).getPiloting()));
            bufferedWriter.write("\" initB=\"");
            bufferedWriter.write(String.valueOf(((Pilot)serializable).getInitBonus()));
            bufferedWriter.write("\" commandB=\"");
            bufferedWriter.write(String.valueOf(((Pilot)serializable).getCommandBonus()));
            if (((Pilot)serializable).isDead() || ((Pilot)serializable).getHits() > 5) {
                bufferedWriter.write("\" hits=\"Dead");
            } else if (((Pilot)serializable).getHits() > 0) {
                bufferedWriter.write("\" hits=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getHits()));
            }
            if (((Pilot)serializable).countAdvantages() > 0) {
                bufferedWriter.write("\" advantages=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getAdvantageList("::")));
            }
            if (((Pilot)serializable).countMDImplants() > 0) {
                bufferedWriter.write("\" implants=\"");
                bufferedWriter.write(String.valueOf(((Pilot)serializable).getImplantList("::")));
            }
            if (entity instanceof Mech) {
                if (((Mech)entity).isAutoEject()) {
                    bufferedWriter.write("\" autoeject=\"true");
                } else {
                    bufferedWriter.write("\" autoeject=\"false");
                }
            }
            bufferedWriter.write("\"/>");
            bufferedWriter.write("\r\n");
            if (entity instanceof Tank) {
                Tank tank = (Tank)entity;
                bufferedWriter.write(EntityListFile.getMovementString(tank));
                if (tank.isTurretLocked()) {
                    bufferedWriter.write(EntityListFile.getTurretLockedString(tank));
                }
            }
            if (entity instanceof Aero) {
                Aero aero;
                Aero aero2 = (Aero)entity;
                bufferedWriter.write("      <structural integrity=\"");
                bufferedWriter.write(String.valueOf(aero2.getSI()));
                bufferedWriter.write("\"/>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <heat sinks=\"");
                bufferedWriter.write(String.valueOf(aero2.getHeatSinks()));
                bufferedWriter.write("\"/>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <fuel left=\"");
                bufferedWriter.write(String.valueOf(aero2.getFuel()));
                bufferedWriter.write("\"/>");
                bufferedWriter.write("\r\n");
                if (aero2 instanceof FighterSquadron) {
                    aero = (FighterSquadron)aero2;
                    bufferedWriter.write("      <active fighters=\"");
                    bufferedWriter.write(String.valueOf(((FighterSquadron)aero).getNFighters()));
                    bufferedWriter.write("\"/>");
                    bufferedWriter.write("\r\n");
                    bufferedWriter.write("      <total armor=\"");
                    bufferedWriter.write(String.valueOf(((FighterSquadron)aero).getTotalArmor()));
                    bufferedWriter.write("\"/>");
                    bufferedWriter.write("\r\n");
                }
                if (aero2 instanceof Jumpship) {
                    aero = (Jumpship)aero2;
                    bufferedWriter.write("      <KF integrity=\"");
                    bufferedWriter.write(String.valueOf(((Jumpship)aero).getKFIntegrity()));
                    bufferedWriter.write("\"/>");
                    bufferedWriter.write("\r\n");
                    bufferedWriter.write("      <sail integrity=\"");
                    bufferedWriter.write(String.valueOf(((Jumpship)aero).getSailIntegrity()));
                    bufferedWriter.write("\"/>");
                    bufferedWriter.write("\r\n");
                }
                bufferedWriter.write(EntityListFile.getAeroCritString(aero2));
            }
            if (null != (string = EntityListFile.getLocString(entity))) {
                bufferedWriter.write(string);
            }
            bufferedWriter.write("   </entity>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
        }
        bufferedWriter.write("</unit>");
        bufferedWriter.write("\r\n");
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    private static String getTurretLockedString(Tank tank) {
        String string = "      <turretlock direction=\"";
        string = string.concat(Integer.toString(tank.getSecondaryFacing()));
        string = string.concat("\"/>\n");
        return string;
    }

    private static String getMovementString(Tank tank) {
        String string = "      <movement speed=\"";
        string = tank.isImmobile() ? string.concat("immobile") : string.concat(Integer.toString(tank.getOriginalWalkMP()));
        string = string.concat("\"/>\n");
        return string;
    }

    private static String getAeroCritString(Aero aero) {
        String string = "      <acriticals";
        String string2 = "";
        if (aero.getAvionicsHits() > 0) {
            string2 = string2.concat(" avionics=\"");
            string2 = string2.concat(Integer.toString(aero.getAvionicsHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getSensorHits() > 0) {
            string2 = string2.concat(" sensors=\"");
            string2 = string2.concat(Integer.toString(aero.getSensorHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getEngineHits() > 0) {
            string2 = string2.concat(" engine=\"");
            string2 = string2.concat(Integer.toString(aero.getEngineHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getFCSHits() > 0) {
            string2 = string2.concat(" fcs=\"");
            string2 = string2.concat(Integer.toString(aero.getFCSHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getCICHits() > 0) {
            string2 = string2.concat(" cic=\"");
            string2 = string2.concat(Integer.toString(aero.getCICHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getLeftThrustHits() > 0) {
            string2 = string2.concat(" leftThrust=\"");
            string2 = string2.concat(Integer.toString(aero.getLeftThrustHits()));
            string2 = string2.concat("\"");
        }
        if (aero.getRightThrustHits() > 0) {
            string2 = string2.concat(" rightThrust=\"");
            string2 = string2.concat(Integer.toString(aero.getRightThrustHits()));
            string2 = string2.concat("\"");
        }
        if (!aero.hasLifeSupport()) {
            string2 = string2.concat(" lifeSupport=\"none\"");
        }
        if (aero.isGearHit()) {
            string2 = string2.concat(" gear=\"none\"");
        }
        if (string2.equals("")) {
            return string2;
        }
        string = string.concat(string2);
        string = string.concat("/>\n");
        return string;
    }

    public static Vector<Entity> loadFrom(File file) throws IOException {
        XMLStreamParser xMLStreamParser = new XMLStreamParser();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            xMLStreamParser.parse(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace(System.err);
            throw new IOException("Unable to read from: " + file);
        }
        if (xMLStreamParser.hasWarningMessage()) {
            System.out.println(xMLStreamParser.getWarningMessage());
        }
        return xMLStreamParser.getEntities();
    }
}

