/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.ASFBay;
import megamek.common.Bay;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.Jumpship;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.SmallCraftBay;

public class SpaceStation
extends Jumpship
implements Serializable {
    private static final long serialVersionUID = -3160156173650960985L;

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += 25000.0;
        d += (double)(100000 * this.getDocks());
        double d2 = (double)((float)this.getOriginalWalkMP() * this.weight) * 0.06;
        d += d2 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += 1000.0;
        if (this.hasHPG()) {
            d += 1.0E9;
        }
        d += (double)(200 * this.getFuel()) / this.getFuelPerTon();
        d += this.getArmorWeight(this.locations() - 2) * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)(5000000 * this.getGravDeck());
        d += (double)(10000000 * this.getGravDeckLarge());
        d += (double)(40000000 * this.getGravDeckHuge());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 20000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        double d3 = 5.0;
        return Math.round((d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()))) * d3);
    }
}

