/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKGunEmplacementFile
extends BLKFile
implements IMechLoader {
    public BLKGunEmplacementFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        GunEmplacement gunEmplacement = new GunEmplacement();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        gunEmplacement.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            gunEmplacement.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            gunEmplacement.setModel("");
        }
        this.setTechLevel(gunEmplacement);
        if (!this.dataFile.exists("ConstructionFactor")) {
            throw new EntityLoadingException("Could not find block.");
        }
        gunEmplacement.initConstructionFactor(this.dataFile.getDataAsInt("ConstructionFactor")[0]);
        if (this.dataFile.exists("Height")) {
            gunEmplacement.setHeight(this.dataFile.getDataAsInt("Height")[0]);
        }
        if (this.dataFile.exists("Turret")) {
            gunEmplacement.setTurret(true);
            gunEmplacement.initTurretArmor(this.dataFile.getDataAsInt("Turret")[0]);
        }
        this.loadEquipment(gunEmplacement, "North", 1);
        this.loadEquipment(gunEmplacement, "East", 2);
        this.loadEquipment(gunEmplacement, "West", 3);
        if (gunEmplacement.hasTurret()) {
            this.loadEquipment(gunEmplacement, "Turret", 4);
        }
        this.loadEquipment(gunEmplacement, "Building", 0);
        return gunEmplacement;
    }
}

