/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Protomech;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKProtoFile
extends BLKFile
implements IMechLoader {
    public BLKProtoFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        Protomech protomech = new Protomech();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        protomech.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            protomech.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            protomech.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        protomech.setYear(this.dataFile.getDataAsInt("year")[0]);
        this.setTechLevel(protomech);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        protomech.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        protomech.setMovementMode(12);
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        protomech.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (this.dataFile.exists("jumpingMP")) {
            protomech.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        boolean bl = false;
        if (6 == nArray.length) {
            bl = true;
        } else if (5 == nArray.length) {
            bl = false;
        } else {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        protomech.setHasMainGun(bl);
        for (int i = 0; i < nArray.length; ++i) {
            protomech.initializeArmor(nArray[i], i);
        }
        protomech.autoSetInternal();
        String[] stringArray = protomech.getLocationNames();
        for (int i = 0; i < protomech.locations(); ++i) {
            this.loadEquipment(protomech, stringArray[i], i);
        }
        return protomech;
    }

    private void loadEquipment(Protomech protomech, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = protomech.getTechLevel() == 2 ? "Clan " : "IS ";
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string3 = stringArray[i].trim();
            int n2 = string3.indexOf("Ammo (");
            int n3 = 0;
            if (n2 > 0) {
                try {
                    object = string3.substring(n2 + 6, string3.length() - 1);
                    n3 = Integer.parseInt((String)object);
                    if (n3 < 0) {
                        throw new EntityLoadingException("Invalid number of shots in: " + string3 + ".");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new EntityLoadingException("Could not determine the number of shots in: " + string3 + ".");
                }
                string3 = string3.substring(0, n2 + 4);
            }
            if ((object = EquipmentType.get(string3)) == null) {
                object = EquipmentType.get(string2 + string3);
            }
            if (object == null) continue;
            try {
                if (n2 > 0) {
                    protomech.addEquipment((EquipmentType)object, n, false, n3);
                    continue;
                }
                protomech.addEquipment((EquipmentType)object, n);
                continue;
            }
            catch (LocationFullException locationFullException) {
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }
}

