/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

public class ChemicalLaserHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 2304364403526293671L;

    public ChemicalLaserHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -3;
    }

    protected int calcDamagePerHit() {
        double d = ((AmmoType)this.ammo.getType()).getRackSize() * ((AmmoType)this.ammo.getType()).getDamagePerShot();
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            d *= (double)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.game.getOptions().booleanOption("tacops_altdmg")) {
            if (this.nRange <= 1) {
                d += 1.0;
            } else if (this.nRange > this.wtype.getMediumRange() && this.nRange <= this.wtype.getLongRange()) {
                d -= 1.0;
            }
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            d -= 1.0;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        return (int)Math.ceil(d);
    }

    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            this.ae.heatBuildup += this.wtype.getHeat();
        }
    }
}

