/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.EnergyWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPCHandler
extends EnergyWeaponHandler {
    private static final long serialVersionUID = 5545991061428671743L;

    public PPCHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            int n = this.wtype.getHeat();
            if (this.game.getOptions().booleanOption("tacops_energy_weapons")) {
                n = Compute.dialDownHeat(this.weapon, this.wtype, this.ae.getPosition().distance(this.target.getPosition()));
            }
            this.ae.heatBuildup += n;
            if (this.weapon.hasChargedCapacitor()) {
                this.ae.heatBuildup += 5;
            }
        }
    }

    @Override
    protected int calcDamagePerHit() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        float f = this.wtype.getDamage(n);
        if (this.game.getOptions().booleanOption("tacops_energy_weapons") && this.wtype.hasModes()) {
            f = Compute.dialDownDamage(this.weapon, this.wtype, n);
        }
        if (this.weapon.hasChargedCapacitor()) {
            f += 5.0f;
        }
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            f *= (float)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.game.getOptions().booleanOption("tacops_altdmg")) {
            if (n <= 1) {
                f += 1.0f;
            } else if (n > this.wtype.getMediumRange() && n <= this.wtype.getLongRange()) {
                f -= 1.0f;
            }
        }
        if (this.game.getOptions().booleanOption("tacops_range") && n > this.wtype.getRanges(this.weapon)[3]) {
            f -= 1.0f;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (int)Compute.directBlowInfantryDamage(f, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
        } else if (this.bDirect) {
            f = Math.min(f + (float)(this.toHit.getMoS() / 3), f * 2.0f);
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        return (int)Math.ceil(f);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        int n;
        int n2;
        if (this.game.getOptions().booleanOption("tacops_ppc_inhibitors") && this.wtype.hasModes() && this.weapon.curMode().equals("Field Inhibitor OFF")) {
            n2 = 0;
            n = Compute.d6(2);
            int n3 = Compute.effectiveDistance(this.game, this.ae, this.target);
            if (n3 >= 3) {
                n2 = 3;
            } else if (n3 == 2) {
                n2 = 6;
            } else if (n3 == 1) {
                n2 = 10;
            }
            this.r = new Report(3175);
            this.r.subject = this.subjectId;
            this.r.indent();
            vector.addElement(this.r);
            this.r = new Report(3180);
            this.r.subject = this.subjectId;
            this.r.indent();
            this.r.add(n2);
            this.r.add(n);
            if (n < n2) {
                int n4 = this.weapon.getLocation();
                this.weapon.setDestroyed(true);
                for (int i = 0; i < this.ae.getNumberOfCriticals(n4); ++i) {
                    Mounted mounted;
                    CriticalSlot criticalSlot = this.ae.getCritical(n4, i);
                    if (criticalSlot == null || criticalSlot.getType() != 0 || !(mounted = this.ae.getEquipment(criticalSlot.getIndex())).equals(this.weapon)) continue;
                    this.ae.hitAllCriticals(n4, i);
                }
                this.r.choose(false);
                vector.addElement(this.r);
                vector.addAll(this.server.damageEntity(this.ae, new HitData(n4), 10, false, Server.DamageType.NONE, true));
                this.r = new Report(3185);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
            } else {
                this.r.choose(true);
                vector.addElement(this.r);
            }
        }
        if (this.weapon.hasChargedCapacitor() && this.roll == 2) {
            this.r = new Report(3178);
            this.r.subject = this.ae.getId();
            this.r.indent();
            vector.add(this.r);
            n2 = this.weapon.getLocation();
            this.weapon.setDestroyed(true);
            for (n = 0; n < this.ae.getNumberOfCriticals(n2); ++n) {
                Mounted mounted;
                CriticalSlot criticalSlot = this.ae.getCritical(n2, n);
                if (criticalSlot == null || criticalSlot.getType() == 0 || !(mounted = this.ae.getEquipment(criticalSlot.getIndex())).equals(this.weapon)) continue;
                criticalSlot.setDestroyed(true);
                break;
            }
        }
        if (this.weapon.hasChargedCapacitor()) {
            this.weapon.getLinkedBy().setMode("Off");
        }
        return false;
    }
}

