/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.EnergyWeaponHandler;
import megamek.server.Server;

public class PulseLaserWeaponHandler
extends EnergyWeaponHandler {
    private static final long serialVersionUID = -5701939682138221449L;

    public PulseLaserWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        float f = this.wtype.getDamage();
        if (this.game.getOptions().booleanOption("tacops_energy_weapons") && this.wtype.hasModes()) {
            f = Compute.dialDownDamage(this.weapon, this.wtype, this.nRange);
        }
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            f *= (float)((BattleArmor)this.ae).getShootingStrength();
        }
        int n = this.ae.getPosition().distance(this.target.getPosition());
        if (this.game.getOptions().booleanOption("tacops_altdmg")) {
            if (n <= 1) {
                f += 1.0f;
            } else if (n > this.wtype.getMediumRange() && n <= this.wtype.getLongRange()) {
                f -= 1.0f;
            }
        }
        if (this.game.getOptions().booleanOption("tacops_range") && n > this.wtype.getRanges(this.weapon)[3]) {
            f = (int)Math.floor((double)f / 2.0);
            f -= 1.0f;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (float)Compute.directBlowInfantryDamage(f, this.bDirect ? this.toHit.getMoS() / 3 : 0, 2);
        } else if (this.bDirect) {
            f = Math.min(f + (float)(this.toHit.getMoS() / 3), f * 2.0f);
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        return (int)Math.ceil(f);
    }
}

