/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UltraWeaponHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 7551194199079004134L;
    int howManyShots;

    public UltraWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void useAmmo() {
        this.setDone();
        this.checkAmmo();
        int n = this.ae.getTotalAmmoOfType(this.ammo.getType());
        if (n > 1) {
            this.howManyShots = 2;
        }
        if (n == 1) {
            this.howManyShots = 1;
        }
        if (n == 0) {
            // empty if block
        }
        if (this.ammo.getShotsLeft() == 0) {
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        if (this.ammo.getShotsLeft() == 1) {
            this.ammo.setShotsLeft(0);
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - (this.howManyShots == 2 ? 1 : 0));
        } else {
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - this.howManyShots);
        }
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        this.bSalvo = true;
        if (this.howManyShots == 1) {
            return this.howManyShots;
        }
        int n2 = 0;
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        if (this.bDirect) {
            n2 += this.toHit.getMoS() / 3 * 2;
        }
        boolean bl = this.game.getOptions().booleanOption("tacops_clusterhitpen");
        int[] nArray = this.wtype.getRanges(this.weapon);
        if (bl) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= nArray[2] ? (n2 += 0) : --n2);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > nArray[3]) {
            n2 -= 2;
        }
        int n3 = n = this.allShotsHit() ? this.howManyShots : Compute.missilesHit(this.howManyShots, n2);
        if (!this.weapon.isJammed()) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(" shot(s) ");
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
            this.r = new Report(3345);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        return n;
    }

    @Override
    protected void addHeat() {
        for (int i = 0; i < this.howManyShots; ++i) {
            super.addHeat();
        }
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        if (this.roll == 2 && this.howManyShots == 2) {
            this.r = new Report();
            this.r.subject = this.subjectId;
            this.weapon.setJammed(true);
            if (this.wtype.getAmmoType() == 20) {
                this.r.messageId = 3160;
                this.weapon.setHit(true);
            } else {
                this.r.messageId = 3170;
            }
            vector.addElement(this.r);
            return false;
        }
        return false;
    }

    @Override
    protected int calcDamagePerHit() {
        double d = this.wtype.getDamage();
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = this.wtype.getDamage() * this.howManyShots;
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
            if (this.howManyShots > 1) {
                d += 1.0;
            }
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            d = (int)Math.floor(d * 0.75);
        }
        return (int)d;
    }

    @Override
    protected boolean usesClusterTable() {
        return true;
    }
}

