/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.EnergyWeaponHandler;
import megamek.server.Server;

public class VariableSpeedPulseLaserWeaponHandler
extends EnergyWeaponHandler {
    private static final long serialVersionUID = -5701939682138221449L;

    public VariableSpeedPulseLaserWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int[] nArray = this.wtype.getRanges(this.weapon);
        float f = this.wtype.getDamage(n);
        if (this.game.getOptions().booleanOption("tacops_energy_weapons") && this.wtype.hasModes()) {
            f = Compute.dialDownDamage(this.weapon, this.wtype, n);
        }
        if (this.game.getOptions().booleanOption("tacops_altdmg")) {
            if (n <= 1) {
                f += 1.0f;
            } else if (n > this.wtype.getMediumRange() && n <= this.wtype.getLongRange()) {
                f -= 1.0f;
            }
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (float)Compute.directBlowInfantryDamage(f, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
            f = n <= nArray[1] ? (f += 3.0f) : (n <= nArray[2] ? (f += 2.0f) : (f += 1.0f));
        } else if (this.bDirect) {
            f = Math.min(f + (float)(this.toHit.getMoS() / 3), f * 2.0f);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && n > nArray[3]) {
            f = (int)Math.floor((double)f / 2.0);
            f -= 1.0f;
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        return (int)Math.ceil(f);
    }

    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            int n = this.wtype.getHeat();
            if (this.game.getOptions().booleanOption("tacops_energy_weapons")) {
                n = Compute.dialDownHeat(this.weapon, this.wtype, this.ae.getPosition().distance(this.target.getPosition()));
            }
            this.ae.heatBuildup += n;
            if (this.weapon.hasChargedCapacitor()) {
                this.ae.heatBuildup += 5;
            }
        }
    }
}

