/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.FighterSquadron;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.ITerrain;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponHandler
implements AttackHandler,
Serializable {
    private static final long serialVersionUID = 7137408139594693559L;
    public ToHitData toHit;
    public WeaponAttackAction waa;
    public int roll;
    protected IGame game;
    protected transient Server server;
    protected Report r;
    protected boolean bMissed;
    protected boolean bSalvo = false;
    protected boolean bGlancing = false;
    protected boolean bDirect = false;
    protected boolean nukeS2S = false;
    protected WeaponType wtype;
    protected Mounted weapon;
    protected Entity ae;
    protected Targetable target;
    protected int subjectId;
    protected int nRange;
    protected int nDamPerHit;
    protected int attackValue;
    protected boolean throughFront;
    protected boolean announcedEntityFiring = false;
    protected boolean missed = false;
    protected Server.DamageType damageType;
    protected int generalDamageType = -1;
    protected Vector<Integer> insertedAttacks = new Vector();

    @Override
    public int getAttackerId() {
        return this.ae.getId();
    }

    @Override
    public boolean cares(IGame.Phase phase) {
        return phase == IGame.Phase.PHASE_FIRING;
    }

    protected boolean doChecks(Vector<Report> vector) {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.server = Server.getServerInstance();
    }

    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    protected int calcHits(Vector<Report> vector) {
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() != this.target.getTargetId()) {
            this.bSalvo = true;
            int n = this.allShotsHit() ? ((BattleArmor)this.ae).getShootingStrength() : Compute.missilesHit(((BattleArmor)this.ae).getShootingStrength());
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(" troopers ");
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.add(this.r);
            return n;
        }
        return 1;
    }

    protected int calcnCluster() {
        return 1;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        this.insertAttacks(phase, vector);
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        if (entity != null) {
            this.ae.setLastTarget(entity.getId());
        }
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("tacops_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.ae.getId();
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.toHit.setMoS(this.roll - Math.max(2, this.toHit.getValue()));
        boolean bl3 = this.bDirect = this.game.getOptions().booleanOption("tacops_direct_blow") && this.toHit.getMoS() / 3 >= 1 && entity != null;
        if (this.bDirect) {
            this.r = new Report(3189);
            this.r.subject = this.ae.getId();
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.nDamPerHit = this.calcDamagePerHit();
        this.addHeat();
        boolean bl4 = this.doChecks(vector);
        if (bl4) {
            this.bMissed = true;
        }
        if (this.specialResolution(vector, entity, this.bMissed)) {
            return false;
        }
        if (this.bMissed && !bl4) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        int n2 = this.calcnCluster();
        if (this.ae instanceof Aero && this.target instanceof Aero) {
            if (this.usesClusterTable()) {
                this.nDamPerHit = 1;
                n = this.attackValue;
                n2 = 5;
            } else {
                this.nDamPerHit = this.attackValue;
                n = 1;
                n2 = 1;
            }
        }
        if (this.bMissed) {
            return false;
        }
        int n3 = 0;
        if (bl && building != null) {
            n3 = (int)Math.ceil((double)building.getPhaseCF(this.target.getPosition()) / 10.0);
        }
        if (n == 0) {
            this.r = new Report(3365);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        while (n > 0) {
            if (this.target.getTargetType() == 2 || this.target.getTargetType() == 4) {
                this.handleIgnitionDamage(vector, building, this.bSalvo, n);
                return false;
            }
            if (this.target.getTargetType() == 1) {
                int n4 = this.nDamPerHit * n;
                this.handleClearDamage(vector, building, n4, this.bSalvo);
                return false;
            }
            if (this.target.getTargetType() == 3) {
                int n5 = this.nDamPerHit * n;
                this.handleBuildingDamage(vector, building, n5, this.bSalvo, this.target.getPosition());
                return false;
            }
            if (entity == null) continue;
            this.handleEntityDamage(entity, vector, building, n, n2, this.nDamPerHit, n3);
            this.server.creditKill(entity, this.ae);
            n -= n2;
        }
        Report.addNewline(vector);
        return false;
    }

    protected int calcDamagePerHit() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        double d = this.wtype.getDamage(n);
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            d *= (double)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0);
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && n > this.wtype.getRanges(this.weapon)[3]) {
            d = (int)Math.floor(d * 0.75);
        }
        return (int)d;
    }

    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int n2 = 0;
        int n3 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        if (n3 == 1) {
            n2 = this.wtype.getRoundShortAV();
        } else if (n3 == 2) {
            n2 = this.wtype.getRoundMedAV();
        } else if (n3 == 3) {
            n2 = this.wtype.getRoundLongAV();
        } else if (n3 == 4) {
            n2 = this.wtype.getRoundExtAV();
        }
        return n2;
    }

    protected double getSquadronMultiplier() {
        double d = 1.0;
        if (this.ae instanceof FighterSquadron) {
            FighterSquadron fighterSquadron = (FighterSquadron)this.ae;
            d = (double)fighterSquadron.getNFighters() / (double)fighterSquadron.getN0Fighters();
        }
        return d;
    }

    protected int getCapMisMod() {
        return 0;
    }

    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        this.missed = false;
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData.setGeneralDamageType(this.generalDamageType);
        hitData.setCapital(this.wtype.isCapital());
        hitData.setBoxCars(this.roll == 12);
        hitData.setCapMisCritMod(this.getCapMisMod());
        if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
            this.r = new Report(3460);
            this.r.subject = this.subjectId;
            this.r.add(entity.getShortName());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            this.r.indent(2);
            vector.addElement(this.r);
            boolean bl = false;
            this.missed = true;
            return;
        }
        if (!this.bSalvo) {
            this.r = new Report(3405);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getTableDesc());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if (hitData.hitAimedLocation()) {
            this.r = new Report(3410);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n5 = n3 * Math.min(n2, n);
        if (this.bDirect) {
            hitData.makeDirectBlow(this.toHit.getMoS() / 3);
        }
        if (n4 > 0) {
            int n6 = Math.min(n4, n5);
            n5 -= n6;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n6, entity.getPosition());
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if ((n5 = this.checkTerrain(n5, entity, vector)) == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
            this.missed = true;
        } else {
            if (this.bGlancing) {
                hitData.makeGlancingBlow();
            }
            vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront, false, this.nukeS2S));
        }
    }

    protected void handleIgnitionDamage(Vector<Report> vector, Building building, boolean bl, int n) {
        TargetRoll targetRoll;
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if ((targetRoll = new TargetRoll(this.wtype.getFireTN(), this.wtype.getName())).getValue() != Integer.MAX_VALUE) {
            Report.addNewline(vector);
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, false, targetRoll, true, -1, vector);
        }
    }

    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }

    protected void handleBuildingDamage(Vector<Report> vector, Building building, int n, boolean bl, Coords coords) {
        if (!bl) {
            this.r = new Report(3390);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        Report.addNewline(vector);
        Vector<Report> vector2 = this.server.damageBuilding(building, n, coords);
        for (Report report : vector2) {
            report.subject = this.subjectId;
        }
        vector.addAll(vector2);
        this.server.damageInfantryIn(building, n, coords);
    }

    protected boolean allShotsHit() {
        return (this.target.getTargetType() == 4 || this.target.getTargetType() == 3) && this.nRange <= 1 || this.target.getTargetType() == 1;
    }

    protected void reportMiss(Vector<Report> vector) {
        this.r = new Report(3220);
        this.r.subject = this.subjectId;
        vector.addElement(this.r);
    }

    protected WeaponHandler() {
    }

    public WeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        this.damageType = Server.DamageType.NONE;
        this.toHit = toHitData;
        this.waa = weaponAttackAction;
        this.game = iGame;
        this.ae = this.game.getEntity(this.waa.getEntityId());
        this.weapon = this.ae.getEquipment(this.waa.getWeaponId());
        this.wtype = (WeaponType)this.weapon.getType();
        this.target = this.game.getTarget(this.waa.getTargetType(), this.waa.getTargetId());
        this.server = server;
        this.subjectId = this.getAttackerId();
        this.nRange = this.ae.getPosition().distance(this.target.getPosition());
        this.throughFront = this.target instanceof Mech ? Compute.isThroughFrontHex(this.game, this.ae.getPosition(), (Entity)this.target) : true;
        this.roll = Compute.d6(2);
        this.useAmmo();
        this.attackValue = (int)Math.ceil(this.getSquadronMultiplier() * (double)this.calcAttackValue());
    }

    protected void useAmmo() {
        this.setDone();
    }

    protected void setDone() {
        this.weapon.setUsedThisRound(true);
    }

    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            this.ae.heatBuildup += this.wtype.getHeat();
        }
    }

    protected boolean usesClusterTable() {
        return false;
    }

    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        return false;
    }

    @Override
    public boolean announcedEntityFiring() {
        return this.announcedEntityFiring;
    }

    @Override
    public void setAnnouncedEntityFiring(boolean bl) {
        this.announcedEntityFiring = bl;
    }

    @Override
    public WeaponAttackAction getWaa() {
        return this.waa;
    }

    public int checkTerrain(int n, Entity entity, Vector<Report> vector) {
        if (this.game.getOptions().booleanOption("tacops_woods_cover") && (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(1) || this.game.getBoard().getHex(entity.getPosition()).containsTerrain(5))) {
            ITerrain iTerrain = this.game.getBoard().getHex(entity.getPosition()).getTerrain(1);
            ITerrain iTerrain2 = this.game.getBoard().getHex(entity.getPosition()).getTerrain(5);
            int n2 = 0;
            String string = "";
            if (iTerrain != null) {
                n2 = iTerrain.getLevel() * 2;
                string = "wooded";
            } else if (iTerrain2 != null) {
                n2 = iTerrain2.getLevel() * 2;
                string = "jungle";
            }
            n2 = Math.min(n, n2);
            n = Math.max(0, n - n2);
            this.server.tryClearHex(entity.getPosition(), n2, this.ae.getId());
            Report.addNewline(vector);
            Report report = new Report(6427);
            report.subject = entity.getId();
            report.add(string);
            report.add(n2);
            report.indent(2);
            report.newlines = 0;
            vector.add(report);
        }
        return n;
    }

    protected boolean canDoDirectBlowDamage() {
        return true;
    }

    protected void insertAttacks(IGame.Phase phase, Vector<Report> vector) {
    }
}

