/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Vector;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.ITerrainFactory;
import megamek.common.PlanetaryConditions;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeatherProcessor
extends DynamicTerrainProcessor {
    private IGame game;
    Vector<Report> vPhaseReport;
    int modSnowTurn = 0;
    int heavySnowTurn = 0;
    int sleetTurn = 0;
    int iceTurn = 0;

    public WeatherProcessor(Server server) {
        super(server);
    }

    @Override
    void doEndPhaseChanges(Vector<Report> vector) {
        this.game = this.server.getGame();
        this.vPhaseReport = vector;
        this.resolveWeather();
        this.vPhaseReport = null;
    }

    private void debugTime(String string, boolean bl) {
    }

    private void resolveWeather() {
        Report report;
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        IBoard iBoard = this.game.getBoard();
        int n = iBoard.getWidth();
        int n2 = iBoard.getHeight();
        PlanetaryConditions planetaryConditions = this.game.getPlanetaryConditions();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!planetaryConditions.isTerrainAffected()) {
            return;
        }
        this.debugTime("resolve weather 1", true);
        if (planetaryConditions.getWeather() == 6 && this.game.getBoard().onGround()) {
            ++this.modSnowTurn;
            if (this.modSnowTurn == 9) {
                bl = true;
            }
            if (this.modSnowTurn == 19) {
                bl2 = true;
                bl3 = true;
            }
        }
        if (planetaryConditions.getWeather() == 7 && this.game.getBoard().onGround()) {
            ++this.heavySnowTurn;
            if (this.heavySnowTurn == 4) {
                bl = true;
            }
            if (this.heavySnowTurn == 14) {
                bl2 = true;
            }
            if (this.heavySnowTurn == 19) {
                bl3 = true;
            }
        }
        if (planetaryConditions.getWeather() == 8 && this.game.getBoard().onGround()) {
            ++this.sleetTurn;
            if (this.sleetTurn == 14) {
                bl3 = true;
            }
        }
        if (planetaryConditions.getWeather() == 9 && this.game.getBoard().onGround()) {
            ++this.iceTurn;
            if (this.iceTurn == 14) {
                bl3 = true;
            }
        }
        if (bl) {
            report = new Report(5505, 0);
            this.vPhaseReport.addElement(report);
        }
        if (bl2) {
            report = new Report(5510, 0);
            this.vPhaseReport.addElement(report);
        }
        if (bl3) {
            report = new Report(5515, 0);
            this.vPhaseReport.addElement(report);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Coords coords = new Coords(i, j);
                IHex iHex = iBoard.getHex(i, j);
                if (iHex.containsTerrain(19)) {
                    if (iHex.terrainLevel(19) == 1) {
                        if (planetaryConditions.putOutFire()) {
                            this.server.removeFire(coords, "weather conditions");
                        }
                    } else {
                        iHex.removeTerrain(19);
                        iHex.addTerrain(iTerrainFactory.createTerrain(19, 1));
                        this.server.sendChangedHex(coords);
                    }
                }
                if (bl3 && !iHex.containsTerrain(17) && iHex.containsTerrain(2)) {
                    iHex.addTerrain(iTerrainFactory.createTerrain(17, 1));
                    this.server.sendChangedHex(coords);
                }
                if (!(!bl || iHex.containsTerrain(18) || iHex.containsTerrain(2) && !iHex.containsTerrain(17) || iHex.containsTerrain(8))) {
                    iHex.addTerrain(iTerrainFactory.createTerrain(18, 1));
                    this.server.sendChangedHex(coords);
                }
                if (bl2 && iHex.terrainLevel(18) <= 1 && (!iHex.containsTerrain(2) || iHex.containsTerrain(17)) && !iHex.containsTerrain(8)) {
                    iHex.addTerrain(iTerrainFactory.createTerrain(18, 2));
                    this.server.sendChangedHex(coords);
                }
                if (iHex.terrainLevel(18) > 1 && iHex.containsTerrain(19) && iHex.getFireTurn() == 3) {
                    iHex.removeTerrain(18);
                    if (!iHex.containsTerrain(15) && !iHex.containsTerrain(2)) {
                        iHex.addTerrain(iTerrainFactory.createTerrain(15, 1));
                    }
                }
                if (iHex.terrainLevel(18) == 1 && iHex.containsTerrain(19) && iHex.getFireTurn() == 1) {
                    iHex.removeTerrain(18);
                    if (!iHex.containsTerrain(15) && !iHex.containsTerrain(2)) {
                        iHex.addTerrain(iTerrainFactory.createTerrain(15, 1));
                    }
                }
                if (iHex.containsTerrain(17) && iHex.containsTerrain(19) && iHex.getFireTurn() == 2) {
                    iHex.removeTerrain(17);
                    if (!iHex.containsTerrain(15) && !iHex.containsTerrain(2)) {
                        iHex.addTerrain(iTerrainFactory.createTerrain(15, 1));
                    }
                }
                if (planetaryConditions.getWindStrength() <= 2 || !iHex.containsTerrain(2) || iHex.depth() <= 0) continue;
                if (planetaryConditions.getWindStrength() > 4) {
                    if (iHex.terrainLevel(16) > 1) continue;
                    iHex.addTerrain(iTerrainFactory.createTerrain(16, 2));
                    continue;
                }
                if (iHex.containsTerrain(16)) continue;
                iHex.addTerrain(iTerrainFactory.createTerrain(16, 1));
            }
        }
        this.debugTime("resolve weather 1 end", true);
    }
}

