/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AePlayWave;
import client.CConfig;
import client.CUser;
import client.ClientThread;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.cmd.Command;
import client.gui.Browser;
import client.gui.CMainFrame;
import client.gui.SplashWindow;
import client.gui.commands.IGUICommand;
import client.gui.commands.MailGCmd;
import client.gui.commands.PingGCmd;
import client.gui.dialog.RewardPointsDialog;
import client.gui.dialog.SignonDialog;
import client.protocol.CConnector;
import client.protocol.DataFetchClient;
import client.protocol.IClient;
import client.protocol.TransportCodec;
import client.protocol.commands.AckSignonPCmd;
import client.protocol.commands.CommPCmd;
import client.protocol.commands.IProtCommand;
import client.protocol.commands.PingPCmd;
import client.protocol.commands.PongPCmd;
import client.util.RepairManagmentThread;
import client.util.SalvageManagmentThread;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertGreen;
import com.jgoodies.looks.plastic.theme.SkyBlue;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import common.AdvancedTerrain;
import common.BMEquipment;
import common.CampaignData;
import common.Equipment;
import common.House;
import common.Influences;
import common.MMGame;
import common.Planet;
import common.PlanetEnvironment;
import common.Unit;
import common.campaign.Buildings;
import common.util.ThreadManager;
import common.util.TokenReader;
import common.util.UnitUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.rmi.dgc.VMID;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import megamek.MegaMek;
import megamek.client.Client;
import megamek.client.ui.AWT.GameOptionsDialog;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.server.Server;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MWClient
implements IClient {
    public static Object mwClientLog;
    CampaignData data = null;
    DataFetchClient dataFetcher;
    Thread updateDataFetcher;
    CConfig Config;
    public static final String CLIENT_VERSION = "0.2.40.0";
    CConnector Connector;
    TimeOutThread TO;
    Collection<CUser> Users;
    TreeMap<String, MMGame> servers = new TreeMap();
    Server myServer = null;
    Date mytime = new Date(System.currentTimeMillis());
    Vector<IBasicOption> GameOptions = new Vector(1, 1);
    Vector<String> decodeBuffer = new Vector(1, 1);
    Browser browser;
    boolean SignOff = false;
    boolean packFrame = false;
    boolean SoundMuted = false;
    public String myUsername = "";
    String password = "";
    String myDedOwners = "";
    int myPort = -1;
    int gameCount = 0;
    long lastResetCheck = System.currentTimeMillis();
    int dedRestartAt = 50;
    int savedGamesMaxDays = 30;
    long TimeOut = 120L;
    long LastPing = 0L;
    PlanetEnvironment currentEnvironment;
    AdvancedTerrain aTerrain = null;
    TreeMap<String, String[]> allOps;
    Dimension MapSize;
    int mapMedium = 0;
    SplashWindow splash = null;
    Buildings buildingTemplate = null;
    public static final String CAMPAIGN_PATH = "data/campaign/";
    public static final String PROTOCOL_DELIMITER = "\t";
    public static final String PROTOCOL_PREFIX = "/";
    public static final String COMMAND_DELIMITER = "|";
    public static final String GUI_PREFIX = "/";
    public static final String CAMPAIGN_PREFIX = "/";
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_LOGGEDOUT = 1;
    public static final int STATUS_RESERVE = 2;
    public static final int STATUS_ACTIVE = 3;
    public static final int STATUS_FIGHTING = 4;
    public static final int REFRESH_STATUS = 0;
    public static final int REFRESH_USERLIST = 1;
    public static final int REFRESH_PLAYERPANEL = 2;
    public static final int REFRESH_BATTLETABLE = 4;
    public static final int REFRESH_HQPANEL = 5;
    public static final int REFRESH_BMPANEL = 6;
    public static final int IGNORE_PUBLIC = 0;
    public static final int IGNORE_HOUSE = 1;
    public static final int IGNORE_PRIVATE = 2;
    CCampaign theCampaign;
    CPlayer myPlayer;
    CMainFrame MainFrame;
    int Status = 0;
    int LastStatus = 0;
    TreeMap<String, IGUICommand> GUICommands = new TreeMap();
    TreeMap<String, IProtCommand> ProtCommands = new TreeMap();
    HashMap<String, Command> commands = new HashMap();
    String LastQuery = "";
    Vector<String> IgnorePublic = new Vector(1, 1);
    Vector<String> IgnoreHouse = new Vector(1, 1);
    Vector<String> IgnorePrivate = new Vector(1, 1);
    Vector<String> KeyWords = new Vector(1, 1);
    private String cacheDir;
    public Properties serverConfigs = new Properties();
    private int playerStartingEdge = -1;
    private boolean usingBots = false;
    private boolean botsOnSameTeam = false;
    private RepairManagmentThread RMT = null;
    private SalvageManagmentThread SMT = null;
    private boolean waitingOnCommand = false;
    private HashMap<String, Equipment> blackMarketEquipmentList = new HashMap();

    public static void main(String[] args) {
        boolean dedicated = false;
        CampaignData.mwlog.createClientLoggers();
        String logFileName = "./logs/megameklog.txt";
        boolean enableSplashScreen = true;
        try {
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
            System.setOut(ps);
            System.setErr(ps);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to redirect MegaMek output to " + logFileName);
        }
        CampaignData.mwlog.infoLog("Starting MekWars Client Version: 0.2.40.0");
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-dedicated") || args[i].equalsIgnoreCase("-d")) {
                    dedicated = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-disableSplash")) {
                    enableSplashScreen = false;
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-enableSplash")) continue;
                enableSplashScreen = true;
            }
            CConfig config = new CConfig(dedicated);
            if (!enableSplashScreen) {
                config.setParam("ENABLESPLASHSCREEN", "false");
            } else {
                config.setParam("ENABLESPLASHSCREEN", "true");
            }
            File cache = new File("./data/mechfiles/units.cache");
            if (cache.exists()) {
                cache.delete();
            }
            new MWClient(config);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Couldn't create Client Object");
            System.exit(1);
        }
    }

    public MWClient(CConfig config) {
        this.Config = config;
        if (this.isDedicated()) {
            try {
                Runtime runTime = Runtime.getRuntime();
                String[] call = new String[]{"java", "-Xmx512m", "-jar", "MekWarsDed.jar"};
                runTime.exec(call);
                System.exit(0);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to find MekWarsDed.jar");
            }
        } else {
            this.setLookAndFeel(false);
            if (this.Config.isParam("ENABLESPLASHSCREEN")) {
                this.splash = new SplashWindow();
            }
        }
        try {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            CampaignData.mwlog.errLog("RT Info: " + rt.getName());
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        this.Connector = new CConnector(this);
        this.Connector.setSplashWindow(this.splash);
        this.Users = Collections.synchronizedList(new Vector(1, 1));
        if (!this.isDedicated()) {
            block50: {
                this.theCampaign = new CCampaign(this);
                this.myPlayer = this.theCampaign.getPlayer();
                this.createProtCommands();
                this.createGUICommands();
                if (this.splash != null) {
                    this.splash.setStatus(this.splash.STATUS_FETCHINGDATA);
                }
                boolean shouldShowSignOn = false;
                if (!Boolean.parseBoolean(this.getConfigParam("AUTOCONNECT"))) {
                    shouldShowSignOn = true;
                } else if (this.getConfigParam("SERVERIP").trim().equals("")) {
                    shouldShowSignOn = true;
                } else if (this.getConfigParam("NAME").trim().equals("")) {
                    shouldShowSignOn = true;
                } else if (this.getConfigParam("NAMEPASSWORD").trim().equals("")) {
                    shouldShowSignOn = true;
                }
                if (shouldShowSignOn) {
                    if (this.splash != null) {
                        this.splash.setStatus(this.splash.STATUS_INPUTWAIT);
                    }
                    new SignonDialog(this);
                    if (this.splash != null) {
                        this.splash.setStatus(this.splash.STATUS_FETCHINGDATA);
                    }
                }
                this.dataFetcher = new DataFetchClient(Integer.parseInt(this.Config.getParam("DATAPORT")), Integer.parseInt(this.Config.getParam("SOCKETTIMEOUTDELAY")));
                try {
                    BufferedReader dis = new BufferedReader(new InputStreamReader(new FileInputStream("data/servers/" + this.Config.getParam("SERVERIP") + "." + this.Config.getParam("SERVERPORT") + "/dataLastUpdated.dat")));
                    Date lastTS = new Date(Long.parseLong(dis.readLine()));
                    this.dataFetcher.setLastTimestamp(lastTS);
                }
                catch (Throwable t) {
                    CampaignData.mwlog.infoLog("Couldn't read timestamp of last datafetch. Will need to fetch all planetchanges since last full update.");
                }
                this.dataFetcher.setData(this.Config.getParam("SERVERIP"), this.getCacheDir());
                try {
                    this.dataFetcher.checkForMostRecentOpList();
                }
                catch (IOException e) {
                    Object[] options = new Object[]{"Exit", "Continue"};
                    int selectedValue = JOptionPane.showOptionDialog(null, "No OpList. This usually means that you were unable to connect to the server to fetch a copy. Do you wish to exit?", "Startup error!", -1, 0, null, options, options[0]);
                    if (selectedValue != 0) break block50;
                    System.exit(0);
                }
            }
            this.setupAllOps();
        } else {
            this.createProtCommands();
            this.dataFetcher = new DataFetchClient(Integer.parseInt(this.Config.getParam("DATAPORT")), Integer.parseInt(this.Config.getParam("SOCKETTIMEOUTDELAY")));
            this.dataFetcher.setData(this.Config.getParam("SERVERIP"), this.getCacheDir());
            try {
                this.dataFetcher.getServerConfigData(this);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error While getting server config file.");
                CampaignData.mwlog.errLog(ex);
            }
            this.dataFetcher.closeDataConnection();
            File localGameOptions = new File("./mmconf");
            try {
                if (localGameOptions.exists() && (localGameOptions = new File("./mmconf/gameoptions.xml")).exists()) {
                    localGameOptions.delete();
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        System.err.println("Get Data Time: " + System.currentTimeMillis());
        System.err.flush();
        this.getData();
        System.err.println("Done Getting Data Time: " + System.currentTimeMillis());
        System.err.flush();
        this.dataFetcher.setLastTimestamp(new Date(System.currentTimeMillis()));
        this.dataFetcher.store();
        this.myUsername = this.getConfigParam("NAME");
        if (this.isDedicated() && !this.myUsername.startsWith("[Dedicated]")) {
            this.Config.setParam("NAME", "[Dedicated] " + this.Config.getParam("NAME"));
            this.myUsername = this.Config.getParam("NAME");
        }
        this.dedRestartAt = Integer.parseInt(this.getConfigParam("DEDAUTORESTART"));
        this.savedGamesMaxDays = Integer.parseInt(this.getConfigParam("MAXSAVEDGAMEDAYS"));
        this.myDedOwners = this.getConfigParam("DEDICATEDOWNERNAME");
        this.myPort = Integer.parseInt(this.getConfigParam("PORT"));
        this.IgnorePublic = this.splitString(this.Config.getParam("IGNOREPUBLIC"), ",");
        this.IgnoreHouse = this.splitString(this.Config.getParam("IGNOREHOUSE"), ",");
        this.IgnorePrivate = this.splitString(this.Config.getParam("IGNOREPRIVATE"), ",");
        this.KeyWords = this.splitString(this.Config.getParam("KEYWORDS"), ",");
        System.err.println("staring PAS Time: " + System.currentTimeMillis());
        System.err.flush();
        CampaignData.mwlog.infoLog("Starting pAS");
        PurgeAutoSaves pAS = new PurgeAutoSaves();
        new Thread(pAS).start();
        System.err.println("PAS Started Time: " + System.currentTimeMillis());
        System.err.flush();
        if (this.splash != null) {
            this.splash.setStatus(this.splash.STATUS_CONNECTING);
        }
        String chatServerIP = "";
        int chatServerPort = -1;
        try {
            chatServerIP = this.Config.getParam("SERVERIP");
            chatServerPort = this.Config.getIntParam("SERVERPORT");
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
            System.exit(1);
        }
        if (!this.isDedicated()) {
            System.err.println("Creating CMainFrame Time: " + System.currentTimeMillis());
            System.err.flush();
            this.MainFrame = new CMainFrame(this);
            System.err.println("CMainFrame Created Time: " + System.currentTimeMillis());
            System.err.flush();
            try {
                this.MainFrame.setIconImage(this.Config.getImage("LOGOUT").getImage());
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            System.err.println("Packing/Validating CMainFrame Time: " + System.currentTimeMillis());
            System.err.flush();
            if (this.packFrame) {
                this.MainFrame.pack();
            } else {
                this.MainFrame.validate();
            }
            System.err.println("done packing/validating CMainFrame Time: " + System.currentTimeMillis());
            System.err.flush();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.MainFrame.getSize();
            this.MainFrame.setExtendedState(Integer.parseInt(this.getConfigParam("WINDOWSTATE")));
            this.MainFrame.setSize(Integer.parseInt(this.getConfigParam("WINDOWWIDTH")), Integer.parseInt(this.getConfigParam("WINDOWHEIGHT")));
            this.MainFrame.setLocation(Integer.parseInt(this.getConfigParam("WINDOWLEFT")), Integer.parseInt(this.getConfigParam("WINDOWTOP")));
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setSoundMuted(this.getConfig().isParam("DISABLEALLSOUND"));
            System.err.println("Attack Menu Update Time: " + System.currentTimeMillis());
            System.err.flush();
            this.MainFrame.updateAttackMenu();
            System.err.println("Attack Menu Update done Time: " + System.currentTimeMillis());
            System.err.flush();
            System.err.println("MainFrame Visible Time: " + System.currentTimeMillis());
            System.err.flush();
            System.err.println("Creating Browser Time: " + System.currentTimeMillis());
            System.err.flush();
            this.browser = new Browser();
            Browser.init();
            System.err.println("Browser Created Time: " + System.currentTimeMillis());
            System.err.flush();
            System.err.println("Connecting to Server Time: " + System.currentTimeMillis());
            System.err.flush();
            this.connectToServer(chatServerIP, chatServerPort);
            System.err.println("Connected to Server Time: " + System.currentTimeMillis());
            System.err.flush();
            try {
                System.err.println("making mainframe visible: " + System.currentTimeMillis());
                System.err.flush();
                if (this.splash != null) {
                    this.splash.setStatus(this.splash.STATUS_CONSTRUCTINGGUI);
                }
                this.MainFrame.setVisible(true);
                if (this.splash != null) {
                    System.err.println("splash not null: " + System.currentTimeMillis());
                    System.err.flush();
                    this.splash.getProgressBar().setValue(9);
                    System.err.println("progress bar set to 9: " + System.currentTimeMillis());
                    System.err.flush();
                    this.splash.getProgressBar().setVisible(false);
                    System.err.println("progressbar going bye bye: " + System.currentTimeMillis());
                    System.err.flush();
                    this.splash.dispose();
                    System.err.println("splash going bye bye: " + System.currentTimeMillis());
                    System.err.flush();
                }
                System.err.println("splash going to null: " + System.currentTimeMillis());
                System.err.flush();
                this.splash = null;
                System.err.println("splash null: " + System.currentTimeMillis());
                System.err.flush();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                CampaignData.mwlog.errLog("Error closing splash / opening main frame.");
            }
            System.err.println("MainFrame Visible Done Time: " + System.currentTimeMillis());
            System.err.flush();
            this.refreshGUI(0);
            this.refreshGUI(2);
            this.refreshGUI(6);
            this.refreshGUI(5);
            this.sendChat("/c setclientversion#" + this.myUsername.trim() + "#" + CLIENT_VERSION);
            this.sendChat("/getsavedmail");
            if (Boolean.parseBoolean(this.getserverConfigs("UseAdvanceRepair"))) {
                this.RMT = new RepairManagmentThread(Long.parseLong(this.getserverConfigs("TimeForEachRepairPoint")) * 1000L, this);
                this.RMT.start();
            }
            if (Boolean.parseBoolean(this.getserverConfigs("UsePartsRepair"))) {
                this.SMT = new SalvageManagmentThread(Long.parseLong(this.getserverConfigs("TimeForEachRepairPoint")) * 1000L, this);
                this.SMT.start();
            }
        } else {
            int retryCount = 0;
            while (this.Status == 0 && retryCount++ < 20) {
                this.connectToServer(chatServerIP, chatServerPort);
                if (this.Status != 0) continue;
                CampaignData.mwlog.infoLog("Couldn't connect to server. Retrying in 90 seconds.");
                try {
                    Thread.sleep(90000L);
                }
                catch (Exception exe) {
                    CampaignData.mwlog.errLog(exe);
                    System.exit(2);
                }
            }
        }
        this.TimeOut = Long.parseLong(this.Config.getParam("TIMEOUT"));
        this.LastPing = System.currentTimeMillis() / 1000L;
        this.TO = new TimeOutThread(this);
        this.TO.run();
    }

    public synchronized void doParseDataInput(String input) {
        if (this.decodeBuffer.size() > 0) {
            Iterator<String> i = this.decodeBuffer.iterator();
            while (i.hasNext()) {
                String currS = i.next();
                this.doParseDataHelper(currS);
                i.remove();
            }
        } else {
            this.doParseDataHelper(input);
        }
    }

    private void doParseDataHelper(String input) {
        try {
            if (input.length() == 0) {
                return;
            }
            StringTokenizer ST = null;
            String task = null;
            CampaignData.mwlog.infoLog(input);
            ST = new StringTokenizer(input, COMMAND_DELIMITER);
            task = ST.nextToken();
            if (!this.commands.containsKey(task)) {
                try {
                    Class<?> cmdClass = Class.forName(this.getClass().getPackage().getName() + ".cmd." + task);
                    Constructor<?> c = cmdClass.getConstructor(MWClient.class);
                    Command cmd = (Command)c.newInstance(this);
                    this.commands.put(task, cmd);
                }
                catch (Exception e) {
                    CampaignData.mwlog.errLog(e);
                }
            }
            if (this.commands.containsKey(task)) {
                this.commands.get(task).execute(input);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public synchronized void parseDedDataInput(String data) {
        if (data.startsWith("US|") || data.startsWith("NU|") || data.startsWith("UG|") || data.startsWith("RGTS|") || data.startsWith("DSD|") || data.startsWith("USD|")) {
            this.doParseDataHelper(data);
            return;
        }
        if (!data.startsWith("PM|")) {
            return;
        }
        data = data.substring(3);
        StringTokenizer st = new StringTokenizer(data, COMMAND_DELIMITER);
        StringTokenizer own = new StringTokenizer(this.myDedOwners, "$");
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return;
        }
        if (name.equals(this.myUsername)) {
            return;
        }
        String command = st.nextToken().trim();
        if (command.equals("checkrestartcount")) {
            this.checkForRestart();
            return;
        }
        if (command.equals("displaymegameklog")) {
            CampaignData.mwlog.infoLog("display megameklog command received from " + name);
            try {
                File logFile = new File("./logs/megameklog.txt");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#MegaMek Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display megamek logs command on " + this.myUsername);
            return;
        }
        if (command.equals("displaydederrorlog")) {
            CampaignData.mwlog.infoLog("display ded error command received from " + name);
            try {
                File logFile = new File("./logs/errlog.0");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#Error Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display ded error log command on " + this.myUsername);
            return;
        }
        if (command.equals("displaydedlog")) {
            CampaignData.mwlog.infoLog("display ded log command received from " + name);
            try {
                File logFile = new File("./logs/infolog.0");
                FileInputStream fis = new FileInputStream(logFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                this.sendChat("/c sendtomisc#" + name + "#Ded Log from " + this.myUsername);
                int counter = 0;
                while (dis.ready()) {
                    this.sendChat("/c sendtomisc#" + name + "#" + dis.readLine());
                    if (counter++ % 100 != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                }
                fis.close();
                dis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sendChat("/c mm# " + name + " used the display ded log command on " + this.myUsername);
            return;
        }
        while (this.myDedOwners.equals("") || own.hasMoreTokens()) {
            String owner = own.hasMoreTokens() ? own.nextToken() : "";
            if (!this.myDedOwners.equals("") && !name.equals(owner) && this.getUser(name).getUserlevel() < 100) continue;
            if (command.equals("restart")) {
                CampaignData.mwlog.infoLog("Restart command received from " + name);
                this.stopHost();
                File localGameOptions = new File("./mmconf");
                try {
                    if (localGameOptions.exists() && (localGameOptions = new File("./mmconf/gameoptions.xml")).exists()) {
                        localGameOptions.delete();
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                this.sendChat("/c mm# " + name + " used the restart command on " + this.myUsername);
                try {
                    Runtime runTime = Runtime.getRuntime();
                    if (new File("MekWarsDed.jar").exists()) {
                        String[] call = new String[]{"java", "-Xmx512m", "-jar", "MekWarsDed.jar"};
                        runTime.exec(call);
                    } else {
                        String[] call = new String[]{"java", "-Xmx512m", "-jar", "MekWarsClient.jar"};
                        runTime.exec(call);
                    }
                    System.exit(0);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Unable to find MekWarsDed.jar");
                }
                return;
            }
            if (command.equals("reset")) {
                CampaignData.mwlog.infoLog("Reset command received from " + name);
                if (this.myServer != null) {
                    this.resetGame();
                }
                this.sendChat("/c mm# " + name + " used the reset command on " + this.myUsername);
                return;
            }
            if (command.equals("die")) {
                this.goodbye();
                System.exit(0);
            } else {
                if (command.equals("start")) {
                    CampaignData.mwlog.infoLog("Start command received from " + name);
                    if (this.myServer == null) {
                        this.startHost(true, false, false);
                    }
                    this.sendChat("/c mm# " + name + " used the start command on " + this.myUsername);
                    return;
                }
                if (command.equals("stop")) {
                    CampaignData.mwlog.infoLog("Stop command received from " + name);
                    if (this.myServer != null) {
                        this.stopHost();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                    this.sendChat("/c mm# " + name + " used the stop command on " + this.myUsername);
                    return;
                }
                if (command.equals("owners")) {
                    CampaignData.mwlog.infoLog("Owners command received from " + name);
                    this.sendChat("/mail " + name + ", My owners: " + this.myDedOwners.replace('$', ' '));
                    this.sendChat("/c mm# " + name + " used the owners command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("owner ")) {
                    CampaignData.mwlog.infoLog("Owner command received from " + name);
                    if (!this.myDedOwners.equals("")) {
                        this.myDedOwners = this.myDedOwners + "$";
                    }
                    this.myDedOwners = this.myDedOwners + command.substring("owner ".length()).trim();
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " used the owner " + this.myDedOwners + " command on " + this.myUsername);
                    return;
                }
                if (command.equals("clearowners")) {
                    CampaignData.mwlog.infoLog("Clearowners command received from " + name);
                    this.myDedOwners = "";
                    this.sendChat("/mail " + name + ", My owners: " + this.myDedOwners);
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " used the clear owners command on " + this.myUsername);
                    return;
                }
                if (command.equals("port")) {
                    CampaignData.mwlog.infoLog("Port command received from " + name);
                    this.sendChat("/mail " + name + ", My port: " + this.myPort);
                    this.sendChat("/c mm# " + name + " used the port command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("port ")) {
                    int port;
                    CampaignData.mwlog.infoLog("Port (set) command received from " + name);
                    try {
                        port = Integer.parseInt(command.substring("port ".length()).trim());
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": non-numeral port.");
                        return;
                    }
                    if (port > 0 && port < 65536) {
                        this.myPort = port;
                    } else {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": port out of valid range.");
                    }
                    String portString = Integer.toString(this.myPort);
                    this.getConfig().setParam("PORT", portString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " changed the port for " + this.myUsername + " to " + this.myPort);
                    return;
                }
                if (command.equals("savegamepurge")) {
                    CampaignData.mwlog.infoLog("Save game purge command received from " + name);
                    this.sendChat("/mail " + name + ", I purge saved games that are " + this.savedGamesMaxDays + " days old, or older.");
                    this.sendChat("/c mm# " + name + " used the save game purge command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("savegamepurge ")) {
                    int mySavedGamesMaxDays = 7;
                    CampaignData.mwlog.infoLog("Savegamepurge command received from " + name);
                    try {
                        mySavedGamesMaxDays = Integer.parseInt(command.substring("savegamepurge ".length()).trim());
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.infoLog("Command error: " + command + ": invalid number.");
                        return;
                    }
                    String purgeString = Integer.toString(mySavedGamesMaxDays);
                    this.getConfig().setParam("MAXSAVEDGAMEDAYS", purgeString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.savedGamesMaxDays = mySavedGamesMaxDays;
                    this.sendChat("/c mm# " + name + " changed the save game purge for " + this.myUsername + " to " + mySavedGamesMaxDays + " days.");
                    return;
                }
                if (command.equals("displaysavedgames")) {
                    CampaignData.mwlog.infoLog("displaysavedgames command received from " + name);
                    String list = "<br><b>Saved files on " + this.myUsername + "</b><br>";
                    String dateTimeFormat = "MM/dd/yyyy HH:mm:ss";
                    SimpleDateFormat sDF = new SimpleDateFormat(dateTimeFormat);
                    try {
                        File tempFile = new File("./savegames/");
                        File[] fileList = tempFile.listFiles();
                        for (int i = 0; i < fileList.length; ++i) {
                            File dateFile = fileList[i];
                            Date date = new Date(dateFile.lastModified());
                            String dateTime = sDF.format(date);
                            list = list + "<a href=\"MEKMAIL" + this.myUsername + "*loadgamewithfullpath " + fileList[i] + "\">Load " + fileList[i] + "</a> " + dateTime + "<br>";
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat("/mail " + name + ", " + list);
                    this.sendChat("/c mm# " + name + " used the display saved games command on " + this.myUsername);
                    return;
                }
                if (command.equals("update")) {
                    this.sendChat("/c mm# " + name + " used the update command on " + this.myUsername);
                    CampaignData.mwlog.infoLog("Update command received from " + name);
                    try {
                        if (this.myServer != null) {
                            this.myServer.die();
                        }
                        this.goodbye();
                        Runtime runtime = Runtime.getRuntime();
                        String[] call = new String[]{"java", "-jar", "MekWarsAutoUpdate.jar", "DEDICATED", this.getConfigParam("DEDUPDATECOMMANDFILE")};
                        runtime.exec(call);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                    System.exit(0);
                    return;
                }
                if (command.equals("ping")) {
                    CampaignData.mwlog.infoLog("Ping command received from " + name);
                    String version = CLIENT_VERSION;
                    this.sendChat("/mail " + name + ", I'm active with version " + version + ".");
                    this.sendChat("/c mm# " + name + " used the ping command on " + this.myUsername);
                    return;
                }
            }
            if (command.equals("loadgame") || command.startsWith("loadgame ")) {
                CampaignData.mwlog.infoLog("Loadgame command received from " + name);
                String filename = "";
                if (command.startsWith("loadgame ")) {
                    filename = command.substring("loadgame ".length()).trim();
                }
                if (command.equals("loadgame") || filename.equals("")) {
                    filename = "autosave.sav";
                }
                if (this.myServer != null) {
                    if (!this.loadGame(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", Saved game loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                return;
            }
            if (command.startsWith("loadgamewithfullpath ")) {
                CampaignData.mwlog.infoLog("Loadgamewithfullpath command received from " + name);
                String filename = "";
                if (command.startsWith("loadgamewithfullpath ")) {
                    filename = command.substring("loadgamewithfullpath ".length()).trim();
                }
                if (command.equals("loadgamewithfullpath") || filename.equals("")) {
                    filename = "autosave.sav";
                }
                if (this.myServer != null) {
                    if (!this.loadGameWithFullPath(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", Saved game loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                return;
            }
            if (command.equals("loadautosave")) {
                CampaignData.mwlog.infoLog("Loadautosave command received from " + name);
                String filename = "autosave.sav";
                if (this.myServer != null) {
                    if (Boolean.parseBoolean(this.getserverConfigs("MMTimeStampLogFile"))) {
                        filename = this.getParanoidAutoSave();
                    }
                    if (!this.loadGame(filename)) {
                        this.sendChat("/mail " + name + ", Unable to load saved game.");
                    } else {
                        this.sendChat("/mail " + name + ", " + filename + " loaded.");
                    }
                }
                this.sendChat("/c mm# " + name + " loaded " + filename + " game on " + this.myUsername);
                return;
            }
            if (command.startsWith("name ")) {
                CampaignData.mwlog.infoLog("Name command received from " + name);
                String myComName = command.substring("name ".length()).trim();
                this.getConfig().setParam("NAME", myComName);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " used the set name command to change the name to " + myComName + " command on " + this.myUsername);
                this.Config.setParam("NAME", "[Dedicated] " + myComName);
                this.myUsername = this.Config.getParam("NAME");
                return;
            }
            if (command.startsWith("comment ")) {
                CampaignData.mwlog.infoLog("Prefix command received from " + name);
                String myComComment = command.substring("comment ".length()).trim();
                this.getConfig().setParam("COMMENT", myComComment);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " has set the comment to " + myComComment + " on " + this.myUsername);
                return;
            }
            if (command.startsWith("players ")) {
                CampaignData.mwlog.infoLog("Prefix command received from " + name);
                try {
                    String numPlayers = command.substring("players ".length()).trim();
                    this.getConfig().setParam("MAXPLAYERS", numPlayers);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat("/c mm# " + name + " has set the max number of players to " + numPlayers + " on " + this.myUsername);
                    return;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Unable to convert number of players to int");
                    return;
                }
            }
            if (command.equals("restartcount")) {
                CampaignData.mwlog.infoLog("Restartcount command received from " + name);
                this.sendChat("/mail " + name + ", My restart count is set to " + this.dedRestartAt + " my current game count is " + this.gameCount);
                this.sendChat("/c mm# " + name + " used the restartcount command on " + this.myUsername);
                return;
            }
            if (command.startsWith("restartcount ")) {
                CampaignData.mwlog.infoLog("restartcount change command received from " + name);
                try {
                    this.dedRestartAt = Integer.parseInt(command.substring("restartcount ".length()).trim());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.infoLog("Command error: " + command + ": bad counter.");
                    return;
                }
                String restartString = Integer.toString(this.dedRestartAt);
                this.getConfig().setParam("DEDAUTORESTART", restartString);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " changed the restart count for " + this.myUsername + " to " + this.dedRestartAt);
                return;
            }
            if (command.equals("getupdateurl")) {
                CampaignData.mwlog.infoLog("GetUpdateUrl command received from " + name);
                String updateURL = this.getConfigParam("UPDATEURL");
                this.sendChat("/c mm# " + name + " used the getUpdateURL command on " + this.myUsername);
                this.sendChat("/mail " + name + ", My update URL is " + updateURL + ".");
                return;
            }
            if (command.startsWith("setupdateurl ")) {
                CampaignData.mwlog.infoLog("setUpdateURL command received from " + name);
                String myUpdateURL = command.substring("setupdateurl ".length()).trim();
                this.getConfig().setParam("UPDATEURL", myUpdateURL);
                this.getConfig().saveConfig();
                this.setConfig();
                this.sendChat("/c mm# " + name + " used the set update url command to change the the update url to " + myUpdateURL + " on " + this.myUsername);
                return;
            }
            CampaignData.mwlog.infoLog("Command error: " + command + ": unknown command.");
            return;
        }
        this.sendChat("/c mm# " + name + " tried to use the " + command + " on " + this.myUsername + ", but does not have ownership.");
        this.sendChat("/mail " + name + ", You do not have management rights for this host!");
        CampaignData.mwlog.infoLog("Command error: " + command + ": access denied for " + name + ".");
    }

    public void processGUIInput(String input) {
        String s = null;
        if (input.startsWith("/")) {
            IGUICommand command;
            StringTokenizer ST = new StringTokenizer(input = input.substring("/".length()), " #");
            s = ST.nextToken();
            if (s.equalsIgnoreCase("c")) {
                s = "c " + ST.nextToken().toLowerCase();
            }
            if ((command = this.getGUICommand(s)) != null && command.check(s)) {
                if (!command.execute(input)) {
                    CampaignData.mwlog.infoLog("COMMAND ERROR: wrong command executed.");
                }
                return;
            }
            input = "/" + input;
            this.sendChat(input);
            s = "Sent command: \"" + input.substring("/".length()) + '\"';
            this.addToChat(s, 3, null);
        } else {
            this.sendChat(input);
            String color = this.getUser(this.myUsername).getColor();
            String addon = this.getUser(this.myUsername).getAddon();
            addon = addon.equals("") ? "" : " [" + addon + "]";
            s = "<font color=\"" + color + "\"><b>" + this.myUsername + addon + "</b></font><b>:</b> " + input;
            if (this.Config.isParam("TIMESTAMP")) {
                s = "<font color=\"" + this.Config.isParam("CHATFONTCOLOR") + "\">" + this.getShortTime() + "</font>" + s;
            }
            this.addToChat(s, 3, null);
        }
    }

    protected void createGUICommands() {
        this.addGUICommand(new PingGCmd(this));
        this.addGUICommand(new MailGCmd(this));
    }

    protected void addGUICommand(IGUICommand command) {
        this.GUICommands.put(command.getName(), command);
        if (command.isAlias()) {
            this.GUICommands.put(command.getAlias(), command);
        }
    }

    IGUICommand getGUICommand(String command) {
        return this.GUICommands.get(command);
    }

    protected void createProtCommands() {
        this.addProtCommand(new CommPCmd(this));
        this.addProtCommand(new PingPCmd(this));
        this.addProtCommand(new PongPCmd(this));
        this.addProtCommand(new AckSignonPCmd(this));
    }

    protected void addProtCommand(IProtCommand command) {
        this.ProtCommands.put(command.getName(), command);
    }

    IProtCommand getProtCommand(String command) {
        return this.ProtCommands.get(command);
    }

    public CCampaign getCampaign() {
        return this.theCampaign;
    }

    public CPlayer getPlayer() {
        return this.myPlayer;
    }

    public String getLastQuery() {
        return this.LastQuery;
    }

    public void setLastQuery(String name) {
        this.LastQuery = name;
    }

    public int getMyStatus() {
        return this.Status;
    }

    public void setLastPing(long lastping) {
        this.LastPing = lastping;
    }

    public Vector<String> getIgnorePublic() {
        return this.IgnorePublic;
    }

    public Vector<String> getIgnoreHouse() {
        return this.IgnoreHouse;
    }

    public Vector<String> getIgnorePrivate() {
        return this.IgnorePrivate;
    }

    public RepairManagmentThread getRMT() {
        return this.RMT;
    }

    public SalvageManagmentThread getSMT() {
        return this.SMT;
    }

    public Vector<String> getIgnored(int type) {
        if (type == 0) {
            return this.IgnorePublic;
        }
        if (type == 1) {
            return this.IgnoreHouse;
        }
        if (type == 2) {
            return this.IgnorePrivate;
        }
        return new Vector<String>(1, 1);
    }

    public boolean isIgnored(String name, int type) {
        if (this.getUser(name.trim()).getUserlevel() >= 100) {
            return false;
        }
        for (String next : this.getIgnored(type)) {
            if (!name.trim().equalsIgnoreCase(next.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeyWords(String input) {
        for (String currS : this.KeyWords) {
            if (input.toLowerCase().indexOf(currS.toLowerCase()) <= -1) continue;
            return true;
        }
        return false;
    }

    public String getStatus() {
        if (this.Status == 0) {
            return "Not connected";
        }
        if (this.Status == 1) {
            return "Logged out";
        }
        if (this.Status == 2) {
            return "Reserve duty";
        }
        if (this.Status == 3) {
            return "Active duty";
        }
        if (this.Status == 4) {
            return "Fighting";
        }
        return "";
    }

    public void setPlayerStartingEdge(int edge) {
        this.playerStartingEdge = edge;
    }

    public int getPlayerStartingEdge() {
        return this.playerStartingEdge;
    }

    public String getShortTime() {
        this.mytime = new Date();
        StringTokenizer s = new StringTokenizer(this.mytime.toString());
        s.nextElement();
        s.nextElement();
        s.nextElement();
        String t = (String)s.nextElement();
        s = new StringTokenizer(t, ":");
        String result = "[" + s.nextElement() + ":" + s.nextElement() + "] ";
        return result;
    }

    public void addToChat(String s) {
        this.addToChat(s, 0, null);
    }

    public void addToChat(String s, int channel) {
        this.addToChat(s, channel, null);
    }

    public void addToChat(String s, int channel, String tabName) {
        s = "<BODY  TEXT=\"" + this.Config.getParam("CHATFONTCOLOR") + "\" BGCOLOR=\"" + this.Config.getParam("BACKGROUNDCOLOR") + "\"><font size=\"" + this.Config.getParam("CHATFONTSIZE") + "\">" + s + "</font></BODY>";
        try {
            SwingUtilities.invokeLater(new CAddToChat(s, channel, tabName));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void sendChat(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreElements()) {
            String str = (String)st.nextElement();
            if (str.trim().equals("")) continue;
            this.serverSend("CH|" + str);
        }
    }

    public String doEscape(String str) {
        if (str.indexOf("<a href=\"MEKINFO") != -1) {
            return str;
        }
        str = this.doEscapeString(str, 38, "&amp;");
        str = this.doEscapeString(str, 60, "&lt;");
        str = this.doEscapeString(str, 62, "&gt;");
        return str;
    }

    public String doEscapeString(String t, int character, String replace) {
        int pos = t.indexOf(character);
        if (pos != -1) {
            String res = "";
            if (pos > 0) {
                res = res + t.substring(0, pos);
            }
            res = res + replace;
            if (pos < t.length()) {
                res = res + this.doEscapeString(t.substring(pos + 1), character, replace);
            }
            return res;
        }
        return t;
    }

    protected Vector<String> splitString(String string, String splitter) {
        Vector<String> vector = new Vector<String>(1, 1);
        String[] splitted = string.split(splitter);
        for (int i = 0; i < splitted.length; ++i) {
            vector.add(splitted[i].trim());
        }
        Iterator i = vector.iterator();
        while (i.hasNext()) {
            String currString = (String)i.next();
            if (currString.trim().length() != 0) continue;
            i.remove();
        }
        return vector;
    }

    public TreeMap<String, MMGame> getServers() {
        return this.servers;
    }

    public synchronized CUser getUser(String name) {
        for (CUser currUser : this.Users) {
            if (!currUser.getName().equalsIgnoreCase(name)) continue;
            return currUser;
        }
        CUser dummyUser = new CUser();
        dummyUser.setColor(this.Config.getParam("CHATFONTCOLOR"));
        return dummyUser;
    }

    public synchronized ArrayList<String> getPartialUser(String u) {
        String result = "";
        TreeSet<String> userNames = new TreeSet<String>();
        if (u.trim().indexOf(" ") != -1) {
            result = u.substring(u.trim().lastIndexOf(" ")).trim();
            u = u.substring(0, u.trim().lastIndexOf(" ")).trim();
        } else {
            result = u.trim();
            u = "";
        }
        if (result.length() < 1) {
            return null;
        }
        int myLevel = this.getUser(this.getPlayer().getName()).getUserlevel();
        for (CUser usr : this.Users) {
            if (!usr.getName().toLowerCase().startsWith(result.toLowerCase()) || usr.isInvis() && (!usr.isInvis() || myLevel < usr.getUserlevel())) continue;
            userNames.add(usr.getName());
        }
        ArrayList<String> test = new ArrayList<String>();
        test.addAll(userNames);
        return test;
    }

    public synchronized void clearUserCampaignData() {
        for (CUser currUser : this.Users) {
            currUser.clearCampaignData();
        }
    }

    public void setupAllOps() {
        this.allOps = new TreeMap();
        try {
            File f = new File(this.cacheDir + "/OpList.txt");
            if (!f.exists()) {
                CampaignData.mwlog.errLog("Error: OpList.txt does not exist.");
                return;
            }
            FileInputStream in = new FileInputStream(this.cacheDir + "/OpList.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String currLine = br.readLine();
            if (currLine != null) {
                currLine = br.readLine();
            }
            while (currLine != null) {
                if (currLine.trim().length() == 0) {
                    currLine = br.readLine();
                    continue;
                }
                StringTokenizer st = new StringTokenizer(currLine, "*");
                String name = st.nextToken();
                String range = st.nextToken();
                String color = st.nextToken();
                String hasLong = st.nextToken();
                String facInfo = st.nextToken();
                String homeInfo = st.nextToken();
                String launchOn = st.nextToken();
                String launchFrom = st.nextToken();
                String minOwn = st.nextToken();
                String maxOwn = st.nextToken();
                String reserveOnly = st.nextToken();
                String activeOnly = st.nextToken();
                String legalDefenders = st.nextToken();
                String allowPlanetFlags = st.nextToken();
                String disallowPlanetFlags = st.nextToken();
                String minAccessLevel = st.nextToken();
                String[] props = new String[]{range, color, hasLong, facInfo, homeInfo, launchOn, launchFrom, minOwn, maxOwn, legalDefenders, allowPlanetFlags, disallowPlanetFlags, reserveOnly, activeOnly, minAccessLevel};
                this.allOps.put(name, props);
                currLine = br.readLine();
            }
            br.close();
            in.close();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Error in setupAllOps()");
            CampaignData.mwlog.errLog(e);
        }
    }

    public TreeMap<String, String[]> getAllOps() {
        return this.allOps;
    }

    public void setLookAndFeel(boolean isRedraw) {
        Object LAF = new KunststoffLookAndFeel();
        if (this.Config.getParam("LOOKANDFEEL").equals("metal")) {
            LAF = new MetalLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("motif")) {
            LAF = new MotifLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("metouia")) {
            LAF = new MetouiaLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("plastic")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new DesertGreen());
            LAF = new Plastic3DLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("plasticxp")) {
            LAF = new PlasticXPLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("plastic3d")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new SkyBlue());
            LAF = new Plastic3DLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("jwindows")) {
            LAF = new WindowsLookAndFeel();
        } else if (this.Config.getParam("LOOKANDFEEL").equals("skins")) {
            try {
                Skin theSkinToUse = SkinLookAndFeel.loadThemePack((String)("./data/skins/" + this.Config.getParam("LOOKANDFEELSKIN")));
                SkinLookAndFeel.setSkin((Skin)theSkinToUse);
                LAF = new SkinLookAndFeel();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                LAF = UIManager.getLookAndFeel();
            }
        }
        try {
            if (isRedraw) {
                this.MainFrame.setVisible(false);
            }
            if (this.Config.getParam("LOOKANDFEEL").equalsIgnoreCase("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel((LookAndFeel)LAF);
            }
            if (isRedraw) {
                SwingUtilities.updateComponentTreeUI(this.MainFrame);
                this.MainFrame.setVisible(true);
                this.getMainFrame().getMainPanel().getUserListPanel().resetActivityButton();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
    }

    public void refreshGUI(int mode) {
        try {
            SwingUtilities.invokeLater(new CRefreshGUI(mode));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void showInfoWindow(String Text) {
        if (!this.isDedicated()) {
            final JDialog dialog = new JDialog((Frame)this.MainFrame, "Message");
            JLabel label = new JLabel("<html>" + Text + "</html>");
            label.setHorizontalAlignment(0);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 30;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            contentPane.add((Component)label, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(1));
            JButton okButton = new JButton("OK");
            panel.add(okButton);
            contentPane.add((Component)panel, gridBagConstraints);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            Dimension d = dialog.getPreferredSize();
            d.setSize(d.getWidth() + 20.0, d.getHeight() + 40.0);
            dialog.setSize(d);
            dialog.setLocationRelativeTo(this.MainFrame);
            dialog.setVisible(true);
        } else {
            CampaignData.mwlog.errLog("-----------");
            CampaignData.mwlog.errLog(Text);
            CampaignData.mwlog.errLog("-----------");
        }
    }

    public void doPlaySound(String filename) {
        this.doPlaySound(filename, true);
    }

    public void doPlaySound(String filename, boolean inThread) {
        if (this.SoundMuted) {
            return;
        }
        try {
            if (inThread) {
                AePlayWave player = new AePlayWave(filename);
                player.start();
            } else {
                AePlayWave.AePlayWaveNonThreaded(filename);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void setSoundMuted(boolean b) {
        this.SoundMuted = b;
        this.MainFrame.setSoundMuted(b);
        if (b != this.getConfig().isParam("DISABLEALLSOUND")) {
            if (!b) {
                this.getConfig().setParam("DISABLEALLSOUND", "false");
            } else {
                this.getConfig().setParam("DISABLEALLSOUND", "true");
            }
            this.getConfig().saveConfig();
        }
    }

    public boolean isMuted() {
        return this.SoundMuted;
    }

    public void setUsingBots(Boolean using) {
        this.usingBots = using;
    }

    public boolean isUsingBots() {
        return this.usingBots;
    }

    public void setBotsOnSameTeam(Boolean sameTeam) {
        this.botsOnSameTeam = sameTeam;
    }

    public boolean isBotsOnSameTeam() {
        return this.botsOnSameTeam;
    }

    public CMainFrame getMainFrame() {
        return this.MainFrame;
    }

    public synchronized Collection<CUser> getUsers() {
        return this.Users;
    }

    public String getProtocolVersion() {
        return "4";
    }

    public void setUsername(String s) {
        this.myUsername = s.trim();
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public CConfig getConfig() {
        return this.Config;
    }

    public void setConfig() {
        this.Config = new CConfig(false);
    }

    public String getConfigParam(String p) {
        String tparam = "";
        if (p.endsWith(":")) {
            p = p.substring(0, p.lastIndexOf(":"));
        }
        if (p.equals("NAME") && !this.myUsername.equals("")) {
            return this.myUsername;
        }
        if (p.equals("NAMEPASSWORD") && !this.password.equals("")) {
            return this.password;
        }
        tparam = this.Config.getParam(p);
        if (tparam == null) {
            CampaignData.mwlog.errLog("Unable to find param " + p);
            tparam = "";
        }
        if (tparam.equals("") && p.equals("NAME") && this.isDedicated()) {
            CampaignData.mwlog.infoLog("Error: no dedicated name set.");
            System.exit(1);
        }
        return tparam;
    }

    @Override
    public void systemMessage(String message) {
        if (!this.isDedicated()) {
            String sysColour = this.getConfigParam("SYSMESSAGECOLOR");
            message = "<font color=\"" + sysColour + "\"><b>" + message + "</b></font>";
            this.addToChat(message, 4);
            if (this.Config.isParam("MAINCHANNELSM")) {
                this.addToChat(message);
            }
        }
    }

    @Override
    public void errorMessage(String message) {
        if (!this.isDedicated()) {
            JOptionPane.showMessageDialog(this.MainFrame, message);
        } else {
            CampaignData.mwlog.errLog("Error: " + message);
        }
    }

    @Override
    public void processIncoming(String incoming) {
        IProtCommand pcommand = null;
        if (incoming.startsWith("/")) {
            StringTokenizer ST = new StringTokenizer(incoming = incoming.substring("/".length()), PROTOCOL_DELIMITER);
            String s = ST.nextToken();
            pcommand = this.getProtCommand(s);
            if (pcommand != null && pcommand.check(s)) {
                if (!pcommand.execute(incoming)) {
                    CampaignData.mwlog.infoLog("COMMAND ERROR: wrong protocol command executed or execution failed.");
                    CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
                }
                return;
            }
            if (pcommand == null) {
                CampaignData.mwlog.infoLog("COMMAND ERROR: unknown protocol command from server.");
                CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
                return;
            }
        } else {
            CampaignData.mwlog.infoLog("COMMAND ERROR: received protocol command without protocol prefix.");
            CampaignData.mwlog.infoLog("COMMAND RECEIVED: " + incoming);
            return;
        }
    }

    @Override
    public void connectionLost() {
        this.Status = 0;
        if (this.SignOff) {
            return;
        }
        this.errorMessage("Connection lost.");
        if (this.isDedicated()) {
            this.stopHost();
            try {
                Thread.sleep(90000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            while (this.Status == 0) {
                this.connectToServer(this.Config.getParam("SERVERIP"), this.Config.getIntParam("SERVERPORT"));
                if (this.Status != 0) continue;
                CampaignData.mwlog.infoLog("Couldn't reconnect to server. Retrying in 120 seconds.");
                try {
                    Thread.sleep(90000L);
                }
                catch (Exception exe) {
                    CampaignData.mwlog.errLog(exe);
                }
            }
        } else {
            this.Users.clear();
            this.refreshGUI(0);
        }
    }

    @Override
    public void connectionEstablished() {
        this.LastPing = System.currentTimeMillis() / 1000L;
        CampaignData.mwlog.errLog("Connected. Signing on.");
        String VersionSubID = new VMID().toString();
        StringTokenizer ST = new StringTokenizer(VersionSubID, ":");
        String passToSend = this.getConfigParam("NAMEPASSWORD");
        if (passToSend == null || passToSend.length() == 0) {
            passToSend = "1337";
        }
        this.Connector.send("/signon\t" + this.getConfigParam("NAME") + PROTOCOL_DELIMITER + passToSend + PROTOCOL_DELIMITER + this.getProtocolVersion() + PROTOCOL_DELIMITER + this.Config.getParam("COLOR") + PROTOCOL_DELIMITER + CLIENT_VERSION + PROTOCOL_DELIMITER + ST.nextToken());
        this.Status = 1;
        if (!this.isDedicated()) {
            this.refreshGUI(0);
        }
    }

    public void rewardPointsDialog() {
        new RewardPointsDialog(this);
    }

    public void connectToServer() {
        this.connectToServer(this.Config.getParam("SERVERIP"), this.Config.getIntParam("SERVERPORT"));
    }

    public void connectToServer(String ip, int port) {
        if (this.myUsername == null || this.myUsername.equals("")) {
            this.errorMessage("Username not set.");
            return;
        }
        this.Connector.connect(ip, port);
    }

    public void goodbye() {
        this.SignOff = true;
        if (!this.isDedicated() && this.Status > 1) {
            this.getConfig().setParam("PANELDIVIDER", Integer.toString(this.getMainFrame().getMainPanel().getTabSPane().getDividerLocation()));
            this.getConfig().setParam("VERTICALDIVIDER", Integer.toString(this.getMainFrame().getMainPanel().getMainSPane().getDividerLocation()));
            this.getConfig().setParam("PLAYERPANELDIVIDER", Integer.toString(this.getMainFrame().getMainPanel().getSideSPane().getDividerLocation()));
            this.getConfig().setParam("WINDOWSTATE", Integer.toString(this.getMainFrame().getExtendedState()));
            this.getConfig().setParam("WINDOWHEIGHT", Integer.toString(this.getMainFrame().getHeight()));
            this.getConfig().setParam("WINDOWWIDTH", Integer.toString(this.getMainFrame().getWidth()));
            this.getConfig().setParam("WINDOWLEFT", Integer.toString(this.getMainFrame().getX()));
            this.getConfig().setParam("WINDOWTOP", Integer.toString(this.getMainFrame().getY()));
            this.getConfig().saveConfig();
        }
        if (this.Status != 0) {
            this.Connector.send("/signoff");
            this.dataFetcher.closeDataConnection();
            this.Connector.closeConnection();
        }
        if (this.getConfig().isParam("ENABLEEXITCLIENTSOUND")) {
            this.doPlaySound(this.getConfigParam("SOUNDONEXITCLIENT"), false);
        }
    }

    public CConnector getConnector() {
        return this.Connector;
    }

    public void serverSend(String s) {
        try {
            this.Connector.send("/comm\t" + TransportCodec.encode(s));
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
    }

    public void startHost(boolean dedicated, boolean deploy, boolean loadSavegame) {
        String MMVersion;
        String ip = "127.0.0.1";
        if (!this.getConfigParam("IP:").equals("")) {
            try {
                ip = this.getConfigParam("IP:");
                InetAddress IA = InetAddress.getByName(ip);
                ip = IA.getHostAddress();
            }
            catch (Exception ex) {
                this.showInfoWindow("Couldn't set IP. Please check the spelling of mwconfig.txt's IP value or comment it out to use autodetection.");
                return;
            }
        }
        if (!(MMVersion = this.getserverConfigs("AllowedMegaMekVersion")).equals("-1") && !MMVersion.equalsIgnoreCase(MegaMek.VERSION)) {
            if (this.isDedicated()) {
                CampaignData.mwlog.errLog("You are using an invalid version of MegaMek. Please use version " + MMVersion);
                try {
                    this.stopHost();
                    this.goodbye();
                    Runtime runtime = Runtime.getRuntime();
                    String[] call = new String[]{"java", "-jar", "MekWarsAutoUpdate.jar", "DEDICATED"};
                    runtime.exec(call);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                System.exit(0);
            } else {
                this.showInfoWindow("You are using an invalid version of MegaMek. Please use version " + MMVersion);
            }
            return;
        }
        if (this.servers.get(this.myUsername) != null) {
            if (this.isDedicated()) {
                CampaignData.mwlog.errLog("Attempted to start a second host while host was already running.");
            } else {
                String toUser = "CH|CLIENT: You already have a host open.";
                this.doParseDataInput(toUser);
            }
            return;
        }
        int MaxPlayers = Integer.parseInt(this.getConfigParam("MAXPLAYERS:"));
        String comment = this.getConfigParam("COMMENT:");
        String gpassword = this.getConfigParam("GAMEPASSWORD:");
        if (gpassword == null) {
            gpassword = "";
        }
        try {
            this.myServer = new Server(gpassword, this.myPort);
            if (loadSavegame) {
                FileDialog f = new FileDialog((Frame)this.MainFrame, "Load Savegame");
                f.setDirectory(System.getProperty("user.dir") + "/savegames");
                f.setVisible(true);
                this.myServer.loadGame(new File(f.getDirectory(), f.getFile()));
            }
        }
        catch (Exception ex) {
            try {
                if (this.myServer == null) {
                    CampaignData.mwlog.errLog("Error opening dedicated server. Result = null host.");
                    CampaignData.mwlog.errLog(ex);
                } else {
                    CampaignData.mwlog.errLog("Error opening dedicated server. Will attempt a .die().");
                    CampaignData.mwlog.errLog(ex);
                    this.myServer.die();
                    this.myServer = null;
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Further error while trying to clean up failed host attempt.");
                CampaignData.mwlog.errLog(e);
            }
            return;
        }
        this.serverSend("NG|" + new MMGame(this.myUsername, ip, this.myPort, MaxPlayers, MegaMek.VERSION + " " + MegaMek.TIMESTAMP, comment).toString());
        if (!dedicated) {
            ArrayList<CUnit> autoArmy;
            ArrayList<Unit> meks;
            if (deploy) {
                meks = this.myPlayer.getLockedUnits();
                autoArmy = this.myPlayer.getAutoArmy();
            } else {
                meks = new ArrayList();
                autoArmy = new ArrayList();
            }
            CampaignData.mwlog.infoLog("Joining own game!");
            ClientThread MMGameThread = new ClientThread(this.myUsername, this.myUsername, "127.0.0.1", this.myPort, this, meks, autoArmy);
            ThreadManager.getInstance().runInThreadFromPool(MMGameThread);
            this.serverSend("JG|" + this.myUsername);
        } else {
            this.clearSavedGames();
            this.purgeOldLogs();
            IClientPreferences cs = PreferenceManager.getClientPreferences();
            cs.setStampFilenames(Boolean.parseBoolean(this.getserverConfigs("MMTimeStampLogFile")));
        }
    }

    public void stopHost() {
        this.serverSend("CG");
        try {
            this.myServer.die();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Megamek Error:");
        }
        this.myServer = null;
    }

    public void resetGame() {
        if (this.myServer != null) {
            this.myServer.resetGame();
        }
    }

    public boolean loadGame(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File("./savegames/", filename));
        }
        if (this.myServer == null) {
            CampaignData.mwlog.infoLog("MyServer == NULL!");
        }
        if (filename == null) {
            CampaignData.mwlog.infoLog("Filename == NULL!");
        } else if (filename.equals("")) {
            CampaignData.mwlog.infoLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean loadGameWithFullPath(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File(filename));
        }
        if (this.myServer == null) {
            CampaignData.mwlog.infoLog("MyServer == NULL!");
        }
        if (filename == null) {
            CampaignData.mwlog.infoLog("Filename == NULL!");
        } else if (filename.equals("")) {
            CampaignData.mwlog.infoLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean isServerRunning() {
        return this.myServer != null;
    }

    public void startClient(String hostName, boolean deploy) {
        ArrayList<Unit> meks = new ArrayList();
        ArrayList<CUnit> autoArmy = new ArrayList();
        if (this.servers.size() > 0 && hostName != null && hostName.trim().length() > 0) {
            MMGame toJoin = this.servers.get(hostName);
            if (toJoin.getCurrentPlayers().size() >= toJoin.getMaxPlayers() && !toJoin.getCurrentPlayers().contains(this.myUsername) && !this.isMod()) {
                this.showInfoWindow("This game is already full");
                return;
            }
            String serverip = toJoin.getIp();
            int serverport = toJoin.getPort();
            if (this.myUsername.equalsIgnoreCase(toJoin.getHostName())) {
                serverip = "localhost";
            }
            if (deploy) {
                meks = this.myPlayer.getLockedUnits();
                autoArmy = this.myPlayer.getAutoArmy();
            }
            ClientThread tmpThread = new ClientThread(this.Config.getParam("NAME"), hostName, serverip, serverport, this, meks, autoArmy);
            ThreadManager.getInstance().runInThreadFromPool(tmpThread);
            this.serverSend("JG|" + toJoin.getHostName());
            toJoin = null;
        } else {
            this.showInfoWindow("You have to select a game!");
        }
    }

    public void closingGame(String hostName) {
        CampaignData.mwlog.infoLog("Leaving " + hostName);
        this.serverSend("LG|" + hostName);
        System.gc();
    }

    public Vector<IBasicOption> getGameOptions() {
        return this.GameOptions;
    }

    public Dimension getMapSize() {
        return this.MapSize;
    }

    public int getMapMedium() {
        return this.mapMedium;
    }

    public PlanetEnvironment getCurrentEnvironment() {
        return this.currentEnvironment;
    }

    public AdvancedTerrain getCurrentAdvancedTerrain() {
        return this.aTerrain;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void getBlackMarketSettings() {
        try {
            this.dataFetcher.getBlackMarketSettings(this);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public synchronized void refreshData() {
        if (!this.getConfig().isParam("MAPTABVISIBLE")) {
            CampaignData.mwlog.infoLog("Map visibility disabled. Skipping map data fetch!");
            return;
        }
        if (!this.dataFetcher.getPlanetsUpdate(this.data)) {
            CampaignData.mwlog.infoLog("MD5 does not match! But the md5 seems broken anyway...");
        }
        this.updateDataFetcher = null;
        Map<Integer, Influences> changesSinceLastRefresh = this.dataFetcher.getChangesSinceLastRefresh();
        if (this.getMainFrame() != null) {
            this.getMainFrame().getMainPanel().getMapPanel().getMap().dataFetched(changesSinceLastRefresh);
        }
        CampaignData.mwlog.infoLog("update for new planet data finished");
    }

    public Map<Integer, Influences> getChangesSinceLastRefresh() {
        return this.dataFetcher.getChangesSinceLastRefresh();
    }

    public void reloadData() {
        block4: {
            try {
                this.data = this.dataFetcher.getAllData();
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block4;
                CampaignData.mwlog.errLog(ex);
            }
        }
        try {
            this.dataFetcher.getServerConfigData(this);
        }
        catch (IOException e1) {
            CampaignData.mwlog.errLog(e1);
        }
    }

    public void getServerConfigData() {
        block2: {
            try {
                this.dataFetcher.getServerConfigData(this);
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block2;
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void loadServerCommmands() {
        block2: {
            try {
                this.dataFetcher.getAccessLevels(this.getData());
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block2;
                CampaignData.mwlog.errLog("Error loading Server Commands files");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void loadServerTraitFiles() {
        block2: {
            try {
                this.dataFetcher.getServerTraitFiles();
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block2;
                CampaignData.mwlog.errLog("Error loading Server Trait files");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void loadBannedAmmo() {
        block2: {
            try {
                this.dataFetcher.getBannedAmmoData(this);
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block2;
                CampaignData.mwlog.errLog("Error loading Server banned ammo file");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void loadBanTargeting() {
        block2: {
            try {
                this.dataFetcher.getBanTargetingData(this);
            }
            catch (Exception ex) {
                if (ex instanceof SocketException) break block2;
                CampaignData.mwlog.errLog("Error loading Server banned targeting file");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public CampaignData getData() {
        if (this.data == null && !this.isDedicated()) {
            block20: {
                try {
                    CampaignData.mwlog.infoLog("try to import the planetcache");
                    this.dataFetcher.checkServerVersion(this);
                    this.data = this.dataFetcher.getCacheData(this.getCacheDir());
                    if (this.data == null || this.data.getAllPlanets().size() == 0 || this.data.getAllHouses().size() == 0) {
                        throw new Exception("data still empty");
                    }
                    this.refreshData();
                    this.dataFetcher.store();
                    CampaignData.mwlog.infoLog("cache data loaded");
                }
                catch (Throwable e) {
                    block19: {
                        if (!(e instanceof FileNotFoundException)) {
                            CampaignData.mwlog.errLog((Exception)e);
                        }
                        CampaignData.mwlog.infoLog("need to fetch all planet data..");
                        try {
                            this.data = this.dataFetcher.getAllData();
                            this.dataFetcher.store();
                        }
                        catch (ConnectException e1) {
                            if (this.splash != null) {
                                this.splash.setStatus(this.splash.STATUS_DATAERROR);
                            }
                            CampaignData.mwlog.errLog(e1);
                            CampaignData.mwlog.errLog(this.getCacheDir());
                            Object[] options = new Object[]{"Exit", "Continue"};
                            int selectedValue = JOptionPane.showOptionDialog(null, "Could not connect to server to fetch map data.", "Connection error!", -1, 0, null, options, options[0]);
                            if (selectedValue == 0) {
                                System.exit(0);
                            }
                        }
                        catch (IOException e1) {
                            if (this.splash != null) {
                                this.splash.setStatus(this.splash.STATUS_DATAERROR);
                            }
                            CampaignData.mwlog.errLog(e1);
                            JOptionPane.showMessageDialog(null, "Server is busy while fetching planet data.\nTry again later.");
                        }
                        catch (Throwable e1) {
                            if (this.splash != null) {
                                this.splash.setStatus(this.splash.STATUS_DATAERROR);
                            }
                            CampaignData.mwlog.errLog((Exception)e1);
                            Object[] options = new Object[]{"Exit", "Continue"};
                            int selectedValue = JOptionPane.showOptionDialog(null, "Unknown error while fetching map data. Please\nreport this bug, and keep your error logs handy.", "Unknown error!", -1, 0, null, options, options[0]);
                            if (selectedValue != 0) break block19;
                            System.exit(0);
                        }
                    }
                    if (this.splash == null) break block20;
                    this.splash.setStatus(this.splash.STATUS_FETCHINGDATA);
                }
            }
            try {
                this.dataFetcher.getServerConfigData(this);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to fetch Server configs.");
                CampaignData.mwlog.errLog(ex);
            }
            try {
                this.dataFetcher.getBannedAmmoData(this);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to fetch server banned ammo data.");
                CampaignData.mwlog.errLog(ex);
            }
            try {
                this.dataFetcher.getBanTargetingData(this);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to fetch banned targeting systems.");
                CampaignData.mwlog.errLog(ex);
            }
            this.dataFetcher.closeDataConnection();
        }
        return this.data;
    }

    public double getAmmoCost(String ammo) {
        EquipmentType eq = EquipmentType.get(ammo);
        if (eq == null) {
            return -1.0;
        }
        if (!this.getCampaign().getBlackMarketParts().containsKey(eq.getName())) {
            return -1.0;
        }
        if (this.getCampaign().getBlackMarketParts().get(eq.getName()).getCost() > 0.0) {
            return this.getCampaign().getBlackMarketParts().get(eq.getName()).getCost();
        }
        return -1.0;
    }

    public void processTick(int time) {
        this.getMainFrame().getMainPanel().getPlayerPanel().setNextTick(System.currentTimeMillis() + (long)time);
        this.getMainFrame().getMainPanel().getMapPanel().getMap().processTick();
        System.gc();
    }

    public String getCacheDir() {
        this.cacheDir = "data/servers/" + this.Config.getParam("SERVERIP") + "." + this.Config.getParam("SERVERPORT");
        File dir = new File(this.cacheDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return this.cacheDir;
    }

    public void setIgnoreHouse() {
        this.IgnoreHouse = this.splitString(this.Config.getParam("IGNOREHOUSE"), ",");
    }

    public void setIgnorePublic() {
        this.IgnorePublic = this.splitString(this.Config.getParam("IGNOREPUBLIC"), ",");
    }

    public void setIgnorePrivate() {
        this.IgnorePrivate = this.splitString(this.Config.getParam("IGNOREPRIVATE"), ",");
    }

    public void setKeyWords() {
        this.KeyWords = this.splitString(this.Config.getParam("KEYWORDS"), ",");
    }

    public void setAdvancedTerrain(AdvancedTerrain aTerrain) {
        this.aTerrain = aTerrain;
    }

    public void setEnvironment(PlanetEnvironment pe, Dimension map, int mapMedium) {
        this.currentEnvironment = pe;
        this.MapSize = map;
        this.mapMedium = mapMedium;
    }

    public void setBuildingTemplate(Buildings buildingTemplate) {
        this.buildingTemplate = buildingTemplate;
    }

    public Buildings getBuildingTemplate() {
        return this.buildingTemplate;
    }

    public void changeStatus(int newStatus) {
        this.LastStatus = this.Status;
        this.Status = newStatus;
        if (this.Status != 2 && this.Status == 1) {
            this.clearUserCampaignData();
        }
        if (this.Status == 4) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(false);
        } else if (this.Status == 3) {
            if (this.LastStatus != 4) {
                this.getMainFrame().getMainPanel().getUserListPanel().setActivityButton(false);
            }
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        } else if (this.Status == 0) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Disconnected");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(false);
        } else if (this.Status == 1) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Login");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        } else if (this.Status == 2) {
            if (this.LastStatus != 1) {
                this.getMainFrame().getMainPanel().getUserListPanel().setActivityButton(true);
            }
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        }
        this.getMainFrame().updateAttackMenu();
        this.refreshGUI(0);
        this.refreshGUI(5);
        this.refreshGUI(2);
    }

    public String getserverConfigs(String key) {
        if (this.serverConfigs.getProperty(key) == null) {
            CampaignData.mwlog.infoLog("You're missing the config variable: " + key + " in serverconfig!");
            return "-1";
        }
        return this.serverConfigs.getProperty(key).trim();
    }

    public Properties getserverConfigs() {
        return this.serverConfigs;
    }

    public boolean isAdmin() {
        return this.getUserLevel() >= 200;
    }

    public boolean isMod() {
        return this.getUserLevel() >= 100;
    }

    public boolean isLeader() {
        return this.getUserLevel() >= Integer.parseInt(this.getserverConfigs("factionLeaderLevel"));
    }

    public int getUserLevel() {
        return this.getUser(this.getUsername()).getUserlevel();
    }

    public void checkForRestart() {
        ++this.gameCount;
        if (System.currentTimeMillis() - 30000L < this.lastResetCheck) {
            return;
        }
        if (this.gameCount >= this.dedRestartAt) {
            CampaignData.mwlog.infoLog("System has reached " + this.gameCount + " games played and is restarting");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            this.stopHost();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            try {
                Runtime runTime = Runtime.getRuntime();
                if (new File("MekWarsDed.jar").exists()) {
                    String[] call = new String[]{"java", "-Xmx512m", "-jar", "MekWarsDed.jar"};
                    runTime.exec(call);
                } else {
                    String[] call = new String[]{"java", "-Xmx512m", "-jar", "MekWarsClient.jar"};
                    runTime.exec(call);
                }
                System.exit(0);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to find MekWarsDed.jar");
            }
        }
        this.lastResetCheck = System.currentTimeMillis();
    }

    public void clearSavedGames() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./savegames/");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error trying to delete these files!");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void purgeOldLogs() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./logs/backup");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error trying to delete these files!");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public String getParanoidAutoSave() {
        File tempFile = new File("./savegames/");
        AutoSaveFilter filter = new AutoSaveFilter();
        File[] fileList = tempFile.listFiles(filter);
        long time = 0L;
        String saveFile = "autosave.sav";
        for (int i = 0; i < fileList.length; ++i) {
            File newFile = fileList[i];
            if (newFile.lastModified() <= time) continue;
            time = newFile.lastModified();
            saveFile = newFile.getName();
        }
        return saveFile;
    }

    public void clearBanAmmo() {
        this.getData().getServerBannedAmmo().clear();
        for (House faction : this.getData().getAllHouses()) {
            faction.getBannedAmmo().clear();
        }
    }

    public void clearBanTargeting() {
        this.getData().getBannedTargetingSystems().clear();
    }

    public void loadBanTargeting(String line) {
        StringTokenizer st = new StringTokenizer(line, "#");
        while (st.hasMoreTokens()) {
            this.getData().getBannedTargetingSystems().put(Integer.parseInt(st.nextToken()), "Banned");
        }
    }

    public void saveBannedTargetingSystems(String timestamp) {
        try {
            FileOutputStream out = new FileOutputStream(this.cacheDir + "/bantargeting.dat");
            PrintStream p = new PrintStream(out);
            p.println(timestamp);
            for (Integer targetingSytem : this.getData().getBannedTargetingSystems().keySet()) {
                p.print(targetingSytem);
                p.print("#");
            }
            p.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadBanAmmo(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, "#");
            String HouseName = (String)st.nextElement();
            House faction = null;
            if (!HouseName.equalsIgnoreCase("server")) {
                faction = this.getData().getHouseByName(HouseName);
                while (st.hasMoreTokens()) {
                    faction.getBannedAmmo().put(st.nextToken(), "Banned");
                }
            } else {
                while (st.hasMoreElements()) {
                    this.getData().getServerBannedAmmo().put(st.nextToken(), "Banned");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveBannedAmmo(String timestamp) {
        try {
            FileOutputStream out = new FileOutputStream(this.cacheDir + "/banammo.dat");
            PrintStream p = new PrintStream(out);
            p.println(timestamp);
            p.print("server#");
            for (String currBan : this.data.getServerBannedAmmo().keySet()) {
                p.print(currBan);
                p.print("#");
            }
            p.println();
            for (House h : this.data.getAllHouses()) {
                if (h.getBannedAmmo().size() < 1) continue;
                p.print(h.getName() + "#");
                for (String currBan : h.getBannedAmmo().keySet()) {
                    p.print(currBan);
                    p.print("#");
                }
                p.println();
            }
            p.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount) {
        return this.moneyOrFluMessage(money, shortname, amount, false);
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount, boolean showSign) {
        String result = NumberFormat.getInstance().format(amount);
        String moneyShort = this.getserverConfigs("MoneyShortName");
        String moneyLong = this.getserverConfigs("MoneyLongName");
        String fluShort = this.getserverConfigs("FluShortName");
        String fluLong = this.getserverConfigs("FluLongName");
        String sign = "+";
        if (amount < 0) {
            amount *= -1;
            result = "";
            sign = "-";
        }
        result = money ? (shortname ? (amount == 1 && moneyShort.endsWith("s") ? result + moneyShort.substring(0, moneyShort.length() - 1) : (amount > 1 && !moneyShort.endsWith("s") ? result + moneyShort + "s" : result + moneyShort)) : (amount == 1 && moneyLong.endsWith("s") ? result + " " + moneyLong.substring(0, moneyLong.length() - 1) : (amount > 1 && !moneyLong.endsWith("s") ? result + " " + moneyLong + "s" : result + " " + moneyLong))) : (shortname ? result + fluShort : result + " " + fluLong);
        if (showSign) {
            result = sign + result;
        }
        return result.trim();
    }

    public void loadMegaMekClient() {
        try {
            this.setWaiting(true);
            this.sendChat("/c GetServerMegaMekGameOptions");
            try {
                while (this.isWaiting()) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            Client MegaMekClient = new Client("temp", "None", 0);
            MegaMekClient.game.getOptions().loadOptions();
            GameOptions gameOptions = MegaMekClient.game.getOptions();
            GameOptionsDialog MMGOD = new GameOptionsDialog((Frame)this.getMainFrame(), gameOptions);
            MMGOD.update(gameOptions);
            MMGOD.setEditable(true);
            MMGOD.setVisible(true);
            MMGOD.dispose();
            File localGameOptions = new File("mmconf/gameoptions.xml");
            if (localGameOptions.lastModified() >= System.currentTimeMillis() - 1000L) {
                this.sendGameOptionsToServer();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to pull server MegaMek Logs");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void sendGameOptionsToServer() {
        StringBuilder packet = new StringBuilder();
        try {
            FileInputStream gameOptionsFile = new FileInputStream("./mmconf/gameoptions.xml");
            BufferedReader gameOptions = new BufferedReader(new InputStreamReader(gameOptionsFile));
            while (gameOptions.ready()) {
                packet.append(gameOptions.readLine() + "#");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendChat("/c servergameoptions#" + packet.toString());
    }

    public int getMinPlanetOwnerShip(Planet p) {
        if (p.getMinPlanetOwnerShip() == -1) {
            return Integer.parseInt(this.getserverConfigs("MinPlanetOwnerShip"));
        }
        return p.getMinPlanetOwnerShip();
    }

    public int getTotalRepairCosts(Entity unit) {
        int cost = 0;
        int systemCrits = 0;
        int engineCrits = 0;
        for (int critLocation = 0; critLocation < unit.locations(); ++critLocation) {
            if (critLocation == 1 || critLocation == 3 || critLocation == 2) {
                if (unit.getArmor(critLocation, false) != unit.getOArmor(critLocation, false)) {
                    cost = (int)((double)cost + (CUnit.getArmorCost(unit, this) * (double)unit.getOArmor(critLocation, false) - (double)unit.getArmor(critLocation, false)));
                }
                if (unit.getArmor(critLocation, true) != unit.getOArmor(critLocation, true)) {
                    cost = (int)((double)cost + (CUnit.getArmorCost(unit, this) * (double)unit.getOArmor(critLocation, false) - (double)unit.getArmor(critLocation, false)));
                }
                if (unit.getInternal(critLocation) != unit.getOInternal(critLocation)) {
                    cost = (int)((double)cost + (CUnit.getStructureCost(unit, this) * (double)unit.getOInternal(critLocation) - (double)unit.getInternal(critLocation)));
                }
            } else {
                if (unit.getArmor(critLocation, false) != unit.getOArmor(critLocation, false)) {
                    cost = (int)((double)cost + (CUnit.getArmorCost(unit, this) * (double)unit.getOArmor(critLocation, false) - (double)unit.getArmor(critLocation, false)));
                }
                if (unit.getInternal(critLocation) != unit.getOInternal(critLocation)) {
                    cost = (int)((double)cost + (CUnit.getStructureCost(unit, this) * (double)unit.getOInternal(critLocation) - (double)unit.getInternal(critLocation)));
                }
            }
            for (int critSlot = 0; critSlot < unit.getNumberOfCriticals(critLocation); ++critSlot) {
                CriticalSlot cs = unit.getCritical(critLocation, critSlot);
                if (cs == null || cs.isBreached() || !cs.isDamaged()) continue;
                if (UnitUtils.isEngineCrit(cs)) {
                    engineCrits = UnitUtils.getNumberOfEngineCrits(unit);
                    continue;
                }
                if (cs.getType() == 0) {
                    ++systemCrits;
                    continue;
                }
                cost = (int)((double)cost + CUnit.getCritCost(unit, this, cs));
            }
        }
        cost += Integer.parseInt(this.getserverConfigs("SystemCritRepairCost")) * systemCrits;
        return cost += Integer.parseInt(this.getserverConfigs("EngineCritRepairCost")) * engineCrits;
    }

    public void setServerOpFlags(StringTokenizer st) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            while (st.hasMoreTokens()) {
                map.put(st.nextToken(), st.nextToken());
            }
            this.getData().getPlanetOpFlags().clear();
            this.getData().getPlanetOpFlags().putAll(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTechLaborCosts(Entity unit, int techType) {
        int cost = 0;
        int techCost = Integer.parseInt(this.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        int totalCrits = 0;
        boolean damagedEngine = false;
        for (int critLocation = 0; critLocation < unit.locations(); ++critLocation) {
            if (critLocation == 1 || critLocation == 3 || critLocation == 2) {
                if (unit.getArmor(critLocation, false) != unit.getOArmor(critLocation, false)) {
                    cost += techCost;
                }
                if (unit.getArmor(critLocation, true) != unit.getOArmor(critLocation, true)) {
                    cost += techCost;
                }
                if (unit.getInternal(critLocation) != unit.getOInternal(critLocation)) {
                    cost += techCost;
                }
            } else {
                if (unit.getArmor(critLocation, false) != unit.getOArmor(critLocation, false)) {
                    cost += techCost;
                }
                if (unit.getInternal(critLocation) != unit.getOInternal(critLocation)) {
                    cost += techCost;
                }
            }
            for (int critSlot = 0; critSlot < unit.getNumberOfCriticals(critLocation); ++critSlot) {
                CriticalSlot cs = unit.getCritical(critLocation, critSlot);
                if (cs == null || cs.isBreached() || !cs.isDamaged()) continue;
                if (UnitUtils.isEngineCrit(cs)) {
                    damagedEngine = true;
                    continue;
                }
                ++totalCrits;
            }
        }
        if (damagedEngine) {
            totalCrits = UnitUtils.getNumberOfEngineCrits(unit);
        }
        return cost += techCost * totalCrits + techCost;
    }

    public void retrieveOpData(String type, String data) {
        StringTokenizer st = new StringTokenizer(data, "#");
        String opName = st.nextToken();
        File opFile = new File("./data/operations/" + type);
        if (!opFile.exists()) {
            opFile.mkdirs();
        }
        opFile = new File("./data/operations/" + type + "/" + opName + ".txt");
        try {
            FileOutputStream out = new FileOutputStream(opFile);
            PrintStream p = new PrintStream(out);
            while (st.hasMoreTokens()) {
                p.println(st.nextToken().replaceAll("\\(pound\\)", "#"));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void retrieveMul(String data) {
        StringTokenizer st = new StringTokenizer(data, "#");
        String mulName = st.nextToken();
        File mulFile = new File("./data/armies/");
        if (!mulFile.exists()) {
            mulFile.mkdirs();
        }
        mulFile = new File("./data/armies/" + mulName);
        try {
            FileOutputStream out = new FileOutputStream(mulFile);
            PrintStream p = new PrintStream(out);
            while (st.hasMoreTokens()) {
                p.println(st.nextToken().replaceAll("\\(pound\\)", "#"));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public boolean isUsingAdvanceRepairs() {
        return Boolean.parseBoolean(this.getserverConfigs("UseAdvanceRepair")) || Boolean.parseBoolean(this.getserverConfigs("UseSimpleRepair"));
    }

    public boolean isDedicated() {
        return this.Config.isParam("DEDICATED");
    }

    public void updateOpData(boolean deleteCache) {
        try {
            if (deleteCache) {
                new File(this.cacheDir + "/OpList.txt").delete();
            }
            this.dataFetcher.checkForMostRecentOpList();
            this.setupAllOps();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void updateParam(StringTokenizer ST) {
        try {
            this.getConfig().setParam(ST.nextToken(), ST.nextToken());
            this.getConfig().saveConfig();
            this.setConfig();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public Server getMyServer() {
        return this.myServer;
    }

    public boolean isWaiting() {
        return this.waitingOnCommand;
    }

    public void setWaiting(boolean waiting) {
        this.waitingOnCommand = waiting;
    }

    public HashMap<String, Equipment> getBlackMarketEquipmentList() {
        return this.blackMarketEquipmentList;
    }

    public void updatePartsBlackMarket(String data) {
        StringTokenizer ST = new StringTokenizer(data, "#");
        boolean allowTechCrossOver = Boolean.parseBoolean(this.getserverConfigs("AllowCrossOverTech"));
        int techLevel = this.getData().getHouseByName(this.getPlayer().getHouse()).getTechLevel();
        this.getCampaign().getBlackMarketParts().clear();
        while (ST.hasMoreTokens()) {
            BMEquipment bme = new BMEquipment();
            bme.setEquipmentInternalName(ST.nextToken());
            bme.setAmount(Integer.parseInt(ST.nextToken()));
            bme.setCost(Double.parseDouble(ST.nextToken()));
            bme.setCostUp(Boolean.parseBoolean(ST.nextToken()));
            bme.getEquipmentName();
            bme.getTech();
            if (!allowTechCrossOver && !UnitUtils.isSameTech(bme.getTechLevel(), techLevel)) continue;
            this.getCampaign().getBlackMarketParts().put(bme.getEquipmentName(), bme);
        }
        this.getMainFrame().getMainPanel().refreshBME();
    }

    public void updatePlayerPartsCache(String data) {
        StringTokenizer ST = new StringTokenizer(data, "#");
        String key = ST.nextToken();
        int value = Integer.parseInt(ST.nextToken());
        if (value < 1) {
            this.getPlayer().getPartsCache().remove(key, Math.abs(value));
        } else {
            this.getPlayer().getPartsCache().add(key, value);
        }
        this.getMainFrame().getMainPanel().refreshBME();
    }

    public void updateClient() {
        try {
            this.goodbye();
            Runtime runtime = Runtime.getRuntime();
            String[] call = new String[]{"java", "-jar", "MekWarsAutoUpdate.jar", "PLAYER"};
            runtime.exec(call);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        System.exit(0);
    }

    public void createNewHouse(StringTokenizer st) {
        House house = new House();
        house.setId(TokenReader.readInt(st));
        house.setName(TokenReader.readString(st));
        house.setLogo(TokenReader.readString(st));
        house.setBaseGunner(TokenReader.readInt(st));
        house.setBasePilot(TokenReader.readInt(st));
        house.setHouseColor(TokenReader.readString(st));
        house.setHousePlayerColors(TokenReader.readString(st));
        house.setAbbreviation(TokenReader.readString(st));
        house.setConquerable(TokenReader.readBoolean(st));
        house.setTechLevel(TokenReader.readInt(st));
        house.setHouseDefectionFrom(TokenReader.readBoolean(st));
        house.setHouseDefectionTo(TokenReader.readBoolean(st));
        house.setUsedMekBayMultiplier(TokenReader.readFloat(st));
        this.getData().addHouse(house);
    }

    private static class PurgeAutoSaves
    implements Runnable {
        public void run() {
            long twoHours = 0x6DDD00L;
            try {
                while (true) {
                    File saveFiles;
                    if (!(saveFiles = new File("./savegames")).exists()) {
                        return;
                    }
                    AutoSaveFilter filter = new AutoSaveFilter();
                    File[] fileList = saveFiles.listFiles(filter);
                    for (int i = 0; i < fileList.length; ++i) {
                        File savedFile = fileList[i];
                        long lastTime = savedFile.lastModified();
                        if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - twoHours) continue;
                        try {
                            CampaignData.mwlog.infoLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - twoHours));
                            savedFile.delete();
                            continue;
                        }
                        catch (Exception ex) {
                            CampaignData.mwlog.errLog("Error trying to delete these files!");
                            CampaignData.mwlog.errLog(ex);
                        }
                    }
                    Thread.sleep(twoHours);
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    static class AutoSaveFilter
    implements FilenameFilter {
        AutoSaveFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("autosave");
        }
    }

    protected class TimeOutThread
    extends Thread {
        MWClient mwclient;

        public TimeOutThread(MWClient client) {
            this.mwclient = client;
        }

        public void run() {
            while (true) {
                try {
                    TimeOutThread.sleep(this.mwclient.TimeOut * 100L);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                if (this.mwclient.Status != 0) {
                    long timeout = System.currentTimeMillis() / 1000L - MWClient.this.LastPing;
                    if (timeout <= this.mwclient.TimeOut) continue;
                    MWClient.this.systemMessage("Ping timeout (" + timeout + " s)");
                    MWClient.this.Connector.closeConnection();
                    continue;
                }
                MWClient.this.LastPing = System.currentTimeMillis() / 1000L;
            }
        }
    }

    protected class CRefreshGUI
    implements Runnable {
        protected int mode = -1;

        public CRefreshGUI(int tmode) {
            this.mode = tmode;
        }

        public void run() {
            if (MWClient.this.MainFrame == null) {
                return;
            }
            try {
                switch (this.mode) {
                    case 1: {
                        MWClient.this.MainFrame.getMainPanel().getUserListPanel().refresh();
                        break;
                    }
                    case 2: {
                        MWClient.this.MainFrame.getMainPanel().getPlayerPanel().refresh();
                        break;
                    }
                    case 4: {
                        MWClient.this.MainFrame.refreshBattleTable();
                        break;
                    }
                    case 5: {
                        MWClient.this.MainFrame.getMainPanel().getHQPanel().refresh();
                        break;
                    }
                    case 0: {
                        MWClient.this.MainFrame.changeStatus(MWClient.this.Status, MWClient.this.LastStatus);
                        break;
                    }
                    case 6: {
                        MWClient.this.MainFrame.getMainPanel().getBMPanel().refresh();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class CAddToChat
    implements Runnable {
        String input = "";
        int channel = -1;
        String tabName = "";

        public CAddToChat(String tinput, int tchannel, String ttabName) {
            this.input = tinput;
            this.channel = tchannel;
            this.tabName = ttabName;
        }

        public void run() {
            MWClient.this.MainFrame.getMainPanel().getCommPanel().setChat(this.input, this.channel, this.tabName);
        }
    }
}

