/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import common.Army;
import common.Unit;
import common.util.TokenReader;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CArmy
extends Army {
    private MWClient mwclient;
    private TreeSet<String> legalOperations = new TreeSet();
    private float rawForceSize = 0.0f;

    public void fromString(String s, CPlayer p, String delimiter, MWClient client) {
        int i;
        this.mwclient = client;
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        this.setID(TokenReader.readInt(ST));
        this.setBV(TokenReader.readInt(ST));
        this.setLocked(TokenReader.readBoolean(ST));
        this.setName(TokenReader.readString(ST));
        this.setLowerLimiter(TokenReader.readInt(ST));
        this.setUpperLimiter(TokenReader.readInt(ST));
        int count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            CUnit u = p.getUnit(TokenReader.readInt(ST));
            if (u.getId() == 0) continue;
            this.addUnit(u);
        }
        count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            int key = TokenReader.readInt(ST);
            int unit = TokenReader.readInt(ST);
            this.getC3Network().put(key, unit);
        }
        this.setOpForceSize(TokenReader.readFloat(ST));
        count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            int unit = TokenReader.readInt(ST);
            this.addCommander(unit);
        }
        boolean locked = TokenReader.readBoolean(ST);
        if (locked) {
            this.playerLockArmy();
        } else {
            this.playerUnlockArmy();
        }
        boolean disabled = TokenReader.readBoolean(ST);
        if (disabled) {
            this.disableArmy();
        } else {
            this.enableArmy();
        }
    }

    public void addUnit(CUnit u) {
        this.getUnits().add(u);
    }

    public void addUnit(CUnit u, int position) {
        this.getUnits().add(position, u);
    }

    public TreeSet<String> getLegalOperations() {
        return this.legalOperations;
    }

    protected void setLegalOperations(TreeSet<String> ts) {
        this.legalOperations = ts;
    }

    public float getRawForceSize() {
        if (this.rawForceSize != 0.0f) {
            return this.rawForceSize;
        }
        for (Unit u : this.getUnits()) {
            if (u.getType() == 2) {
                this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("InfantryOperationsBVMod"));
                continue;
            }
            if (u.getType() == 1) {
                this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("VehicleOperationsBVMod"));
                continue;
            }
            if (u.getType() == 4) {
                this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("BAOperationsBVMod"));
                continue;
            }
            if (u.getType() == 5) {
                this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("AeroOperationsBVMod"));
                continue;
            }
            if (u.getType() == 3) {
                this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("ProtoOperationsBVMod"));
                continue;
            }
            this.rawForceSize += Float.parseFloat(this.mwclient.getserverConfigs("MekOperationsBVMod"));
        }
        return this.rawForceSize;
    }

    public void setRawForceSize(float rfs) {
        this.rawForceSize = rfs;
    }

    public double forceSizeModifier(double opposingForceSize) {
        double myForceSize = 0.0;
        this.setRawForceSize(0.0f);
        myForceSize = this.getRawForceSize();
        if (myForceSize > opposingForceSize) {
            return opposingForceSize / myForceSize + myForceSize / opposingForceSize - 1.0;
        }
        return 1.0;
    }

    public float getTotalTonnage() {
        float totalTonnage = 0.0f;
        for (Unit unit : this.getUnits()) {
            totalTonnage += ((CUnit)unit).getEntity().getWeight();
        }
        return totalTonnage;
    }

    public int getAverageWalk() {
        int walk = 0;
        if (this.getUnits().size() < 1) {
            return 0;
        }
        for (Unit unit : this.getUnits()) {
            CUnit en = (CUnit)unit;
            walk += en.getEntity().getWalkMP();
        }
        return walk /= this.getUnits().size();
    }

    public int getAverageJump() {
        int walk = 0;
        if (this.getUnits().size() < 1) {
            return 0;
        }
        for (Unit unit : this.getUnits()) {
            CUnit en = (CUnit)unit;
            walk += en.getEntity().getJumpMP();
        }
        return walk /= this.getUnits().size();
    }
}

