/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.campaign.CCampaign;
import client.campaign.CUnit;
import common.campaign.pilot.Pilot;
import common.util.TokenReader;
import java.util.StringTokenizer;

public class CBMUnit {
    private boolean soldByPlayer = false;
    private String modelName = "";
    private String fileName = "";
    private int auctionID = -1;
    private int unitID = -1;
    private int salesTicksRemaining = -1;
    private int minBid = -1;
    private int playersBid = -1;
    CUnit embeddedUnit;

    public CBMUnit(String listingData, CCampaign campaign) {
        StringTokenizer ST = new StringTokenizer(listingData, "*");
        this.auctionID = TokenReader.readInt(ST);
        this.unitID = TokenReader.readInt(ST);
        this.modelName = TokenReader.readString(ST);
        this.fileName = TokenReader.readString(ST);
        this.salesTicksRemaining = TokenReader.readInt(ST);
        this.minBid = TokenReader.readInt(ST);
        this.soldByPlayer = TokenReader.readBoolean(ST);
        this.playersBid = TokenReader.readInt(ST);
        this.embeddedUnit = new CUnit();
        this.embeddedUnit.setUnitFilename(this.fileName);
        this.embeddedUnit.createEntity();
        int factionGunnery = campaign.getPlayer().getMyHouse().getBaseGunner();
        int factionPiloting = campaign.getPlayer().getMyHouse().getBasePilot();
        if (this.embeddedUnit.getType() == 0 || this.embeddedUnit.getType() == 1) {
            this.embeddedUnit.setPilot(new Pilot("BM Unit", factionGunnery, factionPiloting));
        } else {
            this.embeddedUnit.setPilot(new Pilot("BM Unit", factionGunnery, 5));
        }
        this.embeddedUnit.getEntity().setCrew(new megamek.common.Pilot("Generic Pilot", factionGunnery, factionPiloting));
    }

    public int getAuctionID() {
        return this.auctionID;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getTicks() {
        return this.salesTicksRemaining;
    }

    public void decrementSalesTicks() {
        --this.salesTicksRemaining;
    }

    public int getMinBid() {
        return this.minBid;
    }

    public boolean playerIsSeller() {
        return this.soldByPlayer;
    }

    public int getBid() {
        return this.playersBid;
    }

    public CUnit getEmbeddedUnit() {
        return this.embeddedUnit;
    }
}

