/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CBMUnit;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.gui.BlackMarketModel;
import client.gui.MechInfo;
import client.gui.TableSorter;
import client.gui.dialog.MechDetailDisplay;
import client.gui.dialog.SellUnitDialog;
import common.CampaignData;
import common.util.SpringLayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.common.Entity;

public class CBMPanel
extends JPanel {
    private static final long serialVersionUID = -432087180209544906L;
    MWClient mwclient;
    CPlayer Player;
    long lastUpdate = -1L;
    public BlackMarketModel BlackMarketInfo;
    private JTable tblMarket = new JTable();
    private JScrollPane spMarket = new JScrollPane();
    private JButton btnShowMek = new JButton();
    private JButton btnRecallBid = new JButton();
    private JButton btnRecallUnit = new JButton();
    private JButton btnSellUnit = new JButton();
    private JButton btnBid = new JButton();
    private JPanel pnlBuy = new JPanel();
    private JPanel pnlBuyBtns = new JPanel();
    private JPanel spacingPanel1 = new JPanel();
    private JPanel spacingPanel2 = new JPanel();
    private JPanel spacingPanel3 = new JPanel();
    private JPanel pnlMekIconHolder = new JPanel();
    private JPanel pnlMekIcon = new JPanel();
    private boolean factionBidsAllowed = true;
    private CCampaign theCampaign;
    private GridBagConstraints gridBagConstraints;
    private CBMUnit mm;

    public CBMPanel(MWClient client) {
        this.setLayout(new GridBagLayout());
        this.mwclient = client;
        this.pnlMekIconHolder = new JPanel();
        this.pnlMekIconHolder.setMaximumSize(new Dimension(84, 72));
        this.pnlMekIconHolder.setMaximumSize(new Dimension(84, 72));
        this.pnlMekIcon = new MechInfo(this.mwclient.getConfig().getImage("CAMO"));
        this.pnlMekIcon.setMinimumSize(new Dimension(84, 72));
        this.pnlMekIcon.setPreferredSize(new Dimension(84, 72));
        this.pnlMekIcon.setMaximumSize(new Dimension(84, 72));
        this.BlackMarketInfo = new BlackMarketModel(this.mwclient);
        this.theCampaign = client.getCampaign();
        this.Player = this.theCampaign.getPlayer();
        TableSorter sorter = new TableSorter(this.BlackMarketInfo, client, 0);
        this.tblMarket.setModel(sorter);
        this.tblMarket.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CBMPanel.this.btnShowMekActionPerformed(new ActionEvent(CBMPanel.this.btnShowMek, 0, ""));
                }
            }
        });
        this.BlackMarketInfo.initColumnSizes(this.tblMarket);
        for (int i = 0; i < this.BlackMarketInfo.getColumnCount(); ++i) {
            this.tblMarket.getColumnModel().getColumn(i).setCellRenderer(this.BlackMarketInfo.getRenderer());
        }
        sorter.addMouseListenerToHeaderInTable(this.tblMarket);
        this.tblMarket.setSelectionMode(0);
        ListSelectionModel rowSM = this.tblMarket.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    ((MechInfo)CBMPanel.this.pnlMekIcon).setImageVisible(false);
                }
                int selectedRow = lsm.getMinSelectionIndex();
                Integer auctionId = (Integer)CBMPanel.this.tblMarket.getModel().getValueAt(selectedRow, 5);
                if (auctionId != null) {
                    CBMPanel.this.mm = CBMPanel.this.getMarketMechAtRow(CBMPanel.this.tblMarket.getSelectedRow());
                    if (CBMPanel.this.mm != null) {
                        CBMPanel.this.btnShowMek.setEnabled(true);
                        if (CBMPanel.this.mm.getBid() > 0) {
                            CBMPanel.this.btnRecallBid.setEnabled(true);
                        } else {
                            CBMPanel.this.btnRecallBid.setEnabled(false);
                        }
                        if (CBMPanel.this.mm.playerIsSeller()) {
                            CBMPanel.this.btnBid.setEnabled(false);
                            CBMPanel.this.btnRecallUnit.setEnabled(true);
                        } else {
                            if (CBMPanel.this.factionBidsAllowed) {
                                CBMPanel.this.btnBid.setEnabled(true);
                            } else {
                                CBMPanel.this.btnBid.setEnabled(false);
                            }
                            CBMPanel.this.btnRecallUnit.setEnabled(false);
                        }
                        CBMPanel.this.mwclient.getMainFrame().getMainPanel().getBMPanel().resetCamo();
                    } else {
                        CBMPanel.this.btnRecallBid.setEnabled(false);
                        CBMPanel.this.btnRecallUnit.setEnabled(false);
                        CBMPanel.this.btnBid.setEnabled(false);
                        CBMPanel.this.btnShowMek.setEnabled(false);
                    }
                }
            }
        });
        this.pnlBuy.setLayout(new GridBagLayout());
        this.spMarket.setToolTipText("Click on the column header to sort.");
        this.spMarket.setPreferredSize(new Dimension(300, 370));
        this.tblMarket.setDoubleBuffered(true);
        this.spMarket.setViewportView(this.tblMarket);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.pnlBuy.add((Component)this.spMarket, this.gridBagConstraints);
        JPanel panelButtonWrapper = new JPanel();
        this.pnlBuyBtns.setLayout(new SpringLayout());
        this.btnShowMek.setText("Show Unit");
        this.btnShowMek.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPanel.this.btnShowMekActionPerformed(evt);
            }
        });
        this.spacingPanel1 = new JPanel();
        this.spacingPanel1.setMaximumSize(new Dimension(20, 1));
        this.btnBid.setText("Place Bid");
        this.btnBid.setEnabled(false);
        this.btnBid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPanel.this.btnBidActionPerformed(evt);
            }
        });
        this.btnRecallBid.setText("Retract Bid");
        this.btnRecallBid.setEnabled(false);
        this.btnRecallBid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPanel.this.btnRecallBidActionPerformed(evt);
            }
        });
        this.spacingPanel2 = new JPanel();
        this.spacingPanel2.setMaximumSize(new Dimension(20, 1));
        this.btnRecallUnit.setText("Remove Unit");
        this.btnRecallUnit.setEnabled(false);
        this.btnRecallUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPanel.this.btnRecallUnitActionPerformed(evt);
            }
        });
        this.btnSellUnit.setText("Sell Unit");
        this.btnSellUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPanel.this.btnSellUnitActionPerformed(evt);
            }
        });
        this.spacingPanel3 = new JPanel();
        this.spacingPanel3.setMaximumSize(new Dimension(20, 1));
        this.resetButtonBar();
        panelButtonWrapper.add(this.pnlBuyBtns);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.pnlBuy.add((Component)panelButtonWrapper, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridheight = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 30;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlBuy, this.gridBagConstraints);
        this.refresh();
    }

    public void fireMarketChanged() {
        this.BlackMarketInfo.refreshModel();
        this.tblMarket.setPreferredSize(new Dimension(this.tblMarket.getWidth(), this.tblMarket.getRowHeight() * this.tblMarket.getRowCount()));
        this.tblMarket.revalidate();
    }

    public void refresh() {
        this.fireMarketChanged();
    }

    private void btnRecallBidActionPerformed(ActionEvent evt) {
        this.mm = this.getMarketMechAtRow(this.tblMarket.getSelectedRow());
        if (this.mm == null) {
            return;
        }
        if (this.tblMarket.getValueAt(this.tblMarket.getSelectedRow(), 4) == null) {
            return;
        }
        this.mwclient.sendChat("/c recallbid#" + this.mm.getAuctionID());
        this.btnRecallBid.setEnabled(false);
        this.btnRecallUnit.setEnabled(false);
        this.btnBid.setEnabled(false);
    }

    private void btnRecallUnitActionPerformed(ActionEvent evt) {
        this.mm = this.getMarketMechAtRow(this.tblMarket.getSelectedRow());
        if (this.mm == null) {
            return;
        }
        if (!this.mm.playerIsSeller()) {
            return;
        }
        this.mwclient.sendChat("/c recall#" + this.mm.getAuctionID());
        this.btnRecallBid.setEnabled(false);
        this.btnRecallUnit.setEnabled(false);
        this.btnBid.setEnabled(false);
    }

    public void btnSellUnitActionPerformed(ActionEvent evt) {
        SellUnitDialog sud = new SellUnitDialog(null, this.mwclient, null);
        sud.setVisible(true);
    }

    private void btnShowMekActionPerformed(ActionEvent evt) {
        this.mm = this.getMarketMechAtRow(this.tblMarket.getSelectedRow());
        if (this.mm == null) {
            return;
        }
        Entity theEntity = this.mm.getEmbeddedUnit().getEntity();
        theEntity.loadAllWeapons();
        JFrame InfoWindow = new JFrame();
        MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
        InfoWindow.getContentPane().add(MechDetailInfo);
        InfoWindow.setSize(220, 400);
        InfoWindow.setResizable(false);
        MechDetailInfo.displayEntity(theEntity, this.mm.getEmbeddedUnit().getEntity().calculateBattleValue(false, false), this.mwclient.getConfig().getImage("CAMO"));
        InfoWindow.setTitle(this.mm.getModelName());
        InfoWindow.setLocationRelativeTo(this.mwclient.getMainFrame());
        InfoWindow.setVisible(true);
    }

    public CBMUnit getMarketMechAtRow(int row) {
        this.mm = null;
        Integer auctionId = (Integer)this.tblMarket.getModel().getValueAt(row, 5);
        if (auctionId != null) {
            this.mm = this.theCampaign.getBlackMarket().get(auctionId);
        }
        return this.mm;
    }

    private void btnBidActionPerformed(ActionEvent evt) {
        int auctionID;
        int row = this.tblMarket.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.mm = this.getMarketMechAtRow(this.tblMarket.getSelectedRow());
        if (this.mm.playerIsSeller()) {
            return;
        }
        if (this.mm != null && (auctionID = this.mm.getAuctionID()) != -1) {
            String playerBidString = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "<HTML><center>How much would you like to bid on the " + this.mm.getModelName() + "?<BR>Minimum is " + this.mwclient.moneyOrFluMessage(true, true, this.mm.getMinBid()) + ".</center></HTML>", "Amount to Bid", -1);
            if (playerBidString == null || playerBidString.trim().length() == 0) {
                return;
            }
            try {
                int playerBid = Integer.parseInt(playerBidString);
                if (playerBid < this.mm.getMinBid()) {
                    String toUser = "CH|CLIENT: You tried to bid less than the minimum your contacts are willing to accept for the " + this.mm.getModelName() + ". Try bidding " + this.mwclient.moneyOrFluMessage(true, false, this.mm.getMinBid()) + " or more.";
                    this.mwclient.doParseDataInput(toUser);
                    return;
                }
                this.mwclient.sendChat("/c bid#" + auctionID + "#" + playerBid);
                this.btnBid.setEnabled(false);
                this.btnRecallBid.setEnabled(false);
            }
            catch (NumberFormatException NFE) {
                String toUser = "CH|CLIENT: Invalid Bid amount. Try using numbers next time!";
                this.mwclient.doParseDataInput(toUser);
                return;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void resetCamo() {
        if (this.mwclient.getConfig().isParam("BMPREVIEWIMAGE")) {
            this.pnlMekIcon = new MechInfo(this.mwclient.getConfig().getImage("CAMO"));
            this.pnlMekIcon.setMinimumSize(new Dimension(84, 72));
            this.pnlMekIcon.setPreferredSize(new Dimension(84, 72));
            this.pnlMekIcon.setMaximumSize(new Dimension(84, 72));
            try {
                ((MechInfo)this.pnlMekIcon).setUnit(this.mm.getEmbeddedUnit().getEntity());
                ((MechInfo)this.pnlMekIcon).setImageVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pnlMekIconHolder.removeAll();
            this.pnlMekIconHolder.add(this.pnlMekIcon);
        } else {
            ((MechInfo)this.pnlMekIcon).setImageVisible(false);
        }
        this.pnlBuyBtns.validate();
    }

    public void checkFactionAccess() {
        boolean sellingEnabled = true;
        StringTokenizer blockedFactions = new StringTokenizer(this.mwclient.getserverConfigs("BMNoSell"), "$");
        while (blockedFactions.hasMoreTokens()) {
            if (!this.Player.getMyHouse().getName().equals(blockedFactions.nextToken())) continue;
            sellingEnabled = false;
        }
        if (sellingEnabled) {
            this.btnSellUnit.setEnabled(true);
        } else {
            this.btnSellUnit.setEnabled(false);
        }
        boolean buyingEnabled = true;
        blockedFactions = new StringTokenizer(this.mwclient.getserverConfigs("BMNoBuy"), "$");
        while (blockedFactions.hasMoreTokens()) {
            if (!this.Player.getMyHouse().getName().equals(blockedFactions.nextToken())) continue;
            buyingEnabled = false;
        }
        this.factionBidsAllowed = buyingEnabled;
    }

    public void resetButtonBar() {
        if (this.mwclient.getConfig().isParam("BMPREVIEWIMAGE")) {
            this.pnlBuyBtns.removeAll();
            this.pnlMekIconHolder.removeAll();
            JPanel buttonSpring = new JPanel(new SpringLayout());
            buttonSpring.add(this.btnShowMek);
            buttonSpring.add(this.btnBid);
            buttonSpring.add(this.spacingPanel1);
            buttonSpring.add(this.btnBid);
            buttonSpring.add(this.btnRecallBid);
            buttonSpring.add(this.spacingPanel2);
            buttonSpring.add(this.btnRecallUnit);
            buttonSpring.add(this.btnSellUnit);
            this.resetCamo();
            this.pnlMekIconHolder.add(this.pnlMekIcon);
            this.pnlBuyBtns.add(this.pnlMekIconHolder);
            SpringLayoutHelper.setupSpringGrid(buttonSpring, 1, 8);
            this.pnlBuyBtns.add(new JLabel("\n "));
            this.pnlBuyBtns.add(buttonSpring);
            SpringLayoutHelper.setupSpringGrid(this.pnlBuyBtns, 1, 3);
        } else {
            this.pnlBuyBtns.removeAll();
            this.pnlBuyBtns.add(this.btnShowMek);
            this.pnlBuyBtns.add(this.btnBid);
            this.pnlBuyBtns.add(this.spacingPanel1);
            this.pnlBuyBtns.add(this.btnBid);
            this.pnlBuyBtns.add(this.btnRecallBid);
            this.pnlBuyBtns.add(this.spacingPanel2);
            this.pnlBuyBtns.add(this.btnRecallUnit);
            this.pnlBuyBtns.add(this.btnSellUnit);
            SpringLayoutHelper.setupSpringGrid(this.pnlBuyBtns, 1, 8);
        }
        this.pnlBuyBtns.validate();
        this.repaint();
    }
}

