/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CCampaign;
import client.gui.BlackMarketPartsModel;
import client.gui.TableSorter;
import common.BMEquipment;
import common.util.SpringLayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CBMPartsPanel
extends JPanel {
    private static final long serialVersionUID = -5553918525846016147L;
    MWClient mwclient;
    long lastUpdate = -1L;
    public BlackMarketPartsModel BlackMarketInfo;
    private JTable tblMarket = new JTable();
    private JScrollPane spMarket = new JScrollPane();
    private JButton btnBuy = new JButton("Buy");
    private JPanel pnlBuyBtns = new JPanel();
    private JPanel pnlBuy = new JPanel();
    private JPanel spacingPanel1 = new JPanel();
    private JPanel spacingPanel3 = new JPanel();
    private CCampaign theCampaign;
    private GridBagConstraints gridBagConstraints;
    private BMEquipment bme;

    public CBMPartsPanel(MWClient client, String type) {
        this.setLayout(new GridBagLayout());
        this.mwclient = client;
        this.BlackMarketInfo = new BlackMarketPartsModel(this.mwclient, type);
        this.theCampaign = client.getCampaign();
        TableSorter sorter = new TableSorter(this.BlackMarketInfo, client, 3);
        this.tblMarket.setModel(sorter);
        this.btnBuy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CBMPartsPanel.this.btnBuyPartsPerformed(evt);
            }
        });
        this.tblMarket.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CBMPartsPanel.this.btnBuyPartsPerformed(new ActionEvent(CBMPartsPanel.this.btnBuy, 0, ""));
                }
            }
        });
        this.BlackMarketInfo.initColumnSizes(this.tblMarket);
        for (int i = 0; i < this.BlackMarketInfo.getColumnCount(); ++i) {
            this.tblMarket.getColumnModel().getColumn(i).setCellRenderer(this.BlackMarketInfo.getRenderer());
        }
        sorter.addMouseListenerToHeaderInTable(this.tblMarket);
        this.tblMarket.setSelectionMode(0);
        ListSelectionModel rowSM = this.tblMarket.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int selectedRow = lsm.getMinSelectionIndex();
                String part = (String)CBMPartsPanel.this.tblMarket.getModel().getValueAt(selectedRow, 0);
                if (part != null) {
                    CBMPartsPanel.this.bme = CBMPartsPanel.this.getPartsAtRow(CBMPartsPanel.this.tblMarket.getSelectedRow());
                    if (CBMPartsPanel.this.bme != null) {
                        CBMPartsPanel.this.btnBuy.setEnabled(true);
                    } else {
                        CBMPartsPanel.this.btnBuy.setEnabled(false);
                    }
                }
            }
        });
        this.pnlBuy.setLayout(new GridBagLayout());
        this.spMarket.setToolTipText("Click on the column header to sort.");
        this.spMarket.setPreferredSize(new Dimension(300, 370));
        this.tblMarket.setDoubleBuffered(true);
        this.spMarket.setViewportView(this.tblMarket);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.pnlBuy.add((Component)this.spMarket, this.gridBagConstraints);
        JPanel panelButtonWrapper = new JPanel();
        this.pnlBuyBtns.setLayout(new SpringLayout());
        this.spacingPanel1 = new JPanel();
        this.spacingPanel1.setMaximumSize(new Dimension(20, 1));
        this.spacingPanel3 = new JPanel();
        this.spacingPanel3.setMaximumSize(new Dimension(20, 1));
        this.resetButtonBar();
        panelButtonWrapper.add(this.pnlBuyBtns);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.pnlBuy.add((Component)panelButtonWrapper, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridheight = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 30;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlBuy, this.gridBagConstraints);
        this.refresh();
    }

    public void fireMarketChanged() {
        this.BlackMarketInfo.refreshModel();
        this.tblMarket.setPreferredSize(new Dimension(this.tblMarket.getWidth(), this.tblMarket.getRowHeight() * this.tblMarket.getRowCount()));
        this.tblMarket.revalidate();
    }

    public void refresh() {
        this.fireMarketChanged();
    }

    public BMEquipment getPartsAtRow(int row) {
        this.bme = null;
        String part = (String)this.tblMarket.getModel().getValueAt(row, 0);
        if (part != null) {
            this.bme = this.theCampaign.getBlackMarketParts().get(part);
        }
        return this.bme;
    }

    private void btnBuyPartsPerformed(ActionEvent evt) {
        int row = this.tblMarket.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.bme = this.getPartsAtRow(this.tblMarket.getSelectedRow());
        if (this.bme != null) {
            String playerAmountString = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "<HTML><center>How many units of " + this.bme.getEquipmentName() + " would you like to buy?", "Amount to Buy", -1);
            if (playerAmountString == null || playerAmountString.trim().length() == 0) {
                return;
            }
            try {
                int amount = Integer.parseInt(playerAmountString);
                if (amount > this.bme.getAmount()) {
                    JOptionPane.showMessageDialog(this, "There are only " + this.bme.getAmount() + " " + this.bme.getEquipmentName() + " parts available.");
                    return;
                }
                if ((double)amount * this.bme.getCost() > (double)this.mwclient.getPlayer().getMoney()) {
                    JOptionPane.showMessageDialog(this, "You only have " + this.mwclient.moneyOrFluMessage(true, true, this.mwclient.getPlayer().getMoney()));
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showConfirmDialog(this.mwclient.getMainFrame(), "Invalid Syntax Try Again.");
                return;
            }
            this.mwclient.sendChat("/c buyparts#" + this.bme.getEquipmentInternalName() + "#" + playerAmountString);
        }
    }

    public void resetButtonBar() {
        this.pnlBuyBtns.removeAll();
        this.pnlBuyBtns.add(this.btnBuy);
        SpringLayoutHelper.setupSpringGrid(this.pnlBuyBtns, 8);
        this.pnlBuyBtns.validate();
        this.repaint();
    }
}

