/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.TableSorter;
import common.MMGame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class CBattlePanel
extends JPanel {
    private static final long serialVersionUID = -1556406945897698254L;
    private final MWClient mwclient;
    private final JTable BattleTable;
    private final BattlesModel battleTableModel;
    private final JScrollPane battleScrollPane;
    private final TableSorter battleSorter;

    public CBattlePanel(MWClient client) {
        this.mwclient = client;
        this.setLayout(new BoxLayout(this, 1));
        this.battleTableModel = new BattlesModel();
        this.BattleTable = new JTable();
        this.battleSorter = new TableSorter(this.battleTableModel, this.mwclient, 2);
        this.BattleTable.setModel(this.battleSorter);
        this.battleSorter.addMouseListenerToHeaderInTable(this.BattleTable);
        this.BattleTable.setDefaultRenderer(Object.class, this.battleTableModel.getRenderer());
        this.BattleTable.addMouseListener(new BattlePopupListener());
        this.BattleTable.getColumnModel().getColumn(0).setMinWidth(10);
        this.BattleTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.BattleTable.getColumnModel().getColumn(1).setMinWidth(10);
        this.BattleTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.BattleTable.getColumnModel().getColumn(2).setMinWidth(10);
        this.BattleTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.BattleTable.getColumnModel().getColumn(2).setMaxWidth(200);
        this.BattleTable.getColumnModel().getColumn(3).setMinWidth(10);
        this.BattleTable.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.BattleTable.getColumnModel().getColumn(4).setMinWidth(10);
        this.BattleTable.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.BattleTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String curName = (String)CBattlePanel.this.battleSorter.getValueAt(CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()), 0);
                    CBattlePanel.this.mwclient.startClient(curName, true);
                }
            }
        });
        this.BattleTable.setSelectionMode(0);
        this.battleScrollPane = new JScrollPane(this.BattleTable);
        this.battleScrollPane.add((Component)this.BattleTable, null);
        this.battleScrollPane.setPreferredSize(new Dimension(640, 190));
        this.battleScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.battleScrollPane.getViewport().add((Component)this.BattleTable, null);
        this.add((Component)this.battleScrollPane, "North");
    }

    public JScrollPane getBattleScrollPane() {
        return this.battleScrollPane;
    }

    public BattlesModel getBattleTableModel() {
        return this.battleTableModel;
    }

    public JTable getBattleTable() {
        return this.BattleTable;
    }

    class BattlesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6384905445657195650L;
        public Object[] sortedGames;
        public static final int NAME = 0;
        public static final int PLAYERCOUNT = 1;
        public static final int VERSION = 2;
        public static final int COMMENT = 3;
        public static final int PLAYERNAMES = 4;
        final String[] columnNames = new String[]{"Name", "Players", "Version", "Comment", "Player Names"};
        final String[] longValues = new String[]{"XXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXX"};

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public BattlesModel() {
            this.sortedGames = CBattlePanel.this.mwclient.getServers().values().toArray();
        }

        public void refreshModel() {
            this.sortedGames = CBattlePanel.this.mwclient.getServers().values().toArray();
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.sortedGames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0) {
                return "";
            }
            if (row >= this.sortedGames.length) {
                return "";
            }
            MMGame aGame = (MMGame)this.sortedGames[row];
            switch (col) {
                case 0: {
                    return aGame.getHostName();
                }
                case 1: {
                    return aGame.getCurrentPlayers().size() + "/" + aGame.getMaxPlayers();
                }
                case 2: {
                    return aGame.getVersion();
                }
                case 3: {
                    return aGame.getComment();
                }
                case 4: {
                    StringBuffer result = new StringBuffer();
                    for (String currName : aGame.getCurrentPlayers()) {
                        result.append(currName + ", ");
                    }
                    String toReturn = result.toString().trim();
                    if (toReturn.lastIndexOf(",") >= 0) {
                        toReturn = toReturn.substring(0, toReturn.lastIndexOf(","));
                    }
                    return toReturn;
                }
            }
            return "";
        }

        public Renderer getRenderer() {
            return new Renderer();
        }

        class Renderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -2353501701911884548L;

            Renderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (BattlesModel.this.sortedGames.length <= row) {
                    return c;
                }
                if (isSelected) {
                    return c;
                }
                String gameName = (String)CBattlePanel.this.battleSorter.getValueAt(row, 0);
                MMGame game = CBattlePanel.this.mwclient.getServers().get(gameName);
                if (game.getCurrentPlayers().size() >= game.getMaxPlayers()) {
                    c.setBackground(Color.red);
                } else if (game.getStatus().equals("Open")) {
                    c.setBackground(Color.green);
                } else if (game.getStatus().equals("Running")) {
                    c.setBackground(Color.yellow);
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        }
    }

    class BattlePopupListener
    extends MouseAdapter
    implements ActionListener {
        BattlePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger()) {
                JMenuItem menuItem;
                int currRow = CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint());
                String curName = (String)CBattlePanel.this.battleSorter.getValueAt(currRow, 0);
                MMGame curGame = CBattlePanel.this.mwclient.getServers().get(curName);
                if (curGame == null) {
                    return;
                }
                if (curGame.getCurrentPlayers().size() < curGame.getMaxPlayers() || CBattlePanel.this.mwclient.isMod()) {
                    menuItem = new JMenuItem("View game");
                    menuItem.setActionCommand("V|" + curName);
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    if (curGame.getStatus().equals("Open")) {
                        menuItem = new JMenuItem("Join game");
                        menuItem.setActionCommand("J|" + curName);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                    }
                } else {
                    menuItem = new JMenuItem("Game is full");
                    popup.add(menuItem);
                }
                if (curGame.getHostName().equals(CBattlePanel.this.mwclient.getUsername())) {
                    menuItem = new JMenuItem("Stop Hosting");
                    menuItem.setActionCommand("S|" + curName);
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                }
                if (curGame.getHostName().startsWith("[Dedicated]")) {
                    JMenu serviceMenu = new JMenu("Maintenance");
                    JMenu settingsMenu = new JMenu("Settings");
                    JMenu portMenu = new JMenu("Port");
                    JMenu ownersMenu = new JMenu("Owners");
                    JMenu miscMenu = new JMenu("Misc");
                    JMenu autoRestartMenu = new JMenu("AutoRestart");
                    JMenu updateMenu = new JMenu("Update");
                    popup.addSeparator();
                    menuItem = new JMenuItem("Restart Dedicated");
                    menuItem.setActionCommand("RESTART|" + curName);
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    menuItem = new JMenuItem("Load Autosave");
                    menuItem.setActionCommand("LOADAUTOSAVE|" + curName);
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    popup.addSeparator();
                    menuItem = new JMenuItem("Reset Dedicated");
                    menuItem.setActionCommand("RESET|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Kill Dedicated");
                    menuItem.setActionCommand("DIE|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Start Dedicated");
                    menuItem.setActionCommand("START|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Stop Dedicated");
                    menuItem.setActionCommand("STOP|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Load Game");
                    menuItem.setActionCommand("LOADGAME|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Display Saved Games");
                    menuItem.setActionCommand("DSG|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    JMenu logMenu = new JMenu("Logs");
                    menuItem = new JMenuItem("Display MegaMek Log");
                    menuItem.setActionCommand("DMML|" + curName);
                    menuItem.addActionListener(this);
                    logMenu.add(menuItem);
                    menuItem = new JMenuItem("Display Error Log");
                    menuItem.setActionCommand("DDEL|" + curName);
                    menuItem.addActionListener(this);
                    logMenu.add(menuItem);
                    menuItem = new JMenuItem("Display Log");
                    menuItem.setActionCommand("DELL|" + curName);
                    menuItem.addActionListener(this);
                    logMenu.add(menuItem);
                    serviceMenu.add(logMenu);
                    menuItem = new JMenuItem("Ping Dedicated");
                    menuItem.setActionCommand("PING|" + curName);
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Get Update URL");
                    menuItem.setActionCommand("GETUPDATEURL|" + curName);
                    menuItem.addActionListener(this);
                    updateMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Update URL");
                    menuItem.setActionCommand("SETUPDATEURL|" + curName);
                    menuItem.addActionListener(this);
                    updateMenu.add(menuItem);
                    menuItem = new JMenuItem("Update Dedicated");
                    menuItem.setActionCommand("UPDATE|" + curName);
                    menuItem.addActionListener(this);
                    updateMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Owners");
                    menuItem.setActionCommand("OWNERS|" + curName);
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Add Dedicated Owners");
                    menuItem.setActionCommand("ADDOWNERS|" + curName);
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Clear Dedicated Owners");
                    menuItem.setActionCommand("CLEAROWNERS|" + curName);
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Port");
                    menuItem.setActionCommand("GETPORT|" + curName);
                    menuItem.addActionListener(this);
                    portMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Port");
                    menuItem.setActionCommand("SETPORT|" + curName);
                    menuItem.addActionListener(this);
                    portMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Name");
                    menuItem.setActionCommand("SETNAME|" + curName);
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Comment");
                    menuItem.setActionCommand("SETCOMMENT|" + curName);
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Max Players");
                    menuItem.setActionCommand("SETPLAYERS|" + curName);
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Saved Games Purge Days");
                    menuItem.setActionCommand("GSGPD|" + curName);
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Saved Games Purge Days");
                    menuItem.setActionCommand("SSGPD|" + curName);
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Restart Count");
                    menuItem.setActionCommand("CURRENTRESTART|" + curName);
                    menuItem.addActionListener(this);
                    autoRestartMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Restart Count");
                    menuItem.setActionCommand("SETRESTART|" + curName);
                    menuItem.addActionListener(this);
                    autoRestartMenu.add(menuItem);
                    settingsMenu.add(portMenu);
                    settingsMenu.add(ownersMenu);
                    settingsMenu.add(miscMenu);
                    settingsMenu.add(autoRestartMenu);
                    settingsMenu.add(updateMenu);
                    serviceMenu.add(settingsMenu);
                    popup.add(serviceMenu);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String s = actionEvent.getActionCommand();
            if (s.startsWith("V|")) {
                CBattlePanel.this.mwclient.startClient(s.substring(2), false);
            }
            if (s.startsWith("J|")) {
                CBattlePanel.this.mwclient.startClient(s.substring(2), true);
            }
            if (s.startsWith("S|")) {
                CBattlePanel.this.mwclient.getMainFrame().stopHost();
                CBattlePanel.this.mwclient.stopHost();
            }
            if (s.startsWith("RESTART|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to restart\n\r" + currName + "?", "Restart?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",restart");
                }
            } else if (s.startsWith("RESET|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to reset\n\r" + currName + "?", "Reset?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",reset");
                }
            } else if (s.startsWith("DIE|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to kill\n\r" + currName + "?", "Kill?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",die");
                }
            } else if (s.startsWith("START|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to start\n\r" + currName + "?", "Start?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",start");
                }
            } else if (s.startsWith("STOP|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to stop\n\r" + currName + "?", "Stop?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",stop");
                }
            } else if (s.startsWith("OWNERS|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",owners");
            } else if (s.startsWith("CLEAROWNERS|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to clear the owners of\n\r" + currName + "?", "Clear the owners?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",clearowners");
                }
            } else if (s.startsWith("ADDOWNERS|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a list of owners you want to add to\n\r" + currName + "\n\r(sperated by $)", "Add Owners", 2);
                if (result != null && result.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",owner " + result);
                }
            } else if (s.startsWith("GETPORT|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",port");
            } else if (s.startsWith("SETPORT|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new port for\n\r" + currName, "New Port", 2);
                if (result != null && result.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",port " + result);
                }
            } else if (s.startsWith("GSGPD|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",savegamepurge");
            } else if (s.startsWith("SSGPD|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new day for\n\r" + currName, "New days out to purge", 2);
                if (result != null && result.length() >= 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",savegamepurge " + result);
                }
            } else if (s.startsWith("PING|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",ping");
            } else if (s.startsWith("UPDATE|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",update");
            } else if (s.startsWith("DSG|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",displaysavedgames");
            } else if (s.startsWith("DMML|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",displaymegameklog");
            } else if (s.startsWith("DDEL|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",displaydederrorlog");
            } else if (s.startsWith("DELL|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",displaydedlog");
            } else if (s.startsWith("LOADGAME|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = null;
                result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter name of the save file on\n\r" + currName + "\n\r(leave blank to load autosave.sav)", "Load Game", 2);
                if (result != null) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",loadgame " + result);
                }
            } else if (s.startsWith("LOADAUTOSAVE|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                int result = JOptionPane.showConfirmDialog(CBattlePanel.this.mwclient.getMainFrame(), "Are you sure you want to load the autosave game on\n\r" + currName + "?", "Load Auto Saved Game?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",loadautosave");
                }
            } else if (s.startsWith("SETNAME|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new name for\n\r" + currName + "\n\rNote: This will kill the Ded. A restart will be required.", "New Name", 2);
                if (result != null && result.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",name " + result);
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",die");
                }
            } else if (s.startsWith("SETCOMMENT|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new comment for\n\r" + currName, "New Comment", 2);
                if (result != null && result.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",comment " + result);
                }
            } else if (s.startsWith("SETPLAYERS|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter the max number of players for\n\r" + currName, "New Players", 2);
                if (result != null && result.length() > 0) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",players " + result);
                }
            } else if (s.startsWith("CURRENTRESTART|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",restartcount");
            } else if (s.startsWith("SETRESTART|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new restart count for\n\r" + currName, "New Restart", 2);
                if (result != null && result.length() >= 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",restartcount " + result);
                }
            } else if (s.startsWith("GETUPDATEURL|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",getupdateurl");
            } else if (s.startsWith("SETUPDATEURL|")) {
                String currName = s.substring(s.indexOf(124) + 1);
                String result = JOptionPane.showInputDialog(CBattlePanel.this.mwclient.getMainFrame(), "Enter a new update url for\n\r" + currName, "New Update URL", 2);
                if (result != null && result.length() >= 1) {
                    CBattlePanel.this.mwclient.sendChat("/mail " + currName + ",setupdateurl " + result);
                }
            }
        }
    }
}

