/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CUser;
import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.AttackMenu;
import client.gui.Browser;
import client.gui.CMainPanel;
import client.gui.dialog.ComponentConverterDialog;
import client.gui.dialog.ConfigurationDialog;
import client.gui.dialog.HouseNameDialog;
import client.gui.dialog.PlanetNameDialog;
import client.gui.dialog.PlayerNameDialog;
import client.gui.dialog.RegisterNameDialog;
import client.gui.dialog.SellUnitDialog;
import client.gui.dialog.SubFactionNameDialog;
import client.gui.dialog.TableViewerDialog;
import client.gui.dialog.TraitDialog;
import client.gui.dialog.UnitSelectionDialog;
import client.gui.dialog.UnitViewerDialog;
import client.gui.menuPopupSound;
import client.gui.menuSound;
import common.CampaignData;
import common.House;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import megamek.MegaMek;
import megamek.client.ui.AWT.UnitLoadingDialog;

public class CMainFrame
extends JFrame {
    private static final long serialVersionUID = -1198882220815512476L;
    JPanel contentPane;
    JToolBar ToolBar = new JToolBar();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileConnect = new JMenuItem();
    JMenuItem jMenuFileDisconnect = new JMenuItem();
    JMenuItem jMenuFileRegister = new JMenuItem();
    JMenuItem jMenuFileMail = new JMenuItem();
    JMenuItem jMenuFileLastOnline = new JMenuItem();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenuItem jMenuFileConfig = new JMenuItem();
    JMenu jMenuCampaign = new JMenu();
    JMenu jMenuCampaignSubStatus = new JMenu();
    JMenu jMenuCampaignSubTechs = new JMenu();
    JMenu jMenuCampaignSubBays = new JMenu();
    JMenu jMenuCampaignSubTransfer = new JMenu();
    JMenu jMenuCampaignSubAttack = new JMenu();
    JMenu jMenuCampaignSubMerc = new JMenu();
    JMenu jMenuCampaignSubOther = new JMenu();
    JMenu jMenuCampaignPersonnelTechSubMenu = new JMenu("Techs");
    JMenu jMenuCampaignPersonnelPilotsSubMenu = new JMenu("Pilots");
    JMenuItem jMenuCampaignMyStatus = new JMenuItem();
    JMenuItem jMenuCampaignLogin = new JMenuItem();
    JMenuItem jMenuCampaignActivate = new JMenuItem();
    JMenuItem jMenuCampaignDeactivate = new JMenuItem();
    JMenuItem jMenuCampaignLogout = new JMenuItem();
    JMenuItem jMenuCampaignPlayers = new JMenuItem();
    JMenuItem jMenuCampaignISStatus = new JMenuItem();
    JMenuItem jMenuCampaignHouses = new JMenuItem();
    JMenuItem jMenuCampaignFactionStatus = new JMenuItem();
    JMenuItem jMenuCampaignHouseStatus = new JMenuItem();
    JMenuItem jMenuCampaignCheckAttack = new JMenuItem();
    JMenuItem jMenuCampaignRange = new JMenuItem();
    JMenuItem jMenuCampaignTransferUnit = new JMenuItem();
    JMenuItem jMenuCampaignTransferMoney = new JMenuItem();
    JMenuItem jMenuCampaignTransferPilot = new JMenuItem();
    JMenuItem jMenuCampaignLogo = new JMenuItem();
    JMenuItem jMenuCampaignPersonalPilotQueue = new JMenuItem();
    JMenuItem jMenuCampaignDonatePersonalPilot = new JMenuItem();
    JMenuItem jMenuCampaignDirectSell = new JMenuItem();
    JMenuItem jMenuCampaignDefect = new JMenuItem();
    JMenuItem jMenuCampaignRewardPoints = new JMenuItem();
    JMenuItem jMenuCampaignPartsCache = new JMenuItem();
    JMenuItem jMenuSubCampaignFireTechs = new JMenuItem();
    JMenuItem jMenuSubCampaignHireTechs = new JMenuItem();
    JMenuItem jMenuSubCampaignSellBays = new JMenuItem();
    JMenuItem jMenuSubCampaignBuyBays = new JMenuItem();
    JMenuItem jMenuCampaignBuyPilots = new JMenuItem();
    JMenuItem jMenuMercStatus = new JMenuItem();
    JMenuItem jMenuMercUnemployed = new JMenuItem();
    JMenuItem jMenuMercContracted = new JMenuItem();
    JMenuItem jMenuMercOfferContract = new JMenuItem();
    AttackMenu jMenuAttackMenu;
    JMenu jMenuHost = new JMenu();
    JMenuItem jMenuCSHostAndJoin = new JMenuItem();
    JMenuItem jMenuCSHostDedicated = new JMenuItem();
    JMenuItem jMenuCSHostLoad = new JMenuItem();
    JMenuItem jMenuCSHostLoadAndJoin = new JMenuItem();
    JMenuItem jMenuCSHostStop = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JCheckBoxMenuItem jMenuOptionsAutoScroll = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jMenuOptionsMute = new JCheckBoxMenuItem();
    JMenuItem jMenuOptionsReloadAllData = new JMenuItem();
    JMenu jMenuLeaderShip = new JMenu();
    JMenuItem jMenuLeaderPromote = new JMenuItem();
    JMenuItem jMenuLeaderDemote = new JMenuItem();
    JMenuItem jMenuLeaderFluff = new JMenuItem();
    JMenuItem jMenuLeaderMute = new JMenuItem();
    JMenuItem jMenuLeaderFactionColor = new JMenuItem();
    JMenuItem jMenuLeaderPlayerColor = new JMenuItem();
    JMenuItem jMenuLeaderPurchaseFactory = new JMenuItem();
    JMenuItem jMenuLeaderResearchTech = new JMenuItem();
    JMenuItem jMenuLeaderResearchUnit = new JMenuItem();
    JMenuItem jMenuLeaderSetComponentConversion = new JMenuItem();
    JMenuItem jMenuLeaderViewFactionPartsCache = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JMenuItem jMenuHelpMemory = new JMenuItem();
    JMenuItem jMenuHelpHelp = new JMenuItem();
    JMenuItem jMenuHelpViewUnit = new JMenuItem();
    JMenuItem jMenuHelpViewBuildTables = new JMenuItem();
    JMenuItem jMenuHelpViewTraits = new JMenuItem();
    JMenuItem jMenuHelpPilotSkills = new JMenuItem();
    JMenu jMenuMod = new JMenu();
    JMenu jMenuAdmin = new JMenu();
    JMenu jMenuOperations = new JMenu();
    public MWClient mwclient;
    private int userLevel = 0;
    CMainPanel MainPanel;
    CCampaign theCampaign;
    CPlayer thePlayer;
    private boolean hasAdminMenus = false;
    boolean useAdvanceRepairs = false;
    boolean usePersonalPilotQueues = false;
    private menuSound sound;
    private menuPopupSound popupSound;

    public CMainFrame(MWClient myC) {
        this.mwclient = myC;
        this.theCampaign = this.mwclient.getCampaign();
        this.thePlayer = this.mwclient.getPlayer();
        this.MainPanel = new CMainPanel(this.mwclient, this);
        this.useAdvanceRepairs = this.mwclient.isUsingAdvanceRepairs();
        this.usePersonalPilotQueues = Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowPersonalPilotQueues"));
        this.sound = new menuSound(this.mwclient);
        this.popupSound = new menuPopupSound(this.mwclient);
        this.jMenuAttackMenu = new AttackMenu(this.mwclient, -1, "-1");
        this.enableEvents(64L);
        this.setResizable(true);
        this.setSize(new Dimension(640, 480));
        this.setExtendedState(6);
        this.setTitle(this.mwclient.getConfigParam("CAMPAIGNSERVERNAME") + " (MekWars Client " + "0.2.40.0" + ")");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.useAdvanceRepairs = this.mwclient.isUsingAdvanceRepairs();
        this.usePersonalPilotQueues = Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowPersonalPilotQueues"));
        try {
            this.createMenu();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
        this.setJMenuBar(this.jMenuBar1);
        this.enableMenu();
        this.repaint();
        this.contentPane.add((Component)this.MainPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (CMainFrame.this.mwclient.isServerRunning()) {
                    int result = JOptionPane.showConfirmDialog(CMainFrame.this.mwclient.getMainFrame(), "Are you sure you want to exit?", "You are hosting a game!", 0);
                    if (result == 0) {
                        CMainFrame.this.mwclient.goodbye();
                        System.exit(0);
                    }
                } else {
                    CMainFrame.this.mwclient.goodbye();
                    System.exit(0);
                }
            }
        });
    }

    public CMainPanel getMainPanel() {
        return this.MainPanel;
    }

    public void enableMenu() {
        boolean disconnected = false;
        boolean loggedout = false;
        boolean loggedin = false;
        boolean reserve = false;
        boolean active = false;
        boolean admin = false;
        boolean mod = false;
        this.userLevel = this.mwclient.getUserLevel();
        this.mwclient.loadServerCommmands();
        if (this.mwclient.getMyStatus() == 0) {
            disconnected = true;
        }
        if (this.mwclient.getMyStatus() == 1) {
            loggedout = true;
        }
        if (this.mwclient.getMyStatus() == 2) {
            loggedin = true;
            reserve = true;
        }
        if (this.mwclient.getMyStatus() == 3) {
            loggedin = true;
            active = true;
        }
        if (this.mwclient.getMyStatus() == 4) {
            loggedin = true;
        }
        if (this.mwclient.isAdmin()) {
            admin = true;
        }
        if (this.mwclient.isMod()) {
            mod = true;
        }
        if ((mod || admin) && !this.hasAdminMenus) {
            File loadJar = new File("./MekWarsAdmin.jar");
            if (!loadJar.exists()) {
                CampaignData.mwlog.errLog("Player/Server menu creation skipped. No MekWarsAdmin.jar present.");
            } else {
                Object o;
                Class<?> c;
                URLClassLoader loader;
                try {
                    loader = new URLClassLoader(new URL[]{loadJar.toURI().toURL()});
                    c = loader.loadClass("admin.ModeratorMenu");
                    o = c.newInstance();
                    c.getDeclaredMethod("createMenu", MWClient.class).invoke(o, this.mwclient);
                    this.jMenuBar1.remove(this.jMenuMod);
                    this.jMenuMod = (JMenu)o;
                    this.jMenuBar1.add(this.jMenuMod);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("ModeratorMenu creation FAILED!");
                    CampaignData.mwlog.errLog(ex);
                }
                try {
                    loader = new URLClassLoader(new URL[]{loadJar.toURI().toURL()});
                    c = loader.loadClass("admin.AdminMenu");
                    o = c.newInstance();
                    c.getDeclaredMethod("createMenu", MWClient.class).invoke(o, this.mwclient);
                    this.jMenuBar1.remove(this.jMenuAdmin);
                    this.jMenuAdmin = (JMenu)o;
                    this.jMenuBar1.add(this.jMenuAdmin);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("AdminMenu creation FAILED!");
                    CampaignData.mwlog.errLog(ex);
                }
            }
            if (new File("./MekWarsOpEditor.jar").exists()) {
                this.jMenuBar1.remove(this.jMenuOperations);
                this.jMenuOperations.setText("Operations");
                JMenuItem item = new JMenuItem("Op Editor");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            URLClassLoader loader = new URLClassLoader(new URL[]{new File("./MekWarsOpEditor.jar").toURI().toURL()});
                            Class<?> c = loader.loadClass("OperationsEditor.MainOperations");
                            Object o = c.newInstance();
                            c.getDeclaredMethod("main", Object.class).invoke(o, CMainFrame.this.mwclient);
                        }
                        catch (Exception ex) {
                            CampaignData.mwlog.errLog(ex);
                        }
                    }
                });
                this.jMenuOperations.add(item);
                JMenuItem jMenuRetrieveOperationFile = new JMenuItem();
                JMenuItem jMenuSetOperationFile = new JMenuItem();
                JMenuItem jMenuSetNewOperationFile = new JMenuItem();
                JMenuItem jMenuSendAllOperationFiles = new JMenuItem();
                JMenuItem jMenuUpdateOperations = new JMenuItem();
                jMenuRetrieveOperationFile.setText("Retrieve Operation File");
                jMenuRetrieveOperationFile.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMainFrame.this.jMenuRetrieveOperationFile_actionPerformed(e);
                    }
                });
                jMenuSetOperationFile.setText("Set Operation File");
                jMenuSetOperationFile.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMainFrame.this.jMenuSetOperationFile_actionPerformed(e);
                    }
                });
                jMenuSetNewOperationFile.setText("Set New Operation File");
                jMenuSetNewOperationFile.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMainFrame.this.jMenuSetNewOperationFile_actionPerformed(e);
                    }
                });
                jMenuSendAllOperationFiles.setText("Send All Local Op Files");
                jMenuSendAllOperationFiles.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMainFrame.this.jMenuSendAllOperationFiles_actionPerformed(e);
                    }
                });
                jMenuUpdateOperations.setText("Update Operations");
                jMenuUpdateOperations.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CMainFrame.this.jMenuUpdateOperations_actionPerformed(e);
                    }
                });
                int userLevel = this.mwclient.getUserLevel();
                if (userLevel >= this.mwclient.getData().getAccessLevel("RetrieveOperation")) {
                    this.jMenuOperations.add(jMenuRetrieveOperationFile);
                }
                if (userLevel >= this.mwclient.getData().getAccessLevel("SetOperation")) {
                    this.jMenuOperations.add(jMenuSetOperationFile);
                    this.jMenuOperations.add(jMenuSetNewOperationFile);
                    this.jMenuOperations.add(jMenuSendAllOperationFiles);
                }
                if (userLevel >= this.mwclient.getData().getAccessLevel("UpdateOperations")) {
                    this.jMenuOperations.add(jMenuUpdateOperations);
                }
                this.jMenuBar1.add(this.jMenuOperations);
            }
            this.hasAdminMenus = true;
        }
        this.jMenuAdmin.setVisible(admin);
        this.jMenuMod.setVisible(mod);
        this.jMenuOperations.setVisible(mod);
        this.jMenuCampaign.setVisible(!disconnected);
        this.jMenuCampaignMyStatus.setVisible(loggedin);
        this.jMenuCampaignSubAttack.setVisible(loggedin);
        this.jMenuCampaignSubMerc.setVisible(loggedin);
        this.jMenuCampaignSubTransfer.setVisible(loggedin);
        this.jMenuCampaignSubStatus.setVisible(loggedin);
        this.jMenuCampaignSubTechs.setVisible(loggedin);
        this.jMenuCampaignSubBays.setVisible(this.useAdvanceRepairs && loggedin);
        this.jMenuCampaignSubOther.setVisible(loggedin);
        this.jMenuHost.setVisible(!disconnected);
        this.jMenuLeaderShip.setVisible(this.mwclient.isLeader());
        this.jMenuLeaderDemote.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("DemotePlayer"));
        this.jMenuLeaderFluff.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("FactionLeaderFluff"));
        this.jMenuLeaderMute.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("FactionLeaderMute"));
        this.jMenuLeaderPromote.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("PromotePlayer"));
        this.jMenuLeaderFactionColor.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("ChangeHouseColor"));
        this.jMenuLeaderPlayerColor.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHousePlayerColor"));
        this.jMenuLeaderPurchaseFactory.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("PurchaseFactory"));
        this.jMenuLeaderResearchTech.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("ResearchTechLevel"));
        this.jMenuLeaderResearchUnit.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("ResearchUnit"));
        this.jMenuLeaderSetComponentConversion.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("SetComponentConversion"));
        this.jMenuLeaderViewFactionPartsCache.setVisible(this.userLevel >= this.mwclient.getData().getAccessLevel("ViewFactionPartsCache"));
        this.jMenuFileConnect.setVisible(disconnected);
        this.jMenuFileDisconnect.setVisible(!disconnected);
        this.jMenuFileRegister.setVisible(!disconnected);
        this.jMenuFileMail.setVisible(!disconnected);
        this.jMenuFileLastOnline.setVisible(!disconnected);
        this.jMenuFileConfig.setVisible(true);
        this.jMenuCampaignLogin.setVisible(loggedout);
        this.jMenuCampaignActivate.setVisible(reserve);
        this.jMenuCampaignDeactivate.setVisible(active);
        this.jMenuCampaignLogout.setVisible(loggedin);
        this.jMenuCampaignPersonalPilotQueue.setVisible(this.usePersonalPilotQueues);
        this.jMenuCampaignTransferPilot.setVisible(this.usePersonalPilotQueues);
        this.jMenuCampaignDonatePersonalPilot.setVisible(this.usePersonalPilotQueues);
        this.jMenuCampaignDirectSell.setVisible(Boolean.parseBoolean(this.mwclient.getserverConfigs("UseDirectSell")));
        this.addMenuListener(this.jMenuBar1.getComponents());
        this.repaint();
    }

    protected void createMenu() throws Exception {
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic('F');
        this.jMenuFileConnect.setText("Connect");
        this.jMenuFileConnect.setMnemonic('o');
        this.jMenuFileConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileConnect_actionPerformed();
            }
        });
        this.jMenuFileDisconnect.setText("Disconnect");
        this.jMenuFileDisconnect.setMnemonic('D');
        this.jMenuFileDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.getConnector().closeConnection();
            }
        });
        this.jMenuFileRegister.setText("Register Nickname");
        this.jMenuFileRegister.setMnemonic('R');
        this.jMenuFileRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileRegister_actionPerformed();
            }
        });
        this.jMenuFileMail.setText("Mail User");
        this.jMenuFileMail.setMnemonic('M');
        this.jMenuFileMail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileMail_actionPerformed(null);
            }
        });
        this.jMenuFileLastOnline.setText("Last Online");
        this.jMenuFileLastOnline.setMnemonic('L');
        this.jMenuFileLastOnline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileLastOnline_actionPerformed();
            }
        });
        this.jMenuFileConfig.setText("Configuration");
        this.jMenuFileConfig.setMnemonic('C');
        this.jMenuFileConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ConfigurationDialog(CMainFrame.this.mwclient);
            }
        });
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.setMnemonic('X');
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileExit_actionPerformed();
            }
        });
        this.jMenuCampaign.setText("Campaign");
        this.jMenuCampaign.setMnemonic('C');
        this.jMenuCampaignLogin.setText("Log in!");
        this.jMenuCampaignLogin.setMnemonic('I');
        this.jMenuCampaignLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c login");
            }
        });
        this.jMenuCampaignActivate.setText("Activate");
        this.jMenuCampaignActivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c activate#0.2.40.0");
            }
        });
        this.jMenuCampaignDeactivate.setText("Deactivate");
        this.jMenuCampaignDeactivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c deactivate");
            }
        });
        this.jMenuCampaignLogout.setText("Log Out");
        this.jMenuCampaignLogout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c logout");
            }
        });
        this.jMenuCampaignPlayers.setText("Players Status");
        this.jMenuCampaignPlayers.setMnemonic('P');
        this.jMenuCampaignPlayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c players");
            }
        });
        this.jMenuCampaignISStatus.setText("Planetary Control");
        this.jMenuCampaignISStatus.setMnemonic('C');
        this.jMenuCampaignISStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignISStatus_actionPerformed();
            }
        });
        this.jMenuCampaignFactionStatus.setText("Faction Status");
        this.jMenuCampaignFactionStatus.setMnemonic('F');
        this.jMenuCampaignFactionStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignFactionStatus_actionPerformed();
            }
        });
        this.jMenuCampaignHouses.setText("Factions List");
        this.jMenuCampaignHouses.setMnemonic('L');
        this.jMenuCampaignHouses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c housestatus");
            }
        });
        if (this.useAdvanceRepairs) {
            this.jMenuCampaignSubBays.setText("Bays");
            this.jMenuCampaignSubBays.setMnemonic('B');
        }
        this.jMenuCampaignSubTechs.setText("Personnel");
        this.jMenuCampaignSubTechs.setMnemonic('E');
        this.jMenuCampaignSubTransfer.setText("Transfer");
        this.jMenuCampaignSubTransfer.setMnemonic('T');
        this.jMenuCampaignSubAttack.setText("Front Line");
        this.jMenuCampaignSubAttack.setMnemonic('F');
        this.jMenuCampaignSubStatus.setText("Status");
        this.jMenuCampaignSubStatus.setMnemonic('U');
        this.jMenuCampaignSubOther.setText("Other");
        this.jMenuCampaignSubOther.setMnemonic('O');
        this.jMenuCampaignMyStatus.setText("My Status");
        this.jMenuCampaignMyStatus.setMnemonic('M');
        this.jMenuCampaignMyStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c mystatus");
            }
        });
        this.jMenuCampaignCheckAttack.setText("Attack Options");
        this.jMenuCampaignCheckAttack.setMnemonic('A');
        this.jMenuCampaignCheckAttack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderCheckAttack_actionPerformed(-1);
            }
        });
        this.jMenuCampaignRange.setText("Range Calculator");
        this.jMenuCampaignRange.setMnemonic('R');
        this.jMenuCampaignRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderRange_actionPerformed();
            }
        });
        this.jMenuCampaignTransferUnit.setText("Transfer Unit");
        this.jMenuCampaignTransferUnit.setMnemonic('U');
        this.jMenuCampaignTransferUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderTransferUnit_actionPerformed(null, -1);
            }
        });
        this.jMenuCampaignTransferMoney.setText("Transfer " + this.mwclient.moneyOrFluMessage(true, true, -2));
        this.jMenuCampaignTransferMoney.setMnemonic('C');
        this.jMenuCampaignTransferMoney.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderTransferMoney_actionPerformed(null);
            }
        });
        this.jMenuCampaignLogo.setText("Set Logo");
        this.jMenuCampaignLogo.setMnemonic('L');
        this.jMenuCampaignLogo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderLogo_actionPerformed();
            }
        });
        this.jMenuCampaignPersonalPilotQueue.setText("View Pilot Queue");
        this.jMenuCampaignPersonalPilotQueue.setMnemonic('Q');
        this.jMenuCampaignPersonalPilotQueue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderPersonalPilotQueue_actionPerformed();
            }
        });
        this.jMenuCampaignDonatePersonalPilot.setText("Fire Pilot");
        this.jMenuCampaignDonatePersonalPilot.setMnemonic('o');
        this.jMenuCampaignDonatePersonalPilot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDonatePersonalPilot_actionPerformed();
            }
        });
        this.jMenuCampaignDirectSell.setText("Direct Sell Unit");
        this.jMenuCampaignDirectSell.setMnemonic('S');
        this.jMenuCampaignDirectSell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDirectSell_actionPerformed(null, null);
            }
        });
        this.jMenuCampaignTransferPilot.setText("Transfer Pilot");
        this.jMenuCampaignTransferPilot.setMnemonic('T');
        this.jMenuCampaignTransferPilot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderTransferPilot_actionPerformed(null);
            }
        });
        this.jMenuCampaignDefect.setText("Defect");
        this.jMenuCampaignDefect.setMnemonic('D');
        this.jMenuCampaignDefect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDefect_actionPerformed();
            }
        });
        this.jMenuCampaignRewardPoints.setText("Use Reward Points");
        this.jMenuCampaignRewardPoints.setMnemonic('P');
        this.jMenuCampaignRewardPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.rewardPointsDialog();
            }
        });
        this.jMenuCampaignPartsCache.setText("View Parts");
        this.jMenuCampaignPartsCache.setMnemonic('V');
        this.jMenuCampaignPartsCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignPartsCache_actionPerformed();
            }
        });
        if (this.useAdvanceRepairs) {
            this.jMenuSubCampaignBuyBays.setText("Lease Bays");
            this.jMenuSubCampaignBuyBays.setMnemonic('L');
            this.jMenuSubCampaignBuyBays.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CMainFrame.this.jMenuCommanderBuyBays_actionPerformed();
                }
            });
            this.jMenuSubCampaignSellBays.setText("Return Bays");
            this.jMenuSubCampaignSellBays.setMnemonic('R');
            this.jMenuSubCampaignSellBays.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CMainFrame.this.jMenuCommanderSellBays_actionPerformed();
                }
            });
        }
        if (this.usePersonalPilotQueues) {
            this.jMenuCampaignBuyPilots.setText("Hire Pilots");
            this.jMenuCampaignBuyPilots.setMnemonic('P');
            this.jMenuCampaignBuyPilots.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CMainFrame.this.jMenuCampaignSubOtherBuyPilots_actionPerformed();
                }
            });
        }
        this.jMenuSubCampaignHireTechs.setText("Hire Techs");
        this.jMenuSubCampaignHireTechs.setMnemonic('H');
        this.jMenuSubCampaignHireTechs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderHireTechs_actionPerformed();
            }
        });
        this.jMenuSubCampaignFireTechs.setText("Fire Techs");
        this.jMenuSubCampaignFireTechs.setMnemonic('F');
        this.jMenuSubCampaignFireTechs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderFireTechs_actionPerformed();
            }
        });
        this.jMenuCampaignSubMerc.setText("Mercenaries");
        this.jMenuCampaignSubMerc.setMnemonic('r');
        this.jMenuMercOfferContract.setText("Offer a Mercenary Contract");
        this.jMenuMercOfferContract.setMnemonic('O');
        this.jMenuMercOfferContract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuMercOfferContract_actionPerformed();
            }
        });
        this.jMenuMercStatus.setText("Mercenary Status");
        this.jMenuMercStatus.setMnemonic('M');
        this.jMenuMercStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuMercStatus_actionPerformed();
            }
        });
        this.jMenuMercUnemployed.setText("Unemployed Mercs");
        this.jMenuMercUnemployed.setMnemonic('U');
        this.jMenuMercUnemployed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c unemployedmercs");
            }
        });
        this.jMenuMercContracted.setText("Contracted Mercs");
        this.jMenuMercContracted.setMnemonic('C');
        this.jMenuMercContracted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c housecontracts");
            }
        });
        this.jMenuHost.setText("Host");
        this.jMenuHost.setMnemonic('S');
        this.jMenuCSHostAndJoin.setText("Start Hosting (and Join)");
        this.jMenuCSHostAndJoin.setMnemonic('H');
        this.jMenuCSHostAndJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(false, true, false);
            }
        });
        this.jMenuCSHostDedicated.setText("Start Dedicated Host");
        this.jMenuCSHostDedicated.setMnemonic('D');
        this.jMenuCSHostDedicated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(true, false, false);
            }
        });
        this.jMenuCSHostLoad.setText("Start Dedicated Host (Load Savegame)");
        this.jMenuCSHostLoad.setMnemonic('L');
        this.jMenuCSHostLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(true, false, true);
            }
        });
        this.jMenuCSHostLoadAndJoin.setText("Start Hosting (Load Savegame and Join)");
        this.jMenuCSHostLoadAndJoin.setMnemonic('S');
        this.jMenuCSHostLoadAndJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(false, false, true);
            }
        });
        this.jMenuCSHostStop.setText("Stop Hosting");
        this.jMenuCSHostStop.setMnemonic('S');
        this.jMenuCSHostStop.setEnabled(false);
        this.jMenuCSHostStop.setVisible(false);
        this.jMenuCSHostStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.stopHost();
                CMainFrame.this.mwclient.stopHost();
            }
        });
        this.jMenuOptions.setText("Options");
        this.jMenuOptions.setMnemonic('I');
        this.jMenuOptionsAutoScroll.setText("Auto Scroll");
        this.jMenuOptionsAutoScroll.setMnemonic('A');
        this.jMenuOptionsAutoScroll.setState(this.MainPanel.getCommPanel().autoTextUpdate);
        this.jMenuOptionsAutoScroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean newValue;
                CMainFrame.this.MainPanel.getCommPanel().autoTextUpdate = newValue = !CMainFrame.this.MainPanel.getCommPanel().autoTextUpdate;
                CMainFrame.this.jMenuOptionsAutoScroll.setState(newValue);
                CMainFrame.this.mwclient.getConfig().setParam("AUTOSCROLL", Boolean.toString(newValue));
                CMainFrame.this.mwclient.getConfig().saveConfig();
            }
        });
        this.jMenuOptionsMute.setText("Mute");
        this.jMenuOptionsMute.setMnemonic('M');
        this.jMenuOptionsMute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.setSoundMuted(CMainFrame.this.jMenuOptionsMute.getState());
            }
        });
        this.jMenuOptionsReloadAllData.setText("Reload Data");
        this.jMenuOptionsReloadAllData.setMnemonic('D');
        this.jMenuOptionsReloadAllData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.reloadData();
            }
        });
        this.jMenuLeaderShip.setText("Leadership");
        this.jMenuLeaderPromote.setText("Promote Player");
        this.jMenuLeaderPromote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderPromote_actionPerformed();
            }
        });
        this.jMenuLeaderDemote.setText("Demote Player");
        this.jMenuLeaderDemote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderDemote_actionPerformed();
            }
        });
        this.jMenuLeaderFluff.setText("Fluff Player");
        this.jMenuLeaderFluff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderFluff_actionPerformed();
            }
        });
        this.jMenuLeaderMute.setText("Mute Player");
        this.jMenuLeaderMute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderMute_actionPerformed();
            }
        });
        this.jMenuLeaderFactionColor.setText("Faction Color");
        this.jMenuLeaderFactionColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderFactionColor_actionPerformed();
            }
        });
        this.jMenuLeaderPlayerColor.setText("Player Color");
        this.jMenuLeaderPlayerColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderPlayerColor_actionPerformed();
            }
        });
        this.jMenuLeaderResearchUnit.setText("Research Unit");
        this.jMenuLeaderResearchUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderResearchUnit_actionPerformed();
            }
        });
        this.jMenuLeaderResearchTech.setText("Research Tech");
        this.jMenuLeaderResearchTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog(CMainFrame.this.mwclient.getMainFrame(), "Do you wish to research tech?", "Research?", 0);
                if (option == 1) {
                    return;
                }
                CMainFrame.this.mwclient.sendChat("/c researchtechlevel");
            }
        });
        this.jMenuLeaderPurchaseFactory.setText("Purchase Factory");
        this.jMenuLeaderPurchaseFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderPurchaseFactory_actionPerformed(null);
            }
        });
        this.jMenuLeaderSetComponentConversion.setText("Set Component Conversion");
        this.jMenuLeaderSetComponentConversion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuLeaderSetComponentConversion_actionPerformed();
            }
        });
        this.jMenuLeaderViewFactionPartsCache.setText("View Faction Cache");
        this.jMenuLeaderViewFactionPartsCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat("/c viewfactionpartscache");
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelp.setMnemonic('E');
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.setMnemonic('A');
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpAbout_actionPerformed();
            }
        });
        this.jMenuHelpMemory.setText("Memory");
        this.jMenuHelpMemory.setMnemonic('M');
        this.jMenuHelpMemory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpMemory_actionPerformed();
            }
        });
        this.jMenuHelpHelp.setText("Online Help");
        this.jMenuHelpHelp.setMnemonic('H');
        this.jMenuHelpHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpHelp_actionPerformed();
            }
        });
        this.jMenuHelpViewUnit.setText("Unit Viewer");
        this.jMenuHelpViewUnit.setMnemonic('U');
        this.jMenuHelpViewUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpViewUnit_actionPerformed();
            }
        });
        this.jMenuHelpViewBuildTables.setText("Build Table Viewer");
        this.jMenuHelpViewBuildTables.setMnemonic('B');
        this.jMenuHelpViewBuildTables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpViewBuildTables_actionPerformed();
            }
        });
        this.jMenuHelpViewTraits.setText("View Faction Traits");
        this.jMenuHelpViewTraits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TraitDialog(CMainFrame.this.mwclient, true);
            }
        });
        this.jMenuHelpPilotSkills.setText("Pilot Skill Descriptions");
        this.jMenuHelpPilotSkills.setMnemonic('P');
        this.jMenuHelpPilotSkills.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpPilotSkills_actionPerformed();
            }
        });
        JMenuItem jMenuMekwarsBug = new JMenuItem("Report Bug (MekWars)");
        JMenuItem jMenuMegamekBug = new JMenuItem("Report Bug (MegaMek)");
        JMenuItem jMenuMekwarsRFE = new JMenuItem("RFE (MekWars)");
        JMenuItem jMenuMegamekRFE = new JMenuItem("RFE (MegaMek)");
        ActionListener mekwarsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=122002&atid=692058");
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        };
        ActionListener megamekListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=47079&atid=448394");
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        };
        ActionListener megamekRFEListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=47079&atid=448397");
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        };
        ActionListener mekwarsRFEListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=122002&atid=692061");
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        };
        jMenuMekwarsBug.addActionListener(mekwarsListener);
        jMenuMegamekBug.addActionListener(megamekListener);
        jMenuMegamekRFE.addActionListener(megamekRFEListener);
        jMenuMekwarsRFE.addActionListener(mekwarsRFEListener);
        this.jMenuFile.add(this.jMenuFileConnect);
        this.jMenuFile.add(this.jMenuFileRegister);
        this.jMenuFile.add(this.jMenuFileMail);
        this.jMenuFile.add(this.jMenuFileLastOnline);
        this.jMenuFile.add(this.jMenuFileConfig);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileDisconnect);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuCampaignSubAttack.add(this.jMenuCampaignCheckAttack);
        this.jMenuCampaignSubAttack.add(this.jMenuCampaignRange);
        this.jMenuCampaignSubTransfer.add(this.jMenuCampaignTransferMoney);
        this.jMenuCampaignSubTransfer.add(this.jMenuCampaignTransferUnit);
        this.jMenuCampaignSubTransfer.add(this.jMenuCampaignTransferPilot);
        this.jMenuCampaignPersonnelTechSubMenu.add(this.jMenuSubCampaignHireTechs);
        this.jMenuCampaignPersonnelTechSubMenu.add(this.jMenuSubCampaignFireTechs);
        this.jMenuCampaignSubTechs.add(this.jMenuCampaignPersonnelTechSubMenu);
        if (this.usePersonalPilotQueues) {
            this.jMenuCampaignPersonnelPilotsSubMenu.add(this.jMenuCampaignPersonalPilotQueue);
            this.jMenuCampaignPersonnelPilotsSubMenu.add(this.jMenuCampaignBuyPilots);
            this.jMenuCampaignPersonnelPilotsSubMenu.add(this.jMenuCampaignDonatePersonalPilot);
            this.jMenuCampaignSubTechs.add(this.jMenuCampaignPersonnelPilotsSubMenu);
        }
        this.jMenuCampaignSubBays.add(this.jMenuSubCampaignBuyBays);
        this.jMenuCampaignSubBays.add(this.jMenuSubCampaignSellBays);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignPlayers);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignFactionStatus);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignISStatus);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignHouses);
        this.jMenuCampaignSubMerc.add(this.jMenuMercStatus);
        this.jMenuCampaignSubMerc.add(this.jMenuMercUnemployed);
        this.jMenuCampaignSubMerc.add(this.jMenuMercContracted);
        this.jMenuCampaignSubMerc.add(this.jMenuMercOfferContract);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignLogo);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignDefect);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignRewardPoints);
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UsePartsBlackMarket"))) {
            this.jMenuCampaignSubOther.add(this.jMenuCampaignPartsCache);
        }
        this.jMenuCampaignSubOther.add(this.jMenuCampaignDirectSell);
        this.jMenuCampaign.add(this.jMenuCampaignMyStatus);
        this.jMenuCampaign.add(this.jMenuCampaignSubAttack);
        this.jMenuCampaign.addSeparator();
        this.jMenuCampaign.add(this.jMenuCampaignSubMerc);
        this.jMenuCampaign.add(this.jMenuCampaignSubTransfer);
        this.jMenuCampaign.add(this.jMenuCampaignSubStatus);
        this.jMenuCampaign.add(this.jMenuCampaignSubBays);
        this.jMenuCampaign.add(this.jMenuCampaignSubTechs);
        this.jMenuCampaign.add(this.jMenuCampaignSubOther);
        this.jMenuCampaign.addSeparator();
        this.jMenuCampaign.add(this.jMenuCampaignLogin);
        this.jMenuCampaign.add(this.jMenuCampaignActivate);
        this.jMenuCampaign.add(this.jMenuCampaignDeactivate);
        this.jMenuCampaign.add(this.jMenuCampaignLogout);
        this.jMenuHost.add(this.jMenuCSHostAndJoin);
        this.jMenuHost.add(this.jMenuCSHostLoadAndJoin);
        this.jMenuHost.add(this.jMenuCSHostDedicated);
        this.jMenuHost.add(this.jMenuCSHostLoad);
        this.jMenuHost.add(this.jMenuCSHostStop);
        this.jMenuOptions.add(this.jMenuOptionsAutoScroll);
        this.jMenuOptions.add(this.jMenuOptionsMute);
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(this.jMenuOptionsReloadAllData);
        this.jMenuLeaderShip.add(this.jMenuLeaderFluff);
        this.jMenuLeaderShip.add(this.jMenuLeaderMute);
        this.jMenuLeaderShip.add(this.jMenuLeaderPromote);
        this.jMenuLeaderShip.add(this.jMenuLeaderDemote);
        this.jMenuLeaderShip.add(this.jMenuLeaderFactionColor);
        this.jMenuLeaderShip.add(this.jMenuLeaderPlayerColor);
        this.jMenuLeaderShip.add(this.jMenuLeaderPurchaseFactory);
        this.jMenuLeaderShip.add(this.jMenuLeaderResearchTech);
        this.jMenuLeaderShip.add(this.jMenuLeaderResearchUnit);
        this.jMenuLeaderShip.add(this.jMenuLeaderSetComponentConversion);
        this.jMenuLeaderShip.add(this.jMenuLeaderViewFactionPartsCache);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuHelp.add(this.jMenuHelpMemory);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(this.jMenuHelpViewUnit);
        this.jMenuHelp.add(this.jMenuHelpViewBuildTables);
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTNforMek")) > 0) {
            this.jMenuHelp.add(this.jMenuHelpViewTraits);
        }
        this.jMenuHelp.add(this.jMenuHelpHelp);
        this.jMenuHelp.add(this.jMenuHelpPilotSkills);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(jMenuMekwarsBug);
        this.jMenuHelp.add(jMenuMegamekBug);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(jMenuMekwarsRFE);
        this.jMenuHelp.add(jMenuMegamekRFE);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuCampaign);
        this.jMenuBar1.add(this.jMenuAttackMenu);
        this.jMenuBar1.add(this.jMenuHost);
        this.jMenuBar1.add(this.jMenuOptions);
        this.jMenuBar1.add(this.jMenuLeaderShip);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuBar1.add(this.jMenuOperations);
    }

    public void jMenuFileNick_actionPerformed() {
        String NewNick = JOptionPane.showInputDialog(this.getContentPane(), (Object)"NewNick");
        if (NewNick == null) {
            return;
        }
        String Password = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Message");
        this.mwclient.sendChat("/nick " + NewNick + "," + Password);
    }

    public void jMenuFileConnect_actionPerformed() {
        this.mwclient.connectToServer();
        if (!this.mwclient.getStatus().equals("Not connected")) {
            this.mwclient.sendChat("/c setclientversion#" + this.mwclient.myUsername.trim() + "#" + "0.2.40.0");
        }
    }

    public void jMenuFileRegister_actionPerformed() {
        new RegisterNameDialog(this.mwclient);
    }

    public void jMenuFileMail_actionPerformed(String Nickname) {
        if (Nickname == null && (Nickname = JOptionPane.showInputDialog(this.getContentPane(), "Nickname", "Send mail to whom?", -1)) == null) {
            return;
        }
        String message = JOptionPane.showInputDialog(this.getContentPane(), "message", "Send mail to " + Nickname, -1);
        if (message == null) {
            return;
        }
        this.mwclient.processGUIInput("/mail " + Nickname + "," + message);
    }

    public void jMenuFileLastOnline_actionPerformed() {
        String Nickname = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Player name?");
        if (Nickname == null) {
            return;
        }
        this.mwclient.sendChat("/c lastonline#" + Nickname);
    }

    public void jMenuFileExit_actionPerformed() {
        this.mwclient.goodbye();
        System.exit(0);
    }

    public void jMenuCampaignISStatus_actionPerformed() {
        String House2 = "";
        String House22 = "";
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", true, false);
        factionDialog.setVisible(true);
        House2 = factionDialog.getHouseName();
        factionDialog.dispose();
        if (House2 == null) {
            return;
        }
        if (!House2.equals("")) {
            factionDialog = new HouseNameDialog(this.mwclient, "Secondary Faction", true, false);
            factionDialog.setVisible(true);
            House22 = factionDialog.getHouseName();
            factionDialog.dispose();
            this.mwclient.sendChat("/c isstatus#" + House2 + "#" + House22);
        } else {
            this.mwclient.sendChat("/c isstatus");
        }
    }

    public void jMenuCampaignFactionStatus_actionPerformed() {
        String House2 = "";
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", true, false);
        factionDialog.setVisible(true);
        House2 = factionDialog.getHouseName();
        factionDialog.dispose();
        if (House2 == null) {
            return;
        }
        this.mwclient.sendChat("/c faction#" + House2);
    }

    public void jMenuMercStatus_actionPerformed() {
        PlayerNameDialog playerDialog = new PlayerNameDialog(this.mwclient, "Which Merc do you want info on?", 2);
        playerDialog.setVisible(true);
        String Merc = playerDialog.getPlayerName();
        playerDialog.dispose();
        if (Merc == null) {
            return;
        }
        this.mwclient.sendChat("/c mstatus#" + Merc);
    }

    public void jMenuCommanderCheckAttack_actionPerformed(int lid) {
        if (lid == -1) {
            this.mwclient.sendChat("/c ca");
        } else {
            this.mwclient.sendChat("/c ca#" + lid);
        }
    }

    public void jMenuCommanderRange_actionPerformed() {
        String range = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Max distance in Lightyears?");
        if (range == null || range.length() < 1) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String faction = factionDialog.getHouseName();
        factionDialog.dispose();
        if (faction == null || faction.length() < 1) {
            return;
        }
        this.mwclient.sendChat("/c range#" + range + "#" + faction);
    }

    public void jMenuCommanderTransferMoney_actionPerformed(String name) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", 1);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        String Amount = JOptionPane.showInputDialog(this.getContentPane(), "Amount", "Send " + this.mwclient.moneyOrFluMessage(true, true, -2) + " to " + targetPlayer, -1);
        if (Amount == null) {
            return;
        }
        this.mwclient.sendChat("/c transfermoney#" + targetPlayer + "#" + Amount);
    }

    public void jMenuCommanderTransferUnit_actionPerformed(String name, int mid) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", 1);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        if (mid == -1) {
            UnitSelectionDialog usd = new UnitSelectionDialog(this.mwclient, "Transfer Unit", "Select unit to transfer:");
            usd.setVisible(true);
            mid = Integer.parseInt(usd.getUnitID());
            usd.dispose();
        }
        if (mid == -1) {
            return;
        }
        this.mwclient.sendChat("/c transferunit#" + targetPlayer + "#" + mid);
    }

    public void jMenuCommanderAddToBM_actionPerformed(int mid) {
        Vector<CUnit> toSell = new Vector<CUnit>(1, 1);
        toSell.add(this.mwclient.getPlayer().getUnit(mid));
        SellUnitDialog sud = new SellUnitDialog(this, this.mwclient, toSell);
        sud.setVisible(true);
    }

    public void jMenuCommanderRemoveLance_actionPerformed(int lid) {
        if (lid == -1) {
            String LanceID = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army ID?");
            if (LanceID == null) {
                return;
            }
            lid = Integer.parseInt(LanceID);
        }
        this.mwclient.sendChat("/c rma#" + lid);
    }

    public void jMenuCommanderNamePilot_actionPerformed(int uid) {
        String newName = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Pilot's Name?");
        if (newName == null) {
            return;
        }
        this.mwclient.sendChat("/c namepilot#" + uid + "#" + newName);
    }

    public void jMenuCommanderNameArmy_actionPerformed(int aid) {
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(aid);
        if (selectedArmy == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(this.getContentPane(), "New army name? [Leave blank to clear]", selectedArmy.getName());
        if (newName == null) {
            return;
        }
        if (newName.trim().length() == 0) {
            newName = "clear";
        }
        this.mwclient.sendChat("/c namearmy#" + aid + "#" + newName);
    }

    public void jMenuCommanderPlayerLockArmy_actionPerformed(int aid) {
        this.mwclient.sendChat("/c playerlockarmy#" + aid);
    }

    public void jMenuCommanderPlayerUnlockArmy_actionPerformed(int aid) {
        this.mwclient.sendChat("/c playerunlockarmy#" + aid);
    }

    public void jMenuCommanderDisableArmy_actionPerformed(int aid) {
        this.mwclient.sendChat("/c togglearmydisabled#" + aid);
    }

    public void jMenuCommanderSetLowerUnitLimit_actionPerformed(int aid) {
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(aid);
        if (selectedArmy == null) {
            return;
        }
        int newLimit = -1;
        String example = "Example: An Army of 8 units with a Lower Limit of<br>4 will not be able to fight an Army with only 3 units.<br>This can be useful if you want to avoid fighting a<br>small number of super heavy/levelled units.";
        String limit = JOptionPane.showInputDialog(this.getContentPane(), "<HTML>Lower Limit? [-1 to disable the limit]<i><br><br>" + example + "<br></i></HTML>", Integer.toString(selectedArmy.getLowerLimiter()), -1);
        if (limit == null) {
            return;
        }
        newLimit = Integer.parseInt(limit);
        this.mwclient.sendChat("/c all#" + aid + "#" + newLimit);
    }

    public void jMenuCommanderSetUpperUnitLimit_actionPerformed(int aid) {
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(aid);
        if (selectedArmy == null) {
            return;
        }
        int newLimit = -1;
        String example = "Example: An Army of 4 units with an Upper Limit of 5<br>will not be able to fight againt Armies with more than<br>9 units. This can be useful if you don't want to play<br>againts swarms";
        String limit = JOptionPane.showInputDialog(this.getContentPane(), "<HTML>Upper Limit? [-1 to disable the limit]<i><br><br>" + example + "<br></i></HTML>", Integer.toString(selectedArmy.getLowerLimiter()).toString(), -1);
        if (limit == null) {
            return;
        }
        newLimit = Integer.parseInt(limit);
        this.mwclient.sendChat("/c aul#" + aid + "#" + newLimit);
    }

    public void jMenuCommanderSetForceSizeToFace_actionPerformed(int aid) {
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(aid);
        if (selectedArmy == null) {
            return;
        }
        String example = "This is the force size you expect to face when you request a match";
        String force = JOptionPane.showInputDialog(this.getContentPane(), "<HTML>Force Size To Face\t? [-1 to disable the limit]<i><br><br>" + example + "<br></i></HTML>", Float.toString(selectedArmy.getOpForceSize()), -1);
        if (force == null) {
            return;
        }
        this.mwclient.sendChat("/c aofs#" + aid + "#" + force);
    }

    public void jMenuCommanderLogo_actionPerformed() {
        String LogoURL = JOptionPane.showInputDialog(this.getContentPane(), "URL? (i.e. http://www.mysite.com/mypic.jpg)", this.mwclient.getPlayer().getMyLogo());
        if (LogoURL == null) {
            return;
        }
        this.mwclient.sendChat("/c setmylogo#" + LogoURL);
    }

    public void jMenuCommanderPersonalPilotQueue_actionPerformed() {
        this.mwclient.sendChat("/c displayplayerpersonalpilotqueue");
    }

    public void jMenuCommanderTransferPilot_actionPerformed(String name) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", 1);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        Object[] pWeightClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        Object[] pUnitType = new Object[]{"Mek", "Proto"};
        int weightClass = 0;
        int unitType = 0;
        String pUnitTypeString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a pilot unit type", "Unit Type Selection", 1, null, pUnitType, pUnitType[0]);
        if (pUnitTypeString == null || pUnitTypeString.length() == 0) {
            return;
        }
        unitType = pUnitTypeString.equals("Mek") ? 0 : 3;
        String pWeightClassString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a pilot unit size", "Weight Class Selection", 1, null, pWeightClass, pWeightClass[0]);
        if (pWeightClassString == null || pWeightClassString.length() == 0) {
            return;
        }
        weightClass = Unit.getWeightIDForName(pWeightClassString);
        if (this.mwclient.getPlayer().getPersonalPilotQueue().getPilotQueue(unitType, weightClass).size() < 1) {
            JOptionPane.showMessageDialog(null, "You do not have any pilots for " + StringUtils.aOrAn(pWeightClassString, true) + " " + pUnitTypeString, "No Pilots!", -1);
            return;
        }
        Object[] pilots = this.mwclient.getPlayer().getPersonalPilotQueue().getPilotQueue(unitType, weightClass).toArray();
        JComboBox<String> combo = new JComboBox<String>();
        for (int i = 0; i < pilots.length; ++i) {
            Pilot mm = (Pilot)pilots[i];
            if (unitType == 0) {
                combo.addItem(mm.getName() + " (" + mm.getGunnery() + "/" + mm.getPiloting() + ")[" + mm.getSkillString(true) + "]");
                continue;
            }
            combo.addItem(mm.getName() + " (" + mm.getGunnery() + ")[" + mm.getSkillString(true) + "]");
        }
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select a pilot.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int position = combo.getSelectedIndex();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        this.mwclient.sendChat("/c transferpilot#" + targetPlayer + "#" + unitType + "#" + weightClass + "#" + position);
    }

    public void jMenuCommanderDonatePersonalPilot_actionPerformed() {
        boolean allowProto = Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"));
        Object[] pWeightClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        Object[] pUnitType = allowProto ? new Object[]{"Mek", "Proto"} : new Object[]{"Mek"};
        int weightClass = 0;
        int unitType = 0;
        String pUnitTypeString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a pilot unit type", "Unit Type Selection", 1, null, pUnitType, pUnitType[0]);
        if (pUnitTypeString == null || pUnitTypeString.length() == 0) {
            return;
        }
        unitType = pUnitTypeString.equals("Mek") ? 0 : 3;
        String pWeightClassString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a pilot unit size", "Weight Class Selection", 1, null, pWeightClass, pWeightClass[0]);
        if (pWeightClassString == null || pWeightClassString.length() == 0) {
            return;
        }
        weightClass = Unit.getWeightIDForName(pWeightClassString);
        if (this.mwclient.getPlayer().getPersonalPilotQueue().getPilotQueue(unitType, weightClass).size() < 1) {
            JOptionPane.showMessageDialog(null, "You do not have any pilots for " + StringUtils.aOrAn(pWeightClassString, true) + " " + pUnitTypeString + ".", "No Pilots!", -1);
            return;
        }
        Object[] pilots = this.mwclient.getPlayer().getPersonalPilotQueue().getPilotQueue(unitType, weightClass).toArray();
        JComboBox<String> combo = new JComboBox<String>();
        for (int i = 0; i < pilots.length; ++i) {
            Pilot mm = (Pilot)pilots[i];
            if (unitType == 0) {
                combo.addItem(mm.getName() + " (" + mm.getGunnery() + "/" + mm.getPiloting() + ")[" + mm.getSkillString(true) + "]");
                continue;
            }
            combo.addItem(mm.getName() + " (" + mm.getGunnery() + ")[" + mm.getSkillString(true) + "]");
        }
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select a pilot.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int position = combo.getSelectedIndex();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        this.mwclient.sendChat("/c donatepilot#" + unitType + "#" + weightClass + "#" + position);
    }

    public void jMenuCommanderDirectSell_actionPerformed(String name, String id) {
        String unitID;
        String buyer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Buyer", 0);
            pnd.setVisible(true);
            buyer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            buyer = name;
        }
        if (buyer == null) {
            return;
        }
        if (id == null || id.trim().equals("")) {
            UnitSelectionDialog usd = new UnitSelectionDialog(this.mwclient, "Unit", "Select a unit to sell");
            usd.setVisible(true);
            unitID = usd.getUnitID();
            usd.dispose();
        } else {
            unitID = id;
        }
        CUnit unit = this.mwclient.getPlayer().getUnit(Integer.parseInt(unitID));
        String serviceFee = "SellDirect" + Unit.getWeightClassDesc(unit.getWeightclass()) + Unit.getTypeClassDesc(unit.getType()) + "Price";
        String price = JOptionPane.showInputDialog(this.getContentPane(), (Object)("How much do you wish to offer? (" + this.mwclient.moneyOrFluMessage(true, true, -2) + ")\n\r" + "Please note a service charge of " + this.mwclient.moneyOrFluMessage(true, true, Integer.parseInt(this.mwclient.getserverConfigs(serviceFee))) + " will be added."));
        if (price == null || price.length() < 1) {
            return;
        }
        this.mwclient.sendChat("/c directsellunit#" + buyer + "#" + this.mwclient.getPlayer().getName() + "#" + unitID + "#" + price);
    }

    public void jMenuMercOfferContract_actionPerformed() {
        PlayerNameDialog playerDialog = new PlayerNameDialog(this.mwclient, "Which Merc do you want to offer a contract?", 2);
        playerDialog.setVisible(true);
        String Merc = playerDialog.getPlayerName();
        playerDialog.dispose();
        if (Merc == null) {
            return;
        }
        String Amount = JOptionPane.showInputDialog(this.getContentPane(), (Object)("How much do you wish to offer? (" + this.mwclient.moneyOrFluMessage(true, true, -2) + ")"));
        if (Amount == null) {
            return;
        }
        Vector<String> techTypes = new Vector<String>(5, 1);
        techTypes.add("Exp");
        techTypes.add("Land");
        techTypes.add("Units");
        techTypes.add("Components");
        techTypes.add("Delay");
        JComboBox combo = new JComboBox(techTypes);
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this, "Select contract type.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String Type2 = (String)combo.getSelectedItem();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        String Duration2 = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Duration of the contract?");
        if (Duration2 == null) {
            return;
        }
        this.mwclient.sendChat("/c offercontract#" + Merc + "#" + Amount + "#" + Duration2 + "#" + Type2);
    }

    public void jMenuCommanderDefect_actionPerformed() {
        String House2 = "";
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowSinglePlayerFactions"))) {
            House2 = JOptionPane.showInputDialog(this.getContentPane(), "Name of your new Faction?", "New Faction Name?", 3);
            if (House2 == null) {
                return;
            }
            String shortName = JOptionPane.showInputDialog(this.getContentPane(), House2 + "'s short name?", "Short Name?", 3);
            if (shortName == null) {
                return;
            }
            this.mwclient.sendChat("/c defect#" + House2 + "#newfaction#" + shortName);
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Defect to faction:", false, true);
        factionDialog.setVisible(true);
        House2 = factionDialog.getHouseName();
        factionDialog.dispose();
        if (House2 == null) {
            return;
        }
        this.mwclient.sendChat("/c defect#" + House2);
    }

    public void jMenuCommanderFireTechs_actionPerformed() {
        String techsToFire = JOptionPane.showInputDialog(this.getContentPane(), (Object)"How many techs do you want to fire?");
        if (techsToFire == null || techsToFire.trim().length() == 0) {
            return;
        }
        int techs = Integer.parseInt(techsToFire);
        if (!this.useAdvanceRepairs && this.thePlayer.getTechs() <= 0) {
            this.mwclient.addToChat("<b>You have no hired techs to fire.<b>");
            return;
        }
        if (!(this.useAdvanceRepairs || techs >= 1 && techs <= this.thePlayer.getTechs())) {
            this.mwclient.addToChat("<b>Try picking a number between 1 and " + this.thePlayer.getTechs() + "<b>");
            return;
        }
        if (this.useAdvanceRepairs) {
            Vector<String> techTypes = new Vector<String>(4, 1);
            techTypes.add("Green");
            techTypes.add("Regular");
            techTypes.add("Vet");
            techTypes.add("Elite");
            JComboBox combo = new JComboBox(techTypes);
            combo.setEditable(true);
            JOptionPane jop = new JOptionPane(combo, 3, 2);
            JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select tech to fire.");
            combo.grabFocus();
            combo.getEditor().selectAll();
            dlg.setVisible(true);
            int techType = combo.getSelectedIndex();
            if (techType < 0) {
                return;
            }
            int value = (Integer)jop.getValue();
            if (value == 2) {
                return;
            }
            this.mwclient.sendChat("/c firetechs#" + techs + "#" + techType);
        } else {
            this.mwclient.sendChat("/c firetechs#" + techs);
        }
    }

    public void jMenuCommanderHireTechs_actionPerformed() {
        boolean allowRegTechs = Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowRegTechsToBeHired"));
        String techsToHire = "";
        techsToHire = this.useAdvanceRepairs && !allowRegTechs ? JOptionPane.showInputDialog(this.getContentPane(), (Object)("How many green techs do you want to hire?(" + Integer.parseInt(this.mwclient.getserverConfigs("GreenTechHireCost")) + this.mwclient.moneyOrFluMessage(true, true, -2) + ")")) : JOptionPane.showInputDialog(this.getContentPane(), (Object)"How many techs do you want to hire?");
        if (techsToHire == null || techsToHire.length() == 0) {
            return;
        }
        int techs = Integer.parseInt(techsToHire);
        if (techs < 1) {
            this.mwclient.addToChat("Try picking a number greater then 0");
            return;
        }
        if (this.useAdvanceRepairs && allowRegTechs) {
            Vector<String> techTypes = new Vector<String>(2, 1);
            techTypes.add("Green " + Integer.parseInt(this.mwclient.getserverConfigs("GreenTechHireCost")) + this.mwclient.moneyOrFluMessage(true, true, -2));
            techTypes.add("Regular " + Integer.parseInt(this.mwclient.getserverConfigs("RegTechHireCost")) + this.mwclient.moneyOrFluMessage(true, true, -2));
            JComboBox combo = new JComboBox(techTypes);
            combo.setEditable(false);
            JOptionPane jop = new JOptionPane(combo, 3, 2);
            JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select tech to hire.");
            combo.grabFocus();
            combo.getEditor().selectAll();
            dlg.setVisible(true);
            int techType = combo.getSelectedIndex();
            if (techType < 0) {
                return;
            }
            int value = (Integer)jop.getValue();
            if (value == 2) {
                return;
            }
            this.mwclient.sendChat("/c hiretechs#" + techs + "#" + techType);
        } else {
            this.mwclient.sendChat("/c hiretechs#" + techs);
        }
    }

    public void jMenuCampaignSubOtherBuyPilots_actionPerformed() {
        boolean allowProto = Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"));
        boolean allowAero = Boolean.parseBoolean(this.mwclient.getserverConfigs("UseAero"));
        int unitType = 0;
        int unitClass = 0;
        Object[] pWeightClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        Object[] pUnitType = allowProto && allowAero ? new Object[]{"Mek", "Proto", "Aero"} : (allowProto ? new Object[]{"Mek", "Proto"} : (allowAero ? new Object[]{"Mek", "Aero"} : new Object[]{"Mek"}));
        String pUnitTypeString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select unit type", "Unit Type Selection", 1, null, pUnitType, pUnitType[0]);
        if (pUnitTypeString == null || pUnitTypeString.length() == 0) {
            return;
        }
        unitType = CUnit.getTypeIDForName(pUnitTypeString);
        String pWeightClassString = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select unit size", "Weight Class Selection", 1, null, pWeightClass, pWeightClass[0]);
        if (pWeightClassString == null || pWeightClassString.length() == 0) {
            return;
        }
        unitClass = Unit.getWeightIDForName(pWeightClassString);
        String numberOfPilots = JOptionPane.showInputDialog(this.getContentPane(), "How many pilots do you want to hire?", 1);
        if (numberOfPilots == null || numberOfPilots.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c buypilotsfromhouse#" + unitType + "#" + unitClass + "#" + numberOfPilots);
    }

    public void jMenuCommanderSellBays_actionPerformed() {
        String baysToFire = JOptionPane.showInputDialog(this.getContentPane(), (Object)"How many bays do you want to return??");
        if (baysToFire == null || baysToFire.length() == 0) {
            return;
        }
        int bays = Integer.parseInt(baysToFire);
        if (this.thePlayer.getFreeBays() <= 0) {
            this.mwclient.addToChat("<b>You have no free bays to return.<b>");
            return;
        }
        if (bays < 1 || bays > this.thePlayer.getFreeBays()) {
            this.mwclient.addToChat("<b>Try picking a number between 1 and " + this.thePlayer.getFreeBays() + "<b>");
            return;
        }
        this.mwclient.sendChat("/c sellbays#" + bays);
    }

    public void jMenuCampaignPartsCache_actionPerformed() {
        CPlayer p = this.mwclient.getPlayer();
        StringBuilder result = new StringBuilder();
        result.append(p.getPartsCache().tableizeComponents());
        this.mwclient.doParseDataInput("SM|" + result.toString());
    }

    public void jMenuCommanderBuyBays_actionPerformed() {
        String baysToHire = JOptionPane.showInputDialog(this.getContentPane(), (Object)("How many bays do you want to lease?(" + Integer.parseInt(this.mwclient.getserverConfigs("CostToBuyNewBay")) + this.mwclient.moneyOrFluMessage(true, true, -2) + ")"));
        if (baysToHire == null || baysToHire.length() == 0) {
            return;
        }
        int bays = Integer.parseInt(baysToHire);
        if (bays < 1) {
            this.mwclient.addToChat("Try picking a number greater then 0");
            return;
        }
        this.mwclient.sendChat("/c buybays#" + bays);
    }

    public void jMenuHelpViewBuildTables_actionPerformed() {
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminRequestBuildTable") || this.userLevel >= this.mwclient.getData().getAccessLevel("RequestBuildTable")) {
            new TableViewerDialog(this.mwclient);
        } else {
            this.mwclient.sendChat("/c buildtablelist");
        }
    }

    public void jMenuHelpViewUnit_actionPerformed() {
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.mwclient.getMainFrame());
        UnitViewerDialog unitSelector = new UnitViewerDialog(this.mwclient.getMainFrame(), unitLoadingDialog, this.mwclient, 0);
        new Thread(unitSelector).start();
    }

    public void jMenuLeaderPromote_actionPerformed() {
        int menuType = this.mwclient.isMod() ? 0 : 1;
        PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Promote", menuType);
        pnd.setVisible(true);
        String targetPlayer = pnd.getPlayerName();
        pnd.dispose();
        if (targetPlayer == null) {
            return;
        }
        SubFactionNameDialog subFactionDialog = new SubFactionNameDialog(this.mwclient, "SubFaction", this.mwclient.getUser(targetPlayer).getHouse());
        subFactionDialog.setVisible(true);
        String subFactionName = subFactionDialog.getSubFactionName();
        subFactionDialog.dispose();
        if (subFactionName == null || subFactionName.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c promoteplayer#" + targetPlayer + "#" + subFactionName);
    }

    public void jMenuLeaderDemote_actionPerformed() {
        int menuType = this.mwclient.isMod() ? 0 : 1;
        PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Demote Player", menuType);
        pnd.setVisible(true);
        String targetPlayer = pnd.getPlayerName();
        pnd.dispose();
        if (targetPlayer == null) {
            return;
        }
        SubFactionNameDialog subFactionDialog = new SubFactionNameDialog(this.mwclient, "Use None to remove completely", this.mwclient.getUser(targetPlayer).getHouse());
        subFactionDialog.setVisible(true);
        String subFactionName = subFactionDialog.getSubFactionName();
        subFactionDialog.dispose();
        if (subFactionName == null || subFactionName.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c demoteplayer#" + targetPlayer + "#" + subFactionName);
    }

    public void jMenuLeaderFluff_actionPerformed() {
        int menuType = 1;
        PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Fluff Player", menuType);
        pnd.setVisible(true);
        String targetPlayer = pnd.getPlayerName();
        pnd.dispose();
        if (targetPlayer == null) {
            return;
        }
        CUser user = this.mwclient.getUser(targetPlayer);
        String newfluff = JOptionPane.showInputDialog(this, "Fluff? (Leave blank to remove)", user.getFluff());
        if (newfluff != null) {
            this.mwclient.sendChat("/c FactionLeaderFluff#" + targetPlayer + "#" + newfluff);
        }
    }

    public void jMenuLeaderMute_actionPerformed() {
        int menuType = 1;
        PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Mute Player", menuType);
        pnd.setVisible(true);
        String targetPlayer = pnd.getPlayerName();
        pnd.dispose();
        if (targetPlayer == null) {
            return;
        }
        this.mwclient.sendChat("/c FactionLeaderMute#" + targetPlayer);
    }

    public void jMenuLeaderFactionColor_actionPerformed() {
        String newColor = JOptionPane.showInputDialog(this, "Faction Color?", "Faction Color?", 3);
        if (newColor != null) {
            this.mwclient.sendChat("/c ChangeHouseColor#" + this.mwclient.getPlayer().getHouse() + "#" + newColor);
        }
    }

    public void jMenuLeaderPlayerColor_actionPerformed() {
        String newColor = JOptionPane.showInputDialog(this, "Player Color?", "Player Color?", 3);
        if (newColor != null) {
            this.mwclient.sendChat("/c AdminSetHousePlayerColor#" + this.mwclient.getPlayer().getHouse() + "#" + newColor);
        }
    }

    public void jMenuLeaderResearchUnit_actionPerformed() {
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.mwclient.getMainFrame());
        UnitViewerDialog unitSelector = new UnitViewerDialog(this.mwclient.getMainFrame(), unitLoadingDialog, this.mwclient, 3);
        unitSelector.setName("Unit Selector");
        new Thread(unitSelector).start();
    }

    public void jMenuLeaderSetComponentConversion_actionPerformed() {
        new ComponentConverterDialog(this.mwclient);
    }

    public void jMenuLeaderPurchaseFactory_actionPerformed(String planet) {
        String[] units = new String[]{CUnit.getTypeClassDesc(0), CUnit.getTypeClassDesc(1), CUnit.getTypeClassDesc(2), CUnit.getTypeClassDesc(3), CUnit.getTypeClassDesc(4)};
        String[] weight = new String[]{CUnit.getWeightClassDesc(0), CUnit.getWeightClassDesc(1), CUnit.getWeightClassDesc(2), CUnit.getWeightClassDesc(3)};
        String factoryName = JOptionPane.showInputDialog(this, "Factory Name?", "Factory Name?", 3);
        if (factoryName == null) {
            return;
        }
        JComboBox<String> combo = new JComboBox<String>(units);
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Unit Type");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int unitType = combo.getSelectedIndex();
        if (unitType < 0) {
            return;
        }
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        combo = new JComboBox<String>(weight);
        combo.setEditable(false);
        jop = new JOptionPane(combo, 3, 2);
        dlg = jop.createDialog(this.mwclient.getMainFrame(), "Unit Weight");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int unitWeight = combo.getSelectedIndex();
        if (unitWeight < 0) {
            return;
        }
        value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        if (planet == null) {
            String[] opString = new String[]{"20000", " ", " ", " ", " ", "100", "100", "0", Integer.toString(Integer.MAX_VALUE), this.mwclient.getPlayer().getHouse(), "", ""};
            PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Choose a planet", opString);
            planetDialog.setVisible(true);
            planet = planetDialog.getPlanetName();
            planetDialog.dispose();
            if (planet == null) {
                return;
            }
        }
        this.mwclient.sendChat("/c purchaseFactory#" + factoryName + "#" + unitType + "#" + unitWeight + "#" + planet);
    }

    public void jMenuHelpAbout_actionPerformed() {
        JDialog dlg = new JDialog((Frame)this, "MekWars Client Info");
        JPanel child = new JPanel();
        child.setLayout(new BoxLayout(child, 1));
        JLabel mekwars = new JLabel("MekWars Client Version: 0.2.40.0");
        JLabel version = new JLabel("MegaMek Version: " + MegaMek.VERSION);
        JLabel license1 = new JLabel("MekWars Client software is under GPL. See");
        JLabel license2 = new JLabel("license.txt in ./MekWars Docs/ for details.");
        JLabel license3 = new JLabel("Project Info and Server Packages:");
        JLabel license4 = new JLabel("       http://www.sourceforge.net/projects/mekwars       ");
        JLabel data1 = new JLabel("       Datasets are prepared by server operators.       ");
        JLabel data2 = new JLabel("       Contact a server administrator for information       ");
        JLabel data3 = new JLabel("       regarding data use and redistribution.       ");
        mekwars.setAlignmentX(0.5f);
        version.setAlignmentX(0.5f);
        license1.setAlignmentX(0.5f);
        license2.setAlignmentX(0.5f);
        license3.setAlignmentX(0.5f);
        license4.setAlignmentX(0.5f);
        data1.setAlignmentX(0.5f);
        data2.setAlignmentX(0.5f);
        data3.setAlignmentX(0.5f);
        child.add(new JLabel("\n"));
        child.add(mekwars);
        child.add(version);
        child.add(new JLabel("\n"));
        child.add(license1);
        child.add(license2);
        child.add(new JLabel("\n"));
        child.add(license3);
        child.add(license4);
        child.add(new JLabel("\n"));
        child.add(data1);
        child.add(data2);
        child.add(data3);
        child.add(new JLabel("\n"));
        dlg.getContentPane().add(child);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setResizable(false);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void jMenuHelpMemory_actionPerformed() {
        JDialog dlg = new JDialog((Frame)this, "MekWars Memory Usage");
        JPanel child = new JPanel();
        child.setLayout(new BoxLayout(child, 1));
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        DecimalFormat myFormatter = new DecimalFormat("#,### kb");
        JLabel freeMem = new JLabel("Free Memory:          " + myFormatter.format(freeMemory / 1024L));
        JLabel allocatedMem = new JLabel("Allocated Memory:  " + myFormatter.format(allocatedMemory / 1024L));
        JLabel maxMem = new JLabel("Max Memory:           " + myFormatter.format(maxMemory / 1024L));
        JLabel totalFreeMem = new JLabel("Total Free Memory: " + myFormatter.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
        freeMem.setAlignmentX(0.0f);
        allocatedMem.setAlignmentX(0.0f);
        maxMem.setAlignmentX(0.0f);
        totalFreeMem.setAlignmentX(0.0f);
        child.add(new JLabel("\n"));
        child.add(freeMem);
        child.add(allocatedMem);
        child.add(maxMem);
        child.add(totalFreeMem);
        child.add(new JLabel("\n"));
        dlg.getContentPane().add(child);
        dlg.setLocationRelativeTo(this);
        dlg.setModal(false);
        dlg.setResizable(false);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void jMenuHelpHelp_actionPerformed() {
        House faction;
        int type;
        CPlayer p = this.mwclient.getPlayer();
        boolean trueCost = Boolean.parseBoolean(this.mwclient.getserverConfigs("UseCalculatedCosts"));
        StringBuilder result = new StringBuilder();
        result.append("<font color=\"black\">");
        result.append("MEKWARS ONLINE HELP<br>");
        result.append("<table><tr><th>Name</th><th>" + this.mwclient.moneyOrFluMessage(true, false, -2) + "</th><th>" + this.mwclient.moneyOrFluMessage(false, false, -2) + "</th><th>Components</th>");
        if (this.useAdvanceRepairs) {
            result.append("<th>Bays</th></tr>");
        } else {
            result.append("<th>Techs</th></tr>");
        }
        int typeamount = 6;
        for (type = 0; type < typeamount; ++type) {
            String useIt = "Use" + Unit.getTypeClassDesc(type);
            if (!Boolean.parseBoolean(this.mwclient.getserverConfigs(useIt))) continue;
            for (int weight = 0; !(weight >= 4 || Boolean.parseBoolean(this.mwclient.getserverConfigs("UseOnlyLightInfantry")) && type == 2 && weight != 0 || Boolean.parseBoolean(this.mwclient.getserverConfigs("UseOnlyOneVehicleSize")) && type == 1 && weight != 0); ++weight) {
                result.append("<tr><td>" + Unit.getWeightClassDesc(weight) + " " + Unit.getTypeClassDesc(type) + "</td><td>");
                if (trueCost) {
                    result.append("See Unit Viwer");
                } else {
                    result.append(CUnit.getPriceForUnit(this.mwclient, weight, type, p.getMyHouse()));
                }
                result.append("</td><td>" + CUnit.getInfluenceForUnit(this.mwclient, weight, type, p.getMyHouse()) + "</td>");
                result.append("<td>" + CUnit.getPPForUnit(this.mwclient, weight, type, p.getMyHouse()) + "</td><td>");
                if (type == 3) {
                    result.append(this.mwclient.getserverConfigs("TechsToProtoPointRatio") + " per 5");
                } else {
                    result.append(p.getHangarSpaceRequired(type, weight, 0, ""));
                }
                result.append("</td></tr>");
            }
        }
        result.append("</table>");
        result.append("<br><b><i>Repoding facts:</b></i>");
        result.append("<table><tr><th>Class</th><th>" + this.mwclient.moneyOrFluMessage(true, false, -2) + "</th><th>" + this.mwclient.moneyOrFluMessage(false, false, -2) + "</th><th>Components</th></tr>");
        typeamount = 1;
        for (type = 0; type < typeamount; ++type) {
            for (int weight = 0; weight < 4; ++weight) {
                String repodFlu = "RepodFlu" + Unit.getWeightClassDesc(weight);
                String repodCost = "RepodCost" + Unit.getWeightClassDesc(weight);
                String repodComponents = "RepodComp" + Unit.getWeightClassDesc(weight);
                int repodCostInt = Integer.parseInt(this.mwclient.getserverConfigs(repodCost));
                int repodComponentsInt = Integer.parseInt(this.mwclient.getserverConfigs(repodComponents));
                if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("DoesRepodCost"))) {
                    repodCostInt = 0;
                }
                if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("RepodUsesComp"))) {
                    repodComponentsInt = 0;
                }
                result.append("<tr><td>" + Unit.getWeightClassDesc(weight) + "</td><td>" + repodCostInt + "</td><td>" + this.mwclient.getserverConfigs(repodFlu) + "</td><td>" + repodComponentsInt + "</td></tr>");
            }
        }
        result.append("</table><br>");
        if (this.useAdvanceRepairs) {
            result.append("<br><b><i>Tech/BayCosts:</b></i>");
            result.append("<table><tr><th>Type</th><th>" + this.mwclient.moneyOrFluMessage(true, false, -2) + "</th>");
            result.append("<tr><td>Bay Cost</td><td>" + Integer.parseInt(this.mwclient.getserverConfigs("CostToBuyNewBay")) + "</td></tr>");
            result.append("<tr><td>Bay Sale</td><td>" + Integer.parseInt(this.mwclient.getserverConfigs("BaySellBackPrice")) + "</td></tr>");
            result.append("<tr><td>Green Tech</td><td>" + Integer.parseInt(this.mwclient.getserverConfigs("GreenTechHireCost")) + "</td></tr>");
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowRegTechsToBeHired"))) {
                result.append("<tr><td>Reg Tech</td><td>" + Integer.parseInt(this.mwclient.getserverConfigs("RegTechHireCost")) + "</td></tr>");
            }
            result.append("</table>");
        }
        result.append("<table><tr><th>Size of Unit</th><th>EXP needed</th></tr>");
        result.append("<tr><td>Medium</td><td>" + this.mwclient.getserverConfigs("MinEXPforMedium") + "</td></tr>");
        result.append("<tr><td>Heavy</td><td>" + this.mwclient.getserverConfigs("MinEXPforHeavy") + "</td></tr>");
        result.append("<tr><td>Assault</td><td>" + this.mwclient.getserverConfigs("MinEXPforAssault") + "</td></tr>");
        result.append("</table>");
        result.append("EXP needed to Buy/Sell on the Black Market: " + this.mwclient.getserverConfigs("MinEXPforBMBuying") + "/" + this.mwclient.getserverConfigs("MinEXPforBMSelling") + "<br>");
        result.append("EXP needed to defect from " + this.mwclient.getserverConfigs("NewbieHouseName") + " to a Faction: " + this.mwclient.getserverConfigs("MinEXPforDefecting") + "<br>");
        result.append("</table><br>");
        result.append("<b><i>Unit Status Icons</B></i><br>");
        result.append("<table><tr><th>Icon</th><th>Description</th></tr>");
        result.append("<tr><td><img src=\"data/images/status/ammo.gif\"></td><td>Unit has all ammo bins loaded</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/low.gif\"></td><td>Unit has 1 or more ammo bins that are low on ammo</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/empty.gif\"></td><td>Unit has 1 or more ammo bins that are empty</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/armor.gif\"></td><td>Unit has armor damage</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/structure.gif\"></td><td>Unit has IS damage</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/critical.gif\"></td><td>Unit has criticals damaged</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/engine.gif\"></td><td>Unit is engined</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/nopilot.gif\"></td><td>Unit has no pilot</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/pilot.gif\"></td><td>Unit has a pilot</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/wound.gif\"></td><td>Unit has a wounded pilot</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/eject.gif\"></td><td>Unit has autoejection enabled</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/noeject.gif\"></td><td>Unit has autoejection disabled</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/pending.gif\"></td><td>Unit has pending repairs</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/repairing.gif\"></td><td>Unit is currently under repair</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/unmaint.gif\"></td><td>Unit is unmaintained/damaged</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/maint.gif\"></td><td>Unit is fully maintained</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/search.gif\"></td><td>Unit is equiped with a slite</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/searchon.gif\"></td><td>Unit is equiped with a slite and defaults to on</td></tr>");
        result.append("<tr><td><img src=\"data/images/status/nosearch.gif\"></td><td>Unit is not equiped with a slite</td></tr>");
        result.append("</table><br>");
        result.append("</table><br>");
        if (this.mwclient.getData().getServerBannedAmmo().size() > 0) {
            result.append("<b><i>Server Banned ammo</b></i><br>");
            for (String key : this.mwclient.getData().getServerBannedAmmo().keySet()) {
                result.append(this.mwclient.getData().getMunitionsByNumber().get(Long.parseLong(key)) + "<br>");
            }
        }
        if ((faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse())).getBannedAmmo().size() > 0) {
            result.append("<b><i>House Banned Ammo</b></i><br>");
            for (String key : faction.getBannedAmmo().keySet()) {
                result.append(this.mwclient.getData().getMunitionsByNumber().get(Long.parseLong(key)) + "<br>");
            }
        }
        this.mwclient.doParseDataInput("SM|" + result.toString());
    }

    public void jMenuHelpPilotSkills_actionPerformed() {
        String result = "";
        result = result + "<font color=\"black\">";
        result = result + "<b><i>MekWars/MegaMek Pilot Skills</b></i><br>";
        result = result + "<table><tr><th>Name</th><th>Abbrivation</th><th>Description</th></tr>";
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforATforMek")) > 0) {
            result = result + "<tr><td>Astech</td><td>AT</td>";
            result = this.useAdvanceRepairs ? result + "<td>Pilot acts as a tech with repairs only costing parts</td>" : result + "<td>Reduces the number of techs needed to repair a unit by 1</td>";
            result = result + "</tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforBVDNIforMek")) > 0) {
            result = result + "<tr><td>MD Buffered VDNI</td><td>BVDNI</td><td>Allows pilots to take more damage.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforDMforMek")) > 0) {
            result = result + "<tr><td>Dodge Maneuver</td><td>DM</td><td>Enables the unit to make a dodge maneuver instead of a physical attack.<br>This maneuver adds +2 to the BTH to physical attacks against the unit.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforEDforMek")) > 0) {
            result = result + "<tr><td>Edge</td><td>ED</td><td>Allows Pilot to reroll 1 roll(per level) per game.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforEIforMek")) > 0) {
            result = result + "<tr><td>Enhanced Interface</td><td>EI</td><td>Neural interface to the clan enhanced imaging system<br>-1 To PSR<br>+2 when targeting with TC instead of +3<br>Can Target without TC at +6<br>Reduces all forest and Smoke mods to 1<br>Pilot receives 1 point of damage every time Units IS is hit,<br>If you fail a roll of 7+<br>BA's recieve 1 extra point of damage every time they are hit</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGTforMek")) > 0) {
            result = result + "<tr><td>Gifted</td><td>GT</td><td>Pilots receive an extra " + this.mwclient.getserverConfigs("GiftedPercent") + "% chance to gain a skill when they fail<br>to level Piloting or Gunnery after a win.</td>" + "</tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGBforMek")) > 0) {
            result = result + "<tr><td>Gunnery Ballistic</td><td>GB</td><td>NOTE: This is an unofficial rule. Pilot gets a -1 to-hit bonus on all<br>ballistic weapons (MGs, all ACs, Gaussrifles).</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGLforMek")) > 0) {
            result = result + "<tr><td>Gunnery Laser</td><td>GL</td><td>NOTE: This is an unofficial rule. Pilot gets a -1 to-hit bonus on all<br>energy-based weapons (Laser, PPC, and Flamer).</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGMforMek")) > 0) {
            result = result + "<tr><td>Gunnery Missile</td><td>GM</td><td>NOTE: This is an unofficial rule. Pilot gets a -1 to-hit bonus on all<br>missile weapons (LRM, MRM, SRM).</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforIMforMek")) > 0) {
            result = result + "<tr><td>Iron Man</td><td>IM</td><td>NOTE: This is an unofficial rule. A pilot with this skill receives only<br>1 pilot hit from ammunition explosions.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMAforMek")) > 0) {
            result = result + "<tr><td>Maneuvering Ace</td><td>MA</td><td>Enables the unit to move laterally like a Quad. Units also receive a -1<br>BTH to rolls against skidding.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMSforMek")) > 0) {
            result = result + "<tr><td>Melee Specialist</td><td>MS</td><td>Enables the unit to do 1 additional point of damage with physical attacks<br>and subtracts one from the attacker movement modifier (to a minimum of zero).<br>Note: This ability is only used for BattleMechs.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMTforMek")) > 0) {
            result = result + "<tr><td>MedTech</td><td>MT</td><td>A pilot with the MedTech skill will heal 1 extra point per tick.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforNAGforMek")) > 0) {
            result = result + "<tr><td>Natural Aptitude: Gunnery</td><td>NAG</td><td>The pilot checks leveling for gunnery at one level higher then current i.e.<br>5 instead of 4 for a 4/5 pilot</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforNAPforMek")) > 0) {
            result = result + "<tr><td>Natural Aptitude: Piloting</td><td>NAP</td><td>The pilot checks leveling for piloting at one level higher then current i.e.<br>5 instead of 4 for a 4/5 pilot</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforPRforMek")) > 0) {
            result = result + "<tr><td>Pain Resistance</td><td>PR</td><td>When making consciousness rolls, 1 is added to all rolls. Also, damage received<BR>from ammo explosions is reduced to 1.<BR>Note: This ability is only used for BattleMechs.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforPSforMek")) > 0) {
            result = result + "<tr><td>Pain Shunt</td><td>PS</td><td>When making consciousness rolls, 1 is added to all rolls. Also, damage received<BR>from ammo explosions is reduced to 1.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforQSforMek")) > 0) {
            result = result + "<tr><td>Quick Study</td><td>QS</td><td>Pilots with the Quick Study skill gain a 5% bonus to all XP earned.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforSVforMek")) > 0) {
            result = result + "<tr><td>Survivalist</td><td>SV</td><td>If a pilot has this skill they will have a +20% of returning home if ejected and<br>left on the field.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTGforMek")) > 0) {
            result = result + "<tr><td>Tactical Genius</td><td>TG</td><td>A pilot who has a Tactical Genius may reroll their initiative once per turn.<br>The second roll must be accepted.</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTNforMek")) > 0) {
            result = result + "<tr><td>Trait</td><td>TN</td><td>Pilot traits for use with moding the gaining of other skills</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforVDNIforMek")) > 0) {
            result = result + "<tr><td>VDNI MD Skill</td><td>VDNI</td><td>Allows Pilot to Take more Damage</td></tr>";
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforWSforMek")) > 0) {
            result = result + "<tr><td>Weapon Specialist</td><td>WS</td><td>A pilot who specializes in a particular weapon receives a -2 to hit modifier<br>on all attacks with that weapon.</td></tr>";
        }
        result = result + "<tr><td>Clan Pilot Training</td><td>CPT</td><td>Pilot has a +1 penalty for physical attacks,<br>because clans do not train for dishonourable combat.</td></tr>";
        result = result + "</table>";
        this.mwclient.doParseDataInput("SM|" + result);
    }

    public void showMulFileList(String data) {
        StringTokenizer mulList = new StringTokenizer(data, "#");
        Vector<String> list = new Vector<String>(1, 1);
        while (mulList.hasMoreElements()) {
            list.add(mulList.nextToken());
        }
        JComboBox combo = new JComboBox(list);
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select mul file.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        if (combo.getSelectedIndex() < 0) {
            return;
        }
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        String selectedMul = (String)list.elementAt(combo.getSelectedIndex());
        this.mwclient.sendChat("/c retrievemul#" + selectedMul);
    }

    public void refreshBattleTable() {
        this.MainPanel.refreshBattleTable();
    }

    void this_componentResized(ComponentEvent e) {
    }

    public void setSoundMuted(boolean b) {
        this.jMenuOptionsMute.setState(b);
    }

    public void refreshMenu() {
        this.hasAdminMenus = false;
        this.jMenuBar1.removeAll();
        try {
            this.createMenu();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        this.enableMenu();
        this.repaint();
    }

    public void updateAttackMenu() {
        if (this.jMenuAttackMenu == null) {
            CampaignData.mwlog.errLog("Attack Menu is Null!");
            return;
        }
        this.jMenuAttackMenu.updateMenuItems(true);
    }

    public void startHost() {
        this.jMenuHost.setForeground(Color.red);
        this.jMenuCSHostAndJoin.setEnabled(false);
        this.jMenuCSHostDedicated.setEnabled(false);
        this.jMenuCSHostStop.setEnabled(true);
        this.jMenuCSHostAndJoin.setVisible(false);
        this.jMenuCSHostDedicated.setVisible(false);
        this.jMenuCSHostLoad.setVisible(false);
        this.jMenuCSHostLoadAndJoin.setVisible(false);
        this.jMenuCSHostStop.setVisible(true);
    }

    public void stopHost() {
        this.jMenuHost.setForeground(Color.black);
        this.jMenuCSHostAndJoin.setEnabled(true);
        this.jMenuCSHostDedicated.setEnabled(true);
        this.jMenuCSHostStop.setEnabled(false);
        this.jMenuCSHostAndJoin.setVisible(true);
        this.jMenuCSHostDedicated.setVisible(true);
        this.jMenuCSHostLoad.setVisible(true);
        this.jMenuCSHostLoadAndJoin.setVisible(true);
        this.jMenuCSHostStop.setVisible(false);
    }

    public void changeStatus(int status, int laststatus) {
        if (this.mwclient.getConfig().isParam("STATUSINTRAYICON")) {
            if (status == 2) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getImage("RESERVE").getImage());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            } else if (status == 3) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getImage("ACTIVE").getImage());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            } else if (status == 4) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getImage("FIGHT").getImage());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            } else if (status == 1 || status == 0) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getImage("LOGOUT").getImage());
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        } else {
            try {
                this.setIconImage(this.mwclient.getConfig().getImage("TRAY").getImage());
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        this.MainPanel.changeStatus(status, laststatus);
        this.enableMenu();
        this.repaint();
    }

    public void createArmyFromMul(String data) {
        PlayerNameDialog playerDialog = new PlayerNameDialog(this.mwclient, "Choose a Player.", 0);
        playerDialog.setVisible(true);
        String player = playerDialog.getPlayerName();
        playerDialog.dispose();
        if (player == null) {
            player = "";
        }
        System.err.println("String Tokenizer called");
        StringTokenizer mulList = new StringTokenizer(data, "#");
        Vector<String> list = new Vector<String>(1, 1);
        while (mulList.hasMoreElements()) {
            list.add(mulList.nextToken());
        }
        JComboBox combo = new JComboBox(list);
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(this.mwclient.getMainFrame(), "Select mul file.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        if (combo.getSelectedIndex() < 0) {
            return;
        }
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        String selectedMul = (String)list.elementAt(combo.getSelectedIndex());
        String fluff = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army Name.");
        if (fluff == null || fluff.length() < 1) {
            return;
        }
        this.mwclient.sendChat("/createarmyfrommul " + selectedMul + "#" + fluff + "#" + player);
    }

    public void jMenuSendAllOperationFiles_actionPerformed(ActionEvent e) {
        int result = JOptionPane.showConfirmDialog(null, "Upload All local OpFiles?", "Upload Ops", 0);
        if (result == 1) {
            return;
        }
        File opFiles = new File("./data/operations/short/");
        if (!opFiles.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        for (File opFile : opFiles.listFiles()) {
            try {
                FileInputStream fis = new FileInputStream(opFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                opData.append(opFile.getName().substring(0, opFile.getName().lastIndexOf(".txt")) + "#");
                while (dis.ready()) {
                    opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
                }
                dis.close();
                fis.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to read " + opFile);
                return;
            }
            this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
            opData.setLength(0);
            opData.trimToSize();
        }
    }

    public void jMenuSetNewOperationFile_actionPerformed(ActionEvent e) {
        String opName = JOptionPane.showInputDialog(this.mwclient.getMainFrame().getContentPane(), (Object)"New Op Name?");
        if (opName == null || opName.trim().length() < 1) {
            return;
        }
        File opFile = new File("./data/operations/short/" + opName + ".txt");
        if (!opFile.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(opName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to read " + opFile);
            return;
        }
        this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
    }

    public void jMenuUpdateOperations_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat("/c adminlockcampaign");
        this.mwclient.sendChat("/c updateoperations");
        this.mwclient.sendChat("/c adminunlockcampaign");
    }

    public void jMenuRetrieveOperationFile_actionPerformed(ActionEvent e) {
        JComboBox<Object> opCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
        opCombo.setEditable(false);
        JOptionPane jop = new JOptionPane(opCombo, 3, 2);
        JDialog dlg = jop.createDialog(this, "Select Op.");
        opCombo.grabFocus();
        opCombo.getEditor().selectAll();
        dlg.setVisible(true);
        if ((Integer)jop.getValue() == 2) {
            return;
        }
        String opName = (String)opCombo.getSelectedItem();
        this.mwclient.sendChat("/c RETRIEVEOPERATION#short#" + opName);
    }

    public void jMenuSetOperationFile_actionPerformed(ActionEvent e) {
        JComboBox<Object> opCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
        opCombo.setEditable(false);
        JOptionPane jop = new JOptionPane(opCombo, 3, 2);
        JDialog dlg = jop.createDialog(this, "Select Op.");
        opCombo.grabFocus();
        opCombo.getEditor().selectAll();
        dlg.setVisible(true);
        if ((Integer)jop.getValue() == 2) {
            return;
        }
        String opName = (String)opCombo.getSelectedItem();
        File opFile = new File("./data/operations/short/" + opName + ".txt");
        if (!opFile.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(opName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to read " + opFile);
            return;
        }
        this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
    }

    private void addMenuListener(Object[] components) {
        for (Object menu : components) {
            if (!(menu instanceof JMenu)) continue;
            JMenu jmenu = (JMenu)menu;
            jmenu.removeMenuListener(this.sound);
            jmenu.addMenuListener(this.sound);
            this.addMenuItemListner(jmenu);
        }
    }

    private void addMenuItemListner(JMenu menu) {
        for (int pos = 0; pos < menu.getItemCount(); ++pos) {
            JMenuItem item = menu.getItem(pos);
            if (!(item instanceof JMenu)) continue;
            ((JMenu)item).removeMenuListener(this.popupSound);
            ((JMenu)item).addMenuListener(this.popupSound);
            this.addMenuItemListner((JMenu)item);
        }
    }
}

