/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.CMainFrame;
import client.gui.InnerStellarMap;
import client.gui.PlanetPanel;
import common.CampaignData;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CMapPanel
extends JPanel {
    private static final long serialVersionUID = 5547551465585402891L;
    private InnerStellarMap map;
    private JSlider slider;
    private PlanetPanel planetPanel;
    private JPanel mapControl;
    private MWClient mwclient;

    public CMapPanel(MWClient client, CMainFrame mainFrame, int xsize, int ysize) {
        this.mwclient = client;
        this.setLayout(null);
        this.mapControl = new JPanel();
        this.mapControl.setOpaque(false);
        this.mapControl.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.mapControl);
        this.mapControl.setLayout(new BoxLayout(this.mapControl, 1));
        this.map = new InnerStellarMap(this, this.mwclient, mainFrame);
        this.planetPanel = new PlanetPanel(this, this.mwclient);
        this.mapControl.add(this.planetPanel);
        this.planetPanel.setAlignmentX(0.0f);
        this.planetPanel.setAlignmentY(0.0f);
        this.slider = new ZoomSlider();
        this.slider.setValue((int)Math.round(50.0 / this.map.conf.scale));
        this.slider.setAlignmentX(0.0f);
        this.slider.setAlignmentY(0.0f);
        this.slider.setOpaque(false);
        this.slider.setMajorTickSpacing(this.slider.getMaximum() / 5);
        this.slider.setMinorTickSpacing(this.slider.getMaximum() / 10);
        this.slider.setPaintTicks(true);
        this.add(this.slider);
        this.add(this.map);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                CMapPanel.this.map.setSize(e.getComponent().getSize());
                CMapPanel.this.slider.setBounds(e.getComponent().getWidth() - 155, 5, 150, ((CMapPanel)CMapPanel.this).slider.getPreferredSize().height);
            }

            public void componentShown(ComponentEvent e) {
                CMapPanel.this.map.setSize(e.getComponent().getSize());
                CMapPanel.this.slider.setBounds(e.getComponent().getWidth() - 155, 5, 150, ((CMapPanel)CMapPanel.this).slider.getPreferredSize().height);
            }
        });
        if (client.getConfig().isParam("MAPTABVISIBLE")) {
            try {
                this.map.activate(client.getData().getPlanet(this.map.conf.planetID));
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public CampaignData getData() {
        return this.mwclient.getData();
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public PlanetPanel getPPanel() {
        return this.planetPanel;
    }

    public JPanel getMapControl() {
        return this.mapControl;
    }

    public InnerStellarMap getMap() {
        return this.map;
    }

    private class ZoomSlider
    extends JSlider
    implements ChangeListener {
        private static final long serialVersionUID = -2214264904474265394L;

        ZoomSlider() {
            super(0, ((CMapPanel)CMapPanel.this).map.conf.reverseScaleMin, ((CMapPanel)CMapPanel.this).map.conf.reverseScaleMax, ((CMapPanel)CMapPanel.this).map.conf.reverseScaleMin + (((CMapPanel)CMapPanel.this).map.conf.reverseScaleMax - ((CMapPanel)CMapPanel.this).map.conf.reverseScaleMin) / 2);
            this.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent e) {
            CMapPanel.this.map.setScale(50.0 / (double)this.getValue());
            CMapPanel.this.repaint();
        }
    }
}

