/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.Browser;
import client.gui.CHSPanel;
import client.gui.InnerStellarMap;
import common.CampaignData;
import common.Planet;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class MMNetHyperLinkListener
implements HyperlinkListener {
    MWClient mwclient;
    protected boolean isHovering = false;
    protected String Tooltip = null;
    protected CHSPanel HSPanel = null;

    public MMNetHyperLinkListener(MWClient f) {
        this.mwclient = f;
    }

    public MMNetHyperLinkListener(MWClient f, CHSPanel p) {
        this.mwclient = f;
        this.HSPanel = p;
    }

    public boolean isHoveringOverHyperlink() {
        return this.isHovering;
    }

    public String getTooltip() {
        return this.Tooltip;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.isHovering = true;
            try {
                this.Tooltip = (String)e.getSourceElement().getAttributes().getAttribute(HTML.getAttributeKey("alt"));
                CampaignData.mwlog.infoLog(this.Tooltip);
                if (this.HSPanel != null) {
                    this.HSPanel.setInfoText(this.Tooltip);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.isHovering = false;
            if (this.HSPanel != null) {
                this.HSPanel.setInfoText("");
            }
            this.Tooltip = null;
        }
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    if (e.getDescription().startsWith("MEKWARS")) {
                        String command = e.getDescription();
                        command = command.substring(7);
                        this.mwclient.sendChat(command);
                    } else if (e.getDescription().startsWith("MEKMAIL")) {
                        String command = e.getDescription();
                        command = command.substring(7);
                        StringTokenizer commandStr = new StringTokenizer(command, "*");
                        command = commandStr.nextToken() + ", " + commandStr.nextToken();
                        CampaignData.mwlog.errLog("Command " + command);
                        this.mwclient.sendChat("/mail " + command);
                    } else if (e.getDescription().startsWith("MEKINFO")) {
                        String command = e.getDescription();
                        command = command.substring(7);
                        StringTokenizer ST = new StringTokenizer(command, "#");
                        String filename = ST.nextToken();
                        int BV = Integer.parseInt(ST.nextToken());
                        int gunnery = Integer.parseInt(ST.nextToken());
                        int piloting = Integer.parseInt(ST.nextToken());
                        String battleDamage = "";
                        if (ST.hasMoreTokens()) {
                            battleDamage = ST.nextToken();
                        }
                        this.mwclient.getMainFrame().getMainPanel().getHSPanel().showInfoWindow(filename, BV, gunnery, piloting, battleDamage);
                    } else if (e.getDescription().startsWith("MWUSERP")) {
                        String command = e.getDescription();
                        command = command.substring(7);
                        this.mwclient.rewardPointsDialog();
                    } else if (e.getDescription().startsWith("MWREG")) {
                        String command = e.getDescription();
                        command = command.substring(5);
                        this.mwclient.getMainFrame().jMenuFileRegister_actionPerformed();
                    } else if (e.getDescription().startsWith("JUMPTOPLANET")) {
                        String command = e.getDescription();
                        command = command.substring(12);
                        StringTokenizer ST = new StringTokenizer(command, "#");
                        String planetName = ST.nextToken();
                        InnerStellarMap map = this.mwclient.getMainFrame().getMainPanel().getMapPanel().getMap();
                        Planet currPlanet = this.mwclient.getData().getPlanetByName(planetName);
                        if (currPlanet != null) {
                            map.setSelectedPlanet(currPlanet);
                            map.activate(currPlanet, true);
                            map.saveMapSelection(currPlanet);
                            if (this.mwclient.getConfig().isParam("MAPTABONCLICK") && this.mwclient.getConfig().isParam("MAPTABVISIBLE")) {
                                this.mwclient.getMainFrame().getMainPanel().selectMapTab();
                            }
                        }
                    } else if (e.getDescription().startsWith("MWDEFECTDLG")) {
                        String command = e.getDescription();
                        command = command.substring(11);
                        Object[] options = new Object[]{" Defect ", " Cancel "};
                        int confirmed = JOptionPane.showOptionDialog(this.mwclient.getMainFrame(), "Are you SURE you want to defect?", "Defection Confirmation", -1, 2, null, options, options[1]);
                        if (confirmed == 0) {
                            this.mwclient.sendChat(command);
                        }
                    } else if (e.getDescription().startsWith("MWSOLDEFECT")) {
                        this.mwclient.getMainFrame().jMenuCommanderDefect_actionPerformed();
                    } else if (e.getDescription().startsWith("REMOVEQUEUEDWORKORDER")) {
                        String command = e.getDescription();
                        StringTokenizer ST = new StringTokenizer(command, "|");
                        ST.nextToken();
                        int tech = Integer.parseInt(ST.nextToken());
                        String position = ST.nextToken();
                        this.mwclient.getRMT().removeWorkOrder(tech, position);
                    } else if (e.getDescription().startsWith("REMOVESALVAGEQUEUEDWORKORDER")) {
                        String command = e.getDescription();
                        StringTokenizer ST = new StringTokenizer(command, "|");
                        ST.nextToken();
                        int tech = Integer.parseInt(ST.nextToken());
                        String position = ST.nextToken();
                        this.mwclient.getSMT().removeWorkOrder(tech, position);
                    } else {
                        Browser.displayURL(e.getURL().toExternalForm());
                    }
                }
                catch (Throwable t) {
                    CampaignData.mwlog.errLog((Exception)t);
                }
            }
        }
    }
}

