/*
 * Decompiled with CFR 0.152.
 */
package client.gui.commands;

import client.MWClient;
import client.gui.commands.IGUICommand;
import client.protocol.CConnector;
import javax.swing.AbstractAction;

public abstract class CGUICommand
extends AbstractAction
implements IGUICommand {
    private static final long serialVersionUID = -8448209123971531879L;
    String name = "";
    String alias = "";
    String command = "";
    String subcommand = "";
    String GUIprefix = "";
    String delimiter = "";
    String prefix = "";
    MWClient mwclient;
    CConnector Connector;

    public CGUICommand(MWClient mwclient) {
        this.mwclient = mwclient;
        this.Connector = mwclient.getConnector();
        this.GUIprefix = "/";
        this.delimiter = "\t";
        this.prefix = "/";
    }

    public boolean check(String tname) {
        if (tname.startsWith(this.GUIprefix)) {
            tname = tname.substring(this.GUIprefix.length());
        }
        return this.name.equals(tname) || this.alias.equals(tname);
    }

    public boolean execute(String input) {
        return true;
    }

    protected void echo(String input) {
    }

    protected void send(String input) {
        this.Connector.send(this.prefix + this.command + this.delimiter + input);
    }

    protected void send() {
        this.Connector.send(this.prefix + this.command);
    }

    protected String decompose(String input) {
        if (input.startsWith(this.GUIprefix)) {
            input = input.substring(this.GUIprefix.length()).trim();
        }
        if (input.startsWith(this.name)) {
            input = input.substring(this.name.length()).trim();
        } else if (input.startsWith(this.alias)) {
            input = input.substring(this.alias.length()).trim();
        }
        return input;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAlias() {
        return this.alias != null && !this.alias.equals("");
    }
}

