/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import common.campaign.pilot.Pilot;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class BulkRepairDialog
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener {
    private static final long serialVersionUID = 2053155152906533410L;
    private MWClient mwclient = null;
    private Entity unit = null;
    private CUnit playerUnit = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private String windowName = "Bulk Repair Dialog";
    private final int ARMOR = 1;
    private final int INTERNAL = 2;
    private final int WEAPONS = 3;
    private final int EQUIPMENT = 4;
    private final int SYSTEMS = 5;
    private final int ENGINES = 6;
    private final JButton okayButton = new JButton("Start Repairs");
    private final JButton cancelButton = new JButton("Close");
    private JOptionPane pane;
    private JPanel MasterPanel = new JPanel();
    private JPanel contentPane;
    private JPanel masterBox = new JPanel(new SpringLayout());
    private JPanel repairBox = new JPanel();
    private JPanel techBox = new JPanel();
    private JPanel rollBox = new JPanel();
    private JPanel costBox = new JPanel();
    private JPanel timeBox = new JPanel();
    private JPanel blankPanel1 = new JPanel();
    private JPanel blankPanel2 = new JPanel();
    private JPanel totalTextPanel = new JPanel();
    private JPanel totalPanel = new JPanel();
    private JPanel timePanel = new JPanel();
    private JCheckBox repairCB = new JCheckBox();
    private JLabel costField = new JLabel();
    private JLabel timeField = new JLabel();
    private SpinnerNumberModel baseRollEditor = new SpinnerNumberModel();
    private JSpinner baseRollField = new JSpinner(this.baseRollEditor);
    private JComboBox techComboBox = new JComboBox();
    private int repairType = TYPE_BULK;
    public static int TYPE_BULK = 0;
    public static int TYPE_SIMPLE = 1;
    public static int TYPE_SALVAGE = 2;
    public static int UNIT_TYPE_SINGLE = 0;
    public static int UNIT_TYPE_ALL = 1;
    private int unitRepairType = UNIT_TYPE_SINGLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkRepairDialog(MWClient c, int unitID, int repairType, int unitRepairType) {
        this.mwclient = c;
        this.playerUnit = c.getPlayer().getUnit(unitID);
        this.repairType = repairType;
        this.unitRepairType = unitRepairType;
        Entity entity = this.playerUnit.getEntity();
        synchronized (entity) {
            this.unit = this.playerUnit.getEntity();
        }
        this.windowName = this.unit.getShortNameRaw() + " Repair Dialog";
        this.addKeyListener(this);
        if (this.isSalvage()) {
            this.okayButton.setText("Start Salvage");
        }
        this.okayButton.setActionCommand(okayCommand);
        this.okayButton.addActionListener(this);
        this.okayButton.setToolTipText("Start Bulk Repairs.");
        this.okayButton.setMnemonic('S');
        this.cancelButton.setActionCommand(cancelCommand);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setToolTipText("Close the bulk repair dialog");
        this.cancelButton.setDefaultCapable(true);
        this.MasterPanel.setLayout(new BoxLayout(this.MasterPanel, 1));
        this.repairBox.setLayout(new BoxLayout(this.repairBox, 1));
        this.costBox.setLayout(new BoxLayout(this.costBox, 1));
        this.techBox.setLayout(new BoxLayout(this.techBox, 1));
        this.rollBox.setLayout(new BoxLayout(this.rollBox, 1));
        this.timeBox.setLayout(new BoxLayout(this.timeBox, 1));
        this.loadPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.MasterPanel, -1, 2, null, options, null);
        this.setIconImage(this.mwclient.getConfig().getImage("REPAIR").getImage());
        this.setTitle(this.windowName);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pane, "Center");
        this.setResizable(true);
        if (!this.isBulk()) {
            this.setSize(new Dimension(440, 287));
        } else {
            this.setSize(new Dimension(369, 287));
        }
        this.setExtendedState(0);
        this.contentPane.addKeyListener(this);
        this.pane.addKeyListener(this);
        this.MasterPanel.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.masterBox.addKeyListener(this);
        this.repairBox.addKeyListener(this);
        this.costBox.addKeyListener(this);
        this.techBox.addKeyListener(this);
        this.rollBox.addKeyListener(this);
        this.timeBox.addKeyListener(this);
        this.addKeyListener(this);
        this.repaint();
        this.setLocationRelativeTo(this.mwclient.getMainFrame());
        this.setVisible(true);
        this.setRepair();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            if (this.isSimple()) {
                StringBuilder sb = new StringBuilder();
                for (int type = 1; type <= 6; ++type) {
                    sb.append("#" + ((JComboBox)this.techBox.getComponent(type)).getSelectedIndex());
                    sb.append("#" + ((JSpinner)this.rollBox.getComponent(type)).getValue().toString());
                }
                if (this.unitRepairType == UNIT_TYPE_ALL) {
                    for (CUnit repairUnit : this.mwclient.getPlayer().getHangar()) {
                        if (repairUnit.getType() != 0 && repairUnit.getType() != 1 || !UnitUtils.hasArmorDamage(this.unit) && !UnitUtils.hasCriticalDamage(this.unit) && !UnitUtils.hasISDamage(this.unit)) continue;
                        this.mwclient.sendChat("/c simplerepair#" + repairUnit.getId() + sb.toString());
                    }
                } else {
                    this.mwclient.sendChat("/c simplerepair#" + this.playerUnit.getId() + sb.toString());
                }
            } else if (this.isSalvage()) {
                this.mwclient.getSMT().removeAllWorkOrders(this.unit.getExternalId());
                this.checkArmor();
                this.checkWeapons();
                this.checkEquipment();
                this.checkSystems();
                this.checkEngines();
                this.checkInternal();
            } else if (this.unitRepairType == UNIT_TYPE_ALL) {
                for (CUnit repairUnit : this.mwclient.getPlayer().getHangar()) {
                    this.unit = repairUnit.getEntity();
                    if (repairUnit.getType() != 0 && repairUnit.getType() != 1 || !UnitUtils.hasArmorDamage(this.unit) && !UnitUtils.hasCriticalDamage(this.unit) && !UnitUtils.hasISDamage(this.unit)) continue;
                    this.mwclient.getRMT().removeAllWorkOrders(this.unit.getExternalId());
                    this.checkInternal();
                    this.checkArmor();
                    this.checkWeapons();
                    this.checkEquipment();
                    this.checkSystems();
                    this.checkEngines();
                }
            } else {
                this.mwclient.getRMT().removeAllWorkOrders(this.unit.getExternalId());
                this.checkInternal();
                this.checkArmor();
                this.checkWeapons();
                this.checkEquipment();
                this.checkSystems();
                this.checkEngines();
            }
            this.mwclient.getConfig().saveConfig();
            super.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            super.dispose();
        } else {
            try {
                int location = Integer.parseInt(command);
                int techType = ((JComboBox)this.techBox.getComponent(location)).getSelectedIndex();
                if (techType == 4) {
                    techType = this.playerUnit.getPilot().getSkills().getPilotSkill(2).getLevel();
                }
                ((JSpinner)this.rollBox.getComponent(location)).setValue(UnitUtils.techBaseRoll(techType));
                if (((JCheckBox)this.repairBox.getComponent(location)).isSelected()) {
                    this.setCost(location);
                } else {
                    ((JLabel)this.costBox.getComponent(location)).setText("0");
                }
                this.setTotalCost();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadPanel() {
        String[] techList = null;
        Pilot pilot = this.playerUnit.getPilot();
        techList = pilot.getSkills().has(2) ? new String[]{"Green", "Reg", "Vet", "Elite", "Pilot"} : new String[]{"Green", "Reg", "Vet", "Elite"};
        this.repairBox.add(new JLabel("Repair Type"));
        this.techBox.add(new JLabel("Tech Type", 2));
        this.rollBox.add(new JLabel("Base Roll", 2));
        this.costBox.add(new JLabel("Cost", 2));
        if (this.isSimple()) {
            this.timeBox.add(new JLabel("Time", 2));
        }
        for (int x = 0; x < 6; ++x) {
            this.techComboBox = new JComboBox<String>(techList);
            this.techComboBox.addActionListener(this);
            this.techComboBox.setActionCommand(Integer.toString(x + 1));
            this.techComboBox.addKeyListener(this);
            this.techBox.add(this.techComboBox);
            this.baseRollEditor = new SpinnerNumberModel();
            this.baseRollEditor.setMaximum(Integer.valueOf(12));
            this.baseRollEditor.setMinimum(Integer.valueOf(3));
            this.baseRollEditor.setStepSize(1);
            this.baseRollEditor.setValue(8);
            this.baseRollField = new JSpinner(this.baseRollEditor);
            this.baseRollField.addKeyListener(this);
            this.baseRollField.addChangeListener(this);
            this.baseRollField.setName(Integer.toString(x + 1));
            this.baseRollField.setEnabled(!this.isSalvage());
            this.rollBox.add(this.baseRollField);
            this.costField = new JLabel("0");
            this.costField.setAlignmentX(0.5f);
            this.costField.setPreferredSize(new Dimension(50, 100));
            this.costField.setToolTipText("This is an estimated cost based on tech type and base roll");
            this.costBox.add(this.costField);
            this.timeField = new JLabel("0", 2);
            this.timeField.setPreferredSize(new Dimension(50, 100));
            this.timeField.setToolTipText("This is an estimated time based on tech type and base roll");
            this.timeBox.add(this.timeField);
        }
        this.repairCB = new JCheckBox("Armor");
        this.repairCB.addKeyListener(this);
        this.repairCB.addActionListener(this);
        this.repairCB.setActionCommand(Integer.toString(1));
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.repairBox.add(this.repairCB);
        this.repairCB = new JCheckBox("Structure");
        this.repairCB.addKeyListener(this);
        this.repairCB.addActionListener(this);
        this.repairCB.setActionCommand(Integer.toString(2));
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.repairBox.add(this.repairCB);
        this.repairCB = new JCheckBox("Weapons");
        this.repairBox.add(this.repairCB);
        this.repairCB.addKeyListener(this);
        this.repairCB.setActionCommand(Integer.toString(3));
        this.repairCB.addActionListener(this);
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.repairCB = new JCheckBox("Equipment");
        this.repairBox.add(this.repairCB);
        this.repairCB.addKeyListener(this);
        this.repairCB.addActionListener(this);
        this.repairCB.setActionCommand(Integer.toString(4));
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.repairCB = new JCheckBox("Systems");
        this.repairBox.add(this.repairCB);
        this.repairCB.addKeyListener(this);
        this.repairCB.addActionListener(this);
        this.repairCB.setActionCommand(Integer.toString(5));
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.repairCB = new JCheckBox("Engines");
        this.repairCB.addKeyListener(this);
        this.repairCB.addActionListener(this);
        this.repairBox.add(this.repairCB);
        this.repairCB.setActionCommand(Integer.toString(6));
        this.repairCB.setSelected(!this.isBulk());
        this.repairCB.setEnabled(!this.isSimple());
        this.masterBox.add(this.repairBox);
        this.masterBox.add(this.techBox);
        this.masterBox.add(this.rollBox);
        this.masterBox.add(this.costBox);
        if (this.isSimple()) {
            this.masterBox.add(this.timeBox);
        }
        this.blankPanel1.add(new JLabel(" "));
        this.blankPanel2.add(new JLabel(" "));
        this.costField = new JLabel("0");
        this.costField.setToolTipText("This is an estimated cost based on tech type and base roll");
        this.totalPanel.add(this.costField);
        this.totalTextPanel.add(new JLabel("Estimated Total:"));
        this.masterBox.add(this.blankPanel1);
        this.masterBox.add(this.blankPanel2);
        this.masterBox.add(this.totalTextPanel);
        this.masterBox.add(this.totalPanel);
        if (this.isSimple()) {
            this.timeField = new JLabel("0");
            this.timePanel.add(this.timeField);
            this.masterBox.add(this.timePanel);
        }
        if (this.isSimple()) {
            SpringLayoutHelper.setupSpringGrid(this.masterBox, 5);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.masterBox, 4);
        }
        this.MasterPanel.add(this.masterBox);
        if (this.isSimple()) {
            for (int type = 1; type <= 6; ++type) {
                this.setCost(type);
            }
            this.setTotalCost();
        }
    }

    public void setRepair() {
        int tech = 0;
        int roll = 0;
        if (this.isSalvage()) {
            ((JComboBox)this.techBox.getComponent(1)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGEARMORTECH")));
            ((JComboBox)this.techBox.getComponent(2)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGEINTERNALTECH")));
            ((JComboBox)this.techBox.getComponent(5)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGESYSTEMSTECH")));
            ((JComboBox)this.techBox.getComponent(6)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGEENGINESTECH")));
            ((JComboBox)this.techBox.getComponent(3)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGEWEAPONSTECH")));
            ((JComboBox)this.techBox.getComponent(4)).setSelectedIndex(Integer.parseInt(this.mwclient.getConfigParam("SALVAGEEQUIPMENTTECH")));
            this.setArmorCost();
            this.setInternalCost();
            this.setSystemCost();
            this.setEngineCost();
            this.setWeaponCost();
            this.setEquipmentCost();
            this.setTotalCost();
            return;
        }
        if (UnitUtils.hasArmorDamage(this.unit)) {
            ((JCheckBox)this.repairBox.getComponent(1)).setSelected(true);
            tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIRARMORTECH"));
            roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIRARMORROLL"));
            ((JComboBox)this.techBox.getComponent(1)).setSelectedIndex(tech);
            ((JSpinner)this.rollBox.getComponent(1)).setValue(roll);
            this.setArmorCost();
        }
        if (UnitUtils.hasISDamage(this.unit)) {
            ((JCheckBox)this.repairBox.getComponent(2)).setSelected(true);
            tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIRINTERNALTECH"));
            roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIRINTERNALROLL"));
            ((JComboBox)this.techBox.getComponent(2)).setSelectedIndex(tech);
            ((JSpinner)this.rollBox.getComponent(2)).setValue(roll);
            this.setInternalCost();
        }
        if (UnitUtils.hasCriticalDamage(this.unit)) {
            for (int location = 0; location < this.unit.locations(); ++location) {
                for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                    CriticalSlot cs = this.unit.getCritical(location, slot);
                    if (cs == null || !cs.isBreached() && !cs.isDamaged()) continue;
                    if (cs.getType() == 1) {
                        Mounted mounted = this.unit.getEquipment(cs.getIndex());
                        if (!mounted.isDestroyed() && !mounted.isMissing()) continue;
                        if (mounted.getType() instanceof WeaponType) {
                            ((JCheckBox)this.repairBox.getComponent(3)).setSelected(true);
                            tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIRWEAPONSTECH"));
                            roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIRWEAPONSROLL"));
                            ((JComboBox)this.techBox.getComponent(3)).setSelectedIndex(tech);
                            ((JSpinner)this.rollBox.getComponent(3)).setValue(roll);
                            this.setWeaponCost();
                            continue;
                        }
                        if (mounted.getType() instanceof WeaponType) continue;
                        ((JCheckBox)this.repairBox.getComponent(4)).setSelected(true);
                        tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIREQUIPMENTTECH"));
                        roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIREQUIPMENTROLL"));
                        ((JComboBox)this.techBox.getComponent(4)).setSelectedIndex(tech);
                        ((JSpinner)this.rollBox.getComponent(4)).setValue(roll);
                        this.setEquipmentCost();
                        continue;
                    }
                    if (cs.getType() == 0 && cs.getIndex() != 3) {
                        ((JCheckBox)this.repairBox.getComponent(5)).setSelected(true);
                        tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIRSYSTEMSTECH"));
                        roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIRSYSTEMSROLL"));
                        ((JComboBox)this.techBox.getComponent(5)).setSelectedIndex(tech);
                        ((JSpinner)this.rollBox.getComponent(5)).setValue(roll);
                        this.setSystemCost();
                        continue;
                    }
                    if (!UnitUtils.isEngineCrit(cs)) continue;
                    ((JCheckBox)this.repairBox.getComponent(6)).setSelected(true);
                    tech = Integer.parseInt(this.mwclient.getConfigParam("REPAIRENGINESTECH"));
                    roll = Integer.parseInt(this.mwclient.getConfigParam("REPAIRENGINESROLL"));
                    ((JComboBox)this.techBox.getComponent(6)).setSelectedIndex(tech);
                    ((JSpinner)this.rollBox.getComponent(6)).setValue(roll);
                    this.setEngineCost();
                }
            }
        }
        this.setTotalCost();
    }

    public void setCost(int repairType) {
        if (repairType == 1) {
            this.setArmorCost();
            return;
        }
        if (repairType == 2) {
            this.setInternalCost();
            return;
        }
        if (repairType == 5) {
            this.setSystemCost();
            return;
        }
        if (repairType == 6) {
            this.setEngineCost();
            return;
        }
        if (repairType == 3) {
            this.setWeaponCost();
            return;
        }
        if (repairType == 4) {
            this.setEquipmentCost();
            return;
        }
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 27) {
            super.dispose();
        }
    }

    public void stateChanged(ChangeEvent arg0) {
        int location = 1;
        location = Integer.parseInt(((JSpinner)arg0.getSource()).getName());
        if (((JCheckBox)this.repairBox.getComponent(location)).isSelected()) {
            this.setCost(location);
            this.setTotalCost();
        }
    }

    private void checkArmor() {
        if (!((JCheckBox)this.repairBox.getComponent(1)).isSelected()) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(1)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(1)).getValue().toString();
        if (this.isBulk() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIRARMORTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIRARMORROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGEARMORTECH", Integer.toString(techType));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            String workOrder;
            if (this.isSalvage()) {
                if (this.unit.getArmor(location) > 0) {
                    workOrder = this.unit.getExternalId() + "#" + location + "#" + 13;
                    this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                }
                if (!this.unit.hasRearArmor(location) || this.unit.getArmor(location, true) <= 0) continue;
                workOrder = this.unit.getExternalId() + "#" + location + "#" + 14;
                this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                continue;
            }
            if (this.unit.getArmor(location) < this.unit.getOArmor(location)) {
                workOrder = this.unit.getExternalId() + "#" + location + "#" + 13 + "#" + baseRoll + "#999";
                this.mwclient.getRMT().addWorkOrder(techType, workOrder);
            }
            if (!this.unit.hasRearArmor(location) || this.unit.getArmor(location, true) >= this.unit.getOArmor(location, true)) continue;
            workOrder = this.unit.getExternalId() + "#" + (location + 7) + "#" + 14 + "#" + baseRoll + "#999";
            this.mwclient.getRMT().addWorkOrder(techType, workOrder);
        }
    }

    private void checkInternal() {
        if (!((JCheckBox)this.repairBox.getComponent(2)).isSelected()) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(2)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(2)).getValue().toString();
        if (this.isBulk() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIRINTERNALTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIRINTERNALROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGEINTERNALTECH", Integer.toString(techType));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            String workOrder;
            if (this.isSalvage()) {
                if (this.unit.getInternal(location) <= 0) continue;
                workOrder = this.unit.getExternalId() + "#" + location + "#" + 15 + "#";
                this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                continue;
            }
            if (this.unit.getInternal(location) >= this.unit.getOInternal(location)) continue;
            workOrder = this.unit.getExternalId() + "#" + location + "#" + 15 + "#" + baseRoll + "#999";
            this.mwclient.getRMT().addWorkOrder(techType, workOrder);
        }
    }

    private void checkEngines() {
        if (!((JCheckBox)this.repairBox.getComponent(6)).isSelected()) {
            return;
        }
        if (!this.isSalvage() && UnitUtils.getNumberOfDamagedEngineCrits(this.unit) < 1) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(6)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(6)).getValue().toString();
        if (this.isBulk() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIRENGINESTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIRENGINESROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGEENGINESTECH", Integer.toString(techType));
        }
        for (int location = 1; location <= 3; ++location) {
            for (int slot = 0; slot < this.unit.locations(); ++slot) {
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || !UnitUtils.isEngineCrit(cs)) continue;
                if (this.isSalvage()) {
                    if (cs.isDamaged()) continue;
                    String workOrder = this.unit.getExternalId() + "#" + location + "#" + slot;
                    this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                    return;
                }
                if (!cs.isDamaged() && !cs.isBreached()) continue;
                String workOrder = this.unit.getExternalId() + "#" + location + "#" + slot + "#" + baseRoll + "#999";
                this.mwclient.getRMT().addWorkOrder(techType, workOrder);
                return;
            }
        }
    }

    private void checkSystems() {
        if (!((JCheckBox)this.repairBox.getComponent(5)).isSelected()) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(5)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(5)).getValue().toString();
        if (!this.isSalvage() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIRSYSTEMSTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIRSYSTEMSROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGESYSTEMSTECH", Integer.toString(techType));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                String workOrder;
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || UnitUtils.isNonRepairableCrit(this.unit, cs)) continue;
                if (this.isSalvage()) {
                    if (cs.isDamaged() || cs.getType() != 0 || cs.getIndex() == 3) continue;
                    workOrder = this.unit.getExternalId() + "#" + location + "#" + slot;
                    this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                    slot += UnitUtils.getNumberOfCrits(this.unit, cs) - 1;
                    continue;
                }
                if (!cs.isBreached() && !cs.isDamaged() || cs.getType() != 0 || cs.getIndex() == 3) continue;
                workOrder = this.unit.getExternalId() + "#" + location + "#" + slot + "#" + baseRoll + "#999";
                this.mwclient.getRMT().addWorkOrder(techType, workOrder);
                slot += UnitUtils.getNumberOfCrits(this.unit, cs) - 1;
            }
        }
    }

    private void checkWeapons() {
        if (!((JCheckBox)this.repairBox.getComponent(3)).isSelected()) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(3)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(3)).getValue().toString();
        if (!this.isSalvage() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIRWEAPONSTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIRWEAPONSROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGEWEAPONSTECH", Integer.toString(techType));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            Mounted lastWeapon = null;
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                String workOrder;
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || UnitUtils.isNonRepairableCrit(this.unit, cs) || !this.isSalvage() && !cs.isBreached() && !cs.isDamaged() || cs.getType() != 1) continue;
                Mounted mounted = this.unit.getEquipment(cs.getIndex());
                if (this.isSalvage()) {
                    if (!(mounted.getType() instanceof WeaponType) || mounted.isDestroyed() || mounted.isMissing() || mounted.equals(lastWeapon)) continue;
                    lastWeapon = mounted;
                    workOrder = this.unit.getExternalId() + "#" + location + "#" + slot;
                    this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                    continue;
                }
                if (!(mounted.getType() instanceof WeaponType) || !mounted.isDestroyed() && !mounted.isMissing() || mounted.equals(lastWeapon)) continue;
                lastWeapon = mounted;
                workOrder = this.unit.getExternalId() + "#" + location + "#" + slot + "#" + baseRoll + "#999";
                this.mwclient.getRMT().addWorkOrder(techType, workOrder);
            }
        }
    }

    private void checkEquipment() {
        if (!((JCheckBox)this.repairBox.getComponent(4)).isSelected()) {
            return;
        }
        int techType = ((JComboBox)this.techBox.getComponent(4)).getSelectedIndex();
        String baseRoll = ((JSpinner)this.rollBox.getComponent(4)).getValue().toString();
        if (this.isBulk() && techType != 4) {
            this.mwclient.getConfig().setParam("REPAIREQUIPMENTTECH", Integer.toString(techType));
            this.mwclient.getConfig().setParam("REPAIREQUIPMENTROLL", baseRoll);
        } else if (this.isSalvage()) {
            this.mwclient.getConfig().setParam("SALVAGEEQUIPMENTTECH", Integer.toString(techType));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            Mounted lastEq = null;
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                String workOrder;
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || UnitUtils.isNonRepairableCrit(this.unit, cs) || !this.isSalvage() && !cs.isBreached() && !cs.isDamaged() || cs.getType() != 1) continue;
                Mounted mounted = this.unit.getEquipment(cs.getIndex());
                if (this.isSalvage()) {
                    if (mounted.getType() instanceof WeaponType || mounted.isDestroyed() || mounted.isMissing() || mounted.equals(lastEq)) continue;
                    lastEq = mounted;
                    workOrder = this.unit.getExternalId() + "#" + location + "#" + slot;
                    this.mwclient.getSMT().addWorkOrder(techType, workOrder);
                    continue;
                }
                if (mounted.getType() instanceof WeaponType || !mounted.isDestroyed() && !mounted.isMissing() || mounted.equals(lastEq)) continue;
                lastEq = mounted;
                workOrder = this.unit.getExternalId() + "#" + location + "#" + slot + "#" + baseRoll + "#999";
                this.mwclient.getRMT().addWorkOrder(techType, workOrder);
            }
        }
    }

    private void setArmorCost() {
        int techType = ((JComboBox)this.techBox.getComponent(1)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(1)).getValue().toString());
        double pointsToRepair = 0.0;
        double armorCost = CUnit.getArmorCost(this.unit, this.mwclient);
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean clear = true;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(1)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
            techWorkMod = UnitUtils.getTechRoll(this.unit, 0, 13, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
        } else {
            techType = this.playerUnit.getPilot().getSkills().getPilotSkill(2).getLevel();
        }
        techWorkMod = Math.max(techWorkMod, 0.0);
        for (int location = 0; location < this.unit.locations(); ++location) {
            if (this.isSalvage()) {
                if (this.unit.getArmor(location) > 0) {
                    cost += techCost;
                    this.setWorkHours(1, location, 0, true, clear);
                    clear = false;
                }
                if (!this.unit.hasRearArmor(location) || this.unit.getArmor(location, true) <= 0) continue;
                cost += techCost;
                this.setWorkHours(1, location, 0, true, clear);
                clear = false;
                continue;
            }
            if (this.unit.getArmor(location) < this.unit.getOArmor(location)) {
                cost += armorCost * (pointsToRepair += (double)(this.unit.getOArmor(location) - this.unit.getArmor(location)));
                cost += techCost * Math.abs(techWorkMod);
                cost += techCost;
                this.setWorkHours(1, location, 0, true, clear);
                clear = false;
            }
            if (!this.unit.hasRearArmor(location)) continue;
            cost += armorCost * (pointsToRepair += (double)(this.unit.getOArmor(location, true) - this.unit.getArmor(location, true)));
            cost += techCost * Math.abs(techWorkMod);
            cost += techCost;
            this.setWorkHours(1, location, 0, true, clear);
            clear = false;
        }
        if (!this.isSalvage()) {
            cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        }
        cost = Math.max(0.0, cost);
        ((JLabel)this.costBox.getComponent(1)).setText(Integer.toString((int)cost));
    }

    private void setInternalCost() {
        int techType = ((JComboBox)this.techBox.getComponent(2)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(2)).getValue().toString());
        double pointsToRepair = 0.0;
        double armorCost = CUnit.getStructureCost(this.unit, this.mwclient);
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean clear = true;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(2)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            if (this.isSalvage() && this.unit.getInternal(location) > 0) {
                cost += techCost;
                this.setWorkHours(2, location, 15, true, clear);
                clear = false;
                continue;
            }
            if (this.unit.getInternal(location) >= this.unit.getOInternal(location)) continue;
            if (techType != 4) {
                techWorkMod = UnitUtils.getTechRoll(this.unit, location, 15, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
            }
            techWorkMod = Math.max(techWorkMod, 0.0);
            pointsToRepair = this.unit.getOInternal(location) - this.unit.getInternal(location);
            cost += armorCost * pointsToRepair;
            cost += techCost * Math.abs(techWorkMod);
            cost += techCost;
            this.setWorkHours(2, location, 15, true, clear);
            clear = false;
        }
        if (!this.isSalvage()) {
            cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        }
        cost = Math.max(0.0, cost);
        ((JLabel)this.costBox.getComponent(2)).setText(Integer.toString((int)cost));
    }

    private void setSystemCost() {
        int techType = ((JComboBox)this.techBox.getComponent(5)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(5)).getValue().toString());
        double pointsToRepair = 0.0;
        double critCost = 0.0;
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean clear = true;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(5)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || UnitUtils.isNonRepairableCrit(this.unit, cs)) continue;
                if (this.isSalvage()) {
                    if (cs.isDamaged() || cs.getType() != 0 || cs.getIndex() == 3) continue;
                    int crits = UnitUtils.getNumberOfCrits(this.unit, cs) - UnitUtils.getNumberOfDamagedCrits(this.unit, slot, location, false);
                    cost += techCost * (double)crits;
                    cost += techCost;
                    slot += UnitUtils.getNumberOfCrits(this.unit, cs) - 1;
                    clear = false;
                    continue;
                }
                if (!cs.isBreached() && !cs.isDamaged() || cs.getType() != 0 || cs.getIndex() == 3) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(this.unit, location, slot, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
                }
                critCost = CUnit.getCritCost(this.unit, this.mwclient, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(this.unit, cs);
                cost += (critCost += techCost) * pointsToRepair;
                cost += techCost * Math.abs(techWorkMod);
                cost += techCost;
                this.setWorkHours(5, location, slot, false, clear);
                clear = false;
                slot = (int)((double)slot + (pointsToRepair - 1.0));
            }
        }
        if (!this.isSalvage()) {
            cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        }
        cost = Math.max(0.0, cost);
        ((JLabel)this.costBox.getComponent(5)).setText(Integer.toString((int)cost));
    }

    private void setWeaponCost() {
        int techType = ((JComboBox)this.techBox.getComponent(3)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(3)).getValue().toString());
        double pointsToRepair = 0.0;
        double critCost = 0.0;
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean clear = true;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(3)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        Mounted lastWeapon = null;
        for (int location = 0; location < this.unit.locations(); ++location) {
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                Mounted mounted;
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null) continue;
                if (this.isSalvage()) {
                    if (cs.isDamaged() || cs.getType() != 1 || !((mounted = this.unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType) || mounted.equals(lastWeapon)) continue;
                    int crits = UnitUtils.getNumberOfCrits(this.unit, cs) - UnitUtils.getNumberOfDamagedCrits(this.unit, slot, location, false);
                    cost += techCost * (double)crits;
                    if (crits > 0) {
                        cost += techCost;
                    }
                    clear = false;
                    lastWeapon = mounted;
                    continue;
                }
                if (!cs.isBreached() && !cs.isDamaged() || cs.getType() != 1 || !((mounted = this.unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType) || mounted.equals(lastWeapon)) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(this.unit, location, slot, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
                }
                critCost = CUnit.getCritCost(this.unit, this.mwclient, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(this.unit, cs);
                cost += (critCost += techCost) * pointsToRepair;
                cost += techCost * Math.abs(techWorkMod);
                cost += techCost;
                this.setWorkHours(3, location, slot, false, clear);
                lastWeapon = mounted;
                clear = false;
            }
        }
        if (!this.isSalvage()) {
            cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        }
        cost = Math.max(0.0, cost);
        ((JLabel)this.costBox.getComponent(3)).setText(Integer.toString((int)cost));
    }

    private void setEquipmentCost() {
        int techType = ((JComboBox)this.techBox.getComponent(4)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(4)).getValue().toString());
        double pointsToRepair = 0.0;
        double critCost = 0.0;
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean clear = true;
        Mounted lastEq = null;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(4)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (int location = 0; location < this.unit.locations(); ++location) {
            for (int slot = 0; slot < this.unit.getNumberOfCriticals(location); ++slot) {
                Mounted mounted;
                CriticalSlot cs = this.unit.getCritical(location, slot);
                if (cs == null || UnitUtils.isNonRepairableCrit(this.unit, cs)) continue;
                if (this.isSalvage()) {
                    if (cs.isDamaged() || cs.getType() != 1 || (mounted = this.unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType || mounted.equals(lastEq)) continue;
                    int crits = UnitUtils.getNumberOfCrits(this.unit, cs) - UnitUtils.getNumberOfDamagedCrits(this.unit, slot, location, false);
                    cost += techCost * (double)crits;
                    cost += techCost;
                    clear = false;
                    lastEq = mounted;
                    continue;
                }
                if (!cs.isBreached() && !cs.isDamaged() || cs.getType() != 1 || (mounted = this.unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType || mounted.equals(lastEq)) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(this.unit, location, slot, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
                }
                critCost = CUnit.getCritCost(this.unit, this.mwclient, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(this.unit, cs);
                cost += (critCost += techCost) * pointsToRepair;
                cost += techCost * Math.abs(techWorkMod);
                cost += techCost;
                this.setWorkHours(4, location, slot, false, clear);
                clear = false;
                lastEq = mounted;
            }
        }
        if (!this.isSalvage()) {
            cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        }
        cost = Math.max(0.0, cost);
        ((JLabel)this.costBox.getComponent(4)).setText(Integer.toString((int)cost));
    }

    private void setEngineCost() {
        int techType = ((JComboBox)this.techBox.getComponent(6)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(6)).getValue().toString());
        double pointsToRepair = 0.0;
        double critCost = 0.0;
        double techCost = 0.0;
        double techWorkMod = 0.0;
        double cost = 0.0;
        boolean found = false;
        int location = 0;
        int slot = 0;
        CriticalSlot cs = null;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            ((JLabel)this.costBox.getComponent(6)).setText("?????");
            return;
        }
        if (techType != 4) {
            techCost = Integer.parseInt(this.mwclient.getserverConfigs(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        block0: for (int x = 1; x <= 3; ++x) {
            for (int y = 0; y < this.unit.getNumberOfCriticals(x); ++y) {
                cs = this.unit.getCritical(x, y);
                if (cs == null || !UnitUtils.isEngineCrit(cs)) continue;
                if (this.isSalvage()) {
                    int totalCrits = UnitUtils.getNumberOfEngineCrits(this.unit) - UnitUtils.getNumberOfDamagedEngineCrits(this.unit);
                    int totalCost = (int)((double)totalCrits * techCost);
                    if (totalCrits > 0) {
                        totalCost = (int)((double)totalCost + techCost);
                    }
                    cost = Math.max(0, totalCost);
                    ((JLabel)this.costBox.getComponent(6)).setText(Integer.toString((int)cost));
                    return;
                }
                if (!cs.isDamaged() && !cs.isBreached()) continue;
                location = x;
                slot = y;
                found = true;
                break block0;
            }
        }
        if (techType != 4) {
            techWorkMod = UnitUtils.getTechRoll(this.unit, location, slot, techType, true, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
        }
        critCost = CUnit.getCritCost(this.unit, this.mwclient, cs);
        techWorkMod = Math.max(techWorkMod, 0.0);
        pointsToRepair = UnitUtils.getNumberOfCrits(this.unit, cs);
        cost += (critCost += techCost) * pointsToRepair;
        cost += techCost * Math.abs(techWorkMod);
        cost += techCost;
        cost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        cost = Math.max(0.0, cost);
        if (!found) {
            cost = 0.0;
        }
        if (this.isSimple()) {
            ((JLabel)this.timeBox.getComponent(6)).setText("0");
            this.setWorkHours(6, 1, 0, false, true);
        }
        ((JLabel)this.costBox.getComponent(6)).setText(Integer.toString((int)cost));
    }

    private double payOutIncreaseBasedOnRoll(int roll) {
        if (roll <= 2) {
            return 1.0;
        }
        if (roll > 12) {
            return 36.0;
        }
        double[] payout = new double[]{1.0, 1.0, 1.0, 1.03, 1.09, 1.2, 1.38, 1.72, 2.4, 3.6, 5.92, 12.0, 36.0};
        return payout[roll];
    }

    private void setWorkHours(int type, int critLocation, int critSlot, boolean armor, boolean clear) {
        int techType = ((JComboBox)this.techBox.getComponent(type)).getSelectedIndex();
        int baseRoll = Integer.parseInt(((JSpinner)this.rollBox.getComponent(type)).getValue().toString());
        if (critLocation < 0 || critSlot < 0) {
            return;
        }
        int baseLine = Integer.parseInt(this.mwclient.getserverConfigs("TimeForEachRepairPoint"));
        if (!armor) {
            CriticalSlot cs = this.unit.getCritical(critLocation, critSlot);
            int totalCrits = UnitUtils.getNumberOfCrits(this.unit, cs);
            baseLine *= totalCrits;
        }
        int rolls = UnitUtils.getTechRoll(this.unit, critLocation, critSlot, techType, armor, this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse()).getTechLevel()) - baseRoll;
        for (int count = 0; count < rolls; ++count) {
            baseLine *= 2;
        }
        baseLine = (int)((double)baseLine * this.payOutIncreaseBasedOnRoll(baseRoll));
        JLabel textField = (JLabel)this.timeBox.getComponent(type);
        if (!clear) {
            baseLine += Integer.parseInt(textField.getText());
        }
        textField.setText(Integer.toString(baseLine));
    }

    private void setTotalCost() {
        int cost = 0;
        int seconds = 0;
        int minutes = 0;
        int hours = 0;
        if (this.unitRepairType == UNIT_TYPE_ALL) {
            if (this.isSimple()) {
                ((JLabel)this.timePanel.getComponent(0)).setText("?????");
            }
            ((JLabel)this.totalPanel.getComponent(0)).setText("?????");
            return;
        }
        for (int x = 1; x <= 6; ++x) {
            cost += Integer.parseInt(((JLabel)this.costBox.getComponent(x)).getText());
            if (!this.isSimple()) continue;
            seconds += Integer.parseInt(((JLabel)this.timeBox.getComponent(x)).getText());
        }
        if (this.isSimple()) {
            if (seconds > 3600) {
                hours = seconds / 3600;
                seconds %= 3600;
            }
            if (seconds > 60) {
                minutes = seconds / 60;
                seconds %= 60;
            }
            StringBuilder text = new StringBuilder();
            StringBuilder toolTip = new StringBuilder();
            if (hours > 0) {
                text.append(hours + "h ");
                toolTip.append(hours + " hours ");
            }
            if (minutes > 0) {
                text.append(minutes + "m ");
                toolTip.append(minutes + " minutes ");
            }
            text.append(seconds + "s");
            toolTip.append(seconds + " seconds");
            ((JLabel)this.timePanel.getComponent(0)).setText(text.toString());
            ((JLabel)this.timePanel.getComponent(0)).setToolTipText(toolTip.toString());
        }
        ((JLabel)this.totalPanel.getComponent(0)).setText(Integer.toString(cost));
    }

    private boolean isSimple() {
        return this.repairType == TYPE_SIMPLE;
    }

    private boolean isBulk() {
        return this.repairType == TYPE_BULK;
    }

    private boolean isSalvage() {
        return this.repairType == TYPE_SALVAGE;
    }
}

