/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.MechInfo;
import common.CampaignData;
import common.util.UnitUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.common.Entity;

public class CamoSelectionDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 491308053668750747L;
    private TreeMap<String, Object> camos;
    private JList camoList;
    private DefaultListModel listModel;
    private MechInfo oldCamo;
    private MechInfo newCamo;
    private JScrollPane scrollPane;
    private Entity oldEntity;
    private Entity newEntity;
    private String originalCamo = "";
    private MWClient mwclient;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";

    public CamoSelectionDialog(JFrame parent, MWClient mwclient) {
        super(parent, "Select Camo Pattern", true);
        this.mwclient = mwclient;
        this.originalCamo = mwclient.getConfigParam("UNITCAMO");
        try {
            CUnit toShow = null;
            int hangarSize = mwclient.getPlayer().getHangar().size();
            if (hangarSize > 0) {
                Random r = new Random();
                toShow = mwclient.getPlayer().getHangar().get(r.nextInt(hangarSize));
            }
            if (toShow != null) {
                this.oldEntity = toShow.getEntity();
                this.newEntity = toShow.getEntity();
            } else {
                this.oldEntity = UnitUtils.createOMG();
                this.newEntity = UnitUtils.createOMG();
            }
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
            this.dispose();
            return;
        }
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.listModel = new DefaultListModel();
        this.listModel.addElement("NO CAMO");
        this.camos = new TreeMap();
        File camoDirectory = new File("./data/images/camo");
        Object[] camoNames = camoDirectory.list();
        Arrays.sort(camoNames);
        for (int i = 0; i < camoNames.length; ++i) {
            Object currCamoName = camoNames[i];
            String ext = "";
            int offset = ((String)currCamoName).lastIndexOf(46);
            if (offset > 0 && offset < ((String)currCamoName).length() - 1) {
                ext = ((String)currCamoName).substring(offset + 1).toLowerCase();
            }
            if (!ext.equals("png") && !ext.equals("jpeg") && !ext.equals("jpg") && !ext.equals("gif")) continue;
            this.camos.put((String)currCamoName, "filler");
            this.listModel.addElement(currCamoName);
        }
        JPanel oldPanel = new JPanel();
        oldPanel.setLayout(new BoxLayout(oldPanel, 1));
        JLabel oldHeader = new JLabel("Old Camo", 0);
        oldHeader.setAlignmentX(0.5f);
        oldPanel.add(oldHeader);
        String oldCamoName = mwclient.getConfig().getParam("UNITCAMO");
        Image oldCamoImage = Toolkit.getDefaultToolkit().getImage("./data/images/camo/" + oldCamoName);
        oldCamoImage.getScaledInstance(84, 72, 2);
        this.camos.remove(oldCamoName);
        ImageIcon oldCamoIcon = new ImageIcon(oldCamoImage);
        this.camos.put(oldCamoName, oldCamoIcon);
        this.oldCamo = new MechInfo(oldCamoIcon);
        this.oldCamo.setUnit(this.oldEntity);
        this.oldCamo.setMinimumSize(new Dimension(84, 72));
        oldPanel.add(this.oldCamo);
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        JLabel newHeader = new JLabel("New Camo", 0);
        newHeader.setAlignmentX(0.5f);
        newPanel.add(newHeader);
        this.newCamo = new MechInfo(new ImageIcon());
        this.newCamo.setUnit(this.newEntity);
        this.newCamo.setMinimumSize(new Dimension(84, 72));
        newPanel.add(this.newCamo);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 1));
        iconPanel.add(oldPanel);
        iconPanel.add(new JLabel("\n "));
        iconPanel.add(new JLabel("\n "));
        iconPanel.add(newPanel);
        this.camoList = new JList(this.listModel);
        this.camoList.setSelectionMode(0);
        this.camoList.setLayoutOrientation(0);
        this.camoList.setVisibleRowCount(-1);
        this.scrollPane = new JScrollPane(this.camoList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setPreferredSize(new Dimension(280, 425));
        ListSelectionModel listSelectionModel = this.camoList.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.camoList.setSelectedValue(oldCamoName, true);
        this.getRootPane().setDefaultButton(this.okayButton);
        JPanel listandIconFlow = new JPanel();
        listandIconFlow.add(this.scrollPane);
        listandIconFlow.add(iconPanel);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(listandIconFlow);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        String currCamo = (String)this.camoList.getSelectedValue();
        if (command.equals("Okay") && !currCamo.equals(this.originalCamo)) {
            this.mwclient.getConfig().setParam("UNITCAMO", currCamo);
            this.mwclient.getConfig().saveConfig();
            this.mwclient.setConfig();
            this.mwclient.getConfig().loadImage("data/images/camo/" + currCamo, "CAMO", 84, 72);
            this.mwclient.getMainFrame().getMainPanel().selectFirstTab();
            this.mwclient.getMainFrame().getMainPanel().getHQPanel().reinitialize();
        }
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            if (this.camoList.getSelectedIndex() == 0) {
                this.newCamo.setPreviewIcon(null);
                this.newCamo.setUnit(this.newEntity);
            } else {
                String currSelection = (String)this.camoList.getSelectedValue();
                ImageIcon currCamoIcon = null;
                if (this.camos.get(currSelection).equals("filler")) {
                    Image currCamo = Toolkit.getDefaultToolkit().getImage("./data/images/camo/" + currSelection);
                    currCamo.getScaledInstance(84, 72, 2);
                    this.camos.remove(currSelection);
                    currCamoIcon = new ImageIcon(currCamo);
                    this.camos.put(currSelection, currCamoIcon);
                } else {
                    currCamoIcon = (ImageIcon)this.camos.get(currSelection);
                }
                this.newCamo.setPreviewIcon(currCamoIcon);
                this.newCamo.setUnit(this.newEntity);
            }
            this.newCamo.repaint();
        }
    }
}

