/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import common.BMEquipment;
import common.util.ComponentToCritsConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class ComponentConverterDialog
implements ActionListener {
    private static final String okayCommand = "okay";
    private static final String cancelCommand = "cancel";
    private static final String selectorButtonCommand = "selectorbuttoncommand";
    private static final String windowName = "Component Crit Converter";
    protected JPanel mainPanel = new JPanel();
    protected JPanel critPanel = new JPanel();
    protected JScrollPane scrollPane = new JScrollPane();
    private JTextField baseTextField = new JTextField(5);
    String[] units = new String[]{CUnit.getTypeClassDesc(0), CUnit.getTypeClassDesc(1), CUnit.getTypeClassDesc(2), CUnit.getTypeClassDesc(3), CUnit.getTypeClassDesc(4), CUnit.getTypeClassDesc(5)};
    String[] weight = new String[]{CUnit.getWeightClassDesc(0), CUnit.getWeightClassDesc(1), CUnit.getWeightClassDesc(2), CUnit.getWeightClassDesc(3)};
    protected JComboBox weightCombo;
    protected JComboBox typeCombo;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JButton modeButton = new JButton("Basic");
    private boolean isAdvanced = false;
    private int basicWeight = 0;
    private int basicType = 0;
    private int basicAmount = 100;
    private JDialog dialog;
    private JOptionPane pane;
    MWClient mwclient = null;

    public ComponentConverterDialog(MWClient mwclient) {
        this.mwclient = mwclient;
        this.scrollPane.add(this.mainPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.mainPanel);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.okayButton.setActionCommand(okayCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(cancelCommand);
        this.modeButton.addActionListener(this);
        this.modeButton.setActionCommand(selectorButtonCommand);
        Object[] options = new Object[]{this.okayButton, this.cancelButton, this.modeButton};
        this.pane = new JOptionPane(this.scrollPane, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(this.scrollPane, windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.isAdvanced = !mwclient.getCampaign().getComponentConverter().containsKey("All");
        this.dialog.setLocationRelativeTo(mwclient.getMainFrame());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.refresh();
        this.dialog.setVisible(true);
        if (this.pane.getValue() == this.okayButton) {
            for (int pos = this.mainPanel.getComponentCount() - 1; pos >= 0; --pos) {
                JPanel panel = (JPanel)this.mainPanel.getComponent(pos);
                this.findAndSaveConfigs(panel);
            }
            mwclient.sendChat("/c getcomponentconversion");
        } else {
            this.dialog.dispose();
        }
    }

    public void findAndSaveConfigs(JPanel panel) {
        String crit = null;
        String amount = null;
        int weight = 0;
        int type = 0;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndSaveConfigs((JPanel)field);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                if (textBox.getName().equals("amount")) {
                    amount = textBox.getText();
                    continue;
                }
                crit = textBox.getName();
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)field;
            if (combo.getName().equals("weight")) {
                weight = combo.getSelectedIndex();
                continue;
            }
            type = combo.getSelectedIndex();
        }
        ComponentToCritsConverter converter = this.mwclient.getCampaign().getComponentConverter().get(crit);
        if (converter == null || converter.getComponentUsedType() != type || converter.getComponentUsedWeight() != weight || converter.getMinCritLevel() != Integer.parseInt(amount)) {
            this.mwclient.sendChat("/c Setcomponentconversion#" + crit + "#" + weight + "#" + type + "#" + amount);
        }
    }

    public void findAndBasicConfigs(JPanel panel) {
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndBasicConfigs((JPanel)field);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                if (!textBox.getName().equals("amount")) continue;
                this.basicAmount = Integer.parseInt(textBox.getText());
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)field;
            if (combo.getName().equals("weight")) {
                this.basicWeight = combo.getSelectedIndex();
                continue;
            }
            this.basicType = combo.getSelectedIndex();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else if (command.equals(selectorButtonCommand)) {
            this.refresh();
        }
    }

    public void refresh() {
        if (!this.isAdvanced) {
            this.mainPanel.removeAll();
            this.scrollPane.setSize(300, 40);
            this.scrollPane.setPreferredSize(this.scrollPane.getSize());
            this.scrollPane.setMinimumSize(this.scrollPane.getSize());
            this.dialog.setSize(400, 140);
            this.dialog.setPreferredSize(this.dialog.getSize());
            this.dialog.setMinimumSize(this.dialog.getSize());
            ComponentToCritsConverter converter = this.mwclient.getCampaign().getComponentConverter().get("All");
            if (converter == null) {
                converter = new ComponentToCritsConverter();
                converter.setCritName("All");
                converter.setComponentUsedType(0);
                converter.setComponentUsedWeight(0);
                converter.setMinCritLevel(100);
            }
            this.critPanel = new JPanel();
            this.baseTextField = new JTextField(5);
            this.baseTextField.setEditable(false);
            this.baseTextField.setName(converter.getCritName());
            this.baseTextField.setText(converter.getCritName());
            this.critPanel.add(this.baseTextField);
            this.weightCombo = new JComboBox<String>(this.weight);
            this.weightCombo.setName("weight");
            this.weightCombo.setSelectedIndex(converter.getComponentUsedWeight());
            this.critPanel.add(this.weightCombo);
            this.typeCombo = new JComboBox<String>(this.units);
            this.typeCombo.setName("type");
            this.typeCombo.setSelectedIndex(converter.getComponentUsedType());
            this.critPanel.add(this.typeCombo);
            this.baseTextField = new JTextField(5);
            this.baseTextField.setName("amount");
            this.baseTextField.setText(Integer.toString(converter.getMinCritLevel()));
            this.critPanel.add(this.baseTextField);
            this.mainPanel.add(this.critPanel);
            this.modeButton.setText("Advanced");
            this.isAdvanced = !this.isAdvanced;
        } else {
            this.findAndBasicConfigs(this.mainPanel);
            this.mainPanel.removeAll();
            for (BMEquipment eq : this.mwclient.getCampaign().getBlackMarketParts().values()) {
                if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowCrossOverTech")) && this.mwclient.getPlayer().getHouseFightingFor().getTechLevel() != 11 && eq.getTechLevel() != 11 && this.mwclient.getPlayer().getHouseFightingFor().getTechLevel() < eq.getTechLevel() || !(eq.getCost() > 0.0)) continue;
                ComponentToCritsConverter converter = this.mwclient.getCampaign().getComponentConverter().get(eq.getEquipmentInternalName());
                if (converter == null) {
                    converter = new ComponentToCritsConverter();
                    converter.setCritName(eq.getEquipmentInternalName());
                    converter.setComponentUsedType(this.basicType);
                    converter.setComponentUsedWeight(this.basicWeight);
                    converter.setMinCritLevel(this.basicAmount);
                }
                this.critPanel = new JPanel();
                this.baseTextField = new JTextField(25);
                this.baseTextField.setEditable(false);
                this.baseTextField.setName(eq.getEquipmentInternalName());
                this.baseTextField.setText(eq.getEquipmentName());
                this.critPanel.add(this.baseTextField);
                this.weightCombo = new JComboBox<String>(this.weight);
                this.weightCombo.setName("weight");
                this.weightCombo.setSelectedIndex(converter.getComponentUsedWeight());
                this.critPanel.add(this.weightCombo);
                this.typeCombo = new JComboBox<String>(this.units);
                this.typeCombo.setSelectedIndex(converter.getComponentUsedType());
                this.typeCombo.setName("type");
                this.critPanel.add(this.typeCombo);
                this.baseTextField = new JTextField(5);
                this.baseTextField.setName("amount");
                this.baseTextField.setText(Integer.toString(converter.getMinCritLevel()));
                this.critPanel.add(this.baseTextField);
                this.mainPanel.add(this.critPanel);
            }
            this.scrollPane.setSize(400, 400);
            this.scrollPane.setPreferredSize(this.scrollPane.getSize());
            this.scrollPane.setMinimumSize(this.scrollPane.getSize());
            this.dialog.setSize(500, 500);
            this.dialog.setPreferredSize(this.dialog.getSize());
            this.dialog.setMinimumSize(this.dialog.getSize());
            this.isAdvanced = !this.isAdvanced;
            this.modeButton.setText("Basic");
        }
    }
}

